namespace Roblox.TranslationResources.Purchasing;

/// <summary>
/// This class overrides RixtyPinResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class RixtyPinResources_pt_br : RixtyPinResources_en_us, IRixtyPinResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyNow"
	/// English String: "Buy Now"
	/// </summary>
	public override string ActionBuyNow => "Comprar agora";

	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Action.MoreBCOptions"
	/// English String: "More Builders Club Options"
	/// </summary>
	public override string ActionMoreBCOptions => "Mais opções do Builders Club";

	/// <summary>
	/// Key: "Action.Redeem"
	/// English String: "Redeem"
	/// </summary>
	public override string ActionRedeem => "Utilizar";

	/// <summary>
	/// Key: "Heading.AlreadyHaveCredit"
	/// English String: "You have Roblox Credit!"
	/// </summary>
	public override string HeadingAlreadyHaveCredit => "Você tem Créditos Roblox!";

	/// <summary>
	/// Key: "Heading.BuyRobuxUsingRixty"
	/// English String: "Buy Robux using Rixty"
	/// </summary>
	public override string HeadingBuyRobuxUsingRixty => "Comprar Robux usando Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxOrBcWithRixty"
	/// English String: "Get Robux or Builders Club with Rixty"
	/// </summary>
	public override string HeadingGetRobuxOrBcWithRixty => "Obter Robux ou entrar para o Builders Club usando Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxWithRixty"
	/// English String: "Get Robux with Rixty"
	/// </summary>
	public override string HeadingGetRobuxWithRixty => "Obtenha Robux usando Rixty";

	/// <summary>
	/// Key: "Heading.HowToUse"
	/// English String: "How to Use"
	/// </summary>
	public override string HeadingHowToUse => "Como usar";

	/// <summary>
	/// Key: "Heading.PayWithRixty"
	/// English String: "Pay with Rixty"
	/// </summary>
	public override string HeadingPayWithRixty => "Pagar com Rixty";

	/// <summary>
	/// Key: "Heading.RedeemRixtyCards"
	/// English String: "Redeem Rixty Cards"
	/// </summary>
	public override string HeadingRedeemRixtyCards => "Utilizar cartões Rixty";

	/// <summary>
	/// Key: "Label.AlreadyHaveAccount"
	/// English String: "I already have a Rixty account"
	/// </summary>
	public override string LabelAlreadyHaveAccount => "Já tenho uma conta Rixty";

	/// <summary>
	/// Key: "Label.BuildersClubImage"
	/// Alternate text for Builders Club image
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClubImage => "Builders Club";

	/// <summary>
	/// Key: "Label.EnterPin"
	/// English String: "Enter PIN:"
	/// </summary>
	public override string LabelEnterPin => "Insira o PIN:";

	/// <summary>
	/// Key: "Label.EnterPinImage"
	/// English String: "Enter Your PIN"
	/// </summary>
	public override string LabelEnterPinImage => "Insira seu PIN";

	/// <summary>
	/// Key: "Label.FortyFiveDaysBC"
	/// English String: "45 Day Builders Club Extension - $10.00 (Existing BC members only)"
	/// </summary>
	public override string LabelFortyFiveDaysBC => "Prolongamento de 45 dias do Builders Club - $10,00 (só para membros do BC)";

	/// <summary>
	/// Key: "Label.InstructionForCombineCards"
	/// English String: "Combine cards for more Roblox credit."
	/// </summary>
	public override string LabelInstructionForCombineCards => "Combine cartões para obter mais créditos Roblox.";

	/// <summary>
	/// Key: "Label.InstructionForEnterPin"
	/// English String: "Enter your Rixty PIN."
	/// </summary>
	public override string LabelInstructionForEnterPin => "Insira seu PIN Rixty.";

	/// <summary>
	/// Key: "Label.OrUppercase"
	/// English String: "OR"
	/// </summary>
	public override string LabelOrUppercase => "OU";

	/// <summary>
	/// Key: "Label.PinImageText"
	/// English String: "Your PIN is on your receipt"
	/// </summary>
	public override string LabelPinImageText => "Seu PIN está no seu recibo";

	/// <summary>
	/// Key: "Label.RixtyLogo"
	/// English String: "Rixty Logo"
	/// </summary>
	public override string LabelRixtyLogo => "Logotipo Rixty";

	/// <summary>
	/// Key: "Label.Robux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.ThirtyDaysBC"
	/// English String: "30 Days of Builders Club - $10.00"
	/// </summary>
	public override string LabelThirtyDaysBC => "30 dias de Builders Club - $10,00";

	/// <summary>
	/// Key: "Label.WhySpendCredit"
	/// English String: "Spend your Roblox credit on Robux and Builders Club!"
	/// </summary>
	public override string LabelWhySpendCredit => "Gaste seus créditos Roblox com Robux e Builders Club!";

	/// <summary>
	/// Key: "Label.YourBalance"
	/// English String: "Your Balance:"
	/// </summary>
	public override string LabelYourBalance => "Seu saldo:";

	/// <summary>
	/// Key: "Message.AnErrorOccurred"
	/// English String: "An error occurred"
	/// </summary>
	public override string MessageAnErrorOccurred => "Ocorreu um erro";

	/// <summary>
	/// Key: "Message.Failure"
	/// English String: "Failure"
	/// </summary>
	public override string MessageFailure => "Falha";

	/// <summary>
	/// Key: "Message.Loading"
	/// English String: "Loading"
	/// </summary>
	public override string MessageLoading => "Carregando";

	/// <summary>
	/// Key: "Message.PinAlreadyRedeemed"
	/// English String: "PIN already redeemed"
	/// </summary>
	public override string MessagePinAlreadyRedeemed => "PIN já utilizado";

	/// <summary>
	/// Key: "Message.RixtyUnavailable"
	/// English String: "Currently unavailable. Please try again later."
	/// </summary>
	public override string MessageRixtyUnavailable => "Não disponível no momento. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "Sucesso";

	/// <summary>
	/// Key: "Message.SuccessfulRedemption"
	/// English String: "You have successfully redeemed your PIN!"
	/// </summary>
	public override string MessageSuccessfulRedemption => "Você utilizou seu PIN com sucesso!";

	public RixtyPinResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyNow()
	{
		return "Comprar agora";
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForActionMoreBCOptions()
	{
		return "Mais opções do Builders Club";
	}

	protected override string _GetTemplateForActionRedeem()
	{
		return "Utilizar";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobux"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobux(string lineBreak)
	{
		return $"Com Rixty, você pode usar dinheiro e moedas para comprar Robux e entrar para o Builders Club.{lineBreak}Não tem um cartão de crédito? Sem problema!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobux()
	{
		return "Com Rixty, você pode usar dinheiro e moedas para comprar Robux e entrar para o Builders Club.{lineBreak}Não tem um cartão de crédito? Sem problema!";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobuxAndPremium"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobuxAndPremium(string lineBreak)
	{
		return $"Com Rixty, você pode usar dinheiro e moedas para comprar Robux e entrar para o Builders Club.{lineBreak}Não tem um cartão de crédito? Sem problema!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobuxAndPremium()
	{
		return "Com Rixty, você pode usar dinheiro e moedas para comprar Robux e entrar para o Builders Club.{lineBreak}Não tem um cartão de crédito? Sem problema!";
	}

	protected override string _GetTemplateForHeadingAlreadyHaveCredit()
	{
		return "Você tem Créditos Roblox!";
	}

	protected override string _GetTemplateForHeadingBuyRobuxUsingRixty()
	{
		return "Comprar Robux usando Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxOrBcWithRixty()
	{
		return "Obter Robux ou entrar para o Builders Club usando Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxWithRixty()
	{
		return "Obtenha Robux usando Rixty";
	}

	protected override string _GetTemplateForHeadingHowToUse()
	{
		return "Como usar";
	}

	protected override string _GetTemplateForHeadingPayWithRixty()
	{
		return "Pagar com Rixty";
	}

	protected override string _GetTemplateForHeadingRedeemRixtyCards()
	{
		return "Utilizar cartões Rixty";
	}

	protected override string _GetTemplateForLabelAlreadyHaveAccount()
	{
		return "Já tenho uma conta Rixty";
	}

	/// <summary>
	/// Key: "Label.BuildersClubExtensionExisting"
	/// For example, 45 Day Builders Club Extension - $10.00 (Existing BC members only)
	/// English String: "{numberOfDays} Day Builders Club Extension - {cost} (Existing BC members only)"
	/// </summary>
	public override string LabelBuildersClubExtensionExisting(string numberOfDays, string cost)
	{
		return $"Prolongamento de {numberOfDays} dias do Builders Club - {cost} (só para membros do BC)";
	}

	protected override string _GetTemplateForLabelBuildersClubExtensionExisting()
	{
		return "Prolongamento de {numberOfDays} dias do Builders Club - {cost} (só para membros do BC)";
	}

	protected override string _GetTemplateForLabelBuildersClubImage()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubOffer"
	/// New purchase offer of builders club
	/// English String: "{numberOfDays} Days of Builders Club - {cost}"
	/// </summary>
	public override string LabelBuildersClubOffer(string numberOfDays, string cost)
	{
		return $"{numberOfDays} dias de Builders Club - {cost}";
	}

	protected override string _GetTemplateForLabelBuildersClubOffer()
	{
		return "{numberOfDays} dias de Builders Club - {cost}";
	}

	/// <summary>
	/// Key: "Label.BuyRobuxWithRixty"
	/// For example, "400 Robux for $4.95"
	/// English String: "{robuxAmount} Robux for {currencyAmount}"
	/// </summary>
	public override string LabelBuyRobuxWithRixty(string robuxAmount, string currencyAmount)
	{
		return $"{robuxAmount} Robux por {currencyAmount}";
	}

	protected override string _GetTemplateForLabelBuyRobuxWithRixty()
	{
		return "{robuxAmount} Robux por {currencyAmount}";
	}

	protected override string _GetTemplateForLabelEnterPin()
	{
		return "Insira o PIN:";
	}

	protected override string _GetTemplateForLabelEnterPinImage()
	{
		return "Insira seu PIN";
	}

	protected override string _GetTemplateForLabelFortyFiveDaysBC()
	{
		return "Prolongamento de 45 dias do Builders Club - $10,00 (só para membros do BC)";
	}

	/// <summary>
	/// Key: "Label.GetPhysicalRixtyCard"
	/// English String: "{startLink}Go to your local store{endLink} and get a Rixty Card."
	/// </summary>
	public override string LabelGetPhysicalRixtyCard(string startLink, string endLink)
	{
		return $"{startLink}Vá para sua loja local{endLink} e compre um cartão Rixty.";
	}

	protected override string _GetTemplateForLabelGetPhysicalRixtyCard()
	{
		return "{startLink}Vá para sua loja local{endLink} e compre um cartão Rixty.";
	}

	protected override string _GetTemplateForLabelInstructionForCombineCards()
	{
		return "Combine cartões para obter mais créditos Roblox.";
	}

	protected override string _GetTemplateForLabelInstructionForEnterPin()
	{
		return "Insira seu PIN Rixty.";
	}

	protected override string _GetTemplateForLabelOrUppercase()
	{
		return "OU";
	}

	protected override string _GetTemplateForLabelPinImageText()
	{
		return "Seu PIN está no seu recibo";
	}

	protected override string _GetTemplateForLabelRixtyLogo()
	{
		return "Logotipo Rixty";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelThirtyDaysBC()
	{
		return "30 dias de Builders Club - $10,00";
	}

	protected override string _GetTemplateForLabelWhySpendCredit()
	{
		return "Gaste seus créditos Roblox com Robux e Builders Club!";
	}

	protected override string _GetTemplateForLabelYourBalance()
	{
		return "Seu saldo:";
	}

	protected override string _GetTemplateForMessageAnErrorOccurred()
	{
		return "Ocorreu um erro";
	}

	protected override string _GetTemplateForMessageFailure()
	{
		return "Falha";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "Carregando";
	}

	protected override string _GetTemplateForMessagePinAlreadyRedeemed()
	{
		return "PIN já utilizado";
	}

	protected override string _GetTemplateForMessageRixtyUnavailable()
	{
		return "Não disponível no momento. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForMessageSuccessfulRedemption()
	{
		return "Você utilizou seu PIN com sucesso!";
	}
}
