namespace Roblox.TranslationResources.Purchasing;

/// <summary>
/// This class overrides RixtyPinResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class RixtyPinResources_ja_jp : RixtyPinResources_en_us, IRixtyPinResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyNow"
	/// English String: "Buy Now"
	/// </summary>
	public override string ActionBuyNow => "今すぐ買う";

	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Robuxを買う";

	/// <summary>
	/// Key: "Action.MoreBCOptions"
	/// English String: "More Builders Club Options"
	/// </summary>
	public override string ActionMoreBCOptions => "その他のBuilders Clubオプション";

	/// <summary>
	/// Key: "Action.Redeem"
	/// English String: "Redeem"
	/// </summary>
	public override string ActionRedeem => "引き換え";

	/// <summary>
	/// Key: "Heading.AlreadyHaveCredit"
	/// English String: "You have Roblox Credit!"
	/// </summary>
	public override string HeadingAlreadyHaveCredit => "Robloxクレジットがあります！";

	/// <summary>
	/// Key: "Heading.BuyRobuxUsingRixty"
	/// English String: "Buy Robux using Rixty"
	/// </summary>
	public override string HeadingBuyRobuxUsingRixty => "Rixtyを使ってRobuxを買う";

	/// <summary>
	/// Key: "Heading.GetRobuxOrBcWithRixty"
	/// English String: "Get Robux or Builders Club with Rixty"
	/// </summary>
	public override string HeadingGetRobuxOrBcWithRixty => "RixtyでRobuxやBuilders Clubをゲットしよう";

	/// <summary>
	/// Key: "Heading.GetRobuxWithRixty"
	/// English String: "Get Robux with Rixty"
	/// </summary>
	public override string HeadingGetRobuxWithRixty => "RixtyでRobuxをゲットしよう";

	/// <summary>
	/// Key: "Heading.HowToUse"
	/// English String: "How to Use"
	/// </summary>
	public override string HeadingHowToUse => "使い方";

	/// <summary>
	/// Key: "Heading.PayWithRixty"
	/// English String: "Pay with Rixty"
	/// </summary>
	public override string HeadingPayWithRixty => "Rixtyで払う";

	/// <summary>
	/// Key: "Heading.RedeemRixtyCards"
	/// English String: "Redeem Rixty Cards"
	/// </summary>
	public override string HeadingRedeemRixtyCards => "Rixtyカードを引き換える";

	/// <summary>
	/// Key: "Label.AlreadyHaveAccount"
	/// English String: "I already have a Rixty account"
	/// </summary>
	public override string LabelAlreadyHaveAccount => "すでにRixtyアカウントを持っています";

	/// <summary>
	/// Key: "Label.BuildersClubImage"
	/// Alternate text for Builders Club image
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClubImage => "Builders Club";

	/// <summary>
	/// Key: "Label.EnterPin"
	/// English String: "Enter PIN:"
	/// </summary>
	public override string LabelEnterPin => "PINを入力:";

	/// <summary>
	/// Key: "Label.EnterPinImage"
	/// English String: "Enter Your PIN"
	/// </summary>
	public override string LabelEnterPinImage => "PINを入力してください";

	/// <summary>
	/// Key: "Label.FortyFiveDaysBC"
	/// English String: "45 Day Builders Club Extension - $10.00 (Existing BC members only)"
	/// </summary>
	public override string LabelFortyFiveDaysBC => "Builders Club（45日延長） -$10.00（現在BCメンバーの方のみ）";

	/// <summary>
	/// Key: "Label.InstructionForCombineCards"
	/// English String: "Combine cards for more Roblox credit."
	/// </summary>
	public override string LabelInstructionForCombineCards => "カードを組み合わせて、さらにRobloxクレジットを獲得しましょう。";

	/// <summary>
	/// Key: "Label.InstructionForEnterPin"
	/// English String: "Enter your Rixty PIN."
	/// </summary>
	public override string LabelInstructionForEnterPin => "Rixty PINを入力してください。";

	/// <summary>
	/// Key: "Label.OrUppercase"
	/// English String: "OR"
	/// </summary>
	public override string LabelOrUppercase => "または";

	/// <summary>
	/// Key: "Label.PinImageText"
	/// English String: "Your PIN is on your receipt"
	/// </summary>
	public override string LabelPinImageText => "PINはレシートに記載されています";

	/// <summary>
	/// Key: "Label.RixtyLogo"
	/// English String: "Rixty Logo"
	/// </summary>
	public override string LabelRixtyLogo => "Rixtyロゴ";

	/// <summary>
	/// Key: "Label.Robux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.ThirtyDaysBC"
	/// English String: "30 Days of Builders Club - $10.00"
	/// </summary>
	public override string LabelThirtyDaysBC => "Builders Club（30日間） - $10.00";

	/// <summary>
	/// Key: "Label.WhySpendCredit"
	/// English String: "Spend your Roblox credit on Robux and Builders Club!"
	/// </summary>
	public override string LabelWhySpendCredit => "RobuxやBuilders Clubのお支払いにRobloxクレジットを使おう！";

	/// <summary>
	/// Key: "Label.YourBalance"
	/// English String: "Your Balance:"
	/// </summary>
	public override string LabelYourBalance => "あなたの残高:";

	/// <summary>
	/// Key: "Message.AnErrorOccurred"
	/// English String: "An error occurred"
	/// </summary>
	public override string MessageAnErrorOccurred => "エラーが発生";

	/// <summary>
	/// Key: "Message.Failure"
	/// English String: "Failure"
	/// </summary>
	public override string MessageFailure => "失敗";

	/// <summary>
	/// Key: "Message.Loading"
	/// English String: "Loading"
	/// </summary>
	public override string MessageLoading => "読み込み中";

	/// <summary>
	/// Key: "Message.PinAlreadyRedeemed"
	/// English String: "PIN already redeemed"
	/// </summary>
	public override string MessagePinAlreadyRedeemed => "PINは引き換え済みです";

	/// <summary>
	/// Key: "Message.RixtyUnavailable"
	/// English String: "Currently unavailable. Please try again later."
	/// </summary>
	public override string MessageRixtyUnavailable => "現在利用できません。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "成功";

	/// <summary>
	/// Key: "Message.SuccessfulRedemption"
	/// English String: "You have successfully redeemed your PIN!"
	/// </summary>
	public override string MessageSuccessfulRedemption => "PINの認証が完了しました！";

	public RixtyPinResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyNow()
	{
		return "今すぐ買う";
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Robuxを買う";
	}

	protected override string _GetTemplateForActionMoreBCOptions()
	{
		return "その他のBuilders Clubオプション";
	}

	protected override string _GetTemplateForActionRedeem()
	{
		return "引き換え";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobux"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobux(string lineBreak)
	{
		return $"Rixtyでは、現金やコインでRobuxやBuilders Clubのメンバーシップを買うことができます。{lineBreak}クレジットカードがなくても大丈夫！";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobux()
	{
		return "Rixtyでは、現金やコインでRobuxやBuilders Clubのメンバーシップを買うことができます。{lineBreak}クレジットカードがなくても大丈夫！";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobuxAndPremium"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobuxAndPremium(string lineBreak)
	{
		return $"Rixtyでは、現金やコインでRobuxやBuilders Clubのメンバーシップを買うことができます。{lineBreak}クレジットカードがなくても大丈夫！";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobuxAndPremium()
	{
		return "Rixtyでは、現金やコインでRobuxやBuilders Clubのメンバーシップを買うことができます。{lineBreak}クレジットカードがなくても大丈夫！";
	}

	protected override string _GetTemplateForHeadingAlreadyHaveCredit()
	{
		return "Robloxクレジットがあります！";
	}

	protected override string _GetTemplateForHeadingBuyRobuxUsingRixty()
	{
		return "Rixtyを使ってRobuxを買う";
	}

	protected override string _GetTemplateForHeadingGetRobuxOrBcWithRixty()
	{
		return "RixtyでRobuxやBuilders Clubをゲットしよう";
	}

	protected override string _GetTemplateForHeadingGetRobuxWithRixty()
	{
		return "RixtyでRobuxをゲットしよう";
	}

	protected override string _GetTemplateForHeadingHowToUse()
	{
		return "使い方";
	}

	protected override string _GetTemplateForHeadingPayWithRixty()
	{
		return "Rixtyで払う";
	}

	protected override string _GetTemplateForHeadingRedeemRixtyCards()
	{
		return "Rixtyカードを引き換える";
	}

	protected override string _GetTemplateForLabelAlreadyHaveAccount()
	{
		return "すでにRixtyアカウントを持っています";
	}

	/// <summary>
	/// Key: "Label.BuildersClubExtensionExisting"
	/// For example, 45 Day Builders Club Extension - $10.00 (Existing BC members only)
	/// English String: "{numberOfDays} Day Builders Club Extension - {cost} (Existing BC members only)"
	/// </summary>
	public override string LabelBuildersClubExtensionExisting(string numberOfDays, string cost)
	{
		return $"Builders Club（{numberOfDays}日延長） - {cost}（現在BCメンバーの方のみ）";
	}

	protected override string _GetTemplateForLabelBuildersClubExtensionExisting()
	{
		return "Builders Club（{numberOfDays}日延長） - {cost}（現在BCメンバーの方のみ）";
	}

	protected override string _GetTemplateForLabelBuildersClubImage()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubOffer"
	/// New purchase offer of builders club
	/// English String: "{numberOfDays} Days of Builders Club - {cost}"
	/// </summary>
	public override string LabelBuildersClubOffer(string numberOfDays, string cost)
	{
		return $"Builders Club（{numberOfDays}日間） - {cost}";
	}

	protected override string _GetTemplateForLabelBuildersClubOffer()
	{
		return "Builders Club（{numberOfDays}日間） - {cost}";
	}

	/// <summary>
	/// Key: "Label.BuyRobuxWithRixty"
	/// For example, "400 Robux for $4.95"
	/// English String: "{robuxAmount} Robux for {currencyAmount}"
	/// </summary>
	public override string LabelBuyRobuxWithRixty(string robuxAmount, string currencyAmount)
	{
		return $"{currencyAmount}で{robuxAmount} Robux";
	}

	protected override string _GetTemplateForLabelBuyRobuxWithRixty()
	{
		return "{currencyAmount}で{robuxAmount} Robux";
	}

	protected override string _GetTemplateForLabelEnterPin()
	{
		return "PINを入力:";
	}

	protected override string _GetTemplateForLabelEnterPinImage()
	{
		return "PINを入力してください";
	}

	protected override string _GetTemplateForLabelFortyFiveDaysBC()
	{
		return "Builders Club（45日延長） -$10.00（現在BCメンバーの方のみ）";
	}

	/// <summary>
	/// Key: "Label.GetPhysicalRixtyCard"
	/// English String: "{startLink}Go to your local store{endLink} and get a Rixty Card."
	/// </summary>
	public override string LabelGetPhysicalRixtyCard(string startLink, string endLink)
	{
		return $"{startLink}お近くのショップ{endLink}で、Rixtyカードを手に入れよう。";
	}

	protected override string _GetTemplateForLabelGetPhysicalRixtyCard()
	{
		return "{startLink}お近くのショップ{endLink}で、Rixtyカードを手に入れよう。";
	}

	protected override string _GetTemplateForLabelInstructionForCombineCards()
	{
		return "カードを組み合わせて、さらにRobloxクレジットを獲得しましょう。";
	}

	protected override string _GetTemplateForLabelInstructionForEnterPin()
	{
		return "Rixty PINを入力してください。";
	}

	protected override string _GetTemplateForLabelOrUppercase()
	{
		return "または";
	}

	protected override string _GetTemplateForLabelPinImageText()
	{
		return "PINはレシートに記載されています";
	}

	protected override string _GetTemplateForLabelRixtyLogo()
	{
		return "Rixtyロゴ";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelThirtyDaysBC()
	{
		return "Builders Club（30日間） - $10.00";
	}

	protected override string _GetTemplateForLabelWhySpendCredit()
	{
		return "RobuxやBuilders Clubのお支払いにRobloxクレジットを使おう！";
	}

	protected override string _GetTemplateForLabelYourBalance()
	{
		return "あなたの残高:";
	}

	protected override string _GetTemplateForMessageAnErrorOccurred()
	{
		return "エラーが発生";
	}

	protected override string _GetTemplateForMessageFailure()
	{
		return "失敗";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "読み込み中";
	}

	protected override string _GetTemplateForMessagePinAlreadyRedeemed()
	{
		return "PINは引き換え済みです";
	}

	protected override string _GetTemplateForMessageRixtyUnavailable()
	{
		return "現在利用できません。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForMessageSuccessfulRedemption()
	{
		return "PINの認証が完了しました！";
	}
}
