namespace Roblox.TranslationResources.Purchasing;

/// <summary>
/// This class overrides RixtyPinResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class RixtyPinResources_es_es : RixtyPinResources_en_us, IRixtyPinResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyNow"
	/// English String: "Buy Now"
	/// </summary>
	public override string ActionBuyNow => "Comprar ahora";

	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Action.MoreBCOptions"
	/// English String: "More Builders Club Options"
	/// </summary>
	public override string ActionMoreBCOptions => "Más opciones del Builders Club";

	/// <summary>
	/// Key: "Action.Redeem"
	/// English String: "Redeem"
	/// </summary>
	public override string ActionRedeem => "Canjear";

	/// <summary>
	/// Key: "Heading.AlreadyHaveCredit"
	/// English String: "You have Roblox Credit!"
	/// </summary>
	public override string HeadingAlreadyHaveCredit => "¡Tienes crédito de Roblox!";

	/// <summary>
	/// Key: "Heading.BuyRobuxUsingRixty"
	/// English String: "Buy Robux using Rixty"
	/// </summary>
	public override string HeadingBuyRobuxUsingRixty => "Comprar Robux con Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxOrBcWithRixty"
	/// English String: "Get Robux or Builders Club with Rixty"
	/// </summary>
	public override string HeadingGetRobuxOrBcWithRixty => "Obtén Robux o únete al Builders Club con la tarjeta Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxWithRixty"
	/// English String: "Get Robux with Rixty"
	/// </summary>
	public override string HeadingGetRobuxWithRixty => "Obtén Robux con Rixty";

	/// <summary>
	/// Key: "Heading.HowToUse"
	/// English String: "How to Use"
	/// </summary>
	public override string HeadingHowToUse => "Cómo usarlas";

	/// <summary>
	/// Key: "Heading.PayWithRixty"
	/// English String: "Pay with Rixty"
	/// </summary>
	public override string HeadingPayWithRixty => "Pagar con Rixty";

	/// <summary>
	/// Key: "Heading.RedeemRixtyCards"
	/// English String: "Redeem Rixty Cards"
	/// </summary>
	public override string HeadingRedeemRixtyCards => "Canjear las tarjetas Rixty";

	/// <summary>
	/// Key: "Label.AlreadyHaveAccount"
	/// English String: "I already have a Rixty account"
	/// </summary>
	public override string LabelAlreadyHaveAccount => "Ya tengo una cuenta Rixty";

	/// <summary>
	/// Key: "Label.BuildersClubImage"
	/// Alternate text for Builders Club image
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClubImage => "Builders Club";

	/// <summary>
	/// Key: "Label.EnterPin"
	/// English String: "Enter PIN:"
	/// </summary>
	public override string LabelEnterPin => "Ingresar PIN:";

	/// <summary>
	/// Key: "Label.EnterPinImage"
	/// English String: "Enter Your PIN"
	/// </summary>
	public override string LabelEnterPinImage => "Introduce tu PIN";

	/// <summary>
	/// Key: "Label.FortyFiveDaysBC"
	/// English String: "45 Day Builders Club Extension - $10.00 (Existing BC members only)"
	/// </summary>
	public override string LabelFortyFiveDaysBC => "Extensión de 45 días del Builders Club - $10 (solo para los miembros actuales del BC)";

	/// <summary>
	/// Key: "Label.InstructionForCombineCards"
	/// English String: "Combine cards for more Roblox credit."
	/// </summary>
	public override string LabelInstructionForCombineCards => "Combina las tarjetas para aumentar tu crédito de Roblox.";

	/// <summary>
	/// Key: "Label.InstructionForEnterPin"
	/// English String: "Enter your Rixty PIN."
	/// </summary>
	public override string LabelInstructionForEnterPin => "Introduce tu PIN de Rixty.";

	/// <summary>
	/// Key: "Label.OrUppercase"
	/// English String: "OR"
	/// </summary>
	public override string LabelOrUppercase => "O";

	/// <summary>
	/// Key: "Label.PinImageText"
	/// English String: "Your PIN is on your receipt"
	/// </summary>
	public override string LabelPinImageText => "Tu PIN está en el recibo";

	/// <summary>
	/// Key: "Label.RixtyLogo"
	/// English String: "Rixty Logo"
	/// </summary>
	public override string LabelRixtyLogo => "Logotipo de Rixty";

	/// <summary>
	/// Key: "Label.Robux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.ThirtyDaysBC"
	/// English String: "30 Days of Builders Club - $10.00"
	/// </summary>
	public override string LabelThirtyDaysBC => "30 días de Builders Club - $10";

	/// <summary>
	/// Key: "Label.WhySpendCredit"
	/// English String: "Spend your Roblox credit on Robux and Builders Club!"
	/// </summary>
	public override string LabelWhySpendCredit => "¡Utiliza tu crédito de Roblox para comprar Robux y para unirte al Builders Club!";

	/// <summary>
	/// Key: "Label.YourBalance"
	/// English String: "Your Balance:"
	/// </summary>
	public override string LabelYourBalance => "Tu saldo:";

	/// <summary>
	/// Key: "Message.AnErrorOccurred"
	/// English String: "An error occurred"
	/// </summary>
	public override string MessageAnErrorOccurred => "Se ha producido un error.";

	/// <summary>
	/// Key: "Message.Failure"
	/// English String: "Failure"
	/// </summary>
	public override string MessageFailure => "Error";

	/// <summary>
	/// Key: "Message.Loading"
	/// English String: "Loading"
	/// </summary>
	public override string MessageLoading => "Cargando";

	/// <summary>
	/// Key: "Message.PinAlreadyRedeemed"
	/// English String: "PIN already redeemed"
	/// </summary>
	public override string MessagePinAlreadyRedeemed => "El PIN ya se ha canjeado.";

	/// <summary>
	/// Key: "Message.RixtyUnavailable"
	/// English String: "Currently unavailable. Please try again later."
	/// </summary>
	public override string MessageRixtyUnavailable => "No disponible en este momento. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "Hecho";

	/// <summary>
	/// Key: "Message.SuccessfulRedemption"
	/// English String: "You have successfully redeemed your PIN!"
	/// </summary>
	public override string MessageSuccessfulRedemption => "¡Has canjeado correctamente tu PIN!";

	public RixtyPinResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyNow()
	{
		return "Comprar ahora";
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForActionMoreBCOptions()
	{
		return "Más opciones del Builders Club";
	}

	protected override string _GetTemplateForActionRedeem()
	{
		return "Canjear";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobux"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobux(string lineBreak)
	{
		return $"Con la tarjeta Rixty, puedes usar dinero en efectivo y monedas para comprar Robux o unirte al Builders Club.{lineBreak}¿No tienes una tarjeta de crédito? ¡No hay problema!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobux()
	{
		return "Con la tarjeta Rixty, puedes usar dinero en efectivo y monedas para comprar Robux o unirte al Builders Club.{lineBreak}¿No tienes una tarjeta de crédito? ¡No hay problema!";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobuxAndPremium"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobuxAndPremium(string lineBreak)
	{
		return $"Con la tarjeta Rixty, puedes usar dinero en efectivo y monedas para comprar Robux o unirte al Builders Club.{lineBreak}¿No tienes una tarjeta de crédito? ¡No hay problema!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobuxAndPremium()
	{
		return "Con la tarjeta Rixty, puedes usar dinero en efectivo y monedas para comprar Robux o unirte al Builders Club.{lineBreak}¿No tienes una tarjeta de crédito? ¡No hay problema!";
	}

	protected override string _GetTemplateForHeadingAlreadyHaveCredit()
	{
		return "¡Tienes crédito de Roblox!";
	}

	protected override string _GetTemplateForHeadingBuyRobuxUsingRixty()
	{
		return "Comprar Robux con Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxOrBcWithRixty()
	{
		return "Obtén Robux o únete al Builders Club con la tarjeta Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxWithRixty()
	{
		return "Obtén Robux con Rixty";
	}

	protected override string _GetTemplateForHeadingHowToUse()
	{
		return "Cómo usarlas";
	}

	protected override string _GetTemplateForHeadingPayWithRixty()
	{
		return "Pagar con Rixty";
	}

	protected override string _GetTemplateForHeadingRedeemRixtyCards()
	{
		return "Canjear las tarjetas Rixty";
	}

	protected override string _GetTemplateForLabelAlreadyHaveAccount()
	{
		return "Ya tengo una cuenta Rixty";
	}

	/// <summary>
	/// Key: "Label.BuildersClubExtensionExisting"
	/// For example, 45 Day Builders Club Extension - $10.00 (Existing BC members only)
	/// English String: "{numberOfDays} Day Builders Club Extension - {cost} (Existing BC members only)"
	/// </summary>
	public override string LabelBuildersClubExtensionExisting(string numberOfDays, string cost)
	{
		return $"Extensión de {numberOfDays} del Builders Club - {cost} (solo para los miembros actuales del BC)";
	}

	protected override string _GetTemplateForLabelBuildersClubExtensionExisting()
	{
		return "Extensión de {numberOfDays} del Builders Club - {cost} (solo para los miembros actuales del BC)";
	}

	protected override string _GetTemplateForLabelBuildersClubImage()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubOffer"
	/// New purchase offer of builders club
	/// English String: "{numberOfDays} Days of Builders Club - {cost}"
	/// </summary>
	public override string LabelBuildersClubOffer(string numberOfDays, string cost)
	{
		return $"{numberOfDays} días del Builders Club - {cost}";
	}

	protected override string _GetTemplateForLabelBuildersClubOffer()
	{
		return "{numberOfDays} días del Builders Club - {cost}";
	}

	/// <summary>
	/// Key: "Label.BuyRobuxWithRixty"
	/// For example, "400 Robux for $4.95"
	/// English String: "{robuxAmount} Robux for {currencyAmount}"
	/// </summary>
	public override string LabelBuyRobuxWithRixty(string robuxAmount, string currencyAmount)
	{
		return $"{robuxAmount} Robux por {currencyAmount}";
	}

	protected override string _GetTemplateForLabelBuyRobuxWithRixty()
	{
		return "{robuxAmount} Robux por {currencyAmount}";
	}

	protected override string _GetTemplateForLabelEnterPin()
	{
		return "Ingresar PIN:";
	}

	protected override string _GetTemplateForLabelEnterPinImage()
	{
		return "Introduce tu PIN";
	}

	protected override string _GetTemplateForLabelFortyFiveDaysBC()
	{
		return "Extensión de 45 días del Builders Club - $10 (solo para los miembros actuales del BC)";
	}

	/// <summary>
	/// Key: "Label.GetPhysicalRixtyCard"
	/// English String: "{startLink}Go to your local store{endLink} and get a Rixty Card."
	/// </summary>
	public override string LabelGetPhysicalRixtyCard(string startLink, string endLink)
	{
		return $"{startLink}Ve a tu tienda local{endLink} para conseguir una tarjeta Rixty.";
	}

	protected override string _GetTemplateForLabelGetPhysicalRixtyCard()
	{
		return "{startLink}Ve a tu tienda local{endLink} para conseguir una tarjeta Rixty.";
	}

	protected override string _GetTemplateForLabelInstructionForCombineCards()
	{
		return "Combina las tarjetas para aumentar tu crédito de Roblox.";
	}

	protected override string _GetTemplateForLabelInstructionForEnterPin()
	{
		return "Introduce tu PIN de Rixty.";
	}

	protected override string _GetTemplateForLabelOrUppercase()
	{
		return "O";
	}

	protected override string _GetTemplateForLabelPinImageText()
	{
		return "Tu PIN está en el recibo";
	}

	protected override string _GetTemplateForLabelRixtyLogo()
	{
		return "Logotipo de Rixty";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelThirtyDaysBC()
	{
		return "30 días de Builders Club - $10";
	}

	protected override string _GetTemplateForLabelWhySpendCredit()
	{
		return "¡Utiliza tu crédito de Roblox para comprar Robux y para unirte al Builders Club!";
	}

	protected override string _GetTemplateForLabelYourBalance()
	{
		return "Tu saldo:";
	}

	protected override string _GetTemplateForMessageAnErrorOccurred()
	{
		return "Se ha producido un error.";
	}

	protected override string _GetTemplateForMessageFailure()
	{
		return "Error";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "Cargando";
	}

	protected override string _GetTemplateForMessagePinAlreadyRedeemed()
	{
		return "El PIN ya se ha canjeado.";
	}

	protected override string _GetTemplateForMessageRixtyUnavailable()
	{
		return "No disponible en este momento. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForMessageSuccessfulRedemption()
	{
		return "¡Has canjeado correctamente tu PIN!";
	}
}
