namespace Roblox.TranslationResources.Purchasing;

/// <summary>
/// This class overrides RixtyPinResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class RixtyPinResources_de_de : RixtyPinResources_en_us, IRixtyPinResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyNow"
	/// English String: "Buy Now"
	/// </summary>
	public override string ActionBuyNow => "Jetzt kaufen";

	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Robux kaufen";

	/// <summary>
	/// Key: "Action.MoreBCOptions"
	/// English String: "More Builders Club Options"
	/// </summary>
	public override string ActionMoreBCOptions => "Weitere „Builders Club“-Optionen";

	/// <summary>
	/// Key: "Action.Redeem"
	/// English String: "Redeem"
	/// </summary>
	public override string ActionRedeem => "Einlösen";

	/// <summary>
	/// Key: "Heading.AlreadyHaveCredit"
	/// English String: "You have Roblox Credit!"
	/// </summary>
	public override string HeadingAlreadyHaveCredit => "Du hast Roblox-Guthaben!";

	/// <summary>
	/// Key: "Heading.BuyRobuxUsingRixty"
	/// English String: "Buy Robux using Rixty"
	/// </summary>
	public override string HeadingBuyRobuxUsingRixty => "Robux kaufen mit Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxOrBcWithRixty"
	/// English String: "Get Robux or Builders Club with Rixty"
	/// </summary>
	public override string HeadingGetRobuxOrBcWithRixty => "Hol dir Robux oder werde „Builders Club“-Mitglied mit Rixty";

	/// <summary>
	/// Key: "Heading.GetRobuxWithRixty"
	/// English String: "Get Robux with Rixty"
	/// </summary>
	public override string HeadingGetRobuxWithRixty => "Erhalte Robux mit Rixty";

	/// <summary>
	/// Key: "Heading.HowToUse"
	/// English String: "How to Use"
	/// </summary>
	public override string HeadingHowToUse => "So funktioniert’s";

	/// <summary>
	/// Key: "Heading.PayWithRixty"
	/// English String: "Pay with Rixty"
	/// </summary>
	public override string HeadingPayWithRixty => "Mit Rixty bezahlen";

	/// <summary>
	/// Key: "Heading.RedeemRixtyCards"
	/// English String: "Redeem Rixty Cards"
	/// </summary>
	public override string HeadingRedeemRixtyCards => "Rixty-Karten einlösen";

	/// <summary>
	/// Key: "Label.AlreadyHaveAccount"
	/// English String: "I already have a Rixty account"
	/// </summary>
	public override string LabelAlreadyHaveAccount => "Ich habe bereits ein Rixty-Konto";

	/// <summary>
	/// Key: "Label.BuildersClubImage"
	/// Alternate text for Builders Club image
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClubImage => "Builders Club";

	/// <summary>
	/// Key: "Label.EnterPin"
	/// English String: "Enter PIN:"
	/// </summary>
	public override string LabelEnterPin => "PIN eingeben:";

	/// <summary>
	/// Key: "Label.EnterPinImage"
	/// English String: "Enter Your PIN"
	/// </summary>
	public override string LabelEnterPinImage => "Gib deine PIN ein";

	/// <summary>
	/// Key: "Label.FortyFiveDaysBC"
	/// English String: "45 Day Builders Club Extension - $10.00 (Existing BC members only)"
	/// </summary>
	public override string LabelFortyFiveDaysBC => "45 Tage Verlängerung für Builders Club - 10,00\u00a0$ (Nur für bestehende BC-Mitglieder.)";

	/// <summary>
	/// Key: "Label.InstructionForCombineCards"
	/// English String: "Combine cards for more Roblox credit."
	/// </summary>
	public override string LabelInstructionForCombineCards => "Kombiniere Karten, um mehr Roblox-Guthaben zu erhalten.";

	/// <summary>
	/// Key: "Label.InstructionForEnterPin"
	/// English String: "Enter your Rixty PIN."
	/// </summary>
	public override string LabelInstructionForEnterPin => "Gib deine Rixty-PIN ein.";

	/// <summary>
	/// Key: "Label.OrUppercase"
	/// English String: "OR"
	/// </summary>
	public override string LabelOrUppercase => "ODER";

	/// <summary>
	/// Key: "Label.PinImageText"
	/// English String: "Your PIN is on your receipt"
	/// </summary>
	public override string LabelPinImageText => "Deine PIN befindet sich auf deinem Kaufbeleg.";

	/// <summary>
	/// Key: "Label.RixtyLogo"
	/// English String: "Rixty Logo"
	/// </summary>
	public override string LabelRixtyLogo => "Rixty Logo";

	/// <summary>
	/// Key: "Label.Robux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.ThirtyDaysBC"
	/// English String: "30 Days of Builders Club - $10.00"
	/// </summary>
	public override string LabelThirtyDaysBC => "30 Tage Builders Club - 10,00\u00a0$";

	/// <summary>
	/// Key: "Label.WhySpendCredit"
	/// English String: "Spend your Roblox credit on Robux and Builders Club!"
	/// </summary>
	public override string LabelWhySpendCredit => "Gib dein Roblox-Guthaben für Robux und Builders Club aus!";

	/// <summary>
	/// Key: "Label.YourBalance"
	/// English String: "Your Balance:"
	/// </summary>
	public override string LabelYourBalance => "Dein Guthaben:";

	/// <summary>
	/// Key: "Message.AnErrorOccurred"
	/// English String: "An error occurred"
	/// </summary>
	public override string MessageAnErrorOccurred => "Ein Fehler ist aufgetreten.";

	/// <summary>
	/// Key: "Message.Failure"
	/// English String: "Failure"
	/// </summary>
	public override string MessageFailure => "Gescheitert";

	/// <summary>
	/// Key: "Message.Loading"
	/// English String: "Loading"
	/// </summary>
	public override string MessageLoading => "Wird geladen";

	/// <summary>
	/// Key: "Message.PinAlreadyRedeemed"
	/// English String: "PIN already redeemed"
	/// </summary>
	public override string MessagePinAlreadyRedeemed => "PIN bereits eingelöst";

	/// <summary>
	/// Key: "Message.RixtyUnavailable"
	/// English String: "Currently unavailable. Please try again later."
	/// </summary>
	public override string MessageRixtyUnavailable => "Derzeit nicht verfügbar. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "Erfolg";

	/// <summary>
	/// Key: "Message.SuccessfulRedemption"
	/// English String: "You have successfully redeemed your PIN!"
	/// </summary>
	public override string MessageSuccessfulRedemption => "Du hast deine PIN eingelöst!";

	public RixtyPinResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyNow()
	{
		return "Jetzt kaufen";
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Robux kaufen";
	}

	protected override string _GetTemplateForActionMoreBCOptions()
	{
		return "Weitere „Builders Club“-Optionen";
	}

	protected override string _GetTemplateForActionRedeem()
	{
		return "Einlösen";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobux"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobux(string lineBreak)
	{
		return $"Mit Rixty kannst du Bargeld und Münzen verwenden, um Robux zu kaufen und „Builders Club“-Mitglied zu werden.{lineBreak}Keine Kreditkarte? Kein Problem!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobux()
	{
		return "Mit Rixty kannst du Bargeld und Münzen verwenden, um Robux zu kaufen und „Builders Club“-Mitglied zu werden.{lineBreak}Keine Kreditkarte? Kein Problem!";
	}

	/// <summary>
	/// Key: "Description.UseCashForRobuxAndPremium"
	/// English String: "With Rixty, you can use cash and coins to buy Robux and Builders Club.{lineBreak}No credit card? No problem!"
	/// </summary>
	public override string DescriptionUseCashForRobuxAndPremium(string lineBreak)
	{
		return $"Mit Rixty kannst du Bargeld und Coins verwenden, um Robux zu kaufen und „Builders Club“-Mitglied zu werden.{lineBreak}Keine Kreditkarte? Kein Problem!";
	}

	protected override string _GetTemplateForDescriptionUseCashForRobuxAndPremium()
	{
		return "Mit Rixty kannst du Bargeld und Coins verwenden, um Robux zu kaufen und „Builders Club“-Mitglied zu werden.{lineBreak}Keine Kreditkarte? Kein Problem!";
	}

	protected override string _GetTemplateForHeadingAlreadyHaveCredit()
	{
		return "Du hast Roblox-Guthaben!";
	}

	protected override string _GetTemplateForHeadingBuyRobuxUsingRixty()
	{
		return "Robux kaufen mit Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxOrBcWithRixty()
	{
		return "Hol dir Robux oder werde „Builders Club“-Mitglied mit Rixty";
	}

	protected override string _GetTemplateForHeadingGetRobuxWithRixty()
	{
		return "Erhalte Robux mit Rixty";
	}

	protected override string _GetTemplateForHeadingHowToUse()
	{
		return "So funktioniert’s";
	}

	protected override string _GetTemplateForHeadingPayWithRixty()
	{
		return "Mit Rixty bezahlen";
	}

	protected override string _GetTemplateForHeadingRedeemRixtyCards()
	{
		return "Rixty-Karten einlösen";
	}

	protected override string _GetTemplateForLabelAlreadyHaveAccount()
	{
		return "Ich habe bereits ein Rixty-Konto";
	}

	/// <summary>
	/// Key: "Label.BuildersClubExtensionExisting"
	/// For example, 45 Day Builders Club Extension - $10.00 (Existing BC members only)
	/// English String: "{numberOfDays} Day Builders Club Extension - {cost} (Existing BC members only)"
	/// </summary>
	public override string LabelBuildersClubExtensionExisting(string numberOfDays, string cost)
	{
		return $"{numberOfDays} Tage Verlängerung für Builders Club - {cost} (Nur für bestehende BC-Mitglieder.)";
	}

	protected override string _GetTemplateForLabelBuildersClubExtensionExisting()
	{
		return "{numberOfDays} Tage Verlängerung für Builders Club - {cost} (Nur für bestehende BC-Mitglieder.)";
	}

	protected override string _GetTemplateForLabelBuildersClubImage()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubOffer"
	/// New purchase offer of builders club
	/// English String: "{numberOfDays} Days of Builders Club - {cost}"
	/// </summary>
	public override string LabelBuildersClubOffer(string numberOfDays, string cost)
	{
		return $"{numberOfDays} Tage Builders Club - {cost}";
	}

	protected override string _GetTemplateForLabelBuildersClubOffer()
	{
		return "{numberOfDays} Tage Builders Club - {cost}";
	}

	/// <summary>
	/// Key: "Label.BuyRobuxWithRixty"
	/// For example, "400 Robux for $4.95"
	/// English String: "{robuxAmount} Robux for {currencyAmount}"
	/// </summary>
	public override string LabelBuyRobuxWithRixty(string robuxAmount, string currencyAmount)
	{
		return $"{robuxAmount} Robux für {currencyAmount}";
	}

	protected override string _GetTemplateForLabelBuyRobuxWithRixty()
	{
		return "{robuxAmount} Robux für {currencyAmount}";
	}

	protected override string _GetTemplateForLabelEnterPin()
	{
		return "PIN eingeben:";
	}

	protected override string _GetTemplateForLabelEnterPinImage()
	{
		return "Gib deine PIN ein";
	}

	protected override string _GetTemplateForLabelFortyFiveDaysBC()
	{
		return "45 Tage Verlängerung für Builders Club - 10,00\u00a0$ (Nur für bestehende BC-Mitglieder.)";
	}

	/// <summary>
	/// Key: "Label.GetPhysicalRixtyCard"
	/// English String: "{startLink}Go to your local store{endLink} and get a Rixty Card."
	/// </summary>
	public override string LabelGetPhysicalRixtyCard(string startLink, string endLink)
	{
		return $"{startLink}Geh zu einem Laden in deiner Nähe{endLink} und kaufe eine Rixty-Karte.";
	}

	protected override string _GetTemplateForLabelGetPhysicalRixtyCard()
	{
		return "{startLink}Geh zu einem Laden in deiner Nähe{endLink} und kaufe eine Rixty-Karte.";
	}

	protected override string _GetTemplateForLabelInstructionForCombineCards()
	{
		return "Kombiniere Karten, um mehr Roblox-Guthaben zu erhalten.";
	}

	protected override string _GetTemplateForLabelInstructionForEnterPin()
	{
		return "Gib deine Rixty-PIN ein.";
	}

	protected override string _GetTemplateForLabelOrUppercase()
	{
		return "ODER";
	}

	protected override string _GetTemplateForLabelPinImageText()
	{
		return "Deine PIN befindet sich auf deinem Kaufbeleg.";
	}

	protected override string _GetTemplateForLabelRixtyLogo()
	{
		return "Rixty Logo";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelThirtyDaysBC()
	{
		return "30 Tage Builders Club - 10,00\u00a0$";
	}

	protected override string _GetTemplateForLabelWhySpendCredit()
	{
		return "Gib dein Roblox-Guthaben für Robux und Builders Club aus!";
	}

	protected override string _GetTemplateForLabelYourBalance()
	{
		return "Dein Guthaben:";
	}

	protected override string _GetTemplateForMessageAnErrorOccurred()
	{
		return "Ein Fehler ist aufgetreten.";
	}

	protected override string _GetTemplateForMessageFailure()
	{
		return "Gescheitert";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "Wird geladen";
	}

	protected override string _GetTemplateForMessagePinAlreadyRedeemed()
	{
		return "PIN bereits eingelöst";
	}

	protected override string _GetTemplateForMessageRixtyUnavailable()
	{
		return "Derzeit nicht verfügbar. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForMessageSuccessfulRedemption()
	{
		return "Du hast deine PIN eingelöst!";
	}
}
