namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SurveysGameRatingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SurveysGameRatingsResources_zh_cjv : SurveysGameRatingsResources_en_us, ISurveysGameRatingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Frequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Frequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainFrequently => "经常出现";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Infrequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Infrequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainInfrequently => "不常出现";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.No"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainNo => "否";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Yes"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainYes => "是";

	/// <summary>
	/// Key: "Description.CanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue"
	/// Answer choices are "No", "Yes"
	/// English String: "Can users wager Robux, in game currency purchased with Robux or other items of real value?"
	/// </summary>
	public override string DescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue => "用户是否能以 Robux、用 Robux 购买的游戏内货币或其他有实际价值的道具来下注？";

	/// <summary>
	/// Key: "Description.DefenselessViolenceQuestion"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain violence directed towards defenseless characters?"
	/// </summary>
	public override string DescriptionDefenselessViolenceQuestion => "此游戏是否包含针对无防御能力角色的暴力行为？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainBathroomHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain bathroom humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainBathroomHumor => "此游戏是否包含与排泄物相关的笑话？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainCrudeHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain crude humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainCrudeHumor => "此游戏是否包含黄色笑话？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainNudityOrDepictionsOfSex"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain nudity or depictions of sex?"
	/// </summary>
	public override string DescriptionDoesThisGameContainNudityOrDepictionsOfSex => "此游戏是否包含裸露画面或色情描述？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs"
	/// This question has four possible answer choices: "No", "Infrequent references", "Frequent references", "Characters are shown using alcohol, tobacco or drugs"
	/// English String: "Does this game contain references to alcohol, tobacco or drugs?"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs => "此游戏是否包含有关酒精、香烟或毒品的内容？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.CharactersAreShownUsingAlcoholTobac"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Characters are shown using alcohol, tobacco or drugs"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac => "包含角色使用酒精、香烟或毒品的画面";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.FrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Frequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences => "经常出现";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.InfrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Infrequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences => "不常出现";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.No"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo => "否";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSimulatedGamblingOrPaidLootBoxes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain simulated gambling or paid loot boxes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes => "此游戏是否包含模拟赌博或需付费的战利品箱？";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSuggestiveSexualThemes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain suggestive sexual themes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSuggestiveSexualThemes => "此游戏是否包含暗示的性主题？";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules"
	/// Answer choices are "No, "Yes"
	/// English String: "Does this game follow the the community rules? "
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRules => "此游戏是否遵守社区规则？ ";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.No"
	/// This game does not follow community rules
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesNo => "否";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.Yes"
	/// This game does follow community rules
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesYes => "是";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity"
	/// This question has four possible answer choices: "No", "Some mild bad language", "Infrequenty profanity", "Frequent profanity"
	/// English String: "Does this game use profanity?"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanity => "此游戏是否包含脏话？";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.FrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Frequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityFrequentProfanity => "经常出现脏话";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.InfrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Infrequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityInfrequentProfanity => "不常出现脏话";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.No"
	/// One of four possible answers to "Does this game use profanity?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityNo => "否";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.SomeMildBadLanguage"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Some mild bad language"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanitySomeMildBadLanguage => "一些较温和的脏话";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderEightQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 8 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderEightQuestion => "此游戏是否包含可能吓到 8 岁以下儿童的内容？";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderTwelveQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 12 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderTwelveQuestion => "此游戏是否包含可能吓到 12 岁以下儿童的内容？";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ComicalViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Comical violence"
	/// </summary>
	public override string DescriptionViolenceQuestionComicalViolence => "喜剧式暴力";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.DoesThisGameContainViolentContent"
	/// Note: This survey question lets user pick one of five possible responses, as opposed to being just a "Yes/No" question.
	/// English String: "Does this game contain violent content?"
	/// </summary>
	public override string DescriptionViolenceQuestionDoesThisGameContainViolentContent => "此游戏是否包含暴力内容？";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.EasilyDistinguishableFromRealLife"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Easily distinguishable from real life"
	/// </summary>
	public override string DescriptionViolenceQuestionEasilyDistinguishableFromRealLife => "可轻易与现实区分的暴力";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ExtremeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Extreme, realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionExtremeRealisticViolence => "极度逼真的暴力";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.No"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionViolenceQuestionNo => "否";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.SomeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Some realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionSomeRealisticViolence => "略微逼真的暴力";

	public SurveysGameRatingsResources_zh_cjv(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainFrequently()
	{
		return "经常出现";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainInfrequently()
	{
		return "不常出现";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainNo()
	{
		return "否";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainYes()
	{
		return "是";
	}

	protected override string _GetTemplateForDescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue()
	{
		return "用户是否能以 Robux、用 Robux 购买的游戏内货币或其他有实际价值的道具来下注？";
	}

	protected override string _GetTemplateForDescriptionDefenselessViolenceQuestion()
	{
		return "此游戏是否包含针对无防御能力角色的暴力行为？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainBathroomHumor()
	{
		return "此游戏是否包含与排泄物相关的笑话？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainCrudeHumor()
	{
		return "此游戏是否包含黄色笑话？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainNudityOrDepictionsOfSex()
	{
		return "此游戏是否包含裸露画面或色情描述？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs()
	{
		return "此游戏是否包含有关酒精、香烟或毒品的内容？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac()
	{
		return "包含角色使用酒精、香烟或毒品的画面";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences()
	{
		return "经常出现";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences()
	{
		return "不常出现";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo()
	{
		return "否";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes()
	{
		return "此游戏是否包含模拟赌博或需付费的战利品箱？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSuggestiveSexualThemes()
	{
		return "此游戏是否包含暗示的性主题？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRules()
	{
		return "此游戏是否遵守社区规则？ ";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesNo()
	{
		return "否";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesYes()
	{
		return "是";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanity()
	{
		return "此游戏是否包含脏话？";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityFrequentProfanity()
	{
		return "经常出现脏话";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityInfrequentProfanity()
	{
		return "不常出现脏话";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityNo()
	{
		return "否";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanitySomeMildBadLanguage()
	{
		return "一些较温和的脏话";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderEightQuestion()
	{
		return "此游戏是否包含可能吓到 8 岁以下儿童的内容？";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderTwelveQuestion()
	{
		return "此游戏是否包含可能吓到 12 岁以下儿童的内容？";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionComicalViolence()
	{
		return "喜剧式暴力";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionDoesThisGameContainViolentContent()
	{
		return "此游戏是否包含暴力内容？";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionEasilyDistinguishableFromRealLife()
	{
		return "可轻易与现实区分的暴力";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionExtremeRealisticViolence()
	{
		return "极度逼真的暴力";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionNo()
	{
		return "否";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionSomeRealisticViolence()
	{
		return "略微逼真的暴力";
	}
}
