namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SurveysGameRatingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SurveysGameRatingsResources_es_es : SurveysGameRatingsResources_en_us, ISurveysGameRatingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Frequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Frequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainFrequently => "Con frecuencia";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Infrequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Infrequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainInfrequently => "Con poca frecuencia";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.No"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainNo => "No";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Yes"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainYes => "Sí";

	/// <summary>
	/// Key: "Description.CanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue"
	/// Answer choices are "No", "Yes"
	/// English String: "Can users wager Robux, in game currency purchased with Robux or other items of real value?"
	/// </summary>
	public override string DescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue => "¿Pueden los usuarios apostar usando Robux, comprar con Robux dinero virtual dentro del juego u otros objetos que tengan un valor real?";

	/// <summary>
	/// Key: "Description.DefenselessViolenceQuestion"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain violence directed towards defenseless characters?"
	/// </summary>
	public override string DescriptionDefenselessViolenceQuestion => "¿Este juego contiene actos de violencia dirigidos a personajes indefensos?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainBathroomHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain bathroom humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainBathroomHumor => "¿Este juego contiene humor que hace referencia a actos fisiológicos o corporales (orinar, defecar, vomitar, etc.)?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainCrudeHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain crude humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainCrudeHumor => "¿Este juego contiene humor vulgar?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainNudityOrDepictionsOfSex"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain nudity or depictions of sex?"
	/// </summary>
	public override string DescriptionDoesThisGameContainNudityOrDepictionsOfSex => "¿Este juego contiene desnudez o escenas de sexo?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs"
	/// This question has four possible answer choices: "No", "Infrequent references", "Frequent references", "Characters are shown using alcohol, tobacco or drugs"
	/// English String: "Does this game contain references to alcohol, tobacco or drugs?"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs => "¿Este juego contiene referencias al alcohol, tabaco o drogas?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.CharactersAreShownUsingAlcoholTobac"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Characters are shown using alcohol, tobacco or drugs"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac => "Se muestran personajes que consumen alcohol, drogas o fuman";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.FrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Frequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences => "Referencias frecuentes";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.InfrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Infrequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences => "Referencias infrecuentes";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.No"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo => "No";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSimulatedGamblingOrPaidLootBoxes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain simulated gambling or paid loot boxes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes => "¿Este juego contiene apuestas simuladas o cajas de botín de pago?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSuggestiveSexualThemes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain suggestive sexual themes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSuggestiveSexualThemes => "¿Este juego contiene temas sexuales sugestivos?";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules"
	/// Answer choices are "No, "Yes"
	/// English String: "Does this game follow the the community rules? "
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRules => "¿Este juego sigue las directrices de la comunidad? ";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.No"
	/// This game does not follow community rules
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesNo => "No";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.Yes"
	/// This game does follow community rules
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesYes => "Sí";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity"
	/// This question has four possible answer choices: "No", "Some mild bad language", "Infrequenty profanity", "Frequent profanity"
	/// English String: "Does this game use profanity?"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanity => "¿Este juego contiene lenguaje soez?";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.FrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Frequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityFrequentProfanity => "Palabrotas frecuentes";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.InfrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Infrequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityInfrequentProfanity => "Palabrotas infrecuentes";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.No"
	/// One of four possible answers to "Does this game use profanity?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityNo => "No";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.SomeMildBadLanguage"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Some mild bad language"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanitySomeMildBadLanguage => "Algunas palabrotas leves";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderEightQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 8 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderEightQuestion => "¿Este juego presenta contenido que puede asustar a niños menores de 8 años?";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderTwelveQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 12 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderTwelveQuestion => "¿Este juego presenta contenido que puede asustar a niños menores de 12 años?";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ComicalViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Comical violence"
	/// </summary>
	public override string DescriptionViolenceQuestionComicalViolence => "Violencia cómica";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.DoesThisGameContainViolentContent"
	/// Note: This survey question lets user pick one of five possible responses, as opposed to being just a "Yes/No" question.
	/// English String: "Does this game contain violent content?"
	/// </summary>
	public override string DescriptionViolenceQuestionDoesThisGameContainViolentContent => "¿Este juego presenta contenido violento?";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.EasilyDistinguishableFromRealLife"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Easily distinguishable from real life"
	/// </summary>
	public override string DescriptionViolenceQuestionEasilyDistinguishableFromRealLife => "Fácilmente distinguible de la vida real";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ExtremeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Extreme, realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionExtremeRealisticViolence => "Violencia extrema y realista";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.No"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionViolenceQuestionNo => "No";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.SomeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Some realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionSomeRealisticViolence => "Algo de violencia realista";

	public SurveysGameRatingsResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainFrequently()
	{
		return "Con frecuencia";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainInfrequently()
	{
		return "Con poca frecuencia";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainNo()
	{
		return "No";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainYes()
	{
		return "Sí";
	}

	protected override string _GetTemplateForDescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue()
	{
		return "¿Pueden los usuarios apostar usando Robux, comprar con Robux dinero virtual dentro del juego u otros objetos que tengan un valor real?";
	}

	protected override string _GetTemplateForDescriptionDefenselessViolenceQuestion()
	{
		return "¿Este juego contiene actos de violencia dirigidos a personajes indefensos?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainBathroomHumor()
	{
		return "¿Este juego contiene humor que hace referencia a actos fisiológicos o corporales (orinar, defecar, vomitar, etc.)?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainCrudeHumor()
	{
		return "¿Este juego contiene humor vulgar?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainNudityOrDepictionsOfSex()
	{
		return "¿Este juego contiene desnudez o escenas de sexo?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs()
	{
		return "¿Este juego contiene referencias al alcohol, tabaco o drogas?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac()
	{
		return "Se muestran personajes que consumen alcohol, drogas o fuman";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences()
	{
		return "Referencias frecuentes";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences()
	{
		return "Referencias infrecuentes";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo()
	{
		return "No";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes()
	{
		return "¿Este juego contiene apuestas simuladas o cajas de botín de pago?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSuggestiveSexualThemes()
	{
		return "¿Este juego contiene temas sexuales sugestivos?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRules()
	{
		return "¿Este juego sigue las directrices de la comunidad? ";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesNo()
	{
		return "No";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesYes()
	{
		return "Sí";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanity()
	{
		return "¿Este juego contiene lenguaje soez?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityFrequentProfanity()
	{
		return "Palabrotas frecuentes";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityInfrequentProfanity()
	{
		return "Palabrotas infrecuentes";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityNo()
	{
		return "No";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanitySomeMildBadLanguage()
	{
		return "Algunas palabrotas leves";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderEightQuestion()
	{
		return "¿Este juego presenta contenido que puede asustar a niños menores de 8 años?";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderTwelveQuestion()
	{
		return "¿Este juego presenta contenido que puede asustar a niños menores de 12 años?";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionComicalViolence()
	{
		return "Violencia cómica";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionDoesThisGameContainViolentContent()
	{
		return "¿Este juego presenta contenido violento?";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionEasilyDistinguishableFromRealLife()
	{
		return "Fácilmente distinguible de la vida real";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionExtremeRealisticViolence()
	{
		return "Violencia extrema y realista";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionNo()
	{
		return "No";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionSomeRealisticViolence()
	{
		return "Algo de violencia realista";
	}
}
