namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SurveysGameRatingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SurveysGameRatingsResources_de_de : SurveysGameRatingsResources_en_us, ISurveysGameRatingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Frequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Frequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainFrequently => "Häufig";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Infrequently"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____?"
	/// English String: "Infrequently"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainInfrequently => "Selten";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.No"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainNo => "Nein";

	/// <summary>
	/// Key: "Description.AnswerToDoesThisGameContain.Yes"
	/// A recurring possible answer choice to questions formatted as "Does this game contain ____ ?"
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionAnswerToDoesThisGameContainYes => "Ja";

	/// <summary>
	/// Key: "Description.CanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue"
	/// Answer choices are "No", "Yes"
	/// English String: "Can users wager Robux, in game currency purchased with Robux or other items of real value?"
	/// </summary>
	public override string DescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue => "Können Benutzer Robux, mit Robux gekaufte Spielwährung oder andere Artikel mit materiellem Wert als Wetteinsatz verwenden?";

	/// <summary>
	/// Key: "Description.DefenselessViolenceQuestion"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain violence directed towards defenseless characters?"
	/// </summary>
	public override string DescriptionDefenselessViolenceQuestion => "Enthält dieses Spiel gewalttätige Handlungen gegenüber wehrlosen Charakteren?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainBathroomHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain bathroom humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainBathroomHumor => "Enthält dieses Spiel Fäkalhumor?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainCrudeHumor"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain crude humor?"
	/// </summary>
	public override string DescriptionDoesThisGameContainCrudeHumor => "Enthält dieses Spiel derben Humor?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainNudityOrDepictionsOfSex"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain nudity or depictions of sex?"
	/// </summary>
	public override string DescriptionDoesThisGameContainNudityOrDepictionsOfSex => "Enthält dieses Spiel Nacktheit oder die Darstellung sexueller Handlungen?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs"
	/// This question has four possible answer choices: "No", "Infrequent references", "Frequent references", "Characters are shown using alcohol, tobacco or drugs"
	/// English String: "Does this game contain references to alcohol, tobacco or drugs?"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs => "Enthält dieses Spiel Referenzen zu Alkohol, Tabakprodukten oder Drogen?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.CharactersAreShownUsingAlcoholTobac"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Characters are shown using alcohol, tobacco or drugs"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac => "Charaktere werden beim Konsum von Alkohol, Tabakprodukten oder Drogen gezeigt";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.FrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Frequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences => "Häufige Referenzen";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.InfrequentReferences"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?", with an implied "Yes"
	/// English String: "Infrequent references"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences => "Seltene Referenzen";

	/// <summary>
	/// Key: "Description.DoesThisGameContainReferencesToAlcoholTobaccoOrDrugs.No"
	/// One of four possible answers to "Does this game contain references to alcohol, tobacco or drugs?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo => "Nein";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSimulatedGamblingOrPaidLootBoxes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain simulated gambling or paid loot boxes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes => "Enthält dieses Spiel simuliertes Glücksspiel oder Beutekisten, die gekauft werden können?";

	/// <summary>
	/// Key: "Description.DoesThisGameContainSuggestiveSexualThemes"
	/// Answer choices are "No", "Yes"
	/// English String: "Does this game contain suggestive sexual themes?"
	/// </summary>
	public override string DescriptionDoesThisGameContainSuggestiveSexualThemes => "Enthält dieses Spiel anzügliche sexuelle Elemente?";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules"
	/// Answer choices are "No, "Yes"
	/// English String: "Does this game follow the the community rules? "
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRules => "Hält dieses Spiel die Community-Regeln ein? ";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.No"
	/// This game does not follow community rules
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesNo => "Nein";

	/// <summary>
	/// Key: "Description.DoesThisGameFollowTheCommunityRules.Yes"
	/// This game does follow community rules
	/// English String: "Yes"
	/// </summary>
	public override string DescriptionDoesThisGameFollowTheCommunityRulesYes => "Ja";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity"
	/// This question has four possible answer choices: "No", "Some mild bad language", "Infrequenty profanity", "Frequent profanity"
	/// English String: "Does this game use profanity?"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanity => "Wird in diesem Spiel geflucht?";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.FrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Frequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityFrequentProfanity => "Häufiges Fluchen";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.InfrequentProfanity"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Infrequent profanity"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityInfrequentProfanity => "Seltenes Fluchen";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.No"
	/// One of four possible answers to "Does this game use profanity?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanityNo => "Nein";

	/// <summary>
	/// Key: "Description.DoesThisGameUseProfanity.SomeMildBadLanguage"
	/// One of four possible answers to "Does this game use profanity?", with an implied "Yes"
	/// English String: "Some mild bad language"
	/// </summary>
	public override string DescriptionDoesThisGameUseProfanitySomeMildBadLanguage => "Einige harmlose Flüche";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderEightQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 8 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderEightQuestion => "Enthält dieses Spiel Darstellungen, die von Kindern unter 8 Jahren als furchterregend empfunden werden können?";

	/// <summary>
	/// Key: "Description.ScaryForChildUnderTwelveQuestion"
	/// Answer choices are "No", "Infrequently", "Frequently"
	/// English String: "Does this game contain content that might be scary for a young child under 12 years old?"
	/// </summary>
	public override string DescriptionScaryForChildUnderTwelveQuestion => "Enthält dieses Spiel Darstellungen, die von Kindern unter 12 Jahren als furchterregend empfunden werden können?";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ComicalViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Comical violence"
	/// </summary>
	public override string DescriptionViolenceQuestionComicalViolence => "Comichafte Gewaltdarstellung";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.DoesThisGameContainViolentContent"
	/// Note: This survey question lets user pick one of five possible responses, as opposed to being just a "Yes/No" question.
	/// English String: "Does this game contain violent content?"
	/// </summary>
	public override string DescriptionViolenceQuestionDoesThisGameContainViolentContent => "Enthält dieses Spiel gewalttätige Elemente?";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.EasilyDistinguishableFromRealLife"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Easily distinguishable from real life"
	/// </summary>
	public override string DescriptionViolenceQuestionEasilyDistinguishableFromRealLife => "Leicht von realistischer Gewalt zu unterscheiden";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.ExtremeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Extreme, realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionExtremeRealisticViolence => "Extreme und realistische Gewaltdarstellung";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.No"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?"
	/// English String: "No"
	/// </summary>
	public override string DescriptionViolenceQuestionNo => "Nein";

	/// <summary>
	/// Key: "Description.ViolenceQuestion.SomeRealisticViolence"
	/// Note: This is one out of five possible answers to the question "Does this game contain violent content?", with an implied "Yes"
	/// English String: "Some realistic violence"
	/// </summary>
	public override string DescriptionViolenceQuestionSomeRealisticViolence => "Teilweise realistische Gewaltdarstellung";

	public SurveysGameRatingsResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainFrequently()
	{
		return "Häufig";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainInfrequently()
	{
		return "Selten";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForDescriptionAnswerToDoesThisGameContainYes()
	{
		return "Ja";
	}

	protected override string _GetTemplateForDescriptionCanUsersWagerRobuxInGameCurrencyPurchasedWithRobuxOrOtherItemsOfRealValue()
	{
		return "Können Benutzer Robux, mit Robux gekaufte Spielwährung oder andere Artikel mit materiellem Wert als Wetteinsatz verwenden?";
	}

	protected override string _GetTemplateForDescriptionDefenselessViolenceQuestion()
	{
		return "Enthält dieses Spiel gewalttätige Handlungen gegenüber wehrlosen Charakteren?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainBathroomHumor()
	{
		return "Enthält dieses Spiel Fäkalhumor?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainCrudeHumor()
	{
		return "Enthält dieses Spiel derben Humor?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainNudityOrDepictionsOfSex()
	{
		return "Enthält dieses Spiel Nacktheit oder die Darstellung sexueller Handlungen?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugs()
	{
		return "Enthält dieses Spiel Referenzen zu Alkohol, Tabakprodukten oder Drogen?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsCharactersAreShownUsingAlcoholTobac()
	{
		return "Charaktere werden beim Konsum von Alkohol, Tabakprodukten oder Drogen gezeigt";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsFrequentReferences()
	{
		return "Häufige Referenzen";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsInfrequentReferences()
	{
		return "Seltene Referenzen";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainReferencesToAlcoholTobaccoOrDrugsNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSimulatedGamblingOrPaidLootBoxes()
	{
		return "Enthält dieses Spiel simuliertes Glücksspiel oder Beutekisten, die gekauft werden können?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameContainSuggestiveSexualThemes()
	{
		return "Enthält dieses Spiel anzügliche sexuelle Elemente?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRules()
	{
		return "Hält dieses Spiel die Community-Regeln ein? ";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameFollowTheCommunityRulesYes()
	{
		return "Ja";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanity()
	{
		return "Wird in diesem Spiel geflucht?";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityFrequentProfanity()
	{
		return "Häufiges Fluchen";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityInfrequentProfanity()
	{
		return "Seltenes Fluchen";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanityNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForDescriptionDoesThisGameUseProfanitySomeMildBadLanguage()
	{
		return "Einige harmlose Flüche";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderEightQuestion()
	{
		return "Enthält dieses Spiel Darstellungen, die von Kindern unter 8 Jahren als furchterregend empfunden werden können?";
	}

	protected override string _GetTemplateForDescriptionScaryForChildUnderTwelveQuestion()
	{
		return "Enthält dieses Spiel Darstellungen, die von Kindern unter 12 Jahren als furchterregend empfunden werden können?";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionComicalViolence()
	{
		return "Comichafte Gewaltdarstellung";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionDoesThisGameContainViolentContent()
	{
		return "Enthält dieses Spiel gewalttätige Elemente?";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionEasilyDistinguishableFromRealLife()
	{
		return "Leicht von realistischer Gewalt zu unterscheiden";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionExtremeRealisticViolence()
	{
		return "Extreme und realistische Gewaltdarstellung";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForDescriptionViolenceQuestionSomeRealisticViolence()
	{
		return "Teilweise realistische Gewaltdarstellung";
	}
}
