namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SupportResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SupportResources_zh_tw : SupportResources_en_us, ISupportResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "取消";

	/// <summary>
	/// Key: "Action.Dialog.OK"
	/// OK
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogOK => "確定";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "傳送";

	/// <summary>
	/// Key: "Heading.ContactInformation"
	/// Contact Information
	/// English String: "Contact Information"
	/// </summary>
	public override string HeadingContactInformation => "聯絡資訊";

	/// <summary>
	/// Key: "Heading.DescriptionOfIssue"
	/// Description of issue
	/// English String: "Description of issue"
	/// </summary>
	public override string HeadingDescriptionOfIssue => "問題說明";

	/// <summary>
	/// Key: "Heading.DeviceWithProblem"
	/// What device are you having the problem on?
	/// English String: "What device are you having the problem on?"
	/// </summary>
	public override string HeadingDeviceWithProblem => "您遇到問題的裝置是？";

	/// <summary>
	/// Key: "Heading.Dialog.ErrorWithoutContext"
	/// Error
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogErrorWithoutContext => "錯誤";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "使用者名稱無效";

	/// <summary>
	/// Key: "Heading.Dialog.RequestReceived"
	/// Request Received
	/// English String: "Request Received"
	/// </summary>
	public override string HeadingDialogRequestReceived => "已收到請求";

	/// <summary>
	/// Key: "Heading.HelpCategoryType"
	/// Type of help category
	/// English String: "Type of help category"
	/// </summary>
	public override string HeadingHelpCategoryType => "說明類別的種類";

	/// <summary>
	/// Key: "Heading.IssueDetails"
	/// Issue Details
	/// English String: "Issue Details"
	/// </summary>
	public override string HeadingIssueDetails => "問題詳細資料";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// Contact Us
	/// English String: "Contact Us"
	/// </summary>
	public override string HeadingPageTitle => "聯絡我們";

	/// <summary>
	/// Key: "Label.AccountHacked"
	/// Account Hacked
	/// English String: "Account Hacked"
	/// </summary>
	public override string LabelAccountHacked => "帳號遭駭";

	/// <summary>
	/// Key: "Label.AccountOwnership"
	/// Account Hacked or Can't Log in
	/// English String: "Account Hacked or Can't Log in"
	/// </summary>
	public override string LabelAccountOwnership => "帳號遭駭或無法登入";

	/// <summary>
	/// Key: "Label.AccountPin"
	/// Account PIN
	/// English String: "Account PIN"
	/// </summary>
	public override string LabelAccountPin => "帳號 PIN";

	public override string LabelAdjustChildSettings => "調整兒童隱私權及安全設定";

	/// <summary>
	/// Key: "Label.AmazonDevice"
	/// Amazon Device
	/// English String: "Amazon Device"
	/// </summary>
	public override string LabelAmazonDevice => "Amazon 裝置";

	/// <summary>
	/// Key: "Label.AndroidPhone"
	/// Android Phone
	/// English String: "Android Phone"
	/// </summary>
	public override string LabelAndroidPhone => "Android 手機";

	/// <summary>
	/// Key: "Label.AndroidTablet"
	/// Android Tablet
	/// English String: "Android Tablet"
	/// </summary>
	public override string LabelAndroidTablet => "Android 平板電腦";

	/// <summary>
	/// Key: "Label.AppealAccountContent"
	/// Appeal Account or Content
	/// English String: "Appeal Account or Content"
	/// </summary>
	public override string LabelAppealAccountContent => "帳號或內容上訴";

	/// <summary>
	/// Key: "Label.AppealFriend"
	/// Appeal for Friend
	/// English String: "Appeal for Friend"
	/// </summary>
	public override string LabelAppealFriend => "為好友上訴";

	public override string LabelBilling => "帳務和付款";

	/// <summary>
	/// Key: "Label.BugReport"
	/// Bug Report
	/// English String: "Bug Report"
	/// </summary>
	public override string LabelBugReport => "舉報漏洞";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// Builders Club
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.CancelMembership"
	/// Cancel Membership
	/// English String: "Cancel Membership"
	/// </summary>
	public override string LabelCancelMembership => "取消會員資格";

	/// <summary>
	/// Key: "Label.CannotInstall"
	/// Cannot Install Roblox or Studio
	/// English String: "Cannot Install Roblox or Studio"
	/// </summary>
	public override string LabelCannotInstall => "無法安裝 Roblox 或 Studio";

	/// <summary>
	/// Key: "Label.CannotPlayGame"
	/// Cannot Play Game
	/// English String: "Cannot Play Game"
	/// </summary>
	public override string LabelCannotPlayGame => "無法玩遊戲";

	/// <summary>
	/// Key: "Label.ChangeChildAge"
	/// Change Child Age
	/// English String: "Change Child Age"
	/// </summary>
	public override string LabelChangeChildAge => "變更兒童年齡";

	public override string LabelChatAgeSettings => "聊天與年齡設定";

	/// <summary>
	/// Key: "Label.Chromebook"
	/// Chromebook
	/// English String: "Chromebook"
	/// </summary>
	public override string LabelChromebook => "Chromebook";

	/// <summary>
	/// Key: "Label.ConfirmEmail"
	/// Confirm Email Address
	/// English String: "Confirm Email Address"
	/// </summary>
	public override string LabelConfirmEmail => "確認電子郵件地址";

	/// <summary>
	/// Key: "Label.ContentAbuseReport"
	/// Report Content Breaking Rules
	/// English String: "Report Content Breaking Rules"
	/// </summary>
	public override string LabelContentAbuseReport => "舉報違規內容";

	public override string LabelContest => "比賽及活動";

	/// <summary>
	/// Key: "Label.ContestEventQuestion"
	/// Question or Issue
	/// English String: "Question or Issue"
	/// </summary>
	public override string LabelContestEventQuestion => "問題或困難";

	/// <summary>
	/// Key: "Label.CSCharacter"
	/// Customer Service Character
	/// English String: "Customer Service Character"
	/// </summary>
	public override string LabelCSCharacter => "客服人員角色";

	/// <summary>
	/// Key: "Label.DescribeIssue"
	/// Please describe your issue
	/// English String: "Please describe your issue"
	/// </summary>
	public override string LabelDescribeIssue => "請描述您的問題";

	/// <summary>
	/// Key: "Label.DevEx"
	/// DevEx
	/// English String: "DevEx"
	/// </summary>
	public override string LabelDevEx => "DevEx";

	/// <summary>
	/// Key: "Label.DevExHowTo"
	/// DevEx How To
	/// English String: "DevEx How To"
	/// </summary>
	public override string LabelDevExHowTo => "DevEx 說明";

	/// <summary>
	/// Key: "Label.DevExMyRequest"
	/// DevEx My Request
	/// English String: "DevEx My Request"
	/// </summary>
	public override string LabelDevExMyRequest => "DevEx 我的請求";

	/// <summary>
	/// Key: "Label.DMCA"
	/// DMCA
	/// English String: "DMCA"
	/// </summary>
	public override string LabelDMCA => "數位千禧年著作權法（DMCA）";

	/// <summary>
	/// Key: "Label.EmailAddress"
	/// Email Address
	/// English String: "Email Address"
	/// </summary>
	public override string LabelEmailAddress => "電子郵件地址";

	/// <summary>
	/// Key: "Label.ExploitReport"
	/// Exploit Report
	/// English String: "Exploit Report"
	/// </summary>
	public override string LabelExploitReport => "舉報外掛";

	/// <summary>
	/// Key: "Label.FirstName"
	/// First Name
	/// English String: "First Name"
	/// </summary>
	public override string LabelFirstName => "名字";

	/// <summary>
	/// Key: "Label.ForgotPassword"
	/// Forgot Password
	/// English String: "Forgot Password"
	/// </summary>
	public override string LabelForgotPassword => "忘記密碼";

	/// <summary>
	/// Key: "Label.FreeRobux"
	/// Free Robux
	/// English String: "Free Robux"
	/// </summary>
	public override string LabelFreeRobux => "免費 Robux";

	/// <summary>
	/// Key: "Label.GameCredit"
	/// Game Card
	/// English String: "Game Card"
	/// </summary>
	public override string LabelGameCredit => "點數卡";

	/// <summary>
	/// Key: "Label.GCPartialPayment"
	/// Purchase - Split Payment
	/// English String: "Purchase - Split Payment"
	/// </summary>
	public override string LabelGCPartialPayment => "購買 - 拆分付款";

	/// <summary>
	/// Key: "Label.GCRedeem"
	/// Game Card - Redeem
	/// English String: "Game Card - Redeem"
	/// </summary>
	public override string LabelGCRedeem => "點數卡 - 兌換";

	/// <summary>
	/// Key: "Label.GCSpendCredit"
	/// Game Card - Spend Credit
	/// English String: "Game Card - Spend Credit"
	/// </summary>
	public override string LabelGCSpendCredit => "點數卡 - 使用點數";

	/// <summary>
	/// Key: "Label.HowTo"
	/// How To
	/// English String: "How To"
	/// </summary>
	public override string LabelHowTo => "說明";

	/// <summary>
	/// Key: "Label.HowToGeneral"
	/// How To - General
	/// English String: "How To - General"
	/// </summary>
	public override string LabelHowToGeneral => "說明 - 一般";

	/// <summary>
	/// Key: "Label.HowToOther"
	/// How To - Other
	/// English String: "How To - Other"
	/// </summary>
	public override string LabelHowToOther => "說明 - 其它";

	public override string LabelIdeasSuggestions => "建議";

	/// <summary>
	/// Key: "Label.IPad"
	/// iPad
	/// English String: "iPad"
	/// </summary>
	public override string LabelIPad => "iPad";

	/// <summary>
	/// Key: "Label.IPhone"
	/// iPhone
	/// English String: "iPhone"
	/// </summary>
	public override string LabelIPhone => "iPhone";

	/// <summary>
	/// Key: "Label.IssueDescription"
	/// Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message.
	/// English String: "Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message."
	/// </summary>
	public override string LabelIssueDescription => "請描述您面臨的問題。請附上任何相關資訊，例如問題發生的所在及錯誤訊息文字。";

	/// <summary>
	/// Key: "Label.IWasScammed"
	/// I was Scammed
	/// English String: "I was Scammed"
	/// </summary>
	public override string LabelIWasScammed => "我遭到詐騙";

	/// <summary>
	/// Key: "Label.Mac"
	/// Mac
	/// English String: "Mac"
	/// </summary>
	public override string LabelMac => "Mac";

	/// <summary>
	/// Key: "Label.Membership"
	/// Support page. Membership {{dc.field_membership}} stop_memb.
	/// English String: "Membership"
	/// </summary>
	public override string LabelMembership => "會員資格";

	/// <summary>
	/// Key: "Label.Moderation"
	/// Moderation
	/// English String: "Moderation"
	/// </summary>
	public override string LabelModeration => "過濾";

	/// <summary>
	/// Key: "Label.OtherSiteClaim"
	/// Other Site Claim
	/// English String: "Other Site Claim"
	/// </summary>
	public override string LabelOtherSiteClaim => "其它網站聲明";

	/// <summary>
	/// Key: "Label.OwnerDMCAClaim"
	/// Owner DMCA Claim
	/// English String: "Owner DMCA Claim"
	/// </summary>
	public override string LabelOwnerDMCAClaim => "數位千禧年著作權法（DMCA）所有權人聲明";

	/// <summary>
	/// Key: "Label.PC"
	/// PC
	/// English String: "PC"
	/// </summary>
	public override string LabelPC => "個人電腦";

	/// <summary>
	/// Key: "Label.PhysicalToyIssue"
	/// Physical Toy Issue
	/// English String: "Physical Toy Issue"
	/// </summary>
	public override string LabelPhysicalToyIssue => "實體玩具問題";

	/// <summary>
	/// Key: "Label.PleaseSelect"
	/// Please Select...
	/// English String: "Please Select..."
	/// </summary>
	public override string LabelPleaseSelect => "請選擇…";

	/// <summary>
	/// Key: "Label.PrizeNotReceived"
	/// Prize Not Received
	/// English String: "Prize Not Received"
	/// </summary>
	public override string LabelPrizeNotReceived => "未收到獎項";

	/// <summary>
	/// Key: "Label.PurchaseDeclined"
	/// Purchase - Declined
	/// English String: "Purchase - Declined"
	/// </summary>
	public override string LabelPurchaseDeclined => "購買 - 遭拒";

	/// <summary>
	/// Key: "Label.PurchaseDidNotReceive"
	/// Purchase - Did Not Receive
	/// English String: "Purchase - Did Not Receive"
	/// </summary>
	public override string LabelPurchaseDidNotReceive => "購買 - 未收到";

	/// <summary>
	/// Key: "Label.PurchaseUnauthorizedCharge"
	/// Purchase - Unauthorized Charge
	/// English String: "Purchase - Unauthorized Charge"
	/// </summary>
	public override string LabelPurchaseUnauthorizedCharge => "購買 - 未授權收費";

	/// <summary>
	/// Key: "Label.ReportPhish"
	/// Report Phishing Site
	/// English String: "Report Phishing Site"
	/// </summary>
	public override string LabelReportPhish => "檢舉網路釣魚網站";

	/// <summary>
	/// Key: "Label.RobloxCrashing"
	/// Roblox Crashing
	/// English String: "Roblox Crashing"
	/// </summary>
	public override string LabelRobloxCrashing => "Roblox 當機";

	/// <summary>
	/// Key: "Label.RobloxToys"
	/// Roblox Toys
	/// English String: "Roblox Toys"
	/// </summary>
	public override string LabelRobloxToys => "Roblox 玩具";

	/// <summary>
	/// Key: "Label.Robux"
	/// Robux
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.RobuxPurchaseIssue"
	/// Robux - Purchase Issue
	/// English String: "Robux - Purchase Issue"
	/// </summary>
	public override string LabelRobuxPurchaseIssue => "Robux - 購買問題";

	/// <summary>
	/// Key: "Label.SafetyInquiry"
	/// Inappropriate game or user behavior
	/// English String: "Inappropriate game or user behavior"
	/// </summary>
	public override string LabelSafetyInquiry => "遊戲或使用者行為不當";

	/// <summary>
	/// Key: "Label.SafetyQueueTicket"
	/// User Safety Concern
	/// English String: "User Safety Concern"
	/// </summary>
	public override string LabelSafetyQueueTicket => "使用者安全疑慮";

	/// <summary>
	/// Key: "Label.SpecificGameIssue"
	/// Specific Game Issue
	/// English String: "Specific Game Issue"
	/// </summary>
	public override string LabelSpecificGameIssue => "特定遊戲問題";

	/// <summary>
	/// Key: "Label.Submit"
	/// Submit
	/// English String: "Submit"
	/// </summary>
	public override string LabelSubmit => "提交";

	/// <summary>
	/// Key: "Label.SuggestFeature"
	/// Feature Suggestion
	/// English String: "Feature Suggestion"
	/// </summary>
	public override string LabelSuggestFeature => "功能建議";

	/// <summary>
	/// Key: "Label.SuggestFeedback"
	/// Feedback
	/// English String: "Feedback"
	/// </summary>
	public override string LabelSuggestFeedback => "回饋";

	/// <summary>
	/// Key: "Label.TechnicalSupport"
	/// Technical Support
	/// English String: "Technical Support"
	/// </summary>
	public override string LabelTechnicalSupport => "技術協助";

	/// <summary>
	/// Key: "Label.ToyCodeIssue"
	/// Toy Code Issue
	/// English String: "Toy Code Issue"
	/// </summary>
	public override string LabelToyCodeIssue => "玩具代碼問題";

	/// <summary>
	/// Key: "Label.TwoStepV"
	/// 2-Step Verification
	/// English String: "2-Step Verification"
	/// </summary>
	public override string LabelTwoStepV => "雙步驟驗證";

	/// <summary>
	/// Key: "Label.UserAbuseReport"
	/// Report User Breaking Rules
	/// English String: "Report User Breaking Rules"
	/// </summary>
	public override string LabelUserAbuseReport => "舉報違規使用者";

	/// <summary>
	/// Key: "Label.Username"
	/// Username
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "使用者名稱";

	/// <summary>
	/// Key: "Label.VCCatalog"
	/// Website Item
	/// English String: "Website Item"
	/// </summary>
	public override string LabelVCCatalog => "網站道具";

	/// <summary>
	/// Key: "Label.VCInGame"
	/// In-Game Item
	/// English String: "In-Game Item"
	/// </summary>
	public override string LabelVCInGame => "遊戲中道具";

	/// <summary>
	/// Key: "Label.Xbox"
	/// Xbox
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "Response.Dialog.ErrorWithoutContext"
	/// Something went wrong, please try again later.
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogErrorWithoutContext => "發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "按下「傳送」提交聯絡單，或按下「取消」編輯使用者名稱。提供正確的使用者名稱能讓我更快解決您的問題。";

	/// <summary>
	/// Key: "Response.Dialog.RequestReceived"
	/// Thank you for contacting Roblox. Please check your email for a message from Customer Service.
	/// English String: "Thank you for contacting Roblox. Please check your email for a message from Customer Service."
	/// </summary>
	public override string ResponseDialogRequestReceived => "謝謝您聯絡 Roblox，客服人員將盡速透過電子郵件回覆您。";

	/// <summary>
	/// Key: "Response.Dialog.TooManyAttemptsError"
	/// Too many attempts. Try again later.
	/// English String: "Too many attempts. Try again later."
	/// </summary>
	public override string ResponseDialogTooManyAttemptsError => "嘗試次數過多，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.TryAgainError"
	/// An error occurred. Try again later.
	/// English String: "An error occurred. Try again later."
	/// </summary>
	public override string ResponseDialogTryAgainError => "發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.EmailFormatError"
	/// Please enter a properly formatted email address
	/// English String: "Please enter a properly formatted email address"
	/// </summary>
	public override string ResponseEmailFormatError => "請輸入格式正確的電子郵件地址";

	/// <summary>
	/// Key: "Response.EmailNotMatching"
	/// Email address does not match
	/// English String: "Email address does not match"
	/// </summary>
	public override string ResponseEmailNotMatching => "電子郵件地址不符";

	/// <summary>
	/// Key: "Response.InvalidFirstName"
	/// Please enter a valid first name
	/// English String: "Please enter a valid first name"
	/// </summary>
	public override string ResponseInvalidFirstName => "請輸入有效名字";

	/// <summary>
	/// Key: "Response.InvalidUsername"
	/// That doesn't appear to be a valid Roblox username.
	/// English String: "That doesn't appear to be a valid Roblox username."
	/// </summary>
	public override string ResponseInvalidUsername => "Roblox 使用者名稱無效。";

	/// <summary>
	/// Key: "Response.Under13Email"
	/// If you are under 13 years old, please provide your parent's email address
	/// English String: "If you are under 13 years old, please provide your parent's email address"
	/// </summary>
	public override string ResponseUnder13Email => "若您 13 歲以下，請提供您的家長的電子郵件地址";

	public SupportResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogOK()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "傳送";
	}

	protected override string _GetTemplateForHeadingContactInformation()
	{
		return "聯絡資訊";
	}

	protected override string _GetTemplateForHeadingDescriptionOfIssue()
	{
		return "問題說明";
	}

	protected override string _GetTemplateForHeadingDeviceWithProblem()
	{
		return "您遇到問題的裝置是？";
	}

	protected override string _GetTemplateForHeadingDialogErrorWithoutContext()
	{
		return "錯誤";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "使用者名稱無效";
	}

	protected override string _GetTemplateForHeadingDialogRequestReceived()
	{
		return "已收到請求";
	}

	protected override string _GetTemplateForHeadingHelpCategoryType()
	{
		return "說明類別的種類";
	}

	protected override string _GetTemplateForHeadingIssueDetails()
	{
		return "問題詳細資料";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "聯絡我們";
	}

	protected override string _GetTemplateForLabelAccountHacked()
	{
		return "帳號遭駭";
	}

	protected override string _GetTemplateForLabelAccountOwnership()
	{
		return "帳號遭駭或無法登入";
	}

	protected override string _GetTemplateForLabelAccountPin()
	{
		return "帳號 PIN";
	}

	protected override string _GetTemplateForLabelAdjustChildSettings()
	{
		return "調整兒童隱私權及安全設定";
	}

	protected override string _GetTemplateForLabelAmazonDevice()
	{
		return "Amazon 裝置";
	}

	protected override string _GetTemplateForLabelAndroidPhone()
	{
		return "Android 手機";
	}

	protected override string _GetTemplateForLabelAndroidTablet()
	{
		return "Android 平板電腦";
	}

	protected override string _GetTemplateForLabelAppealAccountContent()
	{
		return "帳號或內容上訴";
	}

	protected override string _GetTemplateForLabelAppealFriend()
	{
		return "為好友上訴";
	}

	protected override string _GetTemplateForLabelBilling()
	{
		return "帳務和付款";
	}

	protected override string _GetTemplateForLabelBugReport()
	{
		return "舉報漏洞";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelCancelMembership()
	{
		return "取消會員資格";
	}

	protected override string _GetTemplateForLabelCannotInstall()
	{
		return "無法安裝 Roblox 或 Studio";
	}

	protected override string _GetTemplateForLabelCannotPlayGame()
	{
		return "無法玩遊戲";
	}

	protected override string _GetTemplateForLabelChangeChildAge()
	{
		return "變更兒童年齡";
	}

	protected override string _GetTemplateForLabelChatAgeSettings()
	{
		return "聊天與年齡設定";
	}

	protected override string _GetTemplateForLabelChromebook()
	{
		return "Chromebook";
	}

	protected override string _GetTemplateForLabelConfirmEmail()
	{
		return "確認電子郵件地址";
	}

	protected override string _GetTemplateForLabelContentAbuseReport()
	{
		return "舉報違規內容";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "比賽及活動";
	}

	protected override string _GetTemplateForLabelContestEventQuestion()
	{
		return "問題或困難";
	}

	protected override string _GetTemplateForLabelCSCharacter()
	{
		return "客服人員角色";
	}

	protected override string _GetTemplateForLabelDescribeIssue()
	{
		return "請描述您的問題";
	}

	protected override string _GetTemplateForLabelDevEx()
	{
		return "DevEx";
	}

	protected override string _GetTemplateForLabelDevExHowTo()
	{
		return "DevEx 說明";
	}

	protected override string _GetTemplateForLabelDevExMyRequest()
	{
		return "DevEx 我的請求";
	}

	protected override string _GetTemplateForLabelDMCA()
	{
		return "數位千禧年著作權法（DMCA）";
	}

	protected override string _GetTemplateForLabelEmailAddress()
	{
		return "電子郵件地址";
	}

	protected override string _GetTemplateForLabelExploitReport()
	{
		return "舉報外掛";
	}

	protected override string _GetTemplateForLabelFirstName()
	{
		return "名字";
	}

	protected override string _GetTemplateForLabelForgotPassword()
	{
		return "忘記密碼";
	}

	protected override string _GetTemplateForLabelFreeRobux()
	{
		return "免費 Robux";
	}

	protected override string _GetTemplateForLabelGameCredit()
	{
		return "點數卡";
	}

	protected override string _GetTemplateForLabelGCPartialPayment()
	{
		return "購買 - 拆分付款";
	}

	protected override string _GetTemplateForLabelGCRedeem()
	{
		return "點數卡 - 兌換";
	}

	protected override string _GetTemplateForLabelGCSpendCredit()
	{
		return "點數卡 - 使用點數";
	}

	protected override string _GetTemplateForLabelHowTo()
	{
		return "說明";
	}

	protected override string _GetTemplateForLabelHowToGeneral()
	{
		return "說明 - 一般";
	}

	protected override string _GetTemplateForLabelHowToOther()
	{
		return "說明 - 其它";
	}

	protected override string _GetTemplateForLabelIdeasSuggestions()
	{
		return "建議";
	}

	protected override string _GetTemplateForLabelIPad()
	{
		return "iPad";
	}

	protected override string _GetTemplateForLabelIPhone()
	{
		return "iPhone";
	}

	protected override string _GetTemplateForLabelIssueDescription()
	{
		return "請描述您面臨的問題。請附上任何相關資訊，例如問題發生的所在及錯誤訊息文字。";
	}

	protected override string _GetTemplateForLabelIWasScammed()
	{
		return "我遭到詐騙";
	}

	protected override string _GetTemplateForLabelMac()
	{
		return "Mac";
	}

	protected override string _GetTemplateForLabelMembership()
	{
		return "會員資格";
	}

	protected override string _GetTemplateForLabelModeration()
	{
		return "過濾";
	}

	protected override string _GetTemplateForLabelOtherSiteClaim()
	{
		return "其它網站聲明";
	}

	protected override string _GetTemplateForLabelOwnerDMCAClaim()
	{
		return "數位千禧年著作權法（DMCA）所有權人聲明";
	}

	protected override string _GetTemplateForLabelPC()
	{
		return "個人電腦";
	}

	protected override string _GetTemplateForLabelPhysicalToyIssue()
	{
		return "實體玩具問題";
	}

	protected override string _GetTemplateForLabelPleaseSelect()
	{
		return "請選擇…";
	}

	protected override string _GetTemplateForLabelPrizeNotReceived()
	{
		return "未收到獎項";
	}

	protected override string _GetTemplateForLabelPurchaseDeclined()
	{
		return "購買 - 遭拒";
	}

	protected override string _GetTemplateForLabelPurchaseDidNotReceive()
	{
		return "購買 - 未收到";
	}

	protected override string _GetTemplateForLabelPurchaseUnauthorizedCharge()
	{
		return "購買 - 未授權收費";
	}

	protected override string _GetTemplateForLabelReportPhish()
	{
		return "檢舉網路釣魚網站";
	}

	protected override string _GetTemplateForLabelRobloxCrashing()
	{
		return "Roblox 當機";
	}

	protected override string _GetTemplateForLabelRobloxToys()
	{
		return "Roblox 玩具";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelRobuxPurchaseIssue()
	{
		return "Robux - 購買問題";
	}

	protected override string _GetTemplateForLabelSafetyInquiry()
	{
		return "遊戲或使用者行為不當";
	}

	protected override string _GetTemplateForLabelSafetyQueueTicket()
	{
		return "使用者安全疑慮";
	}

	protected override string _GetTemplateForLabelSpecificGameIssue()
	{
		return "特定遊戲問題";
	}

	protected override string _GetTemplateForLabelSubmit()
	{
		return "提交";
	}

	protected override string _GetTemplateForLabelSuggestFeature()
	{
		return "功能建議";
	}

	protected override string _GetTemplateForLabelSuggestFeedback()
	{
		return "回饋";
	}

	protected override string _GetTemplateForLabelTechnicalSupport()
	{
		return "技術協助";
	}

	protected override string _GetTemplateForLabelToyCodeIssue()
	{
		return "玩具代碼問題";
	}

	protected override string _GetTemplateForLabelTwoStepV()
	{
		return "雙步驟驗證";
	}

	protected override string _GetTemplateForLabelUserAbuseReport()
	{
		return "舉報違規使用者";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "使用者名稱";
	}

	protected override string _GetTemplateForLabelVCCatalog()
	{
		return "網站道具";
	}

	protected override string _GetTemplateForLabelVCInGame()
	{
		return "遊戲中道具";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForResponseDialogErrorWithoutContext()
	{
		return "發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "按下「傳送」提交聯絡單，或按下「取消」編輯使用者名稱。提供正確的使用者名稱能讓我更快解決您的問題。";
	}

	protected override string _GetTemplateForResponseDialogRequestReceived()
	{
		return "謝謝您聯絡 Roblox，客服人員將盡速透過電子郵件回覆您。";
	}

	protected override string _GetTemplateForResponseDialogTooManyAttemptsError()
	{
		return "嘗試次數過多，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogTryAgainError()
	{
		return "發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseEmailFormatError()
	{
		return "請輸入格式正確的電子郵件地址";
	}

	protected override string _GetTemplateForResponseEmailNotMatching()
	{
		return "電子郵件地址不符";
	}

	protected override string _GetTemplateForResponseInvalidFirstName()
	{
		return "請輸入有效名字";
	}

	protected override string _GetTemplateForResponseInvalidUsername()
	{
		return "Roblox 使用者名稱無效。";
	}

	protected override string _GetTemplateForResponseUnder13Email()
	{
		return "若您 13 歲以下，請提供您的家長的電子郵件地址";
	}
}
