namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SupportResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SupportResources_pt_br : SupportResources_en_us, ISupportResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.OK"
	/// OK
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogOK => "OK";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Enviar";

	/// <summary>
	/// Key: "Heading.ContactInformation"
	/// Contact Information
	/// English String: "Contact Information"
	/// </summary>
	public override string HeadingContactInformation => "Informações de contato";

	/// <summary>
	/// Key: "Heading.DescriptionOfIssue"
	/// Description of issue
	/// English String: "Description of issue"
	/// </summary>
	public override string HeadingDescriptionOfIssue => "Descrição do problema";

	/// <summary>
	/// Key: "Heading.DeviceWithProblem"
	/// What device are you having the problem on?
	/// English String: "What device are you having the problem on?"
	/// </summary>
	public override string HeadingDeviceWithProblem => "Em que dispositivo você está tendo problemas?";

	/// <summary>
	/// Key: "Heading.Dialog.ErrorWithoutContext"
	/// Error
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogErrorWithoutContext => "Erro";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nome de usuário inválido";

	/// <summary>
	/// Key: "Heading.Dialog.RequestReceived"
	/// Request Received
	/// English String: "Request Received"
	/// </summary>
	public override string HeadingDialogRequestReceived => "Solicitação recebida";

	/// <summary>
	/// Key: "Heading.HelpCategoryType"
	/// Type of help category
	/// English String: "Type of help category"
	/// </summary>
	public override string HeadingHelpCategoryType => "Tipo de categoria de ajuda";

	/// <summary>
	/// Key: "Heading.IssueDetails"
	/// Issue Details
	/// English String: "Issue Details"
	/// </summary>
	public override string HeadingIssueDetails => "Detalhes do problema";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// Contact Us
	/// English String: "Contact Us"
	/// </summary>
	public override string HeadingPageTitle => "Fale conosco";

	/// <summary>
	/// Key: "Label.AccountHacked"
	/// Account Hacked
	/// English String: "Account Hacked"
	/// </summary>
	public override string LabelAccountHacked => "Conta hackeada";

	/// <summary>
	/// Key: "Label.AccountOwnership"
	/// Account Hacked or Can't Log in
	/// English String: "Account Hacked or Can't Log in"
	/// </summary>
	public override string LabelAccountOwnership => "Conta hackeada ou impossível se conectar";

	/// <summary>
	/// Key: "Label.AccountPin"
	/// Account PIN
	/// English String: "Account PIN"
	/// </summary>
	public override string LabelAccountPin => "PIN da conta";

	public override string LabelAdjustChildSettings => "Ajustar as configurações de segurança e privacidade da criança";

	/// <summary>
	/// Key: "Label.AmazonDevice"
	/// Amazon Device
	/// English String: "Amazon Device"
	/// </summary>
	public override string LabelAmazonDevice => "Dispositivo Amazon";

	/// <summary>
	/// Key: "Label.AndroidPhone"
	/// Android Phone
	/// English String: "Android Phone"
	/// </summary>
	public override string LabelAndroidPhone => "Telefone Android";

	/// <summary>
	/// Key: "Label.AndroidTablet"
	/// Android Tablet
	/// English String: "Android Tablet"
	/// </summary>
	public override string LabelAndroidTablet => "Tablet Android";

	/// <summary>
	/// Key: "Label.AppealAccountContent"
	/// Appeal Account or Content
	/// English String: "Appeal Account or Content"
	/// </summary>
	public override string LabelAppealAccountContent => "Apelação de conta ou conteúdo";

	/// <summary>
	/// Key: "Label.AppealFriend"
	/// Appeal for Friend
	/// English String: "Appeal for Friend"
	/// </summary>
	public override string LabelAppealFriend => "Apelação para um amigo";

	public override string LabelBilling => "Cobrança e pagamentos";

	/// <summary>
	/// Key: "Label.BugReport"
	/// Bug Report
	/// English String: "Bug Report"
	/// </summary>
	public override string LabelBugReport => "Relatório de erros";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// Builders Club
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.CancelMembership"
	/// Cancel Membership
	/// English String: "Cancel Membership"
	/// </summary>
	public override string LabelCancelMembership => "Cancelar assinatura";

	/// <summary>
	/// Key: "Label.CannotInstall"
	/// Cannot Install Roblox or Studio
	/// English String: "Cannot Install Roblox or Studio"
	/// </summary>
	public override string LabelCannotInstall => "Impossível instalar Roblox ou Studio";

	/// <summary>
	/// Key: "Label.CannotPlayGame"
	/// Cannot Play Game
	/// English String: "Cannot Play Game"
	/// </summary>
	public override string LabelCannotPlayGame => "Impossível jogar jogo";

	/// <summary>
	/// Key: "Label.ChangeChildAge"
	/// Change Child Age
	/// English String: "Change Child Age"
	/// </summary>
	public override string LabelChangeChildAge => "Alterar idade da criança";

	public override string LabelChatAgeSettings => "Configurações de chat e idade";

	/// <summary>
	/// Key: "Label.Chromebook"
	/// Chromebook
	/// English String: "Chromebook"
	/// </summary>
	public override string LabelChromebook => "Chromebook";

	/// <summary>
	/// Key: "Label.ConfirmEmail"
	/// Confirm Email Address
	/// English String: "Confirm Email Address"
	/// </summary>
	public override string LabelConfirmEmail => "Confirmar endereço de e-mail";

	/// <summary>
	/// Key: "Label.ContentAbuseReport"
	/// Report Content Breaking Rules
	/// English String: "Report Content Breaking Rules"
	/// </summary>
	public override string LabelContentAbuseReport => "Denunciar conteúdo por quebrar as regras";

	public override string LabelContest => "Concursos e eventos";

	/// <summary>
	/// Key: "Label.ContestEventQuestion"
	/// Question or Issue
	/// English String: "Question or Issue"
	/// </summary>
	public override string LabelContestEventQuestion => "Pergunta ou problema";

	/// <summary>
	/// Key: "Label.CSCharacter"
	/// Customer Service Character
	/// English String: "Customer Service Character"
	/// </summary>
	public override string LabelCSCharacter => "Customer Service Character";

	/// <summary>
	/// Key: "Label.DescribeIssue"
	/// Please describe your issue
	/// English String: "Please describe your issue"
	/// </summary>
	public override string LabelDescribeIssue => "Descreva seu problema";

	/// <summary>
	/// Key: "Label.DevEx"
	/// DevEx
	/// English String: "DevEx"
	/// </summary>
	public override string LabelDevEx => "DevEx";

	/// <summary>
	/// Key: "Label.DevExHowTo"
	/// DevEx How To
	/// English String: "DevEx How To"
	/// </summary>
	public override string LabelDevExHowTo => "Como fazer do DevEx";

	/// <summary>
	/// Key: "Label.DevExMyRequest"
	/// DevEx My Request
	/// English String: "DevEx My Request"
	/// </summary>
	public override string LabelDevExMyRequest => "Minha solicitação do DevEx";

	/// <summary>
	/// Key: "Label.DMCA"
	/// DMCA
	/// English String: "DMCA"
	/// </summary>
	public override string LabelDMCA => "DMCA";

	/// <summary>
	/// Key: "Label.EmailAddress"
	/// Email Address
	/// English String: "Email Address"
	/// </summary>
	public override string LabelEmailAddress => "Endereço de e-mail";

	/// <summary>
	/// Key: "Label.ExploitReport"
	/// Exploit Report
	/// English String: "Exploit Report"
	/// </summary>
	public override string LabelExploitReport => "Denuncia de exploração indevida";

	/// <summary>
	/// Key: "Label.FirstName"
	/// First Name
	/// English String: "First Name"
	/// </summary>
	public override string LabelFirstName => "Nome";

	/// <summary>
	/// Key: "Label.ForgotPassword"
	/// Forgot Password
	/// English String: "Forgot Password"
	/// </summary>
	public override string LabelForgotPassword => "Esqueci a senha";

	/// <summary>
	/// Key: "Label.FreeRobux"
	/// Free Robux
	/// English String: "Free Robux"
	/// </summary>
	public override string LabelFreeRobux => "Robux grátis";

	/// <summary>
	/// Key: "Label.GameCredit"
	/// Game Card
	/// English String: "Game Card"
	/// </summary>
	public override string LabelGameCredit => "Cartão do jogo";

	/// <summary>
	/// Key: "Label.GCPartialPayment"
	/// Purchase - Split Payment
	/// English String: "Purchase - Split Payment"
	/// </summary>
	public override string LabelGCPartialPayment => "Compra - Dividir pagamento";

	/// <summary>
	/// Key: "Label.GCRedeem"
	/// Game Card - Redeem
	/// English String: "Game Card - Redeem"
	/// </summary>
	public override string LabelGCRedeem => "Cartão do jogo - Retirar";

	/// <summary>
	/// Key: "Label.GCSpendCredit"
	/// Game Card - Spend Credit
	/// English String: "Game Card - Spend Credit"
	/// </summary>
	public override string LabelGCSpendCredit => "Cartão do jogo - Gastar créditos";

	/// <summary>
	/// Key: "Label.HowTo"
	/// How To
	/// English String: "How To"
	/// </summary>
	public override string LabelHowTo => "Como fazer";

	/// <summary>
	/// Key: "Label.HowToGeneral"
	/// How To - General
	/// English String: "How To - General"
	/// </summary>
	public override string LabelHowToGeneral => "Como fazer - Geral";

	/// <summary>
	/// Key: "Label.HowToOther"
	/// How To - Other
	/// English String: "How To - Other"
	/// </summary>
	public override string LabelHowToOther => "Como fazer - Outros";

	public override string LabelIdeasSuggestions => "Ideias e sugestões";

	/// <summary>
	/// Key: "Label.IPad"
	/// iPad
	/// English String: "iPad"
	/// </summary>
	public override string LabelIPad => "iPad";

	/// <summary>
	/// Key: "Label.IPhone"
	/// iPhone
	/// English String: "iPhone"
	/// </summary>
	public override string LabelIPhone => "iPhone";

	/// <summary>
	/// Key: "Label.IssueDescription"
	/// Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message.
	/// English String: "Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message."
	/// </summary>
	public override string LabelIssueDescription => "Descreva o problema que você está enfrentando. Inclua todas as informações relevantes, como onde está ocorrendo o problema ou mensagem de erro.";

	/// <summary>
	/// Key: "Label.IWasScammed"
	/// I was Scammed
	/// English String: "I was Scammed"
	/// </summary>
	public override string LabelIWasScammed => "Fui vítima de um esquema malicioso";

	/// <summary>
	/// Key: "Label.Mac"
	/// Mac
	/// English String: "Mac"
	/// </summary>
	public override string LabelMac => "Mac";

	/// <summary>
	/// Key: "Label.Membership"
	/// Support page. Membership {{dc.field_membership}} stop_memb.
	/// English String: "Membership"
	/// </summary>
	public override string LabelMembership => "Assinatura";

	/// <summary>
	/// Key: "Label.Moderation"
	/// Moderation
	/// English String: "Moderation"
	/// </summary>
	public override string LabelModeration => "Moderação";

	/// <summary>
	/// Key: "Label.OtherSiteClaim"
	/// Other Site Claim
	/// English String: "Other Site Claim"
	/// </summary>
	public override string LabelOtherSiteClaim => "Reivindicação de outro site";

	/// <summary>
	/// Key: "Label.OwnerDMCAClaim"
	/// Owner DMCA Claim
	/// English String: "Owner DMCA Claim"
	/// </summary>
	public override string LabelOwnerDMCAClaim => "Reivindicação de DMCA do dono";

	/// <summary>
	/// Key: "Label.PC"
	/// PC
	/// English String: "PC"
	/// </summary>
	public override string LabelPC => "PC";

	/// <summary>
	/// Key: "Label.PhysicalToyIssue"
	/// Physical Toy Issue
	/// English String: "Physical Toy Issue"
	/// </summary>
	public override string LabelPhysicalToyIssue => "Problema com brinquedo físico";

	/// <summary>
	/// Key: "Label.PleaseSelect"
	/// Please Select...
	/// English String: "Please Select..."
	/// </summary>
	public override string LabelPleaseSelect => "Selecione...";

	/// <summary>
	/// Key: "Label.PrizeNotReceived"
	/// Prize Not Received
	/// English String: "Prize Not Received"
	/// </summary>
	public override string LabelPrizeNotReceived => "Prêmio não recebido";

	/// <summary>
	/// Key: "Label.PurchaseDeclined"
	/// Purchase - Declined
	/// English String: "Purchase - Declined"
	/// </summary>
	public override string LabelPurchaseDeclined => "Compra - Recusada";

	/// <summary>
	/// Key: "Label.PurchaseDidNotReceive"
	/// Purchase - Did Not Receive
	/// English String: "Purchase - Did Not Receive"
	/// </summary>
	public override string LabelPurchaseDidNotReceive => "Compra - Produto não recebido";

	/// <summary>
	/// Key: "Label.PurchaseUnauthorizedCharge"
	/// Purchase - Unauthorized Charge
	/// English String: "Purchase - Unauthorized Charge"
	/// </summary>
	public override string LabelPurchaseUnauthorizedCharge => "Compra - Cobrança não autorizada";

	/// <summary>
	/// Key: "Label.ReportPhish"
	/// Report Phishing Site
	/// English String: "Report Phishing Site"
	/// </summary>
	public override string LabelReportPhish => "Denunciar site de phishing";

	/// <summary>
	/// Key: "Label.RobloxCrashing"
	/// Roblox Crashing
	/// English String: "Roblox Crashing"
	/// </summary>
	public override string LabelRobloxCrashing => "Pane no Roblox";

	/// <summary>
	/// Key: "Label.RobloxToys"
	/// Roblox Toys
	/// English String: "Roblox Toys"
	/// </summary>
	public override string LabelRobloxToys => "Brinquedos Roblox";

	/// <summary>
	/// Key: "Label.Robux"
	/// Robux
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.RobuxPurchaseIssue"
	/// Robux - Purchase Issue
	/// English String: "Robux - Purchase Issue"
	/// </summary>
	public override string LabelRobuxPurchaseIssue => "Robux - Problema na compra";

	/// <summary>
	/// Key: "Label.SafetyInquiry"
	/// Inappropriate game or user behavior
	/// English String: "Inappropriate game or user behavior"
	/// </summary>
	public override string LabelSafetyInquiry => "Comportamento de usuário ou jogo inapropriado";

	/// <summary>
	/// Key: "Label.SafetyQueueTicket"
	/// User Safety Concern
	/// English String: "User Safety Concern"
	/// </summary>
	public override string LabelSafetyQueueTicket => "Cuidados com a segurança do usuário";

	/// <summary>
	/// Key: "Label.SpecificGameIssue"
	/// Specific Game Issue
	/// English String: "Specific Game Issue"
	/// </summary>
	public override string LabelSpecificGameIssue => "Problema específico no jogo";

	/// <summary>
	/// Key: "Label.Submit"
	/// Submit
	/// English String: "Submit"
	/// </summary>
	public override string LabelSubmit => "Enviar";

	/// <summary>
	/// Key: "Label.SuggestFeature"
	/// Feature Suggestion
	/// English String: "Feature Suggestion"
	/// </summary>
	public override string LabelSuggestFeature => "Sugestão de funcionalidade";

	/// <summary>
	/// Key: "Label.SuggestFeedback"
	/// Feedback
	/// English String: "Feedback"
	/// </summary>
	public override string LabelSuggestFeedback => "Opinião";

	/// <summary>
	/// Key: "Label.TechnicalSupport"
	/// Technical Support
	/// English String: "Technical Support"
	/// </summary>
	public override string LabelTechnicalSupport => "Suporte técnico";

	/// <summary>
	/// Key: "Label.ToyCodeIssue"
	/// Toy Code Issue
	/// English String: "Toy Code Issue"
	/// </summary>
	public override string LabelToyCodeIssue => "Problema com código do brinquedo";

	/// <summary>
	/// Key: "Label.TwoStepV"
	/// 2-Step Verification
	/// English String: "2-Step Verification"
	/// </summary>
	public override string LabelTwoStepV => "Verificação de 2 passos";

	/// <summary>
	/// Key: "Label.UserAbuseReport"
	/// Report User Breaking Rules
	/// English String: "Report User Breaking Rules"
	/// </summary>
	public override string LabelUserAbuseReport => "Denunciar usuário por quebrar as regras";

	/// <summary>
	/// Key: "Label.Username"
	/// Username
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Nome de usuário";

	/// <summary>
	/// Key: "Label.VCCatalog"
	/// Website Item
	/// English String: "Website Item"
	/// </summary>
	public override string LabelVCCatalog => "Item do website";

	/// <summary>
	/// Key: "Label.VCInGame"
	/// In-Game Item
	/// English String: "In-Game Item"
	/// </summary>
	public override string LabelVCInGame => "Item do jogo";

	/// <summary>
	/// Key: "Label.Xbox"
	/// Xbox
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "Response.Dialog.ErrorWithoutContext"
	/// Something went wrong, please try again later.
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogErrorWithoutContext => "Algo deu errado. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Aperte Enviar para enviar a solicitação ou Cancelar para editar o nome de usuário. O nome de usuário é uma informação muito importante e pode ajudar a resolver seu problema mais rápido.";

	/// <summary>
	/// Key: "Response.Dialog.RequestReceived"
	/// Thank you for contacting Roblox. Please check your email for a message from Customer Service.
	/// English String: "Thank you for contacting Roblox. Please check your email for a message from Customer Service."
	/// </summary>
	public override string ResponseDialogRequestReceived => "Obrigado por contatar Roblox. Confira o seu e-mail para encontrar uma mensagem do Serviço ao Cliente.";

	/// <summary>
	/// Key: "Response.Dialog.TooManyAttemptsError"
	/// Too many attempts. Try again later.
	/// English String: "Too many attempts. Try again later."
	/// </summary>
	public override string ResponseDialogTooManyAttemptsError => "Tentativas excessivas. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.TryAgainError"
	/// An error occurred. Try again later.
	/// English String: "An error occurred. Try again later."
	/// </summary>
	public override string ResponseDialogTryAgainError => "Ocorreu um erro. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.EmailFormatError"
	/// Please enter a properly formatted email address
	/// English String: "Please enter a properly formatted email address"
	/// </summary>
	public override string ResponseEmailFormatError => "Insira um endereço de e-mail com formato correto";

	/// <summary>
	/// Key: "Response.EmailNotMatching"
	/// Email address does not match
	/// English String: "Email address does not match"
	/// </summary>
	public override string ResponseEmailNotMatching => "Endereço de e-mail não confere";

	/// <summary>
	/// Key: "Response.InvalidFirstName"
	/// Please enter a valid first name
	/// English String: "Please enter a valid first name"
	/// </summary>
	public override string ResponseInvalidFirstName => "Insira um nome válido";

	/// <summary>
	/// Key: "Response.InvalidUsername"
	/// That doesn't appear to be a valid Roblox username.
	/// English String: "That doesn't appear to be a valid Roblox username."
	/// </summary>
	public override string ResponseInvalidUsername => "Este não parece ser um nome de usuário do Roblox válido.";

	/// <summary>
	/// Key: "Response.Under13Email"
	/// If you are under 13 years old, please provide your parent's email address
	/// English String: "If you are under 13 years old, please provide your parent's email address"
	/// </summary>
	public override string ResponseUnder13Email => "Se você tiver menos de 13 anos, forneça o endereço de e-mail do responsável";

	public SupportResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogOK()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForHeadingContactInformation()
	{
		return "Informações de contato";
	}

	protected override string _GetTemplateForHeadingDescriptionOfIssue()
	{
		return "Descrição do problema";
	}

	protected override string _GetTemplateForHeadingDeviceWithProblem()
	{
		return "Em que dispositivo você está tendo problemas?";
	}

	protected override string _GetTemplateForHeadingDialogErrorWithoutContext()
	{
		return "Erro";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nome de usuário inválido";
	}

	protected override string _GetTemplateForHeadingDialogRequestReceived()
	{
		return "Solicitação recebida";
	}

	protected override string _GetTemplateForHeadingHelpCategoryType()
	{
		return "Tipo de categoria de ajuda";
	}

	protected override string _GetTemplateForHeadingIssueDetails()
	{
		return "Detalhes do problema";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Fale conosco";
	}

	protected override string _GetTemplateForLabelAccountHacked()
	{
		return "Conta hackeada";
	}

	protected override string _GetTemplateForLabelAccountOwnership()
	{
		return "Conta hackeada ou impossível se conectar";
	}

	protected override string _GetTemplateForLabelAccountPin()
	{
		return "PIN da conta";
	}

	protected override string _GetTemplateForLabelAdjustChildSettings()
	{
		return "Ajustar as configurações de segurança e privacidade da criança";
	}

	protected override string _GetTemplateForLabelAmazonDevice()
	{
		return "Dispositivo Amazon";
	}

	protected override string _GetTemplateForLabelAndroidPhone()
	{
		return "Telefone Android";
	}

	protected override string _GetTemplateForLabelAndroidTablet()
	{
		return "Tablet Android";
	}

	protected override string _GetTemplateForLabelAppealAccountContent()
	{
		return "Apelação de conta ou conteúdo";
	}

	protected override string _GetTemplateForLabelAppealFriend()
	{
		return "Apelação para um amigo";
	}

	protected override string _GetTemplateForLabelBilling()
	{
		return "Cobrança e pagamentos";
	}

	protected override string _GetTemplateForLabelBugReport()
	{
		return "Relatório de erros";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelCancelMembership()
	{
		return "Cancelar assinatura";
	}

	protected override string _GetTemplateForLabelCannotInstall()
	{
		return "Impossível instalar Roblox ou Studio";
	}

	protected override string _GetTemplateForLabelCannotPlayGame()
	{
		return "Impossível jogar jogo";
	}

	protected override string _GetTemplateForLabelChangeChildAge()
	{
		return "Alterar idade da criança";
	}

	protected override string _GetTemplateForLabelChatAgeSettings()
	{
		return "Configurações de chat e idade";
	}

	protected override string _GetTemplateForLabelChromebook()
	{
		return "Chromebook";
	}

	protected override string _GetTemplateForLabelConfirmEmail()
	{
		return "Confirmar endereço de e-mail";
	}

	protected override string _GetTemplateForLabelContentAbuseReport()
	{
		return "Denunciar conteúdo por quebrar as regras";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Concursos e eventos";
	}

	protected override string _GetTemplateForLabelContestEventQuestion()
	{
		return "Pergunta ou problema";
	}

	protected override string _GetTemplateForLabelCSCharacter()
	{
		return "Customer Service Character";
	}

	protected override string _GetTemplateForLabelDescribeIssue()
	{
		return "Descreva seu problema";
	}

	protected override string _GetTemplateForLabelDevEx()
	{
		return "DevEx";
	}

	protected override string _GetTemplateForLabelDevExHowTo()
	{
		return "Como fazer do DevEx";
	}

	protected override string _GetTemplateForLabelDevExMyRequest()
	{
		return "Minha solicitação do DevEx";
	}

	protected override string _GetTemplateForLabelDMCA()
	{
		return "DMCA";
	}

	protected override string _GetTemplateForLabelEmailAddress()
	{
		return "Endereço de e-mail";
	}

	protected override string _GetTemplateForLabelExploitReport()
	{
		return "Denuncia de exploração indevida";
	}

	protected override string _GetTemplateForLabelFirstName()
	{
		return "Nome";
	}

	protected override string _GetTemplateForLabelForgotPassword()
	{
		return "Esqueci a senha";
	}

	protected override string _GetTemplateForLabelFreeRobux()
	{
		return "Robux grátis";
	}

	protected override string _GetTemplateForLabelGameCredit()
	{
		return "Cartão do jogo";
	}

	protected override string _GetTemplateForLabelGCPartialPayment()
	{
		return "Compra - Dividir pagamento";
	}

	protected override string _GetTemplateForLabelGCRedeem()
	{
		return "Cartão do jogo - Retirar";
	}

	protected override string _GetTemplateForLabelGCSpendCredit()
	{
		return "Cartão do jogo - Gastar créditos";
	}

	protected override string _GetTemplateForLabelHowTo()
	{
		return "Como fazer";
	}

	protected override string _GetTemplateForLabelHowToGeneral()
	{
		return "Como fazer - Geral";
	}

	protected override string _GetTemplateForLabelHowToOther()
	{
		return "Como fazer - Outros";
	}

	protected override string _GetTemplateForLabelIdeasSuggestions()
	{
		return "Ideias e sugestões";
	}

	protected override string _GetTemplateForLabelIPad()
	{
		return "iPad";
	}

	protected override string _GetTemplateForLabelIPhone()
	{
		return "iPhone";
	}

	protected override string _GetTemplateForLabelIssueDescription()
	{
		return "Descreva o problema que você está enfrentando. Inclua todas as informações relevantes, como onde está ocorrendo o problema ou mensagem de erro.";
	}

	protected override string _GetTemplateForLabelIWasScammed()
	{
		return "Fui vítima de um esquema malicioso";
	}

	protected override string _GetTemplateForLabelMac()
	{
		return "Mac";
	}

	protected override string _GetTemplateForLabelMembership()
	{
		return "Assinatura";
	}

	protected override string _GetTemplateForLabelModeration()
	{
		return "Moderação";
	}

	protected override string _GetTemplateForLabelOtherSiteClaim()
	{
		return "Reivindicação de outro site";
	}

	protected override string _GetTemplateForLabelOwnerDMCAClaim()
	{
		return "Reivindicação de DMCA do dono";
	}

	protected override string _GetTemplateForLabelPC()
	{
		return "PC";
	}

	protected override string _GetTemplateForLabelPhysicalToyIssue()
	{
		return "Problema com brinquedo físico";
	}

	protected override string _GetTemplateForLabelPleaseSelect()
	{
		return "Selecione...";
	}

	protected override string _GetTemplateForLabelPrizeNotReceived()
	{
		return "Prêmio não recebido";
	}

	protected override string _GetTemplateForLabelPurchaseDeclined()
	{
		return "Compra - Recusada";
	}

	protected override string _GetTemplateForLabelPurchaseDidNotReceive()
	{
		return "Compra - Produto não recebido";
	}

	protected override string _GetTemplateForLabelPurchaseUnauthorizedCharge()
	{
		return "Compra - Cobrança não autorizada";
	}

	protected override string _GetTemplateForLabelReportPhish()
	{
		return "Denunciar site de phishing";
	}

	protected override string _GetTemplateForLabelRobloxCrashing()
	{
		return "Pane no Roblox";
	}

	protected override string _GetTemplateForLabelRobloxToys()
	{
		return "Brinquedos Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelRobuxPurchaseIssue()
	{
		return "Robux - Problema na compra";
	}

	protected override string _GetTemplateForLabelSafetyInquiry()
	{
		return "Comportamento de usuário ou jogo inapropriado";
	}

	protected override string _GetTemplateForLabelSafetyQueueTicket()
	{
		return "Cuidados com a segurança do usuário";
	}

	protected override string _GetTemplateForLabelSpecificGameIssue()
	{
		return "Problema específico no jogo";
	}

	protected override string _GetTemplateForLabelSubmit()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForLabelSuggestFeature()
	{
		return "Sugestão de funcionalidade";
	}

	protected override string _GetTemplateForLabelSuggestFeedback()
	{
		return "Opinião";
	}

	protected override string _GetTemplateForLabelTechnicalSupport()
	{
		return "Suporte técnico";
	}

	protected override string _GetTemplateForLabelToyCodeIssue()
	{
		return "Problema com código do brinquedo";
	}

	protected override string _GetTemplateForLabelTwoStepV()
	{
		return "Verificação de 2 passos";
	}

	protected override string _GetTemplateForLabelUserAbuseReport()
	{
		return "Denunciar usuário por quebrar as regras";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nome de usuário";
	}

	protected override string _GetTemplateForLabelVCCatalog()
	{
		return "Item do website";
	}

	protected override string _GetTemplateForLabelVCInGame()
	{
		return "Item do jogo";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForResponseDialogErrorWithoutContext()
	{
		return "Algo deu errado. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Aperte Enviar para enviar a solicitação ou Cancelar para editar o nome de usuário. O nome de usuário é uma informação muito importante e pode ajudar a resolver seu problema mais rápido.";
	}

	protected override string _GetTemplateForResponseDialogRequestReceived()
	{
		return "Obrigado por contatar Roblox. Confira o seu e-mail para encontrar uma mensagem do Serviço ao Cliente.";
	}

	protected override string _GetTemplateForResponseDialogTooManyAttemptsError()
	{
		return "Tentativas excessivas. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogTryAgainError()
	{
		return "Ocorreu um erro. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseEmailFormatError()
	{
		return "Insira um endereço de e-mail com formato correto";
	}

	protected override string _GetTemplateForResponseEmailNotMatching()
	{
		return "Endereço de e-mail não confere";
	}

	protected override string _GetTemplateForResponseInvalidFirstName()
	{
		return "Insira um nome válido";
	}

	protected override string _GetTemplateForResponseInvalidUsername()
	{
		return "Este não parece ser um nome de usuário do Roblox válido.";
	}

	protected override string _GetTemplateForResponseUnder13Email()
	{
		return "Se você tiver menos de 13 anos, forneça o endereço de e-mail do responsável";
	}
}
