namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SupportResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SupportResources_fr_fr : SupportResources_en_us, ISupportResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Annuler";

	/// <summary>
	/// Key: "Action.Dialog.OK"
	/// OK
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogOK => "OK";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Envoyer";

	/// <summary>
	/// Key: "Heading.ContactInformation"
	/// Contact Information
	/// English String: "Contact Information"
	/// </summary>
	public override string HeadingContactInformation => "Coordonnées";

	/// <summary>
	/// Key: "Heading.DescriptionOfIssue"
	/// Description of issue
	/// English String: "Description of issue"
	/// </summary>
	public override string HeadingDescriptionOfIssue => "Description du problème";

	/// <summary>
	/// Key: "Heading.DeviceWithProblem"
	/// What device are you having the problem on?
	/// English String: "What device are you having the problem on?"
	/// </summary>
	public override string HeadingDeviceWithProblem => "Sur quel appareil rencontrez-vous le problème\u00a0?";

	/// <summary>
	/// Key: "Heading.Dialog.ErrorWithoutContext"
	/// Error
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogErrorWithoutContext => "Erreur";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nom d'utilisateur invalide";

	/// <summary>
	/// Key: "Heading.Dialog.RequestReceived"
	/// Request Received
	/// English String: "Request Received"
	/// </summary>
	public override string HeadingDialogRequestReceived => "Demande reçue";

	/// <summary>
	/// Key: "Heading.HelpCategoryType"
	/// Type of help category
	/// English String: "Type of help category"
	/// </summary>
	public override string HeadingHelpCategoryType => "Type de rubrique d'aide";

	/// <summary>
	/// Key: "Heading.IssueDetails"
	/// Issue Details
	/// English String: "Issue Details"
	/// </summary>
	public override string HeadingIssueDetails => "Détails du problème";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// Contact Us
	/// English String: "Contact Us"
	/// </summary>
	public override string HeadingPageTitle => "Contact";

	/// <summary>
	/// Key: "Label.AccountHacked"
	/// Account Hacked
	/// English String: "Account Hacked"
	/// </summary>
	public override string LabelAccountHacked => "Compte piraté";

	/// <summary>
	/// Key: "Label.AccountOwnership"
	/// Account Hacked or Can't Log in
	/// English String: "Account Hacked or Can't Log in"
	/// </summary>
	public override string LabelAccountOwnership => "Compte piraté ou connexion impossible";

	/// <summary>
	/// Key: "Label.AccountPin"
	/// Account PIN
	/// English String: "Account PIN"
	/// </summary>
	public override string LabelAccountPin => "Code PIN du compte";

	public override string LabelAdjustChildSettings => "Modifier les paramètres de sécurité et de confidentialité de l'enfant";

	/// <summary>
	/// Key: "Label.AmazonDevice"
	/// Amazon Device
	/// English String: "Amazon Device"
	/// </summary>
	public override string LabelAmazonDevice => "Appareil Amazon";

	/// <summary>
	/// Key: "Label.AndroidPhone"
	/// Android Phone
	/// English String: "Android Phone"
	/// </summary>
	public override string LabelAndroidPhone => "Téléphone Android";

	/// <summary>
	/// Key: "Label.AndroidTablet"
	/// Android Tablet
	/// English String: "Android Tablet"
	/// </summary>
	public override string LabelAndroidTablet => "Tablette Android";

	/// <summary>
	/// Key: "Label.AppealAccountContent"
	/// Appeal Account or Content
	/// English String: "Appeal Account or Content"
	/// </summary>
	public override string LabelAppealAccountContent => "Appel - Compte ou contenu";

	/// <summary>
	/// Key: "Label.AppealFriend"
	/// Appeal for Friend
	/// English String: "Appeal for Friend"
	/// </summary>
	public override string LabelAppealFriend => "Appel - Ami";

	public override string LabelBilling => "Facturation et paiements";

	/// <summary>
	/// Key: "Label.BugReport"
	/// Bug Report
	/// English String: "Bug Report"
	/// </summary>
	public override string LabelBugReport => "Signalement de bug";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// Builders Club
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.CancelMembership"
	/// Cancel Membership
	/// English String: "Cancel Membership"
	/// </summary>
	public override string LabelCancelMembership => "Annulation d'abonnement";

	/// <summary>
	/// Key: "Label.CannotInstall"
	/// Cannot Install Roblox or Studio
	/// English String: "Cannot Install Roblox or Studio"
	/// </summary>
	public override string LabelCannotInstall => "Impossible d'installer Roblox ou Studio";

	/// <summary>
	/// Key: "Label.CannotPlayGame"
	/// Cannot Play Game
	/// English String: "Cannot Play Game"
	/// </summary>
	public override string LabelCannotPlayGame => "Impossible de jouer à un jeu";

	/// <summary>
	/// Key: "Label.ChangeChildAge"
	/// Change Child Age
	/// English String: "Change Child Age"
	/// </summary>
	public override string LabelChangeChildAge => "Changer l'âge de l'enfant";

	public override string LabelChatAgeSettings => "Paramètres de chat et d'âge";

	/// <summary>
	/// Key: "Label.Chromebook"
	/// Chromebook
	/// English String: "Chromebook"
	/// </summary>
	public override string LabelChromebook => "Chromebook";

	/// <summary>
	/// Key: "Label.ConfirmEmail"
	/// Confirm Email Address
	/// English String: "Confirm Email Address"
	/// </summary>
	public override string LabelConfirmEmail => "Confirmer l'adresse e-mail";

	/// <summary>
	/// Key: "Label.ContentAbuseReport"
	/// Report Content Breaking Rules
	/// English String: "Report Content Breaking Rules"
	/// </summary>
	public override string LabelContentAbuseReport => "Signaler une infraction au règlement (contenu)";

	public override string LabelContest => "Compétitions et événements";

	/// <summary>
	/// Key: "Label.ContestEventQuestion"
	/// Question or Issue
	/// English String: "Question or Issue"
	/// </summary>
	public override string LabelContestEventQuestion => "Question ou problème";

	/// <summary>
	/// Key: "Label.CSCharacter"
	/// Customer Service Character
	/// English String: "Customer Service Character"
	/// </summary>
	public override string LabelCSCharacter => "Customer Service Character";

	/// <summary>
	/// Key: "Label.DescribeIssue"
	/// Please describe your issue
	/// English String: "Please describe your issue"
	/// </summary>
	public override string LabelDescribeIssue => "Décris ton problème";

	/// <summary>
	/// Key: "Label.DevEx"
	/// DevEx
	/// English String: "DevEx"
	/// </summary>
	public override string LabelDevEx => "DevEx";

	/// <summary>
	/// Key: "Label.DevExHowTo"
	/// DevEx How To
	/// English String: "DevEx How To"
	/// </summary>
	public override string LabelDevExHowTo => "DevEx - Didacticiels";

	/// <summary>
	/// Key: "Label.DevExMyRequest"
	/// DevEx My Request
	/// English String: "DevEx My Request"
	/// </summary>
	public override string LabelDevExMyRequest => "DevEx - Ma demande";

	/// <summary>
	/// Key: "Label.DMCA"
	/// DMCA
	/// English String: "DMCA"
	/// </summary>
	public override string LabelDMCA => "DMCA";

	/// <summary>
	/// Key: "Label.EmailAddress"
	/// Email Address
	/// English String: "Email Address"
	/// </summary>
	public override string LabelEmailAddress => "Adresse e-mail";

	/// <summary>
	/// Key: "Label.ExploitReport"
	/// Exploit Report
	/// English String: "Exploit Report"
	/// </summary>
	public override string LabelExploitReport => "Signalement de triche";

	/// <summary>
	/// Key: "Label.FirstName"
	/// First Name
	/// English String: "First Name"
	/// </summary>
	public override string LabelFirstName => "Prénom";

	/// <summary>
	/// Key: "Label.ForgotPassword"
	/// Forgot Password
	/// English String: "Forgot Password"
	/// </summary>
	public override string LabelForgotPassword => "Mot de passe oublié";

	/// <summary>
	/// Key: "Label.FreeRobux"
	/// Free Robux
	/// English String: "Free Robux"
	/// </summary>
	public override string LabelFreeRobux => "Robux gratuits";

	/// <summary>
	/// Key: "Label.GameCredit"
	/// Game Card
	/// English String: "Game Card"
	/// </summary>
	public override string LabelGameCredit => "Carte de jeu";

	/// <summary>
	/// Key: "Label.GCPartialPayment"
	/// Purchase - Split Payment
	/// English String: "Purchase - Split Payment"
	/// </summary>
	public override string LabelGCPartialPayment => "Achat - Paiement fractionné";

	/// <summary>
	/// Key: "Label.GCRedeem"
	/// Game Card - Redeem
	/// English String: "Game Card - Redeem"
	/// </summary>
	public override string LabelGCRedeem => "Carte de jeu - Activation";

	/// <summary>
	/// Key: "Label.GCSpendCredit"
	/// Game Card - Spend Credit
	/// English String: "Game Card - Spend Credit"
	/// </summary>
	public override string LabelGCSpendCredit => "Carte de jeu - Dépense de crédit";

	/// <summary>
	/// Key: "Label.HowTo"
	/// How To
	/// English String: "How To"
	/// </summary>
	public override string LabelHowTo => "Didacticiels";

	/// <summary>
	/// Key: "Label.HowToGeneral"
	/// How To - General
	/// English String: "How To - General"
	/// </summary>
	public override string LabelHowToGeneral => "Didacticiels - Général";

	/// <summary>
	/// Key: "Label.HowToOther"
	/// How To - Other
	/// English String: "How To - Other"
	/// </summary>
	public override string LabelHowToOther => "Didacticiels - Autres";

	public override string LabelIdeasSuggestions => "Idées et suggestions";

	/// <summary>
	/// Key: "Label.IPad"
	/// iPad
	/// English String: "iPad"
	/// </summary>
	public override string LabelIPad => "iPad";

	/// <summary>
	/// Key: "Label.IPhone"
	/// iPhone
	/// English String: "iPhone"
	/// </summary>
	public override string LabelIPhone => "iPhone";

	/// <summary>
	/// Key: "Label.IssueDescription"
	/// Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message.
	/// English String: "Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message."
	/// </summary>
	public override string LabelIssueDescription => "Veuillez décrire le problème que vous rencontrez. Pensez à inclure toute information utile, par exemple l'endroit où l'erreur se produit ou encore le message d'erreur obtenu.";

	/// <summary>
	/// Key: "Label.IWasScammed"
	/// I was Scammed
	/// English String: "I was Scammed"
	/// </summary>
	public override string LabelIWasScammed => "J'ai été victime d'une arnaque";

	/// <summary>
	/// Key: "Label.Mac"
	/// Mac
	/// English String: "Mac"
	/// </summary>
	public override string LabelMac => "Mac";

	/// <summary>
	/// Key: "Label.Membership"
	/// Support page. Membership {{dc.field_membership}} stop_memb.
	/// English String: "Membership"
	/// </summary>
	public override string LabelMembership => "Abonnement";

	/// <summary>
	/// Key: "Label.Moderation"
	/// Moderation
	/// English String: "Moderation"
	/// </summary>
	public override string LabelModeration => "Modération";

	/// <summary>
	/// Key: "Label.OtherSiteClaim"
	/// Other Site Claim
	/// English String: "Other Site Claim"
	/// </summary>
	public override string LabelOtherSiteClaim => "Réclamation d'un autre site";

	/// <summary>
	/// Key: "Label.OwnerDMCAClaim"
	/// Owner DMCA Claim
	/// English String: "Owner DMCA Claim"
	/// </summary>
	public override string LabelOwnerDMCAClaim => "Réclamation en vertu de la DMCA (propriétaire des droits)";

	/// <summary>
	/// Key: "Label.PC"
	/// PC
	/// English String: "PC"
	/// </summary>
	public override string LabelPC => "PC";

	/// <summary>
	/// Key: "Label.PhysicalToyIssue"
	/// Physical Toy Issue
	/// English String: "Physical Toy Issue"
	/// </summary>
	public override string LabelPhysicalToyIssue => "Problème avec un jouet réel";

	/// <summary>
	/// Key: "Label.PleaseSelect"
	/// Please Select...
	/// English String: "Please Select..."
	/// </summary>
	public override string LabelPleaseSelect => "Veuillez sélectionner...";

	/// <summary>
	/// Key: "Label.PrizeNotReceived"
	/// Prize Not Received
	/// English String: "Prize Not Received"
	/// </summary>
	public override string LabelPrizeNotReceived => "Prix non reçu";

	/// <summary>
	/// Key: "Label.PurchaseDeclined"
	/// Purchase - Declined
	/// English String: "Purchase - Declined"
	/// </summary>
	public override string LabelPurchaseDeclined => "Achat - Transaction rejetée";

	/// <summary>
	/// Key: "Label.PurchaseDidNotReceive"
	/// Purchase - Did Not Receive
	/// English String: "Purchase - Did Not Receive"
	/// </summary>
	public override string LabelPurchaseDidNotReceive => "Achat - Contenu non reçu";

	/// <summary>
	/// Key: "Label.PurchaseUnauthorizedCharge"
	/// Purchase - Unauthorized Charge
	/// English String: "Purchase - Unauthorized Charge"
	/// </summary>
	public override string LabelPurchaseUnauthorizedCharge => "Achat - Prélèvement non autorisé";

	/// <summary>
	/// Key: "Label.ReportPhish"
	/// Report Phishing Site
	/// English String: "Report Phishing Site"
	/// </summary>
	public override string LabelReportPhish => "Signaler un site de hameçonnage";

	/// <summary>
	/// Key: "Label.RobloxCrashing"
	/// Roblox Crashing
	/// English String: "Roblox Crashing"
	/// </summary>
	public override string LabelRobloxCrashing => "Plantage de Roblox";

	/// <summary>
	/// Key: "Label.RobloxToys"
	/// Roblox Toys
	/// English String: "Roblox Toys"
	/// </summary>
	public override string LabelRobloxToys => "Jouets Roblox";

	/// <summary>
	/// Key: "Label.Robux"
	/// Robux
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.RobuxPurchaseIssue"
	/// Robux - Purchase Issue
	/// English String: "Robux - Purchase Issue"
	/// </summary>
	public override string LabelRobuxPurchaseIssue => "Robux - Problème d'achat";

	/// <summary>
	/// Key: "Label.SafetyInquiry"
	/// Inappropriate game or user behavior
	/// English String: "Inappropriate game or user behavior"
	/// </summary>
	public override string LabelSafetyInquiry => "Jeu ou comportement de joueur inapproprié";

	/// <summary>
	/// Key: "Label.SafetyQueueTicket"
	/// User Safety Concern
	/// English String: "User Safety Concern"
	/// </summary>
	public override string LabelSafetyQueueTicket => "Sécurité des utilisateurs";

	/// <summary>
	/// Key: "Label.SpecificGameIssue"
	/// Specific Game Issue
	/// English String: "Specific Game Issue"
	/// </summary>
	public override string LabelSpecificGameIssue => "Problème spécifique à un jeu";

	/// <summary>
	/// Key: "Label.Submit"
	/// Submit
	/// English String: "Submit"
	/// </summary>
	public override string LabelSubmit => "Envoyer";

	/// <summary>
	/// Key: "Label.SuggestFeature"
	/// Feature Suggestion
	/// English String: "Feature Suggestion"
	/// </summary>
	public override string LabelSuggestFeature => "Suggérer une fonctionnalité";

	/// <summary>
	/// Key: "Label.SuggestFeedback"
	/// Feedback
	/// English String: "Feedback"
	/// </summary>
	public override string LabelSuggestFeedback => "Commentaires et retours";

	/// <summary>
	/// Key: "Label.TechnicalSupport"
	/// Technical Support
	/// English String: "Technical Support"
	/// </summary>
	public override string LabelTechnicalSupport => "Assistance technique";

	/// <summary>
	/// Key: "Label.ToyCodeIssue"
	/// Toy Code Issue
	/// English String: "Toy Code Issue"
	/// </summary>
	public override string LabelToyCodeIssue => "Problème avec un code jouet";

	/// <summary>
	/// Key: "Label.TwoStepV"
	/// 2-Step Verification
	/// English String: "2-Step Verification"
	/// </summary>
	public override string LabelTwoStepV => "Vérification en 2\u00a0étapes";

	/// <summary>
	/// Key: "Label.UserAbuseReport"
	/// Report User Breaking Rules
	/// English String: "Report User Breaking Rules"
	/// </summary>
	public override string LabelUserAbuseReport => "Signaler une infraction au règlement (utilisateur)";

	/// <summary>
	/// Key: "Label.Username"
	/// Username
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Nom d'utilisateur";

	/// <summary>
	/// Key: "Label.VCCatalog"
	/// Website Item
	/// English String: "Website Item"
	/// </summary>
	public override string LabelVCCatalog => "Objet du site Internet";

	/// <summary>
	/// Key: "Label.VCInGame"
	/// In-Game Item
	/// English String: "In-Game Item"
	/// </summary>
	public override string LabelVCInGame => "Objet en jeu";

	/// <summary>
	/// Key: "Label.Xbox"
	/// Xbox
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "Response.Dialog.ErrorWithoutContext"
	/// Something went wrong, please try again later.
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogErrorWithoutContext => "Un problème est survenu. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Appuyez sur Envoyer pour soumettre le ticket ou sur Annuler pour modifier le nom d'utilisateur. Ce dernier est très important et peut vous aider à obtenir une réponse plus rapidement.";

	/// <summary>
	/// Key: "Response.Dialog.RequestReceived"
	/// Thank you for contacting Roblox. Please check your email for a message from Customer Service.
	/// English String: "Thank you for contacting Roblox. Please check your email for a message from Customer Service."
	/// </summary>
	public override string ResponseDialogRequestReceived => "Merci d'avoir contacté l'équipe Roblox. L'assistance clientèle vous contactera par e-mail.";

	/// <summary>
	/// Key: "Response.Dialog.TooManyAttemptsError"
	/// Too many attempts. Try again later.
	/// English String: "Too many attempts. Try again later."
	/// </summary>
	public override string ResponseDialogTooManyAttemptsError => "Trop de tentatives. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.TryAgainError"
	/// An error occurred. Try again later.
	/// English String: "An error occurred. Try again later."
	/// </summary>
	public override string ResponseDialogTryAgainError => "Une erreur est survenue. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.EmailFormatError"
	/// Please enter a properly formatted email address
	/// English String: "Please enter a properly formatted email address"
	/// </summary>
	public override string ResponseEmailFormatError => "Veuillez saisir un format d'adresse e-mail valide.";

	/// <summary>
	/// Key: "Response.EmailNotMatching"
	/// Email address does not match
	/// English String: "Email address does not match"
	/// </summary>
	public override string ResponseEmailNotMatching => "L'adresse e-mail ne correspond pas.";

	/// <summary>
	/// Key: "Response.InvalidFirstName"
	/// Please enter a valid first name
	/// English String: "Please enter a valid first name"
	/// </summary>
	public override string ResponseInvalidFirstName => "Veuillez saisir un prénom valide.";

	/// <summary>
	/// Key: "Response.InvalidUsername"
	/// That doesn't appear to be a valid Roblox username.
	/// English String: "That doesn't appear to be a valid Roblox username."
	/// </summary>
	public override string ResponseInvalidUsername => "Ce nom d'utilisateur Roblox n'est pas valide.";

	/// <summary>
	/// Key: "Response.Under13Email"
	/// If you are under 13 years old, please provide your parent's email address
	/// English String: "If you are under 13 years old, please provide your parent's email address"
	/// </summary>
	public override string ResponseUnder13Email => "Si vous avez moins de 13\u00a0ans, veuillez indiquer l'adresse e-mail d'un de vos parents.";

	public SupportResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionDialogOK()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Envoyer";
	}

	protected override string _GetTemplateForHeadingContactInformation()
	{
		return "Coordonnées";
	}

	protected override string _GetTemplateForHeadingDescriptionOfIssue()
	{
		return "Description du problème";
	}

	protected override string _GetTemplateForHeadingDeviceWithProblem()
	{
		return "Sur quel appareil rencontrez-vous le problème\u00a0?";
	}

	protected override string _GetTemplateForHeadingDialogErrorWithoutContext()
	{
		return "Erreur";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nom d'utilisateur invalide";
	}

	protected override string _GetTemplateForHeadingDialogRequestReceived()
	{
		return "Demande reçue";
	}

	protected override string _GetTemplateForHeadingHelpCategoryType()
	{
		return "Type de rubrique d'aide";
	}

	protected override string _GetTemplateForHeadingIssueDetails()
	{
		return "Détails du problème";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Contact";
	}

	protected override string _GetTemplateForLabelAccountHacked()
	{
		return "Compte piraté";
	}

	protected override string _GetTemplateForLabelAccountOwnership()
	{
		return "Compte piraté ou connexion impossible";
	}

	protected override string _GetTemplateForLabelAccountPin()
	{
		return "Code PIN du compte";
	}

	protected override string _GetTemplateForLabelAdjustChildSettings()
	{
		return "Modifier les paramètres de sécurité et de confidentialité de l'enfant";
	}

	protected override string _GetTemplateForLabelAmazonDevice()
	{
		return "Appareil Amazon";
	}

	protected override string _GetTemplateForLabelAndroidPhone()
	{
		return "Téléphone Android";
	}

	protected override string _GetTemplateForLabelAndroidTablet()
	{
		return "Tablette Android";
	}

	protected override string _GetTemplateForLabelAppealAccountContent()
	{
		return "Appel - Compte ou contenu";
	}

	protected override string _GetTemplateForLabelAppealFriend()
	{
		return "Appel - Ami";
	}

	protected override string _GetTemplateForLabelBilling()
	{
		return "Facturation et paiements";
	}

	protected override string _GetTemplateForLabelBugReport()
	{
		return "Signalement de bug";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelCancelMembership()
	{
		return "Annulation d'abonnement";
	}

	protected override string _GetTemplateForLabelCannotInstall()
	{
		return "Impossible d'installer Roblox ou Studio";
	}

	protected override string _GetTemplateForLabelCannotPlayGame()
	{
		return "Impossible de jouer à un jeu";
	}

	protected override string _GetTemplateForLabelChangeChildAge()
	{
		return "Changer l'âge de l'enfant";
	}

	protected override string _GetTemplateForLabelChatAgeSettings()
	{
		return "Paramètres de chat et d'âge";
	}

	protected override string _GetTemplateForLabelChromebook()
	{
		return "Chromebook";
	}

	protected override string _GetTemplateForLabelConfirmEmail()
	{
		return "Confirmer l'adresse e-mail";
	}

	protected override string _GetTemplateForLabelContentAbuseReport()
	{
		return "Signaler une infraction au règlement (contenu)";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Compétitions et événements";
	}

	protected override string _GetTemplateForLabelContestEventQuestion()
	{
		return "Question ou problème";
	}

	protected override string _GetTemplateForLabelCSCharacter()
	{
		return "Customer Service Character";
	}

	protected override string _GetTemplateForLabelDescribeIssue()
	{
		return "Décris ton problème";
	}

	protected override string _GetTemplateForLabelDevEx()
	{
		return "DevEx";
	}

	protected override string _GetTemplateForLabelDevExHowTo()
	{
		return "DevEx - Didacticiels";
	}

	protected override string _GetTemplateForLabelDevExMyRequest()
	{
		return "DevEx - Ma demande";
	}

	protected override string _GetTemplateForLabelDMCA()
	{
		return "DMCA";
	}

	protected override string _GetTemplateForLabelEmailAddress()
	{
		return "Adresse e-mail";
	}

	protected override string _GetTemplateForLabelExploitReport()
	{
		return "Signalement de triche";
	}

	protected override string _GetTemplateForLabelFirstName()
	{
		return "Prénom";
	}

	protected override string _GetTemplateForLabelForgotPassword()
	{
		return "Mot de passe oublié";
	}

	protected override string _GetTemplateForLabelFreeRobux()
	{
		return "Robux gratuits";
	}

	protected override string _GetTemplateForLabelGameCredit()
	{
		return "Carte de jeu";
	}

	protected override string _GetTemplateForLabelGCPartialPayment()
	{
		return "Achat - Paiement fractionné";
	}

	protected override string _GetTemplateForLabelGCRedeem()
	{
		return "Carte de jeu - Activation";
	}

	protected override string _GetTemplateForLabelGCSpendCredit()
	{
		return "Carte de jeu - Dépense de crédit";
	}

	protected override string _GetTemplateForLabelHowTo()
	{
		return "Didacticiels";
	}

	protected override string _GetTemplateForLabelHowToGeneral()
	{
		return "Didacticiels - Général";
	}

	protected override string _GetTemplateForLabelHowToOther()
	{
		return "Didacticiels - Autres";
	}

	protected override string _GetTemplateForLabelIdeasSuggestions()
	{
		return "Idées et suggestions";
	}

	protected override string _GetTemplateForLabelIPad()
	{
		return "iPad";
	}

	protected override string _GetTemplateForLabelIPhone()
	{
		return "iPhone";
	}

	protected override string _GetTemplateForLabelIssueDescription()
	{
		return "Veuillez décrire le problème que vous rencontrez. Pensez à inclure toute information utile, par exemple l'endroit où l'erreur se produit ou encore le message d'erreur obtenu.";
	}

	protected override string _GetTemplateForLabelIWasScammed()
	{
		return "J'ai été victime d'une arnaque";
	}

	protected override string _GetTemplateForLabelMac()
	{
		return "Mac";
	}

	protected override string _GetTemplateForLabelMembership()
	{
		return "Abonnement";
	}

	protected override string _GetTemplateForLabelModeration()
	{
		return "Modération";
	}

	protected override string _GetTemplateForLabelOtherSiteClaim()
	{
		return "Réclamation d'un autre site";
	}

	protected override string _GetTemplateForLabelOwnerDMCAClaim()
	{
		return "Réclamation en vertu de la DMCA (propriétaire des droits)";
	}

	protected override string _GetTemplateForLabelPC()
	{
		return "PC";
	}

	protected override string _GetTemplateForLabelPhysicalToyIssue()
	{
		return "Problème avec un jouet réel";
	}

	protected override string _GetTemplateForLabelPleaseSelect()
	{
		return "Veuillez sélectionner...";
	}

	protected override string _GetTemplateForLabelPrizeNotReceived()
	{
		return "Prix non reçu";
	}

	protected override string _GetTemplateForLabelPurchaseDeclined()
	{
		return "Achat - Transaction rejetée";
	}

	protected override string _GetTemplateForLabelPurchaseDidNotReceive()
	{
		return "Achat - Contenu non reçu";
	}

	protected override string _GetTemplateForLabelPurchaseUnauthorizedCharge()
	{
		return "Achat - Prélèvement non autorisé";
	}

	protected override string _GetTemplateForLabelReportPhish()
	{
		return "Signaler un site de hameçonnage";
	}

	protected override string _GetTemplateForLabelRobloxCrashing()
	{
		return "Plantage de Roblox";
	}

	protected override string _GetTemplateForLabelRobloxToys()
	{
		return "Jouets Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelRobuxPurchaseIssue()
	{
		return "Robux - Problème d'achat";
	}

	protected override string _GetTemplateForLabelSafetyInquiry()
	{
		return "Jeu ou comportement de joueur inapproprié";
	}

	protected override string _GetTemplateForLabelSafetyQueueTicket()
	{
		return "Sécurité des utilisateurs";
	}

	protected override string _GetTemplateForLabelSpecificGameIssue()
	{
		return "Problème spécifique à un jeu";
	}

	protected override string _GetTemplateForLabelSubmit()
	{
		return "Envoyer";
	}

	protected override string _GetTemplateForLabelSuggestFeature()
	{
		return "Suggérer une fonctionnalité";
	}

	protected override string _GetTemplateForLabelSuggestFeedback()
	{
		return "Commentaires et retours";
	}

	protected override string _GetTemplateForLabelTechnicalSupport()
	{
		return "Assistance technique";
	}

	protected override string _GetTemplateForLabelToyCodeIssue()
	{
		return "Problème avec un code jouet";
	}

	protected override string _GetTemplateForLabelTwoStepV()
	{
		return "Vérification en 2\u00a0étapes";
	}

	protected override string _GetTemplateForLabelUserAbuseReport()
	{
		return "Signaler une infraction au règlement (utilisateur)";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nom d'utilisateur";
	}

	protected override string _GetTemplateForLabelVCCatalog()
	{
		return "Objet du site Internet";
	}

	protected override string _GetTemplateForLabelVCInGame()
	{
		return "Objet en jeu";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForResponseDialogErrorWithoutContext()
	{
		return "Un problème est survenu. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Appuyez sur Envoyer pour soumettre le ticket ou sur Annuler pour modifier le nom d'utilisateur. Ce dernier est très important et peut vous aider à obtenir une réponse plus rapidement.";
	}

	protected override string _GetTemplateForResponseDialogRequestReceived()
	{
		return "Merci d'avoir contacté l'équipe Roblox. L'assistance clientèle vous contactera par e-mail.";
	}

	protected override string _GetTemplateForResponseDialogTooManyAttemptsError()
	{
		return "Trop de tentatives. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogTryAgainError()
	{
		return "Une erreur est survenue. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseEmailFormatError()
	{
		return "Veuillez saisir un format d'adresse e-mail valide.";
	}

	protected override string _GetTemplateForResponseEmailNotMatching()
	{
		return "L'adresse e-mail ne correspond pas.";
	}

	protected override string _GetTemplateForResponseInvalidFirstName()
	{
		return "Veuillez saisir un prénom valide.";
	}

	protected override string _GetTemplateForResponseInvalidUsername()
	{
		return "Ce nom d'utilisateur Roblox n'est pas valide.";
	}

	protected override string _GetTemplateForResponseUnder13Email()
	{
		return "Si vous avez moins de 13\u00a0ans, veuillez indiquer l'adresse e-mail d'un de vos parents.";
	}
}
