namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SupportResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SupportResources_es_es : SupportResources_en_us, ISupportResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.OK"
	/// OK
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogOK => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Enviar";

	/// <summary>
	/// Key: "Heading.ContactInformation"
	/// Contact Information
	/// English String: "Contact Information"
	/// </summary>
	public override string HeadingContactInformation => "Información de contacto";

	/// <summary>
	/// Key: "Heading.DescriptionOfIssue"
	/// Description of issue
	/// English String: "Description of issue"
	/// </summary>
	public override string HeadingDescriptionOfIssue => "Descripción del problema";

	/// <summary>
	/// Key: "Heading.DeviceWithProblem"
	/// What device are you having the problem on?
	/// English String: "What device are you having the problem on?"
	/// </summary>
	public override string HeadingDeviceWithProblem => "¿En qué dispositivo ocurre el problema?";

	/// <summary>
	/// Key: "Heading.Dialog.ErrorWithoutContext"
	/// Error
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogErrorWithoutContext => "Error";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nombre de usuario no válido";

	/// <summary>
	/// Key: "Heading.Dialog.RequestReceived"
	/// Request Received
	/// English String: "Request Received"
	/// </summary>
	public override string HeadingDialogRequestReceived => "Solicitud recibida";

	/// <summary>
	/// Key: "Heading.HelpCategoryType"
	/// Type of help category
	/// English String: "Type of help category"
	/// </summary>
	public override string HeadingHelpCategoryType => "Categorías de ayuda";

	/// <summary>
	/// Key: "Heading.IssueDetails"
	/// Issue Details
	/// English String: "Issue Details"
	/// </summary>
	public override string HeadingIssueDetails => "Detalles del problema";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// Contact Us
	/// English String: "Contact Us"
	/// </summary>
	public override string HeadingPageTitle => "Contáctanos";

	/// <summary>
	/// Key: "Label.AccountHacked"
	/// Account Hacked
	/// English String: "Account Hacked"
	/// </summary>
	public override string LabelAccountHacked => "Cuenta hackeada";

	/// <summary>
	/// Key: "Label.AccountOwnership"
	/// Account Hacked or Can't Log in
	/// English String: "Account Hacked or Can't Log in"
	/// </summary>
	public override string LabelAccountOwnership => "Cuenta hackeada o no puedo iniciar sesión";

	/// <summary>
	/// Key: "Label.AccountPin"
	/// Account PIN
	/// English String: "Account PIN"
	/// </summary>
	public override string LabelAccountPin => "PIN de la cuenta";

	public override string LabelAdjustChildSettings => "Ajustar la configuración de privacidad y seguridad del menor";

	/// <summary>
	/// Key: "Label.AmazonDevice"
	/// Amazon Device
	/// English String: "Amazon Device"
	/// </summary>
	public override string LabelAmazonDevice => "Dispositivo Amazon";

	/// <summary>
	/// Key: "Label.AndroidPhone"
	/// Android Phone
	/// English String: "Android Phone"
	/// </summary>
	public override string LabelAndroidPhone => "Teléfono Android";

	/// <summary>
	/// Key: "Label.AndroidTablet"
	/// Android Tablet
	/// English String: "Android Tablet"
	/// </summary>
	public override string LabelAndroidTablet => "Tablet Android";

	/// <summary>
	/// Key: "Label.AppealAccountContent"
	/// Appeal Account or Content
	/// English String: "Appeal Account or Content"
	/// </summary>
	public override string LabelAppealAccountContent => "Apelar una cuenta o contenido";

	/// <summary>
	/// Key: "Label.AppealFriend"
	/// Appeal for Friend
	/// English String: "Appeal for Friend"
	/// </summary>
	public override string LabelAppealFriend => "Apelar por un amigo";

	public override string LabelBilling => "Facturación y pagos";

	/// <summary>
	/// Key: "Label.BugReport"
	/// Bug Report
	/// English String: "Bug Report"
	/// </summary>
	public override string LabelBugReport => "Informe de error";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// Builders Club
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.CancelMembership"
	/// Cancel Membership
	/// English String: "Cancel Membership"
	/// </summary>
	public override string LabelCancelMembership => "Cancelar membresía";

	/// <summary>
	/// Key: "Label.CannotInstall"
	/// Cannot Install Roblox or Studio
	/// English String: "Cannot Install Roblox or Studio"
	/// </summary>
	public override string LabelCannotInstall => "Problemas para instalar Roblox o Studio";

	/// <summary>
	/// Key: "Label.CannotPlayGame"
	/// Cannot Play Game
	/// English String: "Cannot Play Game"
	/// </summary>
	public override string LabelCannotPlayGame => "Problemas para jugar";

	/// <summary>
	/// Key: "Label.ChangeChildAge"
	/// Change Child Age
	/// English String: "Change Child Age"
	/// </summary>
	public override string LabelChangeChildAge => "Cambiar la edad del menor";

	public override string LabelChatAgeSettings => "Configuración de chat y edad";

	/// <summary>
	/// Key: "Label.Chromebook"
	/// Chromebook
	/// English String: "Chromebook"
	/// </summary>
	public override string LabelChromebook => "Chromebook";

	/// <summary>
	/// Key: "Label.ConfirmEmail"
	/// Confirm Email Address
	/// English String: "Confirm Email Address"
	/// </summary>
	public override string LabelConfirmEmail => "Confirmar dirección de correo electrónico";

	/// <summary>
	/// Key: "Label.ContentAbuseReport"
	/// Report Content Breaking Rules
	/// English String: "Report Content Breaking Rules"
	/// </summary>
	public override string LabelContentAbuseReport => "Denunciar contenido que infringe las normas";

	public override string LabelContest => "Concursos y eventos";

	/// <summary>
	/// Key: "Label.ContestEventQuestion"
	/// Question or Issue
	/// English String: "Question or Issue"
	/// </summary>
	public override string LabelContestEventQuestion => "Pregunta o problema";

	/// <summary>
	/// Key: "Label.CSCharacter"
	/// Customer Service Character
	/// English String: "Customer Service Character"
	/// </summary>
	public override string LabelCSCharacter => "Calidad del servicio al cliente";

	/// <summary>
	/// Key: "Label.DescribeIssue"
	/// Please describe your issue
	/// English String: "Please describe your issue"
	/// </summary>
	public override string LabelDescribeIssue => "Describe el problema que tienes.";

	/// <summary>
	/// Key: "Label.DevEx"
	/// DevEx
	/// English String: "DevEx"
	/// </summary>
	public override string LabelDevEx => "DevEx";

	/// <summary>
	/// Key: "Label.DevExHowTo"
	/// DevEx How To
	/// English String: "DevEx How To"
	/// </summary>
	public override string LabelDevExHowTo => "Guía práctica del DevEx";

	/// <summary>
	/// Key: "Label.DevExMyRequest"
	/// DevEx My Request
	/// English String: "DevEx My Request"
	/// </summary>
	public override string LabelDevExMyRequest => "Mi solicitud al DevEx";

	/// <summary>
	/// Key: "Label.DMCA"
	/// DMCA
	/// English String: "DMCA"
	/// </summary>
	public override string LabelDMCA => "Ley de Derechos de Autor";

	/// <summary>
	/// Key: "Label.EmailAddress"
	/// Email Address
	/// English String: "Email Address"
	/// </summary>
	public override string LabelEmailAddress => "Dirección de correo electrónico";

	/// <summary>
	/// Key: "Label.ExploitReport"
	/// Exploit Report
	/// English String: "Exploit Report"
	/// </summary>
	public override string LabelExploitReport => "Informe de vulnerabilidad";

	/// <summary>
	/// Key: "Label.FirstName"
	/// First Name
	/// English String: "First Name"
	/// </summary>
	public override string LabelFirstName => "Nombre";

	/// <summary>
	/// Key: "Label.ForgotPassword"
	/// Forgot Password
	/// English String: "Forgot Password"
	/// </summary>
	public override string LabelForgotPassword => "Contraseña olvidada";

	/// <summary>
	/// Key: "Label.FreeRobux"
	/// Free Robux
	/// English String: "Free Robux"
	/// </summary>
	public override string LabelFreeRobux => "Robux gratis";

	/// <summary>
	/// Key: "Label.GameCredit"
	/// Game Card
	/// English String: "Game Card"
	/// </summary>
	public override string LabelGameCredit => "Tarjeta de juego";

	/// <summary>
	/// Key: "Label.GCPartialPayment"
	/// Purchase - Split Payment
	/// English String: "Purchase - Split Payment"
	/// </summary>
	public override string LabelGCPartialPayment => "Pagar una factura con diferentes métodos de pago";

	/// <summary>
	/// Key: "Label.GCRedeem"
	/// Game Card - Redeem
	/// English String: "Game Card - Redeem"
	/// </summary>
	public override string LabelGCRedeem => "Canjear una tarjeta de juego";

	/// <summary>
	/// Key: "Label.GCSpendCredit"
	/// Game Card - Spend Credit
	/// English String: "Game Card - Spend Credit"
	/// </summary>
	public override string LabelGCSpendCredit => "Utilizar el crédito de una tarjeta de juego";

	/// <summary>
	/// Key: "Label.HowTo"
	/// How To
	/// English String: "How To"
	/// </summary>
	public override string LabelHowTo => "Guía práctica";

	/// <summary>
	/// Key: "Label.HowToGeneral"
	/// How To - General
	/// English String: "How To - General"
	/// </summary>
	public override string LabelHowToGeneral => "Información general";

	/// <summary>
	/// Key: "Label.HowToOther"
	/// How To - Other
	/// English String: "How To - Other"
	/// </summary>
	public override string LabelHowToOther => "Otro tipo de información";

	public override string LabelIdeasSuggestions => "Ideas y sugerencias";

	/// <summary>
	/// Key: "Label.IPad"
	/// iPad
	/// English String: "iPad"
	/// </summary>
	public override string LabelIPad => "iPad";

	/// <summary>
	/// Key: "Label.IPhone"
	/// iPhone
	/// English String: "iPhone"
	/// </summary>
	public override string LabelIPhone => "iPhone";

	/// <summary>
	/// Key: "Label.IssueDescription"
	/// Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message.
	/// English String: "Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message."
	/// </summary>
	public override string LabelIssueDescription => "Describe el problema. Incluye cualquier información relevante como dónde ocurre o qué mensaje de error aparece.";

	/// <summary>
	/// Key: "Label.IWasScammed"
	/// I was Scammed
	/// English String: "I was Scammed"
	/// </summary>
	public override string LabelIWasScammed => "He sido víctima de una estafa";

	/// <summary>
	/// Key: "Label.Mac"
	/// Mac
	/// English String: "Mac"
	/// </summary>
	public override string LabelMac => "Mac";

	/// <summary>
	/// Key: "Label.Membership"
	/// Support page. Membership {{dc.field_membership}} stop_memb.
	/// English String: "Membership"
	/// </summary>
	public override string LabelMembership => "Suscripción";

	/// <summary>
	/// Key: "Label.Moderation"
	/// Moderation
	/// English String: "Moderation"
	/// </summary>
	public override string LabelModeration => "Moderación";

	/// <summary>
	/// Key: "Label.OtherSiteClaim"
	/// Other Site Claim
	/// English String: "Other Site Claim"
	/// </summary>
	public override string LabelOtherSiteClaim => "Otras denuncias";

	/// <summary>
	/// Key: "Label.OwnerDMCAClaim"
	/// Owner DMCA Claim
	/// English String: "Owner DMCA Claim"
	/// </summary>
	public override string LabelOwnerDMCAClaim => "Denunciar infracción de mis derechos";

	/// <summary>
	/// Key: "Label.PC"
	/// PC
	/// English String: "PC"
	/// </summary>
	public override string LabelPC => "PC";

	/// <summary>
	/// Key: "Label.PhysicalToyIssue"
	/// Physical Toy Issue
	/// English String: "Physical Toy Issue"
	/// </summary>
	public override string LabelPhysicalToyIssue => "Problemas con el juguete";

	/// <summary>
	/// Key: "Label.PleaseSelect"
	/// Please Select...
	/// English String: "Please Select..."
	/// </summary>
	public override string LabelPleaseSelect => "Seleccionar...";

	/// <summary>
	/// Key: "Label.PrizeNotReceived"
	/// Prize Not Received
	/// English String: "Prize Not Received"
	/// </summary>
	public override string LabelPrizeNotReceived => "Premio no recibido";

	/// <summary>
	/// Key: "Label.PurchaseDeclined"
	/// Purchase - Declined
	/// English String: "Purchase - Declined"
	/// </summary>
	public override string LabelPurchaseDeclined => "Compra rechazada";

	/// <summary>
	/// Key: "Label.PurchaseDidNotReceive"
	/// Purchase - Did Not Receive
	/// English String: "Purchase - Did Not Receive"
	/// </summary>
	public override string LabelPurchaseDidNotReceive => "Compra no recibida";

	/// <summary>
	/// Key: "Label.PurchaseUnauthorizedCharge"
	/// Purchase - Unauthorized Charge
	/// English String: "Purchase - Unauthorized Charge"
	/// </summary>
	public override string LabelPurchaseUnauthorizedCharge => "Compra no autorizada";

	/// <summary>
	/// Key: "Label.ReportPhish"
	/// Report Phishing Site
	/// English String: "Report Phishing Site"
	/// </summary>
	public override string LabelReportPhish => "Denunciar un sitio fraudulento";

	/// <summary>
	/// Key: "Label.RobloxCrashing"
	/// Roblox Crashing
	/// English String: "Roblox Crashing"
	/// </summary>
	public override string LabelRobloxCrashing => "Roblox se cuelga";

	/// <summary>
	/// Key: "Label.RobloxToys"
	/// Roblox Toys
	/// English String: "Roblox Toys"
	/// </summary>
	public override string LabelRobloxToys => "Juguetes de Roblox";

	/// <summary>
	/// Key: "Label.Robux"
	/// Robux
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.RobuxPurchaseIssue"
	/// Robux - Purchase Issue
	/// English String: "Robux - Purchase Issue"
	/// </summary>
	public override string LabelRobuxPurchaseIssue => "Problemas con la compra de Robux";

	/// <summary>
	/// Key: "Label.SafetyInquiry"
	/// Inappropriate game or user behavior
	/// English String: "Inappropriate game or user behavior"
	/// </summary>
	public override string LabelSafetyInquiry => "Juego o comportamiento de usuario inadecuado";

	/// <summary>
	/// Key: "Label.SafetyQueueTicket"
	/// User Safety Concern
	/// English String: "User Safety Concern"
	/// </summary>
	public override string LabelSafetyQueueTicket => "Seguridad del usuario";

	/// <summary>
	/// Key: "Label.SpecificGameIssue"
	/// Specific Game Issue
	/// English String: "Specific Game Issue"
	/// </summary>
	public override string LabelSpecificGameIssue => "Problemas específicos de un juego";

	/// <summary>
	/// Key: "Label.Submit"
	/// Submit
	/// English String: "Submit"
	/// </summary>
	public override string LabelSubmit => "Enviar";

	/// <summary>
	/// Key: "Label.SuggestFeature"
	/// Feature Suggestion
	/// English String: "Feature Suggestion"
	/// </summary>
	public override string LabelSuggestFeature => "Sugerir una función";

	/// <summary>
	/// Key: "Label.SuggestFeedback"
	/// Feedback
	/// English String: "Feedback"
	/// </summary>
	public override string LabelSuggestFeedback => "Hacer un comentario";

	/// <summary>
	/// Key: "Label.TechnicalSupport"
	/// Technical Support
	/// English String: "Technical Support"
	/// </summary>
	public override string LabelTechnicalSupport => "Asistencia técnica";

	/// <summary>
	/// Key: "Label.ToyCodeIssue"
	/// Toy Code Issue
	/// English String: "Toy Code Issue"
	/// </summary>
	public override string LabelToyCodeIssue => "Problemas con el código del juguete";

	/// <summary>
	/// Key: "Label.TwoStepV"
	/// 2-Step Verification
	/// English String: "2-Step Verification"
	/// </summary>
	public override string LabelTwoStepV => "Verificación en dos pasos";

	/// <summary>
	/// Key: "Label.UserAbuseReport"
	/// Report User Breaking Rules
	/// English String: "Report User Breaking Rules"
	/// </summary>
	public override string LabelUserAbuseReport => "Denunciar a un usuario que infringe las normas";

	/// <summary>
	/// Key: "Label.Username"
	/// Username
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Nombre de usuario";

	/// <summary>
	/// Key: "Label.VCCatalog"
	/// Website Item
	/// English String: "Website Item"
	/// </summary>
	public override string LabelVCCatalog => "Objeto en el sitio web";

	/// <summary>
	/// Key: "Label.VCInGame"
	/// In-Game Item
	/// English String: "In-Game Item"
	/// </summary>
	public override string LabelVCInGame => "Objeto en el juego";

	/// <summary>
	/// Key: "Label.Xbox"
	/// Xbox
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "Response.Dialog.ErrorWithoutContext"
	/// Something went wrong, please try again later.
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogErrorWithoutContext => "Algo ha ido mal. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Pulsa Enviar para enviar un ticket o Cancelar para editar el nombre de usuario. Proporcionar el nombre de usuario puede ayudar a priorizar tu problema.";

	/// <summary>
	/// Key: "Response.Dialog.RequestReceived"
	/// Thank you for contacting Roblox. Please check your email for a message from Customer Service.
	/// English String: "Thank you for contacting Roblox. Please check your email for a message from Customer Service."
	/// </summary>
	public override string ResponseDialogRequestReceived => "Gracias por contactarte con Roblox. Busca un mensaje de servicio al cliente en tu correo electrónico. ";

	/// <summary>
	/// Key: "Response.Dialog.TooManyAttemptsError"
	/// Too many attempts. Try again later.
	/// English String: "Too many attempts. Try again later."
	/// </summary>
	public override string ResponseDialogTooManyAttemptsError => "Demasiados intentos. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.TryAgainError"
	/// An error occurred. Try again later.
	/// English String: "An error occurred. Try again later."
	/// </summary>
	public override string ResponseDialogTryAgainError => "Se ha producido un error. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.EmailFormatError"
	/// Please enter a properly formatted email address
	/// English String: "Please enter a properly formatted email address"
	/// </summary>
	public override string ResponseEmailFormatError => "Introduce una dirección de correo electrónico con el formato correcto.";

	/// <summary>
	/// Key: "Response.EmailNotMatching"
	/// Email address does not match
	/// English String: "Email address does not match"
	/// </summary>
	public override string ResponseEmailNotMatching => "Las direcciones de correo electrónico no coinciden.";

	/// <summary>
	/// Key: "Response.InvalidFirstName"
	/// Please enter a valid first name
	/// English String: "Please enter a valid first name"
	/// </summary>
	public override string ResponseInvalidFirstName => "Introduce un nombre válido.";

	/// <summary>
	/// Key: "Response.InvalidUsername"
	/// That doesn't appear to be a valid Roblox username.
	/// English String: "That doesn't appear to be a valid Roblox username."
	/// </summary>
	public override string ResponseInvalidUsername => "No parece ser un nombre de usuario válido de Roblox.";

	/// <summary>
	/// Key: "Response.Under13Email"
	/// If you are under 13 years old, please provide your parent's email address
	/// English String: "If you are under 13 years old, please provide your parent's email address"
	/// </summary>
	public override string ResponseUnder13Email => "Si eres menor de 13 años, proporciona la dirección de correo electrónico de uno de tus padres.";

	public SupportResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogOK()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForHeadingContactInformation()
	{
		return "Información de contacto";
	}

	protected override string _GetTemplateForHeadingDescriptionOfIssue()
	{
		return "Descripción del problema";
	}

	protected override string _GetTemplateForHeadingDeviceWithProblem()
	{
		return "¿En qué dispositivo ocurre el problema?";
	}

	protected override string _GetTemplateForHeadingDialogErrorWithoutContext()
	{
		return "Error";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nombre de usuario no válido";
	}

	protected override string _GetTemplateForHeadingDialogRequestReceived()
	{
		return "Solicitud recibida";
	}

	protected override string _GetTemplateForHeadingHelpCategoryType()
	{
		return "Categorías de ayuda";
	}

	protected override string _GetTemplateForHeadingIssueDetails()
	{
		return "Detalles del problema";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Contáctanos";
	}

	protected override string _GetTemplateForLabelAccountHacked()
	{
		return "Cuenta hackeada";
	}

	protected override string _GetTemplateForLabelAccountOwnership()
	{
		return "Cuenta hackeada o no puedo iniciar sesión";
	}

	protected override string _GetTemplateForLabelAccountPin()
	{
		return "PIN de la cuenta";
	}

	protected override string _GetTemplateForLabelAdjustChildSettings()
	{
		return "Ajustar la configuración de privacidad y seguridad del menor";
	}

	protected override string _GetTemplateForLabelAmazonDevice()
	{
		return "Dispositivo Amazon";
	}

	protected override string _GetTemplateForLabelAndroidPhone()
	{
		return "Teléfono Android";
	}

	protected override string _GetTemplateForLabelAndroidTablet()
	{
		return "Tablet Android";
	}

	protected override string _GetTemplateForLabelAppealAccountContent()
	{
		return "Apelar una cuenta o contenido";
	}

	protected override string _GetTemplateForLabelAppealFriend()
	{
		return "Apelar por un amigo";
	}

	protected override string _GetTemplateForLabelBilling()
	{
		return "Facturación y pagos";
	}

	protected override string _GetTemplateForLabelBugReport()
	{
		return "Informe de error";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelCancelMembership()
	{
		return "Cancelar membresía";
	}

	protected override string _GetTemplateForLabelCannotInstall()
	{
		return "Problemas para instalar Roblox o Studio";
	}

	protected override string _GetTemplateForLabelCannotPlayGame()
	{
		return "Problemas para jugar";
	}

	protected override string _GetTemplateForLabelChangeChildAge()
	{
		return "Cambiar la edad del menor";
	}

	protected override string _GetTemplateForLabelChatAgeSettings()
	{
		return "Configuración de chat y edad";
	}

	protected override string _GetTemplateForLabelChromebook()
	{
		return "Chromebook";
	}

	protected override string _GetTemplateForLabelConfirmEmail()
	{
		return "Confirmar dirección de correo electrónico";
	}

	protected override string _GetTemplateForLabelContentAbuseReport()
	{
		return "Denunciar contenido que infringe las normas";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Concursos y eventos";
	}

	protected override string _GetTemplateForLabelContestEventQuestion()
	{
		return "Pregunta o problema";
	}

	protected override string _GetTemplateForLabelCSCharacter()
	{
		return "Calidad del servicio al cliente";
	}

	protected override string _GetTemplateForLabelDescribeIssue()
	{
		return "Describe el problema que tienes.";
	}

	protected override string _GetTemplateForLabelDevEx()
	{
		return "DevEx";
	}

	protected override string _GetTemplateForLabelDevExHowTo()
	{
		return "Guía práctica del DevEx";
	}

	protected override string _GetTemplateForLabelDevExMyRequest()
	{
		return "Mi solicitud al DevEx";
	}

	protected override string _GetTemplateForLabelDMCA()
	{
		return "Ley de Derechos de Autor";
	}

	protected override string _GetTemplateForLabelEmailAddress()
	{
		return "Dirección de correo electrónico";
	}

	protected override string _GetTemplateForLabelExploitReport()
	{
		return "Informe de vulnerabilidad";
	}

	protected override string _GetTemplateForLabelFirstName()
	{
		return "Nombre";
	}

	protected override string _GetTemplateForLabelForgotPassword()
	{
		return "Contraseña olvidada";
	}

	protected override string _GetTemplateForLabelFreeRobux()
	{
		return "Robux gratis";
	}

	protected override string _GetTemplateForLabelGameCredit()
	{
		return "Tarjeta de juego";
	}

	protected override string _GetTemplateForLabelGCPartialPayment()
	{
		return "Pagar una factura con diferentes métodos de pago";
	}

	protected override string _GetTemplateForLabelGCRedeem()
	{
		return "Canjear una tarjeta de juego";
	}

	protected override string _GetTemplateForLabelGCSpendCredit()
	{
		return "Utilizar el crédito de una tarjeta de juego";
	}

	protected override string _GetTemplateForLabelHowTo()
	{
		return "Guía práctica";
	}

	protected override string _GetTemplateForLabelHowToGeneral()
	{
		return "Información general";
	}

	protected override string _GetTemplateForLabelHowToOther()
	{
		return "Otro tipo de información";
	}

	protected override string _GetTemplateForLabelIdeasSuggestions()
	{
		return "Ideas y sugerencias";
	}

	protected override string _GetTemplateForLabelIPad()
	{
		return "iPad";
	}

	protected override string _GetTemplateForLabelIPhone()
	{
		return "iPhone";
	}

	protected override string _GetTemplateForLabelIssueDescription()
	{
		return "Describe el problema. Incluye cualquier información relevante como dónde ocurre o qué mensaje de error aparece.";
	}

	protected override string _GetTemplateForLabelIWasScammed()
	{
		return "He sido víctima de una estafa";
	}

	protected override string _GetTemplateForLabelMac()
	{
		return "Mac";
	}

	protected override string _GetTemplateForLabelMembership()
	{
		return "Suscripción";
	}

	protected override string _GetTemplateForLabelModeration()
	{
		return "Moderación";
	}

	protected override string _GetTemplateForLabelOtherSiteClaim()
	{
		return "Otras denuncias";
	}

	protected override string _GetTemplateForLabelOwnerDMCAClaim()
	{
		return "Denunciar infracción de mis derechos";
	}

	protected override string _GetTemplateForLabelPC()
	{
		return "PC";
	}

	protected override string _GetTemplateForLabelPhysicalToyIssue()
	{
		return "Problemas con el juguete";
	}

	protected override string _GetTemplateForLabelPleaseSelect()
	{
		return "Seleccionar...";
	}

	protected override string _GetTemplateForLabelPrizeNotReceived()
	{
		return "Premio no recibido";
	}

	protected override string _GetTemplateForLabelPurchaseDeclined()
	{
		return "Compra rechazada";
	}

	protected override string _GetTemplateForLabelPurchaseDidNotReceive()
	{
		return "Compra no recibida";
	}

	protected override string _GetTemplateForLabelPurchaseUnauthorizedCharge()
	{
		return "Compra no autorizada";
	}

	protected override string _GetTemplateForLabelReportPhish()
	{
		return "Denunciar un sitio fraudulento";
	}

	protected override string _GetTemplateForLabelRobloxCrashing()
	{
		return "Roblox se cuelga";
	}

	protected override string _GetTemplateForLabelRobloxToys()
	{
		return "Juguetes de Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelRobuxPurchaseIssue()
	{
		return "Problemas con la compra de Robux";
	}

	protected override string _GetTemplateForLabelSafetyInquiry()
	{
		return "Juego o comportamiento de usuario inadecuado";
	}

	protected override string _GetTemplateForLabelSafetyQueueTicket()
	{
		return "Seguridad del usuario";
	}

	protected override string _GetTemplateForLabelSpecificGameIssue()
	{
		return "Problemas específicos de un juego";
	}

	protected override string _GetTemplateForLabelSubmit()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForLabelSuggestFeature()
	{
		return "Sugerir una función";
	}

	protected override string _GetTemplateForLabelSuggestFeedback()
	{
		return "Hacer un comentario";
	}

	protected override string _GetTemplateForLabelTechnicalSupport()
	{
		return "Asistencia técnica";
	}

	protected override string _GetTemplateForLabelToyCodeIssue()
	{
		return "Problemas con el código del juguete";
	}

	protected override string _GetTemplateForLabelTwoStepV()
	{
		return "Verificación en dos pasos";
	}

	protected override string _GetTemplateForLabelUserAbuseReport()
	{
		return "Denunciar a un usuario que infringe las normas";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nombre de usuario";
	}

	protected override string _GetTemplateForLabelVCCatalog()
	{
		return "Objeto en el sitio web";
	}

	protected override string _GetTemplateForLabelVCInGame()
	{
		return "Objeto en el juego";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForResponseDialogErrorWithoutContext()
	{
		return "Algo ha ido mal. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Pulsa Enviar para enviar un ticket o Cancelar para editar el nombre de usuario. Proporcionar el nombre de usuario puede ayudar a priorizar tu problema.";
	}

	protected override string _GetTemplateForResponseDialogRequestReceived()
	{
		return "Gracias por contactarte con Roblox. Busca un mensaje de servicio al cliente en tu correo electrónico. ";
	}

	protected override string _GetTemplateForResponseDialogTooManyAttemptsError()
	{
		return "Demasiados intentos. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogTryAgainError()
	{
		return "Se ha producido un error. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseEmailFormatError()
	{
		return "Introduce una dirección de correo electrónico con el formato correcto.";
	}

	protected override string _GetTemplateForResponseEmailNotMatching()
	{
		return "Las direcciones de correo electrónico no coinciden.";
	}

	protected override string _GetTemplateForResponseInvalidFirstName()
	{
		return "Introduce un nombre válido.";
	}

	protected override string _GetTemplateForResponseInvalidUsername()
	{
		return "No parece ser un nombre de usuario válido de Roblox.";
	}

	protected override string _GetTemplateForResponseUnder13Email()
	{
		return "Si eres menor de 13 años, proporciona la dirección de correo electrónico de uno de tus padres.";
	}
}
