namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides SupportResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class SupportResources_de_de : SupportResources_en_us, ISupportResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Abbrechen";

	/// <summary>
	/// Key: "Action.Dialog.OK"
	/// OK
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogOK => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Senden";

	/// <summary>
	/// Key: "Heading.ContactInformation"
	/// Contact Information
	/// English String: "Contact Information"
	/// </summary>
	public override string HeadingContactInformation => "Kontaktdaten";

	/// <summary>
	/// Key: "Heading.DescriptionOfIssue"
	/// Description of issue
	/// English String: "Description of issue"
	/// </summary>
	public override string HeadingDescriptionOfIssue => "Beschreibung des Problems";

	/// <summary>
	/// Key: "Heading.DeviceWithProblem"
	/// What device are you having the problem on?
	/// English String: "What device are you having the problem on?"
	/// </summary>
	public override string HeadingDeviceWithProblem => "Auf welchem Gerät hast du ein Problem?";

	/// <summary>
	/// Key: "Heading.Dialog.ErrorWithoutContext"
	/// Error
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogErrorWithoutContext => "Fehler";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Ungültiger Benutzername";

	/// <summary>
	/// Key: "Heading.Dialog.RequestReceived"
	/// Request Received
	/// English String: "Request Received"
	/// </summary>
	public override string HeadingDialogRequestReceived => "Anfrage erhalten";

	/// <summary>
	/// Key: "Heading.HelpCategoryType"
	/// Type of help category
	/// English String: "Type of help category"
	/// </summary>
	public override string HeadingHelpCategoryType => "Art der Hilfekategorie";

	/// <summary>
	/// Key: "Heading.IssueDetails"
	/// Issue Details
	/// English String: "Issue Details"
	/// </summary>
	public override string HeadingIssueDetails => "Problemdetails";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// Contact Us
	/// English String: "Contact Us"
	/// </summary>
	public override string HeadingPageTitle => "Kontakt";

	/// <summary>
	/// Key: "Label.AccountHacked"
	/// Account Hacked
	/// English String: "Account Hacked"
	/// </summary>
	public override string LabelAccountHacked => "Konto gehackt";

	/// <summary>
	/// Key: "Label.AccountOwnership"
	/// Account Hacked or Can't Log in
	/// English String: "Account Hacked or Can't Log in"
	/// </summary>
	public override string LabelAccountOwnership => "Konto gehackt oder Anmeldung nicht möglich";

	/// <summary>
	/// Key: "Label.AccountPin"
	/// Account PIN
	/// English String: "Account PIN"
	/// </summary>
	public override string LabelAccountPin => "Konto-PIN";

	public override string LabelAdjustChildSettings => "Datenschutz- und Sicherheitseinstellungen für Kinder anpassen";

	/// <summary>
	/// Key: "Label.AmazonDevice"
	/// Amazon Device
	/// English String: "Amazon Device"
	/// </summary>
	public override string LabelAmazonDevice => "Amazon-Gerät";

	/// <summary>
	/// Key: "Label.AndroidPhone"
	/// Android Phone
	/// English String: "Android Phone"
	/// </summary>
	public override string LabelAndroidPhone => "Android-Handy";

	/// <summary>
	/// Key: "Label.AndroidTablet"
	/// Android Tablet
	/// English String: "Android Tablet"
	/// </summary>
	public override string LabelAndroidTablet => "Android-Tablet";

	/// <summary>
	/// Key: "Label.AppealAccountContent"
	/// Appeal Account or Content
	/// English String: "Appeal Account or Content"
	/// </summary>
	public override string LabelAppealAccountContent => "Beschwerde über Konto oder Inhalt";

	/// <summary>
	/// Key: "Label.AppealFriend"
	/// Appeal for Friend
	/// English String: "Appeal for Friend"
	/// </summary>
	public override string LabelAppealFriend => "Beschwerde für Freund";

	public override string LabelBilling => "Zahlungen";

	/// <summary>
	/// Key: "Label.BugReport"
	/// Bug Report
	/// English String: "Bug Report"
	/// </summary>
	public override string LabelBugReport => "Fehlerbericht";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// Builders Club
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.CancelMembership"
	/// Cancel Membership
	/// English String: "Cancel Membership"
	/// </summary>
	public override string LabelCancelMembership => "Mitgliedschaft kündigen";

	/// <summary>
	/// Key: "Label.CannotInstall"
	/// Cannot Install Roblox or Studio
	/// English String: "Cannot Install Roblox or Studio"
	/// </summary>
	public override string LabelCannotInstall => "Kann Roblox oder Studio nicht installieren";

	/// <summary>
	/// Key: "Label.CannotPlayGame"
	/// Cannot Play Game
	/// English String: "Cannot Play Game"
	/// </summary>
	public override string LabelCannotPlayGame => "Kann Spiel nicht spielen";

	/// <summary>
	/// Key: "Label.ChangeChildAge"
	/// Change Child Age
	/// English String: "Change Child Age"
	/// </summary>
	public override string LabelChangeChildAge => "Alter des Kinds ändern";

	public override string LabelChatAgeSettings => "Chat und Alterseinstellungen";

	/// <summary>
	/// Key: "Label.Chromebook"
	/// Chromebook
	/// English String: "Chromebook"
	/// </summary>
	public override string LabelChromebook => "Chromebook";

	/// <summary>
	/// Key: "Label.ConfirmEmail"
	/// Confirm Email Address
	/// English String: "Confirm Email Address"
	/// </summary>
	public override string LabelConfirmEmail => "E-Mail-Adresse bestätigen";

	/// <summary>
	/// Key: "Label.ContentAbuseReport"
	/// Report Content Breaking Rules
	/// English String: "Report Content Breaking Rules"
	/// </summary>
	public override string LabelContentAbuseReport => "Regelverstoß bei Inhalt melden";

	public override string LabelContest => "Wettbewerbe und Events";

	/// <summary>
	/// Key: "Label.ContestEventQuestion"
	/// Question or Issue
	/// English String: "Question or Issue"
	/// </summary>
	public override string LabelContestEventQuestion => "Frage oder Problem";

	/// <summary>
	/// Key: "Label.CSCharacter"
	/// Customer Service Character
	/// English String: "Customer Service Character"
	/// </summary>
	public override string LabelCSCharacter => "Customer Service Character";

	/// <summary>
	/// Key: "Label.DescribeIssue"
	/// Please describe your issue
	/// English String: "Please describe your issue"
	/// </summary>
	public override string LabelDescribeIssue => "Bitte beschreibe dein Problem.";

	/// <summary>
	/// Key: "Label.DevEx"
	/// DevEx
	/// English String: "DevEx"
	/// </summary>
	public override string LabelDevEx => "DevEx";

	/// <summary>
	/// Key: "Label.DevExHowTo"
	/// DevEx How To
	/// English String: "DevEx How To"
	/// </summary>
	public override string LabelDevExHowTo => "DevEx-Anleitung";

	/// <summary>
	/// Key: "Label.DevExMyRequest"
	/// DevEx My Request
	/// English String: "DevEx My Request"
	/// </summary>
	public override string LabelDevExMyRequest => "DevEx\u00a0– Meine Anfrage";

	/// <summary>
	/// Key: "Label.DMCA"
	/// DMCA
	/// English String: "DMCA"
	/// </summary>
	public override string LabelDMCA => "Urheberrecht";

	/// <summary>
	/// Key: "Label.EmailAddress"
	/// Email Address
	/// English String: "Email Address"
	/// </summary>
	public override string LabelEmailAddress => "E-Mail-Adresse";

	/// <summary>
	/// Key: "Label.ExploitReport"
	/// Exploit Report
	/// English String: "Exploit Report"
	/// </summary>
	public override string LabelExploitReport => "Schummel-Bericht";

	/// <summary>
	/// Key: "Label.FirstName"
	/// First Name
	/// English String: "First Name"
	/// </summary>
	public override string LabelFirstName => "Vorname";

	/// <summary>
	/// Key: "Label.ForgotPassword"
	/// Forgot Password
	/// English String: "Forgot Password"
	/// </summary>
	public override string LabelForgotPassword => "Passwort vergessen";

	/// <summary>
	/// Key: "Label.FreeRobux"
	/// Free Robux
	/// English String: "Free Robux"
	/// </summary>
	public override string LabelFreeRobux => "Gratis-Robux";

	/// <summary>
	/// Key: "Label.GameCredit"
	/// Game Card
	/// English String: "Game Card"
	/// </summary>
	public override string LabelGameCredit => "Spielkarte";

	/// <summary>
	/// Key: "Label.GCPartialPayment"
	/// Purchase - Split Payment
	/// English String: "Purchase - Split Payment"
	/// </summary>
	public override string LabelGCPartialPayment => "Kauf\u00a0– Bezahlung aufteilen";

	/// <summary>
	/// Key: "Label.GCRedeem"
	/// Game Card - Redeem
	/// English String: "Game Card - Redeem"
	/// </summary>
	public override string LabelGCRedeem => "Spielkarte\u00a0– Einlösen";

	/// <summary>
	/// Key: "Label.GCSpendCredit"
	/// Game Card - Spend Credit
	/// English String: "Game Card - Spend Credit"
	/// </summary>
	public override string LabelGCSpendCredit => "Spielkarte\u00a0– Guthaben ausgeben";

	/// <summary>
	/// Key: "Label.HowTo"
	/// How To
	/// English String: "How To"
	/// </summary>
	public override string LabelHowTo => "Anleitung";

	/// <summary>
	/// Key: "Label.HowToGeneral"
	/// How To - General
	/// English String: "How To - General"
	/// </summary>
	public override string LabelHowToGeneral => "Anleitung\u00a0– Allgemein";

	/// <summary>
	/// Key: "Label.HowToOther"
	/// How To - Other
	/// English String: "How To - Other"
	/// </summary>
	public override string LabelHowToOther => "Anleitung\u00a0– Sonstiges";

	public override string LabelIdeasSuggestions => "Ideen und Vorschläge";

	/// <summary>
	/// Key: "Label.IPad"
	/// iPad
	/// English String: "iPad"
	/// </summary>
	public override string LabelIPad => "iPad";

	/// <summary>
	/// Key: "Label.IPhone"
	/// iPhone
	/// English String: "iPhone"
	/// </summary>
	public override string LabelIPhone => "iPhone";

	/// <summary>
	/// Key: "Label.IssueDescription"
	/// Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message.
	/// English String: "Please describe the issue that you are facing. Include any relevant information like where the issue is occurring or the error message."
	/// </summary>
	public override string LabelIssueDescription => "Bitte beschreibe das Problem, das aufgetreten ist. Füge alle relevanten Informationen hinzu, z.\u00a0B. wo das Problem auftritt oder die Fehlermeldung.";

	/// <summary>
	/// Key: "Label.IWasScammed"
	/// I was Scammed
	/// English String: "I was Scammed"
	/// </summary>
	public override string LabelIWasScammed => "Ich wurde betrogen";

	/// <summary>
	/// Key: "Label.Mac"
	/// Mac
	/// English String: "Mac"
	/// </summary>
	public override string LabelMac => "Mac";

	/// <summary>
	/// Key: "Label.Membership"
	/// Support page. Membership {{dc.field_membership}} stop_memb.
	/// English String: "Membership"
	/// </summary>
	public override string LabelMembership => "Mitgliedschaft";

	/// <summary>
	/// Key: "Label.Moderation"
	/// Moderation
	/// English String: "Moderation"
	/// </summary>
	public override string LabelModeration => "Moderation";

	/// <summary>
	/// Key: "Label.OtherSiteClaim"
	/// Other Site Claim
	/// English String: "Other Site Claim"
	/// </summary>
	public override string LabelOtherSiteClaim => "Beschwerde einer anderen Seite";

	/// <summary>
	/// Key: "Label.OwnerDMCAClaim"
	/// Owner DMCA Claim
	/// English String: "Owner DMCA Claim"
	/// </summary>
	public override string LabelOwnerDMCAClaim => "Besitzer meldet Urheberrechtsverletzung";

	/// <summary>
	/// Key: "Label.PC"
	/// PC
	/// English String: "PC"
	/// </summary>
	public override string LabelPC => "PC";

	/// <summary>
	/// Key: "Label.PhysicalToyIssue"
	/// Physical Toy Issue
	/// English String: "Physical Toy Issue"
	/// </summary>
	public override string LabelPhysicalToyIssue => "Problem mit materiellem Spielzeug";

	/// <summary>
	/// Key: "Label.PleaseSelect"
	/// Please Select...
	/// English String: "Please Select..."
	/// </summary>
	public override string LabelPleaseSelect => "Bitte wähle\u00a0...";

	/// <summary>
	/// Key: "Label.PrizeNotReceived"
	/// Prize Not Received
	/// English String: "Prize Not Received"
	/// </summary>
	public override string LabelPrizeNotReceived => "Preis nicht erhalten";

	/// <summary>
	/// Key: "Label.PurchaseDeclined"
	/// Purchase - Declined
	/// English String: "Purchase - Declined"
	/// </summary>
	public override string LabelPurchaseDeclined => "Kauf\u00a0– Bezahlung abgelehnt";

	/// <summary>
	/// Key: "Label.PurchaseDidNotReceive"
	/// Purchase - Did Not Receive
	/// English String: "Purchase - Did Not Receive"
	/// </summary>
	public override string LabelPurchaseDidNotReceive => "Kauf\u00a0– Artikel nicht erhalten";

	/// <summary>
	/// Key: "Label.PurchaseUnauthorizedCharge"
	/// Purchase - Unauthorized Charge
	/// English String: "Purchase - Unauthorized Charge"
	/// </summary>
	public override string LabelPurchaseUnauthorizedCharge => "Kauf\u00a0– Unerlaubte Kontobelastung";

	/// <summary>
	/// Key: "Label.ReportPhish"
	/// Report Phishing Site
	/// English String: "Report Phishing Site"
	/// </summary>
	public override string LabelReportPhish => "Phishing-Seite melden";

	/// <summary>
	/// Key: "Label.RobloxCrashing"
	/// Roblox Crashing
	/// English String: "Roblox Crashing"
	/// </summary>
	public override string LabelRobloxCrashing => "Roblox stürzt ab";

	/// <summary>
	/// Key: "Label.RobloxToys"
	/// Roblox Toys
	/// English String: "Roblox Toys"
	/// </summary>
	public override string LabelRobloxToys => "Roblox-Spielzeug";

	/// <summary>
	/// Key: "Label.Robux"
	/// Robux
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "Label.RobuxPurchaseIssue"
	/// Robux - Purchase Issue
	/// English String: "Robux - Purchase Issue"
	/// </summary>
	public override string LabelRobuxPurchaseIssue => "Robux\u00a0– Problem beim Kauf";

	/// <summary>
	/// Key: "Label.SafetyInquiry"
	/// Inappropriate game or user behavior
	/// English String: "Inappropriate game or user behavior"
	/// </summary>
	public override string LabelSafetyInquiry => "Unangemessenes Verhalten von Spiel oder Benutzer";

	/// <summary>
	/// Key: "Label.SafetyQueueTicket"
	/// User Safety Concern
	/// English String: "User Safety Concern"
	/// </summary>
	public override string LabelSafetyQueueTicket => "Sicherheitsproblem für Benutzer";

	/// <summary>
	/// Key: "Label.SpecificGameIssue"
	/// Specific Game Issue
	/// English String: "Specific Game Issue"
	/// </summary>
	public override string LabelSpecificGameIssue => "Problem mit bestimmtem Spiel";

	/// <summary>
	/// Key: "Label.Submit"
	/// Submit
	/// English String: "Submit"
	/// </summary>
	public override string LabelSubmit => "Senden";

	/// <summary>
	/// Key: "Label.SuggestFeature"
	/// Feature Suggestion
	/// English String: "Feature Suggestion"
	/// </summary>
	public override string LabelSuggestFeature => "Vorschlag für Feature";

	/// <summary>
	/// Key: "Label.SuggestFeedback"
	/// Feedback
	/// English String: "Feedback"
	/// </summary>
	public override string LabelSuggestFeedback => "Feedback";

	/// <summary>
	/// Key: "Label.TechnicalSupport"
	/// Technical Support
	/// English String: "Technical Support"
	/// </summary>
	public override string LabelTechnicalSupport => "Technischer Support";

	/// <summary>
	/// Key: "Label.ToyCodeIssue"
	/// Toy Code Issue
	/// English String: "Toy Code Issue"
	/// </summary>
	public override string LabelToyCodeIssue => "Problem mit Spielzeugcode";

	/// <summary>
	/// Key: "Label.TwoStepV"
	/// 2-Step Verification
	/// English String: "2-Step Verification"
	/// </summary>
	public override string LabelTwoStepV => "Verifizierung in 2 Schritten";

	/// <summary>
	/// Key: "Label.UserAbuseReport"
	/// Report User Breaking Rules
	/// English String: "Report User Breaking Rules"
	/// </summary>
	public override string LabelUserAbuseReport => "Regelverstoß von Benutzer melden";

	/// <summary>
	/// Key: "Label.Username"
	/// Username
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Benutzername";

	/// <summary>
	/// Key: "Label.VCCatalog"
	/// Website Item
	/// English String: "Website Item"
	/// </summary>
	public override string LabelVCCatalog => "Website-Artikel";

	/// <summary>
	/// Key: "Label.VCInGame"
	/// In-Game Item
	/// English String: "In-Game Item"
	/// </summary>
	public override string LabelVCInGame => "Artikel im Spiel";

	/// <summary>
	/// Key: "Label.Xbox"
	/// Xbox
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "Response.Dialog.ErrorWithoutContext"
	/// Something went wrong, please try again later.
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogErrorWithoutContext => "Etwas ist schiefgelaufen. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Wähle „Senden“, um das Ticket einzureichen, oder „Abbrechen“, um den Benutzernamen zu bearbeiten. Bei deinem Benutzernamen handelt es sich um eine wichtige Information, durch die dein Problem schneller bearbeitet werden kann.";

	/// <summary>
	/// Key: "Response.Dialog.RequestReceived"
	/// Thank you for contacting Roblox. Please check your email for a message from Customer Service.
	/// English String: "Thank you for contacting Roblox. Please check your email for a message from Customer Service."
	/// </summary>
	public override string ResponseDialogRequestReceived => "Danke, dass du Roblox kontaktiert hast. Eine Nachricht von unserem Kundenservice findest du in deinem E-Mail-Posteingang.";

	/// <summary>
	/// Key: "Response.Dialog.TooManyAttemptsError"
	/// Too many attempts. Try again later.
	/// English String: "Too many attempts. Try again later."
	/// </summary>
	public override string ResponseDialogTooManyAttemptsError => "Zu viele Versuche. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.TryAgainError"
	/// An error occurred. Try again later.
	/// English String: "An error occurred. Try again later."
	/// </summary>
	public override string ResponseDialogTryAgainError => "Ein Fehler ist aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.EmailFormatError"
	/// Please enter a properly formatted email address
	/// English String: "Please enter a properly formatted email address"
	/// </summary>
	public override string ResponseEmailFormatError => "Bitte gib eine E-Mail-Adresse im korrekten Format an.";

	/// <summary>
	/// Key: "Response.EmailNotMatching"
	/// Email address does not match
	/// English String: "Email address does not match"
	/// </summary>
	public override string ResponseEmailNotMatching => "E-Mail-Adresse stimmt nicht überein.";

	/// <summary>
	/// Key: "Response.InvalidFirstName"
	/// Please enter a valid first name
	/// English String: "Please enter a valid first name"
	/// </summary>
	public override string ResponseInvalidFirstName => "Bitte gib einen gültigen Vornamen ein.";

	/// <summary>
	/// Key: "Response.InvalidUsername"
	/// That doesn't appear to be a valid Roblox username.
	/// English String: "That doesn't appear to be a valid Roblox username."
	/// </summary>
	public override string ResponseInvalidUsername => "Der Benutzername scheint kein gültiger Roblox-Benutzername zu sein.";

	/// <summary>
	/// Key: "Response.Under13Email"
	/// If you are under 13 years old, please provide your parent's email address
	/// English String: "If you are under 13 years old, please provide your parent's email address"
	/// </summary>
	public override string ResponseUnder13Email => "Wenn du unter 13 Jahre alt bist, gib bitte die E-Mail-Adresse deiner Eltern an.";

	public SupportResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionDialogOK()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Senden";
	}

	protected override string _GetTemplateForHeadingContactInformation()
	{
		return "Kontaktdaten";
	}

	protected override string _GetTemplateForHeadingDescriptionOfIssue()
	{
		return "Beschreibung des Problems";
	}

	protected override string _GetTemplateForHeadingDeviceWithProblem()
	{
		return "Auf welchem Gerät hast du ein Problem?";
	}

	protected override string _GetTemplateForHeadingDialogErrorWithoutContext()
	{
		return "Fehler";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Ungültiger Benutzername";
	}

	protected override string _GetTemplateForHeadingDialogRequestReceived()
	{
		return "Anfrage erhalten";
	}

	protected override string _GetTemplateForHeadingHelpCategoryType()
	{
		return "Art der Hilfekategorie";
	}

	protected override string _GetTemplateForHeadingIssueDetails()
	{
		return "Problemdetails";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Kontakt";
	}

	protected override string _GetTemplateForLabelAccountHacked()
	{
		return "Konto gehackt";
	}

	protected override string _GetTemplateForLabelAccountOwnership()
	{
		return "Konto gehackt oder Anmeldung nicht möglich";
	}

	protected override string _GetTemplateForLabelAccountPin()
	{
		return "Konto-PIN";
	}

	protected override string _GetTemplateForLabelAdjustChildSettings()
	{
		return "Datenschutz- und Sicherheitseinstellungen für Kinder anpassen";
	}

	protected override string _GetTemplateForLabelAmazonDevice()
	{
		return "Amazon-Gerät";
	}

	protected override string _GetTemplateForLabelAndroidPhone()
	{
		return "Android-Handy";
	}

	protected override string _GetTemplateForLabelAndroidTablet()
	{
		return "Android-Tablet";
	}

	protected override string _GetTemplateForLabelAppealAccountContent()
	{
		return "Beschwerde über Konto oder Inhalt";
	}

	protected override string _GetTemplateForLabelAppealFriend()
	{
		return "Beschwerde für Freund";
	}

	protected override string _GetTemplateForLabelBilling()
	{
		return "Zahlungen";
	}

	protected override string _GetTemplateForLabelBugReport()
	{
		return "Fehlerbericht";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelCancelMembership()
	{
		return "Mitgliedschaft kündigen";
	}

	protected override string _GetTemplateForLabelCannotInstall()
	{
		return "Kann Roblox oder Studio nicht installieren";
	}

	protected override string _GetTemplateForLabelCannotPlayGame()
	{
		return "Kann Spiel nicht spielen";
	}

	protected override string _GetTemplateForLabelChangeChildAge()
	{
		return "Alter des Kinds ändern";
	}

	protected override string _GetTemplateForLabelChatAgeSettings()
	{
		return "Chat und Alterseinstellungen";
	}

	protected override string _GetTemplateForLabelChromebook()
	{
		return "Chromebook";
	}

	protected override string _GetTemplateForLabelConfirmEmail()
	{
		return "E-Mail-Adresse bestätigen";
	}

	protected override string _GetTemplateForLabelContentAbuseReport()
	{
		return "Regelverstoß bei Inhalt melden";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Wettbewerbe und Events";
	}

	protected override string _GetTemplateForLabelContestEventQuestion()
	{
		return "Frage oder Problem";
	}

	protected override string _GetTemplateForLabelCSCharacter()
	{
		return "Customer Service Character";
	}

	protected override string _GetTemplateForLabelDescribeIssue()
	{
		return "Bitte beschreibe dein Problem.";
	}

	protected override string _GetTemplateForLabelDevEx()
	{
		return "DevEx";
	}

	protected override string _GetTemplateForLabelDevExHowTo()
	{
		return "DevEx-Anleitung";
	}

	protected override string _GetTemplateForLabelDevExMyRequest()
	{
		return "DevEx\u00a0– Meine Anfrage";
	}

	protected override string _GetTemplateForLabelDMCA()
	{
		return "Urheberrecht";
	}

	protected override string _GetTemplateForLabelEmailAddress()
	{
		return "E-Mail-Adresse";
	}

	protected override string _GetTemplateForLabelExploitReport()
	{
		return "Schummel-Bericht";
	}

	protected override string _GetTemplateForLabelFirstName()
	{
		return "Vorname";
	}

	protected override string _GetTemplateForLabelForgotPassword()
	{
		return "Passwort vergessen";
	}

	protected override string _GetTemplateForLabelFreeRobux()
	{
		return "Gratis-Robux";
	}

	protected override string _GetTemplateForLabelGameCredit()
	{
		return "Spielkarte";
	}

	protected override string _GetTemplateForLabelGCPartialPayment()
	{
		return "Kauf\u00a0– Bezahlung aufteilen";
	}

	protected override string _GetTemplateForLabelGCRedeem()
	{
		return "Spielkarte\u00a0– Einlösen";
	}

	protected override string _GetTemplateForLabelGCSpendCredit()
	{
		return "Spielkarte\u00a0– Guthaben ausgeben";
	}

	protected override string _GetTemplateForLabelHowTo()
	{
		return "Anleitung";
	}

	protected override string _GetTemplateForLabelHowToGeneral()
	{
		return "Anleitung\u00a0– Allgemein";
	}

	protected override string _GetTemplateForLabelHowToOther()
	{
		return "Anleitung\u00a0– Sonstiges";
	}

	protected override string _GetTemplateForLabelIdeasSuggestions()
	{
		return "Ideen und Vorschläge";
	}

	protected override string _GetTemplateForLabelIPad()
	{
		return "iPad";
	}

	protected override string _GetTemplateForLabelIPhone()
	{
		return "iPhone";
	}

	protected override string _GetTemplateForLabelIssueDescription()
	{
		return "Bitte beschreibe das Problem, das aufgetreten ist. Füge alle relevanten Informationen hinzu, z.\u00a0B. wo das Problem auftritt oder die Fehlermeldung.";
	}

	protected override string _GetTemplateForLabelIWasScammed()
	{
		return "Ich wurde betrogen";
	}

	protected override string _GetTemplateForLabelMac()
	{
		return "Mac";
	}

	protected override string _GetTemplateForLabelMembership()
	{
		return "Mitgliedschaft";
	}

	protected override string _GetTemplateForLabelModeration()
	{
		return "Moderation";
	}

	protected override string _GetTemplateForLabelOtherSiteClaim()
	{
		return "Beschwerde einer anderen Seite";
	}

	protected override string _GetTemplateForLabelOwnerDMCAClaim()
	{
		return "Besitzer meldet Urheberrechtsverletzung";
	}

	protected override string _GetTemplateForLabelPC()
	{
		return "PC";
	}

	protected override string _GetTemplateForLabelPhysicalToyIssue()
	{
		return "Problem mit materiellem Spielzeug";
	}

	protected override string _GetTemplateForLabelPleaseSelect()
	{
		return "Bitte wähle\u00a0...";
	}

	protected override string _GetTemplateForLabelPrizeNotReceived()
	{
		return "Preis nicht erhalten";
	}

	protected override string _GetTemplateForLabelPurchaseDeclined()
	{
		return "Kauf\u00a0– Bezahlung abgelehnt";
	}

	protected override string _GetTemplateForLabelPurchaseDidNotReceive()
	{
		return "Kauf\u00a0– Artikel nicht erhalten";
	}

	protected override string _GetTemplateForLabelPurchaseUnauthorizedCharge()
	{
		return "Kauf\u00a0– Unerlaubte Kontobelastung";
	}

	protected override string _GetTemplateForLabelReportPhish()
	{
		return "Phishing-Seite melden";
	}

	protected override string _GetTemplateForLabelRobloxCrashing()
	{
		return "Roblox stürzt ab";
	}

	protected override string _GetTemplateForLabelRobloxToys()
	{
		return "Roblox-Spielzeug";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelRobuxPurchaseIssue()
	{
		return "Robux\u00a0– Problem beim Kauf";
	}

	protected override string _GetTemplateForLabelSafetyInquiry()
	{
		return "Unangemessenes Verhalten von Spiel oder Benutzer";
	}

	protected override string _GetTemplateForLabelSafetyQueueTicket()
	{
		return "Sicherheitsproblem für Benutzer";
	}

	protected override string _GetTemplateForLabelSpecificGameIssue()
	{
		return "Problem mit bestimmtem Spiel";
	}

	protected override string _GetTemplateForLabelSubmit()
	{
		return "Senden";
	}

	protected override string _GetTemplateForLabelSuggestFeature()
	{
		return "Vorschlag für Feature";
	}

	protected override string _GetTemplateForLabelSuggestFeedback()
	{
		return "Feedback";
	}

	protected override string _GetTemplateForLabelTechnicalSupport()
	{
		return "Technischer Support";
	}

	protected override string _GetTemplateForLabelToyCodeIssue()
	{
		return "Problem mit Spielzeugcode";
	}

	protected override string _GetTemplateForLabelTwoStepV()
	{
		return "Verifizierung in 2 Schritten";
	}

	protected override string _GetTemplateForLabelUserAbuseReport()
	{
		return "Regelverstoß von Benutzer melden";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Benutzername";
	}

	protected override string _GetTemplateForLabelVCCatalog()
	{
		return "Website-Artikel";
	}

	protected override string _GetTemplateForLabelVCInGame()
	{
		return "Artikel im Spiel";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForResponseDialogErrorWithoutContext()
	{
		return "Etwas ist schiefgelaufen. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Wähle „Senden“, um das Ticket einzureichen, oder „Abbrechen“, um den Benutzernamen zu bearbeiten. Bei deinem Benutzernamen handelt es sich um eine wichtige Information, durch die dein Problem schneller bearbeitet werden kann.";
	}

	protected override string _GetTemplateForResponseDialogRequestReceived()
	{
		return "Danke, dass du Roblox kontaktiert hast. Eine Nachricht von unserem Kundenservice findest du in deinem E-Mail-Posteingang.";
	}

	protected override string _GetTemplateForResponseDialogTooManyAttemptsError()
	{
		return "Zu viele Versuche. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogTryAgainError()
	{
		return "Ein Fehler ist aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseEmailFormatError()
	{
		return "Bitte gib eine E-Mail-Adresse im korrekten Format an.";
	}

	protected override string _GetTemplateForResponseEmailNotMatching()
	{
		return "E-Mail-Adresse stimmt nicht überein.";
	}

	protected override string _GetTemplateForResponseInvalidFirstName()
	{
		return "Bitte gib einen gültigen Vornamen ein.";
	}

	protected override string _GetTemplateForResponseInvalidUsername()
	{
		return "Der Benutzername scheint kein gültiger Roblox-Benutzername zu sein.";
	}

	protected override string _GetTemplateForResponseUnder13Email()
	{
		return "Wenn du unter 13 Jahre alt bist, gib bitte die E-Mail-Adresse deiner Eltern an.";
	}
}
