namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ProfileResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ProfileResources_pt_br : ProfileResources_en_us, IProfileResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Accept"
	/// English String: "Accept"
	/// </summary>
	public override string ActionAccept => "Aceitar";

	/// <summary>
	/// Key: "Action.AddFriend"
	/// English String: "Add Friend"
	/// </summary>
	public override string ActionAddFriend => "Adicionar amigo";

	/// <summary>
	/// Key: "Action.BlockUser"
	/// English String: "Block User"
	/// </summary>
	public override string ActionBlockUser => "Bloquear usuário";

	/// <summary>
	/// Key: "Action.CancelBlockUser"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancelBlockUser => "Cancelar";

	/// <summary>
	/// Key: "Action.Chat"
	/// English String: "Chat"
	/// </summary>
	public override string ActionChat => "Chat";

	/// <summary>
	/// Key: "Action.Close"
	/// close modal
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Fechar";

	/// <summary>
	/// Key: "Action.ConfirmBlockUser"
	/// English String: "Block"
	/// </summary>
	public override string ActionConfirmBlockUser => "Bloquear";

	/// <summary>
	/// Key: "Action.ConfirmUnblockUser"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionConfirmUnblockUser => "Desbloquear";

	/// <summary>
	/// Key: "Action.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string ActionFavorites => "Favoritos";

	/// <summary>
	/// Key: "Action.Follow"
	/// English String: "Follow"
	/// </summary>
	public override string ActionFollow => "Seguir";

	/// <summary>
	/// Key: "Action.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string ActionGridView => "Visão de grade";

	/// <summary>
	/// Key: "Action.ImpersonateUser"
	/// English String: "Impersonate User"
	/// </summary>
	public override string ActionImpersonateUser => "Personificar usuário";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventário";

	/// <summary>
	/// Key: "Action.JoinGame"
	/// English String: "Join Game"
	/// </summary>
	public override string ActionJoinGame => "Entrar no jogo";

	/// <summary>
	/// Key: "Action.Message"
	/// English String: "Message"
	/// </summary>
	public override string ActionMessage => "Mensagem";

	/// <summary>
	/// Key: "Action.Pending"
	/// English String: "Pending"
	/// </summary>
	public override string ActionPending => "Pendente";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Salvar";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Ver todos";

	/// <summary>
	/// Key: "Action.SeeLess"
	/// English String: "See Less"
	/// </summary>
	public override string ActionSeeLess => "Ver menos";

	/// <summary>
	/// Key: "Action.SeeMore"
	/// English String: "See More"
	/// </summary>
	public override string ActionSeeMore => "Ver mais";

	/// <summary>
	/// Key: "Action.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string ActionSlideshowView => "Ver apresentação de slides";

	/// <summary>
	/// Key: "Action.Trade"
	/// English String: "Trade"
	/// </summary>
	public override string ActionTrade => "Trocar";

	/// <summary>
	/// Key: "Action.TradeItems"
	/// English String: "Trade Items"
	/// </summary>
	public override string ActionTradeItems => "Trocar itens";

	/// <summary>
	/// Key: "Action.UnblockUser"
	/// English String: "Unblock User"
	/// </summary>
	public override string ActionUnblockUser => "Desbloquear usuário";

	/// <summary>
	/// Key: "Action.Unfollow"
	/// English String: "Unfollow"
	/// </summary>
	public override string ActionUnfollow => "Deixar de seguir";

	/// <summary>
	/// Key: "Action.Unfriend"
	/// English String: "Unfriend"
	/// </summary>
	public override string ActionUnfriend => "Remover amigo";

	/// <summary>
	/// Key: "Action.UpdateStatus"
	/// English String: "Update Status"
	/// </summary>
	public override string ActionUpdateStatus => "Atualizar status";

	/// <summary>
	/// Key: "Description.BlockUserFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string DescriptionBlockUserFooter => "Quando você bloqueia um usuário, nem você nem ele podem se contatar.";

	/// <summary>
	/// Key: "Description.BlockUserPrompt"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string DescriptionBlockUserPrompt => "Quer mesmo bloquear este usuário?";

	/// <summary>
	/// Key: "Description.ChangeAlias"
	/// English String: "Only you can see this information"
	/// </summary>
	public override string DescriptionChangeAlias => "Só você pode ver esta informação";

	/// <summary>
	/// Key: "Description.UnblockUserPrompt"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string DescriptionUnblockUserPrompt => "Quer mesmo desbloquear este usuário?";

	/// <summary>
	/// Key: "Heading.AboutTab"
	/// this is for the heading under About tab on profile page
	/// English String: "About"
	/// </summary>
	public override string HeadingAboutTab => "Sobre";

	/// <summary>
	/// Key: "Heading.BlockUserTitle"
	/// English String: "Warning"
	/// </summary>
	public override string HeadingBlockUserTitle => "Aviso";

	/// <summary>
	/// Key: "Heading.Collections"
	/// English String: "Collections"
	/// </summary>
	public override string HeadingCollections => "Coleções";

	/// <summary>
	/// Key: "Heading.CurrentlyWearing"
	/// English String: "Currently Wearing"
	/// </summary>
	public override string HeadingCurrentlyWearing => "Vestindo atualmente";

	/// <summary>
	/// Key: "Heading.FavoriteGames"
	/// English String: "Favorites"
	/// </summary>
	public override string HeadingFavoriteGames => "Favoritos";

	/// <summary>
	/// Key: "Heading.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string HeadingFriends => "Amigos";

	/// <summary>
	/// Key: "Heading.Games"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGames => "Jogos";

	/// <summary>
	/// Key: "Heading.GameTitle"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGameTitle => "Jogos";

	/// <summary>
	/// Key: "Heading.Groups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingGroups => "Grupos";

	/// <summary>
	/// Key: "Heading.PlayerAssetsBadges"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerAssetsBadges => "Emblemas de jogador";

	/// <summary>
	/// Key: "Heading.PlayerAssetsClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingPlayerAssetsClothing => "Roupas";

	/// <summary>
	/// Key: "Heading.PlayerAssetsModels"
	/// English String: "Models"
	/// </summary>
	public override string HeadingPlayerAssetsModels => "Modelos";

	/// <summary>
	/// Key: "Heading.PlayerBadge"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerBadge => "Emblemas de jogador";

	/// <summary>
	/// Key: "Heading.Profile"
	/// English String: "Profile"
	/// </summary>
	public override string HeadingProfile => "Perfil";

	/// <summary>
	/// Key: "Heading.ProfileGroups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingProfileGroups => "Grupos";

	/// <summary>
	/// Key: "Heading.RobloxBadge"
	/// English String: "Roblox Badges"
	/// </summary>
	public override string HeadingRobloxBadge => "Emblemas do Roblox";

	/// <summary>
	/// Key: "Heading.Statistics"
	/// English String: "Statistics"
	/// </summary>
	public override string HeadingStatistics => "Estatísticas";

	/// <summary>
	/// Key: "Label.About"
	/// English String: "About"
	/// </summary>
	public override string LabelAbout => "Sobre";

	/// <summary>
	/// Key: "Label.Alias"
	/// Friends Tag, nickname
	/// English String: "Alias"
	/// </summary>
	public override string LabelAlias => "Apelido";

	/// <summary>
	/// Key: "Label.BlockWarningBody"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string LabelBlockWarningBody => "Quer mesmo bloquear este usuário?";

	/// <summary>
	/// Key: "Label.BlockWarningConfirm"
	/// English String: "Block"
	/// </summary>
	public override string LabelBlockWarningConfirm => "Bloquear";

	/// <summary>
	/// Key: "Label.BlockWarningFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string LabelBlockWarningFooter => "Quando você bloqueia um usuário, nem você nem ele podem se contatar.";

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancel => "Cancelar";

	/// <summary>
	/// Key: "Label.ChangeAlias"
	/// set nickname
	/// English String: "Set Alias"
	/// </summary>
	public override string LabelChangeAlias => "Definir apelido";

	/// <summary>
	/// Key: "Label.Creations"
	/// English String: "Creations"
	/// </summary>
	public override string LabelCreations => "Criações";

	/// <summary>
	/// Key: "Label.Followers"
	/// English String: "Followers"
	/// </summary>
	public override string LabelFollowers => "Seguidores";

	/// <summary>
	/// Key: "Label.Following"
	/// English String: "Following"
	/// </summary>
	public override string LabelFollowing => "Seguindo";

	/// <summary>
	/// Key: "Label.ForumPosts"
	/// English String: "Forum Posts"
	/// </summary>
	public override string LabelForumPosts => "Publicações no fórum";

	/// <summary>
	/// Key: "Label.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelFriends => "Amigos";

	/// <summary>
	/// Key: "Label.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string LabelGridView => "Visão de grade";

	/// <summary>
	/// Key: "Label.JoinDate"
	/// English String: "Join Date"
	/// </summary>
	public override string LabelJoinDate => "Data de entrada";

	/// <summary>
	/// Key: "Label.LoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string LabelLoadMore => "Carregar mais";

	/// <summary>
	/// Key: "Label.Members"
	/// English String: "Members"
	/// </summary>
	public override string LabelMembers => "Membros";

	/// <summary>
	/// Key: "Label.PastUsername"
	/// English String: "Past Usernames"
	/// </summary>
	public override string LabelPastUsername => "Nomes de usuário anteriores";

	/// <summary>
	/// Key: "Label.PastUsernames"
	/// English String: "Past usernames"
	/// </summary>
	public override string LabelPastUsernames => "Nomes de usuário anteriores";

	/// <summary>
	/// Key: "Label.PlaceVisits"
	/// English String: "Place Visits"
	/// </summary>
	public override string LabelPlaceVisits => "Visitas no local";

	/// <summary>
	/// Key: "Label.Playing"
	/// English String: "Playing"
	/// </summary>
	public override string LabelPlaying => "Jogando";

	/// <summary>
	/// Key: "Label.Rank"
	/// English String: "Rank"
	/// </summary>
	public override string LabelRank => "Ranque";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Ler mais";

	/// <summary>
	/// Key: "Label.ReportAbuse"
	/// English String: "Report Abuse"
	/// </summary>
	public override string LabelReportAbuse => "Denunciar abuso";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Mostrar menos";

	/// <summary>
	/// Key: "Label.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string LabelSlideshowView => "Ver apresentação de slides";

	/// <summary>
	/// Key: "Label.UnblockWarningBody"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string LabelUnblockWarningBody => "Quer mesmo desbloquear este usuário?";

	/// <summary>
	/// Key: "Label.UnblockWarningConfirm"
	/// English String: "Unblock"
	/// </summary>
	public override string LabelUnblockWarningConfirm => "Desbloquear";

	/// <summary>
	/// Key: "Label.Visits"
	/// English String: "Visits"
	/// </summary>
	public override string LabelVisits => "Visitas";

	/// <summary>
	/// Key: "Label.WarningTitle"
	/// English String: "Warning"
	/// </summary>
	public override string LabelWarningTitle => "Aviso";

	/// <summary>
	/// Key: "Message.AliasHasError"
	/// English String: "An error has occurred. Please try again later"
	/// </summary>
	public override string MessageAliasHasError => "Ocorreu um erro. Tente novamente mais tarde";

	/// <summary>
	/// Key: "Message.AliasIsModerated"
	/// English String: "Please avoid using full names or offensive language."
	/// </summary>
	public override string MessageAliasIsModerated => "Evite usar nomes completos ou linguajar inapropriado.";

	/// <summary>
	/// Key: "Message.ChangeStatus"
	/// English String: "What are you up to?"
	/// </summary>
	public override string MessageChangeStatus => "O que você está fazendo?";

	/// <summary>
	/// Key: "Message.ErrorBlockLimit"
	/// English String: "Operation failed! You may have blocked too many people."
	/// </summary>
	public override string MessageErrorBlockLimit => "Falha na operação! Você bloqueou pessoas demais.";

	/// <summary>
	/// Key: "Message.ErrorGeneral"
	/// English String: "Something went wrong. Please check back in a few minutes."
	/// </summary>
	public override string MessageErrorGeneral => "Algo deu errado. Volte para conferir em alguns minutos.";

	/// <summary>
	/// Key: "Message.Sharing"
	/// English String: "Sharing..."
	/// </summary>
	public override string MessageSharing => "Compartilhando...";

	/// <summary>
	/// Key: "Response.TooManyAttempts"
	/// flood error response
	/// English String: "Too Many Attempts"
	/// </summary>
	public override string ResponseTooManyAttempts => "Muitas tentativas";

	public ProfileResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAccept()
	{
		return "Aceitar";
	}

	protected override string _GetTemplateForActionAddFriend()
	{
		return "Adicionar amigo";
	}

	protected override string _GetTemplateForActionBlockUser()
	{
		return "Bloquear usuário";
	}

	protected override string _GetTemplateForActionCancelBlockUser()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionChat()
	{
		return "Chat";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Fechar";
	}

	protected override string _GetTemplateForActionConfirmBlockUser()
	{
		return "Bloquear";
	}

	protected override string _GetTemplateForActionConfirmUnblockUser()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForActionFollow()
	{
		return "Seguir";
	}

	protected override string _GetTemplateForActionGridView()
	{
		return "Visão de grade";
	}

	protected override string _GetTemplateForActionImpersonateUser()
	{
		return "Personificar usuário";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventário";
	}

	protected override string _GetTemplateForActionJoinGame()
	{
		return "Entrar no jogo";
	}

	protected override string _GetTemplateForActionMessage()
	{
		return "Mensagem";
	}

	protected override string _GetTemplateForActionPending()
	{
		return "Pendente";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Salvar";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Ver todos";
	}

	protected override string _GetTemplateForActionSeeLess()
	{
		return "Ver menos";
	}

	protected override string _GetTemplateForActionSeeMore()
	{
		return "Ver mais";
	}

	protected override string _GetTemplateForActionSlideshowView()
	{
		return "Ver apresentação de slides";
	}

	protected override string _GetTemplateForActionTrade()
	{
		return "Trocar";
	}

	protected override string _GetTemplateForActionTradeItems()
	{
		return "Trocar itens";
	}

	protected override string _GetTemplateForActionUnblockUser()
	{
		return "Desbloquear usuário";
	}

	protected override string _GetTemplateForActionUnfollow()
	{
		return "Deixar de seguir";
	}

	protected override string _GetTemplateForActionUnfriend()
	{
		return "Remover amigo";
	}

	protected override string _GetTemplateForActionUpdateStatus()
	{
		return "Atualizar status";
	}

	protected override string _GetTemplateForDescriptionBlockUserFooter()
	{
		return "Quando você bloqueia um usuário, nem você nem ele podem se contatar.";
	}

	protected override string _GetTemplateForDescriptionBlockUserPrompt()
	{
		return "Quer mesmo bloquear este usuário?";
	}

	protected override string _GetTemplateForDescriptionChangeAlias()
	{
		return "Só você pode ver esta informação";
	}

	protected override string _GetTemplateForDescriptionUnblockUserPrompt()
	{
		return "Quer mesmo desbloquear este usuário?";
	}

	protected override string _GetTemplateForHeadingAboutTab()
	{
		return "Sobre";
	}

	protected override string _GetTemplateForHeadingBlockUserTitle()
	{
		return "Aviso";
	}

	protected override string _GetTemplateForHeadingCollections()
	{
		return "Coleções";
	}

	protected override string _GetTemplateForHeadingCurrentlyWearing()
	{
		return "Vestindo atualmente";
	}

	protected override string _GetTemplateForHeadingFavoriteGames()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForHeadingFriends()
	{
		return "Amigos";
	}

	/// <summary>
	/// Key: "Heading.FriendsNum"
	/// English String: "Friends ({friendsCount})"
	/// </summary>
	public override string HeadingFriendsNum(string friendsCount)
	{
		return $"Amigos ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingFriendsNum()
	{
		return "Amigos ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingGames()
	{
		return "Jogos";
	}

	protected override string _GetTemplateForHeadingGameTitle()
	{
		return "Jogos";
	}

	protected override string _GetTemplateForHeadingGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsBadges()
	{
		return "Emblemas de jogador";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsClothing()
	{
		return "Roupas";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsModels()
	{
		return "Modelos";
	}

	protected override string _GetTemplateForHeadingPlayerBadge()
	{
		return "Emblemas de jogador";
	}

	protected override string _GetTemplateForHeadingProfile()
	{
		return "Perfil";
	}

	protected override string _GetTemplateForHeadingProfileGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForHeadingRobloxBadge()
	{
		return "Emblemas do Roblox";
	}

	protected override string _GetTemplateForHeadingStatistics()
	{
		return "Estatísticas";
	}

	protected override string _GetTemplateForLabelAbout()
	{
		return "Sobre";
	}

	protected override string _GetTemplateForLabelAlias()
	{
		return "Apelido";
	}

	protected override string _GetTemplateForLabelBlockWarningBody()
	{
		return "Quer mesmo bloquear este usuário?";
	}

	protected override string _GetTemplateForLabelBlockWarningConfirm()
	{
		return "Bloquear";
	}

	protected override string _GetTemplateForLabelBlockWarningFooter()
	{
		return "Quando você bloqueia um usuário, nem você nem ele podem se contatar.";
	}

	protected override string _GetTemplateForLabelCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForLabelChangeAlias()
	{
		return "Definir apelido";
	}

	protected override string _GetTemplateForLabelCreations()
	{
		return "Criações";
	}

	protected override string _GetTemplateForLabelFollowers()
	{
		return "Seguidores";
	}

	protected override string _GetTemplateForLabelFollowing()
	{
		return "Seguindo";
	}

	protected override string _GetTemplateForLabelForumPosts()
	{
		return "Publicações no fórum";
	}

	protected override string _GetTemplateForLabelFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelGridView()
	{
		return "Visão de grade";
	}

	protected override string _GetTemplateForLabelJoinDate()
	{
		return "Data de entrada";
	}

	protected override string _GetTemplateForLabelLoadMore()
	{
		return "Carregar mais";
	}

	protected override string _GetTemplateForLabelMembers()
	{
		return "Membros";
	}

	protected override string _GetTemplateForLabelPastUsername()
	{
		return "Nomes de usuário anteriores";
	}

	protected override string _GetTemplateForLabelPastUsernames()
	{
		return "Nomes de usuário anteriores";
	}

	protected override string _GetTemplateForLabelPlaceVisits()
	{
		return "Visitas no local";
	}

	protected override string _GetTemplateForLabelPlaying()
	{
		return "Jogando";
	}

	/// <summary>
	/// Key: "Label.Quotation"
	/// You only need to localize the quotation mark, e.g. 「{userStatus}」
	/// English String: "\"{userStatus}\""
	/// </summary>
	public override string LabelQuotation(string userStatus)
	{
		return $"\"{userStatus}\"";
	}

	protected override string _GetTemplateForLabelQuotation()
	{
		return "\"{userStatus}\"";
	}

	protected override string _GetTemplateForLabelRank()
	{
		return "Ranque";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Ler mais";
	}

	protected override string _GetTemplateForLabelReportAbuse()
	{
		return "Denunciar abuso";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Mostrar menos";
	}

	protected override string _GetTemplateForLabelSlideshowView()
	{
		return "Ver apresentação de slides";
	}

	protected override string _GetTemplateForLabelUnblockWarningBody()
	{
		return "Quer mesmo desbloquear este usuário?";
	}

	protected override string _GetTemplateForLabelUnblockWarningConfirm()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForLabelVisits()
	{
		return "Visitas";
	}

	protected override string _GetTemplateForLabelWarningTitle()
	{
		return "Aviso";
	}

	protected override string _GetTemplateForMessageAliasHasError()
	{
		return "Ocorreu um erro. Tente novamente mais tarde";
	}

	protected override string _GetTemplateForMessageAliasIsModerated()
	{
		return "Evite usar nomes completos ou linguajar inapropriado.";
	}

	protected override string _GetTemplateForMessageChangeStatus()
	{
		return "O que você está fazendo?";
	}

	protected override string _GetTemplateForMessageErrorBlockLimit()
	{
		return "Falha na operação! Você bloqueou pessoas demais.";
	}

	protected override string _GetTemplateForMessageErrorGeneral()
	{
		return "Algo deu errado. Volte para conferir em alguns minutos.";
	}

	/// <summary>
	/// Key: "Message.NoCreation"
	/// English String: "{username} has no creations."
	/// </summary>
	public override string MessageNoCreation(string username)
	{
		return $"{username} não tem criações.";
	}

	protected override string _GetTemplateForMessageNoCreation()
	{
		return "{username} não tem criações.";
	}

	protected override string _GetTemplateForMessageSharing()
	{
		return "Compartilhando...";
	}

	protected override string _GetTemplateForResponseTooManyAttempts()
	{
		return "Muitas tentativas";
	}
}
