namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ProfileResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ProfileResources_fr_fr : ProfileResources_en_us, IProfileResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Accept"
	/// English String: "Accept"
	/// </summary>
	public override string ActionAccept => "Accepter";

	/// <summary>
	/// Key: "Action.AddFriend"
	/// English String: "Add Friend"
	/// </summary>
	public override string ActionAddFriend => "Ajouter ami";

	/// <summary>
	/// Key: "Action.BlockUser"
	/// English String: "Block User"
	/// </summary>
	public override string ActionBlockUser => "Bloquer l'utilisateur";

	/// <summary>
	/// Key: "Action.CancelBlockUser"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancelBlockUser => "Annuler";

	/// <summary>
	/// Key: "Action.Chat"
	/// English String: "Chat"
	/// </summary>
	public override string ActionChat => "Discuter";

	/// <summary>
	/// Key: "Action.Close"
	/// close modal
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Fermer";

	/// <summary>
	/// Key: "Action.ConfirmBlockUser"
	/// English String: "Block"
	/// </summary>
	public override string ActionConfirmBlockUser => "Bloquer";

	/// <summary>
	/// Key: "Action.ConfirmUnblockUser"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionConfirmUnblockUser => "Débloquer";

	/// <summary>
	/// Key: "Action.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string ActionFavorites => "Favoris";

	/// <summary>
	/// Key: "Action.Follow"
	/// English String: "Follow"
	/// </summary>
	public override string ActionFollow => "Suivre";

	/// <summary>
	/// Key: "Action.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string ActionGridView => "Affichage grille";

	/// <summary>
	/// Key: "Action.ImpersonateUser"
	/// English String: "Impersonate User"
	/// </summary>
	public override string ActionImpersonateUser => "Usurpation d'identité";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventaire";

	/// <summary>
	/// Key: "Action.JoinGame"
	/// English String: "Join Game"
	/// </summary>
	public override string ActionJoinGame => "Rejoindre le jeu";

	/// <summary>
	/// Key: "Action.Message"
	/// English String: "Message"
	/// </summary>
	public override string ActionMessage => "Envoyer un message";

	/// <summary>
	/// Key: "Action.Pending"
	/// English String: "Pending"
	/// </summary>
	public override string ActionPending => "En attente";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Enregistrer";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Afficher tout";

	/// <summary>
	/// Key: "Action.SeeLess"
	/// English String: "See Less"
	/// </summary>
	public override string ActionSeeLess => "Afficher moins";

	/// <summary>
	/// Key: "Action.SeeMore"
	/// English String: "See More"
	/// </summary>
	public override string ActionSeeMore => "Afficher plus";

	/// <summary>
	/// Key: "Action.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string ActionSlideshowView => "Affichage diaporama";

	/// <summary>
	/// Key: "Action.Trade"
	/// English String: "Trade"
	/// </summary>
	public override string ActionTrade => "Échange";

	/// <summary>
	/// Key: "Action.TradeItems"
	/// English String: "Trade Items"
	/// </summary>
	public override string ActionTradeItems => "Échange d'objets";

	/// <summary>
	/// Key: "Action.UnblockUser"
	/// English String: "Unblock User"
	/// </summary>
	public override string ActionUnblockUser => "Débloquer l'utilisateur";

	/// <summary>
	/// Key: "Action.Unfollow"
	/// English String: "Unfollow"
	/// </summary>
	public override string ActionUnfollow => "Ne plus suivre";

	/// <summary>
	/// Key: "Action.Unfriend"
	/// English String: "Unfriend"
	/// </summary>
	public override string ActionUnfriend => "Retirer des amis";

	/// <summary>
	/// Key: "Action.UpdateStatus"
	/// English String: "Update Status"
	/// </summary>
	public override string ActionUpdateStatus => "Mettre à jour le statut";

	/// <summary>
	/// Key: "Description.BlockUserFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string DescriptionBlockUserFooter => "Lorsque vous bloquez un utilisateur, aucun de vous ne peut contacter l'autre.";

	/// <summary>
	/// Key: "Description.BlockUserPrompt"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string DescriptionBlockUserPrompt => "Voulez-vous vraiment bloquer cet utilisateur\u00a0?";

	/// <summary>
	/// Key: "Description.ChangeAlias"
	/// English String: "Only you can see this information"
	/// </summary>
	public override string DescriptionChangeAlias => "Il n'y a que toi qui puisse voir cela";

	/// <summary>
	/// Key: "Description.UnblockUserPrompt"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string DescriptionUnblockUserPrompt => "Voulez-vous vraiment débloquer cet utilisateur\u00a0?";

	/// <summary>
	/// Key: "Heading.AboutTab"
	/// this is for the heading under About tab on profile page
	/// English String: "About"
	/// </summary>
	public override string HeadingAboutTab => "À propos";

	/// <summary>
	/// Key: "Heading.BlockUserTitle"
	/// English String: "Warning"
	/// </summary>
	public override string HeadingBlockUserTitle => "Avertissement";

	/// <summary>
	/// Key: "Heading.Collections"
	/// English String: "Collections"
	/// </summary>
	public override string HeadingCollections => "Collections";

	/// <summary>
	/// Key: "Heading.CurrentlyWearing"
	/// English String: "Currently Wearing"
	/// </summary>
	public override string HeadingCurrentlyWearing => "Tenue actuelle";

	/// <summary>
	/// Key: "Heading.FavoriteGames"
	/// English String: "Favorites"
	/// </summary>
	public override string HeadingFavoriteGames => "En favoris";

	/// <summary>
	/// Key: "Heading.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string HeadingFriends => "Amis";

	/// <summary>
	/// Key: "Heading.Games"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGames => "Jeux";

	/// <summary>
	/// Key: "Heading.GameTitle"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGameTitle => "Jeux";

	/// <summary>
	/// Key: "Heading.Groups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingGroups => "Groupes";

	/// <summary>
	/// Key: "Heading.PlayerAssetsBadges"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerAssetsBadges => "Badges de joueur";

	/// <summary>
	/// Key: "Heading.PlayerAssetsClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingPlayerAssetsClothing => "Vêtements";

	/// <summary>
	/// Key: "Heading.PlayerAssetsModels"
	/// English String: "Models"
	/// </summary>
	public override string HeadingPlayerAssetsModels => "Modèles";

	/// <summary>
	/// Key: "Heading.PlayerBadge"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerBadge => "Badges de joueur";

	/// <summary>
	/// Key: "Heading.Profile"
	/// English String: "Profile"
	/// </summary>
	public override string HeadingProfile => "Profil";

	/// <summary>
	/// Key: "Heading.ProfileGroups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingProfileGroups => "Groupes";

	/// <summary>
	/// Key: "Heading.RobloxBadge"
	/// English String: "Roblox Badges"
	/// </summary>
	public override string HeadingRobloxBadge => "Badges Roblox";

	/// <summary>
	/// Key: "Heading.Statistics"
	/// English String: "Statistics"
	/// </summary>
	public override string HeadingStatistics => "Statistiques";

	/// <summary>
	/// Key: "Label.About"
	/// English String: "About"
	/// </summary>
	public override string LabelAbout => "À propos";

	/// <summary>
	/// Key: "Label.Alias"
	/// Friends Tag, nickname
	/// English String: "Alias"
	/// </summary>
	public override string LabelAlias => "Alias";

	/// <summary>
	/// Key: "Label.BlockWarningBody"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string LabelBlockWarningBody => "Voulez-vous vraiment bloquer cet utilisateur\u00a0?";

	/// <summary>
	/// Key: "Label.BlockWarningConfirm"
	/// English String: "Block"
	/// </summary>
	public override string LabelBlockWarningConfirm => "Bloquer";

	/// <summary>
	/// Key: "Label.BlockWarningFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string LabelBlockWarningFooter => "Lorsque vous bloquez un utilisateur, aucun de vous ne peut contacter l'autre.";

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancel => "Annuler";

	/// <summary>
	/// Key: "Label.ChangeAlias"
	/// set nickname
	/// English String: "Set Alias"
	/// </summary>
	public override string LabelChangeAlias => "Définir alias";

	/// <summary>
	/// Key: "Label.Creations"
	/// English String: "Creations"
	/// </summary>
	public override string LabelCreations => "Créations";

	/// <summary>
	/// Key: "Label.Followers"
	/// English String: "Followers"
	/// </summary>
	public override string LabelFollowers => "Abonnés";

	/// <summary>
	/// Key: "Label.Following"
	/// English String: "Following"
	/// </summary>
	public override string LabelFollowing => "Abonnements";

	/// <summary>
	/// Key: "Label.ForumPosts"
	/// English String: "Forum Posts"
	/// </summary>
	public override string LabelForumPosts => "Messages sur le forum";

	/// <summary>
	/// Key: "Label.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelFriends => "Amis";

	/// <summary>
	/// Key: "Label.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string LabelGridView => "Affichage grille";

	/// <summary>
	/// Key: "Label.JoinDate"
	/// English String: "Join Date"
	/// </summary>
	public override string LabelJoinDate => "Date d'inscription";

	/// <summary>
	/// Key: "Label.LoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string LabelLoadMore => "Charger plus";

	/// <summary>
	/// Key: "Label.Members"
	/// English String: "Members"
	/// </summary>
	public override string LabelMembers => "Membres";

	/// <summary>
	/// Key: "Label.PastUsername"
	/// English String: "Past Usernames"
	/// </summary>
	public override string LabelPastUsername => "Anciens noms d'utilisateur";

	/// <summary>
	/// Key: "Label.PastUsernames"
	/// English String: "Past usernames"
	/// </summary>
	public override string LabelPastUsernames => "Anciens noms d'utilisateur";

	/// <summary>
	/// Key: "Label.PlaceVisits"
	/// English String: "Place Visits"
	/// </summary>
	public override string LabelPlaceVisits => "Visites d'emplacement";

	/// <summary>
	/// Key: "Label.Playing"
	/// English String: "Playing"
	/// </summary>
	public override string LabelPlaying => "En jeu";

	/// <summary>
	/// Key: "Label.Rank"
	/// English String: "Rank"
	/// </summary>
	public override string LabelRank => "Rang";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Lire plus";

	/// <summary>
	/// Key: "Label.ReportAbuse"
	/// English String: "Report Abuse"
	/// </summary>
	public override string LabelReportAbuse => "Signaler un comportement abusif";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Afficher moins";

	/// <summary>
	/// Key: "Label.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string LabelSlideshowView => "Affichage diaporama";

	/// <summary>
	/// Key: "Label.UnblockWarningBody"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string LabelUnblockWarningBody => "Voulez-vous vraiment débloquer cet utilisateur\u00a0?";

	/// <summary>
	/// Key: "Label.UnblockWarningConfirm"
	/// English String: "Unblock"
	/// </summary>
	public override string LabelUnblockWarningConfirm => "Débloquer";

	/// <summary>
	/// Key: "Label.Visits"
	/// English String: "Visits"
	/// </summary>
	public override string LabelVisits => "Visites";

	/// <summary>
	/// Key: "Label.WarningTitle"
	/// English String: "Warning"
	/// </summary>
	public override string LabelWarningTitle => "Avertissement";

	/// <summary>
	/// Key: "Message.AliasHasError"
	/// English String: "An error has occurred. Please try again later"
	/// </summary>
	public override string MessageAliasHasError => "Une erreur s'est produite, réessaye plus tard\u00a0";

	/// <summary>
	/// Key: "Message.AliasIsModerated"
	/// English String: "Please avoid using full names or offensive language."
	/// </summary>
	public override string MessageAliasIsModerated => "N'utilise pas de nom complet ou de langage injurieux.";

	/// <summary>
	/// Key: "Message.ChangeStatus"
	/// English String: "What are you up to?"
	/// </summary>
	public override string MessageChangeStatus => "Qu'avez-vous en tête\u00a0?";

	/// <summary>
	/// Key: "Message.ErrorBlockLimit"
	/// English String: "Operation failed! You may have blocked too many people."
	/// </summary>
	public override string MessageErrorBlockLimit => "Échec de l'opération. Vous avez peut-être bloqué trop d'utilisateurs.";

	/// <summary>
	/// Key: "Message.ErrorGeneral"
	/// English String: "Something went wrong. Please check back in a few minutes."
	/// </summary>
	public override string MessageErrorGeneral => "Un problème est survenu. Veuillez réessayer dans quelques minutes.";

	/// <summary>
	/// Key: "Message.Sharing"
	/// English String: "Sharing..."
	/// </summary>
	public override string MessageSharing => "Partage...";

	/// <summary>
	/// Key: "Response.TooManyAttempts"
	/// flood error response
	/// English String: "Too Many Attempts"
	/// </summary>
	public override string ResponseTooManyAttempts => "Trop de tentatives";

	public ProfileResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAccept()
	{
		return "Accepter";
	}

	protected override string _GetTemplateForActionAddFriend()
	{
		return "Ajouter ami";
	}

	protected override string _GetTemplateForActionBlockUser()
	{
		return "Bloquer l'utilisateur";
	}

	protected override string _GetTemplateForActionCancelBlockUser()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionChat()
	{
		return "Discuter";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Fermer";
	}

	protected override string _GetTemplateForActionConfirmBlockUser()
	{
		return "Bloquer";
	}

	protected override string _GetTemplateForActionConfirmUnblockUser()
	{
		return "Débloquer";
	}

	protected override string _GetTemplateForActionFavorites()
	{
		return "Favoris";
	}

	protected override string _GetTemplateForActionFollow()
	{
		return "Suivre";
	}

	protected override string _GetTemplateForActionGridView()
	{
		return "Affichage grille";
	}

	protected override string _GetTemplateForActionImpersonateUser()
	{
		return "Usurpation d'identité";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventaire";
	}

	protected override string _GetTemplateForActionJoinGame()
	{
		return "Rejoindre le jeu";
	}

	protected override string _GetTemplateForActionMessage()
	{
		return "Envoyer un message";
	}

	protected override string _GetTemplateForActionPending()
	{
		return "En attente";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Enregistrer";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Afficher tout";
	}

	protected override string _GetTemplateForActionSeeLess()
	{
		return "Afficher moins";
	}

	protected override string _GetTemplateForActionSeeMore()
	{
		return "Afficher plus";
	}

	protected override string _GetTemplateForActionSlideshowView()
	{
		return "Affichage diaporama";
	}

	protected override string _GetTemplateForActionTrade()
	{
		return "Échange";
	}

	protected override string _GetTemplateForActionTradeItems()
	{
		return "Échange d'objets";
	}

	protected override string _GetTemplateForActionUnblockUser()
	{
		return "Débloquer l'utilisateur";
	}

	protected override string _GetTemplateForActionUnfollow()
	{
		return "Ne plus suivre";
	}

	protected override string _GetTemplateForActionUnfriend()
	{
		return "Retirer des amis";
	}

	protected override string _GetTemplateForActionUpdateStatus()
	{
		return "Mettre à jour le statut";
	}

	protected override string _GetTemplateForDescriptionBlockUserFooter()
	{
		return "Lorsque vous bloquez un utilisateur, aucun de vous ne peut contacter l'autre.";
	}

	protected override string _GetTemplateForDescriptionBlockUserPrompt()
	{
		return "Voulez-vous vraiment bloquer cet utilisateur\u00a0?";
	}

	protected override string _GetTemplateForDescriptionChangeAlias()
	{
		return "Il n'y a que toi qui puisse voir cela";
	}

	protected override string _GetTemplateForDescriptionUnblockUserPrompt()
	{
		return "Voulez-vous vraiment débloquer cet utilisateur\u00a0?";
	}

	protected override string _GetTemplateForHeadingAboutTab()
	{
		return "À propos";
	}

	protected override string _GetTemplateForHeadingBlockUserTitle()
	{
		return "Avertissement";
	}

	protected override string _GetTemplateForHeadingCollections()
	{
		return "Collections";
	}

	protected override string _GetTemplateForHeadingCurrentlyWearing()
	{
		return "Tenue actuelle";
	}

	protected override string _GetTemplateForHeadingFavoriteGames()
	{
		return "En favoris";
	}

	protected override string _GetTemplateForHeadingFriends()
	{
		return "Amis";
	}

	/// <summary>
	/// Key: "Heading.FriendsNum"
	/// English String: "Friends ({friendsCount})"
	/// </summary>
	public override string HeadingFriendsNum(string friendsCount)
	{
		return $"Amis ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingFriendsNum()
	{
		return "Amis ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingGames()
	{
		return "Jeux";
	}

	protected override string _GetTemplateForHeadingGameTitle()
	{
		return "Jeux";
	}

	protected override string _GetTemplateForHeadingGroups()
	{
		return "Groupes";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsBadges()
	{
		return "Badges de joueur";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsClothing()
	{
		return "Vêtements";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsModels()
	{
		return "Modèles";
	}

	protected override string _GetTemplateForHeadingPlayerBadge()
	{
		return "Badges de joueur";
	}

	protected override string _GetTemplateForHeadingProfile()
	{
		return "Profil";
	}

	protected override string _GetTemplateForHeadingProfileGroups()
	{
		return "Groupes";
	}

	protected override string _GetTemplateForHeadingRobloxBadge()
	{
		return "Badges Roblox";
	}

	protected override string _GetTemplateForHeadingStatistics()
	{
		return "Statistiques";
	}

	protected override string _GetTemplateForLabelAbout()
	{
		return "À propos";
	}

	protected override string _GetTemplateForLabelAlias()
	{
		return "Alias";
	}

	protected override string _GetTemplateForLabelBlockWarningBody()
	{
		return "Voulez-vous vraiment bloquer cet utilisateur\u00a0?";
	}

	protected override string _GetTemplateForLabelBlockWarningConfirm()
	{
		return "Bloquer";
	}

	protected override string _GetTemplateForLabelBlockWarningFooter()
	{
		return "Lorsque vous bloquez un utilisateur, aucun de vous ne peut contacter l'autre.";
	}

	protected override string _GetTemplateForLabelCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForLabelChangeAlias()
	{
		return "Définir alias";
	}

	protected override string _GetTemplateForLabelCreations()
	{
		return "Créations";
	}

	protected override string _GetTemplateForLabelFollowers()
	{
		return "Abonnés";
	}

	protected override string _GetTemplateForLabelFollowing()
	{
		return "Abonnements";
	}

	protected override string _GetTemplateForLabelForumPosts()
	{
		return "Messages sur le forum";
	}

	protected override string _GetTemplateForLabelFriends()
	{
		return "Amis";
	}

	protected override string _GetTemplateForLabelGridView()
	{
		return "Affichage grille";
	}

	protected override string _GetTemplateForLabelJoinDate()
	{
		return "Date d'inscription";
	}

	protected override string _GetTemplateForLabelLoadMore()
	{
		return "Charger plus";
	}

	protected override string _GetTemplateForLabelMembers()
	{
		return "Membres";
	}

	protected override string _GetTemplateForLabelPastUsername()
	{
		return "Anciens noms d'utilisateur";
	}

	protected override string _GetTemplateForLabelPastUsernames()
	{
		return "Anciens noms d'utilisateur";
	}

	protected override string _GetTemplateForLabelPlaceVisits()
	{
		return "Visites d'emplacement";
	}

	protected override string _GetTemplateForLabelPlaying()
	{
		return "En jeu";
	}

	/// <summary>
	/// Key: "Label.Quotation"
	/// You only need to localize the quotation mark, e.g. 「{userStatus}」
	/// English String: "\"{userStatus}\""
	/// </summary>
	public override string LabelQuotation(string userStatus)
	{
		return $"«\u00a0{userStatus}\u00a0»";
	}

	protected override string _GetTemplateForLabelQuotation()
	{
		return "«\u00a0{userStatus}\u00a0»";
	}

	protected override string _GetTemplateForLabelRank()
	{
		return "Rang";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Lire plus";
	}

	protected override string _GetTemplateForLabelReportAbuse()
	{
		return "Signaler un comportement abusif";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Afficher moins";
	}

	protected override string _GetTemplateForLabelSlideshowView()
	{
		return "Affichage diaporama";
	}

	protected override string _GetTemplateForLabelUnblockWarningBody()
	{
		return "Voulez-vous vraiment débloquer cet utilisateur\u00a0?";
	}

	protected override string _GetTemplateForLabelUnblockWarningConfirm()
	{
		return "Débloquer";
	}

	protected override string _GetTemplateForLabelVisits()
	{
		return "Visites";
	}

	protected override string _GetTemplateForLabelWarningTitle()
	{
		return "Avertissement";
	}

	protected override string _GetTemplateForMessageAliasHasError()
	{
		return "Une erreur s'est produite, réessaye plus tard\u00a0";
	}

	protected override string _GetTemplateForMessageAliasIsModerated()
	{
		return "N'utilise pas de nom complet ou de langage injurieux.";
	}

	protected override string _GetTemplateForMessageChangeStatus()
	{
		return "Qu'avez-vous en tête\u00a0?";
	}

	protected override string _GetTemplateForMessageErrorBlockLimit()
	{
		return "Échec de l'opération. Vous avez peut-être bloqué trop d'utilisateurs.";
	}

	protected override string _GetTemplateForMessageErrorGeneral()
	{
		return "Un problème est survenu. Veuillez réessayer dans quelques minutes.";
	}

	/// <summary>
	/// Key: "Message.NoCreation"
	/// English String: "{username} has no creations."
	/// </summary>
	public override string MessageNoCreation(string username)
	{
		return $"{username} n'a aucune création.";
	}

	protected override string _GetTemplateForMessageNoCreation()
	{
		return "{username} n'a aucune création.";
	}

	protected override string _GetTemplateForMessageSharing()
	{
		return "Partage...";
	}

	protected override string _GetTemplateForResponseTooManyAttempts()
	{
		return "Trop de tentatives";
	}
}
