namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ProfileResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ProfileResources_es_es : ProfileResources_en_us, IProfileResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Accept"
	/// English String: "Accept"
	/// </summary>
	public override string ActionAccept => "Aceptar";

	/// <summary>
	/// Key: "Action.AddFriend"
	/// English String: "Add Friend"
	/// </summary>
	public override string ActionAddFriend => "Añadir amigo";

	/// <summary>
	/// Key: "Action.BlockUser"
	/// English String: "Block User"
	/// </summary>
	public override string ActionBlockUser => "Bloquear usuario";

	/// <summary>
	/// Key: "Action.CancelBlockUser"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancelBlockUser => "Cancelar";

	/// <summary>
	/// Key: "Action.Chat"
	/// English String: "Chat"
	/// </summary>
	public override string ActionChat => "Chatear";

	/// <summary>
	/// Key: "Action.Close"
	/// close modal
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Cerrar";

	/// <summary>
	/// Key: "Action.ConfirmBlockUser"
	/// English String: "Block"
	/// </summary>
	public override string ActionConfirmBlockUser => "Bloquear";

	/// <summary>
	/// Key: "Action.ConfirmUnblockUser"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionConfirmUnblockUser => "Desbloquear";

	/// <summary>
	/// Key: "Action.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string ActionFavorites => "Favoritos";

	/// <summary>
	/// Key: "Action.Follow"
	/// English String: "Follow"
	/// </summary>
	public override string ActionFollow => "Seguir";

	/// <summary>
	/// Key: "Action.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string ActionGridView => "Vista de rejilla";

	/// <summary>
	/// Key: "Action.ImpersonateUser"
	/// English String: "Impersonate User"
	/// </summary>
	public override string ActionImpersonateUser => "Imitar al usuario";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventario";

	/// <summary>
	/// Key: "Action.JoinGame"
	/// English String: "Join Game"
	/// </summary>
	public override string ActionJoinGame => "Unirse al juego";

	/// <summary>
	/// Key: "Action.Message"
	/// English String: "Message"
	/// </summary>
	public override string ActionMessage => "Mensaje";

	/// <summary>
	/// Key: "Action.Pending"
	/// English String: "Pending"
	/// </summary>
	public override string ActionPending => "Pendiente";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Guardar";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Ver todo";

	/// <summary>
	/// Key: "Action.SeeLess"
	/// English String: "See Less"
	/// </summary>
	public override string ActionSeeLess => "Ver menos";

	/// <summary>
	/// Key: "Action.SeeMore"
	/// English String: "See More"
	/// </summary>
	public override string ActionSeeMore => "Ver más";

	/// <summary>
	/// Key: "Action.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string ActionSlideshowView => "Vista de diapositivas";

	/// <summary>
	/// Key: "Action.Trade"
	/// English String: "Trade"
	/// </summary>
	public override string ActionTrade => "Intercambiar";

	/// <summary>
	/// Key: "Action.TradeItems"
	/// English String: "Trade Items"
	/// </summary>
	public override string ActionTradeItems => "Intercambiar objetos";

	/// <summary>
	/// Key: "Action.UnblockUser"
	/// English String: "Unblock User"
	/// </summary>
	public override string ActionUnblockUser => "Desbloquear usuario";

	/// <summary>
	/// Key: "Action.Unfollow"
	/// English String: "Unfollow"
	/// </summary>
	public override string ActionUnfollow => "Dejar de seguir";

	/// <summary>
	/// Key: "Action.Unfriend"
	/// English String: "Unfriend"
	/// </summary>
	public override string ActionUnfriend => "Cancelar amistad";

	/// <summary>
	/// Key: "Action.UpdateStatus"
	/// English String: "Update Status"
	/// </summary>
	public override string ActionUpdateStatus => "Actualizar estado";

	/// <summary>
	/// Key: "Description.BlockUserFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string DescriptionBlockUserFooter => "Cuando bloqueas a un usuario, ninguno de los dos puede ponerse en contacto directo con el otro.";

	/// <summary>
	/// Key: "Description.BlockUserPrompt"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string DescriptionBlockUserPrompt => "¿Seguro que quieres bloquear a este usuario?";

	/// <summary>
	/// Key: "Description.ChangeAlias"
	/// English String: "Only you can see this information"
	/// </summary>
	public override string DescriptionChangeAlias => "Solo tú puedes ver esta información";

	/// <summary>
	/// Key: "Description.UnblockUserPrompt"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string DescriptionUnblockUserPrompt => "¿Seguro que quieres desbloquear a este usuario?";

	/// <summary>
	/// Key: "Heading.AboutTab"
	/// this is for the heading under About tab on profile page
	/// English String: "About"
	/// </summary>
	public override string HeadingAboutTab => "Sobre mí";

	/// <summary>
	/// Key: "Heading.BlockUserTitle"
	/// English String: "Warning"
	/// </summary>
	public override string HeadingBlockUserTitle => "Advertencia";

	/// <summary>
	/// Key: "Heading.Collections"
	/// English String: "Collections"
	/// </summary>
	public override string HeadingCollections => "Colecciones";

	/// <summary>
	/// Key: "Heading.CurrentlyWearing"
	/// English String: "Currently Wearing"
	/// </summary>
	public override string HeadingCurrentlyWearing => "Ropa actual";

	/// <summary>
	/// Key: "Heading.FavoriteGames"
	/// English String: "Favorites"
	/// </summary>
	public override string HeadingFavoriteGames => "Favoritos";

	/// <summary>
	/// Key: "Heading.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string HeadingFriends => "Amigos";

	/// <summary>
	/// Key: "Heading.Games"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGames => "Juegos";

	/// <summary>
	/// Key: "Heading.GameTitle"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGameTitle => "Juegos";

	/// <summary>
	/// Key: "Heading.Groups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingGroups => "Grupos";

	/// <summary>
	/// Key: "Heading.PlayerAssetsBadges"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerAssetsBadges => "Emblemas de jugador";

	/// <summary>
	/// Key: "Heading.PlayerAssetsClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingPlayerAssetsClothing => "Ropa";

	/// <summary>
	/// Key: "Heading.PlayerAssetsModels"
	/// English String: "Models"
	/// </summary>
	public override string HeadingPlayerAssetsModels => "Modelos";

	/// <summary>
	/// Key: "Heading.PlayerBadge"
	/// English String: "Player Badges"
	/// </summary>
	public override string HeadingPlayerBadge => "Emblemas de jugador";

	/// <summary>
	/// Key: "Heading.Profile"
	/// English String: "Profile"
	/// </summary>
	public override string HeadingProfile => "Perfil";

	/// <summary>
	/// Key: "Heading.ProfileGroups"
	/// English String: "Groups"
	/// </summary>
	public override string HeadingProfileGroups => "Grupos";

	/// <summary>
	/// Key: "Heading.RobloxBadge"
	/// English String: "Roblox Badges"
	/// </summary>
	public override string HeadingRobloxBadge => "Emblemas de Roblox";

	/// <summary>
	/// Key: "Heading.Statistics"
	/// English String: "Statistics"
	/// </summary>
	public override string HeadingStatistics => "Estadísticas";

	/// <summary>
	/// Key: "Label.About"
	/// English String: "About"
	/// </summary>
	public override string LabelAbout => "Información";

	/// <summary>
	/// Key: "Label.Alias"
	/// Friends Tag, nickname
	/// English String: "Alias"
	/// </summary>
	public override string LabelAlias => "Apodo";

	/// <summary>
	/// Key: "Label.BlockWarningBody"
	/// English String: "Are you sure you want to block this user?"
	/// </summary>
	public override string LabelBlockWarningBody => "¿Seguro que quieres bloquear a este usuario?";

	/// <summary>
	/// Key: "Label.BlockWarningConfirm"
	/// English String: "Block"
	/// </summary>
	public override string LabelBlockWarningConfirm => "Bloquear";

	/// <summary>
	/// Key: "Label.BlockWarningFooter"
	/// English String: "When you've blocked a user, neither of you can directly contact the other."
	/// </summary>
	public override string LabelBlockWarningFooter => "Cuando bloqueas a un usuario, ninguno de los dos puede ponerse en contacto directo con el otro.";

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancel => "Cancelar";

	/// <summary>
	/// Key: "Label.ChangeAlias"
	/// set nickname
	/// English String: "Set Alias"
	/// </summary>
	public override string LabelChangeAlias => "Elegir apodos";

	/// <summary>
	/// Key: "Label.Creations"
	/// English String: "Creations"
	/// </summary>
	public override string LabelCreations => "Creaciones";

	/// <summary>
	/// Key: "Label.Followers"
	/// English String: "Followers"
	/// </summary>
	public override string LabelFollowers => "Seguidores";

	/// <summary>
	/// Key: "Label.Following"
	/// English String: "Following"
	/// </summary>
	public override string LabelFollowing => "Siguiendo";

	/// <summary>
	/// Key: "Label.ForumPosts"
	/// English String: "Forum Posts"
	/// </summary>
	public override string LabelForumPosts => "Publicaciones en el foro";

	/// <summary>
	/// Key: "Label.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelFriends => "Amigos";

	/// <summary>
	/// Key: "Label.GridView"
	/// English String: "Grid View"
	/// </summary>
	public override string LabelGridView => "Vista de rejilla";

	/// <summary>
	/// Key: "Label.JoinDate"
	/// English String: "Join Date"
	/// </summary>
	public override string LabelJoinDate => "Fecha de registro";

	/// <summary>
	/// Key: "Label.LoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string LabelLoadMore => "Cargar más";

	/// <summary>
	/// Key: "Label.Members"
	/// English String: "Members"
	/// </summary>
	public override string LabelMembers => "Miembros";

	/// <summary>
	/// Key: "Label.PastUsername"
	/// English String: "Past Usernames"
	/// </summary>
	public override string LabelPastUsername => "Nombres de usuario anteriores";

	/// <summary>
	/// Key: "Label.PastUsernames"
	/// English String: "Past usernames"
	/// </summary>
	public override string LabelPastUsernames => "Nombres de usuario anteriores";

	/// <summary>
	/// Key: "Label.PlaceVisits"
	/// English String: "Place Visits"
	/// </summary>
	public override string LabelPlaceVisits => "Visitas a lugares";

	/// <summary>
	/// Key: "Label.Playing"
	/// English String: "Playing"
	/// </summary>
	public override string LabelPlaying => "Jugando";

	/// <summary>
	/// Key: "Label.Rank"
	/// English String: "Rank"
	/// </summary>
	public override string LabelRank => "Rango";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Más detalles";

	/// <summary>
	/// Key: "Label.ReportAbuse"
	/// English String: "Report Abuse"
	/// </summary>
	public override string LabelReportAbuse => "Denunciar abuso";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Mostrar menos";

	/// <summary>
	/// Key: "Label.SlideshowView"
	/// English String: "Slideshow View"
	/// </summary>
	public override string LabelSlideshowView => "Vista de diapositivas";

	/// <summary>
	/// Key: "Label.UnblockWarningBody"
	/// English String: "Are you sure you want to unblock this user?"
	/// </summary>
	public override string LabelUnblockWarningBody => "¿Seguro que quieres desbloquear a este usuario?";

	/// <summary>
	/// Key: "Label.UnblockWarningConfirm"
	/// English String: "Unblock"
	/// </summary>
	public override string LabelUnblockWarningConfirm => "Desbloquear";

	/// <summary>
	/// Key: "Label.Visits"
	/// English String: "Visits"
	/// </summary>
	public override string LabelVisits => "Visitas";

	/// <summary>
	/// Key: "Label.WarningTitle"
	/// English String: "Warning"
	/// </summary>
	public override string LabelWarningTitle => "Advertencia";

	/// <summary>
	/// Key: "Message.AliasHasError"
	/// English String: "An error has occurred. Please try again later"
	/// </summary>
	public override string MessageAliasHasError => "Se ha producido un error. Inténtalo de nuevo más tarde";

	/// <summary>
	/// Key: "Message.AliasIsModerated"
	/// English String: "Please avoid using full names or offensive language."
	/// </summary>
	public override string MessageAliasIsModerated => "Evita usar nombres completos o lenguaje ofensivo.";

	/// <summary>
	/// Key: "Message.ChangeStatus"
	/// English String: "What are you up to?"
	/// </summary>
	public override string MessageChangeStatus => "¿Qué cuentas?";

	/// <summary>
	/// Key: "Message.ErrorBlockLimit"
	/// English String: "Operation failed! You may have blocked too many people."
	/// </summary>
	public override string MessageErrorBlockLimit => "No se ha podido llevar a cabo la operación. Quizá hayas bloqueado a demasiadas personas.";

	/// <summary>
	/// Key: "Message.ErrorGeneral"
	/// English String: "Something went wrong. Please check back in a few minutes."
	/// </summary>
	public override string MessageErrorGeneral => "Algo ha ido mal. Vuelve a intentarlo dentro de unos minutos.";

	/// <summary>
	/// Key: "Message.Sharing"
	/// English String: "Sharing..."
	/// </summary>
	public override string MessageSharing => "Compartiendo...";

	/// <summary>
	/// Key: "Response.TooManyAttempts"
	/// flood error response
	/// English String: "Too Many Attempts"
	/// </summary>
	public override string ResponseTooManyAttempts => "Demasiados intentos";

	public ProfileResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAccept()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionAddFriend()
	{
		return "Añadir amigo";
	}

	protected override string _GetTemplateForActionBlockUser()
	{
		return "Bloquear usuario";
	}

	protected override string _GetTemplateForActionCancelBlockUser()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionChat()
	{
		return "Chatear";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Cerrar";
	}

	protected override string _GetTemplateForActionConfirmBlockUser()
	{
		return "Bloquear";
	}

	protected override string _GetTemplateForActionConfirmUnblockUser()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForActionFollow()
	{
		return "Seguir";
	}

	protected override string _GetTemplateForActionGridView()
	{
		return "Vista de rejilla";
	}

	protected override string _GetTemplateForActionImpersonateUser()
	{
		return "Imitar al usuario";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventario";
	}

	protected override string _GetTemplateForActionJoinGame()
	{
		return "Unirse al juego";
	}

	protected override string _GetTemplateForActionMessage()
	{
		return "Mensaje";
	}

	protected override string _GetTemplateForActionPending()
	{
		return "Pendiente";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Guardar";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Ver todo";
	}

	protected override string _GetTemplateForActionSeeLess()
	{
		return "Ver menos";
	}

	protected override string _GetTemplateForActionSeeMore()
	{
		return "Ver más";
	}

	protected override string _GetTemplateForActionSlideshowView()
	{
		return "Vista de diapositivas";
	}

	protected override string _GetTemplateForActionTrade()
	{
		return "Intercambiar";
	}

	protected override string _GetTemplateForActionTradeItems()
	{
		return "Intercambiar objetos";
	}

	protected override string _GetTemplateForActionUnblockUser()
	{
		return "Desbloquear usuario";
	}

	protected override string _GetTemplateForActionUnfollow()
	{
		return "Dejar de seguir";
	}

	protected override string _GetTemplateForActionUnfriend()
	{
		return "Cancelar amistad";
	}

	protected override string _GetTemplateForActionUpdateStatus()
	{
		return "Actualizar estado";
	}

	protected override string _GetTemplateForDescriptionBlockUserFooter()
	{
		return "Cuando bloqueas a un usuario, ninguno de los dos puede ponerse en contacto directo con el otro.";
	}

	protected override string _GetTemplateForDescriptionBlockUserPrompt()
	{
		return "¿Seguro que quieres bloquear a este usuario?";
	}

	protected override string _GetTemplateForDescriptionChangeAlias()
	{
		return "Solo tú puedes ver esta información";
	}

	protected override string _GetTemplateForDescriptionUnblockUserPrompt()
	{
		return "¿Seguro que quieres desbloquear a este usuario?";
	}

	protected override string _GetTemplateForHeadingAboutTab()
	{
		return "Sobre mí";
	}

	protected override string _GetTemplateForHeadingBlockUserTitle()
	{
		return "Advertencia";
	}

	protected override string _GetTemplateForHeadingCollections()
	{
		return "Colecciones";
	}

	protected override string _GetTemplateForHeadingCurrentlyWearing()
	{
		return "Ropa actual";
	}

	protected override string _GetTemplateForHeadingFavoriteGames()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForHeadingFriends()
	{
		return "Amigos";
	}

	/// <summary>
	/// Key: "Heading.FriendsNum"
	/// English String: "Friends ({friendsCount})"
	/// </summary>
	public override string HeadingFriendsNum(string friendsCount)
	{
		return $"Amigos ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingFriendsNum()
	{
		return "Amigos ({friendsCount})";
	}

	protected override string _GetTemplateForHeadingGames()
	{
		return "Juegos";
	}

	protected override string _GetTemplateForHeadingGameTitle()
	{
		return "Juegos";
	}

	protected override string _GetTemplateForHeadingGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsBadges()
	{
		return "Emblemas de jugador";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsClothing()
	{
		return "Ropa";
	}

	protected override string _GetTemplateForHeadingPlayerAssetsModels()
	{
		return "Modelos";
	}

	protected override string _GetTemplateForHeadingPlayerBadge()
	{
		return "Emblemas de jugador";
	}

	protected override string _GetTemplateForHeadingProfile()
	{
		return "Perfil";
	}

	protected override string _GetTemplateForHeadingProfileGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForHeadingRobloxBadge()
	{
		return "Emblemas de Roblox";
	}

	protected override string _GetTemplateForHeadingStatistics()
	{
		return "Estadísticas";
	}

	protected override string _GetTemplateForLabelAbout()
	{
		return "Información";
	}

	protected override string _GetTemplateForLabelAlias()
	{
		return "Apodo";
	}

	protected override string _GetTemplateForLabelBlockWarningBody()
	{
		return "¿Seguro que quieres bloquear a este usuario?";
	}

	protected override string _GetTemplateForLabelBlockWarningConfirm()
	{
		return "Bloquear";
	}

	protected override string _GetTemplateForLabelBlockWarningFooter()
	{
		return "Cuando bloqueas a un usuario, ninguno de los dos puede ponerse en contacto directo con el otro.";
	}

	protected override string _GetTemplateForLabelCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForLabelChangeAlias()
	{
		return "Elegir apodos";
	}

	protected override string _GetTemplateForLabelCreations()
	{
		return "Creaciones";
	}

	protected override string _GetTemplateForLabelFollowers()
	{
		return "Seguidores";
	}

	protected override string _GetTemplateForLabelFollowing()
	{
		return "Siguiendo";
	}

	protected override string _GetTemplateForLabelForumPosts()
	{
		return "Publicaciones en el foro";
	}

	protected override string _GetTemplateForLabelFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelGridView()
	{
		return "Vista de rejilla";
	}

	protected override string _GetTemplateForLabelJoinDate()
	{
		return "Fecha de registro";
	}

	protected override string _GetTemplateForLabelLoadMore()
	{
		return "Cargar más";
	}

	protected override string _GetTemplateForLabelMembers()
	{
		return "Miembros";
	}

	protected override string _GetTemplateForLabelPastUsername()
	{
		return "Nombres de usuario anteriores";
	}

	protected override string _GetTemplateForLabelPastUsernames()
	{
		return "Nombres de usuario anteriores";
	}

	protected override string _GetTemplateForLabelPlaceVisits()
	{
		return "Visitas a lugares";
	}

	protected override string _GetTemplateForLabelPlaying()
	{
		return "Jugando";
	}

	/// <summary>
	/// Key: "Label.Quotation"
	/// You only need to localize the quotation mark, e.g. 「{userStatus}」
	/// English String: "\"{userStatus}\""
	/// </summary>
	public override string LabelQuotation(string userStatus)
	{
		return $"\"{userStatus}\"";
	}

	protected override string _GetTemplateForLabelQuotation()
	{
		return "\"{userStatus}\"";
	}

	protected override string _GetTemplateForLabelRank()
	{
		return "Rango";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Más detalles";
	}

	protected override string _GetTemplateForLabelReportAbuse()
	{
		return "Denunciar abuso";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Mostrar menos";
	}

	protected override string _GetTemplateForLabelSlideshowView()
	{
		return "Vista de diapositivas";
	}

	protected override string _GetTemplateForLabelUnblockWarningBody()
	{
		return "¿Seguro que quieres desbloquear a este usuario?";
	}

	protected override string _GetTemplateForLabelUnblockWarningConfirm()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForLabelVisits()
	{
		return "Visitas";
	}

	protected override string _GetTemplateForLabelWarningTitle()
	{
		return "Advertencia";
	}

	protected override string _GetTemplateForMessageAliasHasError()
	{
		return "Se ha producido un error. Inténtalo de nuevo más tarde";
	}

	protected override string _GetTemplateForMessageAliasIsModerated()
	{
		return "Evita usar nombres completos o lenguaje ofensivo.";
	}

	protected override string _GetTemplateForMessageChangeStatus()
	{
		return "¿Qué cuentas?";
	}

	protected override string _GetTemplateForMessageErrorBlockLimit()
	{
		return "No se ha podido llevar a cabo la operación. Quizá hayas bloqueado a demasiadas personas.";
	}

	protected override string _GetTemplateForMessageErrorGeneral()
	{
		return "Algo ha ido mal. Vuelve a intentarlo dentro de unos minutos.";
	}

	/// <summary>
	/// Key: "Message.NoCreation"
	/// English String: "{username} has no creations."
	/// </summary>
	public override string MessageNoCreation(string username)
	{
		return $"{username} no tiene creaciones.";
	}

	protected override string _GetTemplateForMessageNoCreation()
	{
		return "{username} no tiene creaciones.";
	}

	protected override string _GetTemplateForMessageSharing()
	{
		return "Compartiendo...";
	}

	protected override string _GetTemplateForResponseTooManyAttempts()
	{
		return "Demasiados intentos";
	}
}
