namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides PremiumResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class PremiumResources_pt_br : PremiumResources_en_us, IPremiumResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Bought"
	/// English String: "Bought"
	/// </summary>
	public override string ActionBought => "Comprado";

	/// <summary>
	/// Key: "Action.BuyNow"
	/// English String: "Buy Now!"
	/// </summary>
	public override string ActionBuyNow => "Compre agora!";

	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Compre Robux";

	/// <summary>
	/// Key: "Description.GetMoreRobux"
	/// English String: "Get 10% more when purchasing Robux"
	/// </summary>
	public override string DescriptionGetMoreRobux => "Receba 10% a mais ao comprar Robux";

	/// <summary>
	/// Key: "Description.RobloxPremiumSubtitle"
	/// English String: "Joining Roblox Premium gets you a monthly Robux allowance and a 10% bonus when buying Robux. You will also get access to Roblox's economy features including buying, selling, and trading items, as well as increased revenue share on all sales in your games."
	/// </summary>
	public override string DescriptionRobloxPremiumSubtitle => "Assinar o Roblox Premium dá direito a uma mesada de Robux e um bônus de 10% ao comprar Robux. Você também ganha acesso a funcionalidades de economia, incluindo compra, venda e troca de itens, assim como uma porcentagem de renda maior em todas as vendas dentro dos seus jogos.";

	/// <summary>
	/// Key: "Description.SellMoreItems"
	/// English String: "Resell items and get more Robux selling your creations"
	/// </summary>
	public override string DescriptionSellMoreItems => "Revenda itens e ganhe mais Robux ao vender suas criações";

	/// <summary>
	/// Key: "Description.Trade"
	/// English String: "Trade items with other Premium members"
	/// </summary>
	public override string DescriptionTrade => "Troque itens com outros membros Premium";

	/// <summary>
	/// Key: "Heading.BuyRobux"
	/// The title of Robux page
	/// English String: "Buy Robux"
	/// </summary>
	public override string HeadingBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Heading.ConfirmCancellation"
	/// English String: "Confirm Cancellation"
	/// </summary>
	public override string HeadingConfirmCancellation => "Confirmar cancelamento";

	/// <summary>
	/// Key: "Heading.EvenMoreFeatures"
	/// English String: "Even more Features"
	/// </summary>
	public override string HeadingEvenMoreFeatures => "Ainda mais funcionalidades";

	/// <summary>
	/// Key: "Heading.GeneralError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingGeneralError => "Erro";

	/// <summary>
	/// Key: "Heading.PremiumRobuxDiscounts"
	/// English String: "As a Premium user, you get discounts on Robux!"
	/// </summary>
	public override string HeadingPremiumRobuxDiscounts => "Como usuário premium, você recebe descontos em Robux!";

	/// <summary>
	/// Key: "Heading.RobloxPremium"
	/// The title of Subscription page
	/// English String: "Roblox Premium"
	/// </summary>
	public override string HeadingRobloxPremium => "Roblox Premium";

	/// <summary>
	/// Key: "Heading.ServerError"
	/// English String: "Server Error"
	/// </summary>
	public override string HeadingServerError => "Erro de servidor";

	/// <summary>
	/// Key: "Heading.SubscriptionUnavailable"
	/// English String: "Subscription Unavailable"
	/// </summary>
	public override string HeadingSubscriptionUnavailable => "Assinatura não disponível";

	/// <summary>
	/// Key: "Heading.SwitchPlanModal"
	/// English String: "Confirm Subscription Update"
	/// </summary>
	public override string HeadingSwitchPlanModal => "Confirmar atualização de assinatura";

	/// <summary>
	/// Key: "Heading.UnableToFindBc"
	/// English String: "Cannot find Builders Club"
	/// </summary>
	public override string HeadingUnableToFindBc => "Impossível encontrar Builders Club";

	/// <summary>
	/// Key: "Heading.UpgradeToPremium"
	/// English String: "Upgrade to Roblox Premium"
	/// </summary>
	public override string HeadingUpgradeToPremium => "Fazer upgrade para Roblox Premium";

	/// <summary>
	/// Key: "Heading.UpgradeUnavailable"
	/// English String: "Upgrade Unavailable"
	/// </summary>
	public override string HeadingUpgradeUnavailable => "Upgrade não disponível";

	/// <summary>
	/// Key: "Label.10PercentMoreRobux"
	/// Part 1 of a two part label (Label.SinceYouSubscribed)
	/// English String: "You'll get 10% more Robux"
	/// </summary>
	public override string Label10PercentMoreRobux => "Você receberá 10% a mais de Robux";

	/// <summary>
	/// Key: "Label.AndGetMore"
	/// English String: "and get more!"
	/// </summary>
	public override string LabelAndGetMore => "e receba mais!";

	/// <summary>
	/// Key: "Label.BecauseYouSubscribed"
	/// English String: "Because you Subscribed!"
	/// </summary>
	public override string LabelBecauseYouSubscribed => "Porque você assinou!";

	/// <summary>
	/// Key: "Label.BuyOnce"
	/// English String: "Buy Once"
	/// </summary>
	public override string LabelBuyOnce => "Comprar uma vez";

	/// <summary>
	/// Key: "Label.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string LabelBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancel => "Cancelar";

	/// <summary>
	/// Key: "Label.Confirm"
	/// English String: "Confirm"
	/// </summary>
	public override string LabelConfirm => "Confirmar";

	/// <summary>
	/// Key: "Label.CurrentPlan"
	/// English String: "Your Current Plan"
	/// </summary>
	public override string LabelCurrentPlan => "Seu plano atual";

	/// <summary>
	/// Key: "Label.Get10PercentOffRobux"
	/// English String: "Get 10% off Robux"
	/// </summary>
	public override string LabelGet10PercentOffRobux => "Receba 10% de desconto em Robux";

	/// <summary>
	/// Key: "Label.GetMoreRobux"
	/// English String: "Get More Robux"
	/// </summary>
	public override string LabelGetMoreRobux => "Receba mais Robux";

	/// <summary>
	/// Key: "Label.MembershipManagementRecurring"
	/// English String: "To manage your Premium subscription, please go to your Billing settings using a browser."
	/// </summary>
	public override string LabelMembershipManagementRecurring => "Para gerenciar sua assinatura Premium, vá até as configurações de Cobrança usando um navegador.";

	/// <summary>
	/// Key: "Label.No"
	/// English String: "No"
	/// </summary>
	public override string LabelNo => "Não";

	/// <summary>
	/// Key: "Label.PremiumClub2200"
	/// English String: "Roblox Premium 2200"
	/// </summary>
	public override string LabelPremiumClub2200 => "Roblox Premium 2200";

	/// <summary>
	/// Key: "Label.RobloxPremium"
	/// English String: "Roblox Premium"
	/// </summary>
	public override string LabelRobloxPremium => "Roblox Premium";

	/// <summary>
	/// Key: "Label.RobloxPremium1000"
	/// English String: "Roblox Premium 1000"
	/// </summary>
	public override string LabelRobloxPremium1000 => "Roblox Premium 1000";

	/// <summary>
	/// Key: "Label.RobloxPremium1000OneMonth"
	/// English String: "Roblox Premium 1000 One Month"
	/// </summary>
	public override string LabelRobloxPremium1000OneMonth => "Roblox Premium 1000 - Um mês";

	/// <summary>
	/// Key: "Label.RobloxPremium2200"
	/// English String: "Roblox Premium 2200"
	/// </summary>
	public override string LabelRobloxPremium2200 => "Roblox Premium 2200";

	/// <summary>
	/// Key: "Label.RobloxPremium2200OneMonth"
	/// English String: "Roblox Premium 2200 One Month"
	/// </summary>
	public override string LabelRobloxPremium2200OneMonth => "Roblox Premium 2200 - Um mês";

	/// <summary>
	/// Key: "Label.RobloxPremium450"
	/// English String: "Roblox Premium 450"
	/// </summary>
	public override string LabelRobloxPremium450 => "Roblox Premium 450";

	/// <summary>
	/// Key: "Label.RobloxPremium450OneMonth"
	/// English String: "Roblox Premium 450 One Month"
	/// </summary>
	public override string LabelRobloxPremium450OneMonth => "Roblox Premium 450 - Um mês";

	/// <summary>
	/// Key: "Label.SellMore"
	/// English String: "Sell More"
	/// </summary>
	public override string LabelSellMore => "Venda mais";

	/// <summary>
	/// Key: "Label.SinceYouSubscribed"
	/// Part 2 of a 2 part label
	/// English String: "since you subscribed"
	/// </summary>
	public override string LabelSinceYouSubscribed => "por conta da assinatura";

	/// <summary>
	/// Key: "Label.Subscribe"
	/// English String: "Subscribe"
	/// </summary>
	public override string LabelSubscribe => "Assinar";

	/// <summary>
	/// Key: "Label.Trade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelTrade => "Troque";

	/// <summary>
	/// Key: "Label.ValuePacks"
	/// English String: "Value Packs"
	/// </summary>
	public override string LabelValuePacks => "Pacotes econômicos";

	/// <summary>
	/// Key: "Label.WantMoreRobux"
	/// English String: "Want more Robux?"
	/// </summary>
	public override string LabelWantMoreRobux => "Quer mais Robux?";

	/// <summary>
	/// Key: "Label.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string LabelYes => "Sim";

	/// <summary>
	/// Key: "Message.GeneralError"
	/// English String: "An error occurred while updating your subscription. Please try again later."
	/// </summary>
	public override string MessageGeneralError => "Ocorreu um erro ao atualizar sua assinatura. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.NoDataError"
	/// English String: "No subscriptions information."
	/// </summary>
	public override string MessageNoDataError => "Sem informações de assinaturas.";

	/// <summary>
	/// Key: "Message.ServerError"
	/// English String: "A server error occurred while updating your subscription. Please try again later."
	/// </summary>
	public override string MessageServerError => "Ocorreu um erro de servidor ao atualizar sua assinatura. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.UnableToFindBc"
	/// English String: "Cannot find Builders Club information for this user."
	/// </summary>
	public override string MessageUnableToFindBc => "Impossível encontrar informações do Builders Club para este usuário.";

	/// <summary>
	/// Key: "Message.UpgradeUnavailableModal"
	/// English String: "We are sorry, we cannot change your subscription because there is currently no package equivalent to Lifetime Builders Club."
	/// </summary>
	public override string MessageUpgradeUnavailableModal => "Infelizmente não podemos alterar sua assinatura porque não há no momento um pacote equivalente ao Lifetime Builders Club.";

	/// <summary>
	/// Key: "SwitchPlanTitle"
	/// Wrong string. Do translate this.
	/// English String: "Confirm Subscription Update"
	/// </summary>
	public override string SwitchPlanTitle => "Confirmar atualização de assinatura";

	public PremiumResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBought()
	{
		return "Comprado";
	}

	protected override string _GetTemplateForActionBuyNow()
	{
		return "Compre agora!";
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Compre Robux";
	}

	/// <summary>
	/// Key: "Description.BuyMoreRobuxSubtitle"
	/// English String: "Buy Robux to purchase upgrades for your avatar or special abilities in games.{lineBreak} Subscribe to Roblox Premium and get even more Robux each month, as well as bonus features. Premium is billed every month until cancelled. {learnMoreLinkStart}Learn more here.{learnMoreLinkEnd}"
	/// </summary>
	public override string DescriptionBuyMoreRobuxSubtitle(string lineBreak, string learnMoreLinkStart, string learnMoreLinkEnd)
	{
		return $"Adquira Robux para comprar melhorias para seu avatar ou habilidades especiais nos jogos.{lineBreak} Assine o Roblox Premium para obter ainda mais Robux e recursos adicionais todo mês. O Roblox Premium é cobrado todo mês até que seja cancelado. {learnMoreLinkStart}Saiba mais aqui.{learnMoreLinkEnd}";
	}

	protected override string _GetTemplateForDescriptionBuyMoreRobuxSubtitle()
	{
		return "Adquira Robux para comprar melhorias para seu avatar ou habilidades especiais nos jogos.{lineBreak} Assine o Roblox Premium para obter ainda mais Robux e recursos adicionais todo mês. O Roblox Premium é cobrado todo mês até que seja cancelado. {learnMoreLinkStart}Saiba mais aqui.{learnMoreLinkEnd}";
	}

	/// <summary>
	/// Key: "Description.BuyRobuxSubtitle"
	/// English String: "Get Robux to purchase upgrades for your avatar or buy special abilities in games. For more information on how to earn Robux, visit our {helpLinkStart}Robux Help page{helpLinkEnd}.{paragraphBreaker}Purchase Roblox Premium to get more Robux for the same price. Roblox Premium is billed every month until cancelled. {learnMoreLinkStart}Learn more here{learnMoreLinkEnd}."
	/// </summary>
	public override string DescriptionBuyRobuxSubtitle(string helpLinkStart, string helpLinkEnd, string paragraphBreaker, string learnMoreLinkStart, string learnMoreLinkEnd)
	{
		return $"Adquira Robux para comprar melhorias para seu avatar ou habilidades especiais nos jogos. Para mais informações sobre como obter Robux, visite nossa {helpLinkStart}página de Ajuda de Robux{helpLinkEnd}.{paragraphBreaker}Compre Roblox Premium para obter mais Robux pelo mesmo preço. Roblox Premium é cobrado todo mês até cancelado. {learnMoreLinkStart}Saiba mais aqui{learnMoreLinkEnd}.";
	}

	protected override string _GetTemplateForDescriptionBuyRobuxSubtitle()
	{
		return "Adquira Robux para comprar melhorias para seu avatar ou habilidades especiais nos jogos. Para mais informações sobre como obter Robux, visite nossa {helpLinkStart}página de Ajuda de Robux{helpLinkEnd}.{paragraphBreaker}Compre Roblox Premium para obter mais Robux pelo mesmo preço. Roblox Premium é cobrado todo mês até cancelado. {learnMoreLinkStart}Saiba mais aqui{learnMoreLinkEnd}.";
	}

	protected override string _GetTemplateForDescriptionGetMoreRobux()
	{
		return "Receba 10% a mais ao comprar Robux";
	}

	/// <summary>
	/// Key: "Description.IosMonthlySubscriptionDisclosure"
	/// English String: "Roblox Premium is a monthly subscription that costs {costPrice}. Payment will be charged to the iTunes Account at confirmation of purchase. Roblox Premium will automatically renew unless auto-renewal is turned off at least 24-hours before the end of the current period. Your account will be charged {renewalPrice} for renewal within 24-hours prior to the end of the current period. Subscriptions may be managed and auto-renewal may be turned off by going to your Account Settings. If you're under 18 make sure you have the permission of your parent or legal guardian before making a purchase. Making a purchase without permission may result in your account being deleted."
	/// </summary>
	public override string DescriptionIosMonthlySubscriptionDisclosure(string costPrice, string renewalPrice)
	{
		return $"Roblox Premium é uma assinatura mensal que custa {costPrice}. O pagamento será cobrado na Conta iTunes após a confirmação da compra. O Roblox Premium será renovado automaticamente, exceto se a autorrenovação for cancelada pelo menos 24h antes do término do período atual. Haverá uma cobrança de {renewalPrice} pela renovação em sua conta 24h antes do término do período atual. As assinaturas podem ser gerenciadas e a autorrenovação pode ser desabilitada em suas Configurações de Conta. Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta.";
	}

	protected override string _GetTemplateForDescriptionIosMonthlySubscriptionDisclosure()
	{
		return "Roblox Premium é uma assinatura mensal que custa {costPrice}. O pagamento será cobrado na Conta iTunes após a confirmação da compra. O Roblox Premium será renovado automaticamente, exceto se a autorrenovação for cancelada pelo menos 24h antes do término do período atual. Haverá uma cobrança de {renewalPrice} pela renovação em sua conta 24h antes do término do período atual. As assinaturas podem ser gerenciadas e a autorrenovação pode ser desabilitada em suas Configurações de Conta. Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta.";
	}

	/// <summary>
	/// Key: "Description.IosSubscriptionDisclosure"
	/// English String: "Roblox Premium is a {durationType} subscription that costs {costPrice}. Payment will be charged to the iTunes Account at confirmation of purchase. Roblox Premium will automatically renew unless auto-renewal is turned off at least 24-hours before the end of the current period. Your account will be charged {renewalPrice} for renewal within 24-hours prior to the end of the current period. Subscriptions may be managed and auto-renewal may be turned off by going to your Account Settings."
	/// </summary>
	public override string DescriptionIosSubscriptionDisclosure(string durationType, string costPrice, string renewalPrice)
	{
		return $"Roblox Premium é uma assinatura {durationType} que custa {costPrice}. O pagamento será cobrado na Conta iTunes após a confirmação da compra. O Roblox Premium será renovado automaticamente, exceto se a autorrenovação for cancelada pelo menos 24h antes do término do período atual. Haverá uma cobrança de {renewalPrice} pela renovação em sua conta 24h antes do término do período atual. As assinaturas podem ser gerenciadas e a autorrenovação pode ser desabilitada em suas Configurações de Conta.";
	}

	protected override string _GetTemplateForDescriptionIosSubscriptionDisclosure()
	{
		return "Roblox Premium é uma assinatura {durationType} que custa {costPrice}. O pagamento será cobrado na Conta iTunes após a confirmação da compra. O Roblox Premium será renovado automaticamente, exceto se a autorrenovação for cancelada pelo menos 24h antes do término do período atual. Haverá uma cobrança de {renewalPrice} pela renovação em sua conta 24h antes do término do período atual. As assinaturas podem ser gerenciadas e a autorrenovação pode ser desabilitada em suas Configurações de Conta.";
	}

	/// <summary>
	/// Key: "Description.legalDisclosuresPremiumRobuxPage"
	/// English String: "When you buy Robux, you receive only a limited, non-refundable, non-transferable, revocable license to use Robux, which have no value in real currency. See {termsLinkStart}Terms of Use{termsLinkEnd} for other limitations.  If you're under 18 make sure you have the permission of your parent or legal guardian before making a purchase. Making a purchase without permission may result in your account being deleted."
	/// </summary>
	public override string DescriptionlegalDisclosuresPremiumRobuxPage(string termsLinkStart, string termsLinkEnd)
	{
		return $"Ao comprar Robux, você recebe apenas uma licença limitada, não reembolsável, intransferível e revogável para usar Robux, que não tem valor em moedas reais. Confira os {termsLinkStart}Termos de Uso{termsLinkEnd} para obter mais informações sobre outras limitações. Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta.";
	}

	protected override string _GetTemplateForDescriptionlegalDisclosuresPremiumRobuxPage()
	{
		return "Ao comprar Robux, você recebe apenas uma licença limitada, não reembolsável, intransferível e revogável para usar Robux, que não tem valor em moedas reais. Confira os {termsLinkStart}Termos de Uso{termsLinkEnd} para obter mais informações sobre outras limitações. Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta.";
	}

	/// <summary>
	/// Key: "Description.legalDisclosuresPremiumUpgradePage"
	/// English String: "If you are under 18 make sure you have the permission of your parent or legal guardian before making a purchase. Making a purchase without permission may result in your account being deleted.  By clicking “Submit Order” (1) you authorize us to charge your account every month until you cancel the subscription, and (2) you represent that you understand and agree to the {termsLinkStart}Terms of Use{termsLinkEnd} and {privacyLinkStart}Privacy Policy{privatyLinkEnd}. You can cancel at any time by clicking “Cancel membership” on the {billingLinkStart}billing tab{billingLinkEnd}  of the setting page. If you cancel, you will still be charged for the current billing period."
	/// </summary>
	public override string DescriptionlegalDisclosuresPremiumUpgradePage(string termsLinkStart, string termsLinkEnd, string privacyLinkStart, string privatyLinkEnd, string billingLinkStart, string billingLinkEnd)
	{
		return $"Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta. Ao clicar em \"Enviar Pedido\", (1) você nos autoriza a fazer a cobrança em sua conta todo mês até que você cancele a assinatura; e (2) você declara que entende e aceita os {termsLinkStart}Termos de Uso{termsLinkEnd} e a {privacyLinkStart}Política de Privacidade{privatyLinkEnd}. Você pode cancelar a assinatura a qualquer momento clicando em \"Cancelar assinatura\" na {billingLinkStart}aba Cobrança{billingLinkEnd} da página de configurações. Ao cancelar, você ainda será cobrado pelo período de cobrança atual.";
	}

	protected override string _GetTemplateForDescriptionlegalDisclosuresPremiumUpgradePage()
	{
		return "Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta. Ao clicar em \"Enviar Pedido\", (1) você nos autoriza a fazer a cobrança em sua conta todo mês até que você cancele a assinatura; e (2) você declara que entende e aceita os {termsLinkStart}Termos de Uso{termsLinkEnd} e a {privacyLinkStart}Política de Privacidade{privatyLinkEnd}. Você pode cancelar a assinatura a qualquer momento clicando em \"Cancelar assinatura\" na {billingLinkStart}aba Cobrança{billingLinkEnd} da página de configurações. Ao cancelar, você ainda será cobrado pelo período de cobrança atual.";
	}

	/// <summary>
	/// Key: "Description.PremiumSubscriptionDisclosure"
	/// Duplicated
	/// English String: "If you're under 18 make sure you have the permission of your parent or legal guardian before making a purchase. Making a purchase without permission may result in your account being deleted.  By clicking “Submit Order” (1) you authorize us to charge your account every month until you cancel the subscription, and (2) you represent that you understand and agree to the {teamOfUseLinkStart}Terms of Use{teamOfUseLinkEnd} and {privacyPolicyLinkStart}Privacy Policy{privacyPolicyLinkEnd}. You can cancel at any time by clicking “Cancel membership” on the {billingTabLinkStart}billing tab{billingTabLinkEnd} of the setting page. If you cancel, you will still be charged for the current billing period."
	/// </summary>
	public override string DescriptionPremiumSubscriptionDisclosure(string teamOfUseLinkStart, string teamOfUseLinkEnd, string privacyPolicyLinkStart, string privacyPolicyLinkEnd, string billingTabLinkStart, string billingTabLinkEnd)
	{
		return $"Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta. Ao clicar em \"Enviar Pedido\", (1) você nos autoriza a fazer a cobrança em sua conta todo mês até que você cancele a assinatura; e (2) você declara que entende e aceita os {teamOfUseLinkStart}Termos de Uso{teamOfUseLinkEnd} e a {privacyPolicyLinkStart}Política de Privacidade{privacyPolicyLinkEnd}. Você pode cancelar a assinatura a qualquer momento clicando em \"Cancelar assinatura\" na {billingTabLinkStart}aba Cobrança{billingTabLinkEnd} da página de configurações. Ao cancelar, você ainda será cobrado pelo período de cobrança atual.";
	}

	protected override string _GetTemplateForDescriptionPremiumSubscriptionDisclosure()
	{
		return "Se tiver menos de 18 anos, você precisa da permissão de seus pais ou responsáveis antes de efetuar uma compra. Fazer compras sem essa permissão pode resultar na exclusão da sua conta. Ao clicar em \"Enviar Pedido\", (1) você nos autoriza a fazer a cobrança em sua conta todo mês até que você cancele a assinatura; e (2) você declara que entende e aceita os {teamOfUseLinkStart}Termos de Uso{teamOfUseLinkEnd} e a {privacyPolicyLinkStart}Política de Privacidade{privacyPolicyLinkEnd}. Você pode cancelar a assinatura a qualquer momento clicando em \"Cancelar assinatura\" na {billingTabLinkStart}aba Cobrança{billingTabLinkEnd} da página de configurações. Ao cancelar, você ainda será cobrado pelo período de cobrança atual.";
	}

	protected override string _GetTemplateForDescriptionRobloxPremiumSubtitle()
	{
		return "Assinar o Roblox Premium dá direito a uma mesada de Robux e um bônus de 10% ao comprar Robux. Você também ganha acesso a funcionalidades de economia, incluindo compra, venda e troca de itens, assim como uma porcentagem de renda maior em todas as vendas dentro dos seus jogos.";
	}

	protected override string _GetTemplateForDescriptionSellMoreItems()
	{
		return "Revenda itens e ganhe mais Robux ao vender suas criações";
	}

	protected override string _GetTemplateForDescriptionTrade()
	{
		return "Troque itens com outros membros Premium";
	}

	protected override string _GetTemplateForHeadingBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForHeadingConfirmCancellation()
	{
		return "Confirmar cancelamento";
	}

	protected override string _GetTemplateForHeadingEvenMoreFeatures()
	{
		return "Ainda mais funcionalidades";
	}

	protected override string _GetTemplateForHeadingGeneralError()
	{
		return "Erro";
	}

	protected override string _GetTemplateForHeadingPremiumRobuxDiscounts()
	{
		return "Como usuário premium, você recebe descontos em Robux!";
	}

	protected override string _GetTemplateForHeadingRobloxPremium()
	{
		return "Roblox Premium";
	}

	protected override string _GetTemplateForHeadingServerError()
	{
		return "Erro de servidor";
	}

	protected override string _GetTemplateForHeadingSubscriptionUnavailable()
	{
		return "Assinatura não disponível";
	}

	protected override string _GetTemplateForHeadingSwitchPlanModal()
	{
		return "Confirmar atualização de assinatura";
	}

	protected override string _GetTemplateForHeadingUnableToFindBc()
	{
		return "Impossível encontrar Builders Club";
	}

	protected override string _GetTemplateForHeadingUpgradeToPremium()
	{
		return "Fazer upgrade para Roblox Premium";
	}

	protected override string _GetTemplateForHeadingUpgradeUnavailable()
	{
		return "Upgrade não disponível";
	}

	protected override string _GetTemplateForLabel10PercentMoreRobux()
	{
		return "Você receberá 10% a mais de Robux";
	}

	protected override string _GetTemplateForLabelAndGetMore()
	{
		return "e receba mais!";
	}

	protected override string _GetTemplateForLabelBecauseYouSubscribed()
	{
		return "Porque você assinou!";
	}

	protected override string _GetTemplateForLabelBuyOnce()
	{
		return "Comprar uma vez";
	}

	protected override string _GetTemplateForLabelBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForLabelCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForLabelConfirm()
	{
		return "Confirmar";
	}

	protected override string _GetTemplateForLabelCurrentPlan()
	{
		return "Seu plano atual";
	}

	protected override string _GetTemplateForLabelGet10PercentOffRobux()
	{
		return "Receba 10% de desconto em Robux";
	}

	protected override string _GetTemplateForLabelGetMoreRobux()
	{
		return "Receba mais Robux";
	}

	protected override string _GetTemplateForLabelMembershipManagementRecurring()
	{
		return "Para gerenciar sua assinatura Premium, vá até as configurações de Cobrança usando um navegador.";
	}

	/// <summary>
	/// Key: "Label.MembershipStatus"
	/// English String: "Your current plan is {premiumSubscription}. It will expire on {expirationDate}."
	/// </summary>
	public override string LabelMembershipStatus(string premiumSubscription, string expirationDate)
	{
		return $"Seu plano atual é {premiumSubscription}. Ele vai expirar em {expirationDate}.";
	}

	protected override string _GetTemplateForLabelMembershipStatus()
	{
		return "Seu plano atual é {premiumSubscription}. Ele vai expirar em {expirationDate}.";
	}

	/// <summary>
	/// Key: "Label.MembershipStatusExpiration"
	/// English String: "Your current plan is {premiumSubscription}. It will expire on {expirationDate}. You can repurchase or buy a new plan once your membership expires. "
	/// </summary>
	public override string LabelMembershipStatusExpiration(string premiumSubscription, string expirationDate)
	{
		return $"Seu plano atual é {premiumSubscription}. Ele será renovado em {expirationDate}. Você pode recomprar ou comprar um novo plano assim que sua assinatura expirar.";
	}

	protected override string _GetTemplateForLabelMembershipStatusExpiration()
	{
		return "Seu plano atual é {premiumSubscription}. Ele será renovado em {expirationDate}. Você pode recomprar ou comprar um novo plano assim que sua assinatura expirar.";
	}

	/// <summary>
	/// Key: "Label.MembershipStatusRecurring"
	/// English String: "Your current plan is {premiumSubscription}. It will renew on {renewal}."
	/// </summary>
	public override string LabelMembershipStatusRecurring(string premiumSubscription, string renewal)
	{
		return $"Seu plano atual é {premiumSubscription}. Ele será renovado em {renewal}.";
	}

	protected override string _GetTemplateForLabelMembershipStatusRecurring()
	{
		return "Seu plano atual é {premiumSubscription}. Ele será renovado em {renewal}.";
	}

	protected override string _GetTemplateForLabelNo()
	{
		return "Não";
	}

	protected override string _GetTemplateForLabelPremiumClub2200()
	{
		return "Roblox Premium 2200";
	}

	/// <summary>
	/// Key: "Label.PriceMonth"
	/// English String: "{robux}{subTextStart}/month{subTextEnd}"
	/// </summary>
	public override string LabelPriceMonth(string robux, string subTextStart, string subTextEnd)
	{
		return $"{robux}{subTextStart}/mês{subTextEnd}";
	}

	protected override string _GetTemplateForLabelPriceMonth()
	{
		return "{robux}{subTextStart}/mês{subTextEnd}";
	}

	/// <summary>
	/// Key: "Label.PricePerMonth"
	/// Please don't translate this one. This should be removed.
	/// English String: "{robuxAmount}/month"
	/// </summary>
	public override string LabelPricePerMonth(string robuxAmount)
	{
		return $"{robuxAmount}/mês";
	}

	protected override string _GetTemplateForLabelPricePerMonth()
	{
		return "{robuxAmount}/mês";
	}

	protected override string _GetTemplateForLabelRobloxPremium()
	{
		return "Roblox Premium";
	}

	protected override string _GetTemplateForLabelRobloxPremium1000()
	{
		return "Roblox Premium 1000";
	}

	protected override string _GetTemplateForLabelRobloxPremium1000OneMonth()
	{
		return "Roblox Premium 1000 - Um mês";
	}

	protected override string _GetTemplateForLabelRobloxPremium2200()
	{
		return "Roblox Premium 2200";
	}

	protected override string _GetTemplateForLabelRobloxPremium2200OneMonth()
	{
		return "Roblox Premium 2200 - Um mês";
	}

	protected override string _GetTemplateForLabelRobloxPremium450()
	{
		return "Roblox Premium 450";
	}

	protected override string _GetTemplateForLabelRobloxPremium450OneMonth()
	{
		return "Roblox Premium 450 - Um mês";
	}

	protected override string _GetTemplateForLabelSellMore()
	{
		return "Venda mais";
	}

	protected override string _GetTemplateForLabelSinceYouSubscribed()
	{
		return "por conta da assinatura";
	}

	protected override string _GetTemplateForLabelSubscribe()
	{
		return "Assinar";
	}

	/// <summary>
	/// Key: "Label.SubscribeUpsell"
	/// English String: "Subscribe {upsellLinkStart}and get more!{upsellLinkEnd}"
	/// </summary>
	public override string LabelSubscribeUpsell(string upsellLinkStart, string upsellLinkEnd)
	{
		return $"Assine {upsellLinkStart}e receba mais!{upsellLinkEnd}";
	}

	protected override string _GetTemplateForLabelSubscribeUpsell()
	{
		return "Assine {upsellLinkStart}e receba mais!{upsellLinkEnd}";
	}

	protected override string _GetTemplateForLabelTrade()
	{
		return "Troque";
	}

	protected override string _GetTemplateForLabelValuePacks()
	{
		return "Pacotes econômicos";
	}

	protected override string _GetTemplateForLabelWantMoreRobux()
	{
		return "Quer mais Robux?";
	}

	protected override string _GetTemplateForLabelYes()
	{
		return "Sim";
	}

	/// <summary>
	/// Key: "Message.ConfirmCancellationModal"
	/// English String: "By clicking \"Confirm\" will end your Builders Club membership so you can subscribe to Roblox Premium.{newLine} You will receive a one-time payout of {robuxAmount}"
	/// </summary>
	public override string MessageConfirmCancellationModal(string newLine, string robuxAmount)
	{
		return $"Ao clicar em “Confirmar\" você encerrará sua assinatura do Builders Club para poder assinar o Roblox Premium.{newLine} Você receberá um pagamento único de {robuxAmount}";
	}

	protected override string _GetTemplateForMessageConfirmCancellationModal()
	{
		return "Ao clicar em “Confirmar\" você encerrará sua assinatura do Builders Club para poder assinar o Roblox Premium.{newLine} Você receberá um pagamento único de {robuxAmount}";
	}

	protected override string _GetTemplateForMessageGeneralError()
	{
		return "Ocorreu um erro ao atualizar sua assinatura. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageNoDataError()
	{
		return "Sem informações de assinaturas.";
	}

	protected override string _GetTemplateForMessageServerError()
	{
		return "Ocorreu um erro de servidor ao atualizar sua assinatura. Tente novamente mais tarde.";
	}

	/// <summary>
	/// Key: "Message.SubscriptionUnavailableModal"
	/// English String: "We are sorry, you cannot subscribe until your current cancelled plan has expired. Please re-subscribe on {expiredDate}."
	/// </summary>
	public override string MessageSubscriptionUnavailableModal(string expiredDate)
	{
		return $"Infelizmente você não pode assinar até que seu plano cancelado atual tenha expirado. Reative a assinatura a partir de {expiredDate}.";
	}

	protected override string _GetTemplateForMessageSubscriptionUnavailableModal()
	{
		return "Infelizmente você não pode assinar até que seu plano cancelado atual tenha expirado. Reative a assinatura a partir de {expiredDate}.";
	}

	/// <summary>
	/// Key: "Message.SwitchPlanBody"
	/// English String: "By clicking \"Confirm\" you authorize us to charge you {price} each month until you cancel or switch subscriptions effective {renewalDate}"
	/// </summary>
	public override string MessageSwitchPlanBody(string price, string renewalDate)
	{
		return $"Clicando em “Confirmar\" você nos autoriza a cobrar {price} todo mês até que você cancele ou troque a assinatura. Data de renovação: {renewalDate}";
	}

	protected override string _GetTemplateForMessageSwitchPlanBody()
	{
		return "Clicando em “Confirmar\" você nos autoriza a cobrar {price} todo mês até que você cancele ou troque a assinatura. Data de renovação: {renewalDate}";
	}

	protected override string _GetTemplateForMessageUnableToFindBc()
	{
		return "Impossível encontrar informações do Builders Club para este usuário.";
	}

	protected override string _GetTemplateForMessageUpgradeUnavailableModal()
	{
		return "Infelizmente não podemos alterar sua assinatura porque não há no momento um pacote equivalente ao Lifetime Builders Club.";
	}

	protected override string _GetTemplateForSwitchPlanTitle()
	{
		return "Confirmar atualização de assinatura";
	}
}
