namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides MessagesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class MessagesResources_es_es : MessagesResources_en_us, IMessagesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Archive"
	/// English String: "Archive"
	/// </summary>
	public override string ActionArchive => "Archivar";

	/// <summary>
	/// Key: "Action.Back"
	/// English String: "Back"
	/// </summary>
	public override string ActionBack => "Volver";

	/// <summary>
	/// Key: "Action.Discard"
	/// English String: "Discard"
	/// </summary>
	public override string ActionDiscard => "Descartar";

	/// <summary>
	/// Key: "Action.MarkAsRead"
	/// English String: "Mark As Read"
	/// </summary>
	public override string ActionMarkAsRead => "Marcar como leído";

	/// <summary>
	/// Key: "Action.MarkAsUnread"
	/// English String: "Mark As Unread"
	/// </summary>
	public override string ActionMarkAsUnread => "Marcar como no leído";

	/// <summary>
	/// Key: "Action.MoveToInbox"
	/// English String: "Move To Inbox"
	/// </summary>
	public override string ActionMoveToInbox => "Mover al buzón";

	/// <summary>
	/// Key: "Action.Reply"
	/// English String: "Reply"
	/// </summary>
	public override string ActionReply => "Responder";

	/// <summary>
	/// Key: "Action.ReportAbuse"
	/// English String: "Report Abuse"
	/// </summary>
	public override string ActionReportAbuse => "Denunciar abuso";

	/// <summary>
	/// Key: "Action.Send"
	/// English String: "Send"
	/// </summary>
	public override string ActionSend => "Enviar";

	/// <summary>
	/// Key: "Action.SendReply"
	/// English String: "Send Reply"
	/// </summary>
	public override string ActionSendReply => "Enviar respuesta";

	/// <summary>
	/// Key: "Heading.Message"
	/// English String: "Messages"
	/// </summary>
	public override string HeadingMessage => "Mensajes";

	/// <summary>
	/// Key: "Heading.NewMessages"
	/// English String: "New Message"
	/// </summary>
	public override string HeadingNewMessages => "Nuevo mensaje";

	/// <summary>
	/// Key: "Heading.Response"
	/// English String: "Responses:"
	/// </summary>
	public override string HeadingResponse => "Respuestas:";

	/// <summary>
	/// Key: "Label.All"
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Todos";

	/// <summary>
	/// Key: "Label.Archive"
	/// English String: "Archive"
	/// </summary>
	public override string LabelArchive => "Archivo";

	/// <summary>
	/// Key: "Label.Inbox"
	/// English String: "Inbox"
	/// </summary>
	public override string LabelInbox => "Buzón";

	/// <summary>
	/// Key: "Label.IncludeMessage"
	/// English String: "Include Previous Message"
	/// </summary>
	public override string LabelIncludeMessage => "Incluir mensaje anterior";

	/// <summary>
	/// Key: "Label.News"
	/// English String: "News"
	/// </summary>
	public override string LabelNews => "Noticias";

	/// <summary>
	/// Key: "Label.Of"
	/// English String: "Of"
	/// </summary>
	public override string LabelOf => "De";

	/// <summary>
	/// Key: "Label.Select"
	/// English String: "Select..."
	/// </summary>
	public override string LabelSelect => "Seleccionar...";

	/// <summary>
	/// Key: "Label.Sent"
	/// English String: "Sent"
	/// </summary>
	public override string LabelSent => "Enviados";

	/// <summary>
	/// Key: "Label.Subject"
	/// English String: "Subject:"
	/// </summary>
	public override string LabelSubject => "Asunto:";

	/// <summary>
	/// Key: "Label.To"
	/// English String: "To:"
	/// </summary>
	public override string LabelTo => "Para";

	/// <summary>
	/// Key: "Message.BodyCantBlank"
	/// English String: "The message body can't be blank."
	/// </summary>
	public override string MessageBodyCantBlank => "El cuerpo del mensaje no puede estar vacío.";

	/// <summary>
	/// Key: "Message.GeneralError"
	/// English String: "Sorry, an error occurred sending your message."
	/// </summary>
	public override string MessageGeneralError => "Lo sentimos, se ha producido un error al enviar tu mensaje.";

	/// <summary>
	/// Key: "Message.IdTheftWarning"
	/// English String: "Remember, Roblox staff will never ask you for your password. People who ask for your password are trying to steal your account."
	/// </summary>
	public override string MessageIdTheftWarning => "Recuerda: el personal de Roblox nunca te pedirá tu contraseña. Quien te pida tu contraseña te está intentando robar la cuenta.";

	/// <summary>
	/// Key: "Message.NoMessageExist"
	/// English String: "Message doesn't exist"
	/// </summary>
	public override string MessageNoMessageExist => "El mensaje no existe.";

	/// <summary>
	/// Key: "Message.NoNews"
	/// English String: "You have no news."
	/// </summary>
	public override string MessageNoNews => "No tienes noticias.";

	/// <summary>
	/// Key: "Message.NoRecipient"
	/// English String: "Recipient doesn't exist!"
	/// </summary>
	public override string MessageNoRecipient => "¡El destinatario no existe!";

	/// <summary>
	/// Key: "Message.NotAuthorizeToManipulate"
	/// English String: "Not authorized to manipulate message"
	/// </summary>
	public override string MessageNotAuthorizeToManipulate => "No hay autorización para manipular el mensaje.";

	/// <summary>
	/// Key: "Message.NotSendAndModerated"
	/// English String: "Your message was not sent because it was moderated."
	/// </summary>
	public override string MessageNotSendAndModerated => "Tu mensaje no se ha enviado porque ha sido moderado.";

	/// <summary>
	/// Key: "Message.RecipientPrivacySettingsTooHigh"
	/// English String: "The recipient's privacy settings prevent you from sending this message."
	/// </summary>
	public override string MessageRecipientPrivacySettingsTooHigh => "La configuración de privacidad del destinatario te impide enviar este mensaje.";

	/// <summary>
	/// Key: "Message.ReplyHere"
	/// English String: "Reply here..."
	/// </summary>
	public override string MessageReplyHere => "Responde aquí...";

	/// <summary>
	/// Key: "Message.RobloxWarning"
	/// English String: "Remember, Roblox staff will never ask you for your password. People who ask for your password are trying to steal your account."
	/// </summary>
	public override string MessageRobloxWarning => "Recuerda: el personal de Roblox nunca te pedirá tu contraseña. Quien te pida tu contraseña te está intentando robar la cuenta.";

	/// <summary>
	/// Key: "Message.SendSuccessfully"
	/// English String: "Successfully sent message."
	/// </summary>
	public override string MessageSendSuccessfully => "Mensaje enviado correctamente.";

	/// <summary>
	/// Key: "Message.SendTooManyMessages"
	/// English String: "You're sending too many messages too quickly."
	/// </summary>
	public override string MessageSendTooManyMessages => "Estás enviando demasiados mensajes demasiado deprisa.";

	/// <summary>
	/// Key: "Message.SubjectCantBlank"
	/// English String: "The message subject can't be blank."
	/// </summary>
	public override string MessageSubjectCantBlank => "El asunto del mensaje no puede estar vacío.";

	/// <summary>
	/// Key: "Message.UnknownError"
	/// English String: "Unknown error"
	/// </summary>
	public override string MessageUnknownError => "Error desconocido";

	/// <summary>
	/// Key: "Message.UnknownMessageType"
	/// This serves as the fallback string for when an message type is received that the web chat does not know how to render.
	/// English String: "A message cannot be displayed"
	/// </summary>
	public override string MessageUnknownMessageType => "No se puede mostrar un mensaje";

	/// <summary>
	/// Key: "Message.WriteYourMessage"
	/// English String: "Write your message..."
	/// </summary>
	public override string MessageWriteYourMessage => "Escribe tu mensaje...";

	public MessagesResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionArchive()
	{
		return "Archivar";
	}

	protected override string _GetTemplateForActionBack()
	{
		return "Volver";
	}

	protected override string _GetTemplateForActionDiscard()
	{
		return "Descartar";
	}

	protected override string _GetTemplateForActionMarkAsRead()
	{
		return "Marcar como leído";
	}

	protected override string _GetTemplateForActionMarkAsUnread()
	{
		return "Marcar como no leído";
	}

	protected override string _GetTemplateForActionMoveToInbox()
	{
		return "Mover al buzón";
	}

	protected override string _GetTemplateForActionReply()
	{
		return "Responder";
	}

	protected override string _GetTemplateForActionReportAbuse()
	{
		return "Denunciar abuso";
	}

	protected override string _GetTemplateForActionSend()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForActionSendReply()
	{
		return "Enviar respuesta";
	}

	protected override string _GetTemplateForHeadingMessage()
	{
		return "Mensajes";
	}

	protected override string _GetTemplateForHeadingNewMessages()
	{
		return "Nuevo mensaje";
	}

	protected override string _GetTemplateForHeadingResponse()
	{
		return "Respuestas:";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelArchive()
	{
		return "Archivo";
	}

	protected override string _GetTemplateForLabelInbox()
	{
		return "Buzón";
	}

	protected override string _GetTemplateForLabelIncludeMessage()
	{
		return "Incluir mensaje anterior";
	}

	protected override string _GetTemplateForLabelNews()
	{
		return "Noticias";
	}

	/// <summary>
	/// Key: "Label.NoMessagesInCategory"
	/// English String: "You have no {activeTab} messages."
	/// </summary>
	public override string LabelNoMessagesInCategory(string activeTab)
	{
		return $"No tienes mensajes en {activeTab}.";
	}

	protected override string _GetTemplateForLabelNoMessagesInCategory()
	{
		return "No tienes mensajes en {activeTab}.";
	}

	protected override string _GetTemplateForLabelOf()
	{
		return "De";
	}

	protected override string _GetTemplateForLabelSelect()
	{
		return "Seleccionar...";
	}

	protected override string _GetTemplateForLabelSent()
	{
		return "Enviados";
	}

	protected override string _GetTemplateForLabelSubject()
	{
		return "Asunto:";
	}

	protected override string _GetTemplateForLabelTo()
	{
		return "Para";
	}

	protected override string _GetTemplateForMessageBodyCantBlank()
	{
		return "El cuerpo del mensaje no puede estar vacío.";
	}

	/// <summary>
	/// Key: "Message.BodyTooLong"
	/// English String: "Please shorten your message to {maxLength} characters or less and try again."
	/// </summary>
	public override string MessageBodyTooLong(string maxLength)
	{
		return $"Acorta tu mensaje a {maxLength} caracteres o menos e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForMessageBodyTooLong()
	{
		return "Acorta tu mensaje a {maxLength} caracteres o menos e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForMessageGeneralError()
	{
		return "Lo sentimos, se ha producido un error al enviar tu mensaje.";
	}

	protected override string _GetTemplateForMessageIdTheftWarning()
	{
		return "Recuerda: el personal de Roblox nunca te pedirá tu contraseña. Quien te pida tu contraseña te está intentando robar la cuenta.";
	}

	protected override string _GetTemplateForMessageNoMessageExist()
	{
		return "El mensaje no existe.";
	}

	protected override string _GetTemplateForMessageNoNews()
	{
		return "No tienes noticias.";
	}

	protected override string _GetTemplateForMessageNoRecipient()
	{
		return "¡El destinatario no existe!";
	}

	protected override string _GetTemplateForMessageNotAuthorizeToManipulate()
	{
		return "No hay autorización para manipular el mensaje.";
	}

	protected override string _GetTemplateForMessageNotSendAndModerated()
	{
		return "Tu mensaje no se ha enviado porque ha sido moderado.";
	}

	protected override string _GetTemplateForMessageRecipientPrivacySettingsTooHigh()
	{
		return "La configuración de privacidad del destinatario te impide enviar este mensaje.";
	}

	protected override string _GetTemplateForMessageReplyHere()
	{
		return "Responde aquí...";
	}

	protected override string _GetTemplateForMessageRobloxWarning()
	{
		return "Recuerda: el personal de Roblox nunca te pedirá tu contraseña. Quien te pida tu contraseña te está intentando robar la cuenta.";
	}

	/// <summary>
	/// Key: "Message.SenderPrivacySettingTooHeight"
	/// English String: "Your {frontLink}privacy settings{endLink} prevent you from sending this message."
	/// </summary>
	public override string MessageSenderPrivacySettingTooHeight(string frontLink, string endLink)
	{
		return $"Tu {frontLink}configuración de privacidad{endLink} te impide enviar este mensaje.";
	}

	protected override string _GetTemplateForMessageSenderPrivacySettingTooHeight()
	{
		return "Tu {frontLink}configuración de privacidad{endLink} te impide enviar este mensaje.";
	}

	protected override string _GetTemplateForMessageSendSuccessfully()
	{
		return "Mensaje enviado correctamente.";
	}

	protected override string _GetTemplateForMessageSendTooManyMessages()
	{
		return "Estás enviando demasiados mensajes demasiado deprisa.";
	}

	protected override string _GetTemplateForMessageSubjectCantBlank()
	{
		return "El asunto del mensaje no puede estar vacío.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Error desconocido";
	}

	protected override string _GetTemplateForMessageUnknownMessageType()
	{
		return "No se puede mostrar un mensaje";
	}

	/// <summary>
	/// Key: "Message.VerifySenderEmail"
	/// English String: "You must verify your email on the {frontLink}Account Settings{endLink} page before you can send messages."
	/// </summary>
	public override string MessageVerifySenderEmail(string frontLink, string endLink)
	{
		return $"Debes verificar tu correo electrónico en la página {frontLink}Configuración de cuenta{endLink} para poder enviar mensajes.";
	}

	protected override string _GetTemplateForMessageVerifySenderEmail()
	{
		return "Debes verificar tu correo electrónico en la página {frontLink}Configuración de cuenta{endLink} para poder enviar mensajes.";
	}

	protected override string _GetTemplateForMessageWriteYourMessage()
	{
		return "Escribe tu mensaje...";
	}
}
