namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_zh_tw : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "新增";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "加到遊戲";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "加到個人檔案";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "宣傳";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "同意";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "購買";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "取消";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "設定";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "確認";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "刪除";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "停用徽章";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "編輯虛擬人偶";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "啟用徽章";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "領取";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "安裝";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "道具欄";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "否";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "確定";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "移除";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "從個人檔案移除";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "租用";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "檢舉此道具";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "販賣";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "現在販賣";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "脫下";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "下架";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "試穿";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "升級";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "穿戴";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "是";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "內含道具";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "宣傳道具";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "確定";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "我們的贊助商送給您此道具。";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "您已擁有此道具";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "屬性";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "最佳價格";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Builders Club 限定。";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "確定從道具欄永久刪除此道具？";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "刪除道具";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "說明";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "確定停用此徽章？";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "已停止供應的道具，可轉賣。";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "確定啟用此徽章？";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "發生錯誤";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "免費";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "類別";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "只有 Builders Club 會員可以轉賣收藏品。現在加入 Builders Club！";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "只有 Premium 會員可以轉賣收藏品。現在取得 Premium！";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "地點無效。";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "產品無效。";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "此道具在您的道具欄。";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "此道具目前為非賣品。";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "已擁有道具";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "無";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "無";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "價格";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "價格無效。";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "價格（最低 1）";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "購買完成";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "稀有度";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "閱讀更多";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "租用道具";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "販賣您的收藏品";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "限量發行系列，可轉賣。";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "無序號";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "序號";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "顯示更少";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "標籤";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "下架";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "確定將此道具下架？";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "限 13 歲以上。";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "類型";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "更新";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "您將獲得";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "已加到個人檔案";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "已加到您的虛擬人偶";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "您的遊戲的道具數量已達上限！";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "已成功停用徽章";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "已成功啟用徽章";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "無法加到個人檔案";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "無法從道具欄刪除此道具";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "無法停用徽章";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "無法啟用徽章";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "無法從個人檔案移除";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "已成功從道具欄移除";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "已從您的個人檔案移除";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "已自您的虛擬人偶移除";

	public ItemResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "新增";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "加到遊戲";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "加到個人檔案";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "宣傳";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "同意";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "購買";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "設定";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "確認";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "刪除";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "停用徽章";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "編輯虛擬人偶";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "啟用徽章";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "領取";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "安裝";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "道具欄";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "否";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "移除";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "從個人檔案移除";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "租用";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "檢舉此道具";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "販賣";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "現在販賣";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "脫下";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "下架";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "試穿";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "升級";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "穿戴";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "是";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "內含道具";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "宣傳道具";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"允許玩家在您的遊戲內使用此裝備。若有玩家在您的遊戲內購買此裝備，您將可賺取 {affiliateSaleTotal}。";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "允許玩家在您的遊戲內使用此裝備。若有玩家在您的遊戲內購買此裝備，您將可賺取 {affiliateSaleTotal}。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "確定";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "我們的贊助商送給您此道具。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "您已擁有此道具";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "屬性";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "最佳價格";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Builders Club 限定。";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"創作者：{creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "創作者：{creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"{numberOfDays} 天 {numberOfHours} 小時 {numberOfMinutes} 分鐘後下架";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "{numberOfDays} 天 {numberOfHours} 小時 {numberOfMinutes} 分鐘後下架";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "確定從道具欄永久刪除此道具？";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "刪除道具";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "說明";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "確定停用此徽章？";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "已停止供應的道具，可轉賣。";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"在 {placeLink} 贏得此徽章";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "在 {placeLink} 贏得此徽章";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "確定啟用此徽章？";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "發生錯誤";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "免費";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "類別";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "只有 Builders Club 會員可以轉賣收藏品。現在加入 Builders Club！";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "只有 Premium 會員可以轉賣收藏品。現在取得 Premium！";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "地點無效。";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "產品無效。";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "此道具在您的道具欄。";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "此道具目前為非賣品。";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "已擁有道具";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"已擁有道具（{amount}）";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "已擁有道具（{amount}）";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"{name} 的近期平均價格是 {price}。";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "{name} 的近期平均價格是 {price}。";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"市集費（{percent}%）";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "市集費（{percent}%）";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "無";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "無";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"{numberOfHours} 小時 {numberOfMinutes} 分鐘 {numberOfSeconds} 秒後下架";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "{numberOfHours} 小時 {numberOfMinutes} 分鐘 {numberOfSeconds} 秒後下架";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "價格";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "價格無效。";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "價格（最低 1）";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "購買完成";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "稀有度";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "閱讀更多";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "租用道具";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"確定以 {price} 販賣 {name}？";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "確定以 {price} 販賣 {name}？";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "販賣您的收藏品";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "限量發行系列，可轉賣。";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "無序號";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "序號";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"序號 #{number} / {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "序號 #{number} / {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "顯示更少";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "標籤";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "下架";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "確定將此道具下架？";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "限 13 歲以上。";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "類型";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "更新";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"（創作者：{link}）";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "（創作者：{link}）";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"在 {placeLink} 使用此遊戲證";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "在 {placeLink} 使用此遊戲證";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "您將獲得";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "已加到個人檔案";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "已加到您的虛擬人偶";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "您的遊戲的道具數量已達上限！";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "已成功停用徽章";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "已成功啟用徽章";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "無法加到個人檔案";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "無法從道具欄刪除此道具";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "無法停用徽章";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "無法啟用徽章";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "無法從個人檔案移除";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"已將 {placeName} 加到您的遊戲。";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "已將 {placeName} 加到您的遊戲。";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"您已將此裝備加到 {placeName}。";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "您已將此裝備加到 {placeName}。";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "已成功從道具欄移除";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "已從您的個人檔案移除";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "已自您的虛擬人偶移除";
	}
}
