namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_zh_cjv : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "添加";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "添加至游戏";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "添加至个人资料";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "广告";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "同意";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "购买";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "取消";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "配置";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "确认";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "删除";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "停用徽章";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "编辑虚拟形象";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "启用徽章";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "获取";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "安装";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "道具";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "否";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "好";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "移除";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "从个人资料移除";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "租用";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "举报物品";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "出售";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "立即出售";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "脱下";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "下架";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "试穿";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "升级";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "穿戴";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "是";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "包含项目";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "推广物品";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "好";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "我们的赞助商送给你此物品。";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "你已拥有此物品";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "属性";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "最佳价格";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Builders Club 专属。";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "是否确定要从你的道具中永久删除此物品？";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "删除物品";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "描述";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "是否确定要停用此徽章？";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "绝版物品，可转售。";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "是否确定要启用此徽章？";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "发生错误";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "免费";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "主题";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "只有 Builders Club 会员才能转售收藏品。立即加入 Builders Club 吧！";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "只有 Premium 会员才能转售收藏品。立即加入 Premium 吧！";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "地点无效。";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "产品无效。";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "此物品在你的道具栏中。";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "此物品目前为非卖品。";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "已拥有物品";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "无";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "N/A";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "价格";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "价格无效";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "价格（最低 1）";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "购买已完成";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "稀有度";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "阅读更多";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "租用物品";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "出售你的收藏品";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "按序号限量发行，可转售。";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "无序号";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "序号";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "收起";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "标签";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "下架";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "是否确定要将此物品下架？";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "仅限 13+。";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "类型";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "已更新";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "你获得";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "已添加至你的个人资料";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "已添加至你的虚拟形象";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "你游戏中的物品数量已达上限！";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "已成功停用徽章";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "已成功启用徽章";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "无法添加至个人资料";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "无法从道具中删除此物品";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "无法停用徽章";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "无法启用徽章";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "无法从个人资料移除";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "已成功从你的道具移除";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "已从你的个人资料删除";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "已从你的虚拟形象移除";

	public ItemResources_zh_cjv(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "添加";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "添加至游戏";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "添加至个人资料";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "广告";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "同意";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "购买";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "配置";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "确认";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "删除";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "停用徽章";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "编辑虚拟形象";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "启用徽章";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "获取";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "安装";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "道具";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "否";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "好";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "移除";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "从个人资料移除";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "租用";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "举报物品";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "出售";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "立即出售";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "脱下";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "下架";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "试穿";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "升级";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "穿戴";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "是";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "包含项目";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "推广物品";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"允许玩家在你的游戏中使用此装备；此外，如果有玩家从你的游戏页面购买此装备，你可赚取 {affiliateSaleTotal}。";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "允许玩家在你的游戏中使用此装备；此外，如果有玩家从你的游戏页面购买此装备，你可赚取 {affiliateSaleTotal}。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "好";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "我们的赞助商送给你此物品。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "你已拥有此物品";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "属性";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "最佳价格";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Builders Club 专属。";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"创作者 {creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "创作者 {creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"{numberOfDays} 小时 {numberOfHours} 分 {numberOfMinutes} 秒后下架";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "{numberOfDays} 小时 {numberOfHours} 分 {numberOfMinutes} 秒后下架";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "是否确定要从你的道具中永久删除此物品？";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "删除物品";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "描述";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "是否确定要停用此徽章？";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "绝版物品，可转售。";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"在“{placeLink}”赢取此徽章";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "在“{placeLink}”赢取此徽章";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "是否确定要启用此徽章？";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "发生错误";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "免费";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "主题";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "只有 Builders Club 会员才能转售收藏品。立即加入 Builders Club 吧！";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "只有 Premium 会员才能转售收藏品。立即加入 Premium 吧！";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "地点无效。";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "产品无效。";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "此物品在你的道具栏中。";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "此物品目前为非卖品。";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "已拥有物品";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"已拥有物品（{amount} 件）";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "已拥有物品（{amount} 件）";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"\"{name}\"的近期平均价格为 {price}。";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "\"{name}\"的近期平均价格为 {price}。";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"市集费（{percent}%）";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "市集费（{percent}%）";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "无";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "N/A";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"{numberOfHours} 小时 {numberOfMinutes} 分 {numberOfSeconds} 秒后下架";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "{numberOfHours} 小时 {numberOfMinutes} 分 {numberOfSeconds} 秒后下架";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "价格";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "价格无效";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "价格（最低 1）";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "购买已完成";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "稀有度";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "阅读更多";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "租用物品";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"是否确定要以 {price} 出售\"{name}\"？";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "是否确定要以 {price} 出售\"{name}\"？";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "出售你的收藏品";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "按序号限量发行，可转售。";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "无序号";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "序号";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"序号 #{number} / {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "序号 #{number} / {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "收起";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "标签";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "下架";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "是否确定要将此物品下架？";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "仅限 13+。";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "类型";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "已更新";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"（来源： {link}）";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "（来源： {link}）";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"前往“{placeLink}”使用此游戏通行证";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "前往“{placeLink}”使用此游戏通行证";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "你获得";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "已添加至你的个人资料";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "已添加至你的虚拟形象";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "你游戏中的物品数量已达上限！";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "已成功停用徽章";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "已成功启用徽章";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "无法添加至个人资料";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "无法从道具中删除此物品";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "无法停用徽章";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "无法启用徽章";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "无法从个人资料移除";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"已将 {placeName} 添加至你的游戏。";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "已将 {placeName} 添加至你的游戏。";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"你已将此装备添加至 {placeName}。";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "你已将此装备添加至 {placeName}。";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "已成功从你的道具移除";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "已从你的个人资料删除";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "已从你的虚拟形象移除";
	}
}
