namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_pt_br : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "Adicionar";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "Adicionar ao jogo";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "Adicionar ao perfil";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "Anunciar";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "Concordar";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "Configurar";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "Confirmar";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Excluir";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "Desabilitar emblema";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "Editar avatar";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "Habilitar emblema";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Obter";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "Instalar";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventário";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "Não";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "OK";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "Remover";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "Remover do perfil";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "Aluguel";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "Denunciar item";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "Vender";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "Vender agora";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "Remover";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "Cancelar venda";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "Experimentar";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "Melhorar";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "Usar";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "Sim";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "Itens inclusos";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "Promover item";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "OK";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "Você acabou de ganhar este item graças ao nosso patrocinador.";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "Este item agora é seu";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "Atributos";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "Melhor preço";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Exclusivo para Builders Club.";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "Quer mesmo EXCLUIR permanentemente este item do seu inventário?";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "Excluir item";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "Descrição";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "Quer mesmo desabilitar este emblema?";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "Item cancelado, pode ser revendido.";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "Quer mesmo habilitar este emblema?";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "Ocorreu um erro";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Grátis";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "Gênero";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "Apenas membros do Builders Club podem revender itens colecionáveis. Entre para o Builders Club hoje mesmo!";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "Apenas membros Premium podem revender itens colecionáveis. Passe a ser um membro Premium hoje mesmo!";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "Local inválido.";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "Produto inválido.";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "Este item está disponível no seu inventário.";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "Este item não está à venda no momento.";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "Você possui este item";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "Nenhuma";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "N/A";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "Preço";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "Preço inválido";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "Preço (mínimo de 1)";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "Compra concluída";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "Raridade";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Ler mais";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "Alugando item";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "Venda o seu item colecionável";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "Lançamento de série limitada, pode ser revendido.";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "Sem nº de série";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "Número de série";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Mostrar menos";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "Rótulos";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "Cancelar venda";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "Tem certeza de que deseja tirar este item da venda?";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "Somente para 13+.";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "Tipo";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "Atualizado";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "Você ganha";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "Adicionado ao seu perfil";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "Adicionado ao seu avatar";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "Você já tem o número máximo de itens no seu jogo!";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "Emblema desabilitado com sucesso";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "Emblema habilitado com sucesso";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "Falha ao adicionar ao perfil";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "Falha ao excluir item do inventário";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "Falha ao desabilitar emblema";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "Falha ao habilitar emblema";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "Falha ao remover do perfil";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "Removido do seu inventário com sucesso";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "Removido do seu perfil";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "Removido do seu avatar";

	public ItemResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "Adicionar";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "Adicionar ao jogo";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "Adicionar ao perfil";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "Anunciar";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "Concordar";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "Configurar";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "Confirmar";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Excluir";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "Desabilitar emblema";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "Editar avatar";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "Habilitar emblema";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Obter";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "Instalar";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventário";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "Não";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "Remover";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "Remover do perfil";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "Aluguel";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "Denunciar item";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "Vender";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "Vender agora";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "Remover";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "Cancelar venda";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "Experimentar";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "Melhorar";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "Usar";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "Sim";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "Itens inclusos";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "Promover item";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"Permite que os jogadores usem este equipamento dentro do seu jogo e que você ganhe {affiliateSaleTotal} quando ele for comprado em sua página do jogo.";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "Permite que os jogadores usem este equipamento dentro do seu jogo e que você ganhe {affiliateSaleTotal} quando ele for comprado em sua página do jogo.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "OK";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "Você acabou de ganhar este item graças ao nosso patrocinador.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "Este item agora é seu";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "Atributos";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "Melhor preço";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Exclusivo para Builders Club.";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"De {creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "De {creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"Retirado de venda em {numberOfDays} d {numberOfHours} h {numberOfMinutes} m";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "Retirado de venda em {numberOfDays} d {numberOfHours} h {numberOfMinutes} m";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "Quer mesmo EXCLUIR permanentemente este item do seu inventário?";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "Excluir item";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "Descrição";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "Quer mesmo desabilitar este emblema?";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "Item cancelado, pode ser revendido.";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"Ganhe este emblema em: {placeLink}";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "Ganhe este emblema em: {placeLink}";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "Quer mesmo habilitar este emblema?";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "Ocorreu um erro";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Grátis";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "Gênero";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "Apenas membros do Builders Club podem revender itens colecionáveis. Entre para o Builders Club hoje mesmo!";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "Apenas membros Premium podem revender itens colecionáveis. Passe a ser um membro Premium hoje mesmo!";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "Local inválido.";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "Produto inválido.";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "Este item está disponível no seu inventário.";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "Este item não está à venda no momento.";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "Você possui este item";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"Você possui este item ({amount})";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "Você possui este item ({amount})";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"O preço médio recente de {name} é {price}.";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "O preço médio recente de {name} é {price}.";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"Taxa de mercado (em {percent}%)";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "Taxa de mercado (em {percent}%)";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "Nenhuma";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "N/A";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"Retirado de venda em {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "Retirado de venda em {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "Preço";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "Preço inválido";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "Preço (mínimo de 1)";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "Compra concluída";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "Raridade";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Ler mais";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "Alugando item";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"Quer mesmo vender {name} por {price}?";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "Quer mesmo vender {name} por {price}?";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "Venda o seu item colecionável";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "Lançamento de série limitada, pode ser revendido.";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "Sem nº de série";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "Número de série";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"Nº de série {number} de {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "Nº de série {number} de {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Mostrar menos";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "Rótulos";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "Cancelar venda";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "Tem certeza de que deseja tirar este item da venda?";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "Somente para 13+.";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "Tipo";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "Atualizado";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"(de {link})";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "(de {link})";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"Use este Passe de Jogo em: {placeLink}";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "Use este Passe de Jogo em: {placeLink}";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "Você ganha";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "Adicionado ao seu perfil";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "Adicionado ao seu avatar";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "Você já tem o número máximo de itens no seu jogo!";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "Emblema desabilitado com sucesso";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "Emblema habilitado com sucesso";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "Falha ao adicionar ao perfil";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "Falha ao excluir item do inventário";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "Falha ao desabilitar emblema";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "Falha ao habilitar emblema";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "Falha ao remover do perfil";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"Adicionado ao seu jogo, {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "Adicionado ao seu jogo, {placeName}.";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"Você já adicionou este equipamento em {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "Você já adicionou este equipamento em {placeName}.";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "Removido do seu inventário com sucesso";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "Removido do seu perfil";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "Removido do seu avatar";
	}
}
