namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_ja_jp : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "追加";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "ゲームに追加";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "プロフィールに追加";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "宣伝";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "同意する";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "買う";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "キャンセル";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "環境設定する";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "確認";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "削除";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "バッジを無効にする";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "アバターを編集";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "バッジを有効にする";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "ゲットする";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "インストール";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "インベントリ";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "いいえ";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "OK";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "削除";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "プロフィールから削除";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "レンタル";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "アイテムを報告";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "売る";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "今すぐ売る";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "外す";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "非売品にする";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "装備してみる";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "アップグレード";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "装備";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "はい";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "含まれるアイテム";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "アイテムを宣伝する";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "OK";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "スポンサーのご厚意により、このアイテムを手に入れました。";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "このアイテムは、あなたのものです";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "属性";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "お買い得";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Builders Club限定。";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "このアイテムをインベントリから永久に削除してよろしいですか？";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "アイテムを削除";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "詳細";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "このバッジを無効にしてよろしいですか？";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "公開が終了したアイテムです。再販可能。";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "このバッジを有効にしてよろしいですか？";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "エラーが発生しました";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "無料";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "ジャンル";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "コレクタブルを再販できるのは、Builders Clubのメンバーだけです。今すぐBuilders Club参加しよう！";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "コレクタブルアイテムを再販できるのは、Premiumメンバーだけです。今すぐPremiumをゲットしよう！";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "プレースが無効です。";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "製品が無効です。";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "このアイテムはインベントリで利用できます。";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "このアイテムは現在売られていません。";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "所有しているアイテム";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "なし";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "該当なし";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "価格";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "価格が無効です";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "価格（最低1）";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "購入が完了しました";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "レア度";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "続きを読む";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "アイテムをレンタル中";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "コレクタブルアイテムを売る";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "シリアルナンバー付き限定公開。再販可能。";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "シリアルナンバーなし";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "シリアルナンバー";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "表示を減らす";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "タグ";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "非売品にする";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "このアイテムを非売品にしてもよろしいですか？";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "13歳以上限定。";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "タイプ";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "アップデート済み";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "獲得:";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "プロフィールに追加しました";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "アバターに追加しました";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "ゲームのアイテム数の上限に到達しています！";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "バッジを無効にしました";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "バッジを有効にしました";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "プロフィールに追加できません";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "インベントリからアイテムを削除できませんでした";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "バッジを無効にできません";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "バッジを有効にできません";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "プロフィールから削除できません";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "インベントリから削除しました";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "プロフィールから削除しました";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "アバターから削除しました";

	public ItemResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "追加";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "ゲームに追加";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "プロフィールに追加";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "宣伝";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "同意する";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "買う";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "キャンセル";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "環境設定する";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "確認";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "削除";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "バッジを無効にする";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "アバターを編集";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "バッジを有効にする";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "ゲットする";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "インストール";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "インベントリ";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "いいえ";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "削除";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "プロフィールから削除";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "レンタル";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "アイテムを報告";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "売る";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "今すぐ売る";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "外す";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "非売品にする";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "装備してみる";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "アップグレード";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "装備";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "はい";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "含まれるアイテム";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "アイテムを宣伝する";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"プレイヤーがゲームでこのギアを使えるようにします。誰かがゲームページで買ってくれると{affiliateSaleTotal}が手に入ります。";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "プレイヤーがゲームでこのギアを使えるようにします。誰かがゲームページで買ってくれると{affiliateSaleTotal}が手に入ります。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "OK";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "スポンサーのご厚意により、このアイテムを手に入れました。";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "このアイテムは、あなたのものです";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "属性";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "お買い得";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Builders Club限定。";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"作：{creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "作：{creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"あと {numberOfDays} 日 {numberOfHours} 時間 {numberOfMinutes} 分で非売品となります";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "あと {numberOfDays} 日 {numberOfHours} 時間 {numberOfMinutes} 分で非売品となります";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "このアイテムをインベントリから永久に削除してよろしいですか？";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "アイテムを削除";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "詳細";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "このバッジを無効にしてよろしいですか？";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "公開が終了したアイテムです。再販可能。";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"次の場所でこのバッジを手に入れよう: {placeLink}";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "次の場所でこのバッジを手に入れよう: {placeLink}";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "このバッジを有効にしてよろしいですか？";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "エラーが発生しました";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "無料";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "ジャンル";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "コレクタブルを再販できるのは、Builders Clubのメンバーだけです。今すぐBuilders Club参加しよう！";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "コレクタブルアイテムを再販できるのは、Premiumメンバーだけです。今すぐPremiumをゲットしよう！";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "プレースが無効です。";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "製品が無効です。";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "このアイテムはインベントリで利用できます。";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "このアイテムは現在売られていません。";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "所有しているアイテム";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"所有しているアイテム（{amount}）";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "所有しているアイテム（{amount}）";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"{name}の最近の平均価格は{price}です。";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "{name}の最近の平均価格は{price}です。";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"マーケットプレース使用料（{percent}%）";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "マーケットプレース使用料（{percent}%）";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "なし";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "該当なし";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"あと {numberOfHours} 時間 {numberOfMinutes} 分 {numberOfSeconds} 秒で非売品となります";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "あと {numberOfHours} 時間 {numberOfMinutes} 分 {numberOfSeconds} 秒で非売品となります";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "価格";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "価格が無効です";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "価格（最低1）";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "購入が完了しました";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "レア度";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "続きを読む";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "アイテムをレンタル中";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"{name}を{price}で売ってよろしいですか？";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "{name}を{price}で売ってよろしいですか？";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "コレクタブルアイテムを売る";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "シリアルナンバー付き限定公開。再販可能。";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "シリアルナンバーなし";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "シリアルナンバー";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"シリアルナンバー #{number} / {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "シリアルナンバー #{number} / {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "表示を減らす";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "タグ";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "非売品にする";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "このアイテムを非売品にしてもよろしいですか？";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "13歳以上限定。";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "タイプ";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "アップデート済み";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"（更新者{link}）";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "（更新者{link}）";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"次の場所でこのゲームパスを使おう: {placeLink}";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "次の場所でこのゲームパスを使おう: {placeLink}";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "獲得:";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "プロフィールに追加しました";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "アバターに追加しました";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "ゲームのアイテム数の上限に到達しています！";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "バッジを無効にしました";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "バッジを有効にしました";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "プロフィールに追加できません";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "インベントリからアイテムを削除できませんでした";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "バッジを無効にできません";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "バッジを有効にできません";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "プロフィールから削除できません";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"ゲーム{placeName}に追加しました";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "ゲーム{placeName}に追加しました";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"このギアはすでに{placeName}に追加されています。";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "このギアはすでに{placeName}に追加されています。";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "インベントリから削除しました";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "プロフィールから削除しました";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "アバターから削除しました";
	}
}
