namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_fr_fr : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "Ajouter";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "Ajouter au jeu";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "Ajouter au profil";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "Faire la publicité";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "Accepter";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Acheter";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Annuler";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "Configurer";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "Confirmer";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Supprimer";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "Désactiver badge";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "Modifier avatar";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "Activer badge";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Obtenir";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "Installer";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventaire";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "Non";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "OK";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "Supprimer";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "Retirer du profil";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "Louer";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "Signaler l'objet";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "Vendre";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "Vendre maintenant";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "Retirer";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "Retirer des offres";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "Essayer";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "Améliorer";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "Porter";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "Oui";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "Objets inclus";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "Promouvoir objet";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "OK";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "Notre sponsor vous a offert cet objet.";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "Cet objet est désormais en ta possession";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "Caractéristiques";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "Meilleur prix";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Exclusivité du Builders Club.";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "Voulez-vous vraiment SUPPRIMER cet objet de façon définitive\u00a0?";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "Supprimer l'objet";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "Description";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "Voulez-vous vraiment désactiver ce badge\u00a0?";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "Objet plus disponible, peut être revendu.";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "Voulez-vous vraiment activer ce badge\u00a0?";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "Une erreur est survenue.";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratuit";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "Genres";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "Seuls les membres du Builders Club peuvent revendre des objets de collection. Rejoignez le Builders Club dès maintenant\u00a0!";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "Seuls les membres premium peuvent revendre des objets de collection. Passez au statut premium dès maintenant\u00a0!";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "Emplacement non valide.";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "Produit non valide.";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "Cet objet se trouve dans ton inventaire.";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "Cet objet n'est pas en vente pour l'instant.";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "Objet possédé";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "Aucun";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "s.\u00a0o.";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "Prix";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "Le prix n'est pas valide.";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "Prix (minimum 1)";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "Achat effectué";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "Rareté";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Lire plus";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "Location d'objet";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "Vendre ton objet de collection";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "Parution en édition limitée, peut être revendu.";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "Nº de série non disponible";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "Numéro de série";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Afficher moins";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "Tags";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "Retirer des offres";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "Voulez-vous vraiment retirer l'objet des offres\u00a0?";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "Réservé aux 13 ans et +.";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "Type";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "Mis à jour";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "Vous obtenez";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "Ajouté à ton profil";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "Ajouté à ton avatar";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "Ton jeu comporte déjà le nombre maximum d'objets!";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "Badge désactivé";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "Badge activé";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "Impossible d'ajouter l'objet au profil";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "Impossible de supprimer l'objet de l'inventaire";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "Impossible de désactiver le badge";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "Impossible d'activer le badge";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "Impossible de retirer l'objet du profil";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "Retiré de ton inventaire";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "Retiré de ton profil";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "Retiré de ton avatar";

	public ItemResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "Ajouter";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "Ajouter au jeu";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "Ajouter au profil";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "Faire la publicité";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "Accepter";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Acheter";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "Configurer";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "Confirmer";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Supprimer";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "Désactiver badge";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "Modifier avatar";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "Activer badge";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Obtenir";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "Installer";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventaire";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "Non";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "Supprimer";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "Retirer du profil";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "Louer";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "Signaler l'objet";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "Vendre";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "Vendre maintenant";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "Retirer";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "Retirer des offres";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "Essayer";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "Améliorer";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "Porter";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "Oui";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "Objets inclus";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "Promouvoir objet";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"Permet aux joueurs d'utiliser cet équipement dans ton jeu et te rapporte {affiliateSaleTotal} lorsqu'il est acheté depuis la page de ton jeu.";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "Permet aux joueurs d'utiliser cet équipement dans ton jeu et te rapporte {affiliateSaleTotal} lorsqu'il est acheté depuis la page de ton jeu.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "OK";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "Notre sponsor vous a offert cet objet.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "Cet objet est désormais en ta possession";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "Caractéristiques";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "Meilleur prix";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Exclusivité du Builders Club.";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"Par {creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "Par {creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"Vente exceptionnelle dans {numberOfDays} d {numberOfHours} h {numberOfMinutes} m";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "Vente exceptionnelle dans {numberOfDays} d {numberOfHours} h {numberOfMinutes} m";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "Voulez-vous vraiment SUPPRIMER cet objet de façon définitive\u00a0?";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "Supprimer l'objet";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "Description";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "Voulez-vous vraiment désactiver ce badge\u00a0?";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "Objet plus disponible, peut être revendu.";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"Obtenez ce badge dans\u00a0: {placeLink}";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "Obtenez ce badge dans\u00a0: {placeLink}";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "Voulez-vous vraiment activer ce badge\u00a0?";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "Une erreur est survenue.";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratuit";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "Genres";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "Seuls les membres du Builders Club peuvent revendre des objets de collection. Rejoignez le Builders Club dès maintenant\u00a0!";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "Seuls les membres premium peuvent revendre des objets de collection. Passez au statut premium dès maintenant\u00a0!";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "Emplacement non valide.";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "Produit non valide.";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "Cet objet se trouve dans ton inventaire.";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "Cet objet n'est pas en vente pour l'instant.";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "Objet possédé";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"Objet possédé ({amount})";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "Objet possédé ({amount})";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"Le prix moyen récent de l'objet {name} est de {price}.";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "Le prix moyen récent de l'objet {name} est de {price}.";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"Frais du marché (à {percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "Frais du marché (à {percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "Aucun";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "s.\u00a0o.";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"Vente exceptionnelle dans {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "Vente exceptionnelle dans {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "Prix";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "Le prix n'est pas valide.";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "Prix (minimum 1)";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "Achat effectué";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "Rareté";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Lire plus";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "Location d'objet";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"Voulez-vous vraiment vendre {name} pour {price}\u00a0?";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "Voulez-vous vraiment vendre {name} pour {price}\u00a0?";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "Vendre ton objet de collection";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "Parution en édition limitée, peut être revendu.";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "Nº de série non disponible";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "Numéro de série";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"Nº de série {number} sur {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "Nº de série {number} sur {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Afficher moins";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "Tags";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "Retirer des offres";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "Voulez-vous vraiment retirer l'objet des offres\u00a0?";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "Réservé aux 13 ans et +.";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "Type";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "Mis à jour";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"(par {link})";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "(par {link})";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"Utilisez ce passe de jeu dans\u00a0: {placeLink}";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "Utilisez ce passe de jeu dans\u00a0: {placeLink}";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "Vous obtenez";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "Ajouté à ton profil";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "Ajouté à ton avatar";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "Ton jeu comporte déjà le nombre maximum d'objets!";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "Badge désactivé";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "Badge activé";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "Impossible d'ajouter l'objet au profil";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "Impossible de supprimer l'objet de l'inventaire";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "Impossible de désactiver le badge";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "Impossible d'activer le badge";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "Impossible de retirer l'objet du profil";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"Ajouté à ton jeu, {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "Ajouté à ton jeu, {placeName}.";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"Vous avez déjà ajouté cet équipement à {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "Vous avez déjà ajouté cet équipement à {placeName}.";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "Retiré de ton inventaire";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "Retiré de ton profil";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "Retiré de ton avatar";
	}
}
