namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_es_es : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "Añadir";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "Añadir al juego";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "Añadir al perfil";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "Publicitar";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "Aceptar";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "Configurar";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "Confirmar";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Eliminar";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "Desactivar emblema";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "Editar avatar";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "Activar emblema";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Obtener";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "Instalar";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventario";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "No";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "Aceptar";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "Eliminar";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "Eliminar del perfil";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "Alquilar";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "Denunciar objeto";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "Vender";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "Vender ahora";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "Quitar";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "Retirar de venta";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "Poner";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "Mejorar";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "Poner";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "Sí";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "Objetos incluidos";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "Promover objeto";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "Aceptar";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "Acabas de obtener este objeto por cortesía de nuestro patrocinador.";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "Ahora este objeto te pertenece.";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "Atributos";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "Mejor precio";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Exclusivo del Builders Club.";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "¿Seguro que quieres ELIMINAR permanentemente este objeto de tu inventario?";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "Eliminar objeto";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "Descripción";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "¿Seguro que quieres desactivar este emblema?";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "Objeto descontinuado. Se puede revender.";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "¿Seguro que quieres activar este emblema?";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "Se ha producido un error";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratis";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "Géneros";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "Solo los miembros del Builders Club pueden revender los objetos coleccionables. ¡Únete al Builders Club ya!";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "Solo los miembros de Premium pueden revender los objetos coleccionables. ¡Obtén Premium ya!";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "Lugar no válido.";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "Producto no válido.";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "Este objeto está disponible en tu inventario.";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "Este objeto no está en venta en este momento.";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "Objeto en posesión";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "Ninguno";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "No disponible";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "Precio";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "El precio no es válido";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "Precio (mínimo 1)";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "Compra finalizada";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "Rareza";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Más detalles";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "Objeto en alquiler";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "Vende tu objeto coleccionable.";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "Edición limitada y serializada. Se puede revender.";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "Número de serie no disponible";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "Número de serie";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Mostrar menos";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "Etiquetas";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "Retirar de venta";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "¿Seguro que quieres retirar el objeto de la venta?";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "Solo 13+";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "Tipo";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "Actualizado";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "Recibes";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "Añadido a tu perfil";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "Añadido a tu avatar";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "Ya tienes la cantidad máxima de objetos en tu juego.";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "Emblema desactivado correctamente";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "Emblema activado correctamente";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "Error al añadir al perfil";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "Error al eliminar el objeto del inventario.";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "Error al desactivar el emblema.";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "Error al activar el emblema.";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "Error al eliminar del perfil";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "Eliminado correctamente de tu inventario.";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "Eliminado de tu perfil";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "Eliminado de tu avatar";

	public ItemResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "Añadir";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "Añadir al juego";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "Añadir al perfil";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "Publicitar";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "Configurar";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "Confirmar";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Eliminar";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "Desactivar emblema";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "Editar avatar";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "Activar emblema";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Obtener";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "Instalar";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventario";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "No";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "Eliminar";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "Eliminar del perfil";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "Alquilar";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "Denunciar objeto";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "Vender";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "Vender ahora";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "Quitar";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "Retirar de venta";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "Poner";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "Mejorar";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "Poner";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "Sí";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "Objetos incluidos";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "Promover objeto";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"Permite a los jugadores usar este equipamiento dentro de tu juego y gana {affiliateSaleTotal} cuando se venda desde la página de tu juego.";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "Permite a los jugadores usar este equipamiento dentro de tu juego y gana {affiliateSaleTotal} cuando se venda desde la página de tu juego.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "Acabas de obtener este objeto por cortesía de nuestro patrocinador.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "Ahora este objeto te pertenece.";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "Atributos";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "Mejor precio";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Exclusivo del Builders Club.";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"De {creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "De {creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"Fuera de venta en {numberOfDays} d {numberOfHours} h {numberOfMinutes} min";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "Fuera de venta en {numberOfDays} d {numberOfHours} h {numberOfMinutes} min";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "¿Seguro que quieres ELIMINAR permanentemente este objeto de tu inventario?";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "Eliminar objeto";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "Descripción";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "¿Seguro que quieres desactivar este emblema?";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "Objeto descontinuado. Se puede revender.";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"Consigue este emblema en: {placeLink}";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "Consigue este emblema en: {placeLink}";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "¿Seguro que quieres activar este emblema?";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "Se ha producido un error";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratis";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "Géneros";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "Solo los miembros del Builders Club pueden revender los objetos coleccionables. ¡Únete al Builders Club ya!";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "Solo los miembros de Premium pueden revender los objetos coleccionables. ¡Obtén Premium ya!";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "Lugar no válido.";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "Producto no válido.";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "Este objeto está disponible en tu inventario.";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "Este objeto no está en venta en este momento.";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "Objeto en posesión";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"Objeto en posesión ({amount})";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "Objeto en posesión ({amount})";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"El precio medio más reciente de {name} es {price}.";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "El precio medio más reciente de {name} es {price}.";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"Tasa de mercado ({percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "Tasa de mercado ({percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "Ninguno";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "No disponible";
	}

	/// <summary>
	/// Key: "Label.OffsaleCountdownHourMinuteSecond"
	/// Item will go offsale in a variable number of hours (h), minutes (m), and seconds (s). Please use a narrow translation if possible for h/m/s.
	/// English String: "Offsale in {numberOfHours} h {numberOfMinutes} m {numberOfSeconds} s"
	/// </summary>
	public override string LabelOffsaleCountdownHourMinuteSecond(string numberOfHours, string numberOfMinutes, string numberOfSeconds)
	{
		return $"Fuera de venta en {numberOfHours} h {numberOfMinutes} min {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelOffsaleCountdownHourMinuteSecond()
	{
		return "Fuera de venta en {numberOfHours} h {numberOfMinutes} min {numberOfSeconds} s";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "Precio";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "El precio no es válido";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "Precio (mínimo 1)";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "Compra finalizada";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "Rareza";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Más detalles";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "Objeto en alquiler";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"¿Seguro que quieres vender {name} por {price}?";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "¿Seguro que quieres vender {name} por {price}?";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "Vende tu objeto coleccionable.";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "Edición limitada y serializada. Se puede revender.";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "Número de serie no disponible";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "Número de serie";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"Número de serie n.º {number} de {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "Número de serie n.º {number} de {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Mostrar menos";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "Etiquetas";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "Retirar de venta";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "¿Seguro que quieres retirar el objeto de la venta?";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "Solo 13+";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "Tipo";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "Actualizado";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"(por {link})";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "(por {link})";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"Utiliza este pase del juego en: {placeLink}";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "Utiliza este pase del juego en: {placeLink}";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "Recibes";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "Añadido a tu perfil";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "Añadido a tu avatar";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "Ya tienes la cantidad máxima de objetos en tu juego.";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "Emblema desactivado correctamente";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "Emblema activado correctamente";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "Error al añadir al perfil";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "Error al eliminar el objeto del inventario.";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "Error al desactivar el emblema.";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "Error al activar el emblema.";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "Error al eliminar del perfil";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"Añadido a tu juego: {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "Añadido a tu juego: {placeName}.";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"Ya has añadido este equipamiento en {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "Ya has añadido este equipamiento en {placeName}.";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "Eliminado correctamente de tu inventario.";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "Eliminado de tu perfil";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "Eliminado de tu avatar";
	}
}
