namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemResources_de_de : ItemResources_en_us, IItemResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Add"
	/// button label
	/// English String: "Add"
	/// </summary>
	public override string ActionAdd => "Hinzufügen";

	/// <summary>
	/// Key: "Action.AddToGame"
	/// English String: "Add To Game"
	/// </summary>
	public override string ActionAddToGame => "Zu Spiel hinzufügen";

	/// <summary>
	/// Key: "Action.AddToProfile"
	/// English String: "Add to Profile"
	/// </summary>
	public override string ActionAddToProfile => "Zu Profil hinzufügen";

	/// <summary>
	/// Key: "Action.Advertise"
	/// English String: "Advertise"
	/// </summary>
	public override string ActionAdvertise => "Anpreisen";

	/// <summary>
	/// Key: "Action.Agree"
	/// button label
	/// English String: "Agree"
	/// </summary>
	public override string ActionAgree => "Akzeptieren";

	/// <summary>
	/// Key: "Action.Buy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Kaufen";

	/// <summary>
	/// Key: "Action.Cancel"
	/// Cancel
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Abbrechen";

	/// <summary>
	/// Key: "Action.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string ActionConfigure => "Konfigurieren";

	/// <summary>
	/// Key: "Action.Confirm"
	/// button label
	/// English String: "Confirm"
	/// </summary>
	public override string ActionConfirm => "Bestätigen";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Löschen";

	/// <summary>
	/// Key: "Action.DisableBadge"
	/// English String: "Disable Badge"
	/// </summary>
	public override string ActionDisableBadge => "Abzeichen deaktivieren";

	/// <summary>
	/// Key: "Action.EditAvatar"
	/// English String: "Edit Avatar"
	/// </summary>
	public override string ActionEditAvatar => "Avatar bearbeiten";

	/// <summary>
	/// Key: "Action.EnableBadge"
	/// English String: "Enable Badge"
	/// </summary>
	public override string ActionEnableBadge => "Abzeichen aktivieren";

	/// <summary>
	/// Key: "Action.Get"
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Holen";

	/// <summary>
	/// Key: "Action.Install"
	/// English String: "Install"
	/// </summary>
	public override string ActionInstall => "Installieren";

	/// <summary>
	/// Key: "Action.Inventory"
	/// English String: "Inventory"
	/// </summary>
	public override string ActionInventory => "Inventar";

	/// <summary>
	/// Key: "Action.No"
	/// button label
	/// English String: "No"
	/// </summary>
	public override string ActionNo => "Nein";

	/// <summary>
	/// Key: "Action.Ok"
	/// button label
	/// English String: "OK"
	/// </summary>
	public override string ActionOk => "Okay";

	/// <summary>
	/// Key: "Action.Remove"
	/// English String: "Remove"
	/// </summary>
	public override string ActionRemove => "Löschen";

	/// <summary>
	/// Key: "Action.RemoveFromProfile"
	/// English String: "Remove from Profile"
	/// </summary>
	public override string ActionRemoveFromProfile => "Von Profil entfernen";

	/// <summary>
	/// Key: "Action.Rent"
	/// English String: "Rent"
	/// </summary>
	public override string ActionRent => "Mieten";

	/// <summary>
	/// Key: "Action.ReportItem"
	/// English String: "Report Item"
	/// </summary>
	public override string ActionReportItem => "Artikel melden";

	/// <summary>
	/// Key: "Action.Sell"
	/// English String: "Sell"
	/// </summary>
	public override string ActionSell => "Verkaufen";

	/// <summary>
	/// Key: "Action.SellNow"
	/// Sell Now
	/// English String: "Sell Now"
	/// </summary>
	public override string ActionSellNow => "Jetzt verkaufen";

	/// <summary>
	/// Key: "Action.TakeOff"
	/// Action on context menu on owned item detail page.
	/// English String: "Take Off"
	/// </summary>
	public override string ActionTakeOff => "Ablegen";

	/// <summary>
	/// Key: "Action.TakeOffSale"
	/// English String: "Take Off Sale"
	/// </summary>
	public override string ActionTakeOffSale => "Aus dem Angebot nehmen";

	/// <summary>
	/// Key: "Action.TryOn"
	/// English String: "Try On"
	/// </summary>
	public override string ActionTryOn => "Anprobieren";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "Aufwerten";

	/// <summary>
	/// Key: "Action.Wear"
	/// Action on context menu on owned item
	/// English String: "Wear"
	/// </summary>
	public override string ActionWear => "Tragen";

	/// <summary>
	/// Key: "Action.Yes"
	/// Yes
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "Ja";

	/// <summary>
	/// Key: "Heading.IncludedItems"
	/// Included items for a bundle of items. User purchases a bundle and will receive all items that will show below this heading.
	/// English String: "Included Items"
	/// </summary>
	public override string HeadingIncludedItems => "Enthaltene Artikel";

	/// <summary>
	/// Key: "Heading.PromoteItem"
	/// dialog heading
	/// English String: "Promote Item"
	/// </summary>
	public override string HeadingPromoteItem => "Werbung für Artikel machen";

	/// <summary>
	/// Key: "Label.AssetGrantedModalAcceptText"
	/// English String: "OK"
	/// </summary>
	public override string LabelAssetGrantedModalAcceptText => "Okay";

	/// <summary>
	/// Key: "Label.AssetGrantedModalMessage"
	/// English String: "You just got this item courtesy of our sponsor."
	/// </summary>
	public override string LabelAssetGrantedModalMessage => "Du hast diesen Artikel gerade über unseren Sponsor erhalten.";

	/// <summary>
	/// Key: "Label.AssetGrantedModalTitle"
	/// English String: "This item is now yours"
	/// </summary>
	public override string LabelAssetGrantedModalTitle => "Dieser Artikel gehört jetzt dir.";

	/// <summary>
	/// Key: "Label.Attributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelAttributes => "Attribute";

	/// <summary>
	/// Key: "Label.BestPrice"
	/// English String: "Best Price"
	/// </summary>
	public override string LabelBestPrice => "Bester Preis";

	/// <summary>
	/// Key: "Label.BuildersClubExclusive"
	/// label for Builders Club requirement
	/// English String: "Builders Club exclusive."
	/// </summary>
	public override string LabelBuildersClubExclusive => "Exklusiv für „Builders Club“-Mitglieder.";

	/// <summary>
	/// Key: "Label.DeleteFromInventoryConfirm"
	/// confirmation message before deletion
	/// English String: "Are you sure you want to permanently DELETE this item from your inventory?"
	/// </summary>
	public override string LabelDeleteFromInventoryConfirm => "Möchtest du diesen Artikel wirklich dauerhaft aus deinem Inventar LÖSCHEN?";

	/// <summary>
	/// Key: "Label.DeleteItem"
	/// Delete Item
	/// English String: "Delete Item"
	/// </summary>
	public override string LabelDeleteItem => "Artikel löschen";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "Beschreibung";

	/// <summary>
	/// Key: "Label.DisableBadgeConfirm"
	/// Are you sure you want to disable this Badge?
	/// English String: "Are you sure you want to disable this Badge?"
	/// </summary>
	public override string LabelDisableBadgeConfirm => "Möchtest du dieses Abzeichen wirklich deaktivieren?";

	/// <summary>
	/// Key: "Label.DiscontinuedItem"
	/// label
	/// English String: "Discontinued item, resellable."
	/// </summary>
	public override string LabelDiscontinuedItem => "Nicht mehr hergestellter Artikel, kann weiterverkauft werden.";

	/// <summary>
	/// Key: "Label.EnableBadgeConfirm"
	/// Are you sure you want to enable this Badge?
	/// English String: "Are you sure you want to enable this Badge?"
	/// </summary>
	public override string LabelEnableBadgeConfirm => "Möchtest du dieses Abzeichen wirklich aktivieren?";

	/// <summary>
	/// Key: "Label.ErrorOccurred"
	/// English String: "Error occurred"
	/// </summary>
	public override string LabelErrorOccurred => "Fehler aufgetreten";

	/// <summary>
	/// Key: "Label.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratis";

	/// <summary>
	/// Key: "Label.Genres"
	/// English String: "Genres"
	/// </summary>
	public override string LabelGenres => "Genres";

	/// <summary>
	/// Key: "Label.GetBuildersClub"
	/// Only Builders Club members can re-sell collectible items. Get Builders Club today!
	/// English String: "Only Builders Club members can re-sell collectible items. Get Builders Club today!"
	/// </summary>
	public override string LabelGetBuildersClub => "Nur „Builders Club“-Mitglieder können Sammlerobjekte weiterverkaufen. Werde noch heute Mitglied im Builders Club!";

	/// <summary>
	/// Key: "Label.GetPremiumMembership"
	/// English String: "Only Premium members can re-sell collectible items. Get Premium today!"
	/// </summary>
	public override string LabelGetPremiumMembership => "Nur Premium-Mitglieder können Sammlerobjekte weiterverkaufen. Werde noch heute Premium-Mitglied!";

	/// <summary>
	/// Key: "Label.InvalidPlace"
	/// text label
	/// English String: "Invalid Place."
	/// </summary>
	public override string LabelInvalidPlace => "Ungültiger Ort.";

	/// <summary>
	/// Key: "Label.InvalidProduct"
	/// label
	/// English String: "Invalid Product."
	/// </summary>
	public override string LabelInvalidProduct => "Ungültiges Produkt.";

	/// <summary>
	/// Key: "Label.ItemAvailable"
	/// User is looking at the details of an item which they already own in their inventory.
	/// English String: "This item is available in your inventory."
	/// </summary>
	public override string LabelItemAvailable => "Dieser Artikel ist in deinem Inventar verfügbar.";

	/// <summary>
	/// Key: "Label.ItemNotForSale"
	/// User is looking at the details of an item that cannot be purchased.
	/// English String: "This item is not currently for sale."
	/// </summary>
	public override string LabelItemNotForSale => "Dieser Artikel steht derzeit nicht zum Verkauf.";

	/// <summary>
	/// Key: "Label.ItemOwned"
	/// English String: "Item Owned"
	/// </summary>
	public override string LabelItemOwned => "Artikel in Besitz";

	/// <summary>
	/// Key: "Label.None"
	/// English String: "None"
	/// </summary>
	public override string LabelNone => "Keine Auswahl";

	/// <summary>
	/// Key: "Label.NotAvailable"
	/// English String: "N/A"
	/// </summary>
	public override string LabelNotAvailable => "Nicht zutreffend";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "Preis";

	/// <summary>
	/// Key: "Label.PriceIsInvalid"
	/// English String: "Price is invalid"
	/// </summary>
	public override string LabelPriceIsInvalid => "Preis ist ungültig";

	/// <summary>
	/// Key: "Label.PriceMinimumOne"
	/// English String: "Price (minimum 1)"
	/// </summary>
	public override string LabelPriceMinimumOne => "Preis (mindestens 1)";

	/// <summary>
	/// Key: "Label.PurchaseCompleted"
	/// English String: "Purchase Completed"
	/// </summary>
	public override string LabelPurchaseCompleted => "Kauf abgeschlossen";

	/// <summary>
	/// Key: "Label.Rarity"
	/// English String: "Rarity"
	/// </summary>
	public override string LabelRarity => "Seltenheit";

	/// <summary>
	/// Key: "Label.ReadMore"
	/// English String: "Read More"
	/// </summary>
	public override string LabelReadMore => "Weiterlesen";

	/// <summary>
	/// Key: "Label.RentingItem"
	/// English String: "Renting Item"
	/// </summary>
	public override string LabelRentingItem => "Artikel gemietet";

	/// <summary>
	/// Key: "Label.Rthro"
	/// "Anthro" but replace the beginning with "R" to be consistent with "R6" and "R16"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.SellYourCollectibleItem"
	/// Sell Your Collectible Item
	/// English String: "Sell Your Collectible Item"
	/// </summary>
	public override string LabelSellYourCollectibleItem => "Verkaufe dein Sammlerobjekt";

	/// <summary>
	/// Key: "Label.SerializedLimitedRelease"
	/// label
	/// English String: "Serialized limited release, resellable."
	/// </summary>
	public override string LabelSerializedLimitedRelease => "Limitierte Edition mit Seriennummer, kann weiterverkauft werden.";

	/// <summary>
	/// Key: "Label.SerialNotAvailable"
	/// English String: "Serial N/A"
	/// </summary>
	public override string LabelSerialNotAvailable => "Seriennummer nicht verfügbar";

	/// <summary>
	/// Key: "Label.SerialNumber"
	/// English String: "Serial Number"
	/// </summary>
	public override string LabelSerialNumber => "Seriennummer";

	/// <summary>
	/// Key: "Label.ShowLess"
	/// Show Less
	/// English String: "Show Less"
	/// </summary>
	public override string LabelShowLess => "Weniger anzeigen";

	/// <summary>
	/// Key: "Label.Tags"
	/// A label to indicate a list of tags on an item (i.e. "red, belt, shoes, denim" could be some tags for a Pants item that was red jeans with a belt and shoes)
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "Tags";

	/// <summary>
	/// Key: "Label.TakeOffSale"
	/// Take off Sale
	/// English String: "Take off Sale"
	/// </summary>
	public override string LabelTakeOffSale => "Aus dem Angebot nehmen";

	/// <summary>
	/// Key: "Label.TakeOffSaleConfirm"
	/// English String: "Are you sure you want to take the item off sale?"
	/// </summary>
	public override string LabelTakeOffSaleConfirm => "Möchtest du den Artikel wirklich aus dem Angebot nehmen?";

	/// <summary>
	/// Key: "Label.ThirteenPlusOnly"
	/// label
	/// English String: "13+ Only."
	/// </summary>
	public override string LabelThirteenPlusOnly => "Nur 13+.";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "Art";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "Aktualisiert";

	/// <summary>
	/// Key: "Label.YouGet"
	/// Amount user gets after Marketplace fee deduction.
	/// English String: "You get"
	/// </summary>
	public override string LabelYouGet => "Du erhältst";

	/// <summary>
	/// Key: "Response.AddedToProfile"
	/// success message when item is added to profile
	/// English String: "Added to your profile"
	/// </summary>
	public override string ResponseAddedToProfile => "Zu deinem Profil hinzugefügt";

	/// <summary>
	/// Key: "Response.AddedToYourAvater"
	/// Added to your Avatar
	/// English String: "Added to your Avatar"
	/// </summary>
	public override string ResponseAddedToYourAvater => "Zu deinem Avatar hinzugefügt";

	/// <summary>
	/// Key: "Response.AlreadyHaveMaxItems"
	/// error message
	/// English String: "You already have the maximum number of items on your game!"
	/// </summary>
	public override string ResponseAlreadyHaveMaxItems => "Du hast bereits die maximale Anzahl an Artikeln in deinem Spiel!";

	/// <summary>
	/// Key: "Response.DisabledBadge"
	/// Successfully disabled the badge
	/// English String: "Successfully disabled the badge"
	/// </summary>
	public override string ResponseDisabledBadge => "Abzeichen erfolgreich deaktiviert";

	/// <summary>
	/// Key: "Response.EnabledBadge"
	/// Successfully enabled the badge
	/// English String: "Successfully enabled the badge"
	/// </summary>
	public override string ResponseEnabledBadge => "Abzeichen erfolgreich aktiviert";

	/// <summary>
	/// Key: "Response.FailedToAddToProfile"
	/// error message when item could not be added to profile
	/// English String: "Failed to add to profile"
	/// </summary>
	public override string ResponseFailedToAddToProfile => "Konnte nicht zum Profil hinzugefügt werden";

	/// <summary>
	/// Key: "Response.FailedToDeleteFromInventory"
	/// Failed to delete item from inventory
	/// English String: "Failed to delete item from inventory"
	/// </summary>
	public override string ResponseFailedToDeleteFromInventory => "Artikel konnte nicht aus deinem Inventar gelöscht werden";

	/// <summary>
	/// Key: "Response.FailedToDisableBadge"
	/// Failed to disable badge
	/// English String: "Failed to disable badge"
	/// </summary>
	public override string ResponseFailedToDisableBadge => "Abzeichen konnte nicht deaktiviert werden";

	/// <summary>
	/// Key: "Response.FailedToEnableBadge"
	/// Failed to enable badge
	/// English String: "Failed to enable badge"
	/// </summary>
	public override string ResponseFailedToEnableBadge => "Abzeichen konnte nicht aktiviert werden";

	/// <summary>
	/// Key: "Response.FailedToRemoveFromProfile"
	/// error message when items could not be removed
	/// English String: "Failed to remove from profile"
	/// </summary>
	public override string ResponseFailedToRemoveFromProfile => "Konnte nicht von Profil entfernt werden";

	/// <summary>
	/// Key: "Response.RemovedFromInventory"
	/// Successfully removed from your inventory
	/// English String: "Successfully removed from your inventory"
	/// </summary>
	public override string ResponseRemovedFromInventory => "Erfolgreich aus deinem Inventar entfernt";

	/// <summary>
	/// Key: "Response.RemovedFromProfile"
	/// message when an item is removed from profile
	/// English String: "Removed from your profile"
	/// </summary>
	public override string ResponseRemovedFromProfile => "Von deinem Profil entfernt";

	/// <summary>
	/// Key: "Response.RemovedFromYourAvater"
	/// Removed from your Avatar
	/// English String: "Removed from your Avatar"
	/// </summary>
	public override string ResponseRemovedFromYourAvater => "Von deinem Avatar entfernt";

	public ItemResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdd()
	{
		return "Hinzufügen";
	}

	protected override string _GetTemplateForActionAddToGame()
	{
		return "Zu Spiel hinzufügen";
	}

	protected override string _GetTemplateForActionAddToProfile()
	{
		return "Zu Profil hinzufügen";
	}

	protected override string _GetTemplateForActionAdvertise()
	{
		return "Anpreisen";
	}

	protected override string _GetTemplateForActionAgree()
	{
		return "Akzeptieren";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Kaufen";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionConfigure()
	{
		return "Konfigurieren";
	}

	protected override string _GetTemplateForActionConfirm()
	{
		return "Bestätigen";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Löschen";
	}

	protected override string _GetTemplateForActionDisableBadge()
	{
		return "Abzeichen deaktivieren";
	}

	protected override string _GetTemplateForActionEditAvatar()
	{
		return "Avatar bearbeiten";
	}

	protected override string _GetTemplateForActionEnableBadge()
	{
		return "Abzeichen aktivieren";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Holen";
	}

	protected override string _GetTemplateForActionInstall()
	{
		return "Installieren";
	}

	protected override string _GetTemplateForActionInventory()
	{
		return "Inventar";
	}

	protected override string _GetTemplateForActionNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionRemove()
	{
		return "Löschen";
	}

	protected override string _GetTemplateForActionRemoveFromProfile()
	{
		return "Von Profil entfernen";
	}

	protected override string _GetTemplateForActionRent()
	{
		return "Mieten";
	}

	protected override string _GetTemplateForActionReportItem()
	{
		return "Artikel melden";
	}

	protected override string _GetTemplateForActionSell()
	{
		return "Verkaufen";
	}

	protected override string _GetTemplateForActionSellNow()
	{
		return "Jetzt verkaufen";
	}

	protected override string _GetTemplateForActionTakeOff()
	{
		return "Ablegen";
	}

	protected override string _GetTemplateForActionTakeOffSale()
	{
		return "Aus dem Angebot nehmen";
	}

	protected override string _GetTemplateForActionTryOn()
	{
		return "Anprobieren";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "Aufwerten";
	}

	protected override string _GetTemplateForActionWear()
	{
		return "Tragen";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "Ja";
	}

	protected override string _GetTemplateForHeadingIncludedItems()
	{
		return "Enthaltene Artikel";
	}

	protected override string _GetTemplateForHeadingPromoteItem()
	{
		return "Werbung für Artikel machen";
	}

	/// <summary>
	/// Key: "Label.AllowPlayersPlusEarn"
	/// English String: "Allow players to use this gear inside your game plus earn {affiliateSaleTotal} when it's purchased from your game page."
	/// </summary>
	public override string LabelAllowPlayersPlusEarn(string affiliateSaleTotal)
	{
		return $"Erlaube es anderen Spielern, diese Ausrüstung in deinem Spiel zu verwenden, und verdiene {affiliateSaleTotal}, wenn sie auf deiner Spielseite gekauft wird.";
	}

	protected override string _GetTemplateForLabelAllowPlayersPlusEarn()
	{
		return "Erlaube es anderen Spielern, diese Ausrüstung in deinem Spiel zu verwenden, und verdiene {affiliateSaleTotal}, wenn sie auf deiner Spielseite gekauft wird.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalAcceptText()
	{
		return "Okay";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalMessage()
	{
		return "Du hast diesen Artikel gerade über unseren Sponsor erhalten.";
	}

	protected override string _GetTemplateForLabelAssetGrantedModalTitle()
	{
		return "Dieser Artikel gehört jetzt dir.";
	}

	protected override string _GetTemplateForLabelAttributes()
	{
		return "Attribute";
	}

	protected override string _GetTemplateForLabelBestPrice()
	{
		return "Bester Preis";
	}

	protected override string _GetTemplateForLabelBuildersClubExclusive()
	{
		return "Exklusiv für „Builders Club“-Mitglieder.";
	}

	/// <summary>
	/// Key: "Label.By"
	/// English String: "By {creator}"
	/// </summary>
	public override string LabelBy(string creator)
	{
		return $"Von {creator}";
	}

	protected override string _GetTemplateForLabelBy()
	{
		return "Von {creator}";
	}

	/// <summary>
	/// Key: "Label.CountdownTimerDayHourMinute"
	/// Item will go offsale in a variable number of days (d), hours (h), and minutes (m). Please use a narrow translation if possible for d/h/m.
	/// English String: "Offsale in {numberOfDays} d {numberOfHours} h {numberOfMinutes} m"
	/// </summary>
	public override string LabelCountdownTimerDayHourMinute(string numberOfDays, string numberOfHours, string numberOfMinutes)
	{
		return $"Nicht mehr im Angebot in {numberOfDays} Tagen {numberOfHours} Std. {numberOfMinutes} Min.";
	}

	protected override string _GetTemplateForLabelCountdownTimerDayHourMinute()
	{
		return "Nicht mehr im Angebot in {numberOfDays} Tagen {numberOfHours} Std. {numberOfMinutes} Min.";
	}

	protected override string _GetTemplateForLabelDeleteFromInventoryConfirm()
	{
		return "Möchtest du diesen Artikel wirklich dauerhaft aus deinem Inventar LÖSCHEN?";
	}

	protected override string _GetTemplateForLabelDeleteItem()
	{
		return "Artikel löschen";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "Beschreibung";
	}

	protected override string _GetTemplateForLabelDisableBadgeConfirm()
	{
		return "Möchtest du dieses Abzeichen wirklich deaktivieren?";
	}

	protected override string _GetTemplateForLabelDiscontinuedItem()
	{
		return "Nicht mehr hergestellter Artikel, kann weiterverkauft werden.";
	}

	/// <summary>
	/// Key: "Label.EarnBadgeGameLink"
	/// placeLink will carry the game name, which is not localized at the moment.
	/// English String: "Earn this Badge in: {placeLink}"
	/// </summary>
	public override string LabelEarnBadgeGameLink(string placeLink)
	{
		return $"Verdiene dieses Abzeichen hier: {placeLink}";
	}

	protected override string _GetTemplateForLabelEarnBadgeGameLink()
	{
		return "Verdiene dieses Abzeichen hier: {placeLink}";
	}

	protected override string _GetTemplateForLabelEnableBadgeConfirm()
	{
		return "Möchtest du dieses Abzeichen wirklich aktivieren?";
	}

	protected override string _GetTemplateForLabelErrorOccurred()
	{
		return "Fehler aufgetreten";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratis";
	}

	protected override string _GetTemplateForLabelGenres()
	{
		return "Genres";
	}

	protected override string _GetTemplateForLabelGetBuildersClub()
	{
		return "Nur „Builders Club“-Mitglieder können Sammlerobjekte weiterverkaufen. Werde noch heute Mitglied im Builders Club!";
	}

	protected override string _GetTemplateForLabelGetPremiumMembership()
	{
		return "Nur Premium-Mitglieder können Sammlerobjekte weiterverkaufen. Werde noch heute Premium-Mitglied!";
	}

	protected override string _GetTemplateForLabelInvalidPlace()
	{
		return "Ungültiger Ort.";
	}

	protected override string _GetTemplateForLabelInvalidProduct()
	{
		return "Ungültiges Produkt.";
	}

	protected override string _GetTemplateForLabelItemAvailable()
	{
		return "Dieser Artikel ist in deinem Inventar verfügbar.";
	}

	protected override string _GetTemplateForLabelItemNotForSale()
	{
		return "Dieser Artikel steht derzeit nicht zum Verkauf.";
	}

	protected override string _GetTemplateForLabelItemOwned()
	{
		return "Artikel in Besitz";
	}

	/// <summary>
	/// Key: "Label.ItemOwnedAmount"
	/// English String: "Item Owned ({amount})"
	/// </summary>
	public override string LabelItemOwnedAmount(string amount)
	{
		return $"Artikel in Besitz ({amount})";
	}

	protected override string _GetTemplateForLabelItemOwnedAmount()
	{
		return "Artikel in Besitz ({amount})";
	}

	/// <summary>
	/// Key: "Label.ItemRecentPrice"
	/// English String: "{name}'s recent average price is {price}."
	/// </summary>
	public override string LabelItemRecentPrice(string name, string price)
	{
		return $"Der aktuelle Durchschnittspreis von „{name}“ beträgt {price}.";
	}

	protected override string _GetTemplateForLabelItemRecentPrice()
	{
		return "Der aktuelle Durchschnittspreis von „{name}“ beträgt {price}.";
	}

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// Marketplace fee amount
	/// English String: "Marketplace fee (at {percent}%)"
	/// </summary>
	public override string LabelMarketplaceFee(string percent)
	{
		return $"Marktplatzgebühr (zu {percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "Marktplatzgebühr (zu {percent}\u00a0%)";
	}

	protected override string _GetTemplateForLabelNone()
	{
		return "Keine Auswahl";
	}

	protected override string _GetTemplateForLabelNotAvailable()
	{
		return "Nicht zutreffend";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "Preis";
	}

	protected override string _GetTemplateForLabelPriceIsInvalid()
	{
		return "Preis ist ungültig";
	}

	protected override string _GetTemplateForLabelPriceMinimumOne()
	{
		return "Preis (mindestens 1)";
	}

	protected override string _GetTemplateForLabelPurchaseCompleted()
	{
		return "Kauf abgeschlossen";
	}

	protected override string _GetTemplateForLabelRarity()
	{
		return "Seltenheit";
	}

	protected override string _GetTemplateForLabelReadMore()
	{
		return "Weiterlesen";
	}

	protected override string _GetTemplateForLabelRentingItem()
	{
		return "Artikel gemietet";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	/// <summary>
	/// Key: "Label.SellConfirm"
	/// English String: "Are you sure you want to sell {name} for {price}?"
	/// </summary>
	public override string LabelSellConfirm(string name, string price)
	{
		return $"Möchtest du „{name}“ wirklich für {price} verkaufen?";
	}

	protected override string _GetTemplateForLabelSellConfirm()
	{
		return "Möchtest du „{name}“ wirklich für {price} verkaufen?";
	}

	protected override string _GetTemplateForLabelSellYourCollectibleItem()
	{
		return "Verkaufe dein Sammlerobjekt";
	}

	protected override string _GetTemplateForLabelSerializedLimitedRelease()
	{
		return "Limitierte Edition mit Seriennummer, kann weiterverkauft werden.";
	}

	protected override string _GetTemplateForLabelSerialNotAvailable()
	{
		return "Seriennummer nicht verfügbar";
	}

	protected override string _GetTemplateForLabelSerialNumber()
	{
		return "Seriennummer";
	}

	/// <summary>
	/// Key: "Label.SerialNumberOfTotal"
	/// English String: "Serial #{number} of {total}"
	/// </summary>
	public override string LabelSerialNumberOfTotal(string number, string total)
	{
		return $"Seriennummer {number} von {total}";
	}

	protected override string _GetTemplateForLabelSerialNumberOfTotal()
	{
		return "Seriennummer {number} von {total}";
	}

	protected override string _GetTemplateForLabelShowLess()
	{
		return "Weniger anzeigen";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "Tags";
	}

	protected override string _GetTemplateForLabelTakeOffSale()
	{
		return "Aus dem Angebot nehmen";
	}

	protected override string _GetTemplateForLabelTakeOffSaleConfirm()
	{
		return "Möchtest du den Artikel wirklich aus dem Angebot nehmen?";
	}

	protected override string _GetTemplateForLabelThirteenPlusOnly()
	{
		return "Nur 13+.";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "Art";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "Aktualisiert";
	}

	/// <summary>
	/// Key: "Label.UpdatedBy"
	/// English String: "(by {link})"
	/// </summary>
	public override string LabelUpdatedBy(string link)
	{
		return $"(von {link})";
	}

	protected override string _GetTemplateForLabelUpdatedBy()
	{
		return "(von {link})";
	}

	/// <summary>
	/// Key: "Label.UseGamePassLink"
	/// placeLink will carry game name which does not need to be localized
	/// English String: "Use this Game Pass in: {placeLink}"
	/// </summary>
	public override string LabelUseGamePassLink(string placeLink)
	{
		return $"Verwende diesen Spielpass hier: {placeLink}";
	}

	protected override string _GetTemplateForLabelUseGamePassLink()
	{
		return "Verwende diesen Spielpass hier: {placeLink}";
	}

	protected override string _GetTemplateForLabelYouGet()
	{
		return "Du erhältst";
	}

	protected override string _GetTemplateForResponseAddedToProfile()
	{
		return "Zu deinem Profil hinzugefügt";
	}

	protected override string _GetTemplateForResponseAddedToYourAvater()
	{
		return "Zu deinem Avatar hinzugefügt";
	}

	protected override string _GetTemplateForResponseAlreadyHaveMaxItems()
	{
		return "Du hast bereits die maximale Anzahl an Artikeln in deinem Spiel!";
	}

	protected override string _GetTemplateForResponseDisabledBadge()
	{
		return "Abzeichen erfolgreich deaktiviert";
	}

	protected override string _GetTemplateForResponseEnabledBadge()
	{
		return "Abzeichen erfolgreich aktiviert";
	}

	protected override string _GetTemplateForResponseFailedToAddToProfile()
	{
		return "Konnte nicht zum Profil hinzugefügt werden";
	}

	protected override string _GetTemplateForResponseFailedToDeleteFromInventory()
	{
		return "Artikel konnte nicht aus deinem Inventar gelöscht werden";
	}

	protected override string _GetTemplateForResponseFailedToDisableBadge()
	{
		return "Abzeichen konnte nicht deaktiviert werden";
	}

	protected override string _GetTemplateForResponseFailedToEnableBadge()
	{
		return "Abzeichen konnte nicht aktiviert werden";
	}

	protected override string _GetTemplateForResponseFailedToRemoveFromProfile()
	{
		return "Konnte nicht von Profil entfernt werden";
	}

	/// <summary>
	/// Key: "Response.GearAddSuccess"
	/// success message
	/// English String: "Added to your game, {placeName}."
	/// </summary>
	public override string ResponseGearAddSuccess(string placeName)
	{
		return $"Zu deinem Spiel ({placeName}) hinzugefügt.";
	}

	protected override string _GetTemplateForResponseGearAddSuccess()
	{
		return "Zu deinem Spiel ({placeName}) hinzugefügt.";
	}

	/// <summary>
	/// Key: "Response.GearAlreadyAdded"
	/// error message
	/// English String: "You have already added this gear to {placeName}."
	/// </summary>
	public override string ResponseGearAlreadyAdded(string placeName)
	{
		return $"Du hast diese Ausrüstung bereits hierzu hinzugefügt: {placeName}.";
	}

	protected override string _GetTemplateForResponseGearAlreadyAdded()
	{
		return "Du hast diese Ausrüstung bereits hierzu hinzugefügt: {placeName}.";
	}

	protected override string _GetTemplateForResponseRemovedFromInventory()
	{
		return "Erfolgreich aus deinem Inventar entfernt";
	}

	protected override string _GetTemplateForResponseRemovedFromProfile()
	{
		return "Von deinem Profil entfernt";
	}

	protected override string _GetTemplateForResponseRemovedFromYourAvater()
	{
		return "Von deinem Avatar entfernt";
	}
}
