namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides ItemConfigurationResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class ItemConfigurationResources_pt_br : ItemConfigurationResources_en_us, IItemConfigurationResources, ITranslationResources
{
	/// <summary>
	/// Key: "Description.AllowCopying"
	/// English String: "By switching on, you are granting every other user of Roblox the right to use (in various ways) the content you are now sharing. If you do not want to grant this right, please do not check this box. For more information about sharing content, please review the Roblox Terms of Use."
	/// </summary>
	public override string DescriptionAllowCopying => "Ao habilitar, você está permitindo que outros usuários do Roblox utilizem (de várias maneiras) o conteúdo que você está compartilhando. Se você não quiser conceder este direito, não marque esta caixa de seleção. Para mais informações sobre o compartilhamento de conteúdo, consulte os Termos de Uso do Roblox.";

	/// <summary>
	/// Key: "Description.ArchiveWarning"
	/// English String: "Archiving this asset will prevent it from being used in game. Archived assets can be restored."
	/// </summary>
	public override string DescriptionArchiveWarning => "Arquivar este elemento impedirá que ele seja usado no jogo. Elementos arquivados podem ser restaurados.";

	/// <summary>
	/// Key: "Description.ClickToAddTag"
	/// Hover text on the button that adds a tag to an item
	/// English String: "Click to add tag"
	/// </summary>
	public override string DescriptionClickToAddTag => "Clique para adicionar rótulo";

	/// <summary>
	/// Key: "Description.ModeratorFileReview"
	/// English String: "* Uploaded file will be reviewed by moderators before being made visible to other users"
	/// </summary>
	public override string DescriptionModeratorFileReview => "* O arquivo transferido será revisado por moderadores antes de poder ser visto por outros usuários";

	/// <summary>
	/// Key: "Description.ModeratorReview"
	/// English String: "* Uploaded image will be reviewed by moderators before being made visible to other users"
	/// </summary>
	public override string DescriptionModeratorReview => "* A imagem transferida será revisada por moderadores antes de poder ser vista por outros usuários";

	/// <summary>
	/// Key: "Heading.Archive"
	/// header text for section about archiving assets
	/// English String: "Archive"
	/// </summary>
	public override string HeadingArchive => "Arquivar";

	/// <summary>
	/// Key: "Heading.Configure"
	/// English String: "Configure"
	/// </summary>
	public override string HeadingConfigure => "Configurar";

	/// <summary>
	/// Key: "Heading.ConfigureItemTags"
	/// Heading on Configure Tags modal
	/// English String: "Configure Tags"
	/// </summary>
	public override string HeadingConfigureItemTags => "Configurar rótulos";

	/// <summary>
	/// Key: "Heading.Create"
	/// English String: "Create"
	/// </summary>
	public override string HeadingCreate => "Criar";

	/// <summary>
	/// Key: "Heading.Settings"
	/// English String: "Settings"
	/// </summary>
	public override string HeadingSettings => "Configurações";

	/// <summary>
	/// Key: "Label.AllowCopying"
	/// English String: "Allow Copying"
	/// </summary>
	public override string LabelAllowCopying => "Permitir cópia";

	/// <summary>
	/// Key: "Label.Archive"
	/// Text on button for archiving an asset. Part of speech: verb
	/// English String: "Archive"
	/// </summary>
	public override string LabelArchive => "Arquivar";

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancel => "Cancelar";

	/// <summary>
	/// Key: "Label.Computer"
	/// computer term
	/// English String: "Computer"
	/// </summary>
	public override string LabelComputer => "Computador";

	/// <summary>
	/// Key: "Label.Created"
	/// English String: "Created"
	/// </summary>
	public override string LabelCreated => "Criado";

	/// <summary>
	/// Key: "Label.Current"
	/// English String: "Current"
	/// </summary>
	public override string LabelCurrent => "Atual";

	/// <summary>
	/// Key: "Label.CurrentPublishedVersion"
	/// English String: "Current published version"
	/// </summary>
	public override string LabelCurrentPublishedVersion => "Versão publicada atual";

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	public override string LabelDescription => "Descrição";

	/// <summary>
	/// Key: "Label.Device"
	/// device term
	/// English String: "Device"
	/// </summary>
	public override string LabelDevice => "Dispositivo";

	/// <summary>
	/// Key: "Label.EnterItemTag"
	/// Placeholder for input field
	/// English String: "Enter tag here..."
	/// </summary>
	public override string LabelEnterItemTag => "Insira o rótulo aqui...";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "Jogo";

	/// <summary>
	/// Key: "Label.GamePass"
	/// label
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "Passe de jogo";

	/// <summary>
	/// Key: "Label.General"
	/// English String: "General"
	/// </summary>
	public override string LabelGeneral => "Geral";

	/// <summary>
	/// Key: "Label.GoToDetails"
	/// Link to the item details page from the configure page
	/// English String: "Go to Details"
	/// </summary>
	public override string LabelGoToDetails => "Ir para Detalhes";

	/// <summary>
	/// Key: "Label.ItemActive"
	/// English String: "Item is Active"
	/// </summary>
	public override string LabelItemActive => "Item ativo";

	/// <summary>
	/// Key: "Label.ItemForSale"
	/// English String: "Item for Sale"
	/// </summary>
	public override string LabelItemForSale => "Item à venda";

	/// <summary>
	/// Key: "Label.LastUpdated"
	/// English String: "Last Updated"
	/// </summary>
	public override string LabelLastUpdated => "Última atualização";

	/// <summary>
	/// Key: "Label.LearnMore"
	/// English String: "Learn more"
	/// </summary>
	public override string LabelLearnMore => "Saiba mais";

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// English String: "Marketplace Fee"
	/// </summary>
	public override string LabelMarketplaceFee => "Taxa de mercado";

	/// <summary>
	/// Key: "Label.Name"
	/// English String: "Name"
	/// </summary>
	public override string LabelName => "Nome";

	/// <summary>
	/// Key: "Label.OpenForComments"
	/// English String: "Open for Comments"
	/// </summary>
	public override string LabelOpenForComments => "Abrir para comentários";

	/// <summary>
	/// Key: "Label.Preview"
	/// English String: "Preview"
	/// </summary>
	public override string LabelPreview => "Prévia";

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelPrice => "Preço";

	/// <summary>
	/// Key: "Label.Profit"
	/// English String: "You Earn"
	/// </summary>
	public override string LabelProfit => "Você ganha";

	/// <summary>
	/// Key: "Label.Restore"
	/// English String: "Restore"
	/// </summary>
	public override string LabelRestore => "Restaurar";

	/// <summary>
	/// Key: "Label.RevertVersion"
	/// English String: "Revert to this version"
	/// </summary>
	public override string LabelRevertVersion => "Reverter para esta versão";

	/// <summary>
	/// Key: "Label.Sales"
	/// English String: "Sales"
	/// </summary>
	public override string LabelSales => "Promoções";

	/// <summary>
	/// Key: "Label.Save"
	/// English String: "Save"
	/// </summary>
	public override string LabelSave => "Salvar";

	/// <summary>
	/// Key: "Label.SelectType"
	/// Placeholder for dropdown in create asset page. Options are image, mesh, hair accessory, etc
	/// English String: "Select a type"
	/// </summary>
	public override string LabelSelectType => "Selecione um tipo";

	/// <summary>
	/// Key: "Label.Tags"
	/// The label next to a list of item tags in the item configuration page
	/// English String: "Tags"
	/// </summary>
	public override string LabelTags => "Rótulos";

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	public override string LabelType => "Tipo";

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	public override string LabelUpdated => "Atualizado";

	/// <summary>
	/// Key: "Label.Version"
	/// English String: "Version"
	/// </summary>
	public override string LabelVersion => "Versão";

	/// <summary>
	/// Key: "Label.Versions"
	/// English String: "Versions"
	/// </summary>
	public override string LabelVersions => "Versões";

	/// <summary>
	/// Key: "Message.ArchiveError"
	/// English String: "Failed to archive"
	/// </summary>
	public override string MessageArchiveError => "Falha ao arquivar";

	/// <summary>
	/// Key: "Message.ArchiveSuccess"
	/// English String: "Successfully archived"
	/// </summary>
	public override string MessageArchiveSuccess => "Arquivado com sucesso";

	/// <summary>
	/// Key: "Message.DescriptionFieldEmptyError"
	/// English String: "Description cannot be empty"
	/// </summary>
	public override string MessageDescriptionFieldEmptyError => "A descrição não pode ficar vazia.";

	/// <summary>
	/// Key: "Message.DescriptionTooLongError"
	/// error message
	/// English String: "The description is too long."
	/// </summary>
	public override string MessageDescriptionTooLongError => "A descrição é longa demais.";

	/// <summary>
	/// Key: "Message.FilteringServiceUnavailableError"
	/// error message
	/// English String: "Text filtering service is unavailable at this time."
	/// </summary>
	public override string MessageFilteringServiceUnavailableError => "O serviço de filtro de texto não está disponível no momento.";

	/// <summary>
	/// Key: "Message.GamePassConfigDisabledError"
	/// error message
	/// English String: "Game Pass configuration is not enabled yet."
	/// </summary>
	public override string MessageGamePassConfigDisabledError => "A configuração do Passe de Jogo não está habilitada ainda.";

	/// <summary>
	/// Key: "Message.GamePassNotFoundError"
	/// errormessage
	/// English String: "The Game Pass does not exist."
	/// </summary>
	public override string MessageGamePassNotFoundError => "O Passe de Jogo não existe.";

	/// <summary>
	/// Key: "Message.IconUpdateFailed"
	/// error message
	/// English String: "Failed to update icon."
	/// </summary>
	public override string MessageIconUpdateFailed => "Falha ao atualizar o ícone.";

	/// <summary>
	/// Key: "Message.ImageSavingFailedError"
	/// error message
	/// English String: "Failed to save image. Please try again later."
	/// </summary>
	public override string MessageImageSavingFailedError => "Falha ao salvar imagem. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Message.InappropriateTextError"
	/// error message
	/// English String: "The name or description contains inappropriate text."
	/// </summary>
	public override string MessageInappropriateTextError => "O nome ou descrição contém texto inapropriado.";

	/// <summary>
	/// Key: "Message.NameFieldEmpty"
	/// English String: "Name cannot be empty"
	/// </summary>
	public override string MessageNameFieldEmpty => "O nome não pode ficar vazio";

	/// <summary>
	/// Key: "Message.NameRequiredError"
	/// error message
	/// English String: "The name cannot be empty."
	/// </summary>
	public override string MessageNameRequiredError => "O nome não pode ficar vazio.";

	/// <summary>
	/// Key: "Message.NoTagsFound"
	/// English String: "No tags found"
	/// </summary>
	public override string MessageNoTagsFound => "Nenhum rótulo encontrado";

	/// <summary>
	/// Key: "Message.RestoreError"
	/// English String: "Failed to restore"
	/// </summary>
	public override string MessageRestoreError => "Falha ao restaurar";

	/// <summary>
	/// Key: "Message.RestoreSuccess"
	/// English String: "Successfully restored"
	/// </summary>
	public override string MessageRestoreSuccess => "Restaurado com sucesso";

	/// <summary>
	/// Key: "Message.SaveError"
	/// English String: "Something failed. Please try again later"
	/// </summary>
	public override string MessageSaveError => "Algo deu errado. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Message.TooManyUploads"
	/// error message
	/// English String: "You are uploading too much. Please try again later."
	/// </summary>
	public override string MessageTooManyUploads => "Você está transferindo muitos arquivos. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.UpdatePriceError"
	/// English String: "Failed to update price"
	/// </summary>
	public override string MessageUpdatePriceError => "Falha ao atualizar o preço";

	/// <summary>
	/// Key: "Message.UpdatePriceSuccess"
	/// English String: "Successfully updated price"
	/// </summary>
	public override string MessageUpdatePriceSuccess => "Preço atualizado com sucesso";

	/// <summary>
	/// Key: "Message.UpdateSuccess"
	/// English String: "Successfully updated"
	/// </summary>
	public override string MessageUpdateSuccess => "Atualizado com sucesso";

	public ItemConfigurationResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	/// <summary>
	/// Key: "Description.AcceptableFileFormats"
	/// English String: "* Acceptable file formats: {fileExtensions}"
	/// </summary>
	public override string DescriptionAcceptableFileFormats(string fileExtensions)
	{
		return $"* Formatos de arquivo aceitos: {fileExtensions}";
	}

	protected override string _GetTemplateForDescriptionAcceptableFileFormats()
	{
		return "* Formatos de arquivo aceitos: {fileExtensions}";
	}

	/// <summary>
	/// Key: "Description.AcceptableFiles"
	/// English String: "* Acceptable files{lineBreak}Format: {fileExtensions}   |   Size: {fileSizes}"
	/// </summary>
	public override string DescriptionAcceptableFiles(string lineBreak, string fileExtensions, string fileSizes)
	{
		return $"* Arquivos aceitos{lineBreak}Formato: {fileExtensions}   |   Tamanho: {fileSizes}";
	}

	protected override string _GetTemplateForDescriptionAcceptableFiles()
	{
		return "* Arquivos aceitos{lineBreak}Formato: {fileExtensions}   |   Tamanho: {fileSizes}";
	}

	protected override string _GetTemplateForDescriptionAllowCopying()
	{
		return "Ao habilitar, você está permitindo que outros usuários do Roblox utilizem (de várias maneiras) o conteúdo que você está compartilhando. Se você não quiser conceder este direito, não marque esta caixa de seleção. Para mais informações sobre o compartilhamento de conteúdo, consulte os Termos de Uso do Roblox.";
	}

	/// <summary>
	/// Key: "Description.AllowCopyingWarning"
	/// English String: "By switching on, you are granting every other user of Roblox the right to use (in various ways) the content you are now sharing. If you do not want to grant this right, please do not check this box. For more information about sharing content, please review the Roblox {linkStart}Terms of Use{linkEnd}."
	/// </summary>
	public override string DescriptionAllowCopyingWarning(string linkStart, string linkEnd)
	{
		return $"Ao habilitar, você está permitindo que outros usuários do Roblox utilizem (de várias maneiras) o conteúdo que você está compartilhando. Se você não quiser conceder este direito, não marque esta caixa de seleção. Para mais informações sobre o compartilhamento de conteúdo, consulte os {linkStart}Termos de Uso{linkEnd} do Roblox.";
	}

	protected override string _GetTemplateForDescriptionAllowCopyingWarning()
	{
		return "Ao habilitar, você está permitindo que outros usuários do Roblox utilizem (de várias maneiras) o conteúdo que você está compartilhando. Se você não quiser conceder este direito, não marque esta caixa de seleção. Para mais informações sobre o compartilhamento de conteúdo, consulte os {linkStart}Termos de Uso{linkEnd} do Roblox.";
	}

	protected override string _GetTemplateForDescriptionArchiveWarning()
	{
		return "Arquivar este elemento impedirá que ele seja usado no jogo. Elementos arquivados podem ser restaurados.";
	}

	protected override string _GetTemplateForDescriptionClickToAddTag()
	{
		return "Clique para adicionar rótulo";
	}

	/// <summary>
	/// Key: "Description.MarketplaceExplanation"
	/// English String: "(Roblox takes {marketplaceFeePercentage}%, minimum {minimumPrice})"
	/// </summary>
	public override string DescriptionMarketplaceExplanation(string marketplaceFeePercentage, string minimumPrice)
	{
		return $"(Roblox leva {marketplaceFeePercentage}%, mínimo {minimumPrice})";
	}

	protected override string _GetTemplateForDescriptionMarketplaceExplanation()
	{
		return "(Roblox leva {marketplaceFeePercentage}%, mínimo {minimumPrice})";
	}

	protected override string _GetTemplateForDescriptionModeratorFileReview()
	{
		return "* O arquivo transferido será revisado por moderadores antes de poder ser visto por outros usuários";
	}

	protected override string _GetTemplateForDescriptionModeratorReview()
	{
		return "* A imagem transferida será revisada por moderadores antes de poder ser vista por outros usuários";
	}

	/// <summary>
	/// Key: "Description.SelectItemTags"
	/// itemTagLimit is the number of item tags allowed
	/// English String: "Select up to {itemTagLimit} tags."
	/// </summary>
	public override string DescriptionSelectItemTags(string itemTagLimit)
	{
		return $"Selecione até {itemTagLimit} rótulos.";
	}

	protected override string _GetTemplateForDescriptionSelectItemTags()
	{
		return "Selecione até {itemTagLimit} rótulos.";
	}

	public override string DescriptionVerifiedCreatorEmail(string linkStart, string linkEnd)
	{
		return $"Para poder compartilhar conteúdo no Mercado, você precisa adicionar um endereço de e-mail à sua conta e verificá-lo. Isto pode ser feito nas {linkStart}Configurações de conta{linkEnd}.";
	}

	protected override string _GetTemplateForDescriptionVerifiedCreatorEmail()
	{
		return "Para poder compartilhar conteúdo no Mercado, você precisa adicionar um endereço de e-mail à sua conta e verificá-lo. Isto pode ser feito nas {linkStart}Configurações de conta{linkEnd}.";
	}

	protected override string _GetTemplateForHeadingArchive()
	{
		return "Arquivar";
	}

	protected override string _GetTemplateForHeadingConfigure()
	{
		return "Configurar";
	}

	/// <summary>
	/// Key: "Heading.ConfigureItem"
	/// English String: "Configure {itemType}"
	/// </summary>
	public override string HeadingConfigureItem(string itemType)
	{
		return $"Configurar {itemType}";
	}

	protected override string _GetTemplateForHeadingConfigureItem()
	{
		return "Configurar {itemType}";
	}

	protected override string _GetTemplateForHeadingConfigureItemTags()
	{
		return "Configurar rótulos";
	}

	protected override string _GetTemplateForHeadingCreate()
	{
		return "Criar";
	}

	protected override string _GetTemplateForHeadingSettings()
	{
		return "Configurações";
	}

	protected override string _GetTemplateForLabelAllowCopying()
	{
		return "Permitir cópia";
	}

	protected override string _GetTemplateForLabelArchive()
	{
		return "Arquivar";
	}

	protected override string _GetTemplateForLabelCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForLabelComputer()
	{
		return "Computador";
	}

	protected override string _GetTemplateForLabelCreated()
	{
		return "Criado";
	}

	protected override string _GetTemplateForLabelCurrent()
	{
		return "Atual";
	}

	protected override string _GetTemplateForLabelCurrentPublishedVersion()
	{
		return "Versão publicada atual";
	}

	protected override string _GetTemplateForLabelDescription()
	{
		return "Descrição";
	}

	protected override string _GetTemplateForLabelDevice()
	{
		return "Dispositivo";
	}

	protected override string _GetTemplateForLabelEnterItemTag()
	{
		return "Insira o rótulo aqui...";
	}

	/// <summary>
	/// Key: "Label.ForItem"
	/// English String: "For {itemType}"
	/// </summary>
	public override string LabelForItem(string itemType)
	{
		return $"Por {itemType}";
	}

	protected override string _GetTemplateForLabelForItem()
	{
		return "Por {itemType}";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "Jogo";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "Passe de jogo";
	}

	protected override string _GetTemplateForLabelGeneral()
	{
		return "Geral";
	}

	protected override string _GetTemplateForLabelGoToDetails()
	{
		return "Ir para Detalhes";
	}

	protected override string _GetTemplateForLabelItemActive()
	{
		return "Item ativo";
	}

	protected override string _GetTemplateForLabelItemForSale()
	{
		return "Item à venda";
	}

	protected override string _GetTemplateForLabelLastUpdated()
	{
		return "Última atualização";
	}

	protected override string _GetTemplateForLabelLearnMore()
	{
		return "Saiba mais";
	}

	protected override string _GetTemplateForLabelMarketplaceFee()
	{
		return "Taxa de mercado";
	}

	protected override string _GetTemplateForLabelName()
	{
		return "Nome";
	}

	protected override string _GetTemplateForLabelOpenForComments()
	{
		return "Abrir para comentários";
	}

	protected override string _GetTemplateForLabelPreview()
	{
		return "Prévia";
	}

	protected override string _GetTemplateForLabelPrice()
	{
		return "Preço";
	}

	protected override string _GetTemplateForLabelProfit()
	{
		return "Você ganha";
	}

	protected override string _GetTemplateForLabelRestore()
	{
		return "Restaurar";
	}

	protected override string _GetTemplateForLabelRevertVersion()
	{
		return "Reverter para esta versão";
	}

	protected override string _GetTemplateForLabelSales()
	{
		return "Promoções";
	}

	protected override string _GetTemplateForLabelSave()
	{
		return "Salvar";
	}

	protected override string _GetTemplateForLabelSelectType()
	{
		return "Selecione um tipo";
	}

	protected override string _GetTemplateForLabelTags()
	{
		return "Rótulos";
	}

	protected override string _GetTemplateForLabelType()
	{
		return "Tipo";
	}

	protected override string _GetTemplateForLabelUpdated()
	{
		return "Atualizado";
	}

	protected override string _GetTemplateForLabelVersion()
	{
		return "Versão";
	}

	protected override string _GetTemplateForLabelVersions()
	{
		return "Versões";
	}

	protected override string _GetTemplateForMessageArchiveError()
	{
		return "Falha ao arquivar";
	}

	protected override string _GetTemplateForMessageArchiveSuccess()
	{
		return "Arquivado com sucesso";
	}

	/// <summary>
	/// Key: "Message.DescriptionFieldEmpty"
	/// English String: "{maxDescriptionLength} character limit"
	/// </summary>
	public override string MessageDescriptionFieldEmpty(string maxDescriptionLength)
	{
		return $"Limite de caracteres de {maxDescriptionLength}";
	}

	protected override string _GetTemplateForMessageDescriptionFieldEmpty()
	{
		return "Limite de caracteres de {maxDescriptionLength}";
	}

	protected override string _GetTemplateForMessageDescriptionFieldEmptyError()
	{
		return "A descrição não pode ficar vazia.";
	}

	/// <summary>
	/// Key: "Message.DescriptionFieldPopulated"
	/// English String: "{descriptionLength}/{maxDescriptionLength} characters"
	/// </summary>
	public override string MessageDescriptionFieldPopulated(string descriptionLength, string maxDescriptionLength)
	{
		return $"{descriptionLength}/{maxDescriptionLength} caracteres";
	}

	protected override string _GetTemplateForMessageDescriptionFieldPopulated()
	{
		return "{descriptionLength}/{maxDescriptionLength} caracteres";
	}

	protected override string _GetTemplateForMessageDescriptionTooLongError()
	{
		return "A descrição é longa demais.";
	}

	protected override string _GetTemplateForMessageFilteringServiceUnavailableError()
	{
		return "O serviço de filtro de texto não está disponível no momento.";
	}

	protected override string _GetTemplateForMessageGamePassConfigDisabledError()
	{
		return "A configuração do Passe de Jogo não está habilitada ainda.";
	}

	protected override string _GetTemplateForMessageGamePassNotFoundError()
	{
		return "O Passe de Jogo não existe.";
	}

	protected override string _GetTemplateForMessageIconUpdateFailed()
	{
		return "Falha ao atualizar o ícone.";
	}

	protected override string _GetTemplateForMessageImageSavingFailedError()
	{
		return "Falha ao salvar imagem. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForMessageInappropriateTextError()
	{
		return "O nome ou descrição contém texto inapropriado.";
	}

	/// <summary>
	/// Key: "Message.MinimumPrice"
	/// English String: "You cannot set a price below the minimum price of {minimumPrice}"
	/// </summary>
	public override string MessageMinimumPrice(string minimumPrice)
	{
		return $"Você não pode definir o preço com um valor menor que o mínimo de {minimumPrice}";
	}

	protected override string _GetTemplateForMessageMinimumPrice()
	{
		return "Você não pode definir o preço com um valor menor que o mínimo de {minimumPrice}";
	}

	protected override string _GetTemplateForMessageNameFieldEmpty()
	{
		return "O nome não pode ficar vazio";
	}

	/// <summary>
	/// Key: "Message.NameFieldPopulated"
	/// English String: "{nameLength}/{maxNameLength} characters"
	/// </summary>
	public override string MessageNameFieldPopulated(string nameLength, string maxNameLength)
	{
		return $"{nameLength}/{maxNameLength} caracteres";
	}

	protected override string _GetTemplateForMessageNameFieldPopulated()
	{
		return "{nameLength}/{maxNameLength} caracteres";
	}

	protected override string _GetTemplateForMessageNameRequiredError()
	{
		return "O nome não pode ficar vazio.";
	}

	protected override string _GetTemplateForMessageNoTagsFound()
	{
		return "Nenhum rótulo encontrado";
	}

	protected override string _GetTemplateForMessageRestoreError()
	{
		return "Falha ao restaurar";
	}

	protected override string _GetTemplateForMessageRestoreSuccess()
	{
		return "Restaurado com sucesso";
	}

	/// <summary>
	/// Key: "Message.RevertError"
	/// English String: "Failed to revert to version {versionNumber}"
	/// </summary>
	public override string MessageRevertError(string versionNumber)
	{
		return $"Falha ao reverter para a versão {versionNumber}";
	}

	protected override string _GetTemplateForMessageRevertError()
	{
		return "Falha ao reverter para a versão {versionNumber}";
	}

	/// <summary>
	/// Key: "Message.RevertSuccess"
	/// English String: "Successfully reverted to version {versionNumber}"
	/// </summary>
	public override string MessageRevertSuccess(string versionNumber)
	{
		return $"Revertido com sucesso para a versão {versionNumber}";
	}

	protected override string _GetTemplateForMessageRevertSuccess()
	{
		return "Revertido com sucesso para a versão {versionNumber}";
	}

	protected override string _GetTemplateForMessageSaveError()
	{
		return "Algo deu errado. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForMessageTooManyUploads()
	{
		return "Você está transferindo muitos arquivos. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageUpdatePriceError()
	{
		return "Falha ao atualizar o preço";
	}

	protected override string _GetTemplateForMessageUpdatePriceSuccess()
	{
		return "Preço atualizado com sucesso";
	}

	protected override string _GetTemplateForMessageUpdateSuccess()
	{
		return "Atualizado com sucesso";
	}
}
