namespace Roblox.TranslationResources.Feature;

public interface IItemConfigurationResources : ITranslationResources
{
	/// <summary>
	/// Key: "Description.AllowCopying"
	/// English String: "By switching on, you are granting every other user of Roblox the right to use (in various ways) the content you are now sharing. If you do not want to grant this right, please do not check this box. For more information about sharing content, please review the Roblox Terms of Use."
	/// </summary>
	string DescriptionAllowCopying { get; }

	/// <summary>
	/// Key: "Description.ArchiveWarning"
	/// English String: "Archiving this asset will prevent it from being used in game. Archived assets can be restored."
	/// </summary>
	string DescriptionArchiveWarning { get; }

	/// <summary>
	/// Key: "Description.ClickToAddTag"
	/// Hover text on the button that adds a tag to an item
	/// English String: "Click to add tag"
	/// </summary>
	string DescriptionClickToAddTag { get; }

	/// <summary>
	/// Key: "Description.ModeratorFileReview"
	/// English String: "* Uploaded file will be reviewed by moderators before being made visible to other users"
	/// </summary>
	string DescriptionModeratorFileReview { get; }

	/// <summary>
	/// Key: "Description.ModeratorReview"
	/// English String: "* Uploaded image will be reviewed by moderators before being made visible to other users"
	/// </summary>
	string DescriptionModeratorReview { get; }

	/// <summary>
	/// Key: "Heading.Archive"
	/// header text for section about archiving assets
	/// English String: "Archive"
	/// </summary>
	string HeadingArchive { get; }

	/// <summary>
	/// Key: "Heading.Configure"
	/// English String: "Configure"
	/// </summary>
	string HeadingConfigure { get; }

	/// <summary>
	/// Key: "Heading.ConfigureItemTags"
	/// Heading on Configure Tags modal
	/// English String: "Configure Tags"
	/// </summary>
	string HeadingConfigureItemTags { get; }

	/// <summary>
	/// Key: "Heading.Create"
	/// English String: "Create"
	/// </summary>
	string HeadingCreate { get; }

	/// <summary>
	/// Key: "Heading.Settings"
	/// English String: "Settings"
	/// </summary>
	string HeadingSettings { get; }

	/// <summary>
	/// Key: "Label.AllowCopying"
	/// English String: "Allow Copying"
	/// </summary>
	string LabelAllowCopying { get; }

	/// <summary>
	/// Key: "Label.Archive"
	/// Text on button for archiving an asset. Part of speech: verb
	/// English String: "Archive"
	/// </summary>
	string LabelArchive { get; }

	/// <summary>
	/// Key: "Label.Cancel"
	/// English String: "Cancel"
	/// </summary>
	string LabelCancel { get; }

	/// <summary>
	/// Key: "Label.Computer"
	/// computer term
	/// English String: "Computer"
	/// </summary>
	string LabelComputer { get; }

	/// <summary>
	/// Key: "Label.Created"
	/// English String: "Created"
	/// </summary>
	string LabelCreated { get; }

	/// <summary>
	/// Key: "Label.Current"
	/// English String: "Current"
	/// </summary>
	string LabelCurrent { get; }

	/// <summary>
	/// Key: "Label.CurrentPublishedVersion"
	/// English String: "Current published version"
	/// </summary>
	string LabelCurrentPublishedVersion { get; }

	/// <summary>
	/// Key: "Label.Description"
	/// English String: "Description"
	/// </summary>
	string LabelDescription { get; }

	/// <summary>
	/// Key: "Label.Device"
	/// device term
	/// English String: "Device"
	/// </summary>
	string LabelDevice { get; }

	/// <summary>
	/// Key: "Label.EnterItemTag"
	/// Placeholder for input field
	/// English String: "Enter tag here..."
	/// </summary>
	string LabelEnterItemTag { get; }

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	string LabelGame { get; }

	/// <summary>
	/// Key: "Label.GamePass"
	/// label
	/// English String: "Game Pass"
	/// </summary>
	string LabelGamePass { get; }

	/// <summary>
	/// Key: "Label.General"
	/// English String: "General"
	/// </summary>
	string LabelGeneral { get; }

	/// <summary>
	/// Key: "Label.GoToDetails"
	/// Link to the item details page from the configure page
	/// English String: "Go to Details"
	/// </summary>
	string LabelGoToDetails { get; }

	/// <summary>
	/// Key: "Label.ItemActive"
	/// English String: "Item is Active"
	/// </summary>
	string LabelItemActive { get; }

	/// <summary>
	/// Key: "Label.ItemForSale"
	/// English String: "Item for Sale"
	/// </summary>
	string LabelItemForSale { get; }

	/// <summary>
	/// Key: "Label.LastUpdated"
	/// English String: "Last Updated"
	/// </summary>
	string LabelLastUpdated { get; }

	/// <summary>
	/// Key: "Label.LearnMore"
	/// English String: "Learn more"
	/// </summary>
	string LabelLearnMore { get; }

	/// <summary>
	/// Key: "Label.MarketplaceFee"
	/// English String: "Marketplace Fee"
	/// </summary>
	string LabelMarketplaceFee { get; }

	/// <summary>
	/// Key: "Label.Name"
	/// English String: "Name"
	/// </summary>
	string LabelName { get; }

	/// <summary>
	/// Key: "Label.OpenForComments"
	/// English String: "Open for Comments"
	/// </summary>
	string LabelOpenForComments { get; }

	/// <summary>
	/// Key: "Label.Preview"
	/// English String: "Preview"
	/// </summary>
	string LabelPreview { get; }

	/// <summary>
	/// Key: "Label.Price"
	/// English String: "Price"
	/// </summary>
	string LabelPrice { get; }

	/// <summary>
	/// Key: "Label.Profit"
	/// English String: "You Earn"
	/// </summary>
	string LabelProfit { get; }

	/// <summary>
	/// Key: "Label.Restore"
	/// English String: "Restore"
	/// </summary>
	string LabelRestore { get; }

	/// <summary>
	/// Key: "Label.RevertVersion"
	/// English String: "Revert to this version"
	/// </summary>
	string LabelRevertVersion { get; }

	/// <summary>
	/// Key: "Label.Sales"
	/// English String: "Sales"
	/// </summary>
	string LabelSales { get; }

	/// <summary>
	/// Key: "Label.Save"
	/// English String: "Save"
	/// </summary>
	string LabelSave { get; }

	/// <summary>
	/// Key: "Label.SelectType"
	/// Placeholder for dropdown in create asset page. Options are image, mesh, hair accessory, etc
	/// English String: "Select a type"
	/// </summary>
	string LabelSelectType { get; }

	/// <summary>
	/// Key: "Label.Tags"
	/// The label next to a list of item tags in the item configuration page
	/// English String: "Tags"
	/// </summary>
	string LabelTags { get; }

	/// <summary>
	/// Key: "Label.Type"
	/// English String: "Type"
	/// </summary>
	string LabelType { get; }

	/// <summary>
	/// Key: "Label.Updated"
	/// English String: "Updated"
	/// </summary>
	string LabelUpdated { get; }

	/// <summary>
	/// Key: "Label.Version"
	/// English String: "Version"
	/// </summary>
	string LabelVersion { get; }

	/// <summary>
	/// Key: "Label.Versions"
	/// English String: "Versions"
	/// </summary>
	string LabelVersions { get; }

	/// <summary>
	/// Key: "Message.ArchiveError"
	/// English String: "Failed to archive"
	/// </summary>
	string MessageArchiveError { get; }

	/// <summary>
	/// Key: "Message.ArchiveSuccess"
	/// English String: "Successfully archived"
	/// </summary>
	string MessageArchiveSuccess { get; }

	/// <summary>
	/// Key: "Message.DescriptionFieldEmptyError"
	/// English String: "Description cannot be empty"
	/// </summary>
	string MessageDescriptionFieldEmptyError { get; }

	/// <summary>
	/// Key: "Message.DescriptionTooLongError"
	/// error message
	/// English String: "The description is too long."
	/// </summary>
	string MessageDescriptionTooLongError { get; }

	/// <summary>
	/// Key: "Message.FilteringServiceUnavailableError"
	/// error message
	/// English String: "Text filtering service is unavailable at this time."
	/// </summary>
	string MessageFilteringServiceUnavailableError { get; }

	/// <summary>
	/// Key: "Message.GamePassConfigDisabledError"
	/// error message
	/// English String: "Game Pass configuration is not enabled yet."
	/// </summary>
	string MessageGamePassConfigDisabledError { get; }

	/// <summary>
	/// Key: "Message.GamePassNotFoundError"
	/// errormessage
	/// English String: "The Game Pass does not exist."
	/// </summary>
	string MessageGamePassNotFoundError { get; }

	/// <summary>
	/// Key: "Message.IconUpdateFailed"
	/// error message
	/// English String: "Failed to update icon."
	/// </summary>
	string MessageIconUpdateFailed { get; }

	/// <summary>
	/// Key: "Message.ImageSavingFailedError"
	/// error message
	/// English String: "Failed to save image. Please try again later."
	/// </summary>
	string MessageImageSavingFailedError { get; }

	/// <summary>
	/// Key: "Message.InappropriateTextError"
	/// error message
	/// English String: "The name or description contains inappropriate text."
	/// </summary>
	string MessageInappropriateTextError { get; }

	/// <summary>
	/// Key: "Message.NameFieldEmpty"
	/// English String: "Name cannot be empty"
	/// </summary>
	string MessageNameFieldEmpty { get; }

	/// <summary>
	/// Key: "Message.NameRequiredError"
	/// error message
	/// English String: "The name cannot be empty."
	/// </summary>
	string MessageNameRequiredError { get; }

	/// <summary>
	/// Key: "Message.NoTagsFound"
	/// English String: "No tags found"
	/// </summary>
	string MessageNoTagsFound { get; }

	/// <summary>
	/// Key: "Message.RestoreError"
	/// English String: "Failed to restore"
	/// </summary>
	string MessageRestoreError { get; }

	/// <summary>
	/// Key: "Message.RestoreSuccess"
	/// English String: "Successfully restored"
	/// </summary>
	string MessageRestoreSuccess { get; }

	/// <summary>
	/// Key: "Message.SaveError"
	/// English String: "Something failed. Please try again later"
	/// </summary>
	string MessageSaveError { get; }

	/// <summary>
	/// Key: "Message.TooManyUploads"
	/// error message
	/// English String: "You are uploading too much. Please try again later."
	/// </summary>
	string MessageTooManyUploads { get; }

	/// <summary>
	/// Key: "Message.UpdatePriceError"
	/// English String: "Failed to update price"
	/// </summary>
	string MessageUpdatePriceError { get; }

	/// <summary>
	/// Key: "Message.UpdatePriceSuccess"
	/// English String: "Successfully updated price"
	/// </summary>
	string MessageUpdatePriceSuccess { get; }

	/// <summary>
	/// Key: "Message.UpdateSuccess"
	/// English String: "Successfully updated"
	/// </summary>
	string MessageUpdateSuccess { get; }

	/// <summary>
	/// Key: "Description.AcceptableFileFormats"
	/// English String: "* Acceptable file formats: {fileExtensions}"
	/// </summary>
	string DescriptionAcceptableFileFormats(string fileExtensions);

	/// <summary>
	/// Key: "Description.AcceptableFiles"
	/// English String: "* Acceptable files{lineBreak}Format: {fileExtensions}   |   Size: {fileSizes}"
	/// </summary>
	string DescriptionAcceptableFiles(string lineBreak, string fileExtensions, string fileSizes);

	/// <summary>
	/// Key: "Description.AllowCopyingWarning"
	/// English String: "By switching on, you are granting every other user of Roblox the right to use (in various ways) the content you are now sharing. If you do not want to grant this right, please do not check this box. For more information about sharing content, please review the Roblox {linkStart}Terms of Use{linkEnd}."
	/// </summary>
	string DescriptionAllowCopyingWarning(string linkStart, string linkEnd);

	/// <summary>
	/// Key: "Description.MarketplaceExplanation"
	/// English String: "(Roblox takes {marketplaceFeePercentage}%, minimum {minimumPrice})"
	/// </summary>
	string DescriptionMarketplaceExplanation(string marketplaceFeePercentage, string minimumPrice);

	/// <summary>
	/// Key: "Description.SelectItemTags"
	/// itemTagLimit is the number of item tags allowed
	/// English String: "Select up to {itemTagLimit} tags."
	/// </summary>
	string DescriptionSelectItemTags(string itemTagLimit);

	string DescriptionVerifiedCreatorEmail(string linkStart, string linkEnd);

	/// <summary>
	/// Key: "Heading.ConfigureItem"
	/// English String: "Configure {itemType}"
	/// </summary>
	string HeadingConfigureItem(string itemType);

	/// <summary>
	/// Key: "Label.ForItem"
	/// English String: "For {itemType}"
	/// </summary>
	string LabelForItem(string itemType);

	/// <summary>
	/// Key: "Message.DescriptionFieldEmpty"
	/// English String: "{maxDescriptionLength} character limit"
	/// </summary>
	string MessageDescriptionFieldEmpty(string maxDescriptionLength);

	/// <summary>
	/// Key: "Message.DescriptionFieldPopulated"
	/// English String: "{descriptionLength}/{maxDescriptionLength} characters"
	/// </summary>
	string MessageDescriptionFieldPopulated(string descriptionLength, string maxDescriptionLength);

	/// <summary>
	/// Key: "Message.MinimumPrice"
	/// English String: "You cannot set a price below the minimum price of {minimumPrice}"
	/// </summary>
	string MessageMinimumPrice(string minimumPrice);

	/// <summary>
	/// Key: "Message.NameFieldPopulated"
	/// English String: "{nameLength}/{maxNameLength} characters"
	/// </summary>
	string MessageNameFieldPopulated(string nameLength, string maxNameLength);

	/// <summary>
	/// Key: "Message.RevertError"
	/// English String: "Failed to revert to version {versionNumber}"
	/// </summary>
	string MessageRevertError(string versionNumber);

	/// <summary>
	/// Key: "Message.RevertSuccess"
	/// English String: "Successfully reverted to version {versionNumber}"
	/// </summary>
	string MessageRevertSuccess(string versionNumber);
}
