namespace Roblox.TranslationResources.Feature;

public interface IAccountSettingsResources : ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	string ActionBillingHistoryLoadMore { get; }

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	string ActionCancelRenewal { get; }

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	string ActionDialogAddEmail { get; }

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	string ActionDialogAddPhone { get; }

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	string ActionDialogCancel { get; }

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	string ActionDialogChangeEmail { get; }

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	string ActionDialogChangeEmailConfirmation { get; }

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	string ActionDialogChangePassword { get; }

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	string ActionDialogChangePasswordConfirmation { get; }

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	string ActionDialogChangeUsernameBuy { get; }

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	string ActionDialogClose { get; }

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	string ActionDialogEditPhonePrimary { get; }

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	string ActionDialogEditPhoneSecondary { get; }

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	string ActionDialogInsufficientFundsBuy { get; }

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	string ActionDialogNo { get; }

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	string ActionDialogPinCreate { get; }

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	string ActionDialogPinCreateOk { get; }

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	string ActionDialogPinUnlock { get; }

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	string ActionDialogRemovePhonePrimary { get; }

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	string ActionDialogRemovePhoneSecondary { get; }

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	string ActionDialogSend { get; }

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	string ActionDialogSuccess { get; }

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	string ActionDialogUpdate { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	string ActionDialogVerifyEmailOk { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	string ActionDialogVerifyEmailPrimary { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	string ActionDialogVerifyEmailRetry { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	string ActionDialogVerifyPhonePrimary { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	string ActionDialogVerifyPhoneResendLink { get; }

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	string ActionDialogVerifyPhoneSecondary { get; }

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	string ActionDialogYes { get; }

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	string ActionHide { get; }

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	string ActionJoin { get; }

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	string ActionJoinBuildersClub { get; }

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	string ActionSave { get; }

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	string ActionShow { get; }

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	string ActionSignoutAllSessions { get; }

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	string ActionSocialDisconnect { get; }

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	string ActionSuccessDialogButtonText { get; }

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	string ActionUnblock { get; }

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	string ActionUpgradeMembership { get; }

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	string DescriptionAccountControls { get; }

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	string DescriptionAccountEmailRevertEmailSubject { get; }

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	string DescriptionDesktopPush1 { get; }

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	string DescriptionDesktopPush2 { get; }

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	string DescriptionDesktopPush3 { get; }

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	string DescriptionDialogAddPhone { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	string DescriptionDialogChangeEmailConfirmation { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	string DescriptionDialogChangeEmailWarning { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	string DescriptionDialogChangePasswordConfirmation { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	string DescriptionDialogChangeUsernameDisclaimer { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	string DescriptionDialogChangeUsernameForFree { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	string DescriptionDialogChangeUsernameHistory { get; }

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	string DescriptionDialogChangeUsernameTitle { get; }

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	string DescriptionDialogEditPhoneWarning { get; }

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	string DescriptionDialogEmailProvideAndVerifyWarning { get; }

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	string DescriptionDialogEmailVerificationSent { get; }

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	string DescriptionDialogEmailVerifyWarning { get; }

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	string DescriptionDialogFacebookDisconnectWarning { get; }

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	string DescriptionDialogMissingEmailAccountPin { get; }

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	string DescriptionDialogMissingEmailTwoStepVerification { get; }

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	string DescriptionDialogMissingEmailUsername { get; }

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	string DescriptionDialogPinUnlock { get; }

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	string DescriptionDialogUnverifiedEmailAccountPin { get; }

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	string DescriptionDialogUnverifiedEmailTwoStepVerification { get; }

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	string DescriptionDialogUnverifiedEmailUsername { get; }

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	string DescriptionFastTrack { get; }

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	string DescriptionFastTrackStatistics { get; }

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	string DescriptionHelpTextDescription { get; }

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	string DescriptionHelpTextFastTrackAccuracy { get; }

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	string DescriptionHelpTextPrivacyMode { get; }

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	string DescriptionHoverTextChangePassword { get; }

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	string DescriptionHoverTextChangeUsername { get; }

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	string DescriptionHoverTextUpdateEmail { get; }

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	string DescriptionMembershipHelp { get; }

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	string DescriptionMembershipStatus { get; }

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	string DescriptionMembershipStatusRobloxPremium { get; }

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	string DescriptionMobilePush1 { get; }

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	string DescriptionMobilePush2 { get; }

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	string DescriptionNotificationStream1 { get; }

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	string DescriptionNotificationStream2 { get; }

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	string DescriptionRenevalFromWebsiteOnly { get; }

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	string DescriptionSuccessDialogMessage { get; }

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	string DescriptionTwoStepVerificationSecondary { get; }

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	string DescriptionUsernameChangeEmailSubject { get; }

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	string DescriptionVerificationEmailSubjectOver13 { get; }

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	string DescriptionVerificationEmailSubjectUnder13 { get; }

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	string ExampleDescription { get; }

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	string ExampleFacebook { get; }

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	string ExampleGooglePlus { get; }

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	string ExampleTwitch { get; }

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	string ExampleTwitter { get; }

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	string ExampleYouTube { get; }

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	string HeadingAccountControls { get; }

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	string HeadingAccountInfo { get; }

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	string HeadingBilling { get; }

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	string HeadingBlockedUsers { get; }

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	string HeadingContactSettings { get; }

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	string HeadingDesktopPush { get; }

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	string HeadingDialogAddPassword { get; }

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	string HeadingDialogAddPhone { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	string HeadingDialogChangeEmail { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	string HeadingDialogChangeEmailConfirmation { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	string HeadingDialogChangePassword { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	string HeadingDialogChangePasswordConfirmation { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	string HeadingDialogChangePasswordSuccess { get; }

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	string HeadingDialogChangeUsername { get; }

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	string HeadingDialogDefaultError { get; }

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	string HeadingDialogDefaultSuccess { get; }

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	string HeadingDialogEditPhone { get; }

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	string HeadingDialogInsufficientFunds { get; }

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	string HeadingDialogInvalidUsername { get; }

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	string HeadingDialogPinCreate { get; }

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	string HeadingDialogPinCreateSuccessConfirmation { get; }

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	string HeadingDialogPinUnlock { get; }

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	string HeadingDialogRemovePhone { get; }

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	string HeadingDialogVerifiedEmailRequired { get; }

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	string HeadingDialogVerifyEmail { get; }

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	string HeadingDialogVerifyPhone { get; }

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	string HeadingFastTrack { get; }

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	string HeadingMembershipStatus { get; }

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	string HeadingNotificationOptions { get; }

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	string HeadingNotifications { get; }

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	string HeadingNotificationsActionWhen { get; }

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	string HeadingNotificationsDesktopPush { get; }

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	string HeadingNotificationsMobilePush { get; }

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	string HeadingNotificationsStream { get; }

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	string HeadingNotificationStream { get; }

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	string HeadingOtherSettings { get; }

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	string HeadingPageTitle { get; }

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	string HeadingPersonal { get; }

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	string HeadingPin { get; }

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	string HeadingPrivacySettings { get; }

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	string HeadingRenevalDate { get; }

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	string HeadingRestrictions { get; }

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	string HeadingSecureSignOut { get; }

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	string HeadingSocialNetworks { get; }

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	string HeadingSocialSignOn { get; }

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	string HeadingSuccessDialogTitle { get; }

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	string HeadingTabAccountInfo { get; }

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	string HeadingTabBilling { get; }

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	string HeadingTabFastTrack { get; }

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	string HeadingTabNotifications { get; }

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	string HeadingTabPrivacy { get; }

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	string HeadingTabSecurity { get; }

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	string HeadingTransactions { get; }

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	string HeadingTwoStepVerification { get; }

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	string HeadingXbox { get; }

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	string LabelAccountPinDisabled { get; }

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	string LabelAccountPinEnabled { get; }

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	string LabelAccountRestrictionDisabled { get; }

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	string LabelAccountRestrictionEnabled { get; }

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	string LabelAddEmail { get; }

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	string LabelAddEmailParent { get; }

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	string LabelAddPassword { get; }

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	string LabelAddPhone { get; }

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	string LabelAddPhoneLink { get; }

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	string LabelBillingHelp { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	string LabelBillingHistoryCost { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	string LabelBillingHistoryDate { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	string LabelBillingHistoryDescription { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	string LabelBillingHistoryGeneralErrors { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	string LabelBillingHistoryNoTransactions { get; }

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	string LabelBillingHistoryPaymentType { get; }

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	string LabelBirthday { get; }

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	string LabelBuildersClub { get; }

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	string LabelChangeYourUsername { get; }

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	string LabelChooseLanguage { get; }

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	string LabelClassicTheme { get; }

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	string LabelConnectAccount { get; }

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	string LabelCountry { get; }

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	string LabelCountryTitle { get; }

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	string LabelDarkTheme { get; }

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	string LabelDialogAddEmailOver13 { get; }

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	string LabelDialogAddEmailUnder13 { get; }

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	string LabelDialogAddPhoneField { get; }

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	string LabelDialogAddPhonePassword { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	string LabelDialogChangeEmailField { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	string LabelDialogChangeEmailOver13 { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	string LabelDialogChangeEmailUnder13 { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	string LabelDialogChangePasswordConfirm { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	string LabelDialogChangePasswordCurrent { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	string LabelDialogChangePasswordNew { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	string LabelDialogChangeUsernameAccountPassword { get; }

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	string LabelDialogChangeUsernameField { get; }

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	string LabelDialogConfirmPin { get; }

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	string LabelDialogEditPhoneCurrentNumber { get; }

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	string LabelDialogEmailAddressChanged { get; }

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	string LabelDialogEmailRequired { get; }

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	string LabelDialogVerifiedEmail { get; }

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	string LabelDialogVerifyPassword { get; }

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	string LabelDialogVerifyPhoneCodeLabel { get; }

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	string LabelDialogVerifySms { get; }

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	string LabelDropDownCustom { get; }

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	string LabelDropDownDefault { get; }

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	string LabelDropDownEveryone { get; }

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	string LabelDropDownFollowers { get; }

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	string LabelDropDownFollowing { get; }

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	string LabelDropDownFriends { get; }

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	string LabelDropDownHigh { get; }

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	string LabelDropDownLow { get; }

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	string LabelDropDownMedium { get; }

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	string LabelDropDownNone { get; }

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	string LabelDropDownNoOne { get; }

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	string LabelDropDownOff { get; }

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	string LabelEmail { get; }

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	string LabelEmailParent { get; }

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	string LabelEmailVerificationPending { get; }

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	string LabelExpirationDate { get; }

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	string LabelFacebook { get; }

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	string LabelFastTrackAccuracy { get; }

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	string LabelFastTrackAllFastTrackMembers { get; }

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	string LabelFastTrackReportMonth { get; }

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	string LabelFastTrackReportYear { get; }

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	string LabelFastTrackStatistics { get; }

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	string LabelFastTrackYou { get; }

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	string LabelGender { get; }

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	string LabelGooglePlus { get; }

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	string LabelLightTheme { get; }

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	string LabelLocaleTitle { get; }

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	string LabelMembershipStatusRobloxPremium { get; }

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	string LabelNotificationsAddedToPrivateServer { get; }

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	string LabelNotificationsChat { get; }

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	string LabelNotificationsConversationUniverseChanged { get; }

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	string LabelNotificationsDeveloperMetricsAvailable { get; }

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	string LabelNotificationsFriendRequestAccepted { get; }

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	string LabelNotificationsFriendRequestReceived { get; }

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	string LabelNotificationsGameUpdate { get; }

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	string LabelNotificationsPartyInvited { get; }

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	string LabelNotificationsPartyJoined { get; }

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	string LabelNotificationsPrivateMessage { get; }

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	string LabelNotificationsTeamCreateInvite { get; }

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	string LabelPassword { get; }

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	string LabelPhone { get; }

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	string LabelPinTimeMins { get; }

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	string LabelPinTimeRemaining { get; }

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	string LabelPinTimeSecs { get; }

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	string LabelPreviousUsernames { get; }

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	string LabelPrivacyMode { get; }

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	string LabelRenevalDate { get; }

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	string LabelSignOutAllSessions { get; }

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	string LabelSocialLinksVisibility { get; }

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	string LabelThemeTitle { get; }

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	string LabelToolTipContactSettings { get; }

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	string LabelToolTipPinLocked { get; }

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	string LabelToolTipPinUnlocked { get; }

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	string LabelToolTipPrivacyMode { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	string LabelToolTipWhoCanChatInApp { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	string LabelToolTipWhoCanChatInGame { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	string LabelToolTipWhoCanFindMeByPhone { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	string LabelToolTipWhoCanInviteVIP { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	string LabelToolTipWhoCanJoinGame { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	string LabelToolTipWhoCanMessageMe { get; }

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	string LabelToolTipWhoCanSeeInventory { get; }

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	string LabelTradeFilter { get; }

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	string LabelTwitch { get; }

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	string LabelTwitter { get; }

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	string LabelTwoStepEmail { get; }

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	string LabelTwoStepPrerequisite { get; }

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	string LabelTwoStepVerification { get; }

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	string LabelTwoStepVerificationEnabled { get; }

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	string LabelUpdateEmail { get; }

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	string LabelUpdatePhone { get; }

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	string LabelUseDeviceLanguage { get; }

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	string LabelUsername { get; }

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	string LabelVerified { get; }

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	string LabelVerify { get; }

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	string LabelWhoCanChatInApp { get; }

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	string LabelWhoCanChatInGame { get; }

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	string LabelWhoCanFindMeByPhone { get; }

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	string LabelWhoCanInviteVIP { get; }

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	string LabelWhoCanJoinGame { get; }

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	string LabelWhoCanMessageMe { get; }

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	string LabelWhoCanSeeInventory { get; }

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	string LabelWhoCanTradeWithMe { get; }

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	string LabelXboxConnected { get; }

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	string LabelYouTube { get; }

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	string LabelInsufficientRobux { get; }

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	string MessageErrorAccountHasPin { get; }

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	string MessageErrorAccountLocked { get; }

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	string MessageErrorDefault { get; }

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	string MessageErrorEmailAlreadyVerified { get; }

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	string MessageErrorEmailFeatureDisabled { get; }

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	string MessageErrorEmailIncorrectPassword { get; }

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	string MessageErrorEmailInvalidEmail { get; }

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	string MessageErrorEmailNoEmailAssociated { get; }

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	string MessageErrorEmailPinLocked { get; }

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	string MessageErrorEmailSameEmail { get; }

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	string MessageErrorEmailTooManyAccounts { get; }

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	string MessageErrorEmailTooManyUpdates { get; }

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	string MessageErrorEmailTooManyVerify { get; }

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	string MessageErrorEmailUnknown { get; }

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	string MessageErrorIncorrectPin { get; }

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	string MessageErrorInvalidPinFormat { get; }

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	string MessageErrorNoPin { get; }

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	string MessageErrorNoVerifiedEmail { get; }

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	string MessageErrorSystem { get; }

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	string MessageErrorTooManyRequests { get; }

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	string MessageEmailAddSuccess { get; }

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	string MessageEmailAlreadyVerifiedError { get; }

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	string MessageFeatureDisabledError { get; }

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	string MessageInsufficientRobuxErrorForUserName { get; }

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	string MessageInvalidEmail { get; }

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	string MessageNoEmailAssociatedError { get; }

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	string MessagePermissionError { get; }

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	string MessagePinLockedError { get; }

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	string MessageSameEmailError { get; }

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	string MessageSettingsUpdateSuccess { get; }

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	string MessageTooManyAccountsOnEmailError { get; }

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	string MessageTooManyAttemptsError { get; }

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	string MessageUnknownError { get; }

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	string MessageWrongPassword { get; }

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	string ResponesInvalidCodePhone { get; }

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	string ResponesInventoryAndTradePrivacyConflictError { get; }

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	string ResponseCodeRequired { get; }

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	string ResponseDialogBirthdayChangeDefaultWarning { get; }

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	string ResponseDialogBirthdayChangePasswordBody { get; }

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	string ResponseDialogBirthdayChangePasswordTitle { get; }

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	string ResponseDialogBirthdayChangeSocialWarning { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	string ResponseDialogChangePasswordIncorrectPassword { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	string ResponseDialogChangePasswordNoMatch { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	string ResponseDialogChangePasswordTooShortError { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	string ResponseDialogChangeUsernameNoInput { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	string ResponseDialogChangeUsernameNotAllowed { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	string ResponseDialogChangeUsernameNotAvailable { get; }

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	string ResponseDialogChangeUsernameSuccess { get; }

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	string ResponseDialogCountryListError { get; }

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	string ResponseDialogCurrencyServiceError { get; }

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	string ResponseDialogDefaultErrorMessage { get; }

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	string ResponseDialogDefaultErrorTitle { get; }

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	string ResponseDialogDefaultSuccessMessage { get; }

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	string ResponseDialogDisconnectXBoxError { get; }

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	string ResponseDialogEmailSentForVerification { get; }

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	string ResponseDialogInvalidEmailAddress { get; }

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	string ResponseDialogInvalidPhoneNumber { get; }

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	string ResponseDialogInvalidUsername { get; }

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	string ResponseDialogPasswordRulesError { get; }

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	string ResponseDialogPinCreateConfirmation { get; }

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	string ResponseDialogPinCreateMismatch { get; }

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	string ResponseDialogSignoutSessionFailed { get; }

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	string ResponseDialogSignoutSessionsConfirmation { get; }

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	string ResponseDialogTwoStepDisableWarning { get; }

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	string ResponseDialogTwoStepSuccessTitle { get; }

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	string ResponseDialogTwoStepSucessBody { get; }

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	string ResponseDialogUpdateInventorySetting { get; }

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	string ResponseDialogUpdateNotificationSettingsError { get; }

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	string ResponseDialogUpdateTradeSetting { get; }

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	string ResponseDialogVerifyPhoneInvalidCode { get; }

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	string ResponseDialogWarning { get; }

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	string ResponseFeatureDisabled { get; }

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	string ResponseGeneralError { get; }

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	string ResponseIncorrectCodeTooManyTimes { get; }

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	string ResponseIncorrectPasswordTryAgain { get; }

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	string ResponseInvalidPhoneTryAgain { get; }

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	string ResponseNotificationBarPhoneRemovedConfirmation { get; }

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	string ResponseNotificationBarPhoneVerifyConfirmation { get; }

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	string ResponseNumberAlreadyAssociated { get; }

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	string ResponsePinRequired { get; }

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	string ResponseSocialMediaValidationError { get; }

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	string ResponseAgeDownError { get; }

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress);

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress);

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress);

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd);

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount);

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	string DescriptionContactSetting(string linkStart, string linkEnd);

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price);

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	string DescriptionDialogInsufficientFundsWarning(string robuxToBuy);

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	string DescriptionDialogRemovePhoneWarning(string phoneLast4);

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	string DescriptionTwoStepverificationSecondaryEnabled(string email);

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress);

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress);

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress);

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress);

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd);

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink);

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink);

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink);

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink);

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink);

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd);

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	string LabelBillingHistoryCardNumber(string lastFourCard);

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	string LabelBuildersClubJoin(string startSpan, string endSpan);

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	string LabelDialogCreatePin(string digitCount);

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	string LabelDialogVerifyPhoneCode(string digitCount);

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan);

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	string LabelMembershipName(string startSpan, string endSpan);

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	string LabelPremiumClub(string amount);

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan);

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	string LabelRobloxPremiumClub(string amount);

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	string LabelRobuxProductName(string amount);

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	string LabelSocialUsername(string socialUsername);
}
