namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GroupsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GroupsResources_pt_br : GroupsResources_en_us, IGroupsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.AdvertiseGroup"
	/// English String: "Advertise Group"
	/// </summary>
	public override string ActionAdvertiseGroup => "Anunciar grupo";

	/// <summary>
	/// Key: "Action.AuditLog"
	/// English String: "Audit Log"
	/// </summary>
	public override string ActionAuditLog => "Auditar histórico";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.CancelRequest"
	/// English String: "Cancel Request"
	/// </summary>
	public override string ActionCancelRequest => "Cancelar pedido";

	/// <summary>
	/// Key: "Action.ClaimOwnership"
	/// English String: "Claim Ownership"
	/// </summary>
	public override string ActionClaimOwnership => "Receber propriedade";

	/// <summary>
	/// Key: "Action.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Fechar";

	/// <summary>
	/// Key: "Action.ConfigureGroup"
	/// English String: "Configure Group"
	/// </summary>
	public override string ActionConfigureGroup => "Configurar grupo";

	/// <summary>
	/// Key: "Action.CreateGroup"
	/// English String: "Create Group"
	/// </summary>
	public override string ActionCreateGroup => "Criar grupo";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Excluir";

	/// <summary>
	/// Key: "Action.Exile"
	/// English String: "Exile"
	/// </summary>
	public override string ActionExile => "Exilar";

	/// <summary>
	/// Key: "Action.ExileUser"
	/// English String: "Exile User"
	/// </summary>
	public override string ActionExileUser => "Exilar usuário";

	/// <summary>
	/// Key: "Action.GroupAdmin"
	/// English String: "Group Admin"
	/// </summary>
	public override string ActionGroupAdmin => "Administrador do grupo";

	/// <summary>
	/// Key: "Action.GroupShout"
	/// Text on the button for sending / posting a group shout
	/// English String: "Group Shout"
	/// </summary>
	public override string ActionGroupShout => "Anúncio de grupo";

	/// <summary>
	/// Key: "Action.JoinGroup"
	/// English String: "Join Group"
	/// </summary>
	public override string ActionJoinGroup => "Entrar no grupo";

	/// <summary>
	/// Key: "Action.LeaveGroup"
	/// English String: "Leave Group"
	/// </summary>
	public override string ActionLeaveGroup => "Sair do grupo";

	/// <summary>
	/// Key: "Action.MakePrimary"
	/// English String: "Make Primary"
	/// </summary>
	public override string ActionMakePrimary => "Tornar principal";

	/// <summary>
	/// Key: "Action.MakePrimaryGroup"
	/// Set the current group as the users primary group
	/// English String: "Make Primary Group"
	/// </summary>
	public override string ActionMakePrimaryGroup => "Tornar grupo principal";

	/// <summary>
	/// Key: "Action.Post"
	/// English String: "Post"
	/// </summary>
	public override string ActionPost => "Publicar";

	/// <summary>
	/// Key: "Action.Purchase"
	/// English String: "Purchase"
	/// </summary>
	public override string ActionPurchase => "Comprar";

	/// <summary>
	/// Key: "Action.RemovePrimary"
	/// English String: "Remove Primary"
	/// </summary>
	public override string ActionRemovePrimary => "Remover principal";

	/// <summary>
	/// Key: "Action.Report"
	/// English String: "Report"
	/// </summary>
	public override string ActionReport => "Denunciar";

	/// <summary>
	/// Key: "Action.ReportAbuse"
	/// English String: "Report Abuse"
	/// </summary>
	public override string ActionReportAbuse => "Denunciar abuso";

	/// <summary>
	/// Key: "Action.Upgrade"
	/// English String: "Upgrade"
	/// </summary>
	public override string ActionUpgrade => "Upgrade";

	/// <summary>
	/// Key: "Action.UpgradeToJoin"
	/// English String: "Upgrade to Join"
	/// </summary>
	public override string ActionUpgradeToJoin => "Faça o upgrade para entrar";

	/// <summary>
	/// Key: "Action.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionYes => "Sim";

	/// <summary>
	/// Key: "Description.ClothingRevenue"
	/// English String: "Groups have the ability to create and sell official shirts, pants, and t-shirts! All revenue goes to group funds."
	/// </summary>
	public override string DescriptionClothingRevenue => "Grupos possuem a habilidade de criar e vender camisas, calças e camisetas oficiais! Toda a renda vai para os fundos do grupo.";

	/// <summary>
	/// Key: "Description.DeleteAllPostsByUser"
	/// English String: "Also delete all posts by this user."
	/// </summary>
	public override string DescriptionDeleteAllPostsByUser => "Excluir também todas as publicações deste usuário.";

	/// <summary>
	/// Key: "Description.ExileUserWarning"
	/// English String: "Are you sure you want to exile this user?"
	/// </summary>
	public override string DescriptionExileUserWarning => "Quer mesmo exilar este usuário?";

	/// <summary>
	/// Key: "Description.LeaveGroupAsOwnerWarning"
	/// English String: "This will leave the group ownerless."
	/// </summary>
	public override string DescriptionLeaveGroupAsOwnerWarning => "Isto fará com que o grupo fique sem dono.";

	/// <summary>
	/// Key: "Description.LeaveGroupWarning"
	/// English String: "Are you sure you want to leave this group?"
	/// </summary>
	public override string DescriptionLeaveGroupWarning => "Quer mesmo sair deste grupo?";

	/// <summary>
	/// Key: "Description.MakePrimaryGroupWarning"
	/// English String: "Are you sure you want to make this your primary group?"
	/// </summary>
	public override string DescriptionMakePrimaryGroupWarning => "Quer mesmo tornar este grupo o seu grupo principal?";

	/// <summary>
	/// Key: "Description.NoneMaxGroups"
	/// English String: "Upgrade to Builders Club to join more groups."
	/// </summary>
	public override string DescriptionNoneMaxGroups => "Faça o upgrade para Builders Club para entrar em mais grupos.";

	/// <summary>
	/// Key: "Description.NoneMaxGroupsPremium"
	/// English String: "Upgrade to Roblox Premium to join more groups."
	/// </summary>
	public override string DescriptionNoneMaxGroupsPremium => "Faça o upgrade para Roblox Premium para entrar em mais grupos.";

	/// <summary>
	/// Key: "Description.noneMaxGroupsPremiumText"
	/// English String: "Upgrade to Roblox Premium to join more groups."
	/// </summary>
	public override string DescriptionnoneMaxGroupsPremiumText => "Faça o upgrade para Roblox Premium para entrar em mais grupos.";

	/// <summary>
	/// Key: "Description.ObcMaxGroups"
	/// English String: "You have joined the maximum number of groups."
	/// </summary>
	public override string DescriptionObcMaxGroups => "Você entrou no número máximo de grupos.";

	/// <summary>
	/// Key: "Description.OtherBcMaxGroups"
	/// English String: "Upgrade your Builders Club to join more groups."
	/// </summary>
	public override string DescriptionOtherBcMaxGroups => "Faça o upgrade do seu Builders Club para entrar em mais grupos.";

	/// <summary>
	/// Key: "Description.otherPremiumMaxGroupsText"
	/// English String: "Upgrade your Roblox Premium to join more groups."
	/// </summary>
	public override string DescriptionotherPremiumMaxGroupsText => "Faça o upgrade do seu Roblox Premium para entrar em mais grupos.";

	/// <summary>
	/// Key: "Description.PremiumMaxGroups"
	/// English String: "You have joined the maximum number of groups."
	/// </summary>
	public override string DescriptionPremiumMaxGroups => "Você entrou no número máximo de grupos.";

	/// <summary>
	/// Key: "Description.PurchaseBody"
	/// English String: "Would you like to create this group for"
	/// </summary>
	public override string DescriptionPurchaseBody => "Deseja criar este grupo por";

	/// <summary>
	/// Key: "Description.RemovePrimaryGroupWarning"
	/// English String: "Are you sure you want to remove your primary group?"
	/// </summary>
	public override string DescriptionRemovePrimaryGroupWarning => "Quer mesmo remover seu grupo principal?";

	/// <summary>
	/// Key: "Description.ReportAbuseDescription"
	/// English String: "What would you like to report?"
	/// </summary>
	public override string DescriptionReportAbuseDescription => "Deseja denunciar?";

	/// <summary>
	/// Key: "Description.WallPrivacySettings"
	/// English String: "Your privacy settings do not allow you to post to group walls. Click here to adjust these settings."
	/// </summary>
	public override string DescriptionWallPrivacySettings => "Suas configurações de privacidade não permitem que você publique em murais de grupo. Clique aqui para ajustar estas configurações.";

	/// <summary>
	/// Key: "Heading.About"
	/// English String: "About"
	/// </summary>
	public override string HeadingAbout => "Sobre";

	/// <summary>
	/// Key: "Heading.Affiliates"
	/// English String: "Affiliates"
	/// </summary>
	public override string HeadingAffiliates => "Afiliados";

	/// <summary>
	/// Key: "Heading.Allies"
	/// English String: "Allies"
	/// </summary>
	public override string HeadingAllies => "Aliados";

	/// <summary>
	/// Key: "Heading.Date"
	/// English String: "Date"
	/// </summary>
	public override string HeadingDate => "Data";

	/// <summary>
	/// Key: "Heading.Description"
	/// English String: "Description"
	/// </summary>
	public override string HeadingDescription => "Descrição";

	/// <summary>
	/// Key: "Heading.Enemies"
	/// English String: "Enemies"
	/// </summary>
	public override string HeadingEnemies => "Inimigos";

	/// <summary>
	/// Key: "Heading.ExileUserWarning"
	/// English String: "Warning"
	/// </summary>
	public override string HeadingExileUserWarning => "Aviso";

	/// <summary>
	/// Key: "Heading.Funds"
	/// English String: "Funds"
	/// </summary>
	public override string HeadingFunds => "Fundos";

	/// <summary>
	/// Key: "Heading.Games"
	/// English String: "Games"
	/// </summary>
	public override string HeadingGames => "Jogos";

	/// <summary>
	/// Key: "Heading.GroupPurchase"
	/// English String: "Group Purchase Confirmation"
	/// </summary>
	public override string HeadingGroupPurchase => "Confirmação da compra de grupo";

	/// <summary>
	/// Key: "Heading.GroupShout"
	/// English String: "Group Shout"
	/// </summary>
	public override string HeadingGroupShout => "Anúncio de grupo";

	/// <summary>
	/// Key: "Heading.LeaveGroup"
	/// English String: "Leave Group"
	/// </summary>
	public override string HeadingLeaveGroup => "Sair do grupo";

	/// <summary>
	/// Key: "Heading.MakePrimaryGroup"
	/// Heading of make primary group modal
	/// English String: "Make Primary Group"
	/// </summary>
	public override string HeadingMakePrimaryGroup => "Tornar grupo principal";

	/// <summary>
	/// Key: "Heading.Members"
	/// English String: "Members"
	/// </summary>
	public override string HeadingMembers => "Membros";

	/// <summary>
	/// Key: "Heading.NameOrDescription"
	/// Selection option for what to report when reporting something in a group
	/// English String: "Name or Description"
	/// </summary>
	public override string HeadingNameOrDescription => "Nome ou descrição";

	/// <summary>
	/// Key: "Heading.Payouts"
	/// English String: "Payouts"
	/// </summary>
	public override string HeadingPayouts => "Pagamentos";

	/// <summary>
	/// Key: "Heading.Primary"
	/// English String: "Primary"
	/// </summary>
	public override string HeadingPrimary => "Principal";

	/// <summary>
	/// Key: "Heading.Rank"
	/// English String: "Rank"
	/// </summary>
	public override string HeadingRank => "Ranque";

	/// <summary>
	/// Key: "Heading.RemovePrimaryGroup"
	/// English String: "Remove Primary Group"
	/// </summary>
	public override string HeadingRemovePrimaryGroup => "Remover grupo principal";

	/// <summary>
	/// Key: "Heading.Role"
	/// English String: "Role"
	/// </summary>
	public override string HeadingRole => "Função";

	/// <summary>
	/// Key: "Heading.Settings"
	/// English String: "Settings"
	/// </summary>
	public override string HeadingSettings => "Configurações";

	/// <summary>
	/// Key: "Heading.Shout"
	/// To be displayed above the group shout (the current status for a group set by admins)
	/// English String: "Shout"
	/// </summary>
	public override string HeadingShout => "Anunciar";

	/// <summary>
	/// Key: "Heading.Store"
	/// English String: "Store"
	/// </summary>
	public override string HeadingStore => "Loja";

	/// <summary>
	/// Key: "Heading.User"
	/// English String: "User"
	/// </summary>
	public override string HeadingUser => "Usuário";

	/// <summary>
	/// Key: "Heading.Wall"
	/// English String: "Wall"
	/// </summary>
	public override string HeadingWall => "Mural";

	/// <summary>
	/// Key: "Label.Abandon"
	/// English String: "Abandon"
	/// </summary>
	public override string LabelAbandon => "Abandonar";

	/// <summary>
	/// Key: "Label.AcceptAllyRequest"
	/// English String: "Accept Ally Request"
	/// </summary>
	public override string LabelAcceptAllyRequest => "Aceitar pedido de aliança";

	/// <summary>
	/// Key: "Label.AcceptJoinRequest"
	/// English String: "Accept Join Request"
	/// </summary>
	public override string LabelAcceptJoinRequest => "Aceitar pedido de entrada";

	/// <summary>
	/// Key: "Label.AddGroupPlace"
	/// English String: "Add Group Place"
	/// </summary>
	public override string LabelAddGroupPlace => "Adicionar local do grupo";

	/// <summary>
	/// Key: "Label.AdjustCurrencyAmounts"
	/// English String: "Adjust Currency Amounts"
	/// </summary>
	public override string LabelAdjustCurrencyAmounts => "Ajustar valores de moeda";

	/// <summary>
	/// Key: "Label.All"
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Tudo";

	/// <summary>
	/// Key: "Label.AnyoneCanJoin"
	/// English String: "Anyone Can Join"
	/// </summary>
	public override string LabelAnyoneCanJoin => "Qualquer um pode entrar";

	/// <summary>
	/// Key: "Label.BuyAd"
	/// English String: "Buy Ad"
	/// </summary>
	public override string LabelBuyAd => "Comprar publicidade";

	/// <summary>
	/// Key: "Label.BuyClan"
	/// English String: "Buy Clan"
	/// </summary>
	public override string LabelBuyClan => "Comprar clã";

	/// <summary>
	/// Key: "Label.ByOwner"
	/// Prefix to either the owner of the group, or "No One!" if the group has no owner. Could not properly format like By {ownerName} because ownerName is a link in this case
	/// English String: "By"
	/// </summary>
	public override string LabelByOwner => "De";

	/// <summary>
	/// Key: "Label.CancelClanInvite"
	/// English String: "Cancel Clan Invite"
	/// </summary>
	public override string LabelCancelClanInvite => "Cancelar o convite do clã";

	/// <summary>
	/// Key: "Label.ChangeDescription"
	/// English String: "Change Description"
	/// </summary>
	public override string LabelChangeDescription => "Alterar descrição";

	/// <summary>
	/// Key: "Label.ChangeOwner"
	/// English String: "Change Owner"
	/// </summary>
	public override string LabelChangeOwner => "Alterar dono";

	/// <summary>
	/// Key: "Label.ChangeRank"
	/// English String: "Change Rank"
	/// </summary>
	public override string LabelChangeRank => "Alterar ranque";

	/// <summary>
	/// Key: "Label.Claim"
	/// English String: "Claim"
	/// </summary>
	public override string LabelClaim => "Reivindicar";

	/// <summary>
	/// Key: "Label.ConfigureBadge"
	/// English String: "Configure Badge"
	/// </summary>
	public override string LabelConfigureBadge => "Configurar emblema";

	/// <summary>
	/// Key: "Label.ConfigureGroupAsset"
	/// English String: "Configure Group Asset"
	/// </summary>
	public override string LabelConfigureGroupAsset => "Configurar elemento do grupo";

	/// <summary>
	/// Key: "Label.ConfigureGroupDevelopmentItem"
	/// English String: "Configure Group Development Item"
	/// </summary>
	public override string LabelConfigureGroupDevelopmentItem => "Configurar item de desenvolvimento do grupo";

	/// <summary>
	/// Key: "Label.ConfigureGroupGame"
	/// English String: "Configure Group Game"
	/// </summary>
	public override string LabelConfigureGroupGame => "Configurar jogo do grupo";

	/// <summary>
	/// Key: "Label.ConfigureItems"
	/// English String: "Configure Items"
	/// </summary>
	public override string LabelConfigureItems => "Configurar itens";

	/// <summary>
	/// Key: "Label.CreateBadge"
	/// English String: "Create Badge"
	/// </summary>
	public override string LabelCreateBadge => "Criar emblema";

	/// <summary>
	/// Key: "Label.CreateEnemy"
	/// English String: "Create Enemy"
	/// </summary>
	public override string LabelCreateEnemy => "Criar inimigo";

	/// <summary>
	/// Key: "Label.CreateGamePass"
	/// English String: "Create Game Pass"
	/// </summary>
	public override string LabelCreateGamePass => "Criar Passe de Jogo";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Criar grupo";

	/// <summary>
	/// Key: "Label.CreateGroupAsset"
	/// English String: "Create Group Asset"
	/// </summary>
	public override string LabelCreateGroupAsset => "Criar elemento do grupo";

	/// <summary>
	/// Key: "Label.CreateGroupBuildersClubTooltip"
	/// English String: "Creating a group requires a Builders Club membership."
	/// </summary>
	public override string LabelCreateGroupBuildersClubTooltip => "Criar um grupo requer uma assinatura do Builders Club.";

	/// <summary>
	/// Key: "Label.CreateGroupDescription"
	/// English String: "Description (optional)"
	/// </summary>
	public override string LabelCreateGroupDescription => "Descrição (opcional)";

	/// <summary>
	/// Key: "Label.CreateGroupDeveloperProduct"
	/// English String: "Create Group Developer Product"
	/// </summary>
	public override string LabelCreateGroupDeveloperProduct => "Criar produto de desenvolvimento do grupo";

	/// <summary>
	/// Key: "Label.CreateGroupEmblem"
	/// English String: "Emblem"
	/// </summary>
	public override string LabelCreateGroupEmblem => "Emblema";

	/// <summary>
	/// Key: "Label.CreateGroupFee"
	/// English String: "Group Creation Fee"
	/// </summary>
	public override string LabelCreateGroupFee => "Taxa de criação de grupo";

	/// <summary>
	/// Key: "Label.CreateGroupName"
	/// English String: "Name your group"
	/// </summary>
	public override string LabelCreateGroupName => "Dê um nome para seu grupo";

	/// <summary>
	/// Key: "Label.CreateGroupPremiumTooltip"
	/// English String: "Creating a group requires a Roblox Premium membership."
	/// </summary>
	public override string LabelCreateGroupPremiumTooltip => "Criar um grupo requer ser membro do Roblox Premium.";

	/// <summary>
	/// Key: "Label.CreateGroupTooltip"
	/// English String: "Create a new group"
	/// </summary>
	public override string LabelCreateGroupTooltip => "Criar um novo grupo";

	/// <summary>
	/// Key: "Label.CreateItems"
	/// English String: "Create Items"
	/// </summary>
	public override string LabelCreateItems => "Criar itens";

	/// <summary>
	/// Key: "Label.DeclineAllyRequest"
	/// English String: "Decline Ally Request"
	/// </summary>
	public override string LabelDeclineAllyRequest => "Recusar pedido de aliança";

	/// <summary>
	/// Key: "Label.DeclineJoinRequest"
	/// English String: "Decline Join Request"
	/// </summary>
	public override string LabelDeclineJoinRequest => "Recusar pedido de entrada";

	/// <summary>
	/// Key: "Label.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string LabelDelete => "Excluir";

	/// <summary>
	/// Key: "Label.DeleteAllPostsByUser"
	/// English String: "Also delete all posts by this user."
	/// </summary>
	public override string LabelDeleteAllPostsByUser => "Também excluir todas as publicações.";

	/// <summary>
	/// Key: "Label.DeleteAlly"
	/// English String: "Delete Ally"
	/// </summary>
	public override string LabelDeleteAlly => "Excluir aliado";

	/// <summary>
	/// Key: "Label.DeleteEnemy"
	/// English String: "Delete Enemy"
	/// </summary>
	public override string LabelDeleteEnemy => "Excluir inimigo";

	/// <summary>
	/// Key: "Label.DeleteGroupPlace"
	/// English String: "Delete Group Place"
	/// </summary>
	public override string LabelDeleteGroupPlace => "Excluir local do grupo";

	/// <summary>
	/// Key: "Label.DeletePost"
	/// English String: "Delete Post"
	/// </summary>
	public override string LabelDeletePost => "Excluir publicação";

	/// <summary>
	/// Key: "Label.Funds"
	/// English String: "Funds"
	/// </summary>
	public override string LabelFunds => "Fundos";

	/// <summary>
	/// Key: "Label.GroupClosed"
	/// English String: "Group Closed"
	/// </summary>
	public override string LabelGroupClosed => "Grupo fechado";

	/// <summary>
	/// Key: "Label.GroupLocked"
	/// English String: "This group has been locked"
	/// </summary>
	public override string LabelGroupLocked => "Este grupo foi bloqueado";

	/// <summary>
	/// Key: "Label.InviteToClan"
	/// English String: "Invite to Clan"
	/// </summary>
	public override string LabelInviteToClan => "Convidar para o clã";

	/// <summary>
	/// Key: "Label.KickFromClan"
	/// English String: "Kick from Clan"
	/// </summary>
	public override string LabelKickFromClan => "Expulsar do clã";

	/// <summary>
	/// Key: "Label.Loading"
	/// English String: "Loading..."
	/// </summary>
	public override string LabelLoading => "Carregando...";

	/// <summary>
	/// Key: "Label.Lock"
	/// English String: "Lock"
	/// </summary>
	public override string LabelLock => "Travar";

	/// <summary>
	/// Key: "Label.ManageGroupCreations"
	/// English String: "Create or manage group items."
	/// </summary>
	public override string LabelManageGroupCreations => "Criar ou gerenciar itens de grupo.";

	/// <summary>
	/// Key: "Label.ManualApproval"
	/// English String: "Manual Approval"
	/// </summary>
	public override string LabelManualApproval => "Aprovação manual";

	/// <summary>
	/// Key: "Label.ModerateDiscussion"
	/// English String: "Moderate Discussion"
	/// </summary>
	public override string LabelModerateDiscussion => "Moderar discussão";

	/// <summary>
	/// Key: "Label.NoAllies"
	/// English String: "This group does not have any allies."
	/// </summary>
	public override string LabelNoAllies => "Este grupo não possui nenhum aliado.";

	/// <summary>
	/// Key: "Label.NoEnemies"
	/// English String: "This group does not have any enemies."
	/// </summary>
	public override string LabelNoEnemies => "Este grupo não possui nenhum inimigo.";

	/// <summary>
	/// Key: "Label.NoGames"
	/// English String: "No games are associated with this group."
	/// </summary>
	public override string LabelNoGames => "Nenhum jogo está associado com este grupo.";

	/// <summary>
	/// Key: "Label.NoMembersInRole"
	/// English String: "No group members are in this role."
	/// </summary>
	public override string LabelNoMembersInRole => "Nenhum membro de grupo está nesta função.";

	/// <summary>
	/// Key: "Label.NoOne"
	/// English String: "No One!"
	/// </summary>
	public override string LabelNoOne => "Ninguém!";

	/// <summary>
	/// Key: "Label.NoStoreItems"
	/// English String: "No items are for sale in this group."
	/// </summary>
	public override string LabelNoStoreItems => "Nenhum item está à venda neste grupo.";

	/// <summary>
	/// Key: "Label.NoWallPosts"
	/// English String: "Nobody has said anything yet..."
	/// </summary>
	public override string LabelNoWallPosts => "Ninguém disse nada ainda...";

	/// <summary>
	/// Key: "Label.OnlyBcCanJoin"
	/// English String: "Only Builders Club members can join"
	/// </summary>
	public override string LabelOnlyBcCanJoin => "Apenas assinantes do Builders Club podem entrar";

	/// <summary>
	/// Key: "Label.OnlyPremiumCanJoin"
	/// English String: "Only users with membership can join"
	/// </summary>
	public override string LabelOnlyPremiumCanJoin => "Apenas usuários afiliados podem entrar";

	/// <summary>
	/// Key: "Label.PrivateGroup"
	/// If group is invite only
	/// English String: "Private"
	/// </summary>
	public override string LabelPrivateGroup => "Privado";

	/// <summary>
	/// Key: "Label.PublicGroup"
	/// If group is open for anyone to join
	/// English String: "Public"
	/// </summary>
	public override string LabelPublicGroup => "Público";

	/// <summary>
	/// Key: "Label.PublishPlace"
	/// English String: "Publish Place"
	/// </summary>
	public override string LabelPublishPlace => "Publicar local";

	/// <summary>
	/// Key: "Label.RemoveGroupPlace"
	/// English String: "Remove Group Place"
	/// </summary>
	public override string LabelRemoveGroupPlace => "Remover local do grupo";

	/// <summary>
	/// Key: "Label.RemoveMember"
	/// English String: "Remove Member"
	/// </summary>
	public override string LabelRemoveMember => "Remover membro";

	/// <summary>
	/// Key: "Label.Rename"
	/// English String: "Rename"
	/// </summary>
	public override string LabelRename => "Renomear";

	/// <summary>
	/// Key: "Label.RevertGroupAsset"
	/// English String: "Revert Group Asset"
	/// </summary>
	public override string LabelRevertGroupAsset => "Remover elemento do grupo";

	/// <summary>
	/// Key: "Label.SavePlace"
	/// English String: "Save Place"
	/// </summary>
	public override string LabelSavePlace => "Salvar local";

	/// <summary>
	/// Key: "Label.SearchGroups"
	/// English String: "Search All Groups"
	/// </summary>
	public override string LabelSearchGroups => "Pesquisar em todos os grupos";

	/// <summary>
	/// Key: "Label.SearchUsers"
	/// English String: "Search Users"
	/// </summary>
	public override string LabelSearchUsers => "Buscar usuários";

	/// <summary>
	/// Key: "Label.SendAllyRequest"
	/// English String: "Send Ally Request"
	/// </summary>
	public override string LabelSendAllyRequest => "Enviar pedido de aliança";

	/// <summary>
	/// Key: "Label.ShoutPlaceholder"
	/// English String: "Enter your shout"
	/// </summary>
	public override string LabelShoutPlaceholder => "Insira seu anúncio";

	/// <summary>
	/// Key: "Label.SpendGroupFunds"
	/// English String: "Spend Group Funds"
	/// </summary>
	public override string LabelSpendGroupFunds => "Gastar fundos do grupo";

	/// <summary>
	/// Key: "Label.Success"
	/// English String: "Success"
	/// </summary>
	public override string LabelSuccess => "Sucesso";

	/// <summary>
	/// Key: "Label.Unlock"
	/// English String: "Unlock"
	/// </summary>
	public override string LabelUnlock => "Destravar";

	/// <summary>
	/// Key: "Label.UpdateGroupAsset"
	/// English String: "Update Group Asset"
	/// </summary>
	public override string LabelUpdateGroupAsset => "Atualizar elemento do grupo";

	/// <summary>
	/// Key: "Label.WallPostPlaceholder"
	/// English String: "Say something..."
	/// </summary>
	public override string LabelWallPostPlaceholder => "Diga algo...";

	/// <summary>
	/// Key: "Label.WallPostsUnavailable"
	/// Displayed in the group wall area when we cannot successfully load wall posts
	/// English String: "Wall posts are temporarily unavailable, please check back later."
	/// </summary>
	public override string LabelWallPostsUnavailable => "Publicações no mural temporariamente indisponíveis. Confira de novo mais tarde.";

	/// <summary>
	/// Key: "Label.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string LabelWarning => "Aviso";

	/// <summary>
	/// Key: "Message.AlreadyMember"
	/// English String: "You are already a member of this group."
	/// </summary>
	public override string MessageAlreadyMember => "Você já é membro deste grupo.";

	/// <summary>
	/// Key: "Message.AlreadyRequested"
	/// English String: "You have already requested to join this group."
	/// </summary>
	public override string MessageAlreadyRequested => "Você já solicitou a entrada neste grupo.";

	/// <summary>
	/// Key: "Message.BuildGroupRolesListError"
	/// English String: "Unable to load members for selected role."
	/// </summary>
	public override string MessageBuildGroupRolesListError => "Impossível carregar membros da função selecionada.";

	/// <summary>
	/// Key: "Message.CannotClaimGroupWithOwner"
	/// English String: "This group already has an owner."
	/// </summary>
	public override string MessageCannotClaimGroupWithOwner => "Este grupo já tem um dono.";

	/// <summary>
	/// Key: "Message.ChangeOwnerEmpty"
	/// English String: "There is no owner of the group"
	/// </summary>
	public override string MessageChangeOwnerEmpty => "O grupo não tem dono";

	/// <summary>
	/// Key: "Message.ClaimOwnershipError"
	/// English String: "Unable to claim ownership of group."
	/// </summary>
	public override string MessageClaimOwnershipError => "Impossível assumir propriedade do grupo.";

	/// <summary>
	/// Key: "Message.ClaimOwnershipSuccess"
	/// English String: "Successfully claimed ownership of group."
	/// </summary>
	public override string MessageClaimOwnershipSuccess => "Propriedade do grupo assumida com sucesso.";

	/// <summary>
	/// Key: "Message.DefaultError"
	/// English String: "An error occurred."
	/// </summary>
	public override string MessageDefaultError => "Ocorreu um erro.";

	/// <summary>
	/// Key: "Message.DeleteWallPostError"
	/// English String: "Unable to delete wall post."
	/// </summary>
	public override string MessageDeleteWallPostError => "Impossível excluir publicação do mural.";

	/// <summary>
	/// Key: "Message.DeleteWallPostsByUserError"
	/// English String: "Unable to delete wall posts by user."
	/// </summary>
	public override string MessageDeleteWallPostsByUserError => "Impossível excluir publicações do mural do usuário.";

	/// <summary>
	/// Key: "Message.DeleteWallPostSuccess"
	/// English String: "Successfully deleted wall post."
	/// </summary>
	public override string MessageDeleteWallPostSuccess => "Publicação do mural excluída com sucesso.";

	/// <summary>
	/// Key: "Message.DescriptionTooLong"
	/// English String: "The description is too long."
	/// </summary>
	public override string MessageDescriptionTooLong => "A descrição é longa demais.";

	/// <summary>
	/// Key: "Message.DuplicateName"
	/// English String: "Name is already taken. Please try another."
	/// </summary>
	public override string MessageDuplicateName => "Este nome já está sendo usado. Tente outro.";

	/// <summary>
	/// Key: "Message.ExileUserError"
	/// English String: "Unable to exile user."
	/// </summary>
	public override string MessageExileUserError => "Impossível exilar usuário.";

	/// <summary>
	/// Key: "Message.FeatureDisabled"
	/// English String: "The feature is disabled."
	/// </summary>
	public override string MessageFeatureDisabled => "Esta funcionalidade está desabilitada.";

	/// <summary>
	/// Key: "Message.GetGroupRelationshipsError"
	/// English String: "Unable to load group affiliates."
	/// </summary>
	public override string MessageGetGroupRelationshipsError => "Impossível carregar afiliados de grupo.";

	/// <summary>
	/// Key: "Message.GroupClosed"
	/// English String: "You cannot join a closed group."
	/// </summary>
	public override string MessageGroupClosed => "Você não pode entrar em um grupo fechado.";

	/// <summary>
	/// Key: "Message.GroupCreationDisabled"
	/// English String: "Group creation is currently disabled."
	/// </summary>
	public override string MessageGroupCreationDisabled => "A criação de grupo está desabilitada no momento.";

	/// <summary>
	/// Key: "Message.GroupIconInvalid"
	/// English String: "Icon is missing or invalid."
	/// </summary>
	public override string MessageGroupIconInvalid => "Ícone ausente ou inválido.";

	/// <summary>
	/// Key: "Message.GroupMembershipsUnavailableError"
	/// Error displayed on group details view when the system is in read-only mode for maintenance and you try to perform an action.
	/// English String: "The group membership system is temporarily unavailable. Please try again later."
	/// </summary>
	public override string MessageGroupMembershipsUnavailableError => "O sistema de afiliação ao grupo não está disponível no momento. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.InsufficientFunds"
	/// English String: "Insufficient Robux funds."
	/// </summary>
	public override string MessageInsufficientFunds => "Fundos de Robux insuficientes.";

	/// <summary>
	/// Key: "Message.InsufficientGroupSpace"
	/// English String: "You are already in the maximum number of groups."
	/// </summary>
	public override string MessageInsufficientGroupSpace => "Você já entrou no número máximo de grupos.";

	/// <summary>
	/// Key: "Message.InsufficientMembership"
	/// English String: "You do not have the builders club membership necessary to join this group."
	/// </summary>
	public override string MessageInsufficientMembership => "Você não tem a assinatura do builders club necessária para entrar neste grupo.";

	/// <summary>
	/// Key: "Message.InsufficientPermission"
	/// English String: "Insufficient permissions to complete the request."
	/// </summary>
	public override string MessageInsufficientPermission => "Permissão insuficiente para completar a solicitação.";

	/// <summary>
	/// Key: "Message.InsufficientPermissionsForRelationships"
	/// English String: "You don't have permission to manage this group's relationships."
	/// </summary>
	public override string MessageInsufficientPermissionsForRelationships => "Você não tem permissão para gerenciar as relações deste grupo.";

	/// <summary>
	/// Key: "Message.InsufficientRobux"
	/// English String: "You do not have enough Robux to create the group."
	/// </summary>
	public override string MessageInsufficientRobux => "Você não tem Robux o bastante para criar o grupo.";

	/// <summary>
	/// Key: "Message.InvalidAmount"
	/// English String: "The amount is invalid."
	/// </summary>
	public override string MessageInvalidAmount => "Quantidade inválida.";

	/// <summary>
	/// Key: "Message.InvalidGroup"
	/// English String: "Group is invalid or does not exist."
	/// </summary>
	public override string MessageInvalidGroup => "O grupo é inválido ou não existe.";

	/// <summary>
	/// Key: "Message.InvalidGroupIcon"
	/// English String: "The group icon is invalid."
	/// </summary>
	public override string MessageInvalidGroupIcon => "O ícone do grupo é inválido.";

	/// <summary>
	/// Key: "Message.InvalidGroupId"
	/// English String: "The group is invalid or does not exist."
	/// </summary>
	public override string MessageInvalidGroupId => "O grupo é inválido ou não existe.";

	/// <summary>
	/// Key: "Message.InvalidGroupWallPostId"
	/// English String: "The group wall post id is invalid or does not exist."
	/// </summary>
	public override string MessageInvalidGroupWallPostId => "O mural do grupo é inválido ou não existe.";

	/// <summary>
	/// Key: "Message.InvalidIds"
	/// English String: "Ids could not be parsed from request."
	/// </summary>
	public override string MessageInvalidIds => "As IDs não puderam ser interpretadas na solicitação.";

	/// <summary>
	/// Key: "Message.InvalidIdsError"
	/// English String: "Ids could not be parsed from request."
	/// </summary>
	public override string MessageInvalidIdsError => "As IDs não puderam ser interpretadas na solicitação.";

	/// <summary>
	/// Key: "Message.InvalidMembership"
	/// English String: "User must have builders club membership."
	/// </summary>
	public override string MessageInvalidMembership => "O usuário precisa ter uma assinatura do builders club.";

	/// <summary>
	/// Key: "Message.InvalidName"
	/// English String: "The name is invalid."
	/// </summary>
	public override string MessageInvalidName => "O nome é inválido.";

	/// <summary>
	/// Key: "Message.InvalidPaginationParameters"
	/// English String: "Invalid or missing pagination parameters."
	/// </summary>
	public override string MessageInvalidPaginationParameters => "Parâmetros de paginação inválidos ou faltando.";

	/// <summary>
	/// Key: "Message.InvalidPayoutType"
	/// English String: "Invalid payout type."
	/// </summary>
	public override string MessageInvalidPayoutType => "Tipo de pagamento inválido.";

	/// <summary>
	/// Key: "Message.InvalidRecipient"
	/// English String: "The recipient is invalid."
	/// </summary>
	public override string MessageInvalidRecipient => "Destinatário inválido.";

	/// <summary>
	/// Key: "Message.InvalidRelationshipType"
	/// English String: "Group relationship type is invalid."
	/// </summary>
	public override string MessageInvalidRelationshipType => "Tipo de relação de grupo inválido.";

	/// <summary>
	/// Key: "Message.InvalidRoleSetId"
	/// English String: "The roleset is invalid or does not exist."
	/// </summary>
	public override string MessageInvalidRoleSetId => "O conjunto de funções é inválido ou não existe.";

	/// <summary>
	/// Key: "Message.InvalidUser"
	/// English String: "The user is invalid or does not exist."
	/// </summary>
	public override string MessageInvalidUser => "O usuário é inválido ou não existe.";

	/// <summary>
	/// Key: "Message.InvalidWallPostContent"
	/// English String: "Your post was empty, white space, or more than 500 characters."
	/// </summary>
	public override string MessageInvalidWallPostContent => "Sua publicação estava vazia, com espaços em branco ou mais de 500 caracteres.";

	/// <summary>
	/// Key: "Message.JoinGroupError"
	/// English String: "Unable to join group."
	/// </summary>
	public override string MessageJoinGroupError => "Impossível entrar no grupo.";

	/// <summary>
	/// Key: "Message.JoinGroupPendingSuccess"
	/// English String: "Requested to join group, your request is pending."
	/// </summary>
	public override string MessageJoinGroupPendingSuccess => "Pediu para entrar no grupo. Seu pedido está pendente.";

	/// <summary>
	/// Key: "Message.JoinGroupSuccess"
	/// English String: "Successfully joined the group."
	/// </summary>
	public override string MessageJoinGroupSuccess => "Entrada no grupo realizada com sucesso.";

	/// <summary>
	/// Key: "Message.LeaveGroupError"
	/// English String: "Unable to leave group."
	/// </summary>
	public override string MessageLeaveGroupError => "Impossível sair do grupo.";

	/// <summary>
	/// Key: "Message.LoadGroupError"
	/// English String: "Unable to load group."
	/// </summary>
	public override string MessageLoadGroupError => "Impossível carregar grupo.";

	/// <summary>
	/// Key: "Message.LoadGroupGamesError"
	/// English String: "Unable to load games."
	/// </summary>
	public override string MessageLoadGroupGamesError => "Impossível carregar jogos.";

	/// <summary>
	/// Key: "Message.LoadGroupListError"
	/// English String: "Unable to load group list."
	/// </summary>
	public override string MessageLoadGroupListError => "Não foi possível carregar a lista de grupos.";

	/// <summary>
	/// Key: "Message.LoadGroupMembershipsError"
	/// English String: "Unable to load user membership information."
	/// </summary>
	public override string MessageLoadGroupMembershipsError => "Impossível carregar informações de assinatura de usuário.";

	/// <summary>
	/// Key: "Message.LoadGroupMetadataError"
	/// English String: "Unable to load group info."
	/// </summary>
	public override string MessageLoadGroupMetadataError => "Impossível carregar informações de grupo.";

	/// <summary>
	/// Key: "Message.LoadGroupStoreItemsError"
	/// English String: "Unable to load store items."
	/// </summary>
	public override string MessageLoadGroupStoreItemsError => "Impossível carregar itens da loja.";

	/// <summary>
	/// Key: "Message.LoadUserGroupMembershipError"
	/// English String: "Unable to load group member information."
	/// </summary>
	public override string MessageLoadUserGroupMembershipError => "Impossível carregar informações de membro do grupo.";

	/// <summary>
	/// Key: "Message.LoadWallPostsError"
	/// English String: "Unable to load wall posts."
	/// </summary>
	public override string MessageLoadWallPostsError => "Impossível carregar publicações do mural.";

	/// <summary>
	/// Key: "Message.MakePrimaryError"
	/// English String: "Unable to make primary group."
	/// </summary>
	public override string MessageMakePrimaryError => "Habilite para tornar grupo principal.";

	/// <summary>
	/// Key: "Message.MaxGroups"
	/// English String: "User is in maximum number of groups."
	/// </summary>
	public override string MessageMaxGroups => "O usuário entrou no número máximo de grupos.";

	/// <summary>
	/// Key: "Message.MissingGroupIcon"
	/// English String: "The group icon is missing from the request."
	/// </summary>
	public override string MessageMissingGroupIcon => "O ícone do grupo está faltando na solicitação.";

	/// <summary>
	/// Key: "Message.MissingGroupStatusContent"
	/// English String: "Missing group status content."
	/// </summary>
	public override string MessageMissingGroupStatusContent => "Faltando conteúdo de status do grupo.";

	/// <summary>
	/// Key: "Message.NameInvalid"
	/// English String: "Name is missing or has invalid characters."
	/// </summary>
	public override string MessageNameInvalid => "Nome ausente ou contém caracteres inválidos.";

	/// <summary>
	/// Key: "Message.NameModerated"
	/// English String: "The name is moderated."
	/// </summary>
	public override string MessageNameModerated => "O nome é moderado.";

	/// <summary>
	/// Key: "Message.NameTaken"
	/// English String: "The name has been taken."
	/// </summary>
	public override string MessageNameTaken => "O nome já está sendo usado.";

	/// <summary>
	/// Key: "Message.NameTooLong"
	/// English String: "The name is too long."
	/// </summary>
	public override string MessageNameTooLong => "O nome é comprido demais.";

	/// <summary>
	/// Key: "Message.NoPrimary"
	/// English String: "The user specified does not have a primary group."
	/// </summary>
	public override string MessageNoPrimary => "O usuário especificado não tem um grupo principal.";

	/// <summary>
	/// Key: "Message.PassCaptchaToJoin"
	/// English String: "You must pass the captcha test before joining this group."
	/// </summary>
	public override string MessagePassCaptchaToJoin => "Você precisa passar no teste captcha para entrar neste grupo.";

	/// <summary>
	/// Key: "Message.PassCaptchaToPost"
	/// English String: "Captcha must be solved to post to the group wall."
	/// </summary>
	public override string MessagePassCaptchaToPost => "O teste captcha deve ser solucionado para que você possa publicar no mural do grupo.";

	/// <summary>
	/// Key: "Message.RemovePrimaryError"
	/// English String: "Unable to remove primary group."
	/// </summary>
	public override string MessageRemovePrimaryError => "Habilite para remover grupo principal.";

	/// <summary>
	/// Key: "Message.SearchTermCharactersLimit"
	/// English String: "The search term needs to be between 2 and 50 characters"
	/// </summary>
	public override string MessageSearchTermCharactersLimit => "O termo pesquisado deve conter entre 2 e 50 caracteres";

	/// <summary>
	/// Key: "Message.SearchTermEmptyError"
	/// English String: "Search term is empty"
	/// </summary>
	public override string MessageSearchTermEmptyError => "Não há termo a pesquisar";

	/// <summary>
	/// Key: "Message.SearchTermFilteredError"
	/// English String: "Search term was filtered"
	/// </summary>
	public override string MessageSearchTermFilteredError => "O termo pesquisado foi filtrado";

	/// <summary>
	/// Key: "Message.SendGroupShoutError"
	/// English String: "Unable to send group shout."
	/// </summary>
	public override string MessageSendGroupShoutError => "Impossível enviar anúncio de grupo.";

	/// <summary>
	/// Key: "Message.SendPostError"
	/// English String: "Unable to send post."
	/// </summary>
	public override string MessageSendPostError => "Impossível enviar publicação.";

	/// <summary>
	/// Key: "Message.TooManyAttempts"
	/// English String: "Too many attempts to join the group. Please try again later."
	/// </summary>
	public override string MessageTooManyAttempts => "Foram feitas muitas tentativas para entrar no grupo. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.TooManyAttemptsToClaimGroups"
	/// English String: "Too many attempts to claim groups. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsToClaimGroups => "Foram feitas muitas tentativas para reivindicar grupos. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.TooManyGroups"
	/// English String: "You have reached the group capacity. Please leave a group before creating a new one."
	/// </summary>
	public override string MessageTooManyGroups => "Você alcançou o limite de grupos. Saia de um grupo antes de criar um novo.";

	/// <summary>
	/// Key: "Message.TooManyIds"
	/// English String: "Too many ids in request."
	/// </summary>
	public override string MessageTooManyIds => "IDs excessivas na solicitação.";

	/// <summary>
	/// Key: "Message.TooManyPosts"
	/// English String: "You are posting too fast, please try again in a few minutes."
	/// </summary>
	public override string MessageTooManyPosts => "Você está publicando rápido demais. Tente novamente em alguns minutos.";

	/// <summary>
	/// Key: "Message.TooManyRequests"
	/// English String: "Too many requests."
	/// </summary>
	public override string MessageTooManyRequests => "Excesso de solicitações.";

	/// <summary>
	/// Key: "Message.UnauthorizedForPostStatus"
	/// English String: "You are not authorized to set the status of this group."
	/// </summary>
	public override string MessageUnauthorizedForPostStatus => "Você não tem autorização para definir o status deste grupo.";

	/// <summary>
	/// Key: "Message.UnauthorizedForViewGroupPayouts"
	/// English String: "You don't have permission to view this group's payouts."
	/// </summary>
	public override string MessageUnauthorizedForViewGroupPayouts => "Você não tem permissão para ver estes pagamentos de grupo.";

	/// <summary>
	/// Key: "Message.UnauthorizedToClaimGroup"
	/// English String: "You are not authorized to claim this group."
	/// </summary>
	public override string MessageUnauthorizedToClaimGroup => "Você não tem autorização para reivindicar este grupo.";

	/// <summary>
	/// Key: "Message.UnauthorizedToManageMember"
	/// English String: "You do not have permission to manage this member."
	/// </summary>
	public override string MessageUnauthorizedToManageMember => "Você não tem permissão para gerenciar este membro.";

	/// <summary>
	/// Key: "Message.UnauthorizedToViewRolesetPermissions"
	/// English String: "You are not authorized to view permissions for this roleset."
	/// </summary>
	public override string MessageUnauthorizedToViewRolesetPermissions => "Você não tem autorização para ver as permissões deste conjunto de funções.";

	/// <summary>
	/// Key: "Message.UnauthorizedToViewWall"
	/// English String: "You do not have permission to access this group wall."
	/// </summary>
	public override string MessageUnauthorizedToViewWall => "Você não tem permissão para acessar este mural do grupo.";

	/// <summary>
	/// Key: "Message.UnknownError"
	/// English String: "Unknown error"
	/// </summary>
	public override string MessageUnknownError => "Erro desconhecido";

	/// <summary>
	/// Key: "Message.UserNotInGroup"
	/// English String: "You aren't a member of the group specified."
	/// </summary>
	public override string MessageUserNotInGroup => "Você não é membro do grupo especificado.";

	public GroupsResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdvertiseGroup()
	{
		return "Anunciar grupo";
	}

	protected override string _GetTemplateForActionAuditLog()
	{
		return "Auditar histórico";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionCancelRequest()
	{
		return "Cancelar pedido";
	}

	protected override string _GetTemplateForActionClaimOwnership()
	{
		return "Receber propriedade";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Fechar";
	}

	protected override string _GetTemplateForActionConfigureGroup()
	{
		return "Configurar grupo";
	}

	protected override string _GetTemplateForActionCreateGroup()
	{
		return "Criar grupo";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Excluir";
	}

	protected override string _GetTemplateForActionExile()
	{
		return "Exilar";
	}

	protected override string _GetTemplateForActionExileUser()
	{
		return "Exilar usuário";
	}

	protected override string _GetTemplateForActionGroupAdmin()
	{
		return "Administrador do grupo";
	}

	protected override string _GetTemplateForActionGroupShout()
	{
		return "Anúncio de grupo";
	}

	protected override string _GetTemplateForActionJoinGroup()
	{
		return "Entrar no grupo";
	}

	protected override string _GetTemplateForActionLeaveGroup()
	{
		return "Sair do grupo";
	}

	protected override string _GetTemplateForActionMakePrimary()
	{
		return "Tornar principal";
	}

	protected override string _GetTemplateForActionMakePrimaryGroup()
	{
		return "Tornar grupo principal";
	}

	protected override string _GetTemplateForActionPost()
	{
		return "Publicar";
	}

	protected override string _GetTemplateForActionPurchase()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionRemovePrimary()
	{
		return "Remover principal";
	}

	protected override string _GetTemplateForActionReport()
	{
		return "Denunciar";
	}

	protected override string _GetTemplateForActionReportAbuse()
	{
		return "Denunciar abuso";
	}

	protected override string _GetTemplateForActionUpgrade()
	{
		return "Upgrade";
	}

	protected override string _GetTemplateForActionUpgradeToJoin()
	{
		return "Faça o upgrade para entrar";
	}

	protected override string _GetTemplateForActionYes()
	{
		return "Sim";
	}

	protected override string _GetTemplateForDescriptionClothingRevenue()
	{
		return "Grupos possuem a habilidade de criar e vender camisas, calças e camisetas oficiais! Toda a renda vai para os fundos do grupo.";
	}

	protected override string _GetTemplateForDescriptionDeleteAllPostsByUser()
	{
		return "Excluir também todas as publicações deste usuário.";
	}

	protected override string _GetTemplateForDescriptionExileUserWarning()
	{
		return "Quer mesmo exilar este usuário?";
	}

	protected override string _GetTemplateForDescriptionLeaveGroupAsOwnerWarning()
	{
		return "Isto fará com que o grupo fique sem dono.";
	}

	protected override string _GetTemplateForDescriptionLeaveGroupWarning()
	{
		return "Quer mesmo sair deste grupo?";
	}

	protected override string _GetTemplateForDescriptionMakePrimaryGroupWarning()
	{
		return "Quer mesmo tornar este grupo o seu grupo principal?";
	}

	protected override string _GetTemplateForDescriptionNoneMaxGroups()
	{
		return "Faça o upgrade para Builders Club para entrar em mais grupos.";
	}

	protected override string _GetTemplateForDescriptionNoneMaxGroupsPremium()
	{
		return "Faça o upgrade para Roblox Premium para entrar em mais grupos.";
	}

	protected override string _GetTemplateForDescriptionnoneMaxGroupsPremiumText()
	{
		return "Faça o upgrade para Roblox Premium para entrar em mais grupos.";
	}

	protected override string _GetTemplateForDescriptionObcMaxGroups()
	{
		return "Você entrou no número máximo de grupos.";
	}

	protected override string _GetTemplateForDescriptionOtherBcMaxGroups()
	{
		return "Faça o upgrade do seu Builders Club para entrar em mais grupos.";
	}

	protected override string _GetTemplateForDescriptionotherPremiumMaxGroupsText()
	{
		return "Faça o upgrade do seu Roblox Premium para entrar em mais grupos.";
	}

	protected override string _GetTemplateForDescriptionPremiumMaxGroups()
	{
		return "Você entrou no número máximo de grupos.";
	}

	protected override string _GetTemplateForDescriptionPurchaseBody()
	{
		return "Deseja criar este grupo por";
	}

	protected override string _GetTemplateForDescriptionRemovePrimaryGroupWarning()
	{
		return "Quer mesmo remover seu grupo principal?";
	}

	protected override string _GetTemplateForDescriptionReportAbuseDescription()
	{
		return "Deseja denunciar?";
	}

	protected override string _GetTemplateForDescriptionWallPrivacySettings()
	{
		return "Suas configurações de privacidade não permitem que você publique em murais de grupo. Clique aqui para ajustar estas configurações.";
	}

	protected override string _GetTemplateForHeadingAbout()
	{
		return "Sobre";
	}

	protected override string _GetTemplateForHeadingAffiliates()
	{
		return "Afiliados";
	}

	protected override string _GetTemplateForHeadingAllies()
	{
		return "Aliados";
	}

	/// <summary>
	/// Key: "Heading.ConfigureGroup"
	/// English String: "Configure {groupName}"
	/// </summary>
	public override string HeadingConfigureGroup(string groupName)
	{
		return $"Configurar {groupName}";
	}

	protected override string _GetTemplateForHeadingConfigureGroup()
	{
		return "Configurar {groupName}";
	}

	protected override string _GetTemplateForHeadingDate()
	{
		return "Data";
	}

	protected override string _GetTemplateForHeadingDescription()
	{
		return "Descrição";
	}

	protected override string _GetTemplateForHeadingEnemies()
	{
		return "Inimigos";
	}

	protected override string _GetTemplateForHeadingExileUserWarning()
	{
		return "Aviso";
	}

	protected override string _GetTemplateForHeadingFunds()
	{
		return "Fundos";
	}

	protected override string _GetTemplateForHeadingGames()
	{
		return "Jogos";
	}

	protected override string _GetTemplateForHeadingGroupPurchase()
	{
		return "Confirmação da compra de grupo";
	}

	protected override string _GetTemplateForHeadingGroupShout()
	{
		return "Anúncio de grupo";
	}

	protected override string _GetTemplateForHeadingLeaveGroup()
	{
		return "Sair do grupo";
	}

	protected override string _GetTemplateForHeadingMakePrimaryGroup()
	{
		return "Tornar grupo principal";
	}

	protected override string _GetTemplateForHeadingMembers()
	{
		return "Membros";
	}

	protected override string _GetTemplateForHeadingNameOrDescription()
	{
		return "Nome ou descrição";
	}

	protected override string _GetTemplateForHeadingPayouts()
	{
		return "Pagamentos";
	}

	protected override string _GetTemplateForHeadingPrimary()
	{
		return "Principal";
	}

	protected override string _GetTemplateForHeadingRank()
	{
		return "Ranque";
	}

	protected override string _GetTemplateForHeadingRemovePrimaryGroup()
	{
		return "Remover grupo principal";
	}

	protected override string _GetTemplateForHeadingRole()
	{
		return "Função";
	}

	protected override string _GetTemplateForHeadingSettings()
	{
		return "Configurações";
	}

	protected override string _GetTemplateForHeadingShout()
	{
		return "Anunciar";
	}

	protected override string _GetTemplateForHeadingStore()
	{
		return "Loja";
	}

	protected override string _GetTemplateForHeadingUser()
	{
		return "Usuário";
	}

	protected override string _GetTemplateForHeadingWall()
	{
		return "Mural";
	}

	protected override string _GetTemplateForLabelAbandon()
	{
		return "Abandonar";
	}

	protected override string _GetTemplateForLabelAcceptAllyRequest()
	{
		return "Aceitar pedido de aliança";
	}

	protected override string _GetTemplateForLabelAcceptJoinRequest()
	{
		return "Aceitar pedido de entrada";
	}

	protected override string _GetTemplateForLabelAddGroupPlace()
	{
		return "Adicionar local do grupo";
	}

	protected override string _GetTemplateForLabelAdjustCurrencyAmounts()
	{
		return "Ajustar valores de moeda";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Tudo";
	}

	protected override string _GetTemplateForLabelAnyoneCanJoin()
	{
		return "Qualquer um pode entrar";
	}

	protected override string _GetTemplateForLabelBuyAd()
	{
		return "Comprar publicidade";
	}

	protected override string _GetTemplateForLabelBuyClan()
	{
		return "Comprar clã";
	}

	protected override string _GetTemplateForLabelByOwner()
	{
		return "De";
	}

	protected override string _GetTemplateForLabelCancelClanInvite()
	{
		return "Cancelar o convite do clã";
	}

	protected override string _GetTemplateForLabelChangeDescription()
	{
		return "Alterar descrição";
	}

	protected override string _GetTemplateForLabelChangeOwner()
	{
		return "Alterar dono";
	}

	protected override string _GetTemplateForLabelChangeRank()
	{
		return "Alterar ranque";
	}

	protected override string _GetTemplateForLabelClaim()
	{
		return "Reivindicar";
	}

	protected override string _GetTemplateForLabelConfigureBadge()
	{
		return "Configurar emblema";
	}

	protected override string _GetTemplateForLabelConfigureGroupAsset()
	{
		return "Configurar elemento do grupo";
	}

	protected override string _GetTemplateForLabelConfigureGroupDevelopmentItem()
	{
		return "Configurar item de desenvolvimento do grupo";
	}

	protected override string _GetTemplateForLabelConfigureGroupGame()
	{
		return "Configurar jogo do grupo";
	}

	protected override string _GetTemplateForLabelConfigureItems()
	{
		return "Configurar itens";
	}

	protected override string _GetTemplateForLabelCreateBadge()
	{
		return "Criar emblema";
	}

	protected override string _GetTemplateForLabelCreateEnemy()
	{
		return "Criar inimigo";
	}

	protected override string _GetTemplateForLabelCreateGamePass()
	{
		return "Criar Passe de Jogo";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Criar grupo";
	}

	protected override string _GetTemplateForLabelCreateGroupAsset()
	{
		return "Criar elemento do grupo";
	}

	protected override string _GetTemplateForLabelCreateGroupBuildersClubTooltip()
	{
		return "Criar um grupo requer uma assinatura do Builders Club.";
	}

	protected override string _GetTemplateForLabelCreateGroupDescription()
	{
		return "Descrição (opcional)";
	}

	protected override string _GetTemplateForLabelCreateGroupDeveloperProduct()
	{
		return "Criar produto de desenvolvimento do grupo";
	}

	protected override string _GetTemplateForLabelCreateGroupEmblem()
	{
		return "Emblema";
	}

	protected override string _GetTemplateForLabelCreateGroupFee()
	{
		return "Taxa de criação de grupo";
	}

	protected override string _GetTemplateForLabelCreateGroupName()
	{
		return "Dê um nome para seu grupo";
	}

	protected override string _GetTemplateForLabelCreateGroupPremiumTooltip()
	{
		return "Criar um grupo requer ser membro do Roblox Premium.";
	}

	protected override string _GetTemplateForLabelCreateGroupTooltip()
	{
		return "Criar um novo grupo";
	}

	protected override string _GetTemplateForLabelCreateItems()
	{
		return "Criar itens";
	}

	protected override string _GetTemplateForLabelDeclineAllyRequest()
	{
		return "Recusar pedido de aliança";
	}

	protected override string _GetTemplateForLabelDeclineJoinRequest()
	{
		return "Recusar pedido de entrada";
	}

	protected override string _GetTemplateForLabelDelete()
	{
		return "Excluir";
	}

	protected override string _GetTemplateForLabelDeleteAllPostsByUser()
	{
		return "Também excluir todas as publicações.";
	}

	protected override string _GetTemplateForLabelDeleteAlly()
	{
		return "Excluir aliado";
	}

	protected override string _GetTemplateForLabelDeleteEnemy()
	{
		return "Excluir inimigo";
	}

	protected override string _GetTemplateForLabelDeleteGroupPlace()
	{
		return "Excluir local do grupo";
	}

	protected override string _GetTemplateForLabelDeletePost()
	{
		return "Excluir publicação";
	}

	protected override string _GetTemplateForLabelFunds()
	{
		return "Fundos";
	}

	protected override string _GetTemplateForLabelGroupClosed()
	{
		return "Grupo fechado";
	}

	protected override string _GetTemplateForLabelGroupLocked()
	{
		return "Este grupo foi bloqueado";
	}

	/// <summary>
	/// Key: "Label.GroupSearchResults"
	/// English String: "Group Results For {searchTerm}"
	/// </summary>
	public override string LabelGroupSearchResults(string searchTerm)
	{
		return $"Resultados de grupo para {searchTerm}";
	}

	protected override string _GetTemplateForLabelGroupSearchResults()
	{
		return "Resultados de grupo para {searchTerm}";
	}

	protected override string _GetTemplateForLabelInviteToClan()
	{
		return "Convidar para o clã";
	}

	protected override string _GetTemplateForLabelKickFromClan()
	{
		return "Expulsar do clã";
	}

	protected override string _GetTemplateForLabelLoading()
	{
		return "Carregando...";
	}

	protected override string _GetTemplateForLabelLock()
	{
		return "Travar";
	}

	protected override string _GetTemplateForLabelManageGroupCreations()
	{
		return "Criar ou gerenciar itens de grupo.";
	}

	protected override string _GetTemplateForLabelManualApproval()
	{
		return "Aprovação manual";
	}

	/// <summary>
	/// Key: "Label.MaxGroupsTooltip"
	/// English String: "You may only be in a maximum of {maxGroups} groups at one time"
	/// </summary>
	public override string LabelMaxGroupsTooltip(string maxGroups)
	{
		return $"Você só pode estar em um máximo de {maxGroups} grupos em um dado momento";
	}

	protected override string _GetTemplateForLabelMaxGroupsTooltip()
	{
		return "Você só pode estar em um máximo de {maxGroups} grupos em um dado momento";
	}

	protected override string _GetTemplateForLabelMembers()
	{
		return "{memberCount, plural, =0 {# Members} =1 {# Member} other {# Members}}";
	}

	protected override string _GetTemplateForLabelModerateDiscussion()
	{
		return "Moderar discussão";
	}

	protected override string _GetTemplateForLabelNoAllies()
	{
		return "Este grupo não possui nenhum aliado.";
	}

	protected override string _GetTemplateForLabelNoEnemies()
	{
		return "Este grupo não possui nenhum inimigo.";
	}

	protected override string _GetTemplateForLabelNoGames()
	{
		return "Nenhum jogo está associado com este grupo.";
	}

	protected override string _GetTemplateForLabelNoMembersInRole()
	{
		return "Nenhum membro de grupo está nesta função.";
	}

	protected override string _GetTemplateForLabelNoOne()
	{
		return "Ninguém!";
	}

	/// <summary>
	/// Key: "Label.NoResults"
	/// English String: "No results for \"{searchTerm}\""
	/// </summary>
	public override string LabelNoResults(string searchTerm)
	{
		return $"Sem resultados para \"{searchTerm}\"";
	}

	protected override string _GetTemplateForLabelNoResults()
	{
		return "Sem resultados para \"{searchTerm}\"";
	}

	protected override string _GetTemplateForLabelNoStoreItems()
	{
		return "Nenhum item está à venda neste grupo.";
	}

	protected override string _GetTemplateForLabelNoWallPosts()
	{
		return "Ninguém disse nada ainda...";
	}

	protected override string _GetTemplateForLabelOnlyBcCanJoin()
	{
		return "Apenas assinantes do Builders Club podem entrar";
	}

	protected override string _GetTemplateForLabelOnlyPremiumCanJoin()
	{
		return "Apenas usuários afiliados podem entrar";
	}

	protected override string _GetTemplateForLabelPrivateGroup()
	{
		return "Privado";
	}

	protected override string _GetTemplateForLabelPublicGroup()
	{
		return "Público";
	}

	protected override string _GetTemplateForLabelPublishPlace()
	{
		return "Publicar local";
	}

	protected override string _GetTemplateForLabelRemoveGroupPlace()
	{
		return "Remover local do grupo";
	}

	protected override string _GetTemplateForLabelRemoveMember()
	{
		return "Remover membro";
	}

	protected override string _GetTemplateForLabelRename()
	{
		return "Renomear";
	}

	protected override string _GetTemplateForLabelRevertGroupAsset()
	{
		return "Remover elemento do grupo";
	}

	protected override string _GetTemplateForLabelSavePlace()
	{
		return "Salvar local";
	}

	protected override string _GetTemplateForLabelSearchGroups()
	{
		return "Pesquisar em todos os grupos";
	}

	protected override string _GetTemplateForLabelSearchUsers()
	{
		return "Buscar usuários";
	}

	protected override string _GetTemplateForLabelSendAllyRequest()
	{
		return "Enviar pedido de aliança";
	}

	protected override string _GetTemplateForLabelShoutPlaceholder()
	{
		return "Insira seu anúncio";
	}

	protected override string _GetTemplateForLabelSpendGroupFunds()
	{
		return "Gastar fundos do grupo";
	}

	protected override string _GetTemplateForLabelSuccess()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForLabelUnlock()
	{
		return "Destravar";
	}

	protected override string _GetTemplateForLabelUpdateGroupAsset()
	{
		return "Atualizar elemento do grupo";
	}

	protected override string _GetTemplateForLabelWallPostPlaceholder()
	{
		return "Diga algo...";
	}

	protected override string _GetTemplateForLabelWallPostsUnavailable()
	{
		return "Publicações no mural temporariamente indisponíveis. Confira de novo mais tarde.";
	}

	protected override string _GetTemplateForLabelWarning()
	{
		return "Aviso";
	}

	/// <summary>
	/// Key: "Message.Abandon"
	/// English String: "{actor} (group owner) abandoned the group"
	/// </summary>
	public override string MessageAbandon(string actor)
	{
		return $"{actor} (dono do grupo) abandonou o grupo";
	}

	protected override string _GetTemplateForMessageAbandon()
	{
		return "{actor} (dono do grupo) abandonou o grupo";
	}

	/// <summary>
	/// Key: "Message.AcceptAllyRequest"
	/// English String: "{actor} accepted group {group}'s ally request"
	/// </summary>
	public override string MessageAcceptAllyRequest(string actor, string group)
	{
		return $"{actor} aceitou o pedido de aliança do grupo {group}";
	}

	protected override string _GetTemplateForMessageAcceptAllyRequest()
	{
		return "{actor} aceitou o pedido de aliança do grupo {group}";
	}

	/// <summary>
	/// Key: "Message.AcceptJoinRequest"
	/// English String: "{actor} accepted user {user}'s join request"
	/// </summary>
	public override string MessageAcceptJoinRequest(string actor, string user)
	{
		return $"{actor} aceitou o pedido de entrada do usuário {user}";
	}

	protected override string _GetTemplateForMessageAcceptJoinRequest()
	{
		return "{actor} aceitou o pedido de entrada do usuário {user}";
	}

	/// <summary>
	/// Key: "Message.AddGroupPlace"
	/// English String: "{actor} added game {game} as a group game"
	/// </summary>
	public override string MessageAddGroupPlace(string actor, string game)
	{
		return $"{actor} adicionou o jogo {game} como jogo do grupo";
	}

	protected override string _GetTemplateForMessageAddGroupPlace()
	{
		return "{actor} adicionou o jogo {game} como jogo do grupo";
	}

	/// <summary>
	/// Key: "Message.AdjustCurrencyAmountsDecreased"
	/// English String: "{actor} decreased group funds by {amount}"
	/// </summary>
	public override string MessageAdjustCurrencyAmountsDecreased(string actor, string amount)
	{
		return $"{actor} reduziu os fundos do grupo em {amount}";
	}

	protected override string _GetTemplateForMessageAdjustCurrencyAmountsDecreased()
	{
		return "{actor} reduziu os fundos do grupo em {amount}";
	}

	/// <summary>
	/// Key: "Message.AdjustCurrencyAmountsIncreased"
	/// English String: "{actor} increased group funds by {amount}"
	/// </summary>
	public override string MessageAdjustCurrencyAmountsIncreased(string actor, string amount)
	{
		return $"{actor} aumentou os fundos do grupo em {amount}";
	}

	protected override string _GetTemplateForMessageAdjustCurrencyAmountsIncreased()
	{
		return "{actor} aumentou os fundos do grupo em {amount}";
	}

	protected override string _GetTemplateForMessageAlreadyMember()
	{
		return "Você já é membro deste grupo.";
	}

	protected override string _GetTemplateForMessageAlreadyRequested()
	{
		return "Você já solicitou a entrada neste grupo.";
	}

	protected override string _GetTemplateForMessageBuildGroupRolesListError()
	{
		return "Impossível carregar membros da função selecionada.";
	}

	/// <summary>
	/// Key: "Message.BuyAd"
	/// English String: "{actor} bid {bid} on group ad {adName}"
	/// </summary>
	public override string MessageBuyAd(string actor, string bid, string adName)
	{
		return $"{actor} deu um lance de {bid} na publicidade {adName} do grupo";
	}

	protected override string _GetTemplateForMessageBuyAd()
	{
		return "{actor} deu um lance de {bid} na publicidade {adName} do grupo";
	}

	/// <summary>
	/// Key: "Message.BuyClan"
	/// English String: "{actor} bought a group clan"
	/// </summary>
	public override string MessageBuyClan(string actor)
	{
		return $"{actor} comprou um clã do grupo";
	}

	protected override string _GetTemplateForMessageBuyClan()
	{
		return "{actor} comprou um clã do grupo";
	}

	/// <summary>
	/// Key: "Message.CancelClanInvite"
	/// English String: "{actor} cancelled {user}'s clan invite"
	/// </summary>
	public override string MessageCancelClanInvite(string actor, string user)
	{
		return $"{actor} cancelou o convite de clã do usuário {user}";
	}

	protected override string _GetTemplateForMessageCancelClanInvite()
	{
		return "{actor} cancelou o convite de clã do usuário {user}";
	}

	protected override string _GetTemplateForMessageCannotClaimGroupWithOwner()
	{
		return "Este grupo já tem um dono.";
	}

	/// <summary>
	/// Key: "Message.ChangeDescription"
	/// English String: "{actor} changed the description to \"{newDescription}\""
	/// </summary>
	public override string MessageChangeDescription(string actor, string newDescription)
	{
		return $"{actor} alterou a descrição para \"{newDescription}\"";
	}

	protected override string _GetTemplateForMessageChangeDescription()
	{
		return "{actor} alterou a descrição para \"{newDescription}\"";
	}

	/// <summary>
	/// Key: "Message.ChangeOwner"
	/// English String: "{actor} changed the group owner. {user} is the new group owner"
	/// </summary>
	public override string MessageChangeOwner(string actor, string user)
	{
		return $"{actor} alterou o dono do grupo. O novo dono é o usuário {user}";
	}

	protected override string _GetTemplateForMessageChangeOwner()
	{
		return "{actor} alterou o dono do grupo. O novo dono é o usuário {user}";
	}

	protected override string _GetTemplateForMessageChangeOwnerEmpty()
	{
		return "O grupo não tem dono";
	}

	/// <summary>
	/// Key: "Message.ChangeRank"
	/// English String: "{actor} changed user {user}'s rank from {oldRoleSet} to {newRoleSet}"
	/// </summary>
	public override string MessageChangeRank(string actor, string user, string oldRoleSet, string newRoleSet)
	{
		return $"{actor} alterou o ranque do usuário {user} de {oldRoleSet} para {newRoleSet}";
	}

	protected override string _GetTemplateForMessageChangeRank()
	{
		return "{actor} alterou o ranque do usuário {user} de {oldRoleSet} para {newRoleSet}";
	}

	/// <summary>
	/// Key: "Message.Claim"
	/// English String: "{actor} claimed ownership of the group"
	/// </summary>
	public override string MessageClaim(string actor)
	{
		return $"{actor} reivindicou a propriedade do grupo";
	}

	protected override string _GetTemplateForMessageClaim()
	{
		return "{actor} reivindicou a propriedade do grupo";
	}

	protected override string _GetTemplateForMessageClaimOwnershipError()
	{
		return "Impossível assumir propriedade do grupo.";
	}

	protected override string _GetTemplateForMessageClaimOwnershipSuccess()
	{
		return "Propriedade do grupo assumida com sucesso.";
	}

	/// <summary>
	/// Key: "Message.ConfigureAsset"
	/// English String: "{actor} updated asset {item}: {actions}"
	/// </summary>
	public override string MessageConfigureAsset(string actor, string item, string actions)
	{
		return $"{actor} atualizou o elemento {item}: {actions}";
	}

	protected override string _GetTemplateForMessageConfigureAsset()
	{
		return "{actor} atualizou o elemento {item}: {actions}";
	}

	/// <summary>
	/// Key: "Message.ConfigureBadgeDisabled"
	/// English String: "{actor} disabled the badge {badge}"
	/// </summary>
	public override string MessageConfigureBadgeDisabled(string actor, string badge)
	{
		return $"{actor} desativou o emblema {badge}";
	}

	protected override string _GetTemplateForMessageConfigureBadgeDisabled()
	{
		return "{actor} desativou o emblema {badge}";
	}

	/// <summary>
	/// Key: "Message.ConfigureBadgeEnabled"
	/// English String: "{actor} enabled the badge {badge}"
	/// </summary>
	public override string MessageConfigureBadgeEnabled(string actor, string badge)
	{
		return $"{actor} ativou o emblema {badge}";
	}

	protected override string _GetTemplateForMessageConfigureBadgeEnabled()
	{
		return "{actor} ativou o emblema {badge}";
	}

	/// <summary>
	/// Key: "Message.ConfigureBadgeUpdate"
	/// English String: "{actor} configured the badge {badge}"
	/// </summary>
	public override string MessageConfigureBadgeUpdate(string actor, string badge)
	{
		return $"{actor} configurou o emblema {badge}";
	}

	protected override string _GetTemplateForMessageConfigureBadgeUpdate()
	{
		return "{actor} configurou o emblema {badge}";
	}

	/// <summary>
	/// Key: "Message.ConfigureGame"
	/// English String: "{actor} updated {game}: {actions}"
	/// </summary>
	public override string MessageConfigureGame(string actor, string game, string actions)
	{
		return $"{actor} atualizou o jogo {game}: {actions}";
	}

	protected override string _GetTemplateForMessageConfigureGame()
	{
		return "{actor} atualizou o jogo {game}: {actions}";
	}

	/// <summary>
	/// Key: "Message.ConfigureGameDeveloperProduct"
	/// English String: "{actor} updated developer product {id}: {actions}"
	/// </summary>
	public override string MessageConfigureGameDeveloperProduct(string actor, string id, string actions)
	{
		return $"{actor} atualizou o produto do desenvolvedor com ID {id}: {actions}";
	}

	protected override string _GetTemplateForMessageConfigureGameDeveloperProduct()
	{
		return "{actor} atualizou o produto do desenvolvedor com ID {id}: {actions}";
	}

	/// <summary>
	/// Key: "Message.ConfigureItems"
	/// English String: "{actor} configured the group item {item}"
	/// </summary>
	public override string MessageConfigureItems(string actor, string item)
	{
		return $"{actor} configurou o item de grupo {item}";
	}

	protected override string _GetTemplateForMessageConfigureItems()
	{
		return "{actor} configurou o item de grupo {item}";
	}

	/// <summary>
	/// Key: "Message.CreateAsset"
	/// English String: "{actor} created asset {item}"
	/// </summary>
	public override string MessageCreateAsset(string actor, string item)
	{
		return $"{actor} criou o elemento {item}";
	}

	protected override string _GetTemplateForMessageCreateAsset()
	{
		return "{actor} criou o elemento {item}";
	}

	/// <summary>
	/// Key: "Message.CreateBadge"
	/// English String: "{actor} created the badge {badge}"
	/// </summary>
	public override string MessageCreateBadge(string actor, string badge)
	{
		return $"{actor} criou o emblema {badge}";
	}

	protected override string _GetTemplateForMessageCreateBadge()
	{
		return "{actor} criou o emblema {badge}";
	}

	/// <summary>
	/// Key: "Message.CreateDeveloperProduct"
	/// English String: "{actor} created developer product with id {id}"
	/// </summary>
	public override string MessageCreateDeveloperProduct(string actor, string id)
	{
		return $"{actor} criou um produto do desenvolvedor com a ID {id}";
	}

	protected override string _GetTemplateForMessageCreateDeveloperProduct()
	{
		return "{actor} criou um produto do desenvolvedor com a ID {id}";
	}

	/// <summary>
	/// Key: "Message.CreateEnemy"
	/// English String: "{actor} declared group {group} as an enemy"
	/// </summary>
	public override string MessageCreateEnemy(string actor, string group)
	{
		return $"{actor} declarou o grupo {group} como inimigo";
	}

	protected override string _GetTemplateForMessageCreateEnemy()
	{
		return "{actor} declarou o grupo {group} como inimigo";
	}

	/// <summary>
	/// Key: "Message.CreateGamePass"
	/// English String: "{actor} created a Game Pass for {game}: {gamePass}"
	/// </summary>
	public override string MessageCreateGamePass(string actor, string game, string gamePass)
	{
		return $"{actor} criou um Passe de Jogo para {game}: {gamePass}";
	}

	protected override string _GetTemplateForMessageCreateGamePass()
	{
		return "{actor} criou um Passe de Jogo para {game}: {gamePass}";
	}

	/// <summary>
	/// Key: "Message.CreateItems"
	/// English String: "{actor} created the group item {item}"
	/// </summary>
	public override string MessageCreateItems(string actor, string item)
	{
		return $"{actor} criou o item de grupo {item}";
	}

	protected override string _GetTemplateForMessageCreateItems()
	{
		return "{actor} criou o item de grupo {item}";
	}

	/// <summary>
	/// Key: "Message.DeclineAllyRequest"
	/// English String: "{actor} declined group {group}'s ally request"
	/// </summary>
	public override string MessageDeclineAllyRequest(string actor, string group)
	{
		return $"{actor} recusou o pedido de aliança do grupo {group}";
	}

	protected override string _GetTemplateForMessageDeclineAllyRequest()
	{
		return "{actor} recusou o pedido de aliança do grupo {group}";
	}

	/// <summary>
	/// Key: "Message.DeclineJoinRequest"
	/// English String: "{actor} declined user {user}'s join request"
	/// </summary>
	public override string MessageDeclineJoinRequest(string actor, string user)
	{
		return $"{actor} recusou o pedido de entrada do usuário {user}";
	}

	protected override string _GetTemplateForMessageDeclineJoinRequest()
	{
		return "{actor} recusou o pedido de entrada do usuário {user}";
	}

	protected override string _GetTemplateForMessageDefaultError()
	{
		return "Ocorreu um erro.";
	}

	/// <summary>
	/// Key: "Message.Delete"
	/// English String: "{actor} deleted current group"
	/// </summary>
	public override string MessageDelete(string actor)
	{
		return $"{actor} excluiu o grupo atual";
	}

	protected override string _GetTemplateForMessageDelete()
	{
		return "{actor} excluiu o grupo atual";
	}

	/// <summary>
	/// Key: "Message.DeleteAlly"
	/// English String: "{actor} removed group {group} as an ally"
	/// </summary>
	public override string MessageDeleteAlly(string actor, string group)
	{
		return $"{actor} removeu o grupo {group} dos aliados";
	}

	protected override string _GetTemplateForMessageDeleteAlly()
	{
		return "{actor} removeu o grupo {group} dos aliados";
	}

	/// <summary>
	/// Key: "Message.DeleteEnemy"
	/// English String: "{actor} removed group {group} as an enemy"
	/// </summary>
	public override string MessageDeleteEnemy(string actor, string group)
	{
		return $"{actor} removeu o grupo {group} dos inimigos";
	}

	protected override string _GetTemplateForMessageDeleteEnemy()
	{
		return "{actor} removeu o grupo {group} dos inimigos";
	}

	/// <summary>
	/// Key: "Message.DeleteGroupPlace"
	/// English String: "{actor} removed game {game} as a group game"
	/// </summary>
	public override string MessageDeleteGroupPlace(string actor, string game)
	{
		return $"{actor} removeu o jogo {game} dos jogos do grupo";
	}

	protected override string _GetTemplateForMessageDeleteGroupPlace()
	{
		return "{actor} removeu o jogo {game} dos jogos do grupo";
	}

	/// <summary>
	/// Key: "Message.DeletePost"
	/// English String: "{actor} deleted post \"{postDesc}\" by user {user}"
	/// </summary>
	public override string MessageDeletePost(string actor, string postDesc, string user)
	{
		return $"{actor} excluiu a publicação \"{postDesc}\" do usuário {user}";
	}

	protected override string _GetTemplateForMessageDeletePost()
	{
		return "{actor} excluiu a publicação \"{postDesc}\" do usuário {user}";
	}

	protected override string _GetTemplateForMessageDeleteWallPostError()
	{
		return "Impossível excluir publicação do mural.";
	}

	protected override string _GetTemplateForMessageDeleteWallPostsByUserError()
	{
		return "Impossível excluir publicações do mural do usuário.";
	}

	protected override string _GetTemplateForMessageDeleteWallPostSuccess()
	{
		return "Publicação do mural excluída com sucesso.";
	}

	protected override string _GetTemplateForMessageDescriptionTooLong()
	{
		return "A descrição é longa demais.";
	}

	protected override string _GetTemplateForMessageDuplicateName()
	{
		return "Este nome já está sendo usado. Tente outro.";
	}

	protected override string _GetTemplateForMessageExileUserError()
	{
		return "Impossível exilar usuário.";
	}

	protected override string _GetTemplateForMessageFeatureDisabled()
	{
		return "Esta funcionalidade está desabilitada.";
	}

	protected override string _GetTemplateForMessageGetGroupRelationshipsError()
	{
		return "Impossível carregar afiliados de grupo.";
	}

	protected override string _GetTemplateForMessageGroupClosed()
	{
		return "Você não pode entrar em um grupo fechado.";
	}

	protected override string _GetTemplateForMessageGroupCreationDisabled()
	{
		return "A criação de grupo está desabilitada no momento.";
	}

	protected override string _GetTemplateForMessageGroupIconInvalid()
	{
		return "Ícone ausente ou inválido.";
	}

	/// <summary>
	/// Key: "Message.GroupIconTooLarge"
	/// English String: "Icon cannot be larger than {maxSize} mb."
	/// </summary>
	public override string MessageGroupIconTooLarge(string maxSize)
	{
		return $"O ícone pode ter até {maxSize} MB.";
	}

	protected override string _GetTemplateForMessageGroupIconTooLarge()
	{
		return "O ícone pode ter até {maxSize} MB.";
	}

	protected override string _GetTemplateForMessageGroupMembershipsUnavailableError()
	{
		return "O sistema de afiliação ao grupo não está disponível no momento. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageInsufficientFunds()
	{
		return "Fundos de Robux insuficientes.";
	}

	protected override string _GetTemplateForMessageInsufficientGroupSpace()
	{
		return "Você já entrou no número máximo de grupos.";
	}

	protected override string _GetTemplateForMessageInsufficientMembership()
	{
		return "Você não tem a assinatura do builders club necessária para entrar neste grupo.";
	}

	protected override string _GetTemplateForMessageInsufficientPermission()
	{
		return "Permissão insuficiente para completar a solicitação.";
	}

	protected override string _GetTemplateForMessageInsufficientPermissionsForRelationships()
	{
		return "Você não tem permissão para gerenciar as relações deste grupo.";
	}

	protected override string _GetTemplateForMessageInsufficientRobux()
	{
		return "Você não tem Robux o bastante para criar o grupo.";
	}

	protected override string _GetTemplateForMessageInvalidAmount()
	{
		return "Quantidade inválida.";
	}

	protected override string _GetTemplateForMessageInvalidGroup()
	{
		return "O grupo é inválido ou não existe.";
	}

	protected override string _GetTemplateForMessageInvalidGroupIcon()
	{
		return "O ícone do grupo é inválido.";
	}

	protected override string _GetTemplateForMessageInvalidGroupId()
	{
		return "O grupo é inválido ou não existe.";
	}

	protected override string _GetTemplateForMessageInvalidGroupWallPostId()
	{
		return "O mural do grupo é inválido ou não existe.";
	}

	protected override string _GetTemplateForMessageInvalidIds()
	{
		return "As IDs não puderam ser interpretadas na solicitação.";
	}

	protected override string _GetTemplateForMessageInvalidIdsError()
	{
		return "As IDs não puderam ser interpretadas na solicitação.";
	}

	protected override string _GetTemplateForMessageInvalidMembership()
	{
		return "O usuário precisa ter uma assinatura do builders club.";
	}

	protected override string _GetTemplateForMessageInvalidName()
	{
		return "O nome é inválido.";
	}

	protected override string _GetTemplateForMessageInvalidPaginationParameters()
	{
		return "Parâmetros de paginação inválidos ou faltando.";
	}

	protected override string _GetTemplateForMessageInvalidPayoutType()
	{
		return "Tipo de pagamento inválido.";
	}

	protected override string _GetTemplateForMessageInvalidRecipient()
	{
		return "Destinatário inválido.";
	}

	protected override string _GetTemplateForMessageInvalidRelationshipType()
	{
		return "Tipo de relação de grupo inválido.";
	}

	protected override string _GetTemplateForMessageInvalidRoleSetId()
	{
		return "O conjunto de funções é inválido ou não existe.";
	}

	protected override string _GetTemplateForMessageInvalidUser()
	{
		return "O usuário é inválido ou não existe.";
	}

	protected override string _GetTemplateForMessageInvalidWallPostContent()
	{
		return "Sua publicação estava vazia, com espaços em branco ou mais de 500 caracteres.";
	}

	/// <summary>
	/// Key: "Message.InviteToClan"
	/// English String: "{actor} invited user {user} to the clan"
	/// </summary>
	public override string MessageInviteToClan(string actor, string user)
	{
		return $"{actor} convidou o usuário {user} para o clã";
	}

	protected override string _GetTemplateForMessageInviteToClan()
	{
		return "{actor} convidou o usuário {user} para o clã";
	}

	protected override string _GetTemplateForMessageJoinGroupError()
	{
		return "Impossível entrar no grupo.";
	}

	protected override string _GetTemplateForMessageJoinGroupPendingSuccess()
	{
		return "Pediu para entrar no grupo. Seu pedido está pendente.";
	}

	protected override string _GetTemplateForMessageJoinGroupSuccess()
	{
		return "Entrada no grupo realizada com sucesso.";
	}

	/// <summary>
	/// Key: "Message.KickFromClan"
	/// English String: "{actor} kicked user {user} out of the clan"
	/// </summary>
	public override string MessageKickFromClan(string actor, string user)
	{
		return $"{actor} expulsou o usuário {user} do clã";
	}

	protected override string _GetTemplateForMessageKickFromClan()
	{
		return "{actor} expulsou o usuário {user} do clã";
	}

	protected override string _GetTemplateForMessageLeaveGroupError()
	{
		return "Impossível sair do grupo.";
	}

	protected override string _GetTemplateForMessageLoadGroupError()
	{
		return "Impossível carregar grupo.";
	}

	protected override string _GetTemplateForMessageLoadGroupGamesError()
	{
		return "Impossível carregar jogos.";
	}

	protected override string _GetTemplateForMessageLoadGroupListError()
	{
		return "Não foi possível carregar a lista de grupos.";
	}

	protected override string _GetTemplateForMessageLoadGroupMembershipsError()
	{
		return "Impossível carregar informações de assinatura de usuário.";
	}

	protected override string _GetTemplateForMessageLoadGroupMetadataError()
	{
		return "Impossível carregar informações de grupo.";
	}

	protected override string _GetTemplateForMessageLoadGroupStoreItemsError()
	{
		return "Impossível carregar itens da loja.";
	}

	protected override string _GetTemplateForMessageLoadUserGroupMembershipError()
	{
		return "Impossível carregar informações de membro do grupo.";
	}

	protected override string _GetTemplateForMessageLoadWallPostsError()
	{
		return "Impossível carregar publicações do mural.";
	}

	/// <summary>
	/// Key: "Message.Lock"
	/// English String: "{actor} locked the group"
	/// </summary>
	public override string MessageLock(string actor)
	{
		return $"{actor} travou o grupo";
	}

	protected override string _GetTemplateForMessageLock()
	{
		return "{actor} travou o grupo";
	}

	protected override string _GetTemplateForMessageMakePrimaryError()
	{
		return "Habilite para tornar grupo principal.";
	}

	protected override string _GetTemplateForMessageMaxGroups()
	{
		return "O usuário entrou no número máximo de grupos.";
	}

	protected override string _GetTemplateForMessageMissingGroupIcon()
	{
		return "O ícone do grupo está faltando na solicitação.";
	}

	protected override string _GetTemplateForMessageMissingGroupStatusContent()
	{
		return "Faltando conteúdo de status do grupo.";
	}

	protected override string _GetTemplateForMessageNameInvalid()
	{
		return "Nome ausente ou contém caracteres inválidos.";
	}

	protected override string _GetTemplateForMessageNameModerated()
	{
		return "O nome é moderado.";
	}

	protected override string _GetTemplateForMessageNameTaken()
	{
		return "O nome já está sendo usado.";
	}

	protected override string _GetTemplateForMessageNameTooLong()
	{
		return "O nome é comprido demais.";
	}

	protected override string _GetTemplateForMessageNoPrimary()
	{
		return "O usuário especificado não tem um grupo principal.";
	}

	protected override string _GetTemplateForMessagePassCaptchaToJoin()
	{
		return "Você precisa passar no teste captcha para entrar neste grupo.";
	}

	protected override string _GetTemplateForMessagePassCaptchaToPost()
	{
		return "O teste captcha deve ser solucionado para que você possa publicar no mural do grupo.";
	}

	/// <summary>
	/// Key: "Message.PostStatus"
	/// English String: "{actor} changed the group status to \"{groupStatus}\""
	/// </summary>
	public override string MessagePostStatus(string actor, string groupStatus)
	{
		return $"{actor} alterou o status do grupo para \"{groupStatus}\"";
	}

	protected override string _GetTemplateForMessagePostStatus()
	{
		return "{actor} alterou o status do grupo para \"{groupStatus}\"";
	}

	/// <summary>
	/// Key: "Message.RemoveMember"
	/// English String: "{actor} kicked user {user}"
	/// </summary>
	public override string MessageRemoveMember(string actor, string user)
	{
		return $"{actor} expulsou o usuário {user}";
	}

	protected override string _GetTemplateForMessageRemoveMember()
	{
		return "{actor} expulsou o usuário {user}";
	}

	protected override string _GetTemplateForMessageRemovePrimaryError()
	{
		return "Habilite para remover grupo principal.";
	}

	/// <summary>
	/// Key: "Message.Rename"
	/// English String: "{actor} renamed current group to {newName}"
	/// </summary>
	public override string MessageRename(string actor, string newName)
	{
		return $"{actor} renomeou o grupo para {newName}";
	}

	protected override string _GetTemplateForMessageRename()
	{
		return "{actor} renomeou o grupo para {newName}";
	}

	protected override string _GetTemplateForMessageSearchTermCharactersLimit()
	{
		return "O termo pesquisado deve conter entre 2 e 50 caracteres";
	}

	protected override string _GetTemplateForMessageSearchTermEmptyError()
	{
		return "Não há termo a pesquisar";
	}

	protected override string _GetTemplateForMessageSearchTermFilteredError()
	{
		return "O termo pesquisado foi filtrado";
	}

	/// <summary>
	/// Key: "Message.SendAllyRequest"
	/// English String: "{actor} sent an ally request to group {group}"
	/// </summary>
	public override string MessageSendAllyRequest(string actor, string group)
	{
		return $"{actor} enviou um pedido de aliança para o grupo {group}";
	}

	protected override string _GetTemplateForMessageSendAllyRequest()
	{
		return "{actor} enviou um pedido de aliança para o grupo {group}";
	}

	protected override string _GetTemplateForMessageSendGroupShoutError()
	{
		return "Impossível enviar anúncio de grupo.";
	}

	protected override string _GetTemplateForMessageSendPostError()
	{
		return "Impossível enviar publicação.";
	}

	/// <summary>
	/// Key: "Message.SpendGroupFunds"
	/// English String: "{actor} spent {amount} of group funds for: {item}"
	/// </summary>
	public override string MessageSpendGroupFunds(string actor, string amount, string item)
	{
		return $"{actor} gastou {amount} dos fundos do grupo com: {item}";
	}

	protected override string _GetTemplateForMessageSpendGroupFunds()
	{
		return "{actor} gastou {amount} dos fundos do grupo com: {item}";
	}

	protected override string _GetTemplateForMessageTooManyAttempts()
	{
		return "Foram feitas muitas tentativas para entrar no grupo. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsToClaimGroups()
	{
		return "Foram feitas muitas tentativas para reivindicar grupos. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageTooManyGroups()
	{
		return "Você alcançou o limite de grupos. Saia de um grupo antes de criar um novo.";
	}

	protected override string _GetTemplateForMessageTooManyIds()
	{
		return "IDs excessivas na solicitação.";
	}

	protected override string _GetTemplateForMessageTooManyPosts()
	{
		return "Você está publicando rápido demais. Tente novamente em alguns minutos.";
	}

	protected override string _GetTemplateForMessageTooManyRequests()
	{
		return "Excesso de solicitações.";
	}

	protected override string _GetTemplateForMessageUnauthorizedForPostStatus()
	{
		return "Você não tem autorização para definir o status deste grupo.";
	}

	protected override string _GetTemplateForMessageUnauthorizedForViewGroupPayouts()
	{
		return "Você não tem permissão para ver estes pagamentos de grupo.";
	}

	protected override string _GetTemplateForMessageUnauthorizedToClaimGroup()
	{
		return "Você não tem autorização para reivindicar este grupo.";
	}

	protected override string _GetTemplateForMessageUnauthorizedToManageMember()
	{
		return "Você não tem permissão para gerenciar este membro.";
	}

	protected override string _GetTemplateForMessageUnauthorizedToViewRolesetPermissions()
	{
		return "Você não tem autorização para ver as permissões deste conjunto de funções.";
	}

	protected override string _GetTemplateForMessageUnauthorizedToViewWall()
	{
		return "Você não tem permissão para acessar este mural do grupo.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Erro desconhecido";
	}

	/// <summary>
	/// Key: "Message.Unlock"
	/// English String: "{actor} unlocked the group"
	/// </summary>
	public override string MessageUnlock(string actor)
	{
		return $"{actor} destravou o grupo";
	}

	protected override string _GetTemplateForMessageUnlock()
	{
		return "{actor} destravou o grupo";
	}

	/// <summary>
	/// Key: "Message.UpdateAsset"
	/// English String: "{actor} created new version {version} of asset {item}"
	/// </summary>
	public override string MessageUpdateAsset(string actor, string version, string item)
	{
		return $"{actor} criou a nova versão {version} do elemento {item}";
	}

	protected override string _GetTemplateForMessageUpdateAsset()
	{
		return "{actor} criou a nova versão {version} do elemento {item}";
	}

	/// <summary>
	/// Key: "Message.UpdateAssetRevert"
	/// English String: "{actor} reverted asset {item} from version {version} to {oldVersion}"
	/// </summary>
	public override string MessageUpdateAssetRevert(string actor, string item, string version, string oldVersion)
	{
		return $"{actor} reverteu o elemento {item} da versão {version} para {oldVersion}";
	}

	protected override string _GetTemplateForMessageUpdateAssetRevert()
	{
		return "{actor} reverteu o elemento {item} da versão {version} para {oldVersion}";
	}

	protected override string _GetTemplateForMessageUserNotInGroup()
	{
		return "Você não é membro do grupo especificado.";
	}
}
