namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_zh_tw : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "預設";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "停用";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "查看全部";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "實驗模式遊戲";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "推薦遊戲";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "更多結果";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "顯示以下搜尋更多結果：";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "贊助廣告";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "最佳搜尋結果";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "取消";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "實驗";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "這是什麼？";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "實驗模式";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "以下結果含有實驗模式遊戲。";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "歷來";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "篩選條件";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "比賽";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "預設";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "精選遊戲";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "好友動態";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "類別";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "我的最愛";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "我的最愛";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "我的近期活動";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "現在";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "前一日";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "前一週";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "依您喜好";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "個人伺服器";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "熱門遊戲";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "虛擬實境熱門";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "附近熱門";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "全球熱門";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "已購買";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "最近玩過";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "時間";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "最受喜愛";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "營利最高";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "收益最高";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "評價最高";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "推薦遊戲";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "找不到結果";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "搜尋";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "改為搜尋";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "您是不是指：";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "顯示以下搜尋結果：";

	public GamePageResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "預設";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "停用";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "查看全部";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "實驗模式遊戲";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "推薦遊戲";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "更多結果";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "顯示以下搜尋更多結果：";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "贊助廣告";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "最佳搜尋結果";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "取消";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"創作者：{creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "創作者：{creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "實驗";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "這是什麼？";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "實驗模式";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "以下結果含有實驗模式遊戲。";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "歷來";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"因為您喜歡 {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "因為您喜歡 {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "篩選條件";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "比賽";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "預設";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "精選遊戲";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "好友動態";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "類別";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "我的最愛";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "我的最愛";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "我的近期活動";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "現在";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "前一日";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "前一週";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "依您喜好";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "個人伺服器";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "熱門遊戲";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"{CountryName}熱門";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "{CountryName}熱門";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "虛擬實境熱門";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "附近熱門";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "全球熱門";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "已購買";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "最近玩過";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "時間";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "最受喜愛";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "營利最高";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "收益最高";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "評價最高";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "推薦遊戲";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "找不到結果";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount} 人正在玩";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount} 人正在玩";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "搜尋";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "改為搜尋";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "您是不是指：";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "顯示以下搜尋結果：";
	}
}
