namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_zh_cn : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "默认";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "停用";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "查看全部";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "实验模式游戏";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "推荐";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "更多结果";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "更多搜索结果：";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "赞助广告";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "最佳结果";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "取消";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "实验性";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "这是什么？";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "实验模式";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "以下结果包含实验模式游戏。";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "全部";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "过滤条件";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "竞赛";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "默认";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "精选";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "好友动态";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "主题";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "我的最爱";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "我的最爱";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "我的最近活动";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "现在";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "昨天";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "上星期";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "因为你赞过";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "个人服务器";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "热门";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "VR 热门";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "你附近的热门";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "全球流行";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "已购买";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "最近玩过";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "时间";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "最受喜爱";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "最高收入";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "最高收益";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "最高评分";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "推荐";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "未找到搜索结果";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "搜索";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "仍然搜索";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "你要找的是不是：";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "显示的是搜索以下字符的结果：";

	public GamePageResources_zh_cn(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "默认";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "停用";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "查看全部";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "实验模式游戏";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "推荐";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "更多结果";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "更多搜索结果：";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "赞助广告";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "最佳结果";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "取消";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"创作者 {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "创作者 {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "实验性";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "这是什么？";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "实验模式";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "以下结果包含实验模式游戏。";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "全部";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"因为你赞过 {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "因为你赞过 {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "过滤条件";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "竞赛";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "默认";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "精选";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "好友动态";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "主题";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "我的最爱";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "我的最爱";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "我的最近活动";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "现在";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "昨天";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "上星期";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "因为你赞过";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "个人服务器";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "热门";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"{CountryName}热门";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "{CountryName}热门";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "VR 热门";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "你附近的热门";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "全球流行";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "已购买";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "最近玩过";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "时间";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "最受喜爱";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "最高收入";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "最高收益";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "最高评分";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "推荐";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "未找到搜索结果";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount} 人正在玩";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount} 人正在玩";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "搜索";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "仍然搜索";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "你要找的是不是：";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "显示的是搜索以下字符的结果：";
	}
}
