namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_pt_br : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "Padrão";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "Desabilitar";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Ver todos";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "Jogos do modo experimental";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "Recomendados";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "mais resultados";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "Mais resultados para";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "Patrocinado";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Melhor resultado";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "Cancelar";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "Experimental";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "O que é isso?";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "Modo experimental";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "Esses resultados contêm jogos do modo experimental.";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "Todos os tempos";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "Filtrar por";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "Concurso";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "Padrão";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "Destaques";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "Atividade de amigo";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Gênero";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "Meus favoritos";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "Meus favoritos";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "Meus recentes";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "Agora";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "Dia anterior";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "Semana passada";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "Porque você curtiu";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "Servidor pessoal";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "Popular";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "Popular em VR";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "Popular perto de você";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "Popular no mundo todo";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "Comprado";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "Jogados recentemente";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "Hora";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "Favorito absoluto";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "Maior ganho";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "Populares pagos";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "Melhor avaliação";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "Recomendados";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "Nenhum resultado de pesquisa encontrado";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Pesquisar";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "Em vez disso, pesquisar por";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "Você quis dizer:";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "Exibindo resultados para";

	public GamePageResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "Padrão";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "Desabilitar";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Ver todos";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "Jogos do modo experimental";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "mais resultados";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Mais resultados para";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "Patrocinado";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Melhor resultado";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "Cancelar";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"De {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "De {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Experimental";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "O que é isso?";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "Modo experimental";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "Esses resultados contêm jogos do modo experimental.";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "Todos os tempos";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"Porque você curtiu {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "Porque você curtiu {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "Filtrar por";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "Concurso";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "Padrão";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "Destaques";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "Atividade de amigo";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Gênero";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "Meus favoritos";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "Meus favoritos";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "Meus recentes";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "Agora";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "Dia anterior";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "Semana passada";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "Porque você curtiu";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "Servidor pessoal";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "Popular";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"Popular em {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "Popular em {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "Popular em VR";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "Popular perto de você";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "Popular no mundo todo";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "Comprado";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "Jogados recentemente";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "Hora";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "Favorito absoluto";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "Maior ganho";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "Populares pagos";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "Melhor avaliação";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "Nenhum resultado de pesquisa encontrado";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount} jogando";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount} jogando";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Pesquisar";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "Em vez disso, pesquisar por";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "Você quis dizer:";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "Exibindo resultados para";
	}
}
