namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_ko_kr : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "기본값";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "비활성화";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "전체 보기";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "실험 모드 게임";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "추천";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "결과 더 보기";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "다음에 대한 더 많은 검색 결과";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "스폰서 광고";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "상위 검색 결과";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "취소";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "실험";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "이것은 무엇인가요?";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "실험 모드";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "결과에 실험 모드 게임이 포함되어 있어요.";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "전체 기간";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "필터링:";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "콘테스트";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "기본값";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "주목";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "친구 활동";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "장르";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "내 즐겨찾기";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "내 즐겨찾기";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "최근 플레이";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "지금";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "어제";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "지난주";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "관심 기반 추천";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "개인 서버";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "인기";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "VR에서 인기";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "주변에서 인기";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "전 세계적으로 인기";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "구매";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "최근 플레이";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "시간";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "최고 즐겨찾기";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "최고 수익";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "최고 매출";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "최고 평점";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "추천";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "검색 결과 없음";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "검색";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "다른 검색 결과 - 검색어:";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "이것을 찾으셨나요?";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "검색 결과 - 검색어:";

	public GamePageResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "기본값";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "비활성화";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "전체 보기";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "실험 모드 게임";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "추천";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "결과 더 보기";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "다음에 대한 더 많은 검색 결과";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "스폰서 광고";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "상위 검색 결과";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "취소";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"개발: {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "개발: {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "실험";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "이것은 무엇인가요?";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "실험 모드";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "결과에 실험 모드 게임이 포함되어 있어요.";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "전체 기간";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"관심 기반 추천: {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "관심 기반 추천: {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "필터링:";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "콘테스트";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "기본값";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "주목";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "친구 활동";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "장르";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "내 즐겨찾기";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "내 즐겨찾기";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "최근 플레이";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "지금";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "어제";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "지난주";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "관심 기반 추천";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "개인 서버";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "인기";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"{CountryName}에서 인기";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "{CountryName}에서 인기";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "VR에서 인기";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "주변에서 인기";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "전 세계적으로 인기";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "구매";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "최근 플레이";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "시간";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "최고 즐겨찾기";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "최고 수익";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "최고 매출";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "최고 평점";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "추천";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "검색 결과 없음";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount}명 플레이 중";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount}명 플레이 중";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "검색";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "다른 검색 결과 - 검색어:";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "이것을 찾으셨나요?";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "검색 결과 - 검색어:";
	}
}
