namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_ja_jp : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "デフォルト";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "無効化";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "すべて見る";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "試験モードのゲーム";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "おすすめ";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "さらに結果を表示する";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "さらに結果を表示する";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "スポンサー付き広告";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "上位の結果";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "キャンセル";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "試験";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "これは何ですか？";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "試験モード";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "この結果には試験モードのゲームが含まれています。";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "通算";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "フィルタ";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "コンテスト";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "デフォルト";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "注目";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "友達のアクティビティ";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "ジャンル";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "あなたのお気に入り";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "あなたのお気に入り";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "最近のプレイ";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "今";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "昨日";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "先週";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "「いいね」したため";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "パーソナルサーバー";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "人気";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "VRで人気";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "あなたの周りで人気";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "世界中で人気";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "購入済み";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "最近プレイしたゲーム";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "時間";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "大人気";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "収益トップ";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "収入トップ";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "高評価";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "おすすめ";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "検索結果が見つかりませんでした";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "検索";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "元の検索ワード:";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "次の検索結果を表示しています:";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "以下の結果を表示中:";

	public GamePageResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "デフォルト";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "無効化";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "すべて見る";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "試験モードのゲーム";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "おすすめ";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "さらに結果を表示する";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "さらに結果を表示する";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "スポンサー付き広告";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "上位の結果";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "キャンセル";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"作：{creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "作：{creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "試験";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "これは何ですか？";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "試験モード";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "この結果には試験モードのゲームが含まれています。";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "通算";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"{gameName}に「いいね」したため";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "{gameName}に「いいね」したため";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "フィルタ";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "コンテスト";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "デフォルト";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "注目";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "友達のアクティビティ";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "ジャンル";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "あなたのお気に入り";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "あなたのお気に入り";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "最近のプレイ";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "今";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "昨日";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "先週";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "「いいね」したため";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "パーソナルサーバー";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "人気";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"{CountryName} で人気";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "{CountryName} で人気";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "VRで人気";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "あなたの周りで人気";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "世界中で人気";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "購入済み";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "最近プレイしたゲーム";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "時間";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "大人気";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "収益トップ";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "収入トップ";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "高評価";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "おすすめ";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "検索結果が見つかりませんでした";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount} 人がプレイ中";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount} 人がプレイ中";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "検索";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "元の検索ワード:";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "次の検索結果を表示しています:";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "以下の結果を表示中:";
	}
}
