namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_fr_fr : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "Par défaut";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "Désactiver";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Afficher tout";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "Jeux en mode expérimental";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "Recommandés";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "plus de résultats";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "Plus de résultats pour";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "Contenu sponsorisé";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Meilleur résultat";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "Annuler";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "Expérimental";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "Qu'est-ce que c'est\u00a0?";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "Mode expérimental";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "Ces résultats contiennent des jeux en mode expérimental.";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "Tous les temps";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "Filtrer par";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "Compétition";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "Par défaut";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "En vedette";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "Activité des amis";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Genre";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "Mes favoris";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "Mes favoris";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "Mes jeux récents";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "Maintenant";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "Hier";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "Semaine dernière";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "Car vous avez aimé";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "Serveur personnel";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "Populaire";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "Populaire en RV";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "Populaires près de vous";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "Populaire dans le monde entier";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "Achetés";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "Joués récemment";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "Temps";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "Les meilleurs favoris";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "Meilleurs gains";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "Meilleurs paiements";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "Meilleures notes";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "Recommandés";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "Aucun résultat trouvé";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Rechercher";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "Rechercher plutôt";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "Voulez-vous dire\u00a0:";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "Affichage des résultats pour";

	public GamePageResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "Par défaut";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "Désactiver";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Afficher tout";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "Jeux en mode expérimental";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "Recommandés";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "plus de résultats";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Plus de résultats pour";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "Contenu sponsorisé";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Meilleur résultat";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "Annuler";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"Par {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "Par {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Expérimental";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "Qu'est-ce que c'est\u00a0?";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "Mode expérimental";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "Ces résultats contiennent des jeux en mode expérimental.";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "Tous les temps";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"Car vous avez aimé {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "Car vous avez aimé {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "Filtrer par";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "Compétition";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "Par défaut";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "En vedette";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "Activité des amis";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Genre";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "Mes favoris";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "Mes favoris";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "Mes jeux récents";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "Maintenant";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "Hier";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "Semaine dernière";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "Car vous avez aimé";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "Serveur personnel";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "Populaire";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"Populaires ({CountryName})";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "Populaires ({CountryName})";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "Populaire en RV";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "Populaires près de vous";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "Populaire dans le monde entier";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "Achetés";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "Joués récemment";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "Temps";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "Les meilleurs favoris";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "Meilleurs gains";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "Meilleurs paiements";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "Meilleures notes";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "Recommandés";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "Aucun résultat trouvé";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount}\u00a0en jeu";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount}\u00a0en jeu";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Rechercher";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "Rechercher plutôt";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "Voulez-vous dire\u00a0:";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "Affichage des résultats pour";
	}
}
