namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_es_es : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "Predeterminado";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "Desactivar";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Ver todo";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "Juegos del modo experimental";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "Recomendados";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "más resultados";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "Más resultados para";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "Anuncio patrocinado";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Mejor resultado";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "Cancelar";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "Experimentales";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "¿Qué es esto?";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "Experimentales";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "Los resultados incluyen juegos del modo experimental.";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "Todos los tiempos";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "Filtrado por";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "Concurso";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "Predeterminado";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "Promocionados";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "Actividad de amigos";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Género";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "Mis favoritos";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "Mis favoritos";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "Mis recientes";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "Ahora";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "Día anterior";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "Semana pasada";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "Porque te gustó";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "Servidor personal";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "Populares";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "Popular en RV";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "Populares cerca de ti";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "Populares en todo el mundo";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "Comprados";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "Jugados recientemente";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "Tiempo";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "Más favoritos";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "Más rentables";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "Mejores de pago";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "Mejor valorados";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "Recomendados";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "La búsqueda no ha dado resultados.";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Buscar";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "Buscar, en cambio,";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "Búsqueda alternativa:";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "Resultados de";

	public GamePageResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "Predeterminado";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "Desactivar";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Ver todo";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "Juegos del modo experimental";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "más resultados";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Más resultados para";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "Anuncio patrocinado";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Mejor resultado";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "Cancelar";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"De {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "De {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Experimentales";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "¿Qué es esto?";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "Experimentales";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "Los resultados incluyen juegos del modo experimental.";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "Todos los tiempos";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"Porque te gustó {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "Porque te gustó {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "Filtrado por";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "Concurso";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "Predeterminado";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "Promocionados";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "Actividad de amigos";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Género";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "Mis favoritos";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "Mis favoritos";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "Mis recientes";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "Ahora";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "Día anterior";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "Semana pasada";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "Porque te gustó";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "Servidor personal";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "Populares";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"Popular en {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "Popular en {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "Popular en RV";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "Populares cerca de ti";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "Populares en todo el mundo";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "Comprados";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "Jugados recientemente";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "Tiempo";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "Más favoritos";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "Más rentables";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "Mejores de pago";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "Mejor valorados";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "La búsqueda no ha dado resultados.";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"{playerCount} jugando";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "{playerCount} jugando";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Buscar";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "Buscar, en cambio,";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "Búsqueda alternativa:";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "Resultados de";
	}
}
