namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides GamePageResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GamePageResources_de_de : GamePageResources_en_us, IGamePageResources, ITranslationResources
{
	/// <summary>
	/// Key: "abelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string abelFilterDefault => "Standard";

	/// <summary>
	/// Key: "ActionDisableExperimentalMode"
	/// English String: "Disable"
	/// </summary>
	public override string ActionDisableExperimentalMode => "Deaktivieren";

	/// <summary>
	/// Key: "ActionSeeAll"
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Alle ansehen";

	/// <summary>
	/// Key: "HeadingExperimentalMode"
	/// English String: "Experimental Mode Games"
	/// </summary>
	public override string HeadingExperimentalMode => "Spiele im Experimentalmodus";

	/// <summary>
	/// Key: "Label.FilterExperimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterExperimental => "Empfohlen";

	/// <summary>
	/// Key: "Label.MoreResults"
	/// English String: "more results"
	/// </summary>
	public override string LabelMoreResults => "weitere Ergebnisse";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results For"
	/// </summary>
	public override string LabelMoreResultsFor => "Mehr Ergebnisse für";

	/// <summary>
	/// Key: "Label.SponsoredAd"
	/// text for label of sponsored game cards
	/// English String: "Sponsored Ad"
	/// </summary>
	public override string LabelSponsoredAd => "Gesponserte Anzeige";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Top-Ergebnis";

	/// <summary>
	/// Key: "LabelCancelField"
	/// English String: "Cancel"
	/// </summary>
	public override string LabelCancelField => "Abbrechen";

	/// <summary>
	/// Key: "LabelExperimental"
	/// English String: "Experimental"
	/// </summary>
	public override string LabelExperimental => "Experimentell";

	/// <summary>
	/// Key: "LabelExperimentalHelpText"
	/// English String: "What's this?"
	/// </summary>
	public override string LabelExperimentalHelpText => "Was ist das?";

	/// <summary>
	/// Key: "LabelExperimentalMode"
	/// English String: "Experimental Mode"
	/// </summary>
	public override string LabelExperimentalMode => "Experimentalmodus";

	/// <summary>
	/// Key: "LabelExperimentalResults"
	/// English String: "These results contain Experimental Mode games."
	/// </summary>
	public override string LabelExperimentalResults => "Diese Treffer beinhalten auch Spiele im Experimentalmodus.";

	/// <summary>
	/// Key: "LabelFilterAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelFilterAllTime => "Seit Beginn";

	/// <summary>
	/// Key: "LabelFilterBuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelFilterBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "LabelFilterBy"
	/// English String: "Filter By"
	/// </summary>
	public override string LabelFilterBy => "Filtern nach";

	/// <summary>
	/// Key: "LabelFilterContest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelFilterContest => "Wettbewerb";

	/// <summary>
	/// Key: "LabelFilterDefault"
	/// English String: "Default"
	/// </summary>
	public override string LabelFilterDefault => "Standard";

	/// <summary>
	/// Key: "LabelFilterFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFilterFeatured => "Highlight";

	/// <summary>
	/// Key: "LabelFilterFriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFilterFriendActivity => "Freundesaktivität";

	/// <summary>
	/// Key: "LabelFilterGenre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Genre";

	/// <summary>
	/// Key: "LabelFilterMyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelFilterMyFavorite => "Meine Favoriten";

	/// <summary>
	/// Key: "LabelFilterMyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelFilterMyFavorites => "Meine Favoriten";

	/// <summary>
	/// Key: "LabelFilterMyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelFilterMyRecent => "Zuletzt gespielt";

	/// <summary>
	/// Key: "LabelFilterNow"
	/// English String: "Now"
	/// </summary>
	public override string LabelFilterNow => "Jetzt";

	/// <summary>
	/// Key: "LabelFilterPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelFilterPastDay => "Vorheriger Tag";

	/// <summary>
	/// Key: "LabelFilterPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelFilterPastWeek => "Letzte Woche";

	/// <summary>
	/// Key: "LabelFilterPersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelFilterPersonalizedByLiked => "Weil dir das gefallen hat";

	/// <summary>
	/// Key: "LabelFilterPersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelFilterPersonalServer => "Persönlicher Server";

	/// <summary>
	/// Key: "LabelFilterPopular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelFilterPopular => "Beliebt";

	/// <summary>
	/// Key: "LabelFilterPopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelFilterPopularInVr => "Beliebt in VR";

	/// <summary>
	/// Key: "LabelFilterPopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelFilterPopularNearYou => "Beliebt in deiner Umgebung";

	/// <summary>
	/// Key: "LabelFilterPopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelFilterPopularWorldwide => "Weltweit beliebt";

	/// <summary>
	/// Key: "LabelFilterPurchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelFilterPurchased => "Gekauft";

	/// <summary>
	/// Key: "LabelFilterRecentlyPlayed "
	/// English String: "Recently Played"
	/// </summary>
	public override string LabelFilterRecentlyPlayed => "Zuletzt gespielt";

	/// <summary>
	/// Key: "LabelFilterTime"
	/// English String: "Time"
	/// </summary>
	public override string LabelFilterTime => "Zeit";

	/// <summary>
	/// Key: "LabelFilterTopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelFilterTopFavorite => "Superbeliebt";

	/// <summary>
	/// Key: "LabelFilterTopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelFilterTopGrossing => "Top-Verdienst";

	/// <summary>
	/// Key: "LabelFilterTopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelFilterTopPaid => "Top-Bezahlt";

	/// <summary>
	/// Key: "LabelFilterTopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelFilterTopRated => "Top-Bewertung";

	/// <summary>
	/// Key: "LabelFilterTopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelFilterTopRetaining => "Empfohlen";

	/// <summary>
	/// Key: "LabelNoSearchResults"
	/// English String: "No Search Results Found"
	/// </summary>
	public override string LabelNoSearchResults => "Keine Suchergebnisse";

	/// <summary>
	/// Key: "LabelSearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Suche";

	/// <summary>
	/// Key: "LabelSearchInsteadFor"
	/// English String: "Search instead for"
	/// </summary>
	public override string LabelSearchInsteadFor => "Suche stattdessen nach";

	/// <summary>
	/// Key: "LabelSearchYouMightMean"
	/// English String: "Did you mean:"
	/// </summary>
	public override string LabelSearchYouMightMean => "Meintest du:";

	/// <summary>
	/// Key: "LabelShowingResultsFor"
	/// English String: "Showing results for"
	/// </summary>
	public override string LabelShowingResultsFor => "Zeige Treffer für";

	public GamePageResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForabelFilterDefault()
	{
		return "Standard";
	}

	protected override string _GetTemplateForActionDisableExperimentalMode()
	{
		return "Deaktivieren";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Alle ansehen";
	}

	protected override string _GetTemplateForHeadingExperimentalMode()
	{
		return "Spiele im Experimentalmodus";
	}

	protected override string _GetTemplateForLabelFilterExperimental()
	{
		return "Empfohlen";
	}

	protected override string _GetTemplateForLabelMoreResults()
	{
		return "weitere Ergebnisse";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Mehr Ergebnisse für";
	}

	protected override string _GetTemplateForLabelSponsoredAd()
	{
		return "Gesponserte Anzeige";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Top-Ergebnis";
	}

	protected override string _GetTemplateForLabelCancelField()
	{
		return "Abbrechen";
	}

	/// <summary>
	/// Key: "LabelCreatorBy"
	/// English String: "By {creatorLink}"
	/// </summary>
	public override string LabelCreatorBy(string creatorLink)
	{
		return $"Von {creatorLink}";
	}

	protected override string _GetTemplateForLabelCreatorBy()
	{
		return "Von {creatorLink}";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Experimentell";
	}

	protected override string _GetTemplateForLabelExperimentalHelpText()
	{
		return "Was ist das?";
	}

	protected override string _GetTemplateForLabelExperimentalMode()
	{
		return "Experimentalmodus";
	}

	protected override string _GetTemplateForLabelExperimentalResults()
	{
		return "Diese Treffer beinhalten auch Spiele im Experimentalmodus.";
	}

	protected override string _GetTemplateForLabelFilterAllTime()
	{
		return "Seit Beginn";
	}

	/// <summary>
	/// Key: "LabelFilterBecauseYouLiked"
	/// English String: "Because You Liked {gameName}"
	/// </summary>
	public override string LabelFilterBecauseYouLiked(string gameName)
	{
		return $"Weil dir das gefallen hat: {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBecauseYouLiked()
	{
		return "Weil dir das gefallen hat: {gameName}";
	}

	protected override string _GetTemplateForLabelFilterBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelFilterBy()
	{
		return "Filtern nach";
	}

	protected override string _GetTemplateForLabelFilterContest()
	{
		return "Wettbewerb";
	}

	protected override string _GetTemplateForLabelFilterDefault()
	{
		return "Standard";
	}

	protected override string _GetTemplateForLabelFilterFeatured()
	{
		return "Highlight";
	}

	protected override string _GetTemplateForLabelFilterFriendActivity()
	{
		return "Freundesaktivität";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Genre";
	}

	protected override string _GetTemplateForLabelFilterMyFavorite()
	{
		return "Meine Favoriten";
	}

	protected override string _GetTemplateForLabelFilterMyFavorites()
	{
		return "Meine Favoriten";
	}

	protected override string _GetTemplateForLabelFilterMyRecent()
	{
		return "Zuletzt gespielt";
	}

	protected override string _GetTemplateForLabelFilterNow()
	{
		return "Jetzt";
	}

	protected override string _GetTemplateForLabelFilterPastDay()
	{
		return "Vorheriger Tag";
	}

	protected override string _GetTemplateForLabelFilterPastWeek()
	{
		return "Letzte Woche";
	}

	protected override string _GetTemplateForLabelFilterPersonalizedByLiked()
	{
		return "Weil dir das gefallen hat";
	}

	protected override string _GetTemplateForLabelFilterPersonalServer()
	{
		return "Persönlicher Server";
	}

	protected override string _GetTemplateForLabelFilterPopular()
	{
		return "Beliebt";
	}

	/// <summary>
	/// Key: "LabelFilterPopularByCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelFilterPopularByCountry(string CountryName)
	{
		return $"Beliebt in {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularByCountry()
	{
		return "Beliebt in {CountryName}";
	}

	protected override string _GetTemplateForLabelFilterPopularInVr()
	{
		return "Beliebt in VR";
	}

	protected override string _GetTemplateForLabelFilterPopularNearYou()
	{
		return "Beliebt in deiner Umgebung";
	}

	protected override string _GetTemplateForLabelFilterPopularWorldwide()
	{
		return "Weltweit beliebt";
	}

	protected override string _GetTemplateForLabelFilterPurchased()
	{
		return "Gekauft";
	}

	protected override string _GetTemplateForLabelFilterRecentlyPlayed()
	{
		return "Zuletzt gespielt";
	}

	protected override string _GetTemplateForLabelFilterTime()
	{
		return "Zeit";
	}

	protected override string _GetTemplateForLabelFilterTopFavorite()
	{
		return "Superbeliebt";
	}

	protected override string _GetTemplateForLabelFilterTopGrossing()
	{
		return "Top-Verdienst";
	}

	protected override string _GetTemplateForLabelFilterTopPaid()
	{
		return "Top-Bezahlt";
	}

	protected override string _GetTemplateForLabelFilterTopRated()
	{
		return "Top-Bewertung";
	}

	protected override string _GetTemplateForLabelFilterTopRetaining()
	{
		return "Empfohlen";
	}

	protected override string _GetTemplateForLabelNoSearchResults()
	{
		return "Keine Suchergebnisse";
	}

	/// <summary>
	/// Key: "LabelPlayingPhrase"
	/// English String: "{playerCount} Playing"
	/// </summary>
	public override string LabelPlayingPhrase(string playerCount)
	{
		return $"Von {playerCount} gespielt";
	}

	protected override string _GetTemplateForLabelPlayingPhrase()
	{
		return "Von {playerCount} gespielt";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Suche";
	}

	protected override string _GetTemplateForLabelSearchInsteadFor()
	{
		return "Suche stattdessen nach";
	}

	protected override string _GetTemplateForLabelSearchYouMightMean()
	{
		return "Meintest du:";
	}

	protected override string _GetTemplateForLabelShowingResultsFor()
	{
		return "Zeige Treffer für";
	}
}
