namespace Roblox.TranslationResources.Feature;

internal static class GamePageResourceFactory
{
	public const string FullNamespace = "Feature.GamePage";

	public static IGamePageResources GetResources(TranslationResourceLocale locale, TranslationResourceState state)
	{
		return locale switch
		{
			TranslationResourceLocale.de_de => new GamePageResources_de_de(state), 
			TranslationResourceLocale.en_us => new GamePageResources_en_us(state), 
			TranslationResourceLocale.es_es => new GamePageResources_es_es(state), 
			TranslationResourceLocale.fr_fr => new GamePageResources_fr_fr(state), 
			TranslationResourceLocale.ja_jp => new GamePageResources_ja_jp(state), 
			TranslationResourceLocale.ko_kr => new GamePageResources_ko_kr(state), 
			TranslationResourceLocale.pt_br => new GamePageResources_pt_br(state), 
			TranslationResourceLocale.zh_cjv => new GamePageResources_zh_cjv(state), 
			TranslationResourceLocale.zh_cn => new GamePageResources_zh_cn(state), 
			TranslationResourceLocale.zh_tw => new GamePageResources_zh_tw(state), 
			_ => new GamePageResources_en_us(state), 
		};
	}
}
