namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_zh_tw : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "管理我的遊戲";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "前往開發人員平台";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "繼續前往 Roblox Wiki";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "開始創作";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "像您一樣的創作者正在透過他們的創作取得報酬；我們最優秀的開發人員每年可以透過遊戲中買賣賺取超過 200 萬美元。";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "使用我們免費且身歷其境的創作平台";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "您可以使用 Roblox Studio 創作各式各樣的遊戲，並立刻發布到智慧型手機、平板、電腦、遊戲主機及虛擬實境裝置上。";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "融入一個每月超過五千萬名來自全球各地、充滿熱情的玩家組成的社群。";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "開發人員平台是您在 Roblox 發布遊戲的最佳資源。您可以在這裡開始一系列的教學、和其它開發人員交流、更新平台、瀏覽 API 參考資料…等等。";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Roblox Wiki 擁有許多文件、教學及樣本，是協助您學習使用 Roblox Studio 製作遊戲的最佳資源。";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "我一下子就學會玩 Roblox 了！那麼多人在玩 Roblox，裡面的團隊也一直分享資源給開發者，你絕對可以把 Roblox 當成你的職業。";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Roblox 讓我可以專心開發遊戲和未來的職涯，不用為身為大學生的財務狀況煩惱。";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "我很享受在 Roblox 創作遊戲，因為它將 Facebook 等平台的社交功能透過社群的遊戲和創意提升到新的層次。";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Roblox 讓我可以專心開發遊戲和未來的職涯，不用為身為大學生的財務狀況煩惱。";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "我一下子就學會玩 Roblox 了！那麼多人在玩 Roblox，裡面的團隊也一直分享資源給開發者，你絕對可以把 Roblox 當成你的職業。";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "我很享受在 Roblox 創作遊戲，因為它將 Facebook 等平台的社交功能透過社群的遊戲和創意提升到新的層次。";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "開始賺錢";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "創作您所想像的一切";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "發揮創意";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "接觸玩家";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "開發人員平台";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Roblox Wiki";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio 完全免費，快來試試看！";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "創作者的話";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "與好友一起創作";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "開始使用";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "回到頂端";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "引號";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio 支援 Windows 和 Mac";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "管理我的遊戲";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "前往開發人員平台";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "繼續前往 Roblox Wiki";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "開始創作";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "像您一樣的創作者正在透過他們的創作取得報酬；我們最優秀的開發人員每年可以透過遊戲中買賣賺取超過 200 萬美元。";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "使用我們免費且身歷其境的創作平台";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "您可以使用 Roblox Studio 創作各式各樣的遊戲，並立刻發布到智慧型手機、平板、電腦、遊戲主機及虛擬實境裝置上。";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "融入一個每月超過五千萬名來自全球各地、充滿熱情的玩家組成的社群。";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "開發人員平台是您在 Roblox 發布遊戲的最佳資源。您可以在這裡開始一系列的教學、和其它開發人員交流、更新平台、瀏覽 API 參考資料…等等。";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Roblox Wiki 擁有許多文件、教學及樣本，是協助您學習使用 Roblox Studio 製作遊戲的最佳資源。";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "我一下子就學會玩 Roblox 了！那麼多人在玩 Roblox，裡面的團隊也一直分享資源給開發者，你絕對可以把 Roblox 當成你的職業。";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Roblox 讓我可以專心開發遊戲和未來的職涯，不用為身為大學生的財務狀況煩惱。";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "我很享受在 Roblox 創作遊戲，因為它將 Facebook 等平台的社交功能透過社群的遊戲和創意提升到新的層次。";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Roblox 讓我可以專心開發遊戲和未來的職涯，不用為身為大學生的財務狀況煩惱。";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "我一下子就學會玩 Roblox 了！那麼多人在玩 Roblox，裡面的團隊也一直分享資源給開發者，你絕對可以把 Roblox 當成你的職業。";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "我很享受在 Roblox 創作遊戲，因為它將 Facebook 等平台的社交功能透過社群的遊戲和創意提升到新的層次。";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "開始賺錢";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "創作您所想像的一切";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "發揮創意";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "接觸玩家";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "開發人員平台";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Roblox Wiki";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio 完全免費，快來試試看！";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "創作者的話";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "與好友一起創作";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "開始使用";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "回到頂端";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "引號";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio 支援 Windows 和 Mac";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
