namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_zh_cn : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "管理我的游戏";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "前往 Developer Hub";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "继续前往 Roblox Wiki";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "开始创作";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "像你一样的创作者正凭借着他们的创作获得报酬；通过提供游戏内交易项目，我们最优秀的开发者年获利可超过 200 万美元";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "使用我们免费的沉浸式创作引擎";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "你能使用 Roblox Studio 创作任何作品；只需轻轻一点，便能将作品发布至智能手机、平板电脑、游戏主机及虚拟现实设备上";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "融入一个每月超过五千万名来自全球各地、充满热情的玩家所组成的社区";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "Developer Hub 是你在 Roblox 发布游戏的一站式平台。你可以在这里找到种类繁多的教学视频、和其他开发者交流、获取平台更新，浏览我们的 API 参考资料等等。";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Roblox Wiki 包含许多文档、教程和样本，是帮助你学习使用 Roblox Studio 制作游戏的最佳资源";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "我一下就学会玩 Roblox 了！那么多人在玩 Roblox，Roblox 工作团队也一直愿意为开发者提供优秀资源，Roblox 是一个非常棒的职业方向！";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Roblox 给了我专心开发游戏并思考未来职业生涯的空间，我不用再为身为一名大学生的财务状况而烦恼。";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "我很享受在 Roblox 上创作游戏，因为它将 Facebook 等平台的社交功能通过社区的游戏和创意提升到了新的层次。";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Roblox 给了我专心开发游戏并思考未来职业生涯的空间，我不用再为身为一名大学生的财务状况而烦恼。";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "我一下就学会玩 Roblox 了！那么多人在玩 Roblox，Roblox 工作团队也一直愿意为开发者提供优秀资源，Roblox 是一个非常棒的职业方向！";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "我很享受在 Roblox 上创作游戏，因为它将 Facebook 等平台的社交功能通过社区的游戏和创意提升到了新的层次。";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "赚取现金";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "创造你能想象的一切";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "随心制作";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "接触数百万名玩家";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "开发者平台";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Roblox Wiki";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio 完全免费，快来试试看！";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "创作者的话";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "与好友一起创作";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "开始使用";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "回到顶部";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "引号";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio 适用于 Windows 和 Mac";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_zh_cn(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "管理我的游戏";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "前往 Developer Hub";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "继续前往 Roblox Wiki";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "开始创作";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "像你一样的创作者正凭借着他们的创作获得报酬；通过提供游戏内交易项目，我们最优秀的开发者年获利可超过 200 万美元";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "使用我们免费的沉浸式创作引擎";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "你能使用 Roblox Studio 创作任何作品；只需轻轻一点，便能将作品发布至智能手机、平板电脑、游戏主机及虚拟现实设备上";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "融入一个每月超过五千万名来自全球各地、充满热情的玩家所组成的社区";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "Developer Hub 是你在 Roblox 发布游戏的一站式平台。你可以在这里找到种类繁多的教学视频、和其他开发者交流、获取平台更新，浏览我们的 API 参考资料等等。";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Roblox Wiki 包含许多文档、教程和样本，是帮助你学习使用 Roblox Studio 制作游戏的最佳资源";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "我一下就学会玩 Roblox 了！那么多人在玩 Roblox，Roblox 工作团队也一直愿意为开发者提供优秀资源，Roblox 是一个非常棒的职业方向！";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Roblox 给了我专心开发游戏并思考未来职业生涯的空间，我不用再为身为一名大学生的财务状况而烦恼。";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "我很享受在 Roblox 上创作游戏，因为它将 Facebook 等平台的社交功能通过社区的游戏和创意提升到了新的层次。";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Roblox 给了我专心开发游戏并思考未来职业生涯的空间，我不用再为身为一名大学生的财务状况而烦恼。";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "我一下就学会玩 Roblox 了！那么多人在玩 Roblox，Roblox 工作团队也一直愿意为开发者提供优秀资源，Roblox 是一个非常棒的职业方向！";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "我很享受在 Roblox 上创作游戏，因为它将 Facebook 等平台的社交功能通过社区的游戏和创意提升到了新的层次。";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "赚取现金";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "创造你能想象的一切";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "随心制作";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "接触数百万名玩家";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "开发者平台";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Roblox Wiki";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio 完全免费，快来试试看！";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "创作者的话";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "与好友一起创作";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "开始使用";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "回到顶部";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "引号";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio 适用于 Windows 和 Mac";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
