namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_pt_br : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "Gerenciar meus jogos";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "Continuar para o Centro do Desenvolvedor";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Continuar para o Wiki Roblox";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "Comece a criar";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "Criadores como você podem ganhar dinheiro para fazerem aquilo que mais gostam. Nossos melhores desenvolvedores ganham até 2 milhões de dólares por ano fornecendo compras no jogo";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "Com nosso sistema de criação imersivo GRÁTIS";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Roblox Studio permite que você crie e lance qualquer coisa com um clique para: smartphones, tablets, desktops, consoles e dispositivos de realidade virtual";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "Conecte-se com um público gigantesco participando de uma comunidade extremamente empolgada e internacional com mais de 50 milhões de jogadores todo mês";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "O Centro do Desenvolvedor é o local para publicar no Roblox. Aprenda com vários tutoriais, interaja com outros desenvolvedores, confira atualizações de plataformas, consulte nossas referências de API e muito mais.";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "A Wiki Roblox é a fonte definitiva de documento, tutoriais e amostras que vão ajudar você a aprender a fazer jogos com o Roblox Studio";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "Foi muito fácil começar a usar o Roblox. Você pode ter uma carreira inteira nesta plataforma porque ela é tão popular e a equipe deles está sempre fornecendo recursos incríveis para os desenvolvedores.";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "O Roblox permite que eu foque na minha futura carreira potencial de desenvolvedor de jogos sem ter que me preocupar com os problemas financeiros típicos de um universitário.";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "Adoro criar jogos no Roblox pois ele é uma plataforma social. Ele utiliza a socialização de outras plataformas, como o Facebook, e as levam a um novo nível com os jogos e criatividade da comunidade.";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "O Roblox permite que eu foque na minha futura carreira potencial de desenvolvedor de jogos sem ter que me preocupar com os problemas financeiros típicos de um universitário.";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "Foi muito fácil começar a usar o Roblox. Você pode ter uma carreira inteira nesta plataforma porque ela é tão popular e a equipe deles está sempre fornecendo recursos incríveis para os desenvolvedores.";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "Adoro criar jogos no Roblox pois ele é uma plataforma social. Ele utiliza a socialização de outras plataformas, como o Facebook, e as levam a um novo nível com os jogos e criatividade da comunidade.";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "Ganhe dinheiro de verdade";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "Crie qualquer coisa que você possa imaginar";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "Crie qualquer coisa";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "Interaja com milhões de jogadores";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "Centro do desenvolvedor";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Wiki Roblox";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio é GRÁTIS! Experimente hoje!";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "O que nossos criadores estão dizendo";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "Criar com amigos";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "Começando";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "Ir para o topo";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "Aspas";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio está disponível para Windows e Mac";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "Gerenciar meus jogos";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "Continuar para o Centro do Desenvolvedor";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Continuar para o Wiki Roblox";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "Comece a criar";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "Criadores como você podem ganhar dinheiro para fazerem aquilo que mais gostam. Nossos melhores desenvolvedores ganham até 2 milhões de dólares por ano fornecendo compras no jogo";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "Com nosso sistema de criação imersivo GRÁTIS";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Roblox Studio permite que você crie e lance qualquer coisa com um clique para: smartphones, tablets, desktops, consoles e dispositivos de realidade virtual";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "Conecte-se com um público gigantesco participando de uma comunidade extremamente empolgada e internacional com mais de 50 milhões de jogadores todo mês";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "O Centro do Desenvolvedor é o local para publicar no Roblox. Aprenda com vários tutoriais, interaja com outros desenvolvedores, confira atualizações de plataformas, consulte nossas referências de API e muito mais.";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "A Wiki Roblox é a fonte definitiva de documento, tutoriais e amostras que vão ajudar você a aprender a fazer jogos com o Roblox Studio";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "Foi muito fácil começar a usar o Roblox. Você pode ter uma carreira inteira nesta plataforma porque ela é tão popular e a equipe deles está sempre fornecendo recursos incríveis para os desenvolvedores.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "O Roblox permite que eu foque na minha futura carreira potencial de desenvolvedor de jogos sem ter que me preocupar com os problemas financeiros típicos de um universitário.";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "Adoro criar jogos no Roblox pois ele é uma plataforma social. Ele utiliza a socialização de outras plataformas, como o Facebook, e as levam a um novo nível com os jogos e criatividade da comunidade.";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "O Roblox permite que eu foque na minha futura carreira potencial de desenvolvedor de jogos sem ter que me preocupar com os problemas financeiros típicos de um universitário.";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "Foi muito fácil começar a usar o Roblox. Você pode ter uma carreira inteira nesta plataforma porque ela é tão popular e a equipe deles está sempre fornecendo recursos incríveis para os desenvolvedores.";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "Adoro criar jogos no Roblox pois ele é uma plataforma social. Ele utiliza a socialização de outras plataformas, como o Facebook, e as levam a um novo nível com os jogos e criatividade da comunidade.";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "Ganhe dinheiro de verdade";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "Crie qualquer coisa que você possa imaginar";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "Crie qualquer coisa";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "Interaja com milhões de jogadores";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "Centro do desenvolvedor";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Wiki Roblox";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio é GRÁTIS! Experimente hoje!";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "O que nossos criadores estão dizendo";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "Criar com amigos";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "Começando";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "Ir para o topo";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "Aspas";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio está disponível para Windows e Mac";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
