namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_ko_kr : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "내 게임 관리";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "개발자 허브로 계속";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Roblox Wiki로 계속";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "만들기 시작";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "여러분과 같은 개발자들이 하고 싶은 일을 하면서 수익도 창출하고 있습니다. 게임 내 구매 기능 제공을 통해 일 년에 200만 달러 이상의 수익을 올리는 개발자도 있답니다. ";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "몰입형 생성 엔진을 무료로 이용할 수 있어요";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Roblox Studio를 이용해 무엇이든 만들 수 있을 뿐 아니라 클릭 한 번으로 스마트폰, 태블릿, 데스크톱, 콘솔 및 VR 기기에 공개할 수 있습니다.";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "매월 전 세계 5,000만 이상의 플레이어들이 활발히 참여하고 있는 Roblox 커뮤니티에 접속해 수많은 플레이어들을 만나보세요   ";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "개발자 허브는 Roblox 게임 게시에 관한 모든 것을 한곳에서 해결할 수 있는 공간입니다. 다양한 튜토리얼을 통해 폭넓게 배우고, 다른 개발자들을 만나며, 플랫폼 업데이트를 받아보고, API 참조서를 둘러보는 등 다채롭게 활용해 보세요.";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Roblox Wiki는 Roblox Studio에서 게임을 만드는 데 도움을 주는 문서, 튜토리얼 및 샘플 등을 제공하는 최고의 리소스입니다";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "Roblox는 정말 사용하기 쉬운 플랫폼이예요. 인기있을 뿐 아니라 언제나 개발자를 위한 유용한 리소스를 제공해주니 경력을 쌓기에도 최고죠.";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Roblox 덕분에 대학 학비에 대한 걱정 없이 게임 개발과 경력 쌓기에 집중할 수 있었어요.";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "Roblox에서 게임을 만드는 일이 즐거운 이유는 이곳이 소셜 플랫폼이기 때문이죠. Facebook과 같은 소셜 플랫폼을 통해 새로운 차원의 게임을 개발할 수 있을 뿐 아니라 커뮤니티의 창의성을 이용할 수 있게 도와주니까요.";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Roblox 덕분에 대학 학비 걱정 없이 게임 개발과 경력 쌓기에 집중할 수 있었어요.";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "Roblox는 정말 사용하기 쉬운 플랫폼이예요. 인기있을 뿐 아니라 언제나 개발자를 위한 유용한 리소스를 제공해주니 경력을 쌓기에도 최고죠.";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "Roblox에서 게임을 만드는 일이 즐거운 이유는 이곳이 소셜 플랫폼이기 때문이죠. Facebook과 같은 소셜 플랫폼을 통해 새로운 차원의 게임을 개발할 수 있을 뿐 아니라 커뮤니티의 창의성을 이용할 수 있게 도와주니까요";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "상당한 수익까지";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "여러분이 상상하는 모든 것, 지금 만들어보세요! ";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "상상을 현실로";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "수많은 플레이어와의 소통";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "개발자 허브";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Roblox Wiki";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio는 무료입니다! 지금 이용해보세요!";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "Roblox 개발자들의 이야기";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "친구와 만들기";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "시작하기";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "맨 위로 이동";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "따옴표";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio는 Windows와 Mac에서 이용할 수 있습니다";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "내 게임 관리";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "개발자 허브로 계속";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Roblox Wiki로 계속";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "만들기 시작";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "여러분과 같은 개발자들이 하고 싶은 일을 하면서 수익도 창출하고 있습니다. 게임 내 구매 기능 제공을 통해 일 년에 200만 달러 이상의 수익을 올리는 개발자도 있답니다. ";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "몰입형 생성 엔진을 무료로 이용할 수 있어요";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Roblox Studio를 이용해 무엇이든 만들 수 있을 뿐 아니라 클릭 한 번으로 스마트폰, 태블릿, 데스크톱, 콘솔 및 VR 기기에 공개할 수 있습니다.";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "매월 전 세계 5,000만 이상의 플레이어들이 활발히 참여하고 있는 Roblox 커뮤니티에 접속해 수많은 플레이어들을 만나보세요   ";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "개발자 허브는 Roblox 게임 게시에 관한 모든 것을 한곳에서 해결할 수 있는 공간입니다. 다양한 튜토리얼을 통해 폭넓게 배우고, 다른 개발자들을 만나며, 플랫폼 업데이트를 받아보고, API 참조서를 둘러보는 등 다채롭게 활용해 보세요.";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Roblox Wiki는 Roblox Studio에서 게임을 만드는 데 도움을 주는 문서, 튜토리얼 및 샘플 등을 제공하는 최고의 리소스입니다";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "Roblox는 정말 사용하기 쉬운 플랫폼이예요. 인기있을 뿐 아니라 언제나 개발자를 위한 유용한 리소스를 제공해주니 경력을 쌓기에도 최고죠.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Roblox 덕분에 대학 학비에 대한 걱정 없이 게임 개발과 경력 쌓기에 집중할 수 있었어요.";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "Roblox에서 게임을 만드는 일이 즐거운 이유는 이곳이 소셜 플랫폼이기 때문이죠. Facebook과 같은 소셜 플랫폼을 통해 새로운 차원의 게임을 개발할 수 있을 뿐 아니라 커뮤니티의 창의성을 이용할 수 있게 도와주니까요.";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Roblox 덕분에 대학 학비 걱정 없이 게임 개발과 경력 쌓기에 집중할 수 있었어요.";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "Roblox는 정말 사용하기 쉬운 플랫폼이예요. 인기있을 뿐 아니라 언제나 개발자를 위한 유용한 리소스를 제공해주니 경력을 쌓기에도 최고죠.";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "Roblox에서 게임을 만드는 일이 즐거운 이유는 이곳이 소셜 플랫폼이기 때문이죠. Facebook과 같은 소셜 플랫폼을 통해 새로운 차원의 게임을 개발할 수 있을 뿐 아니라 커뮤니티의 창의성을 이용할 수 있게 도와주니까요";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "상당한 수익까지";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "여러분이 상상하는 모든 것, 지금 만들어보세요! ";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "상상을 현실로";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "수많은 플레이어와의 소통";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "개발자 허브";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Roblox Wiki";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio는 무료입니다! 지금 이용해보세요!";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "Roblox 개발자들의 이야기";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "친구와 만들기";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "시작하기";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "맨 위로 이동";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "따옴표";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio는 Windows와 Mac에서 이용할 수 있습니다";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
