namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_ja_jp : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "マイゲームの管理";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "デベロッパーハブへ";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Roblox Wiki に移動する";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "制作を開始";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "あなたのようなゲームクリエーターが、趣味をお金に変えています。トップクラスの開発者は、ゲーム内課金によって年間$200万以上を稼いでいます";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "無料で利用できる没入型ゲーム制作エンジン";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Roblox Studioを使えば何でも制作できて、ワンクリックでスマートフォン、タブレット、ゲームコンソール、VRデバイスで公開することができます";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "月間5000万人以上の熱心なプレイヤーたちが参加している世界的なコミュニティを使って、たくさんの人とつながろう";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "デベロッパーハブは、Robloxで作品公開するのに役立つ機能が一ヶ所にすべて集まった場所です。広範なチュートリアルで学んだり、他の開発者と交流したり、プラットフォームのアップデートをしたり、APIリファレンスを見たり、他にも盛りだくさんです。";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Roblox Wikiでは、解説書、チュートリアル、サンプルなど、あらゆるものにアクセスすることができます。Roblox Studioによるゲーム開発に役立ててください。";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "Robloxは、簡単に使いこなすことができました。最先端のプラットフォームなので、あらゆる経験をつぎ込むことができます。また、Robloxチームは、いつも素晴らしい開発者用リソースを提供してくれます。";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Robloxのおかげで、大学生としての経済的な問題を心配せずに、ゲーム開発や将来のキャリアにつながる可能性があることに集中できています。";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "Robloxでのゲーム制作が楽しいのは、人と交流しながらできるからです。ゲームとコミュニティの創造力を新しい境地に引き上げるには、FacebookのようなプラットフォームのSNS的な要素が必要です。";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Robloxのおかげで、大学生としての経済的な問題を心配せずに、ゲーム開発や将来のキャリアにつながる可能性があることに集中できています。";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "Robloxは、簡単に使いこなすことができました。最先端のプラットフォームなので、あらゆる経験をつぎ込むことができます。また、Robloxチームは、いつも素晴らしい開発者用リソースを提供してくれます。";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "Robloxでのゲーム制作が楽しいのは、人と交流しながらできるからです。ゲームとコミュニティの創造力を新しい境地に引き上げるには、FacebookのようなプラットフォームのSNS的な要素が必要です。";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "実際に現金を稼ぐ";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "想像できるものを何でも作っちゃおう";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "何かを作る";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "数百万人のプレイヤーにリーチ";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "デベロッパーハブ";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Roblox Wiki";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studioは無料です！今すぐ使ってみましょう！";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "クリエーターからのコメント";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "友達と作成";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "始めよう";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "トップに戻る";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "引用符";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studioは、WindowsとMacで利用できます";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "マイゲームの管理";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "デベロッパーハブへ";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Roblox Wiki に移動する";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "制作を開始";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "あなたのようなゲームクリエーターが、趣味をお金に変えています。トップクラスの開発者は、ゲーム内課金によって年間$200万以上を稼いでいます";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "無料で利用できる没入型ゲーム制作エンジン";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Roblox Studioを使えば何でも制作できて、ワンクリックでスマートフォン、タブレット、ゲームコンソール、VRデバイスで公開することができます";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "月間5000万人以上の熱心なプレイヤーたちが参加している世界的なコミュニティを使って、たくさんの人とつながろう";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "デベロッパーハブは、Robloxで作品公開するのに役立つ機能が一ヶ所にすべて集まった場所です。広範なチュートリアルで学んだり、他の開発者と交流したり、プラットフォームのアップデートをしたり、APIリファレンスを見たり、他にも盛りだくさんです。";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Roblox Wikiでは、解説書、チュートリアル、サンプルなど、あらゆるものにアクセスすることができます。Roblox Studioによるゲーム開発に役立ててください。";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "Robloxは、簡単に使いこなすことができました。最先端のプラットフォームなので、あらゆる経験をつぎ込むことができます。また、Robloxチームは、いつも素晴らしい開発者用リソースを提供してくれます。";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Robloxのおかげで、大学生としての経済的な問題を心配せずに、ゲーム開発や将来のキャリアにつながる可能性があることに集中できています。";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "Robloxでのゲーム制作が楽しいのは、人と交流しながらできるからです。ゲームとコミュニティの創造力を新しい境地に引き上げるには、FacebookのようなプラットフォームのSNS的な要素が必要です。";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Robloxのおかげで、大学生としての経済的な問題を心配せずに、ゲーム開発や将来のキャリアにつながる可能性があることに集中できています。";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "Robloxは、簡単に使いこなすことができました。最先端のプラットフォームなので、あらゆる経験をつぎ込むことができます。また、Robloxチームは、いつも素晴らしい開発者用リソースを提供してくれます。";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "Robloxでのゲーム制作が楽しいのは、人と交流しながらできるからです。ゲームとコミュニティの創造力を新しい境地に引き上げるには、FacebookのようなプラットフォームのSNS的な要素が必要です。";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "実際に現金を稼ぐ";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "想像できるものを何でも作っちゃおう";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "何かを作る";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "数百万人のプレイヤーにリーチ";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "デベロッパーハブ";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Roblox Wiki";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studioは無料です！今すぐ使ってみましょう！";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "クリエーターからのコメント";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "友達と作成";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "始めよう";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "トップに戻る";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "引用符";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studioは、WindowsとMacで利用できます";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
