namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_fr_fr : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "Gérer mes jeux";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "Continuer au Hub Developer";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Continuer vers le wiki de Roblox";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "Commencer à créer";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "Les créateurs sont rémunérés pour faire ce qu'ils aiment faire. Les meilleurs développeurs gagnent plus de 2\u00a0millions de dollars par an grâce aux achats en jeu";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "Grâce à notre moteur de création gratuit et immersif";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Roblox Studio vous permet de concevoir sans limite et de publier vos créations d'un seul clic sur smartphone, tablette, ordinateur, console et appareil\u00a0RV";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "Entrez en contact avec une communauté enthousiaste et internationale regroupant plus de 50\u00a0millions de joueurs par mois.";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "Le Hub Developer est l'unique moyen de publier des jeux sur Roblox. Profite d'un large éventail de didacticiels, connecte-toi avec d'autres développeurs, obtiens des mises à jour de plate-forme, parcours nos références d'API, etc.";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Le wiki de Roblox est la base de données centrale regroupant documentation, didacticiels et exemples qui vous aideront à créer des jeux dans Roblox Studio.";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "C'est vraiment très facile de se mettre à Roblox. Cela peut devenir un vrai métier, car c'est une plateforme très dynamique et l'équipe met toujours des ressources géniales à disposition des développeurs.";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Roblox me permet de concentrer mes efforts sur mes compétences de développement et sur mon éventuelle carrière sans avoir à m'inquiéter des difficultés financières liées aux études supérieures.";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "J'aime créer des jeux sur Roblox pour le côté social. Les créations et l'inventivité de la communauté viennent enrichir l'aspect social de plateformes telles que Facebook.";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Roblox me permet de concentrer mes efforts sur mes compétences de développement et sur mon éventuelle carrière sans avoir à m'inquiéter des difficultés financières liées aux études supérieures.";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "C'est vraiment très facile de se mettre à Roblox. Cela peut devenir un vrai métier, car c'est une plateforme très dynamique et l'équipe met toujours des ressources géniales à disposition des développeurs.";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "J'aime créer des jeux sur Roblox pour le côté social. Les créations et l'inventivité de la communauté viennent enrichir l'aspect social de plateformes telles que Facebook.";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "Gagnez de l'argent";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "Donnez vie à votre imagination";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "Créez ce que vous voulez";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "Rejoignez des millions de joueurs";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "Hub Developer";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Wiki de Roblox";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio est gratuit\u00a0! Essayez-le dès maintenant\u00a0!";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "Ce que les créateurs en disent";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "Créer entre amis";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "Premiers pas";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "Haut de la page";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "Point d'interrogation";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio est disponible pour Windows et Mac";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "Gérer mes jeux";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "Continuer au Hub Developer";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Continuer vers le wiki de Roblox";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "Commencer à créer";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "Les créateurs sont rémunérés pour faire ce qu'ils aiment faire. Les meilleurs développeurs gagnent plus de 2\u00a0millions de dollars par an grâce aux achats en jeu";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "Grâce à notre moteur de création gratuit et immersif";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Roblox Studio vous permet de concevoir sans limite et de publier vos créations d'un seul clic sur smartphone, tablette, ordinateur, console et appareil\u00a0RV";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "Entrez en contact avec une communauté enthousiaste et internationale regroupant plus de 50\u00a0millions de joueurs par mois.";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "Le Hub Developer est l'unique moyen de publier des jeux sur Roblox. Profite d'un large éventail de didacticiels, connecte-toi avec d'autres développeurs, obtiens des mises à jour de plate-forme, parcours nos références d'API, etc.";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Le wiki de Roblox est la base de données centrale regroupant documentation, didacticiels et exemples qui vous aideront à créer des jeux dans Roblox Studio.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "C'est vraiment très facile de se mettre à Roblox. Cela peut devenir un vrai métier, car c'est une plateforme très dynamique et l'équipe met toujours des ressources géniales à disposition des développeurs.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Roblox me permet de concentrer mes efforts sur mes compétences de développement et sur mon éventuelle carrière sans avoir à m'inquiéter des difficultés financières liées aux études supérieures.";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "J'aime créer des jeux sur Roblox pour le côté social. Les créations et l'inventivité de la communauté viennent enrichir l'aspect social de plateformes telles que Facebook.";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Roblox me permet de concentrer mes efforts sur mes compétences de développement et sur mon éventuelle carrière sans avoir à m'inquiéter des difficultés financières liées aux études supérieures.";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "C'est vraiment très facile de se mettre à Roblox. Cela peut devenir un vrai métier, car c'est une plateforme très dynamique et l'équipe met toujours des ressources géniales à disposition des développeurs.";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "J'aime créer des jeux sur Roblox pour le côté social. Les créations et l'inventivité de la communauté viennent enrichir l'aspect social de plateformes telles que Facebook.";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "Gagnez de l'argent";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "Donnez vie à votre imagination";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "Créez ce que vous voulez";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "Rejoignez des millions de joueurs";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "Hub Developer";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Wiki de Roblox";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio est gratuit\u00a0! Essayez-le dès maintenant\u00a0!";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "Ce que les créateurs en disent";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "Créer entre amis";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "Premiers pas";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "Haut de la page";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "Point d'interrogation";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio est disponible pour Windows et Mac";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
