namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_es_es : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "Administrar mis juegos";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "Continuar a Centro para desarrolladores";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Continuar a wiki de Roblox";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "Empezar a crear";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "Creadores como tú ganan dinero por hacer algo que les apasiona. Nuestros mejores desarrolladores reciben ingresos de más de 2 millones de dólares al año por proporcionar compras dentro de la aplicación.";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "Con nuestro motor de creación GRATUITO e inmersivo";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Roblox te permite crear cualquier cosa y publicarla con un solo clic en teléfonos inteligentes, tablets, ordenadores de sobremesa y dispositivos de realidad virtual.";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "Conéctate con una audiencia masiva, accediendo a una apasionada comunidad internacional de más de 50 millones de jugadores mensuales.";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "El centro para desarrolladores es un sitio integral para la publicación en Roblox. Ahí puedes encontrar tutoriales; conectarte con otros programadores; obtener actualizaciones de la plataforma; navegar por nuestras referencias de API y mucho más.";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "La wiki de Roblox es el mejor recurso para encontrar documentación, tutoriales y muestras con las que aprenderás a desarrollar juegos en Roblox Studio";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "Fue muy fácil empezar en Roblox. Se puede convertir en una carrera profesional porque la plataforma es muy completa y el equipo que la respalda proporciona increíbles recursos a los desarrolladores.";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Gracias a Roblox me puedo enfocar en crear mis propios juegos y hacer una carrera como desarrollador, sin tener las dificultades económicas típicas de un estudiante universitario.";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "Me apasiona crear juegos en Roblox por su aspecto social. Roblox lleva la socialización de plataformas como Facebook a otro nivel, gracias a los juegos y a la creatividad de la comunidad.";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Gracias a Roblox me puedo enfocar en crear mis propios juegos y hacer una carrera como desarrollador, sin tener las dificultades económicas típicas de un estudiante universitario.";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "Fue muy fácil empezar en Roblox. Se puede convertir en una carrera profesional porque la plataforma es muy completa y el equipo que la respalda proporciona increíbles recursos a los desarrolladores.";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "Me apasiona crear juegos en Roblox por su aspecto social. Roblox lleva la socialización de plataformas como Facebook a otro nivel, gracias a los juegos y a la creatividad de la comunidad.";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "Gana bastante dinero";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "Crea cualquier cosa que llegues a imaginar";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "Crea cualquier cosa";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "Llega a millones de jugadores";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "Centro para desarrolladores";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Wiki de Roblox";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "¡Roblox Studio es GRATIS! ¡Pruébalo ya!";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "Esto es lo que opinan algunos de nuestros creadores";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "Crear con amigos";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "Primeros pasos";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "Ir arriba";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "Comillas";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio está disponible en Windows y Mac.";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "Administrar mis juegos";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "Continuar a Centro para desarrolladores";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Continuar a wiki de Roblox";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "Empezar a crear";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "Creadores como tú ganan dinero por hacer algo que les apasiona. Nuestros mejores desarrolladores reciben ingresos de más de 2 millones de dólares al año por proporcionar compras dentro de la aplicación.";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "Con nuestro motor de creación GRATUITO e inmersivo";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Roblox te permite crear cualquier cosa y publicarla con un solo clic en teléfonos inteligentes, tablets, ordenadores de sobremesa y dispositivos de realidad virtual.";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "Conéctate con una audiencia masiva, accediendo a una apasionada comunidad internacional de más de 50 millones de jugadores mensuales.";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "El centro para desarrolladores es un sitio integral para la publicación en Roblox. Ahí puedes encontrar tutoriales; conectarte con otros programadores; obtener actualizaciones de la plataforma; navegar por nuestras referencias de API y mucho más.";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "La wiki de Roblox es el mejor recurso para encontrar documentación, tutoriales y muestras con las que aprenderás a desarrollar juegos en Roblox Studio";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "Fue muy fácil empezar en Roblox. Se puede convertir en una carrera profesional porque la plataforma es muy completa y el equipo que la respalda proporciona increíbles recursos a los desarrolladores.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Gracias a Roblox me puedo enfocar en crear mis propios juegos y hacer una carrera como desarrollador, sin tener las dificultades económicas típicas de un estudiante universitario.";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "Me apasiona crear juegos en Roblox por su aspecto social. Roblox lleva la socialización de plataformas como Facebook a otro nivel, gracias a los juegos y a la creatividad de la comunidad.";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Gracias a Roblox me puedo enfocar en crear mis propios juegos y hacer una carrera como desarrollador, sin tener las dificultades económicas típicas de un estudiante universitario.";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "Fue muy fácil empezar en Roblox. Se puede convertir en una carrera profesional porque la plataforma es muy completa y el equipo que la respalda proporciona increíbles recursos a los desarrolladores.";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "Me apasiona crear juegos en Roblox por su aspecto social. Roblox lleva la socialización de plataformas como Facebook a otro nivel, gracias a los juegos y a la creatividad de la comunidad.";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "Gana bastante dinero";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "Crea cualquier cosa que llegues a imaginar";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "Crea cualquier cosa";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "Llega a millones de jugadores";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "Centro para desarrolladores";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Wiki de Roblox";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "¡Roblox Studio es GRATIS! ¡Pruébalo ya!";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "Esto es lo que opinan algunos de nuestros creadores";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "Crear con amigos";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "Primeros pasos";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "Ir arriba";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "Comillas";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio está disponible en Windows y Mac.";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
