namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides DevelopLandingResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class DevelopLandingResources_de_de : DevelopLandingResources_en_us, IDevelopLandingResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.ManageMyGames"
	/// button label
	/// English String: "Manage my games"
	/// </summary>
	public override string ActionManageMyGames => "Meine Spiele verwalten";

	/// <summary>
	/// Key: "Action.RobloxDevHub"
	/// English String: "Continue to the Developer Hub"
	/// </summary>
	public override string ActionRobloxDevHub => "Weiter zu Developer Hub";

	/// <summary>
	/// Key: "Action.RobloxWiki"
	/// button label
	/// English String: "Continue to Roblox Wiki"
	/// </summary>
	public override string ActionRobloxWiki => "Weiter zum Roblox-Wiki";

	/// <summary>
	/// Key: "Action.StartCreating"
	/// button label
	/// English String: "Start Creating"
	/// </summary>
	public override string ActionStartCreating => "Erstelle etwas";

	/// <summary>
	/// Key: "Description.EarnSeriousCash"
	/// description
	/// English String: "Creators like you are getting paid for what they love to do. Our top developers are earning over $2M a year by providing in-game purchases"
	/// </summary>
	public override string DescriptionEarnSeriousCash => "Entwickler wie du werden für ihre Lieblingsbeschäftigung bezahlt. Unsere Top-Entwickler verdienen über Verkäufe im Spiel mehr als 2\u00a0Mio. USD pro Jahr.";

	/// <summary>
	/// Key: "Description.FreeImmersiveCreationEngine"
	/// subtext
	/// English String: "With our FREE and immersive creation engine"
	/// </summary>
	public override string DescriptionFreeImmersiveCreationEngine => "Mit unserer KOSTENLOSEN und immersiven Entwickler-Engine";

	/// <summary>
	/// Key: "Description.MakeAnything"
	/// text paragraph on page
	/// English String: "Roblox Studio lets you create anything and release with one click to smartphones, tablets, desktops, consoles, and virtual reality devices"
	/// </summary>
	public override string DescriptionMakeAnything => "Mit Roblox Studio kannst du erschaffen, was du willst, und dein Werk mit nur einem Klick für Smartphones, Tablets, Computer, Konsolen und VR-Geräte veröffentlichen.";

	/// <summary>
	/// Key: "Description.ReachMillionsPlayers"
	/// description
	/// English String: "Connect with a massive audience by tapping into an incredibly enthusiastic and international community of over 50 million monthly players"
	/// </summary>
	public override string DescriptionReachMillionsPlayers => "Erreiche ein riesiges Publikum, indem du Teil einer unglaublich passionierten und internationalen Community mit über 50 Millionen monatlichen Spielern wirst.";

	/// <summary>
	/// Key: "Description.RobloxDevHub"
	/// English String: "The Developer Hub is your one-stop shop for publishing on Roblox. Learn from a wide set of tutorials, connect with other developers, get platform updates, browse our API references, and much more."
	/// </summary>
	public override string DescriptionRobloxDevHub => "Der Developer Hub ist die zentrale Anlaufstelle für die Veröffentlichung auf Roblox. Hier kannst du aus einer Vielzahl von Tutorials lernen, andere Entwickler treffen, Plattform-Updates erhalten, unsere API-Referenzen durchsuchen und viel mehr.";

	/// <summary>
	/// Key: "Description.RobloxWiki"
	/// description
	/// English String: "The Roblox Wiki is the ultimate resource for documentation, tutorials, and samples which will help you learn to make games with Roblox Studio"
	/// </summary>
	public override string DescriptionRobloxWiki => "Das Roblox-Wiki ist die ultimative Informationsdatenbank für Dokumentationen, Tutorials und Beispiele. Damit lernst du ganz einfach, wie du Spiele mit Roblox Studio entwickeln kannst.";

	/// <summary>
	/// Key: "Description.TestimonialAlexBalfanz"
	/// testimonial
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialAlexBalfanz => "Roblox ist äußerst benutzerfreundlich. Man kann dort echt Karriere machen, weil die Plattform so beliebt ist. Und das Team dort bietet uns Entwicklern immer tolle Ressourcen.";

	/// <summary>
	/// Key: "Description.TestimonialAndrewBereza"
	/// testimonial text
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialAndrewBereza => "Mit Roblox kann ich mich voll und ganz auf das Erstellen von Spielen und eine mögliche Karriere als Spieleentwickler konzentrieren, ohne mir Sorgen um finanzielle Schwierigkeiten als Student machen zu müssen.";

	/// <summary>
	/// Key: "Description.TestimonialJacksonMunsell"
	/// testimonial
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialJacksonMunsell => "Ich liebe es, Spiele auf Roblox zu entwickeln, weil es eine soziale Erfahrung ist. Die Spiele und die kreative Energie der Community heben das soziale Element von Netzwerken wie Facebook auf eine völlig neue Stufe.";

	/// <summary>
	/// Key: "Description.TestimonialOne"
	/// testimonial content
	/// English String: "Roblox allows me to focus on my game development and potential future career without having to worry about the financial hardships of being a college student."
	/// </summary>
	public override string DescriptionTestimonialOne => "Mit Roblox kann ich mich voll und ganz auf das Erstellen von Spielen und eine mögliche Karriere als Spieleentwickler konzentrieren, ohne mir Sorgen um finanzielle Schwierigkeiten als Student machen zu müssen.";

	/// <summary>
	/// Key: "Description.TestimonialThree"
	/// testimonial text
	/// English String: "Roblox was so easy to get into. You can have a whole career on it because it’s such a hot platform and the team there is always providing great resources for developers."
	/// </summary>
	public override string DescriptionTestimonialThree => "Roblox ist äußerst benutzerfreundlich. Man kann dort echt Karriere machen, weil die Plattform so beliebt ist. Und das Team dort bietet uns Entwicklern immer tolle Ressourcen.";

	/// <summary>
	/// Key: "Description.TestimonialTwo"
	/// description
	/// English String: "I enjoy creating games on Roblox because it’s social. It takes the socialization of platforms like Facebook to a new level with the games and creativity of the community."
	/// </summary>
	public override string DescriptionTestimonialTwo => "Ich liebe es, Spiele auf Roblox zu entwickeln, weil es eine soziale Erfahrung ist. Die Spiele und die kreative Energie der Community heben das soziale Element von Netzwerken wie Facebook auf eine völlig neue Stufe.";

	/// <summary>
	/// Key: "Heading.EarnSeriousCash"
	/// heading
	/// English String: "Earn Serious Cash"
	/// </summary>
	public override string HeadingEarnSeriousCash => "Verdiene echtes Geld";

	/// <summary>
	/// Key: "Heading.MakeAnything"
	/// heading
	/// English String: "Make Anything You Can Imagine"
	/// </summary>
	public override string HeadingMakeAnything => "Erschaffe alles, was du dir vorstellen kannst";

	/// <summary>
	/// Key: "Heading.MakeAnythingSub"
	/// section heading
	/// English String: "Make Anything"
	/// </summary>
	public override string HeadingMakeAnythingSub => "Erschaffe, was du willst";

	/// <summary>
	/// Key: "Heading.ReachMillionsPlayers"
	/// heading
	/// English String: "Reach Millions of Players"
	/// </summary>
	public override string HeadingReachMillionsPlayers => "Erreiche Millionen von Spielern";

	/// <summary>
	/// Key: "Heading.RobloxDevHub"
	/// English String: "Developer Hub"
	/// </summary>
	public override string HeadingRobloxDevHub => "Developer Hub";

	/// <summary>
	/// Key: "Heading.RobloxWiki"
	/// heading
	/// English String: "Roblox Wiki"
	/// </summary>
	public override string HeadingRobloxWiki => "Roblox-Wiki";

	/// <summary>
	/// Key: "Heading.Studio"
	/// heading
	/// English String: "Studio"
	/// </summary>
	public override string HeadingStudio => "Studio";

	/// <summary>
	/// Key: "Heading.TryFreeRobloxStudioToday"
	/// heading
	/// English String: "Roblox Studio is FREE! Try it out today!"
	/// </summary>
	public override string HeadingTryFreeRobloxStudioToday => "Roblox Studio ist GRATIS! Probiere es noch heute aus!";

	/// <summary>
	/// Key: "Heading.WhatCreatorsSaying"
	/// heading
	/// English String: "What Our Creators Are Saying"
	/// </summary>
	public override string HeadingWhatCreatorsSaying => "Das sagen unsere Entwickler";

	/// <summary>
	/// Key: "Label.CreateWithFriends"
	/// label
	/// English String: "Create With Friends"
	/// </summary>
	public override string LabelCreateWithFriends => "Erstelle etwas mit Freunden";

	/// <summary>
	/// Key: "Label.GetStarted"
	/// label
	/// English String: "Get Started"
	/// </summary>
	public override string LabelGetStarted => "Loslegen";

	/// <summary>
	/// Key: "Label.GoToTop"
	/// label
	/// English String: "Go to top"
	/// </summary>
	public override string LabelGoToTop => "Zum Seitenanfang";

	/// <summary>
	/// Key: "Label.QuotationMark"
	/// image alt text for accessibility
	/// English String: "Quotation Mark"
	/// </summary>
	public override string LabelQuotationMark => "Anführungszeichen";

	/// <summary>
	/// Key: "Label.RobloxStudioOnWindowsAndMac"
	/// label
	/// English String: "Roblox Studio is available on Windows and Mac"
	/// </summary>
	public override string LabelRobloxStudioOnWindowsAndMac => "Roblox Studio ist für Windows und Mac erhältlich.";

	/// <summary>
	/// Key: "Label.TestimonialOneName"
	/// label - no need to translate this
	/// English String: "Andrew Bereza"
	/// </summary>
	public override string LabelTestimonialOneName => "Andrew Bereza";

	/// <summary>
	/// Key: "Label.TestimonialThreeName"
	/// name - please do not translate this
	/// English String: "Alex Balfanz"
	/// </summary>
	public override string LabelTestimonialThreeName => "Alex Balfanz";

	/// <summary>
	/// Key: "Label.TestimonialTwoName"
	/// name - please do not translate this
	/// English String: "Jackson Munsell"
	/// </summary>
	public override string LabelTestimonialTwoName => "Jackson Munsell";

	public DevelopLandingResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionManageMyGames()
	{
		return "Meine Spiele verwalten";
	}

	protected override string _GetTemplateForActionRobloxDevHub()
	{
		return "Weiter zu Developer Hub";
	}

	protected override string _GetTemplateForActionRobloxWiki()
	{
		return "Weiter zum Roblox-Wiki";
	}

	protected override string _GetTemplateForActionStartCreating()
	{
		return "Erstelle etwas";
	}

	protected override string _GetTemplateForDescriptionEarnSeriousCash()
	{
		return "Entwickler wie du werden für ihre Lieblingsbeschäftigung bezahlt. Unsere Top-Entwickler verdienen über Verkäufe im Spiel mehr als 2\u00a0Mio. USD pro Jahr.";
	}

	protected override string _GetTemplateForDescriptionFreeImmersiveCreationEngine()
	{
		return "Mit unserer KOSTENLOSEN und immersiven Entwickler-Engine";
	}

	protected override string _GetTemplateForDescriptionMakeAnything()
	{
		return "Mit Roblox Studio kannst du erschaffen, was du willst, und dein Werk mit nur einem Klick für Smartphones, Tablets, Computer, Konsolen und VR-Geräte veröffentlichen.";
	}

	protected override string _GetTemplateForDescriptionReachMillionsPlayers()
	{
		return "Erreiche ein riesiges Publikum, indem du Teil einer unglaublich passionierten und internationalen Community mit über 50 Millionen monatlichen Spielern wirst.";
	}

	protected override string _GetTemplateForDescriptionRobloxDevHub()
	{
		return "Der Developer Hub ist die zentrale Anlaufstelle für die Veröffentlichung auf Roblox. Hier kannst du aus einer Vielzahl von Tutorials lernen, andere Entwickler treffen, Plattform-Updates erhalten, unsere API-Referenzen durchsuchen und viel mehr.";
	}

	protected override string _GetTemplateForDescriptionRobloxWiki()
	{
		return "Das Roblox-Wiki ist die ultimative Informationsdatenbank für Dokumentationen, Tutorials und Beispiele. Damit lernst du ganz einfach, wie du Spiele mit Roblox Studio entwickeln kannst.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAlexBalfanz()
	{
		return "Roblox ist äußerst benutzerfreundlich. Man kann dort echt Karriere machen, weil die Plattform so beliebt ist. Und das Team dort bietet uns Entwicklern immer tolle Ressourcen.";
	}

	protected override string _GetTemplateForDescriptionTestimonialAndrewBereza()
	{
		return "Mit Roblox kann ich mich voll und ganz auf das Erstellen von Spielen und eine mögliche Karriere als Spieleentwickler konzentrieren, ohne mir Sorgen um finanzielle Schwierigkeiten als Student machen zu müssen.";
	}

	protected override string _GetTemplateForDescriptionTestimonialJacksonMunsell()
	{
		return "Ich liebe es, Spiele auf Roblox zu entwickeln, weil es eine soziale Erfahrung ist. Die Spiele und die kreative Energie der Community heben das soziale Element von Netzwerken wie Facebook auf eine völlig neue Stufe.";
	}

	protected override string _GetTemplateForDescriptionTestimonialOne()
	{
		return "Mit Roblox kann ich mich voll und ganz auf das Erstellen von Spielen und eine mögliche Karriere als Spieleentwickler konzentrieren, ohne mir Sorgen um finanzielle Schwierigkeiten als Student machen zu müssen.";
	}

	protected override string _GetTemplateForDescriptionTestimonialThree()
	{
		return "Roblox ist äußerst benutzerfreundlich. Man kann dort echt Karriere machen, weil die Plattform so beliebt ist. Und das Team dort bietet uns Entwicklern immer tolle Ressourcen.";
	}

	protected override string _GetTemplateForDescriptionTestimonialTwo()
	{
		return "Ich liebe es, Spiele auf Roblox zu entwickeln, weil es eine soziale Erfahrung ist. Die Spiele und die kreative Energie der Community heben das soziale Element von Netzwerken wie Facebook auf eine völlig neue Stufe.";
	}

	protected override string _GetTemplateForHeadingEarnSeriousCash()
	{
		return "Verdiene echtes Geld";
	}

	protected override string _GetTemplateForHeadingMakeAnything()
	{
		return "Erschaffe alles, was du dir vorstellen kannst";
	}

	protected override string _GetTemplateForHeadingMakeAnythingSub()
	{
		return "Erschaffe, was du willst";
	}

	protected override string _GetTemplateForHeadingReachMillionsPlayers()
	{
		return "Erreiche Millionen von Spielern";
	}

	protected override string _GetTemplateForHeadingRobloxDevHub()
	{
		return "Developer Hub";
	}

	protected override string _GetTemplateForHeadingRobloxWiki()
	{
		return "Roblox-Wiki";
	}

	protected override string _GetTemplateForHeadingStudio()
	{
		return "Studio";
	}

	protected override string _GetTemplateForHeadingTryFreeRobloxStudioToday()
	{
		return "Roblox Studio ist GRATIS! Probiere es noch heute aus!";
	}

	protected override string _GetTemplateForHeadingWhatCreatorsSaying()
	{
		return "Das sagen unsere Entwickler";
	}

	protected override string _GetTemplateForLabelCreateWithFriends()
	{
		return "Erstelle etwas mit Freunden";
	}

	protected override string _GetTemplateForLabelGetStarted()
	{
		return "Loslegen";
	}

	protected override string _GetTemplateForLabelGoToTop()
	{
		return "Zum Seitenanfang";
	}

	protected override string _GetTemplateForLabelQuotationMark()
	{
		return "Anführungszeichen";
	}

	protected override string _GetTemplateForLabelRobloxStudioOnWindowsAndMac()
	{
		return "Roblox Studio ist für Windows und Mac erhältlich.";
	}

	protected override string _GetTemplateForLabelTestimonialOneName()
	{
		return "Andrew Bereza";
	}

	protected override string _GetTemplateForLabelTestimonialThreeName()
	{
		return "Alex Balfanz";
	}

	protected override string _GetTemplateForLabelTestimonialTwoName()
	{
		return "Jackson Munsell";
	}
}
