namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides CatalogResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class CatalogResources_pt_br : CatalogResources_en_us, ICatalogResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Action.Dialog.AddGearOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogAddGearOk => "OK";

	/// <summary>
	/// Key: "Action.Filter.Apply"
	/// English String: "Apply"
	/// </summary>
	public override string ActionFilterApply => "Aplicar";

	/// <summary>
	/// Key: "Action.Filter.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionFilterCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Go"
	/// English String: "Go"
	/// </summary>
	public override string ActionGo => "Ok";

	/// <summary>
	/// Key: "Action.ViewAllItems"
	/// English String: "View All Items"
	/// </summary>
	public override string ActionViewAllItems => "Ver todos os itens";

	/// <summary>
	/// Key: "Description.Dialog.AddGearBody"
	/// English String: "To add gear to your game, find an item in the catalog and click the Add to Game button. The item will automatically be allowed in game, and you'll receive a commission on every copy sold from your game page. (You can only add gear that's for sale.)"
	/// </summary>
	public override string DescriptionDialogAddGearBody => "Para adicionar equipamento ao seu jogo, encontre um item no catálogo e clique no botão “Adicionar equipamento”. O item será automaticamente permitido no jogo e você receberá uma comissão a cada cópia vendida na sua página de jogo. (Você só pode adicionar equipamentos que estejam à venda.)";

	/// <summary>
	/// Key: "Heading.CatalogCategory"
	/// English String: "Category"
	/// </summary>
	public override string HeadingCatalogCategory => "Categoria";

	/// <summary>
	/// Key: "Heading.CatalogPage"
	/// English String: "Catalog"
	/// </summary>
	public override string HeadingCatalogPage => "Catálogo";

	/// <summary>
	/// Key: "Label.AllFeaturedItems"
	/// English String: "View All Featured Items"
	/// </summary>
	public override string LabelAllFeaturedItems => "Ver todos os itens em destaque";

	/// <summary>
	/// Key: "Label.AllGenres"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelAllGenres => "Todos os gêneros";

	/// <summary>
	/// Key: "Label.Amazon"
	/// label
	/// English String: "Amazon"
	/// </summary>
	public override string LabelAmazon => "Amazon";

	/// <summary>
	/// Key: "Label.BreadCrumb.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelBreadCrumbFree => "Grátis";

	/// <summary>
	/// Key: "Label.BreadCrumb.Group"
	/// English String: "Group:"
	/// </summary>
	public override string LabelBreadCrumbGroup => "Grupo:";

	/// <summary>
	/// Key: "Label.Bundle"
	/// Bundle
	/// English String: "Bundle"
	/// </summary>
	public override string LabelBundle => "Pacote";

	/// <summary>
	/// Key: "Label.Bundles"
	/// Bundles
	/// English String: "Bundles"
	/// </summary>
	public override string LabelBundles => "Pacotes";

	/// <summary>
	/// Key: "Label.Card.CreatorBy"
	/// English String: "By"
	/// </summary>
	public override string LabelCardCreatorBy => "De ";

	/// <summary>
	/// Key: "Label.Card.PriceWas"
	/// English String: "Was"
	/// </summary>
	public override string LabelCardPriceWas => "Era";

	/// <summary>
	/// Key: "Label.Card.Remaining"
	/// English String: "Remaining:"
	/// </summary>
	public override string LabelCardRemaining => "Restante:";

	/// <summary>
	/// Key: "Label.CategoryAttributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelCategoryAttributes => "Atributos";

	/// <summary>
	/// Key: "Label.CategoryType"
	/// English String: "Type"
	/// </summary>
	public override string LabelCategoryType => "Tipo";

	/// <summary>
	/// Key: "Label.CommunityCreations"
	/// UGC items
	/// English String: " Community Creations"
	/// </summary>
	public override string LabelCommunityCreations => " Criações da comunidade";

	/// <summary>
	/// Key: "Label.Dialog.AddGearTitle"
	/// English String: "Add Gear to Your Game"
	/// </summary>
	public override string LabelDialogAddGearTitle => "Adicione equipamento ao seu jogo";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Emotes
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.FeaturedBundles"
	/// Featured Bundles
	/// English String: "Featured Bundles"
	/// </summary>
	public override string LabelFeaturedBundles => "Pacotes em destaque";

	/// <summary>
	/// Key: "Label.FeaturedEmotes"
	/// Featured Emotes
	/// English String: "Featured Emotes"
	/// </summary>
	public override string LabelFeaturedEmotes => "Emotes em destaque";

	/// <summary>
	/// Key: "Label.Filter.ByTime"
	/// English String: "By Time"
	/// </summary>
	public override string LabelFilterByTime => "Por tempo";

	/// <summary>
	/// Key: "Label.Filter.Category"
	/// English String: "Category"
	/// </summary>
	public override string LabelFilterCategory => "Categoria";

	/// <summary>
	/// Key: "Label.Filter.Creator"
	/// English String: "Creator"
	/// </summary>
	public override string LabelFilterCreator => "Criador";

	/// <summary>
	/// Key: "Label.Filter.Filter"
	/// English String: "Filter"
	/// </summary>
	public override string LabelFilterFilter => "Filtro";

	/// <summary>
	/// Key: "Label.Filter.Filters"
	/// English String: "Filters"
	/// </summary>
	public override string LabelFilterFilters => "Filtros";

	/// <summary>
	/// Key: "Label.Filter.Genre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Gênero";

	/// <summary>
	/// Key: "Label.Filter.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string LabelFilterHide => "Esconder";

	/// <summary>
	/// Key: "Label.Filter.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelFilterPrice => "Preço";

	/// <summary>
	/// Key: "Label.Filter.PriceMax"
	/// English String: "Max"
	/// </summary>
	public override string LabelFilterPriceMax => "Máx.";

	/// <summary>
	/// Key: "Label.Filter.PriceMin"
	/// English String: "Min"
	/// </summary>
	public override string LabelFilterPriceMin => "Mín.";

	/// <summary>
	/// Key: "Label.Filter.PriceTo"
	/// English String: "To"
	/// </summary>
	public override string LabelFilterPriceTo => "Para ";

	/// <summary>
	/// Key: "Label.Filter.Show"
	/// English String: "Show"
	/// </summary>
	public override string LabelFilterShow => "Exibir";

	/// <summary>
	/// Key: "Label.Filter.Sorting"
	/// English String: "Sorting"
	/// </summary>
	public override string LabelFilterSorting => "Ordem";

	/// <summary>
	/// Key: "Label.Filter.UnavailableItems"
	/// English String: "Unavailable Items"
	/// </summary>
	public override string LabelFilterUnavailableItems => "Itens não disponíveis";

	/// <summary>
	/// Key: "Label.GoogleOnly"
	/// label
	/// English String: "Google Only"
	/// </summary>
	public override string LabelGoogleOnly => "Somente Google";

	/// <summary>
	/// Key: "Label.Ios"
	/// label
	/// English String: "IOS"
	/// </summary>
	public override string LabelIos => "IOS";

	/// <summary>
	/// Key: "Label.Mobile"
	/// label
	/// English String: "Mobile"
	/// </summary>
	public override string LabelMobile => "Dispositivo móvel";

	/// <summary>
	/// Key: "Label.New"
	/// label
	/// English String: "New"
	/// </summary>
	public override string LabelNew => "Novo";

	/// <summary>
	/// Key: "Label.Rthro"
	/// Rthro is "Anthro" but we replaced the beginning of the word with an "R" to align with "R6" and "R15"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.Sale"
	/// label
	/// English String: "Sale"
	/// </summary>
	public override string LabelSale => "Promoção";

	/// <summary>
	/// Key: "Label.SearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Pesquisar";

	/// <summary>
	/// Key: "Label.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string LabelSeeAll => "Ver todos";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Nome de usuário";

	/// <summary>
	/// Key: "Label.Xbox"
	/// label
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "LabelAccessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Acessórios";

	/// <summary>
	/// Key: "LabelAccessoryAll"
	/// English String: "All Accessories"
	/// </summary>
	public override string LabelAccessoryAll => "Todos os acessórios";

	/// <summary>
	/// Key: "LabelAccessoryBack"
	/// English String: "Back"
	/// </summary>
	public override string LabelAccessoryBack => "Costas";

	/// <summary>
	/// Key: "LabelAccessoryFace"
	/// English String: "Face"
	/// </summary>
	public override string LabelAccessoryFace => "Rosto";

	/// <summary>
	/// Key: "LabelAccessoryFront"
	/// English String: "Front"
	/// </summary>
	public override string LabelAccessoryFront => "Frente";

	/// <summary>
	/// Key: "LabelAccessoryHair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelAccessoryHair => "Cabelo";

	/// <summary>
	/// Key: "LabelAccessoryHats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelAccessoryHats => "Chapéus";

	/// <summary>
	/// Key: "LabelAccessoryNeck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelAccessoryNeck => "Pescoço";

	/// <summary>
	/// Key: "LabelAccessoryShoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelAccessoryShoulder => "Ombro";

	/// <summary>
	/// Key: "LabelAccessoryWaist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelAccessoryWaist => "Cintura";

	/// <summary>
	/// Key: "LabelAll"
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Todas";

	/// <summary>
	/// Key: "LabelAllBodyParts"
	/// English String: "All Body Parts"
	/// </summary>
	public override string LabelAllBodyParts => "Todas as partes do corpo";

	/// <summary>
	/// Key: "LabelAllCategories"
	/// English String: "All Categories"
	/// </summary>
	public override string LabelAllCategories => "Todas as categorias";

	/// <summary>
	/// Key: "LabelAllClothing"
	/// English String: "All Clothing"
	/// </summary>
	public override string LabelAllClothing => "Todas as roupas";

	/// <summary>
	/// Key: "LabelAllCollectibles"
	/// English String: "All Collectibles"
	/// </summary>
	public override string LabelAllCollectibles => "Todos os colecionáveis";

	/// <summary>
	/// Key: "LabelAllCreators"
	/// English String: "All Creators"
	/// </summary>
	public override string LabelAllCreators => "Todos os criadores";

	/// <summary>
	/// Key: "LabelAllCurrency"
	/// English String: "All Currency"
	/// </summary>
	public override string LabelAllCurrency => "Todas as moedas";

	/// <summary>
	/// Key: "LabelAllFeatured"
	/// English String: "All Featured Items"
	/// </summary>
	public override string LabelAllFeatured => "Todos os itens em destaque";

	/// <summary>
	/// Key: "LabelAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelAllTime => "Todos os tempos";

	/// <summary>
	/// Key: "LabelAnimations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animações";

	/// <summary>
	/// Key: "LabelAnyPrice"
	/// English String: "Any Price"
	/// </summary>
	public override string LabelAnyPrice => "Qualquer preço";

	/// <summary>
	/// Key: "LabelAvatarAnimations"
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Animações de avatar";

	/// <summary>
	/// Key: "LabelBestselling"
	/// English String: "Bestselling"
	/// </summary>
	public override string LabelBestselling => "Mais vendidos";

	/// <summary>
	/// Key: "LabelBodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string LabelBodyParts => "Parte do corpo";

	/// <summary>
	/// Key: "LabelClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string LabelClothing => "Roupas";

	/// <summary>
	/// Key: "LabelCollectibleAccessories"
	/// English String: "Collectible Accessories"
	/// </summary>
	public override string LabelCollectibleAccessories => "Acessórios colecionáveis";

	/// <summary>
	/// Key: "LabelCollectibleFaces"
	/// English String: "Collectible Faces"
	/// </summary>
	public override string LabelCollectibleFaces => "Rostos colecionáveis";

	/// <summary>
	/// Key: "LabelCollectibleGear"
	/// English String: "Collectible Gear"
	/// </summary>
	public override string LabelCollectibleGear => "Equipamento colecionável";

	/// <summary>
	/// Key: "LabelCollectibles"
	/// English String: "Collectibles"
	/// </summary>
	public override string LabelCollectibles => "Colecionáveis";

	/// <summary>
	/// Key: "LabelFaces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Rostos";

	/// <summary>
	/// Key: "LabelFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFeatured => "Destaques";

	/// <summary>
	/// Key: "LabelFeaturedAccesories"
	/// English String: "Featured Accessories"
	/// </summary>
	public override string LabelFeaturedAccesories => "Acessórios em destaque";

	/// <summary>
	/// Key: "LabelFeaturedAnimations"
	/// English String: "Featured Animations"
	/// </summary>
	public override string LabelFeaturedAnimations => "Animações em destaque";

	/// <summary>
	/// Key: "LabelFeaturedFaces"
	/// English String: "Featured Faces"
	/// </summary>
	public override string LabelFeaturedFaces => "Rostos em destaque";

	/// <summary>
	/// Key: "LabelFeaturedGear"
	/// English String: "Featured Gear"
	/// </summary>
	public override string LabelFeaturedGear => "Equipamento em destaque";

	/// <summary>
	/// Key: "LabelFeaturedPackages"
	/// English String: "Featured Packages"
	/// </summary>
	public override string LabelFeaturedPackages => "Pacotes em destaque";

	/// <summary>
	/// Key: "LabelFree"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Grátis";

	/// <summary>
	/// Key: "LabelGear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Equipamento";

	/// <summary>
	/// Key: "LabelGearAll"
	/// English String: "All Gear"
	/// </summary>
	public override string LabelGearAll => "Todos os equipamentos";

	/// <summary>
	/// Key: "LabelGearBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGearBuilding => "Construindo";

	/// <summary>
	/// Key: "LabelGearExplosive"
	/// English String: "Explosive"
	/// </summary>
	public override string LabelGearExplosive => "Explosivo";

	/// <summary>
	/// Key: "LabelGearMelee"
	/// English String: "Melee"
	/// </summary>
	public override string LabelGearMelee => "Corpo a corpo";

	/// <summary>
	/// Key: "LabelGearMusical"
	/// English String: "Musical"
	/// </summary>
	public override string LabelGearMusical => "Musical";

	/// <summary>
	/// Key: "LabelGearNavigation"
	/// English String: "Navigation"
	/// </summary>
	public override string LabelGearNavigation => "Navegação";

	/// <summary>
	/// Key: "LabelGearPersonalTransport"
	/// English String: "Transport"
	/// </summary>
	public override string LabelGearPersonalTransport => "Transporte";

	/// <summary>
	/// Key: "LabelGearPowerUps"
	/// English String: "Power Up"
	/// </summary>
	public override string LabelGearPowerUps => "Poder";

	/// <summary>
	/// Key: "LabelGearRanged"
	/// English String: "Ranged"
	/// </summary>
	public override string LabelGearRanged => "À distância";

	/// <summary>
	/// Key: "LabelGearSocial"
	/// English String: "Social"
	/// </summary>
	public override string LabelGearSocial => "Social";

	/// <summary>
	/// Key: "LabelGenreAdventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelGenreAdventure => "Aventura";

	/// <summary>
	/// Key: "LabelGenreAll"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelGenreAll => "Todos os gêneros";

	/// <summary>
	/// Key: "LabelGenreBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreBuilding => "Construindo";

	/// <summary>
	/// Key: "LabelGenreComedy"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreComedy => "Comédia";

	/// <summary>
	/// Key: "LabelGenreFantasy"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreFantasy => "Medieval";

	/// <summary>
	/// Key: "LabelGenreFighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreFighting => "Luta";

	/// <summary>
	/// Key: "LabelGenreFPS"
	/// English String: "FPS"
	/// </summary>
	public override string LabelGenreFPS => "FPS";

	/// <summary>
	/// Key: "LabelGenreFunny"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreFunny => "Comédia";

	/// <summary>
	/// Key: "LabelGenreHorror"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreHorror => "Horror";

	/// <summary>
	/// Key: "LabelGenreMedieval"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreMedieval => "Medieval";

	/// <summary>
	/// Key: "LabelGenreMilitary"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreMilitary => "Militar";

	/// <summary>
	/// Key: "LabelGenreNaval"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenreNaval => "Naval";

	/// <summary>
	/// Key: "LabelGenreNinja"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreNinja => "Luta";

	/// <summary>
	/// Key: "LabelGenrePirate"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenrePirate => "Naval";

	/// <summary>
	/// Key: "LabelGenreRPG"
	/// English String: "RPG"
	/// </summary>
	public override string LabelGenreRPG => "RPG";

	/// <summary>
	/// Key: "LabelGenreScary"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreScary => "Horror";

	/// <summary>
	/// Key: "LabelGenreSciFi"
	/// English String: "Sci-Fi"
	/// </summary>
	public override string LabelGenreSciFi => "Ficção científica";

	/// <summary>
	/// Key: "LabelGenreSports"
	/// English String: "Sports"
	/// </summary>
	public override string LabelGenreSports => "Esportes";

	/// <summary>
	/// Key: "LabelGenreTownAndCity"
	/// English String: "Town and City"
	/// </summary>
	public override string LabelGenreTownAndCity => "Urbano";

	/// <summary>
	/// Key: "LabelGenreTutorial"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreTutorial => "Construção";

	/// <summary>
	/// Key: "LabelGenreWar"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreWar => "Militar";

	/// <summary>
	/// Key: "LabelGenreWestern"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWestern => "Faroeste";

	/// <summary>
	/// Key: "LabelGenreWildWest"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWildWest => "Faroeste";

	/// <summary>
	/// Key: "LabelHeads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Cabeças";

	/// <summary>
	/// Key: "LabelMostFavorited"
	/// English String: "Most Favorited"
	/// </summary>
	public override string LabelMostFavorited => "Mais favoritos";

	/// <summary>
	/// Key: "LabelNoResellers"
	/// English String: "No Resellers"
	/// </summary>
	public override string LabelNoResellers => "Nenhum revendedor";

	/// <summary>
	/// Key: "LabelOffSale"
	/// English String: "Offsale"
	/// </summary>
	public override string LabelOffSale => "Indisponível";

	/// <summary>
	/// Key: "LabelPackages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Pacotes";

	/// <summary>
	/// Key: "LabelPants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Calças";

	/// <summary>
	/// Key: "LabelPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelPastDay => "Dia anterior";

	/// <summary>
	/// Key: "LabelPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelPastWeek => "Semana passada";

	/// <summary>
	/// Key: "LabelPriceHighFirst"
	/// English String: "Price (High to Low)"
	/// </summary>
	public override string LabelPriceHighFirst => "Preço (maior ao menor)";

	/// <summary>
	/// Key: "LabelPriceLowFirst"
	/// English String: "Price (Low to High)"
	/// </summary>
	public override string LabelPriceLowFirst => "Preço (menor ao maior)";

	/// <summary>
	/// Key: "LabelRecentlyUpdated"
	/// English String: "Recently Updated"
	/// </summary>
	public override string LabelRecentlyUpdated => "Atualizados recentemente";

	/// <summary>
	/// Key: "LabelRelevance"
	/// English String: "Relevance"
	/// </summary>
	public override string LabelRelevance => "Relevância";

	/// <summary>
	/// Key: "LabelRoblox"
	/// English String: "Roblox"
	/// </summary>
	public override string LabelRoblox => "Roblox";

	/// <summary>
	/// Key: "LabelRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "LabelShirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Camisas";

	/// <summary>
	/// Key: "LabelTShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Camisetas";

	/// <summary>
	/// Key: "Response.Error.Filter"
	/// English String: "Errors exist in Filter tab"
	/// </summary>
	public override string ResponseErrorFilter => "Erros na aba de filtro";

	/// <summary>
	/// Key: "Response.GenericError"
	/// English String: "An error occurred. Please try again later."
	/// </summary>
	public override string ResponseGenericError => "Ocorreu um erro. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Response.NoItemsFound"
	/// English String: "No items found."
	/// </summary>
	public override string ResponseNoItemsFound => "Nenhum item encontrado.";

	/// <summary>
	/// Key: "Response.NoSaleItemsFromSearch"
	/// English String: "Your search did not find items for sale. Unavailable items displayed below."
	/// </summary>
	public override string ResponseNoSaleItemsFromSearch => "Sua pesquisa não encontrou itens à venda. Itens não disponíveis exibidos abaixo.";

	/// <summary>
	/// Key: "Response.TemporarilyUnavailable"
	/// English String: "Catalog temporarily unavailable. Please try again later."
	/// </summary>
	public override string ResponseTemporarilyUnavailable => "Catálogo não disponível temporariamente. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Response.Throttled"
	/// Shown to users when they have made too many requests in a minute and are being throttled.
	/// English String: "You're going too fast! Try again in a minute."
	/// </summary>
	public override string ResponseThrottled => "Você está indo rápido demais! Tente novamente em um minutinho.";

	public CatalogResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForActionDialogAddGearOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionFilterApply()
	{
		return "Aplicar";
	}

	protected override string _GetTemplateForActionFilterCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionGo()
	{
		return "Ok";
	}

	protected override string _GetTemplateForActionViewAllItems()
	{
		return "Ver todos os itens";
	}

	protected override string _GetTemplateForDescriptionDialogAddGearBody()
	{
		return "Para adicionar equipamento ao seu jogo, encontre um item no catálogo e clique no botão “Adicionar equipamento”. O item será automaticamente permitido no jogo e você receberá uma comissão a cada cópia vendida na sua página de jogo. (Você só pode adicionar equipamentos que estejam à venda.)";
	}

	protected override string _GetTemplateForHeadingCatalogCategory()
	{
		return "Categoria";
	}

	protected override string _GetTemplateForHeadingCatalogPage()
	{
		return "Catálogo";
	}

	protected override string _GetTemplateForLabelAllFeaturedItems()
	{
		return "Ver todos os itens em destaque";
	}

	protected override string _GetTemplateForLabelAllGenres()
	{
		return "Todos os gêneros";
	}

	protected override string _GetTemplateForLabelAmazon()
	{
		return "Amazon";
	}

	protected override string _GetTemplateForLabelBreadCrumbFree()
	{
		return "Grátis";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreOrText"
	/// English String: "{genreName1} or {genreName2}"
	/// </summary>
	public override string LabelBreadCrumbGenreOrText(string genreName1, string genreName2)
	{
		return $"{genreName1} ou {genreName2}";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreOrText()
	{
		return "{genreName1} ou {genreName2}";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreSelectedText"
	/// English String: "Genre: {genreCount} selected"
	/// </summary>
	public override string LabelBreadCrumbGenreSelectedText(string genreCount)
	{
		return $"Gênero: {genreCount} selecionado(s)";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreSelectedText()
	{
		return "Gênero: {genreCount} selecionado(s)";
	}

	protected override string _GetTemplateForLabelBreadCrumbGroup()
	{
		return "Grupo:";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceAbove"
	/// English String: "{price} and above"
	/// </summary>
	public override string LabelBreadCrumbPriceAbove(string price)
	{
		return $"{price} e acima";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceAbove()
	{
		return "{price} e acima";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceBelow"
	/// English String: "{price} and below"
	/// </summary>
	public override string LabelBreadCrumbPriceBelow(string price)
	{
		return $"{price} e abaixo";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceBelow()
	{
		return "{price} e abaixo";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.ResultsCount"
	/// English String: "{startNumber} - {endNumber} of {resultsCount} Results"
	/// </summary>
	public override string LabelBreadCrumbResultsCount(string startNumber, string endNumber, string resultsCount)
	{
		return $"{startNumber} - {endNumber} de {resultsCount} resultados";
	}

	protected override string _GetTemplateForLabelBreadCrumbResultsCount()
	{
		return "{startNumber} - {endNumber} de {resultsCount} resultados";
	}

	protected override string _GetTemplateForLabelBundle()
	{
		return "Pacote";
	}

	protected override string _GetTemplateForLabelBundles()
	{
		return "Pacotes";
	}

	/// <summary>
	/// Key: "Label.ByCreatorLink"
	/// Creator name in item card with link
	/// English String: "By {linkStart}{creator}{linkEnd}"
	/// </summary>
	public override string LabelByCreatorLink(string linkStart, string creator, string linkEnd)
	{
		return $"De {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelByCreatorLink()
	{
		return "De {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelCardCreatorBy()
	{
		return "De ";
	}

	protected override string _GetTemplateForLabelCardPriceWas()
	{
		return "Era";
	}

	protected override string _GetTemplateForLabelCardRemaining()
	{
		return "Restante:";
	}

	protected override string _GetTemplateForLabelCategoryAttributes()
	{
		return "Atributos";
	}

	protected override string _GetTemplateForLabelCategoryType()
	{
		return "Tipo";
	}

	protected override string _GetTemplateForLabelCommunityCreations()
	{
		return " Criações da comunidade";
	}

	protected override string _GetTemplateForLabelDialogAddGearTitle()
	{
		return "Adicione equipamento ao seu jogo";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeaturedBundles()
	{
		return "Pacotes em destaque";
	}

	protected override string _GetTemplateForLabelFeaturedEmotes()
	{
		return "Emotes em destaque";
	}

	/// <summary>
	/// Key: "Label.FeaturedItemsOnRoblox"
	/// English String: "Featured Items on {spanStart}{roblox}{spanEnd}"
	/// </summary>
	public override string LabelFeaturedItemsOnRoblox(string spanStart, string roblox, string spanEnd)
	{
		return $"Itens em destaque no {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFeaturedItemsOnRoblox()
	{
		return "Itens em destaque no {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFilterByTime()
	{
		return "Por tempo";
	}

	protected override string _GetTemplateForLabelFilterCategory()
	{
		return "Categoria";
	}

	protected override string _GetTemplateForLabelFilterCreator()
	{
		return "Criador";
	}

	protected override string _GetTemplateForLabelFilterFilter()
	{
		return "Filtro";
	}

	protected override string _GetTemplateForLabelFilterFilters()
	{
		return "Filtros";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Gênero";
	}

	protected override string _GetTemplateForLabelFilterHide()
	{
		return "Esconder";
	}

	protected override string _GetTemplateForLabelFilterPrice()
	{
		return "Preço";
	}

	protected override string _GetTemplateForLabelFilterPriceMax()
	{
		return "Máx.";
	}

	protected override string _GetTemplateForLabelFilterPriceMin()
	{
		return "Mín.";
	}

	protected override string _GetTemplateForLabelFilterPriceTo()
	{
		return "Para ";
	}

	protected override string _GetTemplateForLabelFilterShow()
	{
		return "Exibir";
	}

	protected override string _GetTemplateForLabelFilterSorting()
	{
		return "Ordem";
	}

	protected override string _GetTemplateForLabelFilterUnavailableItems()
	{
		return "Itens não disponíveis";
	}

	protected override string _GetTemplateForLabelGoogleOnly()
	{
		return "Somente Google";
	}

	protected override string _GetTemplateForLabelIos()
	{
		return "IOS";
	}

	protected override string _GetTemplateForLabelMobile()
	{
		return "Dispositivo móvel";
	}

	protected override string _GetTemplateForLabelNew()
	{
		return "Novo";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	protected override string _GetTemplateForLabelSale()
	{
		return "Promoção";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Pesquisar";
	}

	protected override string _GetTemplateForLabelSeeAll()
	{
		return "Ver todos";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nome de usuário";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Acessórios";
	}

	protected override string _GetTemplateForLabelAccessoryAll()
	{
		return "Todos os acessórios";
	}

	protected override string _GetTemplateForLabelAccessoryBack()
	{
		return "Costas";
	}

	protected override string _GetTemplateForLabelAccessoryFace()
	{
		return "Rosto";
	}

	protected override string _GetTemplateForLabelAccessoryFront()
	{
		return "Frente";
	}

	protected override string _GetTemplateForLabelAccessoryHair()
	{
		return "Cabelo";
	}

	protected override string _GetTemplateForLabelAccessoryHats()
	{
		return "Chapéus";
	}

	protected override string _GetTemplateForLabelAccessoryNeck()
	{
		return "Pescoço";
	}

	protected override string _GetTemplateForLabelAccessoryShoulder()
	{
		return "Ombro";
	}

	protected override string _GetTemplateForLabelAccessoryWaist()
	{
		return "Cintura";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Todas";
	}

	protected override string _GetTemplateForLabelAllBodyParts()
	{
		return "Todas as partes do corpo";
	}

	protected override string _GetTemplateForLabelAllCategories()
	{
		return "Todas as categorias";
	}

	protected override string _GetTemplateForLabelAllClothing()
	{
		return "Todas as roupas";
	}

	protected override string _GetTemplateForLabelAllCollectibles()
	{
		return "Todos os colecionáveis";
	}

	protected override string _GetTemplateForLabelAllCreators()
	{
		return "Todos os criadores";
	}

	protected override string _GetTemplateForLabelAllCurrency()
	{
		return "Todas as moedas";
	}

	protected override string _GetTemplateForLabelAllFeatured()
	{
		return "Todos os itens em destaque";
	}

	protected override string _GetTemplateForLabelAllTime()
	{
		return "Todos os tempos";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animações";
	}

	protected override string _GetTemplateForLabelAnyPrice()
	{
		return "Qualquer preço";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Animações de avatar";
	}

	protected override string _GetTemplateForLabelBestselling()
	{
		return "Mais vendidos";
	}

	protected override string _GetTemplateForLabelBodyParts()
	{
		return "Parte do corpo";
	}

	protected override string _GetTemplateForLabelClothing()
	{
		return "Roupas";
	}

	protected override string _GetTemplateForLabelCollectibleAccessories()
	{
		return "Acessórios colecionáveis";
	}

	protected override string _GetTemplateForLabelCollectibleFaces()
	{
		return "Rostos colecionáveis";
	}

	protected override string _GetTemplateForLabelCollectibleGear()
	{
		return "Equipamento colecionável";
	}

	protected override string _GetTemplateForLabelCollectibles()
	{
		return "Colecionáveis";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Rostos";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Destaques";
	}

	protected override string _GetTemplateForLabelFeaturedAccesories()
	{
		return "Acessórios em destaque";
	}

	protected override string _GetTemplateForLabelFeaturedAnimations()
	{
		return "Animações em destaque";
	}

	protected override string _GetTemplateForLabelFeaturedFaces()
	{
		return "Rostos em destaque";
	}

	protected override string _GetTemplateForLabelFeaturedGear()
	{
		return "Equipamento em destaque";
	}

	protected override string _GetTemplateForLabelFeaturedPackages()
	{
		return "Pacotes em destaque";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Grátis";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Equipamento";
	}

	protected override string _GetTemplateForLabelGearAll()
	{
		return "Todos os equipamentos";
	}

	protected override string _GetTemplateForLabelGearBuilding()
	{
		return "Construindo";
	}

	protected override string _GetTemplateForLabelGearExplosive()
	{
		return "Explosivo";
	}

	protected override string _GetTemplateForLabelGearMelee()
	{
		return "Corpo a corpo";
	}

	protected override string _GetTemplateForLabelGearMusical()
	{
		return "Musical";
	}

	protected override string _GetTemplateForLabelGearNavigation()
	{
		return "Navegação";
	}

	protected override string _GetTemplateForLabelGearPersonalTransport()
	{
		return "Transporte";
	}

	protected override string _GetTemplateForLabelGearPowerUps()
	{
		return "Poder";
	}

	protected override string _GetTemplateForLabelGearRanged()
	{
		return "À distância";
	}

	protected override string _GetTemplateForLabelGearSocial()
	{
		return "Social";
	}

	protected override string _GetTemplateForLabelGenreAdventure()
	{
		return "Aventura";
	}

	protected override string _GetTemplateForLabelGenreAll()
	{
		return "Todos os gêneros";
	}

	protected override string _GetTemplateForLabelGenreBuilding()
	{
		return "Construindo";
	}

	protected override string _GetTemplateForLabelGenreComedy()
	{
		return "Comédia";
	}

	protected override string _GetTemplateForLabelGenreFantasy()
	{
		return "Medieval";
	}

	protected override string _GetTemplateForLabelGenreFighting()
	{
		return "Luta";
	}

	protected override string _GetTemplateForLabelGenreFPS()
	{
		return "FPS";
	}

	protected override string _GetTemplateForLabelGenreFunny()
	{
		return "Comédia";
	}

	protected override string _GetTemplateForLabelGenreHorror()
	{
		return "Horror";
	}

	protected override string _GetTemplateForLabelGenreMedieval()
	{
		return "Medieval";
	}

	protected override string _GetTemplateForLabelGenreMilitary()
	{
		return "Militar";
	}

	protected override string _GetTemplateForLabelGenreNaval()
	{
		return "Naval";
	}

	protected override string _GetTemplateForLabelGenreNinja()
	{
		return "Luta";
	}

	protected override string _GetTemplateForLabelGenrePirate()
	{
		return "Naval";
	}

	protected override string _GetTemplateForLabelGenreRPG()
	{
		return "RPG";
	}

	protected override string _GetTemplateForLabelGenreScary()
	{
		return "Horror";
	}

	protected override string _GetTemplateForLabelGenreSciFi()
	{
		return "Ficção científica";
	}

	protected override string _GetTemplateForLabelGenreSports()
	{
		return "Esportes";
	}

	protected override string _GetTemplateForLabelGenreTownAndCity()
	{
		return "Urbano";
	}

	protected override string _GetTemplateForLabelGenreTutorial()
	{
		return "Construção";
	}

	protected override string _GetTemplateForLabelGenreWar()
	{
		return "Militar";
	}

	protected override string _GetTemplateForLabelGenreWestern()
	{
		return "Faroeste";
	}

	protected override string _GetTemplateForLabelGenreWildWest()
	{
		return "Faroeste";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Cabeças";
	}

	protected override string _GetTemplateForLabelMostFavorited()
	{
		return "Mais favoritos";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "Nenhum revendedor";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "Indisponível";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Pacotes";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Calças";
	}

	protected override string _GetTemplateForLabelPastDay()
	{
		return "Dia anterior";
	}

	protected override string _GetTemplateForLabelPastWeek()
	{
		return "Semana passada";
	}

	protected override string _GetTemplateForLabelPriceHighFirst()
	{
		return "Preço (maior ao menor)";
	}

	protected override string _GetTemplateForLabelPriceLowFirst()
	{
		return "Preço (menor ao maior)";
	}

	protected override string _GetTemplateForLabelRecentlyUpdated()
	{
		return "Atualizados recentemente";
	}

	protected override string _GetTemplateForLabelRelevance()
	{
		return "Relevância";
	}

	protected override string _GetTemplateForLabelRoblox()
	{
		return "Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForResponseErrorFilter()
	{
		return "Erros na aba de filtro";
	}

	protected override string _GetTemplateForResponseGenericError()
	{
		return "Ocorreu um erro. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForResponseNoItemsFound()
	{
		return "Nenhum item encontrado.";
	}

	protected override string _GetTemplateForResponseNoSaleItemsFromSearch()
	{
		return "Sua pesquisa não encontrou itens à venda. Itens não disponíveis exibidos abaixo.";
	}

	protected override string _GetTemplateForResponseTemporarilyUnavailable()
	{
		return "Catálogo não disponível temporariamente. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForResponseThrottled()
	{
		return "Você está indo rápido demais! Tente novamente em um minutinho.";
	}
}
