namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides CatalogResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class CatalogResources_es_es : CatalogResources_en_us, ICatalogResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Comprar Robux";

	/// <summary>
	/// Key: "Action.Dialog.AddGearOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogAddGearOk => "Aceptar";

	/// <summary>
	/// Key: "Action.Filter.Apply"
	/// English String: "Apply"
	/// </summary>
	public override string ActionFilterApply => "Aplicar";

	/// <summary>
	/// Key: "Action.Filter.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionFilterCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Go"
	/// English String: "Go"
	/// </summary>
	public override string ActionGo => "Ir";

	/// <summary>
	/// Key: "Action.ViewAllItems"
	/// English String: "View All Items"
	/// </summary>
	public override string ActionViewAllItems => "Ver todos los objetos";

	/// <summary>
	/// Key: "Description.Dialog.AddGearBody"
	/// English String: "To add gear to your game, find an item in the catalog and click the Add to Game button. The item will automatically be allowed in game, and you'll receive a commission on every copy sold from your game page. (You can only add gear that's for sale.)"
	/// </summary>
	public override string DescriptionDialogAddGearBody => "Para añadir equipamiento a tu juego, busca un objeto en el catálogo y haz clic en el botón Añadir al juego. El objeto se permitirá automáticamente en el juego y recibirás una comisión por cada copia que se venda desde la página de tu juego. (Solo puedes añadir equipamiento que esté en venta.)";

	/// <summary>
	/// Key: "Heading.CatalogCategory"
	/// English String: "Category"
	/// </summary>
	public override string HeadingCatalogCategory => "Categoría";

	/// <summary>
	/// Key: "Heading.CatalogPage"
	/// English String: "Catalog"
	/// </summary>
	public override string HeadingCatalogPage => "Catálogo";

	/// <summary>
	/// Key: "Label.AllFeaturedItems"
	/// English String: "View All Featured Items"
	/// </summary>
	public override string LabelAllFeaturedItems => "Ver todos los objetos";

	/// <summary>
	/// Key: "Label.AllGenres"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelAllGenres => "Todos los géneros";

	/// <summary>
	/// Key: "Label.Amazon"
	/// label
	/// English String: "Amazon"
	/// </summary>
	public override string LabelAmazon => "Amazon";

	/// <summary>
	/// Key: "Label.BreadCrumb.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelBreadCrumbFree => "Gratis";

	/// <summary>
	/// Key: "Label.BreadCrumb.Group"
	/// English String: "Group:"
	/// </summary>
	public override string LabelBreadCrumbGroup => "Grupo:";

	/// <summary>
	/// Key: "Label.Bundle"
	/// Bundle
	/// English String: "Bundle"
	/// </summary>
	public override string LabelBundle => "Paquete";

	/// <summary>
	/// Key: "Label.Bundles"
	/// Bundles
	/// English String: "Bundles"
	/// </summary>
	public override string LabelBundles => "Paquetes";

	/// <summary>
	/// Key: "Label.Card.CreatorBy"
	/// English String: "By"
	/// </summary>
	public override string LabelCardCreatorBy => "De";

	/// <summary>
	/// Key: "Label.Card.PriceWas"
	/// English String: "Was"
	/// </summary>
	public override string LabelCardPriceWas => "Antes";

	/// <summary>
	/// Key: "Label.Card.Remaining"
	/// English String: "Remaining:"
	/// </summary>
	public override string LabelCardRemaining => "Restantes:";

	/// <summary>
	/// Key: "Label.CategoryAttributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelCategoryAttributes => "Atributos";

	/// <summary>
	/// Key: "Label.CategoryType"
	/// English String: "Type"
	/// </summary>
	public override string LabelCategoryType => "Tipo";

	/// <summary>
	/// Key: "Label.CommunityCreations"
	/// UGC items
	/// English String: " Community Creations"
	/// </summary>
	public override string LabelCommunityCreations => " Creaciones de la comunidad";

	/// <summary>
	/// Key: "Label.Dialog.AddGearTitle"
	/// English String: "Add Gear to Your Game"
	/// </summary>
	public override string LabelDialogAddGearTitle => "Añade equipamiento a tu juego";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Emotes
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emoticonos";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.FeaturedBundles"
	/// Featured Bundles
	/// English String: "Featured Bundles"
	/// </summary>
	public override string LabelFeaturedBundles => "Paquetes";

	/// <summary>
	/// Key: "Label.FeaturedEmotes"
	/// Featured Emotes
	/// English String: "Featured Emotes"
	/// </summary>
	public override string LabelFeaturedEmotes => "Emoticonos";

	/// <summary>
	/// Key: "Label.Filter.ByTime"
	/// English String: "By Time"
	/// </summary>
	public override string LabelFilterByTime => "Por tiempo";

	/// <summary>
	/// Key: "Label.Filter.Category"
	/// English String: "Category"
	/// </summary>
	public override string LabelFilterCategory => "Categoría";

	/// <summary>
	/// Key: "Label.Filter.Creator"
	/// English String: "Creator"
	/// </summary>
	public override string LabelFilterCreator => "Creador";

	/// <summary>
	/// Key: "Label.Filter.Filter"
	/// English String: "Filter"
	/// </summary>
	public override string LabelFilterFilter => "Filtro";

	/// <summary>
	/// Key: "Label.Filter.Filters"
	/// English String: "Filters"
	/// </summary>
	public override string LabelFilterFilters => "Filtros";

	/// <summary>
	/// Key: "Label.Filter.Genre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Género";

	/// <summary>
	/// Key: "Label.Filter.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string LabelFilterHide => "Ocultar";

	/// <summary>
	/// Key: "Label.Filter.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelFilterPrice => "Precio";

	/// <summary>
	/// Key: "Label.Filter.PriceMax"
	/// English String: "Max"
	/// </summary>
	public override string LabelFilterPriceMax => "Máx.";

	/// <summary>
	/// Key: "Label.Filter.PriceMin"
	/// English String: "Min"
	/// </summary>
	public override string LabelFilterPriceMin => "Mín.";

	/// <summary>
	/// Key: "Label.Filter.PriceTo"
	/// English String: "To"
	/// </summary>
	public override string LabelFilterPriceTo => "Hasta";

	/// <summary>
	/// Key: "Label.Filter.Show"
	/// English String: "Show"
	/// </summary>
	public override string LabelFilterShow => "Mostrar";

	/// <summary>
	/// Key: "Label.Filter.Sorting"
	/// English String: "Sorting"
	/// </summary>
	public override string LabelFilterSorting => "Orden";

	/// <summary>
	/// Key: "Label.Filter.UnavailableItems"
	/// English String: "Unavailable Items"
	/// </summary>
	public override string LabelFilterUnavailableItems => "Objetos no disponibles";

	/// <summary>
	/// Key: "Label.GoogleOnly"
	/// label
	/// English String: "Google Only"
	/// </summary>
	public override string LabelGoogleOnly => "Solo Google";

	/// <summary>
	/// Key: "Label.Ios"
	/// label
	/// English String: "IOS"
	/// </summary>
	public override string LabelIos => "iOS";

	/// <summary>
	/// Key: "Label.Mobile"
	/// label
	/// English String: "Mobile"
	/// </summary>
	public override string LabelMobile => "Móvil";

	/// <summary>
	/// Key: "Label.New"
	/// label
	/// English String: "New"
	/// </summary>
	public override string LabelNew => "Nuevo";

	/// <summary>
	/// Key: "Label.Rthro"
	/// Rthro is "Anthro" but we replaced the beginning of the word with an "R" to align with "R6" and "R15"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.Sale"
	/// label
	/// English String: "Sale"
	/// </summary>
	public override string LabelSale => "Venta";

	/// <summary>
	/// Key: "Label.SearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Buscar";

	/// <summary>
	/// Key: "Label.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string LabelSeeAll => "Ver todo";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Usuario";

	/// <summary>
	/// Key: "Label.Xbox"
	/// label
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "LabelAccessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Accesorios";

	/// <summary>
	/// Key: "LabelAccessoryAll"
	/// English String: "All Accessories"
	/// </summary>
	public override string LabelAccessoryAll => "Todos los accesorios";

	/// <summary>
	/// Key: "LabelAccessoryBack"
	/// English String: "Back"
	/// </summary>
	public override string LabelAccessoryBack => "Trasero";

	/// <summary>
	/// Key: "LabelAccessoryFace"
	/// English String: "Face"
	/// </summary>
	public override string LabelAccessoryFace => "Cara";

	/// <summary>
	/// Key: "LabelAccessoryFront"
	/// English String: "Front"
	/// </summary>
	public override string LabelAccessoryFront => "Frontal";

	/// <summary>
	/// Key: "LabelAccessoryHair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelAccessoryHair => "Pelo";

	/// <summary>
	/// Key: "LabelAccessoryHats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelAccessoryHats => "Sombreros";

	/// <summary>
	/// Key: "LabelAccessoryNeck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelAccessoryNeck => "Cuello";

	/// <summary>
	/// Key: "LabelAccessoryShoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelAccessoryShoulder => "Hombro";

	/// <summary>
	/// Key: "LabelAccessoryWaist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelAccessoryWaist => "Cintura";

	/// <summary>
	/// Key: "LabelAll"
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Todos";

	/// <summary>
	/// Key: "LabelAllBodyParts"
	/// English String: "All Body Parts"
	/// </summary>
	public override string LabelAllBodyParts => "Todas las partes del cuerpo";

	/// <summary>
	/// Key: "LabelAllCategories"
	/// English String: "All Categories"
	/// </summary>
	public override string LabelAllCategories => "Todas las categorías";

	/// <summary>
	/// Key: "LabelAllClothing"
	/// English String: "All Clothing"
	/// </summary>
	public override string LabelAllClothing => "Toda la ropa";

	/// <summary>
	/// Key: "LabelAllCollectibles"
	/// English String: "All Collectibles"
	/// </summary>
	public override string LabelAllCollectibles => "Todos";

	/// <summary>
	/// Key: "LabelAllCreators"
	/// English String: "All Creators"
	/// </summary>
	public override string LabelAllCreators => "Todos los creadores";

	/// <summary>
	/// Key: "LabelAllCurrency"
	/// English String: "All Currency"
	/// </summary>
	public override string LabelAllCurrency => "Todas las divisas";

	/// <summary>
	/// Key: "LabelAllFeatured"
	/// English String: "All Featured Items"
	/// </summary>
	public override string LabelAllFeatured => "Todos los objetos";

	/// <summary>
	/// Key: "LabelAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelAllTime => "Todos los tiempos";

	/// <summary>
	/// Key: "LabelAnimations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animaciones";

	/// <summary>
	/// Key: "LabelAnyPrice"
	/// English String: "Any Price"
	/// </summary>
	public override string LabelAnyPrice => "Cualquier precio";

	/// <summary>
	/// Key: "LabelAvatarAnimations"
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Animaciones de avatar";

	/// <summary>
	/// Key: "LabelBestselling"
	/// English String: "Bestselling"
	/// </summary>
	public override string LabelBestselling => "Superventas";

	/// <summary>
	/// Key: "LabelBodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string LabelBodyParts => "Partes del cuerpo";

	/// <summary>
	/// Key: "LabelClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string LabelClothing => "Ropa";

	/// <summary>
	/// Key: "LabelCollectibleAccessories"
	/// English String: "Collectible Accessories"
	/// </summary>
	public override string LabelCollectibleAccessories => "Accessorios";

	/// <summary>
	/// Key: "LabelCollectibleFaces"
	/// English String: "Collectible Faces"
	/// </summary>
	public override string LabelCollectibleFaces => "Caras";

	/// <summary>
	/// Key: "LabelCollectibleGear"
	/// English String: "Collectible Gear"
	/// </summary>
	public override string LabelCollectibleGear => "Equipamiento";

	/// <summary>
	/// Key: "LabelCollectibles"
	/// English String: "Collectibles"
	/// </summary>
	public override string LabelCollectibles => "Coleccionables";

	/// <summary>
	/// Key: "LabelFaces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Caras";

	/// <summary>
	/// Key: "LabelFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFeatured => "Promocionados";

	/// <summary>
	/// Key: "LabelFeaturedAccesories"
	/// English String: "Featured Accessories"
	/// </summary>
	public override string LabelFeaturedAccesories => "Accessorios";

	/// <summary>
	/// Key: "LabelFeaturedAnimations"
	/// English String: "Featured Animations"
	/// </summary>
	public override string LabelFeaturedAnimations => "Animaciones";

	/// <summary>
	/// Key: "LabelFeaturedFaces"
	/// English String: "Featured Faces"
	/// </summary>
	public override string LabelFeaturedFaces => "Caras";

	/// <summary>
	/// Key: "LabelFeaturedGear"
	/// English String: "Featured Gear"
	/// </summary>
	public override string LabelFeaturedGear => "Equipamiento";

	/// <summary>
	/// Key: "LabelFeaturedPackages"
	/// English String: "Featured Packages"
	/// </summary>
	public override string LabelFeaturedPackages => "Paquetes";

	/// <summary>
	/// Key: "LabelFree"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratis";

	/// <summary>
	/// Key: "LabelGear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Equipamiento";

	/// <summary>
	/// Key: "LabelGearAll"
	/// English String: "All Gear"
	/// </summary>
	public override string LabelGearAll => "Todo el equipamiento";

	/// <summary>
	/// Key: "LabelGearBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGearBuilding => "Construcción";

	/// <summary>
	/// Key: "LabelGearExplosive"
	/// English String: "Explosive"
	/// </summary>
	public override string LabelGearExplosive => "Explosivo";

	/// <summary>
	/// Key: "LabelGearMelee"
	/// English String: "Melee"
	/// </summary>
	public override string LabelGearMelee => "Cuerpo a cuerpo";

	/// <summary>
	/// Key: "LabelGearMusical"
	/// English String: "Musical"
	/// </summary>
	public override string LabelGearMusical => "Musical";

	/// <summary>
	/// Key: "LabelGearNavigation"
	/// English String: "Navigation"
	/// </summary>
	public override string LabelGearNavigation => "Navegación";

	/// <summary>
	/// Key: "LabelGearPersonalTransport"
	/// English String: "Transport"
	/// </summary>
	public override string LabelGearPersonalTransport => "Transporte";

	/// <summary>
	/// Key: "LabelGearPowerUps"
	/// English String: "Power Up"
	/// </summary>
	public override string LabelGearPowerUps => "Potenciador";

	/// <summary>
	/// Key: "LabelGearRanged"
	/// English String: "Ranged"
	/// </summary>
	public override string LabelGearRanged => "A distancia";

	/// <summary>
	/// Key: "LabelGearSocial"
	/// English String: "Social"
	/// </summary>
	public override string LabelGearSocial => "Social";

	/// <summary>
	/// Key: "LabelGenreAdventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelGenreAdventure => "Aventura";

	/// <summary>
	/// Key: "LabelGenreAll"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelGenreAll => "Todos los géneros";

	/// <summary>
	/// Key: "LabelGenreBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreBuilding => "Construcción";

	/// <summary>
	/// Key: "LabelGenreComedy"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreComedy => "Comedia";

	/// <summary>
	/// Key: "LabelGenreFantasy"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreFantasy => "Medieval";

	/// <summary>
	/// Key: "LabelGenreFighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreFighting => "Lucha";

	/// <summary>
	/// Key: "LabelGenreFPS"
	/// English String: "FPS"
	/// </summary>
	public override string LabelGenreFPS => "FPS";

	/// <summary>
	/// Key: "LabelGenreFunny"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreFunny => "Comedia";

	/// <summary>
	/// Key: "LabelGenreHorror"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreHorror => "Terror";

	/// <summary>
	/// Key: "LabelGenreMedieval"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreMedieval => "Medieval";

	/// <summary>
	/// Key: "LabelGenreMilitary"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreMilitary => "Militar";

	/// <summary>
	/// Key: "LabelGenreNaval"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenreNaval => "Naval";

	/// <summary>
	/// Key: "LabelGenreNinja"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreNinja => "Lucha";

	/// <summary>
	/// Key: "LabelGenrePirate"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenrePirate => "Naval";

	/// <summary>
	/// Key: "LabelGenreRPG"
	/// English String: "RPG"
	/// </summary>
	public override string LabelGenreRPG => "RPG";

	/// <summary>
	/// Key: "LabelGenreScary"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreScary => "Terror";

	/// <summary>
	/// Key: "LabelGenreSciFi"
	/// English String: "Sci-Fi"
	/// </summary>
	public override string LabelGenreSciFi => "Ciencia-ficción";

	/// <summary>
	/// Key: "LabelGenreSports"
	/// English String: "Sports"
	/// </summary>
	public override string LabelGenreSports => "Deporte";

	/// <summary>
	/// Key: "LabelGenreTownAndCity"
	/// English String: "Town and City"
	/// </summary>
	public override string LabelGenreTownAndCity => "Pueblo y ciudad";

	/// <summary>
	/// Key: "LabelGenreTutorial"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreTutorial => "Construcción";

	/// <summary>
	/// Key: "LabelGenreWar"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreWar => "Militar";

	/// <summary>
	/// Key: "LabelGenreWestern"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWestern => "Western";

	/// <summary>
	/// Key: "LabelGenreWildWest"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWildWest => "Western";

	/// <summary>
	/// Key: "LabelHeads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Cabezas";

	/// <summary>
	/// Key: "LabelMostFavorited"
	/// English String: "Most Favorited"
	/// </summary>
	public override string LabelMostFavorited => "Más favoritos";

	/// <summary>
	/// Key: "LabelNoResellers"
	/// English String: "No Resellers"
	/// </summary>
	public override string LabelNoResellers => "Sin reventa";

	/// <summary>
	/// Key: "LabelOffSale"
	/// English String: "Offsale"
	/// </summary>
	public override string LabelOffSale => "Fuera de oferta";

	/// <summary>
	/// Key: "LabelPackages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Paquetes";

	/// <summary>
	/// Key: "LabelPants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Pantalones";

	/// <summary>
	/// Key: "LabelPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelPastDay => "Día anterior";

	/// <summary>
	/// Key: "LabelPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelPastWeek => "Semana pasada";

	/// <summary>
	/// Key: "LabelPriceHighFirst"
	/// English String: "Price (High to Low)"
	/// </summary>
	public override string LabelPriceHighFirst => "Precio (de mayor a menor)";

	/// <summary>
	/// Key: "LabelPriceLowFirst"
	/// English String: "Price (Low to High)"
	/// </summary>
	public override string LabelPriceLowFirst => "Precio (de menor a mayor)";

	/// <summary>
	/// Key: "LabelRecentlyUpdated"
	/// English String: "Recently Updated"
	/// </summary>
	public override string LabelRecentlyUpdated => "Actualizados recientemente";

	/// <summary>
	/// Key: "LabelRelevance"
	/// English String: "Relevance"
	/// </summary>
	public override string LabelRelevance => "Relevancia";

	/// <summary>
	/// Key: "LabelRoblox"
	/// English String: "Roblox"
	/// </summary>
	public override string LabelRoblox => "Roblox";

	/// <summary>
	/// Key: "LabelRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "LabelShirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Camisas";

	/// <summary>
	/// Key: "LabelTShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Camisetas";

	/// <summary>
	/// Key: "Response.Error.Filter"
	/// English String: "Errors exist in Filter tab"
	/// </summary>
	public override string ResponseErrorFilter => "Hay errores en la pestaña de filtros";

	/// <summary>
	/// Key: "Response.GenericError"
	/// English String: "An error occurred. Please try again later."
	/// </summary>
	public override string ResponseGenericError => "Se ha producido un error. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.NoItemsFound"
	/// English String: "No items found."
	/// </summary>
	public override string ResponseNoItemsFound => "No se han encontrado objetos.";

	/// <summary>
	/// Key: "Response.NoSaleItemsFromSearch"
	/// English String: "Your search did not find items for sale. Unavailable items displayed below."
	/// </summary>
	public override string ResponseNoSaleItemsFromSearch => "Tu búsqueda no ha encontrado objetos en venta. Debajo se muestran los objetos no disponibles.";

	/// <summary>
	/// Key: "Response.TemporarilyUnavailable"
	/// English String: "Catalog temporarily unavailable. Please try again later."
	/// </summary>
	public override string ResponseTemporarilyUnavailable => "El catálogo no está disponible temporalmente. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Throttled"
	/// Shown to users when they have made too many requests in a minute and are being throttled.
	/// English String: "You're going too fast! Try again in a minute."
	/// </summary>
	public override string ResponseThrottled => "¡Vas muy rápido! Inténtalo de nuevo en un minuto.";

	public CatalogResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Comprar Robux";
	}

	protected override string _GetTemplateForActionDialogAddGearOk()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionFilterApply()
	{
		return "Aplicar";
	}

	protected override string _GetTemplateForActionFilterCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionGo()
	{
		return "Ir";
	}

	protected override string _GetTemplateForActionViewAllItems()
	{
		return "Ver todos los objetos";
	}

	protected override string _GetTemplateForDescriptionDialogAddGearBody()
	{
		return "Para añadir equipamiento a tu juego, busca un objeto en el catálogo y haz clic en el botón Añadir al juego. El objeto se permitirá automáticamente en el juego y recibirás una comisión por cada copia que se venda desde la página de tu juego. (Solo puedes añadir equipamiento que esté en venta.)";
	}

	protected override string _GetTemplateForHeadingCatalogCategory()
	{
		return "Categoría";
	}

	protected override string _GetTemplateForHeadingCatalogPage()
	{
		return "Catálogo";
	}

	protected override string _GetTemplateForLabelAllFeaturedItems()
	{
		return "Ver todos los objetos";
	}

	protected override string _GetTemplateForLabelAllGenres()
	{
		return "Todos los géneros";
	}

	protected override string _GetTemplateForLabelAmazon()
	{
		return "Amazon";
	}

	protected override string _GetTemplateForLabelBreadCrumbFree()
	{
		return "Gratis";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreOrText"
	/// English String: "{genreName1} or {genreName2}"
	/// </summary>
	public override string LabelBreadCrumbGenreOrText(string genreName1, string genreName2)
	{
		return $"{genreName1} o {genreName2}";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreOrText()
	{
		return "{genreName1} o {genreName2}";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreSelectedText"
	/// English String: "Genre: {genreCount} selected"
	/// </summary>
	public override string LabelBreadCrumbGenreSelectedText(string genreCount)
	{
		return $"Género: {genreCount} seleccionado(s)";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreSelectedText()
	{
		return "Género: {genreCount} seleccionado(s)";
	}

	protected override string _GetTemplateForLabelBreadCrumbGroup()
	{
		return "Grupo:";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceAbove"
	/// English String: "{price} and above"
	/// </summary>
	public override string LabelBreadCrumbPriceAbove(string price)
	{
		return $"{price} y superior";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceAbove()
	{
		return "{price} y superior";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceBelow"
	/// English String: "{price} and below"
	/// </summary>
	public override string LabelBreadCrumbPriceBelow(string price)
	{
		return $"{price} e inferior";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceBelow()
	{
		return "{price} e inferior";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.ResultsCount"
	/// English String: "{startNumber} - {endNumber} of {resultsCount} Results"
	/// </summary>
	public override string LabelBreadCrumbResultsCount(string startNumber, string endNumber, string resultsCount)
	{
		return $"{startNumber} - {endNumber} de {resultsCount} resultados";
	}

	protected override string _GetTemplateForLabelBreadCrumbResultsCount()
	{
		return "{startNumber} - {endNumber} de {resultsCount} resultados";
	}

	protected override string _GetTemplateForLabelBundle()
	{
		return "Paquete";
	}

	protected override string _GetTemplateForLabelBundles()
	{
		return "Paquetes";
	}

	/// <summary>
	/// Key: "Label.ByCreatorLink"
	/// Creator name in item card with link
	/// English String: "By {linkStart}{creator}{linkEnd}"
	/// </summary>
	public override string LabelByCreatorLink(string linkStart, string creator, string linkEnd)
	{
		return $"De {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelByCreatorLink()
	{
		return "De {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelCardCreatorBy()
	{
		return "De";
	}

	protected override string _GetTemplateForLabelCardPriceWas()
	{
		return "Antes";
	}

	protected override string _GetTemplateForLabelCardRemaining()
	{
		return "Restantes:";
	}

	protected override string _GetTemplateForLabelCategoryAttributes()
	{
		return "Atributos";
	}

	protected override string _GetTemplateForLabelCategoryType()
	{
		return "Tipo";
	}

	protected override string _GetTemplateForLabelCommunityCreations()
	{
		return " Creaciones de la comunidad";
	}

	protected override string _GetTemplateForLabelDialogAddGearTitle()
	{
		return "Añade equipamiento a tu juego";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emoticonos";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeaturedBundles()
	{
		return "Paquetes";
	}

	protected override string _GetTemplateForLabelFeaturedEmotes()
	{
		return "Emoticonos";
	}

	/// <summary>
	/// Key: "Label.FeaturedItemsOnRoblox"
	/// English String: "Featured Items on {spanStart}{roblox}{spanEnd}"
	/// </summary>
	public override string LabelFeaturedItemsOnRoblox(string spanStart, string roblox, string spanEnd)
	{
		return $"Objetos promocionados en {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFeaturedItemsOnRoblox()
	{
		return "Objetos promocionados en {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFilterByTime()
	{
		return "Por tiempo";
	}

	protected override string _GetTemplateForLabelFilterCategory()
	{
		return "Categoría";
	}

	protected override string _GetTemplateForLabelFilterCreator()
	{
		return "Creador";
	}

	protected override string _GetTemplateForLabelFilterFilter()
	{
		return "Filtro";
	}

	protected override string _GetTemplateForLabelFilterFilters()
	{
		return "Filtros";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Género";
	}

	protected override string _GetTemplateForLabelFilterHide()
	{
		return "Ocultar";
	}

	protected override string _GetTemplateForLabelFilterPrice()
	{
		return "Precio";
	}

	protected override string _GetTemplateForLabelFilterPriceMax()
	{
		return "Máx.";
	}

	protected override string _GetTemplateForLabelFilterPriceMin()
	{
		return "Mín.";
	}

	protected override string _GetTemplateForLabelFilterPriceTo()
	{
		return "Hasta";
	}

	protected override string _GetTemplateForLabelFilterShow()
	{
		return "Mostrar";
	}

	protected override string _GetTemplateForLabelFilterSorting()
	{
		return "Orden";
	}

	protected override string _GetTemplateForLabelFilterUnavailableItems()
	{
		return "Objetos no disponibles";
	}

	protected override string _GetTemplateForLabelGoogleOnly()
	{
		return "Solo Google";
	}

	protected override string _GetTemplateForLabelIos()
	{
		return "iOS";
	}

	protected override string _GetTemplateForLabelMobile()
	{
		return "Móvil";
	}

	protected override string _GetTemplateForLabelNew()
	{
		return "Nuevo";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	protected override string _GetTemplateForLabelSale()
	{
		return "Venta";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Buscar";
	}

	protected override string _GetTemplateForLabelSeeAll()
	{
		return "Ver todo";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Usuario";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Accesorios";
	}

	protected override string _GetTemplateForLabelAccessoryAll()
	{
		return "Todos los accesorios";
	}

	protected override string _GetTemplateForLabelAccessoryBack()
	{
		return "Trasero";
	}

	protected override string _GetTemplateForLabelAccessoryFace()
	{
		return "Cara";
	}

	protected override string _GetTemplateForLabelAccessoryFront()
	{
		return "Frontal";
	}

	protected override string _GetTemplateForLabelAccessoryHair()
	{
		return "Pelo";
	}

	protected override string _GetTemplateForLabelAccessoryHats()
	{
		return "Sombreros";
	}

	protected override string _GetTemplateForLabelAccessoryNeck()
	{
		return "Cuello";
	}

	protected override string _GetTemplateForLabelAccessoryShoulder()
	{
		return "Hombro";
	}

	protected override string _GetTemplateForLabelAccessoryWaist()
	{
		return "Cintura";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelAllBodyParts()
	{
		return "Todas las partes del cuerpo";
	}

	protected override string _GetTemplateForLabelAllCategories()
	{
		return "Todas las categorías";
	}

	protected override string _GetTemplateForLabelAllClothing()
	{
		return "Toda la ropa";
	}

	protected override string _GetTemplateForLabelAllCollectibles()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelAllCreators()
	{
		return "Todos los creadores";
	}

	protected override string _GetTemplateForLabelAllCurrency()
	{
		return "Todas las divisas";
	}

	protected override string _GetTemplateForLabelAllFeatured()
	{
		return "Todos los objetos";
	}

	protected override string _GetTemplateForLabelAllTime()
	{
		return "Todos los tiempos";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animaciones";
	}

	protected override string _GetTemplateForLabelAnyPrice()
	{
		return "Cualquier precio";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Animaciones de avatar";
	}

	protected override string _GetTemplateForLabelBestselling()
	{
		return "Superventas";
	}

	protected override string _GetTemplateForLabelBodyParts()
	{
		return "Partes del cuerpo";
	}

	protected override string _GetTemplateForLabelClothing()
	{
		return "Ropa";
	}

	protected override string _GetTemplateForLabelCollectibleAccessories()
	{
		return "Accessorios";
	}

	protected override string _GetTemplateForLabelCollectibleFaces()
	{
		return "Caras";
	}

	protected override string _GetTemplateForLabelCollectibleGear()
	{
		return "Equipamiento";
	}

	protected override string _GetTemplateForLabelCollectibles()
	{
		return "Coleccionables";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Caras";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Promocionados";
	}

	protected override string _GetTemplateForLabelFeaturedAccesories()
	{
		return "Accessorios";
	}

	protected override string _GetTemplateForLabelFeaturedAnimations()
	{
		return "Animaciones";
	}

	protected override string _GetTemplateForLabelFeaturedFaces()
	{
		return "Caras";
	}

	protected override string _GetTemplateForLabelFeaturedGear()
	{
		return "Equipamiento";
	}

	protected override string _GetTemplateForLabelFeaturedPackages()
	{
		return "Paquetes";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratis";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Equipamiento";
	}

	protected override string _GetTemplateForLabelGearAll()
	{
		return "Todo el equipamiento";
	}

	protected override string _GetTemplateForLabelGearBuilding()
	{
		return "Construcción";
	}

	protected override string _GetTemplateForLabelGearExplosive()
	{
		return "Explosivo";
	}

	protected override string _GetTemplateForLabelGearMelee()
	{
		return "Cuerpo a cuerpo";
	}

	protected override string _GetTemplateForLabelGearMusical()
	{
		return "Musical";
	}

	protected override string _GetTemplateForLabelGearNavigation()
	{
		return "Navegación";
	}

	protected override string _GetTemplateForLabelGearPersonalTransport()
	{
		return "Transporte";
	}

	protected override string _GetTemplateForLabelGearPowerUps()
	{
		return "Potenciador";
	}

	protected override string _GetTemplateForLabelGearRanged()
	{
		return "A distancia";
	}

	protected override string _GetTemplateForLabelGearSocial()
	{
		return "Social";
	}

	protected override string _GetTemplateForLabelGenreAdventure()
	{
		return "Aventura";
	}

	protected override string _GetTemplateForLabelGenreAll()
	{
		return "Todos los géneros";
	}

	protected override string _GetTemplateForLabelGenreBuilding()
	{
		return "Construcción";
	}

	protected override string _GetTemplateForLabelGenreComedy()
	{
		return "Comedia";
	}

	protected override string _GetTemplateForLabelGenreFantasy()
	{
		return "Medieval";
	}

	protected override string _GetTemplateForLabelGenreFighting()
	{
		return "Lucha";
	}

	protected override string _GetTemplateForLabelGenreFPS()
	{
		return "FPS";
	}

	protected override string _GetTemplateForLabelGenreFunny()
	{
		return "Comedia";
	}

	protected override string _GetTemplateForLabelGenreHorror()
	{
		return "Terror";
	}

	protected override string _GetTemplateForLabelGenreMedieval()
	{
		return "Medieval";
	}

	protected override string _GetTemplateForLabelGenreMilitary()
	{
		return "Militar";
	}

	protected override string _GetTemplateForLabelGenreNaval()
	{
		return "Naval";
	}

	protected override string _GetTemplateForLabelGenreNinja()
	{
		return "Lucha";
	}

	protected override string _GetTemplateForLabelGenrePirate()
	{
		return "Naval";
	}

	protected override string _GetTemplateForLabelGenreRPG()
	{
		return "RPG";
	}

	protected override string _GetTemplateForLabelGenreScary()
	{
		return "Terror";
	}

	protected override string _GetTemplateForLabelGenreSciFi()
	{
		return "Ciencia-ficción";
	}

	protected override string _GetTemplateForLabelGenreSports()
	{
		return "Deporte";
	}

	protected override string _GetTemplateForLabelGenreTownAndCity()
	{
		return "Pueblo y ciudad";
	}

	protected override string _GetTemplateForLabelGenreTutorial()
	{
		return "Construcción";
	}

	protected override string _GetTemplateForLabelGenreWar()
	{
		return "Militar";
	}

	protected override string _GetTemplateForLabelGenreWestern()
	{
		return "Western";
	}

	protected override string _GetTemplateForLabelGenreWildWest()
	{
		return "Western";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Cabezas";
	}

	protected override string _GetTemplateForLabelMostFavorited()
	{
		return "Más favoritos";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "Sin reventa";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "Fuera de oferta";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Paquetes";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Pantalones";
	}

	protected override string _GetTemplateForLabelPastDay()
	{
		return "Día anterior";
	}

	protected override string _GetTemplateForLabelPastWeek()
	{
		return "Semana pasada";
	}

	protected override string _GetTemplateForLabelPriceHighFirst()
	{
		return "Precio (de mayor a menor)";
	}

	protected override string _GetTemplateForLabelPriceLowFirst()
	{
		return "Precio (de menor a mayor)";
	}

	protected override string _GetTemplateForLabelRecentlyUpdated()
	{
		return "Actualizados recientemente";
	}

	protected override string _GetTemplateForLabelRelevance()
	{
		return "Relevancia";
	}

	protected override string _GetTemplateForLabelRoblox()
	{
		return "Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForResponseErrorFilter()
	{
		return "Hay errores en la pestaña de filtros";
	}

	protected override string _GetTemplateForResponseGenericError()
	{
		return "Se ha producido un error. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseNoItemsFound()
	{
		return "No se han encontrado objetos.";
	}

	protected override string _GetTemplateForResponseNoSaleItemsFromSearch()
	{
		return "Tu búsqueda no ha encontrado objetos en venta. Debajo se muestran los objetos no disponibles.";
	}

	protected override string _GetTemplateForResponseTemporarilyUnavailable()
	{
		return "El catálogo no está disponible temporalmente. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseThrottled()
	{
		return "¡Vas muy rápido! Inténtalo de nuevo en un minuto.";
	}
}
