namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides CatalogResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class CatalogResources_de_de : CatalogResources_en_us, ICatalogResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BuyRobux"
	/// English String: "Buy Robux"
	/// </summary>
	public override string ActionBuyRobux => "Robux kaufen";

	/// <summary>
	/// Key: "Action.Dialog.AddGearOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogAddGearOk => "Okay";

	/// <summary>
	/// Key: "Action.Filter.Apply"
	/// English String: "Apply"
	/// </summary>
	public override string ActionFilterApply => "Anwenden";

	/// <summary>
	/// Key: "Action.Filter.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionFilterCancel => "Abbrechen";

	/// <summary>
	/// Key: "Action.Go"
	/// English String: "Go"
	/// </summary>
	public override string ActionGo => "Los";

	/// <summary>
	/// Key: "Action.ViewAllItems"
	/// English String: "View All Items"
	/// </summary>
	public override string ActionViewAllItems => "Alle Artikel ansehen";

	/// <summary>
	/// Key: "Description.Dialog.AddGearBody"
	/// English String: "To add gear to your game, find an item in the catalog and click the Add to Game button. The item will automatically be allowed in game, and you'll receive a commission on every copy sold from your game page. (You can only add gear that's for sale.)"
	/// </summary>
	public override string DescriptionDialogAddGearBody => "Um Ausrüstung zu deinem Spiel hinzuzufügen, suche im Katalog nach einem Artikel und klicke dann auf „Zu Spiel hinzufügen“. Der Artikel wird automatisch im Spiel erlaubt und du erhältst einen Anteil für jedes Exemplar, das auf deiner Spielseite verkauft wird. (Du kannst nur Ausrüstung hinzufügen, die zum Kauf angeboten wird.)";

	/// <summary>
	/// Key: "Heading.CatalogCategory"
	/// English String: "Category"
	/// </summary>
	public override string HeadingCatalogCategory => "Kategorie";

	/// <summary>
	/// Key: "Heading.CatalogPage"
	/// English String: "Catalog"
	/// </summary>
	public override string HeadingCatalogPage => "Katalog";

	/// <summary>
	/// Key: "Label.AllFeaturedItems"
	/// English String: "View All Featured Items"
	/// </summary>
	public override string LabelAllFeaturedItems => "Alle Highlight-Artikel ansehen";

	/// <summary>
	/// Key: "Label.AllGenres"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelAllGenres => "Alle Genres";

	/// <summary>
	/// Key: "Label.Amazon"
	/// label
	/// English String: "Amazon"
	/// </summary>
	public override string LabelAmazon => "Amazon";

	/// <summary>
	/// Key: "Label.BreadCrumb.Free"
	/// English String: "Free"
	/// </summary>
	public override string LabelBreadCrumbFree => "Gratis";

	/// <summary>
	/// Key: "Label.BreadCrumb.Group"
	/// English String: "Group:"
	/// </summary>
	public override string LabelBreadCrumbGroup => "Gruppe:";

	/// <summary>
	/// Key: "Label.Bundle"
	/// Bundle
	/// English String: "Bundle"
	/// </summary>
	public override string LabelBundle => "Paket";

	/// <summary>
	/// Key: "Label.Bundles"
	/// Bundles
	/// English String: "Bundles"
	/// </summary>
	public override string LabelBundles => "Pakete";

	/// <summary>
	/// Key: "Label.Card.CreatorBy"
	/// English String: "By"
	/// </summary>
	public override string LabelCardCreatorBy => "Von";

	/// <summary>
	/// Key: "Label.Card.PriceWas"
	/// English String: "Was"
	/// </summary>
	public override string LabelCardPriceWas => "Zuvor";

	/// <summary>
	/// Key: "Label.Card.Remaining"
	/// English String: "Remaining:"
	/// </summary>
	public override string LabelCardRemaining => "Übrig:";

	/// <summary>
	/// Key: "Label.CategoryAttributes"
	/// English String: "Attributes"
	/// </summary>
	public override string LabelCategoryAttributes => "Attribute";

	/// <summary>
	/// Key: "Label.CategoryType"
	/// English String: "Type"
	/// </summary>
	public override string LabelCategoryType => "Art";

	/// <summary>
	/// Key: "Label.CommunityCreations"
	/// UGC items
	/// English String: " Community Creations"
	/// </summary>
	public override string LabelCommunityCreations => " Community-Schöpfungen";

	/// <summary>
	/// Key: "Label.Dialog.AddGearTitle"
	/// English String: "Add Gear to Your Game"
	/// </summary>
	public override string LabelDialogAddGearTitle => "Ausrüstung zu deinem Spiel hinzufügen";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Emotes
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoriten";

	/// <summary>
	/// Key: "Label.FeaturedBundles"
	/// Featured Bundles
	/// English String: "Featured Bundles"
	/// </summary>
	public override string LabelFeaturedBundles => "Highlight-Pakete";

	/// <summary>
	/// Key: "Label.FeaturedEmotes"
	/// Featured Emotes
	/// English String: "Featured Emotes"
	/// </summary>
	public override string LabelFeaturedEmotes => "Highlight-Emotes";

	/// <summary>
	/// Key: "Label.Filter.ByTime"
	/// English String: "By Time"
	/// </summary>
	public override string LabelFilterByTime => "Nach Zeit";

	/// <summary>
	/// Key: "Label.Filter.Category"
	/// English String: "Category"
	/// </summary>
	public override string LabelFilterCategory => "Kategorie";

	/// <summary>
	/// Key: "Label.Filter.Creator"
	/// English String: "Creator"
	/// </summary>
	public override string LabelFilterCreator => "Ersteller";

	/// <summary>
	/// Key: "Label.Filter.Filter"
	/// English String: "Filter"
	/// </summary>
	public override string LabelFilterFilter => "Filter";

	/// <summary>
	/// Key: "Label.Filter.Filters"
	/// English String: "Filters"
	/// </summary>
	public override string LabelFilterFilters => "Filter";

	/// <summary>
	/// Key: "Label.Filter.Genre"
	/// English String: "Genre"
	/// </summary>
	public override string LabelFilterGenre => "Genre";

	/// <summary>
	/// Key: "Label.Filter.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string LabelFilterHide => "Verbergen";

	/// <summary>
	/// Key: "Label.Filter.Price"
	/// English String: "Price"
	/// </summary>
	public override string LabelFilterPrice => "Preis";

	/// <summary>
	/// Key: "Label.Filter.PriceMax"
	/// English String: "Max"
	/// </summary>
	public override string LabelFilterPriceMax => "Max.";

	/// <summary>
	/// Key: "Label.Filter.PriceMin"
	/// English String: "Min"
	/// </summary>
	public override string LabelFilterPriceMin => "Min.";

	/// <summary>
	/// Key: "Label.Filter.PriceTo"
	/// English String: "To"
	/// </summary>
	public override string LabelFilterPriceTo => "Bis";

	/// <summary>
	/// Key: "Label.Filter.Show"
	/// English String: "Show"
	/// </summary>
	public override string LabelFilterShow => "Anzeigen";

	/// <summary>
	/// Key: "Label.Filter.Sorting"
	/// English String: "Sorting"
	/// </summary>
	public override string LabelFilterSorting => "Sortierung";

	/// <summary>
	/// Key: "Label.Filter.UnavailableItems"
	/// English String: "Unavailable Items"
	/// </summary>
	public override string LabelFilterUnavailableItems => "Nicht verfügbare Artikel";

	/// <summary>
	/// Key: "Label.GoogleOnly"
	/// label
	/// English String: "Google Only"
	/// </summary>
	public override string LabelGoogleOnly => "Nur Google";

	/// <summary>
	/// Key: "Label.Ios"
	/// label
	/// English String: "IOS"
	/// </summary>
	public override string LabelIos => "iOS";

	/// <summary>
	/// Key: "Label.Mobile"
	/// label
	/// English String: "Mobile"
	/// </summary>
	public override string LabelMobile => "Mobil";

	/// <summary>
	/// Key: "Label.New"
	/// label
	/// English String: "New"
	/// </summary>
	public override string LabelNew => "Neu";

	/// <summary>
	/// Key: "Label.Rthro"
	/// Rthro is "Anthro" but we replaced the beginning of the word with an "R" to align with "R6" and "R15"
	/// English String: "Rthro"
	/// </summary>
	public override string LabelRthro => "Rthro";

	/// <summary>
	/// Key: "Label.Sale"
	/// label
	/// English String: "Sale"
	/// </summary>
	public override string LabelSale => "Angebot";

	/// <summary>
	/// Key: "Label.SearchField"
	/// English String: "Search"
	/// </summary>
	public override string LabelSearchField => "Suche";

	/// <summary>
	/// Key: "Label.SeeAll"
	/// English String: "See All"
	/// </summary>
	public override string LabelSeeAll => "Alle ansehen";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username"
	/// </summary>
	public override string LabelUsername => "Benutzername";

	/// <summary>
	/// Key: "Label.Xbox"
	/// label
	/// English String: "Xbox"
	/// </summary>
	public override string LabelXbox => "Xbox";

	/// <summary>
	/// Key: "LabelAccessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Accessoires";

	/// <summary>
	/// Key: "LabelAccessoryAll"
	/// English String: "All Accessories"
	/// </summary>
	public override string LabelAccessoryAll => "Alle Accessoires";

	/// <summary>
	/// Key: "LabelAccessoryBack"
	/// English String: "Back"
	/// </summary>
	public override string LabelAccessoryBack => "Zurück";

	/// <summary>
	/// Key: "LabelAccessoryFace"
	/// English String: "Face"
	/// </summary>
	public override string LabelAccessoryFace => "Gesicht";

	/// <summary>
	/// Key: "LabelAccessoryFront"
	/// English String: "Front"
	/// </summary>
	public override string LabelAccessoryFront => "Vorderseite";

	/// <summary>
	/// Key: "LabelAccessoryHair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelAccessoryHair => "Haare";

	/// <summary>
	/// Key: "LabelAccessoryHats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelAccessoryHats => "Hüte";

	/// <summary>
	/// Key: "LabelAccessoryNeck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelAccessoryNeck => "Hals";

	/// <summary>
	/// Key: "LabelAccessoryShoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelAccessoryShoulder => "Schulter";

	/// <summary>
	/// Key: "LabelAccessoryWaist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelAccessoryWaist => "Taille";

	/// <summary>
	/// Key: "LabelAll"
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Alle";

	/// <summary>
	/// Key: "LabelAllBodyParts"
	/// English String: "All Body Parts"
	/// </summary>
	public override string LabelAllBodyParts => "Alle Körperteile";

	/// <summary>
	/// Key: "LabelAllCategories"
	/// English String: "All Categories"
	/// </summary>
	public override string LabelAllCategories => "Alle Kategorien";

	/// <summary>
	/// Key: "LabelAllClothing"
	/// English String: "All Clothing"
	/// </summary>
	public override string LabelAllClothing => "Sämtliche Kleidung";

	/// <summary>
	/// Key: "LabelAllCollectibles"
	/// English String: "All Collectibles"
	/// </summary>
	public override string LabelAllCollectibles => "Alle Sammlerobjekte";

	/// <summary>
	/// Key: "LabelAllCreators"
	/// English String: "All Creators"
	/// </summary>
	public override string LabelAllCreators => "Alle Ersteller";

	/// <summary>
	/// Key: "LabelAllCurrency"
	/// English String: "All Currency"
	/// </summary>
	public override string LabelAllCurrency => "Alle Währungen";

	/// <summary>
	/// Key: "LabelAllFeatured"
	/// English String: "All Featured Items"
	/// </summary>
	public override string LabelAllFeatured => "Alle Highlight-Artikel";

	/// <summary>
	/// Key: "LabelAllTime"
	/// English String: "All Time"
	/// </summary>
	public override string LabelAllTime => "Seit Beginn";

	/// <summary>
	/// Key: "LabelAnimations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animationen";

	/// <summary>
	/// Key: "LabelAnyPrice"
	/// English String: "Any Price"
	/// </summary>
	public override string LabelAnyPrice => "Beliebiger Preis";

	/// <summary>
	/// Key: "LabelAvatarAnimations"
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Avataranimationen";

	/// <summary>
	/// Key: "LabelBestselling"
	/// English String: "Bestselling"
	/// </summary>
	public override string LabelBestselling => "Bestseller";

	/// <summary>
	/// Key: "LabelBodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string LabelBodyParts => "Körperteile";

	/// <summary>
	/// Key: "LabelClothing"
	/// English String: "Clothing"
	/// </summary>
	public override string LabelClothing => "Kleidung";

	/// <summary>
	/// Key: "LabelCollectibleAccessories"
	/// English String: "Collectible Accessories"
	/// </summary>
	public override string LabelCollectibleAccessories => "Accessoires-Sammlerobjekte";

	/// <summary>
	/// Key: "LabelCollectibleFaces"
	/// English String: "Collectible Faces"
	/// </summary>
	public override string LabelCollectibleFaces => "Gesichter-Sammlerobjekte";

	/// <summary>
	/// Key: "LabelCollectibleGear"
	/// English String: "Collectible Gear"
	/// </summary>
	public override string LabelCollectibleGear => "Ausrüstung-Sammlerobjekte";

	/// <summary>
	/// Key: "LabelCollectibles"
	/// English String: "Collectibles"
	/// </summary>
	public override string LabelCollectibles => "Sammlerobjekte";

	/// <summary>
	/// Key: "LabelFaces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Gesichter";

	/// <summary>
	/// Key: "LabelFeatured"
	/// English String: "Featured"
	/// </summary>
	public override string LabelFeatured => "Highlight";

	/// <summary>
	/// Key: "LabelFeaturedAccesories"
	/// English String: "Featured Accessories"
	/// </summary>
	public override string LabelFeaturedAccesories => "Highlight-Accessoires";

	/// <summary>
	/// Key: "LabelFeaturedAnimations"
	/// English String: "Featured Animations"
	/// </summary>
	public override string LabelFeaturedAnimations => "Highlight-Animationen";

	/// <summary>
	/// Key: "LabelFeaturedFaces"
	/// English String: "Featured Faces"
	/// </summary>
	public override string LabelFeaturedFaces => "Highlight-Gesichter";

	/// <summary>
	/// Key: "LabelFeaturedGear"
	/// English String: "Featured Gear"
	/// </summary>
	public override string LabelFeaturedGear => "Highlight-Ausrüstung";

	/// <summary>
	/// Key: "LabelFeaturedPackages"
	/// English String: "Featured Packages"
	/// </summary>
	public override string LabelFeaturedPackages => "Highlight-Pakete";

	/// <summary>
	/// Key: "LabelFree"
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratis";

	/// <summary>
	/// Key: "LabelGear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Ausrüstung";

	/// <summary>
	/// Key: "LabelGearAll"
	/// English String: "All Gear"
	/// </summary>
	public override string LabelGearAll => "Sämtliche Ausrüstung";

	/// <summary>
	/// Key: "LabelGearBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGearBuilding => "Bauen";

	/// <summary>
	/// Key: "LabelGearExplosive"
	/// English String: "Explosive"
	/// </summary>
	public override string LabelGearExplosive => "Explosiv";

	/// <summary>
	/// Key: "LabelGearMelee"
	/// English String: "Melee"
	/// </summary>
	public override string LabelGearMelee => "Nahkampf";

	/// <summary>
	/// Key: "LabelGearMusical"
	/// English String: "Musical"
	/// </summary>
	public override string LabelGearMusical => "Musik";

	/// <summary>
	/// Key: "LabelGearNavigation"
	/// English String: "Navigation"
	/// </summary>
	public override string LabelGearNavigation => "Navigation";

	/// <summary>
	/// Key: "LabelGearPersonalTransport"
	/// English String: "Transport"
	/// </summary>
	public override string LabelGearPersonalTransport => "Transport";

	/// <summary>
	/// Key: "LabelGearPowerUps"
	/// English String: "Power Up"
	/// </summary>
	public override string LabelGearPowerUps => "Power-up";

	/// <summary>
	/// Key: "LabelGearRanged"
	/// English String: "Ranged"
	/// </summary>
	public override string LabelGearRanged => "Fernkampf";

	/// <summary>
	/// Key: "LabelGearSocial"
	/// English String: "Social"
	/// </summary>
	public override string LabelGearSocial => "Sozial";

	/// <summary>
	/// Key: "LabelGenreAdventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelGenreAdventure => "Abenteuer";

	/// <summary>
	/// Key: "LabelGenreAll"
	/// English String: "All Genres"
	/// </summary>
	public override string LabelGenreAll => "Alle Genres";

	/// <summary>
	/// Key: "LabelGenreBuilding"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreBuilding => "Bauen";

	/// <summary>
	/// Key: "LabelGenreComedy"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreComedy => "Komödie";

	/// <summary>
	/// Key: "LabelGenreFantasy"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreFantasy => "Mittelalter";

	/// <summary>
	/// Key: "LabelGenreFighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreFighting => "Kampf";

	/// <summary>
	/// Key: "LabelGenreFPS"
	/// English String: "FPS"
	/// </summary>
	public override string LabelGenreFPS => "Ego-Shooter";

	/// <summary>
	/// Key: "LabelGenreFunny"
	/// English String: "Comedy"
	/// </summary>
	public override string LabelGenreFunny => "Komödie";

	/// <summary>
	/// Key: "LabelGenreHorror"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreHorror => "Horror";

	/// <summary>
	/// Key: "LabelGenreMedieval"
	/// English String: "Medieval"
	/// </summary>
	public override string LabelGenreMedieval => "Mittelalter";

	/// <summary>
	/// Key: "LabelGenreMilitary"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreMilitary => "Militär";

	/// <summary>
	/// Key: "LabelGenreNaval"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenreNaval => "Seefahrt";

	/// <summary>
	/// Key: "LabelGenreNinja"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelGenreNinja => "Kampf";

	/// <summary>
	/// Key: "LabelGenrePirate"
	/// English String: "Naval"
	/// </summary>
	public override string LabelGenrePirate => "Seefahrt";

	/// <summary>
	/// Key: "LabelGenreRPG"
	/// English String: "RPG"
	/// </summary>
	public override string LabelGenreRPG => "RPG";

	/// <summary>
	/// Key: "LabelGenreScary"
	/// English String: "Horror"
	/// </summary>
	public override string LabelGenreScary => "Horror";

	/// <summary>
	/// Key: "LabelGenreSciFi"
	/// English String: "Sci-Fi"
	/// </summary>
	public override string LabelGenreSciFi => "Scifi";

	/// <summary>
	/// Key: "LabelGenreSports"
	/// English String: "Sports"
	/// </summary>
	public override string LabelGenreSports => "Sport";

	/// <summary>
	/// Key: "LabelGenreTownAndCity"
	/// English String: "Town and City"
	/// </summary>
	public override string LabelGenreTownAndCity => "Dorf und Stadt";

	/// <summary>
	/// Key: "LabelGenreTutorial"
	/// English String: "Building"
	/// </summary>
	public override string LabelGenreTutorial => "Bauen";

	/// <summary>
	/// Key: "LabelGenreWar"
	/// English String: "Military"
	/// </summary>
	public override string LabelGenreWar => "Militär";

	/// <summary>
	/// Key: "LabelGenreWestern"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWestern => "Western";

	/// <summary>
	/// Key: "LabelGenreWildWest"
	/// English String: "Western"
	/// </summary>
	public override string LabelGenreWildWest => "Western";

	/// <summary>
	/// Key: "LabelHeads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Köpfe";

	/// <summary>
	/// Key: "LabelMostFavorited"
	/// English String: "Most Favorited"
	/// </summary>
	public override string LabelMostFavorited => "Am beliebtesten";

	/// <summary>
	/// Key: "LabelNoResellers"
	/// English String: "No Resellers"
	/// </summary>
	public override string LabelNoResellers => "Keine Wiederverkäufer";

	/// <summary>
	/// Key: "LabelOffSale"
	/// English String: "Offsale"
	/// </summary>
	public override string LabelOffSale => "Nicht kaufbar";

	/// <summary>
	/// Key: "LabelPackages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Pakete";

	/// <summary>
	/// Key: "LabelPants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Hosen";

	/// <summary>
	/// Key: "LabelPastDay"
	/// English String: "Past Day"
	/// </summary>
	public override string LabelPastDay => "Vorheriger Tag";

	/// <summary>
	/// Key: "LabelPastWeek"
	/// English String: "Past Week"
	/// </summary>
	public override string LabelPastWeek => "Letzte Woche";

	/// <summary>
	/// Key: "LabelPriceHighFirst"
	/// English String: "Price (High to Low)"
	/// </summary>
	public override string LabelPriceHighFirst => "Preis (hoch bis niedrig)";

	/// <summary>
	/// Key: "LabelPriceLowFirst"
	/// English String: "Price (Low to High)"
	/// </summary>
	public override string LabelPriceLowFirst => "Preis (niedrig bis hoch)";

	/// <summary>
	/// Key: "LabelRecentlyUpdated"
	/// English String: "Recently Updated"
	/// </summary>
	public override string LabelRecentlyUpdated => "Kürzlich aktualisiert";

	/// <summary>
	/// Key: "LabelRelevance"
	/// English String: "Relevance"
	/// </summary>
	public override string LabelRelevance => "Relevanz";

	/// <summary>
	/// Key: "LabelRoblox"
	/// English String: "Roblox"
	/// </summary>
	public override string LabelRoblox => "Roblox";

	/// <summary>
	/// Key: "LabelRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelRobux => "Robux";

	/// <summary>
	/// Key: "LabelShirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Hemden";

	/// <summary>
	/// Key: "LabelTShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "T-Shirts";

	/// <summary>
	/// Key: "Response.Error.Filter"
	/// English String: "Errors exist in Filter tab"
	/// </summary>
	public override string ResponseErrorFilter => "Im Filterreiter sind Fehler aufgetreten.";

	/// <summary>
	/// Key: "Response.GenericError"
	/// English String: "An error occurred. Please try again later."
	/// </summary>
	public override string ResponseGenericError => "Ein Fehler ist aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.NoItemsFound"
	/// English String: "No items found."
	/// </summary>
	public override string ResponseNoItemsFound => "Keine Artikel gefunden.";

	/// <summary>
	/// Key: "Response.NoSaleItemsFromSearch"
	/// English String: "Your search did not find items for sale. Unavailable items displayed below."
	/// </summary>
	public override string ResponseNoSaleItemsFromSearch => "Deine Suche hat keine Artikel ergeben, die zum Kauf angeboten werden. Nicht verfügbare Artikel werden unten angezeigt.";

	/// <summary>
	/// Key: "Response.TemporarilyUnavailable"
	/// English String: "Catalog temporarily unavailable. Please try again later."
	/// </summary>
	public override string ResponseTemporarilyUnavailable => "Katalog derzeit nicht verfügbar. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Throttled"
	/// Shown to users when they have made too many requests in a minute and are being throttled.
	/// English String: "You're going too fast! Try again in a minute."
	/// </summary>
	public override string ResponseThrottled => "Zu schnell! Versuch es erneut in einer Minute.";

	public CatalogResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBuyRobux()
	{
		return "Robux kaufen";
	}

	protected override string _GetTemplateForActionDialogAddGearOk()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionFilterApply()
	{
		return "Anwenden";
	}

	protected override string _GetTemplateForActionFilterCancel()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionGo()
	{
		return "Los";
	}

	protected override string _GetTemplateForActionViewAllItems()
	{
		return "Alle Artikel ansehen";
	}

	protected override string _GetTemplateForDescriptionDialogAddGearBody()
	{
		return "Um Ausrüstung zu deinem Spiel hinzuzufügen, suche im Katalog nach einem Artikel und klicke dann auf „Zu Spiel hinzufügen“. Der Artikel wird automatisch im Spiel erlaubt und du erhältst einen Anteil für jedes Exemplar, das auf deiner Spielseite verkauft wird. (Du kannst nur Ausrüstung hinzufügen, die zum Kauf angeboten wird.)";
	}

	protected override string _GetTemplateForHeadingCatalogCategory()
	{
		return "Kategorie";
	}

	protected override string _GetTemplateForHeadingCatalogPage()
	{
		return "Katalog";
	}

	protected override string _GetTemplateForLabelAllFeaturedItems()
	{
		return "Alle Highlight-Artikel ansehen";
	}

	protected override string _GetTemplateForLabelAllGenres()
	{
		return "Alle Genres";
	}

	protected override string _GetTemplateForLabelAmazon()
	{
		return "Amazon";
	}

	protected override string _GetTemplateForLabelBreadCrumbFree()
	{
		return "Gratis";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreOrText"
	/// English String: "{genreName1} or {genreName2}"
	/// </summary>
	public override string LabelBreadCrumbGenreOrText(string genreName1, string genreName2)
	{
		return $"{genreName1} oder {genreName2}";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreOrText()
	{
		return "{genreName1} oder {genreName2}";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.GenreSelectedText"
	/// English String: "Genre: {genreCount} selected"
	/// </summary>
	public override string LabelBreadCrumbGenreSelectedText(string genreCount)
	{
		return $"Genre: {genreCount} gewählt";
	}

	protected override string _GetTemplateForLabelBreadCrumbGenreSelectedText()
	{
		return "Genre: {genreCount} gewählt";
	}

	protected override string _GetTemplateForLabelBreadCrumbGroup()
	{
		return "Gruppe:";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceAbove"
	/// English String: "{price} and above"
	/// </summary>
	public override string LabelBreadCrumbPriceAbove(string price)
	{
		return $"{price} und höher";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceAbove()
	{
		return "{price} und höher";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.PriceBelow"
	/// English String: "{price} and below"
	/// </summary>
	public override string LabelBreadCrumbPriceBelow(string price)
	{
		return $"{price} und niedriger";
	}

	protected override string _GetTemplateForLabelBreadCrumbPriceBelow()
	{
		return "{price} und niedriger";
	}

	/// <summary>
	/// Key: "Label.BreadCrumb.ResultsCount"
	/// English String: "{startNumber} - {endNumber} of {resultsCount} Results"
	/// </summary>
	public override string LabelBreadCrumbResultsCount(string startNumber, string endNumber, string resultsCount)
	{
		return $"{startNumber}\u00a0– {endNumber} von {resultsCount} Ergebnissen";
	}

	protected override string _GetTemplateForLabelBreadCrumbResultsCount()
	{
		return "{startNumber}\u00a0– {endNumber} von {resultsCount} Ergebnissen";
	}

	protected override string _GetTemplateForLabelBundle()
	{
		return "Paket";
	}

	protected override string _GetTemplateForLabelBundles()
	{
		return "Pakete";
	}

	/// <summary>
	/// Key: "Label.ByCreatorLink"
	/// Creator name in item card with link
	/// English String: "By {linkStart}{creator}{linkEnd}"
	/// </summary>
	public override string LabelByCreatorLink(string linkStart, string creator, string linkEnd)
	{
		return $"Von {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelByCreatorLink()
	{
		return "Von {linkStart}{creator}{linkEnd}";
	}

	protected override string _GetTemplateForLabelCardCreatorBy()
	{
		return "Von";
	}

	protected override string _GetTemplateForLabelCardPriceWas()
	{
		return "Zuvor";
	}

	protected override string _GetTemplateForLabelCardRemaining()
	{
		return "Übrig:";
	}

	protected override string _GetTemplateForLabelCategoryAttributes()
	{
		return "Attribute";
	}

	protected override string _GetTemplateForLabelCategoryType()
	{
		return "Art";
	}

	protected override string _GetTemplateForLabelCommunityCreations()
	{
		return " Community-Schöpfungen";
	}

	protected override string _GetTemplateForLabelDialogAddGearTitle()
	{
		return "Ausrüstung zu deinem Spiel hinzufügen";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoriten";
	}

	protected override string _GetTemplateForLabelFeaturedBundles()
	{
		return "Highlight-Pakete";
	}

	protected override string _GetTemplateForLabelFeaturedEmotes()
	{
		return "Highlight-Emotes";
	}

	/// <summary>
	/// Key: "Label.FeaturedItemsOnRoblox"
	/// English String: "Featured Items on {spanStart}{roblox}{spanEnd}"
	/// </summary>
	public override string LabelFeaturedItemsOnRoblox(string spanStart, string roblox, string spanEnd)
	{
		return $"Highlight-Artikel bei {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFeaturedItemsOnRoblox()
	{
		return "Highlight-Artikel bei {spanStart}{roblox}{spanEnd}";
	}

	protected override string _GetTemplateForLabelFilterByTime()
	{
		return "Nach Zeit";
	}

	protected override string _GetTemplateForLabelFilterCategory()
	{
		return "Kategorie";
	}

	protected override string _GetTemplateForLabelFilterCreator()
	{
		return "Ersteller";
	}

	protected override string _GetTemplateForLabelFilterFilter()
	{
		return "Filter";
	}

	protected override string _GetTemplateForLabelFilterFilters()
	{
		return "Filter";
	}

	protected override string _GetTemplateForLabelFilterGenre()
	{
		return "Genre";
	}

	protected override string _GetTemplateForLabelFilterHide()
	{
		return "Verbergen";
	}

	protected override string _GetTemplateForLabelFilterPrice()
	{
		return "Preis";
	}

	protected override string _GetTemplateForLabelFilterPriceMax()
	{
		return "Max.";
	}

	protected override string _GetTemplateForLabelFilterPriceMin()
	{
		return "Min.";
	}

	protected override string _GetTemplateForLabelFilterPriceTo()
	{
		return "Bis";
	}

	protected override string _GetTemplateForLabelFilterShow()
	{
		return "Anzeigen";
	}

	protected override string _GetTemplateForLabelFilterSorting()
	{
		return "Sortierung";
	}

	protected override string _GetTemplateForLabelFilterUnavailableItems()
	{
		return "Nicht verfügbare Artikel";
	}

	protected override string _GetTemplateForLabelGoogleOnly()
	{
		return "Nur Google";
	}

	protected override string _GetTemplateForLabelIos()
	{
		return "iOS";
	}

	protected override string _GetTemplateForLabelMobile()
	{
		return "Mobil";
	}

	protected override string _GetTemplateForLabelNew()
	{
		return "Neu";
	}

	protected override string _GetTemplateForLabelRthro()
	{
		return "Rthro";
	}

	protected override string _GetTemplateForLabelSale()
	{
		return "Angebot";
	}

	protected override string _GetTemplateForLabelSearchField()
	{
		return "Suche";
	}

	protected override string _GetTemplateForLabelSeeAll()
	{
		return "Alle ansehen";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Benutzername";
	}

	protected override string _GetTemplateForLabelXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Accessoires";
	}

	protected override string _GetTemplateForLabelAccessoryAll()
	{
		return "Alle Accessoires";
	}

	protected override string _GetTemplateForLabelAccessoryBack()
	{
		return "Zurück";
	}

	protected override string _GetTemplateForLabelAccessoryFace()
	{
		return "Gesicht";
	}

	protected override string _GetTemplateForLabelAccessoryFront()
	{
		return "Vorderseite";
	}

	protected override string _GetTemplateForLabelAccessoryHair()
	{
		return "Haare";
	}

	protected override string _GetTemplateForLabelAccessoryHats()
	{
		return "Hüte";
	}

	protected override string _GetTemplateForLabelAccessoryNeck()
	{
		return "Hals";
	}

	protected override string _GetTemplateForLabelAccessoryShoulder()
	{
		return "Schulter";
	}

	protected override string _GetTemplateForLabelAccessoryWaist()
	{
		return "Taille";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Alle";
	}

	protected override string _GetTemplateForLabelAllBodyParts()
	{
		return "Alle Körperteile";
	}

	protected override string _GetTemplateForLabelAllCategories()
	{
		return "Alle Kategorien";
	}

	protected override string _GetTemplateForLabelAllClothing()
	{
		return "Sämtliche Kleidung";
	}

	protected override string _GetTemplateForLabelAllCollectibles()
	{
		return "Alle Sammlerobjekte";
	}

	protected override string _GetTemplateForLabelAllCreators()
	{
		return "Alle Ersteller";
	}

	protected override string _GetTemplateForLabelAllCurrency()
	{
		return "Alle Währungen";
	}

	protected override string _GetTemplateForLabelAllFeatured()
	{
		return "Alle Highlight-Artikel";
	}

	protected override string _GetTemplateForLabelAllTime()
	{
		return "Seit Beginn";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animationen";
	}

	protected override string _GetTemplateForLabelAnyPrice()
	{
		return "Beliebiger Preis";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Avataranimationen";
	}

	protected override string _GetTemplateForLabelBestselling()
	{
		return "Bestseller";
	}

	protected override string _GetTemplateForLabelBodyParts()
	{
		return "Körperteile";
	}

	protected override string _GetTemplateForLabelClothing()
	{
		return "Kleidung";
	}

	protected override string _GetTemplateForLabelCollectibleAccessories()
	{
		return "Accessoires-Sammlerobjekte";
	}

	protected override string _GetTemplateForLabelCollectibleFaces()
	{
		return "Gesichter-Sammlerobjekte";
	}

	protected override string _GetTemplateForLabelCollectibleGear()
	{
		return "Ausrüstung-Sammlerobjekte";
	}

	protected override string _GetTemplateForLabelCollectibles()
	{
		return "Sammlerobjekte";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Gesichter";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Highlight";
	}

	protected override string _GetTemplateForLabelFeaturedAccesories()
	{
		return "Highlight-Accessoires";
	}

	protected override string _GetTemplateForLabelFeaturedAnimations()
	{
		return "Highlight-Animationen";
	}

	protected override string _GetTemplateForLabelFeaturedFaces()
	{
		return "Highlight-Gesichter";
	}

	protected override string _GetTemplateForLabelFeaturedGear()
	{
		return "Highlight-Ausrüstung";
	}

	protected override string _GetTemplateForLabelFeaturedPackages()
	{
		return "Highlight-Pakete";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratis";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Ausrüstung";
	}

	protected override string _GetTemplateForLabelGearAll()
	{
		return "Sämtliche Ausrüstung";
	}

	protected override string _GetTemplateForLabelGearBuilding()
	{
		return "Bauen";
	}

	protected override string _GetTemplateForLabelGearExplosive()
	{
		return "Explosiv";
	}

	protected override string _GetTemplateForLabelGearMelee()
	{
		return "Nahkampf";
	}

	protected override string _GetTemplateForLabelGearMusical()
	{
		return "Musik";
	}

	protected override string _GetTemplateForLabelGearNavigation()
	{
		return "Navigation";
	}

	protected override string _GetTemplateForLabelGearPersonalTransport()
	{
		return "Transport";
	}

	protected override string _GetTemplateForLabelGearPowerUps()
	{
		return "Power-up";
	}

	protected override string _GetTemplateForLabelGearRanged()
	{
		return "Fernkampf";
	}

	protected override string _GetTemplateForLabelGearSocial()
	{
		return "Sozial";
	}

	protected override string _GetTemplateForLabelGenreAdventure()
	{
		return "Abenteuer";
	}

	protected override string _GetTemplateForLabelGenreAll()
	{
		return "Alle Genres";
	}

	protected override string _GetTemplateForLabelGenreBuilding()
	{
		return "Bauen";
	}

	protected override string _GetTemplateForLabelGenreComedy()
	{
		return "Komödie";
	}

	protected override string _GetTemplateForLabelGenreFantasy()
	{
		return "Mittelalter";
	}

	protected override string _GetTemplateForLabelGenreFighting()
	{
		return "Kampf";
	}

	protected override string _GetTemplateForLabelGenreFPS()
	{
		return "Ego-Shooter";
	}

	protected override string _GetTemplateForLabelGenreFunny()
	{
		return "Komödie";
	}

	protected override string _GetTemplateForLabelGenreHorror()
	{
		return "Horror";
	}

	protected override string _GetTemplateForLabelGenreMedieval()
	{
		return "Mittelalter";
	}

	protected override string _GetTemplateForLabelGenreMilitary()
	{
		return "Militär";
	}

	protected override string _GetTemplateForLabelGenreNaval()
	{
		return "Seefahrt";
	}

	protected override string _GetTemplateForLabelGenreNinja()
	{
		return "Kampf";
	}

	protected override string _GetTemplateForLabelGenrePirate()
	{
		return "Seefahrt";
	}

	protected override string _GetTemplateForLabelGenreRPG()
	{
		return "RPG";
	}

	protected override string _GetTemplateForLabelGenreScary()
	{
		return "Horror";
	}

	protected override string _GetTemplateForLabelGenreSciFi()
	{
		return "Scifi";
	}

	protected override string _GetTemplateForLabelGenreSports()
	{
		return "Sport";
	}

	protected override string _GetTemplateForLabelGenreTownAndCity()
	{
		return "Dorf und Stadt";
	}

	protected override string _GetTemplateForLabelGenreTutorial()
	{
		return "Bauen";
	}

	protected override string _GetTemplateForLabelGenreWar()
	{
		return "Militär";
	}

	protected override string _GetTemplateForLabelGenreWestern()
	{
		return "Western";
	}

	protected override string _GetTemplateForLabelGenreWildWest()
	{
		return "Western";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Köpfe";
	}

	protected override string _GetTemplateForLabelMostFavorited()
	{
		return "Am beliebtesten";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "Keine Wiederverkäufer";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "Nicht kaufbar";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Pakete";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Hosen";
	}

	protected override string _GetTemplateForLabelPastDay()
	{
		return "Vorheriger Tag";
	}

	protected override string _GetTemplateForLabelPastWeek()
	{
		return "Letzte Woche";
	}

	protected override string _GetTemplateForLabelPriceHighFirst()
	{
		return "Preis (hoch bis niedrig)";
	}

	protected override string _GetTemplateForLabelPriceLowFirst()
	{
		return "Preis (niedrig bis hoch)";
	}

	protected override string _GetTemplateForLabelRecentlyUpdated()
	{
		return "Kürzlich aktualisiert";
	}

	protected override string _GetTemplateForLabelRelevance()
	{
		return "Relevanz";
	}

	protected override string _GetTemplateForLabelRoblox()
	{
		return "Roblox";
	}

	protected override string _GetTemplateForLabelRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Hemden";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "T-Shirts";
	}

	protected override string _GetTemplateForResponseErrorFilter()
	{
		return "Im Filterreiter sind Fehler aufgetreten.";
	}

	protected override string _GetTemplateForResponseGenericError()
	{
		return "Ein Fehler ist aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseNoItemsFound()
	{
		return "Keine Artikel gefunden.";
	}

	protected override string _GetTemplateForResponseNoSaleItemsFromSearch()
	{
		return "Deine Suche hat keine Artikel ergeben, die zum Kauf angeboten werden. Nicht verfügbare Artikel werden unten angezeigt.";
	}

	protected override string _GetTemplateForResponseTemporarilyUnavailable()
	{
		return "Katalog derzeit nicht verfügbar. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseThrottled()
	{
		return "Zu schnell! Versuch es erneut in einer Minute.";
	}
}
