namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AvatarResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AvatarResources_zh_cjv : AvatarResources_en_us, IAvatarResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Advanced"
	/// Click Advanced to get the advanced options
	/// English String: "Advanced"
	/// </summary>
	public override string ActionAdvanced => "高级";

	/// <summary>
	/// Key: "Action.Buy"
	/// Button used to buy an item to customize the user's avatar.
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "购买";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "取消";

	/// <summary>
	/// Key: "Action.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "关闭";

	/// <summary>
	/// Key: "Action.Create"
	/// English String: "Create"
	/// </summary>
	public override string ActionCreate => "创建";

	/// <summary>
	/// Key: "Action.CreateNewOutfit"
	/// Button to create new outfit
	/// English String: "Create"
	/// </summary>
	public override string ActionCreateNewOutfit => "创建";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "删除";

	/// <summary>
	/// Key: "Action.Done"
	/// English String: "Done"
	/// </summary>
	public override string ActionDone => "完成";

	/// <summary>
	/// Key: "Action.Get"
	/// Button used to buy get an item for free to customize the user's avatar.
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "获取";

	/// <summary>
	/// Key: "Action.GetMore"
	/// A call to action for the user to buy more clothes from the Catalog page. This could improve how their avatar looks.
	/// English String: "Get More"
	/// </summary>
	public override string ActionGetMore => "获取更多";

	/// <summary>
	/// Key: "Action.OpenRobloxApp"
	/// English String: "Open Roblox App"
	/// </summary>
	public override string ActionOpenRobloxApp => "打开 Roblox App";

	/// <summary>
	/// Key: "Action.Redraw"
	/// Redraw the avatar on the screen
	/// English String: "Redraw"
	/// </summary>
	public override string ActionRedraw => "重绘";

	/// <summary>
	/// Key: "Action.Rename"
	/// English String: "Rename"
	/// </summary>
	public override string ActionRename => "重命名";

	/// <summary>
	/// Key: "Action.RenameOutfit"
	/// Button to rename outfit
	/// English String: "Rename"
	/// </summary>
	public override string ActionRenameOutfit => "重命名";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "保存";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// See all clothing that user can buy
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "查看全部";

	/// <summary>
	/// Key: "Action.ThreeDimensions"
	/// This button allows the user to view their avatar in three dimensions.
	/// English String: "3D"
	/// </summary>
	public override string ActionThreeDimensions => "3D";

	/// <summary>
	/// Key: "Action.TwoDimensions"
	/// This button allows the user to view their avatar in two dimensions.
	/// English String: "2D"
	/// </summary>
	public override string ActionTwoDimensions => "2D";

	/// <summary>
	/// Key: "Action.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionUpdate => "更新";

	/// <summary>
	/// Key: "Action.UserUnderstands"
	/// The user casually responds to the application saying that they understand how to navigate the menu.
	/// English String: "Got it"
	/// </summary>
	public override string ActionUserUnderstands => "明白";

	/// <summary>
	/// Key: "Description.AvatarEditorUpsell"
	/// English String: "To change your look you will need to use the Avatar Editor on the App."
	/// </summary>
	public override string DescriptionAvatarEditorUpsell => "若要更改你的外观，你需要在 App 上使用虚拟形象编辑器。";

	/// <summary>
	/// Key: "Description.CreateNewCostume"
	/// A costume will be created from your avatar's current appearance.
	/// English String: "A costume will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewCostume => "将根据你的虚拟形象的当前外观创建一套装扮。";

	/// <summary>
	/// Key: "Description.CreateNewOutfit"
	/// An outfit will be created from your avatar's current appearance.
	/// English String: "An outfit will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewOutfit => "将根据你的虚拟形象的当前外观创建一套穿搭。";

	/// <summary>
	/// Key: "Description.RenameCostume"
	/// Choose a new name for your costume.
	/// English String: "Choose a new name for your costume."
	/// </summary>
	public override string DescriptionRenameCostume => "为你的装扮选择一个新名称。";

	/// <summary>
	/// Key: "Description.RenameOutfit"
	/// Choose a new name for your outfit.
	/// English String: "Choose a new name for your outfit."
	/// </summary>
	public override string DescriptionRenameOutfit => "为你的穿搭选择一个新名称。";

	/// <summary>
	/// Key: "Heading.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string HeadingAccessories => "饰品";

	/// <summary>
	/// Key: "Heading.AccessoriesChange"
	/// English String: "Accessories Change"
	/// </summary>
	public override string HeadingAccessoriesChange => "配饰更改";

	/// <summary>
	/// Key: "Heading.AdvancedOptions"
	/// English String: "Advanced Options"
	/// </summary>
	public override string HeadingAdvancedOptions => "高级选项";

	/// <summary>
	/// Key: "Heading.All"
	/// All avatar modification types
	/// English String: "All"
	/// </summary>
	public override string HeadingAll => "全部";

	/// <summary>
	/// Key: "Heading.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string HeadingAnimations => "动画";

	/// <summary>
	/// Key: "Heading.Appearance"
	/// English String: "Appearance"
	/// </summary>
	public override string HeadingAppearance => "外观";

	/// <summary>
	/// Key: "Heading.AvatarPageTitle"
	/// Page title for the Avatar page. On this page, the user can modify how they look.
	/// English String: "Avatar Editor"
	/// </summary>
	public override string HeadingAvatarPageTitle => "虚拟形象编辑器";

	/// <summary>
	/// Key: "Heading.Body"
	/// English String: "Body"
	/// </summary>
	public override string HeadingBody => "身体";

	/// <summary>
	/// Key: "Heading.BodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string HeadingBodyParts => "身体部件";

	/// <summary>
	/// Key: "Heading.Clothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingClothing => "服装";

	/// <summary>
	/// Key: "Heading.Costumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Costumes"
	/// </summary>
	public override string HeadingCostumes => "装扮";

	/// <summary>
	/// Key: "Heading.CreateNewCostume"
	/// NOTE: Costume is a more whimsical word choice for outfit. Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Create New Costume"
	/// </summary>
	public override string HeadingCreateNewCostume => "创建新装扮";

	/// <summary>
	/// Key: "Heading.CreateNewOutfit"
	/// English String: "Create New Outfit"
	/// </summary>
	public override string HeadingCreateNewOutfit => "创建新穿搭";

	/// <summary>
	/// Key: "Heading.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string HeadingDelete => "删除";

	/// <summary>
	/// Key: "Heading.DeleteCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Delete Costume"
	/// </summary>
	public override string HeadingDeleteCostume => "删除装扮";

	/// <summary>
	/// Key: "Heading.DeleteOutfit"
	/// English String: "Delete Outfit"
	/// </summary>
	public override string HeadingDeleteOutfit => "删除穿搭";

	/// <summary>
	/// Key: "Heading.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string HeadingEmotes => "动作";

	/// <summary>
	/// Key: "Heading.EquipEmotes"
	/// English String: "Equip Emotes"
	/// </summary>
	public override string HeadingEquipEmotes => "装备动作";

	/// <summary>
	/// Key: "Heading.Outfits"
	/// English String: "Outfits"
	/// </summary>
	public override string HeadingOutfits => "穿搭";

	/// <summary>
	/// Key: "Heading.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string HeadingPackages => "套装";

	/// <summary>
	/// Key: "Heading.Recent"
	/// English String: "Recent"
	/// </summary>
	public override string HeadingRecent => "最近使用";

	/// <summary>
	/// Key: "Heading.Recommended"
	/// See recommended clothing for your avatar
	/// English String: "Recommended"
	/// </summary>
	public override string HeadingRecommended => "推荐";

	/// <summary>
	/// Key: "Heading.RenameCostume"
	/// English String: "Rename Costume"
	/// </summary>
	public override string HeadingRenameCostume => "重命名装扮";

	/// <summary>
	/// Key: "Heading.RenameOutfit"
	/// English String: "Rename Outfit"
	/// </summary>
	public override string HeadingRenameOutfit => "重命名穿搭";

	/// <summary>
	/// Key: "Heading.Scaling"
	/// English String: "Scaling"
	/// </summary>
	public override string HeadingScaling => "比例";

	/// <summary>
	/// Key: "Heading.SkinToneBodyParts"
	/// English String: "Skin Tone by Body Parts"
	/// </summary>
	public override string HeadingSkinToneBodyParts => "按身体部件的肤色";

	/// <summary>
	/// Key: "Heading.Update"
	/// English String: "Update"
	/// </summary>
	public override string HeadingUpdate => "更新";

	/// <summary>
	/// Key: "Heading.UpdateCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Update Costume"
	/// </summary>
	public override string HeadingUpdateCostume => "更新装扮";

	/// <summary>
	/// Key: "Heading.UpdateOutfit"
	/// English String: "Update Outfit"
	/// </summary>
	public override string HeadingUpdateOutfit => "更新穿搭";

	/// <summary>
	/// Key: "Label.All"
	/// All body parts. This label will allow for body parts to change color
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "全部";

	/// <summary>
	/// Key: "Label.AskIfLoadingCorrectly"
	/// Avatar isn't loading correctly?
	/// English String: "Avatar isn't loading correctly?"
	/// </summary>
	public override string LabelAskIfLoadingCorrectly => "虚拟形象未正确加载？";

	/// <summary>
	/// Key: "Label.AssetIDPlaceholder"
	/// This refers to the Asset ID which is a technical word for the Identification Number of an item or asset.
	/// English String: "Asset ID"
	/// </summary>
	public override string LabelAssetIDPlaceholder => "素材 ID";

	/// <summary>
	/// Key: "Label.Back"
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "背面";

	/// <summary>
	/// Key: "Label.BackAccessories"
	/// English String: "Back Accessories"
	/// </summary>
	public override string LabelBackAccessories => "背面配饰";

	/// <summary>
	/// Key: "Label.BodyType"
	/// English String: "Body Type"
	/// </summary>
	public override string LabelBodyType => "体型";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "攀爬";

	/// <summary>
	/// Key: "Label.ClimbAnimations"
	/// English String: "Climb Animations"
	/// </summary>
	public override string LabelClimbAnimations => "攀爬动画";

	/// <summary>
	/// Key: "Label.Clothes"
	/// English String: "Clothes"
	/// </summary>
	public override string LabelClothes => "服装";

	/// <summary>
	/// Key: "Label.Costume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Costume"
	/// </summary>
	public override string LabelCostume => "装扮";

	/// <summary>
	/// Key: "label.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string labelEmotes => "动作";

	/// <summary>
	/// Key: "Label.Equip"
	/// English String: "Equip"
	/// </summary>
	public override string LabelEquip => "装备";

	/// <summary>
	/// Key: "Label.ExploreCatalog"
	/// This text entices users to shop for more things to wear on their avatar
	/// English String: "Explore the catalog to find more clothes!"
	/// </summary>
	public override string LabelExploreCatalog => "探索商店，发现更多！";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "表情";

	/// <summary>
	/// Key: "Label.FaceAccessories"
	/// English String: "Face Accessories"
	/// </summary>
	public override string LabelFaceAccessories => "脸部配饰";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "表情";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "下落";

	/// <summary>
	/// Key: "Label.FallAnimations"
	/// English String: "Fall Animations"
	/// </summary>
	public override string LabelFallAnimations => "下落动画";

	/// <summary>
	/// Key: "Label.Free"
	/// Text label for recommended items
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "免费";

	/// <summary>
	/// Key: "Label.Front"
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "正面";

	/// <summary>
	/// Key: "Label.FrontAccessories"
	/// English String: "Front Accessories"
	/// </summary>
	public override string LabelFrontAccessories => "正面配饰";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "装备";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "发型";

	/// <summary>
	/// Key: "Label.HairAccessories"
	/// English String: "Hair Accessories"
	/// </summary>
	public override string LabelHairAccessories => "发型配饰";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "帽子";

	/// <summary>
	/// Key: "Label.HatAccessories"
	/// English String: "Hat Accessories"
	/// </summary>
	public override string LabelHatAccessories => "帽子配饰";

	/// <summary>
	/// Key: "Label.Head"
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "头部";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "头部";

	/// <summary>
	/// Key: "Label.Height"
	/// English String: "Height"
	/// </summary>
	public override string LabelHeight => "高度";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "闲置";

	/// <summary>
	/// Key: "Label.IdleAnimations"
	/// English String: "Idle Animations"
	/// </summary>
	public override string LabelIdleAnimations => "闲置动画";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "跳跃";

	/// <summary>
	/// Key: "Label.JumpAnimations"
	/// English String: "Jump Animations"
	/// </summary>
	public override string LabelJumpAnimations => "跳跃动画";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "左臂";

	/// <summary>
	/// Key: "Label.LeftArms"
	/// English String: "Left Arms"
	/// </summary>
	public override string LabelLeftArms => "左臂";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "左腿";

	/// <summary>
	/// Key: "Label.LeftLegs"
	/// English String: "Left Legs"
	/// </summary>
	public override string LabelLeftLegs => "左腿";

	/// <summary>
	/// Key: "Label.MyCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "My Costumes"
	/// </summary>
	public override string LabelMyCostumes => "我的装扮";

	/// <summary>
	/// Key: "Label.NamePlaceholderCostume"
	/// English String: "Name your costume"
	/// </summary>
	public override string LabelNamePlaceholderCostume => "命名你的装扮";

	/// <summary>
	/// Key: "Label.NamePlaceholderOutfit"
	/// English String: "Name your outfit"
	/// </summary>
	public override string LabelNamePlaceholderOutfit => "命名你的穿搭";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "颈部";

	/// <summary>
	/// Key: "Label.NeckAccessories"
	/// English String: "Neck Accessories"
	/// </summary>
	public override string LabelNeckAccessories => "颈部配饰";

	/// <summary>
	/// Key: "Label.NoResellers"
	/// Text label for recommended items
	/// English String: "No resellers"
	/// </summary>
	public override string LabelNoResellers => "无人转售";

	/// <summary>
	/// Key: "Label.OffSale"
	/// Text label for recommended items
	/// English String: "Off sale"
	/// </summary>
	public override string LabelOffSale => "非卖品";

	/// <summary>
	/// Key: "Label.Outfit"
	/// English String: "Outfit"
	/// </summary>
	public override string LabelOutfit => "穿搭";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "裤子";

	/// <summary>
	/// Key: "Label.Parts"
	/// English String: "Parts"
	/// </summary>
	public override string LabelParts => "部件";

	/// <summary>
	/// Key: "Label.PresetCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Preset Costumes"
	/// </summary>
	public override string LabelPresetCostumes => "预设装扮";

	/// <summary>
	/// Key: "Label.Proportions"
	/// English String: "Proportions"
	/// </summary>
	public override string LabelProportions => "身材";

	/// <summary>
	/// Key: "Label.RedrawUnavailable"
	/// Avatar redraw is unavailable
	/// English String: "Avatar redraw is unavailable."
	/// </summary>
	public override string LabelRedrawUnavailable => "无法重绘虚拟形象。";

	/// <summary>
	/// Key: "Label.RightArm"
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "右臂";

	/// <summary>
	/// Key: "Label.RightArms"
	/// English String: "Right Arms"
	/// </summary>
	public override string LabelRightArms => "右臂";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "右腿";

	/// <summary>
	/// Key: "Label.RightLegs"
	/// English String: "Right Legs"
	/// </summary>
	public override string LabelRightLegs => "右腿";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "奔跑";

	/// <summary>
	/// Key: "Label.RunAnimations"
	/// English String: "Run Animations"
	/// </summary>
	public override string LabelRunAnimations => "奔跑动画";

	/// <summary>
	/// Key: "Label.Scale"
	/// English String: "Scale"
	/// </summary>
	public override string LabelScale => "比例";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "衬衫";

	/// <summary>
	/// Key: "Label.ShoulderAccessories"
	/// English String: "Shoulder Accessories"
	/// </summary>
	public override string LabelShoulderAccessories => "肩部配饰";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "肩部";

	/// <summary>
	/// Key: "Label.SkinTone"
	/// English String: "Skin Tone"
	/// </summary>
	public override string LabelSkinTone => "肤色";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "游泳";

	/// <summary>
	/// Key: "Label.SwimAnimations"
	/// English String: "Swim Animations"
	/// </summary>
	public override string LabelSwimAnimations => "游泳动画";

	/// <summary>
	/// Key: "Label.SwitchAvatarType"
	/// User is able to increase the number of joints in their avatar from 6 to 15. R15 moves better. See http://roblox.wikia.com/wiki/R15
	/// English String: "Switch between classic R6 avatar and more expressive next generation R15 avatar"
	/// </summary>
	public override string LabelSwitchAvatarType => "在经典 R6 虚拟形象和更具表现力的下一代 R15 虚拟形象之间切换";

	/// <summary>
	/// Key: "Label.Torso"
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "躯干";

	/// <summary>
	/// Key: "Label.Torsos"
	/// English String: "Torsos"
	/// </summary>
	public override string LabelTorsos => "躯干";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "T 恤";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "腰部";

	/// <summary>
	/// Key: "Label.WaistAccessories"
	/// English String: "Waist Accessories"
	/// </summary>
	public override string LabelWaistAccessories => "腰部配饰";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "步行";

	/// <summary>
	/// Key: "Label.WalkAnimations"
	/// English String: "Walk Animations"
	/// </summary>
	public override string LabelWalkAnimations => "步行动画";

	/// <summary>
	/// Key: "Label.Width"
	/// English String: "Width"
	/// </summary>
	public override string LabelWidth => "宽度";

	/// <summary>
	/// Key: "Label.YourEmotes"
	/// English String: "Your Emotes"
	/// </summary>
	public override string LabelYourEmotes => "你的表情";

	/// <summary>
	/// Key: "Message.AccessoriesChange"
	/// English String: "Are you sure you want to override your current look?"
	/// </summary>
	public override string MessageAccessoriesChange => "是否确定要覆盖你的当前外观？";

	/// <summary>
	/// Key: "Message.ChooseEmote"
	/// English String: "Choose an Emote"
	/// </summary>
	public override string MessageChooseEmote => "选择动作";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlot"
	/// English String: "Choose a slot"
	/// </summary>
	public override string MessageChooseEmoteSlot => "选择栏位\n";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlotOrEmote"
	/// English String: "Choose a slot or an Emote"
	/// </summary>
	public override string MessageChooseEmoteSlotOrEmote => "选择栏位或动作";

	/// <summary>
	/// Key: "Message.DefaultClothing"
	/// Encourage user to choose their own clothes.
	/// English String: "Default clothing has been applied to your avatar - wear something from your clothing."
	/// </summary>
	public override string MessageDefaultClothing => "默认服装已应用至你的虚拟形象，请从你的服装中自由选择。";

	/// <summary>
	/// Key: "Message.DeleteThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Are you sure you want to delete this costume?"
	/// </summary>
	public override string MessageDeleteThisCostume => "是否确定要删除此装扮？";

	/// <summary>
	/// Key: "Message.DeleteThisOutfit"
	/// English String: "Are you sure you want to delete this outfit?"
	/// </summary>
	public override string MessageDeleteThisOutfit => "是否确定要删除此穿搭？";

	/// <summary>
	/// Key: "Message.EmotesInstructions"
	/// The instructions describe the navigation flow within the Avatar Editor to equip an emote.
	/// English String: "Go to \"Animations\" &gt; \"Emotes\" &gt; \"Equip Emotes\" to equip an emote."
	/// </summary>
	public override string MessageEmotesInstructions => "前往“动画”>“动作”>“装备动作”以装备动作。";

	/// <summary>
	/// Key: "Message.EmptyAssetList"
	/// User is seeing no assets on this page because they don't have any.
	/// English String: "You don't have any."
	/// </summary>
	public override string MessageEmptyAssetList => "你没有任何素材。";

	/// <summary>
	/// Key: "Message.EmptyListOfCostumes"
	/// The user is viewing an empty list of costumes to choose from. The application tells the user that they can create an costume.
	/// English String: "You don't have any costumes. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfCostumes => "你没有任何装扮。请尝试创建一些！";

	/// <summary>
	/// Key: "Message.EmptyListOfOutfits"
	/// The user is viewing an empty list of outfits to choose from. The application tells the user that they can create an outfit.
	/// English String: "You don't have any outfits. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfOutfits => "你没有任何穿搭。请尝试创建一些穿搭吧！";

	/// <summary>
	/// Key: "Message.EmptyRecentItems"
	/// English String: "You don't have any recent items."
	/// </summary>
	public override string MessageEmptyRecentItems => "你没有任何最近使用过的物品。";

	/// <summary>
	/// Key: "Message.ErrorCreateCostume"
	/// English String: "Unable to create costume, try again later."
	/// </summary>
	public override string MessageErrorCreateCostume => "无法创建装扮，请稍后重试。";

	/// <summary>
	/// Key: "Message.ErrorCreateOutfit"
	/// English String: "Unable to create outfit, try again later."
	/// </summary>
	public override string MessageErrorCreateOutfit => "无法创建穿搭，请稍后重试。";

	/// <summary>
	/// Key: "Message.ErrorDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageErrorDeleteEmote => "无法删除动作。";

	/// <summary>
	/// Key: "Message.ErrorEquipEmote"
	/// English String: "Failed to equip emote, please try again later."
	/// </summary>
	public override string MessageErrorEquipEmote => "无法装备动作，请稍后重试。";

	/// <summary>
	/// Key: "Message.ErrorLoadCostume"
	/// English String: "Failed to load costume."
	/// </summary>
	public override string MessageErrorLoadCostume => "加载装扮失败。";

	/// <summary>
	/// Key: "Message.ErrorLoadEmotes"
	/// English String: "Failed to load emotes."
	/// </summary>
	public override string MessageErrorLoadEmotes => "无法加载动作。";

	/// <summary>
	/// Key: "Message.ErrorLoadOutfits"
	/// English String: "Failed to load outfits."
	/// </summary>
	public override string MessageErrorLoadOutfits => "加载穿搭失败。";

	/// <summary>
	/// Key: "Message.ErrorOutfitName"
	/// English String: "Name can contain letters, numbers, and spaces."
	/// </summary>
	public override string MessageErrorOutfitName => "名称可以包含字母、数字和空格。";

	/// <summary>
	/// Key: "Message.ErrorRenameCostume"
	/// English String: "Failed to rename costume."
	/// </summary>
	public override string MessageErrorRenameCostume => "重命名装扮失败。";

	/// <summary>
	/// Key: "Message.ErrorRenameOutfit"
	/// English String: "Failed to rename outfit."
	/// </summary>
	public override string MessageErrorRenameOutfit => "重命名穿搭失败。";

	/// <summary>
	/// Key: "Message.ErrorUnequipEmote"
	/// English String: "Failed to unequip emote."
	/// </summary>
	public override string MessageErrorUnequipEmote => "无法卸下动作。";

	/// <summary>
	/// Key: "Message.ErrorUpdateCostume"
	/// English String: "Costume update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateCostume => "装扮更新失败，请稍后重试。";

	/// <summary>
	/// Key: "Message.ErrorUpdateEmote"
	/// English String: "Updating emote slot failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateEmote => "无法更新动作栏位，请稍候重试。";

	/// <summary>
	/// Key: "Message.ErrorUpdateOutfit"
	/// English String: "Outfit update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateOutfit => "穿搭更新失败，请稍后重试。";

	/// <summary>
	/// Key: "Message.ErrorUpdateWorn"
	/// There was an error updating items that the user is already wearing.
	/// English String: "Error while updating worn items."
	/// </summary>
	public override string MessageErrorUpdateWorn => "更新已穿戴物品时出错。";

	/// <summary>
	/// Key: "Message.ErrorWearCostume"
	/// English String: "Failed to wear costume."
	/// </summary>
	public override string MessageErrorWearCostume => "完成装扮失败。";

	/// <summary>
	/// Key: "Message.ErrorWearOutfit"
	/// English String: "Failed to wear outfit."
	/// </summary>
	public override string MessageErrorWearOutfit => "完成穿搭失败。";

	/// <summary>
	/// Key: "Message.FailedDeleteCostume"
	/// English String: "Failed to delete costume."
	/// </summary>
	public override string MessageFailedDeleteCostume => "删除装扮失败。";

	/// <summary>
	/// Key: "Message.FailedDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageFailedDeleteEmote => "无法删除动作。";

	/// <summary>
	/// Key: "Message.FailedDeleteOutfit"
	/// English String: "Failed to delete outfit."
	/// </summary>
	public override string MessageFailedDeleteOutfit => "删除穿搭失败。";

	/// <summary>
	/// Key: "Message.FailedLoadAssets"
	/// English String: "Failed to load assets list."
	/// </summary>
	public override string MessageFailedLoadAssets => "加载资产列表失败。";

	/// <summary>
	/// Key: "Message.FailedLoadRecent"
	/// English String: "Failed to load recent items."
	/// </summary>
	public override string MessageFailedLoadRecent => "无法加载最近物品。";

	/// <summary>
	/// Key: "Message.FailedUpdateBodyColor"
	/// English String: "Failed to update skin tone."
	/// </summary>
	public override string MessageFailedUpdateBodyColor => "更新肤色失败。";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedCostume"
	/// The user tried to update a deleted costume.
	/// English String: "The costume you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedCostume => "你尝试更新的装扮已不存在。";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedOutfit"
	/// The user tried to update a deleted outfit.
	/// English String: "The outfit you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedOutfit => "你尝试更新的穿搭已不存在。";

	/// <summary>
	/// Key: "Message.FailedUpdateScales"
	/// English String: "Failed to update scales."
	/// </summary>
	public override string MessageFailedUpdateScales => "更新比例失败。";

	/// <summary>
	/// Key: "Message.FailedUpdateType"
	/// Failed to update the way the user's avatar is rendered.
	/// English String: "Failed to update avatar type."
	/// </summary>
	public override string MessageFailedUpdateType => "更新虚拟形象类型失败。";

	/// <summary>
	/// Key: "Message.FailedWearPackage"
	/// English String: "Failed to wear package."
	/// </summary>
	public override string MessageFailedWearPackage => "穿戴套装失败。";

	/// <summary>
	/// Key: "Message.HatLimitTooltip"
	/// English String: "You can wear up to 3 hats"
	/// </summary>
	public override string MessageHatLimitTooltip => "你最多可戴 3 顶帽子";

	/// <summary>
	/// Key: "Message.InvalidOutfitName"
	/// English String: "Name must be appropriate and less than 200 characters."
	/// </summary>
	public override string MessageInvalidOutfitName => "名称必须适当，且少于 200 个字符。";

	/// <summary>
	/// Key: "Message.Loading"
	/// The user's avatar is loading
	/// English String: "Loading..."
	/// </summary>
	public override string MessageLoading => "正在加载...";

	/// <summary>
	/// Key: "Message.PageUnavailable"
	/// English String: "The avatar page is temporarily unavailable."
	/// </summary>
	public override string MessagePageUnavailable => "虚拟形象页面暂时不可用。";

	/// <summary>
	/// Key: "Message.PresetCostumesDelay"
	/// One-time message that appears to the user first time they visit the Preset Costumes tab. The delay is caused by initial migration.
	/// English String: "Note: We're doing some housekeeping, so it may take a few minutes for all your costumes to appear. Check again in a bit!"
	/// </summary>
	public override string MessagePresetCostumesDelay => "请注意：我们正进行一些维护，你的所有穿搭可能需要几分钟的时间才能显示。请稍后再查看！";

	/// <summary>
	/// Key: "Message.ReachedMaxCostumes"
	/// English String: "You have reached the maximum number of costumes."
	/// </summary>
	public override string MessageReachedMaxCostumes => "你的装扮数量已达上限。";

	/// <summary>
	/// Key: "Message.ReachedMaxOutfits"
	/// English String: "You have reached the maximum number of outfits."
	/// </summary>
	public override string MessageReachedMaxOutfits => "你的穿搭数量已达上限。";

	/// <summary>
	/// Key: "Message.RedirectAvatarSettings"
	/// English String: "You can set Avatar Settings from your Roblox Studio project. In Roblox Studio, go to Home &gt; Game Settings &gt; Avatar"
	/// </summary>
	public override string MessageRedirectAvatarSettings => "你可以在 Roblox Studio 项目中进行虚拟形象设置。在 Roblox Studio 中，前往首页 > 游戏设置 > 虚拟形象";

	/// <summary>
	/// Key: "Message.RedrawFloodchecked"
	/// English String: "You have redrawn your avatar too many times, please try again later."
	/// </summary>
	public override string MessageRedrawFloodchecked => "你重绘虚拟形象的次数过多，请稍后重试。";

	/// <summary>
	/// Key: "Message.RedrawThumbnailFailed"
	/// English String: "Failed to redraw thumbnail."
	/// </summary>
	public override string MessageRedrawThumbnailFailed => "无法重绘缩略图。";

	/// <summary>
	/// Key: "Message.SelectEnableScaling"
	/// R15 is a proper noun
	/// English String: "Select R15 to enable scaling."
	/// </summary>
	public override string MessageSelectEnableScaling => "选择 R15 以启用比例。";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "成功";

	/// <summary>
	/// Key: "Message.SuccessCreateCostume"
	/// English String: "Created costume"
	/// </summary>
	public override string MessageSuccessCreateCostume => "已创建装扮";

	/// <summary>
	/// Key: "Message.SuccessCreateOutfit"
	/// English String: "Created outfit"
	/// </summary>
	public override string MessageSuccessCreateOutfit => "已创建穿搭";

	/// <summary>
	/// Key: "Message.SuccessDeleteCostume"
	/// Deleted costume
	/// English String: "Deleted costume"
	/// </summary>
	public override string MessageSuccessDeleteCostume => "已删除装扮";

	/// <summary>
	/// Key: "Message.SuccessDeleteOutfit"
	/// English String: "Deleted outfit"
	/// </summary>
	public override string MessageSuccessDeleteOutfit => "已删除穿搭";

	/// <summary>
	/// Key: "Message.SuccessEquipEmote"
	/// English String: "Equipped Emote"
	/// </summary>
	public override string MessageSuccessEquipEmote => "动作已装备";

	/// <summary>
	/// Key: "Message.SuccessRenameCostume"
	/// English String: "Renamed costume"
	/// </summary>
	public override string MessageSuccessRenameCostume => "已重命名装扮";

	/// <summary>
	/// Key: "Message.SuccessRenameOutfit"
	/// English String: "Renamed outfit"
	/// </summary>
	public override string MessageSuccessRenameOutfit => "已重命名穿搭";

	/// <summary>
	/// Key: "Message.SuccessSavedAccessories"
	/// English String: "Saved accessories"
	/// </summary>
	public override string MessageSuccessSavedAccessories => "已保存配饰";

	/// <summary>
	/// Key: "Message.SuccessUnequipEmote"
	/// English String: "Unequipped emote"
	/// </summary>
	public override string MessageSuccessUnequipEmote => "已卸下动作";

	/// <summary>
	/// Key: "Message.SuccessUpdatedCostume"
	/// English String: "Updated costume"
	/// </summary>
	public override string MessageSuccessUpdatedCostume => "已更新装扮";

	/// <summary>
	/// Key: "Message.SuccessUpdatedOutfit"
	/// English String: "Updated outfit"
	/// </summary>
	public override string MessageSuccessUpdatedOutfit => "已更新穿搭";

	/// <summary>
	/// Key: "Message.SuccessWoreCostume"
	/// English String: "Successfully wore costume"
	/// </summary>
	public override string MessageSuccessWoreCostume => "已成功完成装扮";

	/// <summary>
	/// Key: "Message.SuccessWoreOutfit"
	/// English String: "Successfully wore outfit"
	/// </summary>
	public override string MessageSuccessWoreOutfit => "已成功完成穿搭";

	/// <summary>
	/// Key: "Message.UpdateThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Do you want to update this costume? This will overwrite the costume with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisCostume => "是否想更新此装扮？这样的话，此装扮将覆盖你虚拟形象的当前外观。";

	/// <summary>
	/// Key: "Message.UpdateThisOutfit"
	/// English String: "Do you want to update this outfit? This will overwrite the outfit with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisOutfit => "是否想更新此穿搭？这样的话，此穿搭将覆盖你虚拟形象的当前外观。";

	/// <summary>
	/// Key: "Message.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string MessageWarning => "警告";

	public AvatarResources_zh_cjv(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdvanced()
	{
		return "高级";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "购买";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "关闭";
	}

	protected override string _GetTemplateForActionCreate()
	{
		return "创建";
	}

	protected override string _GetTemplateForActionCreateNewOutfit()
	{
		return "创建";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "删除";
	}

	protected override string _GetTemplateForActionDone()
	{
		return "完成";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "获取";
	}

	protected override string _GetTemplateForActionGetMore()
	{
		return "获取更多";
	}

	protected override string _GetTemplateForActionOpenRobloxApp()
	{
		return "打开 Roblox App";
	}

	protected override string _GetTemplateForActionRedraw()
	{
		return "重绘";
	}

	protected override string _GetTemplateForActionRename()
	{
		return "重命名";
	}

	protected override string _GetTemplateForActionRenameOutfit()
	{
		return "重命名";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "保存";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "查看全部";
	}

	protected override string _GetTemplateForActionThreeDimensions()
	{
		return "3D";
	}

	protected override string _GetTemplateForActionTwoDimensions()
	{
		return "2D";
	}

	protected override string _GetTemplateForActionUpdate()
	{
		return "更新";
	}

	protected override string _GetTemplateForActionUserUnderstands()
	{
		return "明白";
	}

	protected override string _GetTemplateForDescriptionAvatarEditorUpsell()
	{
		return "若要更改你的外观，你需要在 App 上使用虚拟形象编辑器。";
	}

	protected override string _GetTemplateForDescriptionCreateNewCostume()
	{
		return "将根据你的虚拟形象的当前外观创建一套装扮。";
	}

	protected override string _GetTemplateForDescriptionCreateNewOutfit()
	{
		return "将根据你的虚拟形象的当前外观创建一套穿搭。";
	}

	protected override string _GetTemplateForDescriptionRenameCostume()
	{
		return "为你的装扮选择一个新名称。";
	}

	protected override string _GetTemplateForDescriptionRenameOutfit()
	{
		return "为你的穿搭选择一个新名称。";
	}

	protected override string _GetTemplateForHeadingAccessories()
	{
		return "饰品";
	}

	protected override string _GetTemplateForHeadingAccessoriesChange()
	{
		return "配饰更改";
	}

	protected override string _GetTemplateForHeadingAdvancedOptions()
	{
		return "高级选项";
	}

	protected override string _GetTemplateForHeadingAll()
	{
		return "全部";
	}

	protected override string _GetTemplateForHeadingAnimations()
	{
		return "动画";
	}

	protected override string _GetTemplateForHeadingAppearance()
	{
		return "外观";
	}

	protected override string _GetTemplateForHeadingAvatarPageTitle()
	{
		return "虚拟形象编辑器";
	}

	protected override string _GetTemplateForHeadingBody()
	{
		return "身体";
	}

	protected override string _GetTemplateForHeadingBodyParts()
	{
		return "身体部件";
	}

	protected override string _GetTemplateForHeadingClothing()
	{
		return "服装";
	}

	protected override string _GetTemplateForHeadingCostumes()
	{
		return "装扮";
	}

	protected override string _GetTemplateForHeadingCreateNewCostume()
	{
		return "创建新装扮";
	}

	protected override string _GetTemplateForHeadingCreateNewOutfit()
	{
		return "创建新穿搭";
	}

	protected override string _GetTemplateForHeadingDelete()
	{
		return "删除";
	}

	protected override string _GetTemplateForHeadingDeleteCostume()
	{
		return "删除装扮";
	}

	protected override string _GetTemplateForHeadingDeleteOutfit()
	{
		return "删除穿搭";
	}

	protected override string _GetTemplateForHeadingEmotes()
	{
		return "动作";
	}

	protected override string _GetTemplateForHeadingEquipEmotes()
	{
		return "装备动作";
	}

	protected override string _GetTemplateForHeadingOutfits()
	{
		return "穿搭";
	}

	protected override string _GetTemplateForHeadingPackages()
	{
		return "套装";
	}

	protected override string _GetTemplateForHeadingRecent()
	{
		return "最近使用";
	}

	protected override string _GetTemplateForHeadingRecommended()
	{
		return "推荐";
	}

	protected override string _GetTemplateForHeadingRenameCostume()
	{
		return "重命名装扮";
	}

	protected override string _GetTemplateForHeadingRenameOutfit()
	{
		return "重命名穿搭";
	}

	protected override string _GetTemplateForHeadingScaling()
	{
		return "比例";
	}

	protected override string _GetTemplateForHeadingSkinToneBodyParts()
	{
		return "按身体部件的肤色";
	}

	protected override string _GetTemplateForHeadingUpdate()
	{
		return "更新";
	}

	protected override string _GetTemplateForHeadingUpdateCostume()
	{
		return "更新装扮";
	}

	protected override string _GetTemplateForHeadingUpdateOutfit()
	{
		return "更新穿搭";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "全部";
	}

	protected override string _GetTemplateForLabelAskIfLoadingCorrectly()
	{
		return "虚拟形象未正确加载？";
	}

	protected override string _GetTemplateForLabelAssetIDPlaceholder()
	{
		return "素材 ID";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "背面";
	}

	protected override string _GetTemplateForLabelBackAccessories()
	{
		return "背面配饰";
	}

	protected override string _GetTemplateForLabelBodyType()
	{
		return "体型";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "攀爬";
	}

	protected override string _GetTemplateForLabelClimbAnimations()
	{
		return "攀爬动画";
	}

	protected override string _GetTemplateForLabelClothes()
	{
		return "服装";
	}

	protected override string _GetTemplateForLabelCostume()
	{
		return "装扮";
	}

	/// <summary>
	/// Key: "Label.DirectionsForPackagePlacement"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Packages have been moved to Costumes. Check {startBold}Costumes{rightArrow}Preset Costumes{endBold}"
	/// </summary>
	public override string LabelDirectionsForPackagePlacement(string startBold, string rightArrow, string endBold)
	{
		return $"套装已被移至装扮。请查看{startBold}装扮{rightArrow}预设装扮{endBold}";
	}

	protected override string _GetTemplateForLabelDirectionsForPackagePlacement()
	{
		return "套装已被移至装扮。请查看{startBold}装扮{rightArrow}预设装扮{endBold}";
	}

	/// <summary>
	/// Key: "Label.DirectionsForScalingOptions"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Scaling options are available under Body category. Check {startBold}Body{rightArrow}Scale{endBold}"
	/// </summary>
	public override string LabelDirectionsForScalingOptions(string startBold, string rightArrow, string endBold)
	{
		return $"“身体”类别中可使用比例选项。查看{startBold}身体{rightArrow}比例{endBold}";
	}

	protected override string _GetTemplateForLabelDirectionsForScalingOptions()
	{
		return "“身体”类别中可使用比例选项。查看{startBold}身体{rightArrow}比例{endBold}";
	}

	protected override string _GetTemplateForlabelEmotes()
	{
		return "动作";
	}

	protected override string _GetTemplateForLabelEquip()
	{
		return "装备";
	}

	protected override string _GetTemplateForLabelExploreCatalog()
	{
		return "探索商店，发现更多！";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "表情";
	}

	protected override string _GetTemplateForLabelFaceAccessories()
	{
		return "脸部配饰";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "表情";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "下落";
	}

	protected override string _GetTemplateForLabelFallAnimations()
	{
		return "下落动画";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "免费";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "正面";
	}

	protected override string _GetTemplateForLabelFrontAccessories()
	{
		return "正面配饰";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "装备";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "发型";
	}

	protected override string _GetTemplateForLabelHairAccessories()
	{
		return "发型配饰";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "帽子";
	}

	protected override string _GetTemplateForLabelHatAccessories()
	{
		return "帽子配饰";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "头部";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "头部";
	}

	protected override string _GetTemplateForLabelHeight()
	{
		return "高度";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "闲置";
	}

	protected override string _GetTemplateForLabelIdleAnimations()
	{
		return "闲置动画";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "跳跃";
	}

	protected override string _GetTemplateForLabelJumpAnimations()
	{
		return "跳跃动画";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "左臂";
	}

	protected override string _GetTemplateForLabelLeftArms()
	{
		return "左臂";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "左腿";
	}

	protected override string _GetTemplateForLabelLeftLegs()
	{
		return "左腿";
	}

	protected override string _GetTemplateForLabelMyCostumes()
	{
		return "我的装扮";
	}

	protected override string _GetTemplateForLabelNamePlaceholderCostume()
	{
		return "命名你的装扮";
	}

	protected override string _GetTemplateForLabelNamePlaceholderOutfit()
	{
		return "命名你的穿搭";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "颈部";
	}

	protected override string _GetTemplateForLabelNeckAccessories()
	{
		return "颈部配饰";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "无人转售";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "非卖品";
	}

	protected override string _GetTemplateForLabelOutfit()
	{
		return "穿搭";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "裤子";
	}

	protected override string _GetTemplateForLabelParts()
	{
		return "部件";
	}

	protected override string _GetTemplateForLabelPresetCostumes()
	{
		return "预设装扮";
	}

	protected override string _GetTemplateForLabelProportions()
	{
		return "身材";
	}

	protected override string _GetTemplateForLabelRedrawUnavailable()
	{
		return "无法重绘虚拟形象。";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "右臂";
	}

	protected override string _GetTemplateForLabelRightArms()
	{
		return "右臂";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "右腿";
	}

	protected override string _GetTemplateForLabelRightLegs()
	{
		return "右腿";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "奔跑";
	}

	protected override string _GetTemplateForLabelRunAnimations()
	{
		return "奔跑动画";
	}

	protected override string _GetTemplateForLabelScale()
	{
		return "比例";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "衬衫";
	}

	protected override string _GetTemplateForLabelShoulderAccessories()
	{
		return "肩部配饰";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "肩部";
	}

	protected override string _GetTemplateForLabelSkinTone()
	{
		return "肤色";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "游泳";
	}

	protected override string _GetTemplateForLabelSwimAnimations()
	{
		return "游泳动画";
	}

	protected override string _GetTemplateForLabelSwitchAvatarType()
	{
		return "在经典 R6 虚拟形象和更具表现力的下一代 R15 虚拟形象之间切换";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "躯干";
	}

	protected override string _GetTemplateForLabelTorsos()
	{
		return "躯干";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "T 恤";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "腰部";
	}

	protected override string _GetTemplateForLabelWaistAccessories()
	{
		return "腰部配饰";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "步行";
	}

	protected override string _GetTemplateForLabelWalkAnimations()
	{
		return "步行动画";
	}

	protected override string _GetTemplateForLabelWidth()
	{
		return "宽度";
	}

	protected override string _GetTemplateForLabelYourEmotes()
	{
		return "你的表情";
	}

	protected override string _GetTemplateForMessageAccessoriesChange()
	{
		return "是否确定要覆盖你的当前外观？";
	}

	protected override string _GetTemplateForMessageChooseEmote()
	{
		return "选择动作";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlot()
	{
		return "选择栏位\n";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlotOrEmote()
	{
		return "选择栏位或动作";
	}

	protected override string _GetTemplateForMessageDefaultClothing()
	{
		return "默认服装已应用至你的虚拟形象，请从你的服装中自由选择。";
	}

	/// <summary>
	/// Key: "Message.DeleteOutfit"
	/// English String: "Are you sure you want to delete this {outfitType}?"
	/// </summary>
	public override string MessageDeleteOutfit(string outfitType)
	{
		return $"是否确定要删除此{outfitType}？";
	}

	protected override string _GetTemplateForMessageDeleteOutfit()
	{
		return "是否确定要删除此{outfitType}？";
	}

	protected override string _GetTemplateForMessageDeleteThisCostume()
	{
		return "是否确定要删除此装扮？";
	}

	protected override string _GetTemplateForMessageDeleteThisOutfit()
	{
		return "是否确定要删除此穿搭？";
	}

	protected override string _GetTemplateForMessageEmotesInstructions()
	{
		return "前往“动画”>“动作”>“装备动作”以装备动作。";
	}

	protected override string _GetTemplateForMessageEmptyAssetList()
	{
		return "你没有任何素材。";
	}

	/// <summary>
	/// Key: "Message.EmptyListForItem"
	/// The user tries to load a list of some item but they see nothing because they don't own anything of that type.
	/// English String: "You don't have this item: {itemType}"
	/// </summary>
	public override string MessageEmptyListForItem(string itemType)
	{
		return $"你没有此物品：{itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListForItem()
	{
		return "你没有此物品：{itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListOfCostumes()
	{
		return "你没有任何装扮。请尝试创建一些！";
	}

	protected override string _GetTemplateForMessageEmptyListOfOutfits()
	{
		return "你没有任何穿搭。请尝试创建一些穿搭吧！";
	}

	protected override string _GetTemplateForMessageEmptyRecentItems()
	{
		return "你没有任何最近使用过的物品。";
	}

	protected override string _GetTemplateForMessageErrorCreateCostume()
	{
		return "无法创建装扮，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorCreateOutfit()
	{
		return "无法创建穿搭，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorDeleteEmote()
	{
		return "无法删除动作。";
	}

	protected override string _GetTemplateForMessageErrorEquipEmote()
	{
		return "无法装备动作，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorLoadCostume()
	{
		return "加载装扮失败。";
	}

	protected override string _GetTemplateForMessageErrorLoadEmotes()
	{
		return "无法加载动作。";
	}

	protected override string _GetTemplateForMessageErrorLoadOutfits()
	{
		return "加载穿搭失败。";
	}

	protected override string _GetTemplateForMessageErrorOutfitName()
	{
		return "名称可以包含字母、数字和空格。";
	}

	protected override string _GetTemplateForMessageErrorRenameCostume()
	{
		return "重命名装扮失败。";
	}

	protected override string _GetTemplateForMessageErrorRenameOutfit()
	{
		return "重命名穿搭失败。";
	}

	protected override string _GetTemplateForMessageErrorUnequipEmote()
	{
		return "无法卸下动作。";
	}

	protected override string _GetTemplateForMessageErrorUpdateCostume()
	{
		return "装扮更新失败，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorUpdateEmote()
	{
		return "无法更新动作栏位，请稍候重试。";
	}

	protected override string _GetTemplateForMessageErrorUpdateOutfit()
	{
		return "穿搭更新失败，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorUpdateWorn()
	{
		return "更新已穿戴物品时出错。";
	}

	protected override string _GetTemplateForMessageErrorWearCostume()
	{
		return "完成装扮失败。";
	}

	protected override string _GetTemplateForMessageErrorWearOutfit()
	{
		return "完成穿搭失败。";
	}

	protected override string _GetTemplateForMessageFailedDeleteCostume()
	{
		return "删除装扮失败。";
	}

	protected override string _GetTemplateForMessageFailedDeleteEmote()
	{
		return "无法删除动作。";
	}

	protected override string _GetTemplateForMessageFailedDeleteOutfit()
	{
		return "删除穿搭失败。";
	}

	protected override string _GetTemplateForMessageFailedLoadAssets()
	{
		return "加载资产列表失败。";
	}

	protected override string _GetTemplateForMessageFailedLoadRecent()
	{
		return "无法加载最近物品。";
	}

	protected override string _GetTemplateForMessageFailedUpdateBodyColor()
	{
		return "更新肤色失败。";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedCostume()
	{
		return "你尝试更新的装扮已不存在。";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedOutfit()
	{
		return "你尝试更新的穿搭已不存在。";
	}

	protected override string _GetTemplateForMessageFailedUpdateScales()
	{
		return "更新比例失败。";
	}

	protected override string _GetTemplateForMessageFailedUpdateType()
	{
		return "更新虚拟形象类型失败。";
	}

	protected override string _GetTemplateForMessageFailedWearPackage()
	{
		return "穿戴套装失败。";
	}

	protected override string _GetTemplateForMessageHatLimitTooltip()
	{
		return "你最多可戴 3 顶帽子";
	}

	protected override string _GetTemplateForMessageInvalidOutfitName()
	{
		return "名称必须适当，且少于 200 个字符。";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "正在加载...";
	}

	/// <summary>
	/// Key: "Message.MissingItemsFromOutfit"
	/// User cannot wear an outfit because they are missing or have deleted some of the items that were part of that outfit.
	/// English String: "Number of items that you don't own in this outfit: {number}"
	/// </summary>
	public override string MessageMissingItemsFromOutfit(string number)
	{
		return $"此穿搭中你缺少的物品数目：{number}";
	}

	protected override string _GetTemplateForMessageMissingItemsFromOutfit()
	{
		return "此穿搭中你缺少的物品数目：{number}";
	}

	protected override string _GetTemplateForMessagePageUnavailable()
	{
		return "虚拟形象页面暂时不可用。";
	}

	protected override string _GetTemplateForMessagePresetCostumesDelay()
	{
		return "请注意：我们正进行一些维护，你的所有穿搭可能需要几分钟的时间才能显示。请稍后再查看！";
	}

	protected override string _GetTemplateForMessageReachedMaxCostumes()
	{
		return "你的装扮数量已达上限。";
	}

	protected override string _GetTemplateForMessageReachedMaxOutfits()
	{
		return "你的穿搭数量已达上限。";
	}

	protected override string _GetTemplateForMessageRedirectAvatarSettings()
	{
		return "你可以在 Roblox Studio 项目中进行虚拟形象设置。在 Roblox Studio 中，前往首页 > 游戏设置 > 虚拟形象";
	}

	protected override string _GetTemplateForMessageRedrawFloodchecked()
	{
		return "你重绘虚拟形象的次数过多，请稍后重试。";
	}

	protected override string _GetTemplateForMessageRedrawThumbnailFailed()
	{
		return "无法重绘缩略图。";
	}

	protected override string _GetTemplateForMessageSelectEnableScaling()
	{
		return "选择 R15 以启用比例。";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForMessageSuccessCreateCostume()
	{
		return "已创建装扮";
	}

	protected override string _GetTemplateForMessageSuccessCreateOutfit()
	{
		return "已创建穿搭";
	}

	protected override string _GetTemplateForMessageSuccessDeleteCostume()
	{
		return "已删除装扮";
	}

	protected override string _GetTemplateForMessageSuccessDeleteOutfit()
	{
		return "已删除穿搭";
	}

	protected override string _GetTemplateForMessageSuccessEquipEmote()
	{
		return "动作已装备";
	}

	protected override string _GetTemplateForMessageSuccessRenameCostume()
	{
		return "已重命名装扮";
	}

	protected override string _GetTemplateForMessageSuccessRenameOutfit()
	{
		return "已重命名穿搭";
	}

	protected override string _GetTemplateForMessageSuccessSavedAccessories()
	{
		return "已保存配饰";
	}

	protected override string _GetTemplateForMessageSuccessUnequipEmote()
	{
		return "已卸下动作";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedCostume()
	{
		return "已更新装扮";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedOutfit()
	{
		return "已更新穿搭";
	}

	protected override string _GetTemplateForMessageSuccessWoreCostume()
	{
		return "已成功完成装扮";
	}

	protected override string _GetTemplateForMessageSuccessWoreOutfit()
	{
		return "已成功完成穿搭";
	}

	/// <summary>
	/// Key: "Message.UpdateOutfit"
	/// English String: "Do you want to update this {outfitType1}? This will overwrite the {outfitType2} with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateOutfit(string outfitType1, string outfitType2)
	{
		return $"是否要更新此{outfitType1}？这样的话，{outfitType1}将会覆盖你虚拟形象当前外观的{outfitType2}。";
	}

	protected override string _GetTemplateForMessageUpdateOutfit()
	{
		return "是否要更新此{outfitType1}？这样的话，{outfitType1}将会覆盖你虚拟形象当前外观的{outfitType2}。";
	}

	protected override string _GetTemplateForMessageUpdateThisCostume()
	{
		return "是否想更新此装扮？这样的话，此装扮将覆盖你虚拟形象的当前外观。";
	}

	protected override string _GetTemplateForMessageUpdateThisOutfit()
	{
		return "是否想更新此穿搭？这样的话，此穿搭将覆盖你虚拟形象的当前外观。";
	}

	protected override string _GetTemplateForMessageWarning()
	{
		return "警告";
	}
}
