namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AvatarResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AvatarResources_ko_kr : AvatarResources_en_us, IAvatarResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Advanced"
	/// Click Advanced to get the advanced options
	/// English String: "Advanced"
	/// </summary>
	public override string ActionAdvanced => "고급";

	/// <summary>
	/// Key: "Action.Buy"
	/// Button used to buy an item to customize the user's avatar.
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "구매";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "취소";

	/// <summary>
	/// Key: "Action.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "닫기";

	/// <summary>
	/// Key: "Action.Create"
	/// English String: "Create"
	/// </summary>
	public override string ActionCreate => "만들기";

	/// <summary>
	/// Key: "Action.CreateNewOutfit"
	/// Button to create new outfit
	/// English String: "Create"
	/// </summary>
	public override string ActionCreateNewOutfit => "만들기";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "삭제";

	/// <summary>
	/// Key: "Action.Done"
	/// English String: "Done"
	/// </summary>
	public override string ActionDone => "완료";

	/// <summary>
	/// Key: "Action.Get"
	/// Button used to buy get an item for free to customize the user's avatar.
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "획득";

	/// <summary>
	/// Key: "Action.GetMore"
	/// A call to action for the user to buy more clothes from the Catalog page. This could improve how their avatar looks.
	/// English String: "Get More"
	/// </summary>
	public override string ActionGetMore => "더 보기";

	/// <summary>
	/// Key: "Action.OpenRobloxApp"
	/// English String: "Open Roblox App"
	/// </summary>
	public override string ActionOpenRobloxApp => "Roblox 앱 열기";

	/// <summary>
	/// Key: "Action.Redraw"
	/// Redraw the avatar on the screen
	/// English String: "Redraw"
	/// </summary>
	public override string ActionRedraw => "다시 그리기";

	/// <summary>
	/// Key: "Action.Rename"
	/// English String: "Rename"
	/// </summary>
	public override string ActionRename => "이름 변경";

	/// <summary>
	/// Key: "Action.RenameOutfit"
	/// Button to rename outfit
	/// English String: "Rename"
	/// </summary>
	public override string ActionRenameOutfit => "이름 변경";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "저장";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// See all clothing that user can buy
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "전체 보기";

	/// <summary>
	/// Key: "Action.ThreeDimensions"
	/// This button allows the user to view their avatar in three dimensions.
	/// English String: "3D"
	/// </summary>
	public override string ActionThreeDimensions => "3D";

	/// <summary>
	/// Key: "Action.TwoDimensions"
	/// This button allows the user to view their avatar in two dimensions.
	/// English String: "2D"
	/// </summary>
	public override string ActionTwoDimensions => "2D";

	/// <summary>
	/// Key: "Action.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionUpdate => "업데이트";

	/// <summary>
	/// Key: "Action.UserUnderstands"
	/// The user casually responds to the application saying that they understand how to navigate the menu.
	/// English String: "Got it"
	/// </summary>
	public override string ActionUserUnderstands => "확인";

	/// <summary>
	/// Key: "Description.AvatarEditorUpsell"
	/// English String: "To change your look you will need to use the Avatar Editor on the App."
	/// </summary>
	public override string DescriptionAvatarEditorUpsell => "겉모습을 바꾸려면 앱에 포함된 아바타 편집기를 사용해야 해요.";

	/// <summary>
	/// Key: "Description.CreateNewCostume"
	/// A costume will be created from your avatar's current appearance.
	/// English String: "A costume will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewCostume => "코스튬은 아바타의 현재 모습을 기반으로 만들어집니다.";

	/// <summary>
	/// Key: "Description.CreateNewOutfit"
	/// An outfit will be created from your avatar's current appearance.
	/// English String: "An outfit will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewOutfit => "코스튬은 아바타의 현재 모습을 기반으로 만들어집니다.";

	/// <summary>
	/// Key: "Description.RenameCostume"
	/// Choose a new name for your costume.
	/// English String: "Choose a new name for your costume."
	/// </summary>
	public override string DescriptionRenameCostume => "코스튬에 새 이름을 지어주세요.";

	/// <summary>
	/// Key: "Description.RenameOutfit"
	/// Choose a new name for your outfit.
	/// English String: "Choose a new name for your outfit."
	/// </summary>
	public override string DescriptionRenameOutfit => "코스튬에 새 이름을 지어주세요.";

	/// <summary>
	/// Key: "Heading.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string HeadingAccessories => "장신구";

	/// <summary>
	/// Key: "Heading.AccessoriesChange"
	/// English String: "Accessories Change"
	/// </summary>
	public override string HeadingAccessoriesChange => "장신구 변경";

	/// <summary>
	/// Key: "Heading.AdvancedOptions"
	/// English String: "Advanced Options"
	/// </summary>
	public override string HeadingAdvancedOptions => "고급 옵션";

	/// <summary>
	/// Key: "Heading.All"
	/// All avatar modification types
	/// English String: "All"
	/// </summary>
	public override string HeadingAll => "전체";

	/// <summary>
	/// Key: "Heading.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string HeadingAnimations => "애니메이션";

	/// <summary>
	/// Key: "Heading.Appearance"
	/// English String: "Appearance"
	/// </summary>
	public override string HeadingAppearance => "모습";

	/// <summary>
	/// Key: "Heading.AvatarPageTitle"
	/// Page title for the Avatar page. On this page, the user can modify how they look.
	/// English String: "Avatar Editor"
	/// </summary>
	public override string HeadingAvatarPageTitle => "아바타 편집기";

	/// <summary>
	/// Key: "Heading.Body"
	/// English String: "Body"
	/// </summary>
	public override string HeadingBody => "신체";

	/// <summary>
	/// Key: "Heading.BodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string HeadingBodyParts => "신체 부위";

	/// <summary>
	/// Key: "Heading.Clothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingClothing => "복장";

	/// <summary>
	/// Key: "Heading.Costumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Costumes"
	/// </summary>
	public override string HeadingCostumes => "코스튬";

	/// <summary>
	/// Key: "Heading.CreateNewCostume"
	/// NOTE: Costume is a more whimsical word choice for outfit. Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Create New Costume"
	/// </summary>
	public override string HeadingCreateNewCostume => "새 코스튬 만들기";

	/// <summary>
	/// Key: "Heading.CreateNewOutfit"
	/// English String: "Create New Outfit"
	/// </summary>
	public override string HeadingCreateNewOutfit => "새 코스튬 만들기";

	/// <summary>
	/// Key: "Heading.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string HeadingDelete => "삭제";

	/// <summary>
	/// Key: "Heading.DeleteCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Delete Costume"
	/// </summary>
	public override string HeadingDeleteCostume => "코스튬 삭제";

	/// <summary>
	/// Key: "Heading.DeleteOutfit"
	/// English String: "Delete Outfit"
	/// </summary>
	public override string HeadingDeleteOutfit => "코스튬 삭제";

	/// <summary>
	/// Key: "Heading.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string HeadingEmotes => "감정 표현";

	/// <summary>
	/// Key: "Heading.EquipEmotes"
	/// English String: "Equip Emotes"
	/// </summary>
	public override string HeadingEquipEmotes => "감정 표현 장착";

	/// <summary>
	/// Key: "Heading.Outfits"
	/// English String: "Outfits"
	/// </summary>
	public override string HeadingOutfits => "코스튬";

	/// <summary>
	/// Key: "Heading.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string HeadingPackages => "패키지";

	/// <summary>
	/// Key: "Heading.Recent"
	/// English String: "Recent"
	/// </summary>
	public override string HeadingRecent => "최근";

	/// <summary>
	/// Key: "Heading.Recommended"
	/// See recommended clothing for your avatar
	/// English String: "Recommended"
	/// </summary>
	public override string HeadingRecommended => "추천";

	/// <summary>
	/// Key: "Heading.RenameCostume"
	/// English String: "Rename Costume"
	/// </summary>
	public override string HeadingRenameCostume => "코스튬 이름 변경";

	/// <summary>
	/// Key: "Heading.RenameOutfit"
	/// English String: "Rename Outfit"
	/// </summary>
	public override string HeadingRenameOutfit => "코스튬 이름 변경";

	/// <summary>
	/// Key: "Heading.Scaling"
	/// English String: "Scaling"
	/// </summary>
	public override string HeadingScaling => "크기 변경";

	/// <summary>
	/// Key: "Heading.SkinToneBodyParts"
	/// English String: "Skin Tone by Body Parts"
	/// </summary>
	public override string HeadingSkinToneBodyParts => "신체 부위별 피부 색깔";

	/// <summary>
	/// Key: "Heading.Update"
	/// English String: "Update"
	/// </summary>
	public override string HeadingUpdate => "업데이트";

	/// <summary>
	/// Key: "Heading.UpdateCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Update Costume"
	/// </summary>
	public override string HeadingUpdateCostume => "코스튬 업데이트";

	/// <summary>
	/// Key: "Heading.UpdateOutfit"
	/// English String: "Update Outfit"
	/// </summary>
	public override string HeadingUpdateOutfit => "코스튬 업데이트";

	/// <summary>
	/// Key: "Label.All"
	/// All body parts. This label will allow for body parts to change color
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "전체";

	/// <summary>
	/// Key: "Label.AskIfLoadingCorrectly"
	/// Avatar isn't loading correctly?
	/// English String: "Avatar isn't loading correctly?"
	/// </summary>
	public override string LabelAskIfLoadingCorrectly => "아바타를 제대로 불러올 수 없다구요?";

	/// <summary>
	/// Key: "Label.AssetIDPlaceholder"
	/// This refers to the Asset ID which is a technical word for the Identification Number of an item or asset.
	/// English String: "Asset ID"
	/// </summary>
	public override string LabelAssetIDPlaceholder => "애셋 ID";

	/// <summary>
	/// Key: "Label.Back"
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "등";

	/// <summary>
	/// Key: "Label.BackAccessories"
	/// English String: "Back Accessories"
	/// </summary>
	public override string LabelBackAccessories => "등 장신구";

	/// <summary>
	/// Key: "Label.BodyType"
	/// English String: "Body Type"
	/// </summary>
	public override string LabelBodyType => "체형";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "오르기";

	/// <summary>
	/// Key: "Label.ClimbAnimations"
	/// English String: "Climb Animations"
	/// </summary>
	public override string LabelClimbAnimations => "오르기 애니메이션";

	/// <summary>
	/// Key: "Label.Clothes"
	/// English String: "Clothes"
	/// </summary>
	public override string LabelClothes => "복장";

	/// <summary>
	/// Key: "Label.Costume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Costume"
	/// </summary>
	public override string LabelCostume => "코스튬";

	/// <summary>
	/// Key: "label.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string labelEmotes => "감정 표현";

	/// <summary>
	/// Key: "Label.Equip"
	/// English String: "Equip"
	/// </summary>
	public override string LabelEquip => "장착";

	/// <summary>
	/// Key: "Label.ExploreCatalog"
	/// This text entices users to shop for more things to wear on their avatar
	/// English String: "Explore the catalog to find more clothes!"
	/// </summary>
	public override string LabelExploreCatalog => "카탈로그에서 더 많은 복장을 찾아보세요!";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "얼굴";

	/// <summary>
	/// Key: "Label.FaceAccessories"
	/// English String: "Face Accessories"
	/// </summary>
	public override string LabelFaceAccessories => "얼굴 장신구";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "얼굴";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "낙하";

	/// <summary>
	/// Key: "Label.FallAnimations"
	/// English String: "Fall Animations"
	/// </summary>
	public override string LabelFallAnimations => "낙하 애니메이션";

	/// <summary>
	/// Key: "Label.Free"
	/// Text label for recommended items
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "무료";

	/// <summary>
	/// Key: "Label.Front"
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "가슴";

	/// <summary>
	/// Key: "Label.FrontAccessories"
	/// English String: "Front Accessories"
	/// </summary>
	public override string LabelFrontAccessories => "가슴 장신구";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "장비";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "헤어";

	/// <summary>
	/// Key: "Label.HairAccessories"
	/// English String: "Hair Accessories"
	/// </summary>
	public override string LabelHairAccessories => "헤어 장신구";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "모자";

	/// <summary>
	/// Key: "Label.HatAccessories"
	/// English String: "Hat Accessories"
	/// </summary>
	public override string LabelHatAccessories => "모자 장신구";

	/// <summary>
	/// Key: "Label.Head"
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "머리";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "머리";

	/// <summary>
	/// Key: "Label.Height"
	/// English String: "Height"
	/// </summary>
	public override string LabelHeight => "높이";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "대기";

	/// <summary>
	/// Key: "Label.IdleAnimations"
	/// English String: "Idle Animations"
	/// </summary>
	public override string LabelIdleAnimations => "대기 애니메이션";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "점프";

	/// <summary>
	/// Key: "Label.JumpAnimations"
	/// English String: "Jump Animations"
	/// </summary>
	public override string LabelJumpAnimations => "점프 애니메이션";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "왼팔";

	/// <summary>
	/// Key: "Label.LeftArms"
	/// English String: "Left Arms"
	/// </summary>
	public override string LabelLeftArms => "왼팔";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "왼 다리";

	/// <summary>
	/// Key: "Label.LeftLegs"
	/// English String: "Left Legs"
	/// </summary>
	public override string LabelLeftLegs => "왼 다리";

	/// <summary>
	/// Key: "Label.MyCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "My Costumes"
	/// </summary>
	public override string LabelMyCostumes => "내 코스튬";

	/// <summary>
	/// Key: "Label.NamePlaceholderCostume"
	/// English String: "Name your costume"
	/// </summary>
	public override string LabelNamePlaceholderCostume => "새 코스튬 이름 입력";

	/// <summary>
	/// Key: "Label.NamePlaceholderOutfit"
	/// English String: "Name your outfit"
	/// </summary>
	public override string LabelNamePlaceholderOutfit => "새 코스튬 이름 입력";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "목";

	/// <summary>
	/// Key: "Label.NeckAccessories"
	/// English String: "Neck Accessories"
	/// </summary>
	public override string LabelNeckAccessories => "목 장신구";

	/// <summary>
	/// Key: "Label.NoResellers"
	/// Text label for recommended items
	/// English String: "No resellers"
	/// </summary>
	public override string LabelNoResellers => "재판매자 없음";

	/// <summary>
	/// Key: "Label.OffSale"
	/// Text label for recommended items
	/// English String: "Off sale"
	/// </summary>
	public override string LabelOffSale => "판매 중단";

	/// <summary>
	/// Key: "Label.Outfit"
	/// English String: "Outfit"
	/// </summary>
	public override string LabelOutfit => "코스튬";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "바지";

	/// <summary>
	/// Key: "Label.Parts"
	/// English String: "Parts"
	/// </summary>
	public override string LabelParts => "부위";

	/// <summary>
	/// Key: "Label.PresetCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Preset Costumes"
	/// </summary>
	public override string LabelPresetCostumes => "기본 코스튬";

	/// <summary>
	/// Key: "Label.Proportions"
	/// English String: "Proportions"
	/// </summary>
	public override string LabelProportions => "비율";

	/// <summary>
	/// Key: "Label.RedrawUnavailable"
	/// Avatar redraw is unavailable
	/// English String: "Avatar redraw is unavailable."
	/// </summary>
	public override string LabelRedrawUnavailable => "아바타 다시 그리기를 사용할 수 없습니다.";

	/// <summary>
	/// Key: "Label.RightArm"
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "오른팔";

	/// <summary>
	/// Key: "Label.RightArms"
	/// English String: "Right Arms"
	/// </summary>
	public override string LabelRightArms => "오른팔";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "오른 다리";

	/// <summary>
	/// Key: "Label.RightLegs"
	/// English String: "Right Legs"
	/// </summary>
	public override string LabelRightLegs => "오른 다리";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "달리기";

	/// <summary>
	/// Key: "Label.RunAnimations"
	/// English String: "Run Animations"
	/// </summary>
	public override string LabelRunAnimations => "달리기 애니메이션";

	/// <summary>
	/// Key: "Label.Scale"
	/// English String: "Scale"
	/// </summary>
	public override string LabelScale => "크기";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "셔츠";

	/// <summary>
	/// Key: "Label.ShoulderAccessories"
	/// English String: "Shoulder Accessories"
	/// </summary>
	public override string LabelShoulderAccessories => "어깨 장신구";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "어깨";

	/// <summary>
	/// Key: "Label.SkinTone"
	/// English String: "Skin Tone"
	/// </summary>
	public override string LabelSkinTone => "피부 색깔";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "수영";

	/// <summary>
	/// Key: "Label.SwimAnimations"
	/// English String: "Swim Animations"
	/// </summary>
	public override string LabelSwimAnimations => "수영 애니메이션";

	/// <summary>
	/// Key: "Label.SwitchAvatarType"
	/// User is able to increase the number of joints in their avatar from 6 to 15. R15 moves better. See http://roblox.wikia.com/wiki/R15
	/// English String: "Switch between classic R6 avatar and more expressive next generation R15 avatar"
	/// </summary>
	public override string LabelSwitchAvatarType => "기존 R6 아바타와 더욱 정교한 차세대 R15 아바타간 전환이 가능합니다";

	/// <summary>
	/// Key: "Label.Torso"
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "몸통";

	/// <summary>
	/// Key: "Label.Torsos"
	/// English String: "Torsos"
	/// </summary>
	public override string LabelTorsos => "몸통";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "티셔츠";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "허리";

	/// <summary>
	/// Key: "Label.WaistAccessories"
	/// English String: "Waist Accessories"
	/// </summary>
	public override string LabelWaistAccessories => "허리 장신구";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "걷기";

	/// <summary>
	/// Key: "Label.WalkAnimations"
	/// English String: "Walk Animations"
	/// </summary>
	public override string LabelWalkAnimations => "걷기 애니메이션";

	/// <summary>
	/// Key: "Label.Width"
	/// English String: "Width"
	/// </summary>
	public override string LabelWidth => "넓이";

	/// <summary>
	/// Key: "Label.YourEmotes"
	/// English String: "Your Emotes"
	/// </summary>
	public override string LabelYourEmotes => "플레이어의 감정 표현";

	/// <summary>
	/// Key: "Message.AccessoriesChange"
	/// English String: "Are you sure you want to override your current look?"
	/// </summary>
	public override string MessageAccessoriesChange => "현재 모습을 덮어쓸까요?";

	/// <summary>
	/// Key: "Message.ChooseEmote"
	/// English String: "Choose an Emote"
	/// </summary>
	public override string MessageChooseEmote => "감정 표현을 선택하세요";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlot"
	/// English String: "Choose a slot"
	/// </summary>
	public override string MessageChooseEmoteSlot => "슬롯을 선택하세요";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlotOrEmote"
	/// English String: "Choose a slot or an Emote"
	/// </summary>
	public override string MessageChooseEmoteSlotOrEmote => "슬롯이나 감정 표현을 선택하세요";

	/// <summary>
	/// Key: "Message.DefaultClothing"
	/// Encourage user to choose their own clothes.
	/// English String: "Default clothing has been applied to your avatar - wear something from your clothing."
	/// </summary>
	public override string MessageDefaultClothing => "기본 복장이 아바타에 적용되었어요. 보유한 복장에서 선택하여 착용해보세요.";

	/// <summary>
	/// Key: "Message.DeleteThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Are you sure you want to delete this costume?"
	/// </summary>
	public override string MessageDeleteThisCostume => "본 코스튬을 정말 삭제하시겠습니까?";

	/// <summary>
	/// Key: "Message.DeleteThisOutfit"
	/// English String: "Are you sure you want to delete this outfit?"
	/// </summary>
	public override string MessageDeleteThisOutfit => "본 코스튬을 정말 삭제하시겠습니까?";

	/// <summary>
	/// Key: "Message.EmotesInstructions"
	/// The instructions describe the navigation flow within the Avatar Editor to equip an emote.
	/// English String: "Go to \"Animations\" &gt; \"Emotes\" &gt; \"Equip Emotes\" to equip an emote."
	/// </summary>
	public override string MessageEmotesInstructions => "감정 표현을 장착하려면 다음으로 이동하세요. '애니메이션 > 감정 표현 > 감정 표현 장착'";

	/// <summary>
	/// Key: "Message.EmptyAssetList"
	/// User is seeing no assets on this page because they don't have any.
	/// English String: "You don't have any."
	/// </summary>
	public override string MessageEmptyAssetList => "보유한 애셋이 없습니다.";

	/// <summary>
	/// Key: "Message.EmptyListOfCostumes"
	/// The user is viewing an empty list of costumes to choose from. The application tells the user that they can create an costume.
	/// English String: "You don't have any costumes. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfCostumes => "보유한 코스튬이 없습니다. 직접 만들어보세요!";

	/// <summary>
	/// Key: "Message.EmptyListOfOutfits"
	/// The user is viewing an empty list of outfits to choose from. The application tells the user that they can create an outfit.
	/// English String: "You don't have any outfits. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfOutfits => "보유한 코스튬 없음. 새로 만들어보세요!";

	/// <summary>
	/// Key: "Message.EmptyRecentItems"
	/// English String: "You don't have any recent items."
	/// </summary>
	public override string MessageEmptyRecentItems => "최근 아이템이 없습니다.";

	/// <summary>
	/// Key: "Message.ErrorCreateCostume"
	/// English String: "Unable to create costume, try again later."
	/// </summary>
	public override string MessageErrorCreateCostume => "코스튬 만들기 실패. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorCreateOutfit"
	/// English String: "Unable to create outfit, try again later."
	/// </summary>
	public override string MessageErrorCreateOutfit => "코스튬 만들기 불가. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageErrorDeleteEmote => "감정 표현을 삭제하지 못했어요.";

	/// <summary>
	/// Key: "Message.ErrorEquipEmote"
	/// English String: "Failed to equip emote, please try again later."
	/// </summary>
	public override string MessageErrorEquipEmote => "감정 표현 장착 실패. 잠시 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorLoadCostume"
	/// English String: "Failed to load costume."
	/// </summary>
	public override string MessageErrorLoadCostume => "코스튬 불러오기 실패.";

	/// <summary>
	/// Key: "Message.ErrorLoadEmotes"
	/// English String: "Failed to load emotes."
	/// </summary>
	public override string MessageErrorLoadEmotes => "감정 표현을 불러오지 못했어요.";

	/// <summary>
	/// Key: "Message.ErrorLoadOutfits"
	/// English String: "Failed to load outfits."
	/// </summary>
	public override string MessageErrorLoadOutfits => "코스튬 불러오기 실패.";

	/// <summary>
	/// Key: "Message.ErrorOutfitName"
	/// English String: "Name can contain letters, numbers, and spaces."
	/// </summary>
	public override string MessageErrorOutfitName => "이름은 알파벳, 숫자, 빈 칸을 조합하여 만들 수 있어요.";

	/// <summary>
	/// Key: "Message.ErrorRenameCostume"
	/// English String: "Failed to rename costume."
	/// </summary>
	public override string MessageErrorRenameCostume => "코스튬 이름 변경 실패.";

	/// <summary>
	/// Key: "Message.ErrorRenameOutfit"
	/// English String: "Failed to rename outfit."
	/// </summary>
	public override string MessageErrorRenameOutfit => "코스튬 이름 변경 실패.";

	/// <summary>
	/// Key: "Message.ErrorUnequipEmote"
	/// English String: "Failed to unequip emote."
	/// </summary>
	public override string MessageErrorUnequipEmote => "감정 표현 장착 해제에 실패했습니다.";

	/// <summary>
	/// Key: "Message.ErrorUpdateCostume"
	/// English String: "Costume update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateCostume => "코스튬 업데이트 실패. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorUpdateEmote"
	/// English String: "Updating emote slot failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateEmote => "감정 표현 슬롯 업데이트 실패. 잠시 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorUpdateOutfit"
	/// English String: "Outfit update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateOutfit => "코스튬 업데이트 실패. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.ErrorUpdateWorn"
	/// There was an error updating items that the user is already wearing.
	/// English String: "Error while updating worn items."
	/// </summary>
	public override string MessageErrorUpdateWorn => "착용 아이템 업데이트 중 오류가 발생했어요.";

	/// <summary>
	/// Key: "Message.ErrorWearCostume"
	/// English String: "Failed to wear costume."
	/// </summary>
	public override string MessageErrorWearCostume => "코스튬 착용 실패.";

	/// <summary>
	/// Key: "Message.ErrorWearOutfit"
	/// English String: "Failed to wear outfit."
	/// </summary>
	public override string MessageErrorWearOutfit => "코스튬 착용 실패.";

	/// <summary>
	/// Key: "Message.FailedDeleteCostume"
	/// English String: "Failed to delete costume."
	/// </summary>
	public override string MessageFailedDeleteCostume => "코스튬 삭제 실패.";

	/// <summary>
	/// Key: "Message.FailedDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageFailedDeleteEmote => "감정 표현을 삭제하지 못했어요.";

	/// <summary>
	/// Key: "Message.FailedDeleteOutfit"
	/// English String: "Failed to delete outfit."
	/// </summary>
	public override string MessageFailedDeleteOutfit => "코스튬 삭제 실패.";

	/// <summary>
	/// Key: "Message.FailedLoadAssets"
	/// English String: "Failed to load assets list."
	/// </summary>
	public override string MessageFailedLoadAssets => "애셋 목록 불러오기 실패.";

	/// <summary>
	/// Key: "Message.FailedLoadRecent"
	/// English String: "Failed to load recent items."
	/// </summary>
	public override string MessageFailedLoadRecent => "최근 아이템 불러오기 실패.";

	/// <summary>
	/// Key: "Message.FailedUpdateBodyColor"
	/// English String: "Failed to update skin tone."
	/// </summary>
	public override string MessageFailedUpdateBodyColor => "피부 색깔 업데이트 실패.";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedCostume"
	/// The user tried to update a deleted costume.
	/// English String: "The costume you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedCostume => "업데이트하려는 코스튬이 더 이상 존재하지 않습니다.";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedOutfit"
	/// The user tried to update a deleted outfit.
	/// English String: "The outfit you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedOutfit => "업데이트하려는 코스튬이 더 이상 존재하지 않습니다.";

	/// <summary>
	/// Key: "Message.FailedUpdateScales"
	/// English String: "Failed to update scales."
	/// </summary>
	public override string MessageFailedUpdateScales => "크기 업데이트 실패.";

	/// <summary>
	/// Key: "Message.FailedUpdateType"
	/// Failed to update the way the user's avatar is rendered.
	/// English String: "Failed to update avatar type."
	/// </summary>
	public override string MessageFailedUpdateType => "아바타 유형 업데이트 실패.";

	/// <summary>
	/// Key: "Message.FailedWearPackage"
	/// English String: "Failed to wear package."
	/// </summary>
	public override string MessageFailedWearPackage => "패키지 착용 실패.";

	/// <summary>
	/// Key: "Message.HatLimitTooltip"
	/// English String: "You can wear up to 3 hats"
	/// </summary>
	public override string MessageHatLimitTooltip => "모자는 최대 3개까지 착용할 수 있어요";

	/// <summary>
	/// Key: "Message.InvalidOutfitName"
	/// English String: "Name must be appropriate and less than 200 characters."
	/// </summary>
	public override string MessageInvalidOutfitName => "이름은 적절한 용어를 사용하여야 하며 200자 이내로 입력하셔야 합니다.";

	/// <summary>
	/// Key: "Message.Loading"
	/// The user's avatar is loading
	/// English String: "Loading..."
	/// </summary>
	public override string MessageLoading => "로드 중...";

	/// <summary>
	/// Key: "Message.PageUnavailable"
	/// English String: "The avatar page is temporarily unavailable."
	/// </summary>
	public override string MessagePageUnavailable => "지금은 아바타 페이지를 이용할 수 없습니다.";

	/// <summary>
	/// Key: "Message.PresetCostumesDelay"
	/// One-time message that appears to the user first time they visit the Preset Costumes tab. The delay is caused by initial migration.
	/// English String: "Note: We're doing some housekeeping, so it may take a few minutes for all your costumes to appear. Check again in a bit!"
	/// </summary>
	public override string MessagePresetCostumesDelay => "알림: 점검 중. 코스튬이 나타나는 데 몇 분 정도 소요될 수 있습니다. 잠시 후 다시 확인하세요.";

	/// <summary>
	/// Key: "Message.ReachedMaxCostumes"
	/// English String: "You have reached the maximum number of costumes."
	/// </summary>
	public override string MessageReachedMaxCostumes => "보유한 코스튬 수가 한도에 도달했어요.";

	/// <summary>
	/// Key: "Message.ReachedMaxOutfits"
	/// English String: "You have reached the maximum number of outfits."
	/// </summary>
	public override string MessageReachedMaxOutfits => "보유한 코스튬 수가 한도에 도달했어요.";

	/// <summary>
	/// Key: "Message.RedirectAvatarSettings"
	/// English String: "You can set Avatar Settings from your Roblox Studio project. In Roblox Studio, go to Home &gt; Game Settings &gt; Avatar"
	/// </summary>
	public override string MessageRedirectAvatarSettings => "Roblox Studio 프로젝트에서 아바타 설정을 지정할 수 있어요. Roblox Studio에서 홈 > 게임 설정 > 아바타로 이동하세요.";

	/// <summary>
	/// Key: "Message.RedrawFloodchecked"
	/// English String: "You have redrawn your avatar too many times, please try again later."
	/// </summary>
	public override string MessageRedrawFloodchecked => "허용된 아바타 다시 그리기를 횟수를 초과했습니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.RedrawThumbnailFailed"
	/// English String: "Failed to redraw thumbnail."
	/// </summary>
	public override string MessageRedrawThumbnailFailed => "섬네일 다시 그리기 실패.";

	/// <summary>
	/// Key: "Message.SelectEnableScaling"
	/// R15 is a proper noun
	/// English String: "Select R15 to enable scaling."
	/// </summary>
	public override string MessageSelectEnableScaling => "크기를 변경하려면 R15를 선택하세요.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "완료";

	/// <summary>
	/// Key: "Message.SuccessCreateCostume"
	/// English String: "Created costume"
	/// </summary>
	public override string MessageSuccessCreateCostume => "코스튬 만들기 완료";

	/// <summary>
	/// Key: "Message.SuccessCreateOutfit"
	/// English String: "Created outfit"
	/// </summary>
	public override string MessageSuccessCreateOutfit => "코스튬 만들기 완료";

	/// <summary>
	/// Key: "Message.SuccessDeleteCostume"
	/// Deleted costume
	/// English String: "Deleted costume"
	/// </summary>
	public override string MessageSuccessDeleteCostume => "코스튬 삭제 완료";

	/// <summary>
	/// Key: "Message.SuccessDeleteOutfit"
	/// English String: "Deleted outfit"
	/// </summary>
	public override string MessageSuccessDeleteOutfit => "코스튬 삭제 완료";

	/// <summary>
	/// Key: "Message.SuccessEquipEmote"
	/// English String: "Equipped Emote"
	/// </summary>
	public override string MessageSuccessEquipEmote => "장착된 감정 표현";

	/// <summary>
	/// Key: "Message.SuccessRenameCostume"
	/// English String: "Renamed costume"
	/// </summary>
	public override string MessageSuccessRenameCostume => "코스튬 이름 변경 완료";

	/// <summary>
	/// Key: "Message.SuccessRenameOutfit"
	/// English String: "Renamed outfit"
	/// </summary>
	public override string MessageSuccessRenameOutfit => "코스튬 이름 변경 완료";

	/// <summary>
	/// Key: "Message.SuccessSavedAccessories"
	/// English String: "Saved accessories"
	/// </summary>
	public override string MessageSuccessSavedAccessories => "저장한 장신구";

	/// <summary>
	/// Key: "Message.SuccessUnequipEmote"
	/// English String: "Unequipped emote"
	/// </summary>
	public override string MessageSuccessUnequipEmote => "장착 해제된 감정 표현";

	/// <summary>
	/// Key: "Message.SuccessUpdatedCostume"
	/// English String: "Updated costume"
	/// </summary>
	public override string MessageSuccessUpdatedCostume => "코스튬 업데이트 완료";

	/// <summary>
	/// Key: "Message.SuccessUpdatedOutfit"
	/// English String: "Updated outfit"
	/// </summary>
	public override string MessageSuccessUpdatedOutfit => "코스튬 업데이트 완료";

	/// <summary>
	/// Key: "Message.SuccessWoreCostume"
	/// English String: "Successfully wore costume"
	/// </summary>
	public override string MessageSuccessWoreCostume => "코스튬 착용 완료";

	/// <summary>
	/// Key: "Message.SuccessWoreOutfit"
	/// English String: "Successfully wore outfit"
	/// </summary>
	public override string MessageSuccessWoreOutfit => "코스튬 착용 완료";

	/// <summary>
	/// Key: "Message.UpdateThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Do you want to update this costume? This will overwrite the costume with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisCostume => "본 코스튬으로 업데이트하시겠어요? 아바타의 현재 모습을 덮어쓰게 됩니다.";

	/// <summary>
	/// Key: "Message.UpdateThisOutfit"
	/// English String: "Do you want to update this outfit? This will overwrite the outfit with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisOutfit => "본 코스튬으로 업데이트하시겠어요? 아바타의 현재 모습을 덮어쓰게 됩니다.";

	/// <summary>
	/// Key: "Message.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string MessageWarning => "주의";

	public AvatarResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdvanced()
	{
		return "고급";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "구매";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "취소";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "닫기";
	}

	protected override string _GetTemplateForActionCreate()
	{
		return "만들기";
	}

	protected override string _GetTemplateForActionCreateNewOutfit()
	{
		return "만들기";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "삭제";
	}

	protected override string _GetTemplateForActionDone()
	{
		return "완료";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "획득";
	}

	protected override string _GetTemplateForActionGetMore()
	{
		return "더 보기";
	}

	protected override string _GetTemplateForActionOpenRobloxApp()
	{
		return "Roblox 앱 열기";
	}

	protected override string _GetTemplateForActionRedraw()
	{
		return "다시 그리기";
	}

	protected override string _GetTemplateForActionRename()
	{
		return "이름 변경";
	}

	protected override string _GetTemplateForActionRenameOutfit()
	{
		return "이름 변경";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "저장";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "전체 보기";
	}

	protected override string _GetTemplateForActionThreeDimensions()
	{
		return "3D";
	}

	protected override string _GetTemplateForActionTwoDimensions()
	{
		return "2D";
	}

	protected override string _GetTemplateForActionUpdate()
	{
		return "업데이트";
	}

	protected override string _GetTemplateForActionUserUnderstands()
	{
		return "확인";
	}

	protected override string _GetTemplateForDescriptionAvatarEditorUpsell()
	{
		return "겉모습을 바꾸려면 앱에 포함된 아바타 편집기를 사용해야 해요.";
	}

	protected override string _GetTemplateForDescriptionCreateNewCostume()
	{
		return "코스튬은 아바타의 현재 모습을 기반으로 만들어집니다.";
	}

	protected override string _GetTemplateForDescriptionCreateNewOutfit()
	{
		return "코스튬은 아바타의 현재 모습을 기반으로 만들어집니다.";
	}

	protected override string _GetTemplateForDescriptionRenameCostume()
	{
		return "코스튬에 새 이름을 지어주세요.";
	}

	protected override string _GetTemplateForDescriptionRenameOutfit()
	{
		return "코스튬에 새 이름을 지어주세요.";
	}

	protected override string _GetTemplateForHeadingAccessories()
	{
		return "장신구";
	}

	protected override string _GetTemplateForHeadingAccessoriesChange()
	{
		return "장신구 변경";
	}

	protected override string _GetTemplateForHeadingAdvancedOptions()
	{
		return "고급 옵션";
	}

	protected override string _GetTemplateForHeadingAll()
	{
		return "전체";
	}

	protected override string _GetTemplateForHeadingAnimations()
	{
		return "애니메이션";
	}

	protected override string _GetTemplateForHeadingAppearance()
	{
		return "모습";
	}

	protected override string _GetTemplateForHeadingAvatarPageTitle()
	{
		return "아바타 편집기";
	}

	protected override string _GetTemplateForHeadingBody()
	{
		return "신체";
	}

	protected override string _GetTemplateForHeadingBodyParts()
	{
		return "신체 부위";
	}

	protected override string _GetTemplateForHeadingClothing()
	{
		return "복장";
	}

	protected override string _GetTemplateForHeadingCostumes()
	{
		return "코스튬";
	}

	protected override string _GetTemplateForHeadingCreateNewCostume()
	{
		return "새 코스튬 만들기";
	}

	protected override string _GetTemplateForHeadingCreateNewOutfit()
	{
		return "새 코스튬 만들기";
	}

	protected override string _GetTemplateForHeadingDelete()
	{
		return "삭제";
	}

	protected override string _GetTemplateForHeadingDeleteCostume()
	{
		return "코스튬 삭제";
	}

	protected override string _GetTemplateForHeadingDeleteOutfit()
	{
		return "코스튬 삭제";
	}

	protected override string _GetTemplateForHeadingEmotes()
	{
		return "감정 표현";
	}

	protected override string _GetTemplateForHeadingEquipEmotes()
	{
		return "감정 표현 장착";
	}

	protected override string _GetTemplateForHeadingOutfits()
	{
		return "코스튬";
	}

	protected override string _GetTemplateForHeadingPackages()
	{
		return "패키지";
	}

	protected override string _GetTemplateForHeadingRecent()
	{
		return "최근";
	}

	protected override string _GetTemplateForHeadingRecommended()
	{
		return "추천";
	}

	protected override string _GetTemplateForHeadingRenameCostume()
	{
		return "코스튬 이름 변경";
	}

	protected override string _GetTemplateForHeadingRenameOutfit()
	{
		return "코스튬 이름 변경";
	}

	protected override string _GetTemplateForHeadingScaling()
	{
		return "크기 변경";
	}

	protected override string _GetTemplateForHeadingSkinToneBodyParts()
	{
		return "신체 부위별 피부 색깔";
	}

	protected override string _GetTemplateForHeadingUpdate()
	{
		return "업데이트";
	}

	protected override string _GetTemplateForHeadingUpdateCostume()
	{
		return "코스튬 업데이트";
	}

	protected override string _GetTemplateForHeadingUpdateOutfit()
	{
		return "코스튬 업데이트";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "전체";
	}

	protected override string _GetTemplateForLabelAskIfLoadingCorrectly()
	{
		return "아바타를 제대로 불러올 수 없다구요?";
	}

	protected override string _GetTemplateForLabelAssetIDPlaceholder()
	{
		return "애셋 ID";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "등";
	}

	protected override string _GetTemplateForLabelBackAccessories()
	{
		return "등 장신구";
	}

	protected override string _GetTemplateForLabelBodyType()
	{
		return "체형";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "오르기";
	}

	protected override string _GetTemplateForLabelClimbAnimations()
	{
		return "오르기 애니메이션";
	}

	protected override string _GetTemplateForLabelClothes()
	{
		return "복장";
	}

	protected override string _GetTemplateForLabelCostume()
	{
		return "코스튬";
	}

	/// <summary>
	/// Key: "Label.DirectionsForPackagePlacement"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Packages have been moved to Costumes. Check {startBold}Costumes{rightArrow}Preset Costumes{endBold}"
	/// </summary>
	public override string LabelDirectionsForPackagePlacement(string startBold, string rightArrow, string endBold)
	{
		return $"패키지가 코스튬으로 이동했습니다. {startBold}코스튬{rightArrow}기본 코스튬{endBold}을 확인하세요.";
	}

	protected override string _GetTemplateForLabelDirectionsForPackagePlacement()
	{
		return "패키지가 코스튬으로 이동했습니다. {startBold}코스튬{rightArrow}기본 코스튬{endBold}을 확인하세요.";
	}

	/// <summary>
	/// Key: "Label.DirectionsForScalingOptions"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Scaling options are available under Body category. Check {startBold}Body{rightArrow}Scale{endBold}"
	/// </summary>
	public override string LabelDirectionsForScalingOptions(string startBold, string rightArrow, string endBold)
	{
		return $"신체 카테고리에 있는 아이템은 크기를 조절할 수 있어요. {startBold}신체{rightArrow}크기{endBold}를 확인해보세요.";
	}

	protected override string _GetTemplateForLabelDirectionsForScalingOptions()
	{
		return "신체 카테고리에 있는 아이템은 크기를 조절할 수 있어요. {startBold}신체{rightArrow}크기{endBold}를 확인해보세요.";
	}

	protected override string _GetTemplateForlabelEmotes()
	{
		return "감정 표현";
	}

	protected override string _GetTemplateForLabelEquip()
	{
		return "장착";
	}

	protected override string _GetTemplateForLabelExploreCatalog()
	{
		return "카탈로그에서 더 많은 복장을 찾아보세요!";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "얼굴";
	}

	protected override string _GetTemplateForLabelFaceAccessories()
	{
		return "얼굴 장신구";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "얼굴";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "낙하";
	}

	protected override string _GetTemplateForLabelFallAnimations()
	{
		return "낙하 애니메이션";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "무료";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "가슴";
	}

	protected override string _GetTemplateForLabelFrontAccessories()
	{
		return "가슴 장신구";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "장비";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "헤어";
	}

	protected override string _GetTemplateForLabelHairAccessories()
	{
		return "헤어 장신구";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "모자";
	}

	protected override string _GetTemplateForLabelHatAccessories()
	{
		return "모자 장신구";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "머리";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "머리";
	}

	protected override string _GetTemplateForLabelHeight()
	{
		return "높이";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "대기";
	}

	protected override string _GetTemplateForLabelIdleAnimations()
	{
		return "대기 애니메이션";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "점프";
	}

	protected override string _GetTemplateForLabelJumpAnimations()
	{
		return "점프 애니메이션";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "왼팔";
	}

	protected override string _GetTemplateForLabelLeftArms()
	{
		return "왼팔";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "왼 다리";
	}

	protected override string _GetTemplateForLabelLeftLegs()
	{
		return "왼 다리";
	}

	protected override string _GetTemplateForLabelMyCostumes()
	{
		return "내 코스튬";
	}

	protected override string _GetTemplateForLabelNamePlaceholderCostume()
	{
		return "새 코스튬 이름 입력";
	}

	protected override string _GetTemplateForLabelNamePlaceholderOutfit()
	{
		return "새 코스튬 이름 입력";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "목";
	}

	protected override string _GetTemplateForLabelNeckAccessories()
	{
		return "목 장신구";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "재판매자 없음";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "판매 중단";
	}

	protected override string _GetTemplateForLabelOutfit()
	{
		return "코스튬";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "바지";
	}

	protected override string _GetTemplateForLabelParts()
	{
		return "부위";
	}

	protected override string _GetTemplateForLabelPresetCostumes()
	{
		return "기본 코스튬";
	}

	protected override string _GetTemplateForLabelProportions()
	{
		return "비율";
	}

	protected override string _GetTemplateForLabelRedrawUnavailable()
	{
		return "아바타 다시 그리기를 사용할 수 없습니다.";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "오른팔";
	}

	protected override string _GetTemplateForLabelRightArms()
	{
		return "오른팔";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "오른 다리";
	}

	protected override string _GetTemplateForLabelRightLegs()
	{
		return "오른 다리";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "달리기";
	}

	protected override string _GetTemplateForLabelRunAnimations()
	{
		return "달리기 애니메이션";
	}

	protected override string _GetTemplateForLabelScale()
	{
		return "크기";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "셔츠";
	}

	protected override string _GetTemplateForLabelShoulderAccessories()
	{
		return "어깨 장신구";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "어깨";
	}

	protected override string _GetTemplateForLabelSkinTone()
	{
		return "피부 색깔";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "수영";
	}

	protected override string _GetTemplateForLabelSwimAnimations()
	{
		return "수영 애니메이션";
	}

	protected override string _GetTemplateForLabelSwitchAvatarType()
	{
		return "기존 R6 아바타와 더욱 정교한 차세대 R15 아바타간 전환이 가능합니다";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "몸통";
	}

	protected override string _GetTemplateForLabelTorsos()
	{
		return "몸통";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "티셔츠";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "허리";
	}

	protected override string _GetTemplateForLabelWaistAccessories()
	{
		return "허리 장신구";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "걷기";
	}

	protected override string _GetTemplateForLabelWalkAnimations()
	{
		return "걷기 애니메이션";
	}

	protected override string _GetTemplateForLabelWidth()
	{
		return "넓이";
	}

	protected override string _GetTemplateForLabelYourEmotes()
	{
		return "플레이어의 감정 표현";
	}

	protected override string _GetTemplateForMessageAccessoriesChange()
	{
		return "현재 모습을 덮어쓸까요?";
	}

	protected override string _GetTemplateForMessageChooseEmote()
	{
		return "감정 표현을 선택하세요";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlot()
	{
		return "슬롯을 선택하세요";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlotOrEmote()
	{
		return "슬롯이나 감정 표현을 선택하세요";
	}

	protected override string _GetTemplateForMessageDefaultClothing()
	{
		return "기본 복장이 아바타에 적용되었어요. 보유한 복장에서 선택하여 착용해보세요.";
	}

	/// <summary>
	/// Key: "Message.DeleteOutfit"
	/// English String: "Are you sure you want to delete this {outfitType}?"
	/// </summary>
	public override string MessageDeleteOutfit(string outfitType)
	{
		return $"본 {outfitType}을(를) 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForMessageDeleteOutfit()
	{
		return "본 {outfitType}을(를) 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForMessageDeleteThisCostume()
	{
		return "본 코스튬을 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForMessageDeleteThisOutfit()
	{
		return "본 코스튬을 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForMessageEmotesInstructions()
	{
		return "감정 표현을 장착하려면 다음으로 이동하세요. '애니메이션 > 감정 표현 > 감정 표현 장착'";
	}

	protected override string _GetTemplateForMessageEmptyAssetList()
	{
		return "보유한 애셋이 없습니다.";
	}

	/// <summary>
	/// Key: "Message.EmptyListForItem"
	/// The user tries to load a list of some item but they see nothing because they don't own anything of that type.
	/// English String: "You don't have this item: {itemType}"
	/// </summary>
	public override string MessageEmptyListForItem(string itemType)
	{
		return $"보유한 {itemType}이(가) 없습니다";
	}

	protected override string _GetTemplateForMessageEmptyListForItem()
	{
		return "보유한 {itemType}이(가) 없습니다";
	}

	protected override string _GetTemplateForMessageEmptyListOfCostumes()
	{
		return "보유한 코스튬이 없습니다. 직접 만들어보세요!";
	}

	protected override string _GetTemplateForMessageEmptyListOfOutfits()
	{
		return "보유한 코스튬 없음. 새로 만들어보세요!";
	}

	protected override string _GetTemplateForMessageEmptyRecentItems()
	{
		return "최근 아이템이 없습니다.";
	}

	protected override string _GetTemplateForMessageErrorCreateCostume()
	{
		return "코스튬 만들기 실패. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorCreateOutfit()
	{
		return "코스튬 만들기 불가. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorDeleteEmote()
	{
		return "감정 표현을 삭제하지 못했어요.";
	}

	protected override string _GetTemplateForMessageErrorEquipEmote()
	{
		return "감정 표현 장착 실패. 잠시 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorLoadCostume()
	{
		return "코스튬 불러오기 실패.";
	}

	protected override string _GetTemplateForMessageErrorLoadEmotes()
	{
		return "감정 표현을 불러오지 못했어요.";
	}

	protected override string _GetTemplateForMessageErrorLoadOutfits()
	{
		return "코스튬 불러오기 실패.";
	}

	protected override string _GetTemplateForMessageErrorOutfitName()
	{
		return "이름은 알파벳, 숫자, 빈 칸을 조합하여 만들 수 있어요.";
	}

	protected override string _GetTemplateForMessageErrorRenameCostume()
	{
		return "코스튬 이름 변경 실패.";
	}

	protected override string _GetTemplateForMessageErrorRenameOutfit()
	{
		return "코스튬 이름 변경 실패.";
	}

	protected override string _GetTemplateForMessageErrorUnequipEmote()
	{
		return "감정 표현 장착 해제에 실패했습니다.";
	}

	protected override string _GetTemplateForMessageErrorUpdateCostume()
	{
		return "코스튬 업데이트 실패. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorUpdateEmote()
	{
		return "감정 표현 슬롯 업데이트 실패. 잠시 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorUpdateOutfit()
	{
		return "코스튬 업데이트 실패. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorUpdateWorn()
	{
		return "착용 아이템 업데이트 중 오류가 발생했어요.";
	}

	protected override string _GetTemplateForMessageErrorWearCostume()
	{
		return "코스튬 착용 실패.";
	}

	protected override string _GetTemplateForMessageErrorWearOutfit()
	{
		return "코스튬 착용 실패.";
	}

	protected override string _GetTemplateForMessageFailedDeleteCostume()
	{
		return "코스튬 삭제 실패.";
	}

	protected override string _GetTemplateForMessageFailedDeleteEmote()
	{
		return "감정 표현을 삭제하지 못했어요.";
	}

	protected override string _GetTemplateForMessageFailedDeleteOutfit()
	{
		return "코스튬 삭제 실패.";
	}

	protected override string _GetTemplateForMessageFailedLoadAssets()
	{
		return "애셋 목록 불러오기 실패.";
	}

	protected override string _GetTemplateForMessageFailedLoadRecent()
	{
		return "최근 아이템 불러오기 실패.";
	}

	protected override string _GetTemplateForMessageFailedUpdateBodyColor()
	{
		return "피부 색깔 업데이트 실패.";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedCostume()
	{
		return "업데이트하려는 코스튬이 더 이상 존재하지 않습니다.";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedOutfit()
	{
		return "업데이트하려는 코스튬이 더 이상 존재하지 않습니다.";
	}

	protected override string _GetTemplateForMessageFailedUpdateScales()
	{
		return "크기 업데이트 실패.";
	}

	protected override string _GetTemplateForMessageFailedUpdateType()
	{
		return "아바타 유형 업데이트 실패.";
	}

	protected override string _GetTemplateForMessageFailedWearPackage()
	{
		return "패키지 착용 실패.";
	}

	protected override string _GetTemplateForMessageHatLimitTooltip()
	{
		return "모자는 최대 3개까지 착용할 수 있어요";
	}

	protected override string _GetTemplateForMessageInvalidOutfitName()
	{
		return "이름은 적절한 용어를 사용하여야 하며 200자 이내로 입력하셔야 합니다.";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "로드 중...";
	}

	/// <summary>
	/// Key: "Message.MissingItemsFromOutfit"
	/// User cannot wear an outfit because they are missing or have deleted some of the items that were part of that outfit.
	/// English String: "Number of items that you don't own in this outfit: {number}"
	/// </summary>
	public override string MessageMissingItemsFromOutfit(string number)
	{
		return $"본 코스튬에서 소유하지 않은 아이템 수: {number}";
	}

	protected override string _GetTemplateForMessageMissingItemsFromOutfit()
	{
		return "본 코스튬에서 소유하지 않은 아이템 수: {number}";
	}

	protected override string _GetTemplateForMessagePageUnavailable()
	{
		return "지금은 아바타 페이지를 이용할 수 없습니다.";
	}

	protected override string _GetTemplateForMessagePresetCostumesDelay()
	{
		return "알림: 점검 중. 코스튬이 나타나는 데 몇 분 정도 소요될 수 있습니다. 잠시 후 다시 확인하세요.";
	}

	protected override string _GetTemplateForMessageReachedMaxCostumes()
	{
		return "보유한 코스튬 수가 한도에 도달했어요.";
	}

	protected override string _GetTemplateForMessageReachedMaxOutfits()
	{
		return "보유한 코스튬 수가 한도에 도달했어요.";
	}

	protected override string _GetTemplateForMessageRedirectAvatarSettings()
	{
		return "Roblox Studio 프로젝트에서 아바타 설정을 지정할 수 있어요. Roblox Studio에서 홈 > 게임 설정 > 아바타로 이동하세요.";
	}

	protected override string _GetTemplateForMessageRedrawFloodchecked()
	{
		return "허용된 아바타 다시 그리기를 횟수를 초과했습니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageRedrawThumbnailFailed()
	{
		return "섬네일 다시 그리기 실패.";
	}

	protected override string _GetTemplateForMessageSelectEnableScaling()
	{
		return "크기를 변경하려면 R15를 선택하세요.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "완료";
	}

	protected override string _GetTemplateForMessageSuccessCreateCostume()
	{
		return "코스튬 만들기 완료";
	}

	protected override string _GetTemplateForMessageSuccessCreateOutfit()
	{
		return "코스튬 만들기 완료";
	}

	protected override string _GetTemplateForMessageSuccessDeleteCostume()
	{
		return "코스튬 삭제 완료";
	}

	protected override string _GetTemplateForMessageSuccessDeleteOutfit()
	{
		return "코스튬 삭제 완료";
	}

	protected override string _GetTemplateForMessageSuccessEquipEmote()
	{
		return "장착된 감정 표현";
	}

	protected override string _GetTemplateForMessageSuccessRenameCostume()
	{
		return "코스튬 이름 변경 완료";
	}

	protected override string _GetTemplateForMessageSuccessRenameOutfit()
	{
		return "코스튬 이름 변경 완료";
	}

	protected override string _GetTemplateForMessageSuccessSavedAccessories()
	{
		return "저장한 장신구";
	}

	protected override string _GetTemplateForMessageSuccessUnequipEmote()
	{
		return "장착 해제된 감정 표현";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedCostume()
	{
		return "코스튬 업데이트 완료";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedOutfit()
	{
		return "코스튬 업데이트 완료";
	}

	protected override string _GetTemplateForMessageSuccessWoreCostume()
	{
		return "코스튬 착용 완료";
	}

	protected override string _GetTemplateForMessageSuccessWoreOutfit()
	{
		return "코스튬 착용 완료";
	}

	/// <summary>
	/// Key: "Message.UpdateOutfit"
	/// English String: "Do you want to update this {outfitType1}? This will overwrite the {outfitType2} with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateOutfit(string outfitType1, string outfitType2)
	{
		return $"본 {outfitType1}(으)로 업데이트하시겠어요? 아바타의 현재 모습에 적용된 {outfitType2}을(를) 덮어쓰게 됩니다.";
	}

	protected override string _GetTemplateForMessageUpdateOutfit()
	{
		return "본 {outfitType1}(으)로 업데이트하시겠어요? 아바타의 현재 모습에 적용된 {outfitType2}을(를) 덮어쓰게 됩니다.";
	}

	protected override string _GetTemplateForMessageUpdateThisCostume()
	{
		return "본 코스튬으로 업데이트하시겠어요? 아바타의 현재 모습을 덮어쓰게 됩니다.";
	}

	protected override string _GetTemplateForMessageUpdateThisOutfit()
	{
		return "본 코스튬으로 업데이트하시겠어요? 아바타의 현재 모습을 덮어쓰게 됩니다.";
	}

	protected override string _GetTemplateForMessageWarning()
	{
		return "주의";
	}
}
